/* Detect-zoom
 * -----------
 * Cross Browser Zoom and Pixel Ratio Detector
 * Version 1.0.4 | Apr 1 2013
 * dual-licensed under the WTFPL and MIT license
 * Maintained by https://github/tombigel
 * Original developer https://github.com/yonran
 */

//AMD and CommonJS initialization copied from https://github.com/zohararad/audio5js
(function (root, ns, factory) {
    "use strict";

    if (typeof (module) !== 'undefined' && module.exports) { // CommonJS
        module.exports = factory(ns, root);
    } else if (typeof (define) === 'function' && define.amd) { // AMD
        define("factory", function () {
            return factory(ns, root);
        });
    } else {
        root[ns] = factory(ns, root);
    }

}(window, 'detectZoom', function () {

    /**
     * Use devicePixelRatio if supported by the browser
     * @return {Number}
     * @private
     */
    var devicePixelRatio = function () {
        return window.devicePixelRatio || 1;
    };

    /**
     * Fallback function to set default values
     * @return {Object}
     * @private
     */
    var fallback = function () {
        return {
            zoom: 1,
            devicePxPerCssPx: 1
        };
    };
    /**
     * IE 8 and 9: no trick needed!
     * TODO: Test on IE10 and Windows 8 RT
     * @return {Object}
     * @private
     **/
    var ie8 = function () {
        var zoom = Math.round((screen.deviceXDPI / screen.logicalXDPI) * 100) / 100;
        return {
            zoom: zoom,
            devicePxPerCssPx: zoom * devicePixelRatio()
        };
    };

    /**
     * For IE10 we need to change our technique again...
     * thanks https://github.com/stefanvanburen
     * @return {Object}
     * @private
     */
    var ie10 = function () {
        var zoom = Math.round((document.documentElement.offsetHeight / window.innerHeight) * 100) / 100;
        return {
            zoom: zoom,
            devicePxPerCssPx: zoom * devicePixelRatio()
        };
    };

    /**
     * Mobile WebKit
     * the trick: window.innerWIdth is in CSS pixels, while
     * screen.width and screen.height are in system pixels.
     * And there are no scrollbars to mess up the measurement.
     * @return {Object}
     * @private
     */
    var webkitMobile = function () {
        var deviceWidth = (Math.abs(window.orientation) == 90) ? screen.height : screen.width;
        var zoom = deviceWidth / window.innerWidth;
        return {
            zoom: zoom,
            devicePxPerCssPx: zoom * devicePixelRatio()
        };
    };

    /**
     * Desktop Webkit
     * the trick: an element's clientHeight is in CSS pixels, while you can
     * set its line-height in system pixels using font-size and
     * -webkit-text-size-adjust:none.
     * device-pixel-ratio: http://www.webkit.org/blog/55/high-dpi-web-sites/
     *
     * Previous trick (used before http://trac.webkit.org/changeset/100847):
     * documentElement.scrollWidth is in CSS pixels, while
     * document.width was in system pixels. Note that this is the
     * layout width of the document, which is slightly different from viewport
     * because document width does not include scrollbars and might be wider
     * due to big elements.
     * @return {Object}
     * @private
     */
    var webkit = function () {
        var important = function (str) {
            return str.replace(/;/g, " !important;");
        };

        var div = document.createElement('div');
        div.innerHTML = "1<br>2<br>3<br>4<br>5<br>6<br>7<br>8<br>9<br>0";
        div.setAttribute('style', important('font: 100px/1em sans-serif; -webkit-text-size-adjust: none; text-size-adjust: none; height: auto; width: 1em; padding: 0; overflow: visible;'));

        // The container exists so that the div will be laid out in its own flow
        // while not impacting the layout, viewport size, or display of the
        // webpage as a whole.
        // Add !important and relevant CSS rule resets
        // so that other rules cannot affect the results.
        var container = document.createElement('div');
        container.setAttribute('style', important('width:0; height:0; overflow:hidden; visibility:hidden; position: absolute;'));
        container.appendChild(div);

        document.body.appendChild(container);
        var zoom = 1000 / div.clientHeight;
        zoom = Math.round(zoom * 100) / 100;
        document.body.removeChild(container);

        return{
            zoom: zoom,
            devicePxPerCssPx: zoom * devicePixelRatio()
        };
    };

    /**
     * no real trick; device-pixel-ratio is the ratio of device dpi / css dpi.
     * (Note that this is a different interpretation than Webkit's device
     * pixel ratio, which is the ratio device dpi / system dpi).
     *
     * Also, for Mozilla, there is no difference between the zoom factor and the device ratio.
     *
     * @return {Object}
     * @private
     */
    var firefox4 = function () {
        var zoom = mediaQueryBinarySearch('min--moz-device-pixel-ratio', '', 0, 10, 20, 0.0001);
        zoom = Math.round(zoom * 100) / 100;
        return {
            zoom: zoom,
            devicePxPerCssPx: zoom
        };
    };

    /**
     * Firefox 18.x
     * Mozilla added support for devicePixelRatio to Firefox 18,
     * but it is affected by the zoom level, so, like in older
     * Firefox we can't tell if we are in zoom mode or in a device
     * with a different pixel ratio
     * @return {Object}
     * @private
     */
    var firefox18 = function () {
        return {
            zoom: firefox4().zoom,
            devicePxPerCssPx: devicePixelRatio()
        };
    };

    /**
     * works starting Opera 11.11
     * the trick: outerWidth is the viewport width including scrollbars in
     * system px, while innerWidth is the viewport width including scrollbars
     * in CSS px
     * @return {Object}
     * @private
     */
    var opera11 = function () {
        var zoom = window.top.outerWidth / window.top.innerWidth;
        zoom = Math.round(zoom * 100) / 100;
        return {
            zoom: zoom,
            devicePxPerCssPx: zoom * devicePixelRatio()
        };
    };

    /**
     * Use a binary search through media queries to find zoom level in Firefox
     * @param property
     * @param unit
     * @param a
     * @param b
     * @param maxIter
     * @param epsilon
     * @return {Number}
     */
    var mediaQueryBinarySearch = function (property, unit, a, b, maxIter, epsilon) {
        var matchMedia;
        var head, style, div;
        if (window.matchMedia) {
            matchMedia = window.matchMedia;
        } else {
            head = document.getElementsByTagName('head')[0];
            style = document.createElement('style');
            head.appendChild(style);

            div = document.createElement('div');
            div.className = 'mediaQueryBinarySearch';
            div.style.display = 'none';
            document.body.appendChild(div);

            matchMedia = function (query) {
                style.sheet.insertRule('@media ' + query + '{.mediaQueryBinarySearch ' + '{text-decoration: underline} }', 0);
                var matched = getComputedStyle(div, null).textDecoration == 'underline';
                style.sheet.deleteRule(0);
                return {matches: matched};
            };
        }
        var ratio = binarySearch(a, b, maxIter);
        if (div) {
            head.removeChild(style);
            document.body.removeChild(div);
        }
        return ratio;

        function binarySearch(a, b, maxIter) {
            var mid = (a + b) / 2;
            if (maxIter <= 0 || b - a < epsilon) {
                return mid;
            }
            var query = "(" + property + ":" + mid + unit + ")";
            if (matchMedia(query).matches) {
                return binarySearch(mid, b, maxIter - 1);
            } else {
                return binarySearch(a, mid, maxIter - 1);
            }
        }
    };

    /**
     * Generate detection function
     * @private
     */
    var detectFunction = (function () {
        var func = fallback;
        //IE8+
        if (!isNaN(screen.logicalXDPI) && !isNaN(screen.systemXDPI)) {
            func = ie8;
        }
        // IE10+ / Touch
        else if (window.navigator.msMaxTouchPoints) {
            func = ie10;
        }
        //Mobile Webkit
        else if ('orientation' in window && typeof document.body.style.webkitMarquee === 'string') {
            func = webkitMobile;
        }
        //WebKit
        else if (typeof document.body.style.webkitMarquee === 'string') {
            func = webkit;
        }
        //Opera
        else if (navigator.userAgent.indexOf('Opera') >= 0) {
            func = opera11;
        }
        //Last one is Firefox
        //FF 18.x
        else if (window.devicePixelRatio) {
            func = firefox18;
        }
        //FF 4.0 - 17.x
        else if (firefox4().zoom > 0.001) {
            func = firefox4;
        }

        return func;
    }());


    return ({

        /**
         * Ratios.zoom shorthand
         * @return {Number} Zoom level
         */
        zoom: function () {
            return detectFunction().zoom;
        },

        /**
         * Ratios.devicePxPerCssPx shorthand
         * @return {Number} devicePxPerCssPx level
         */
        device: function () {
            return detectFunction().devicePxPerCssPx;
        }
    });
}));

var wpcom_img_zoomer = {
        clientHintSupport: {
                gravatar: false,
                files: false,
                photon: false,
                mshots: false,
                staticAssets: false,
                latex: false,
                imgpress: false,
        },
	useHints: false,
	zoomed: false,
	timer: null,
	interval: 1000, // zoom polling interval in millisecond

	// Should we apply width/height attributes to control the image size?
	imgNeedsSizeAtts: function( img ) {
		// Do not overwrite existing width/height attributes.
		if ( img.getAttribute('width') !== null || img.getAttribute('height') !== null )
			return false;
		// Do not apply the attributes if the image is already constrained by a parent element.
		if ( img.width < img.naturalWidth || img.height < img.naturalHeight )
			return false;
		return true;
	},

        hintsFor: function( service ) {
                if ( this.useHints === false ) {
                        return false;
                }
                if ( this.hints() === false ) {
                        return false;
                }
                if ( typeof this.clientHintSupport[service] === "undefined" ) {
                        return false;
                }
                if ( this.clientHintSupport[service] === true ) {
                        return true;
                }
                return false;
        },

	hints: function() {
		try {
			var chrome = window.navigator.userAgent.match(/\sChrome\/([0-9]+)\.[.0-9]+\s/)
			if (chrome !== null) {
				var version = parseInt(chrome[1], 10)
				if (isNaN(version) === false && version >= 46) {
					return true
				}
			}
		} catch (e) {
			return false
		}
		return false
	},

	init: function() {
		var t = this;
		try{
			t.zoomImages();
			t.timer = setInterval( function() { t.zoomImages(); }, t.interval );
		}
		catch(e){
		}
	},

	stop: function() {
		if ( this.timer )
			clearInterval( this.timer );
	},

	getScale: function() {
		var scale = detectZoom.device();
		// Round up to 1.5 or the next integer below the cap.
		if      ( scale <= 1.0 ) scale = 1.0;
		else if ( scale <= 1.5 ) scale = 1.5;
		else if ( scale <= 2.0 ) scale = 2.0;
		else if ( scale <= 3.0 ) scale = 3.0;
		else if ( scale <= 4.0 ) scale = 4.0;
		else                     scale = 5.0;
		return scale;
	},

	shouldZoom: function( scale ) {
		var t = this;
		// Do not operate on hidden frames.
		if ( "innerWidth" in window && !window.innerWidth )
			return false;
		// Don't do anything until scale > 1
		if ( scale == 1.0 && t.zoomed == false )
			return false;
		return true;
	},

	zoomImages: function() {
		var t = this;
		var scale = t.getScale();
		if ( ! t.shouldZoom( scale ) ){
			return;
		}
		t.zoomed = true;
		// Loop through all the <img> elements on the page.
		var imgs = document.getElementsByTagName("img");

		for ( var i = 0; i < imgs.length; i++ ) {
			// Wait for original images to load
			if ( "complete" in imgs[i] && ! imgs[i].complete )
				continue;

			// Skip images that have srcset attributes.
			if ( imgs[i].hasAttribute('srcset') ) {
				continue;
			}

			// Skip images that don't need processing.
			var imgScale = imgs[i].getAttribute("scale");
			if ( imgScale == scale || imgScale == "0" )
				continue;

			// Skip images that have already failed at this scale
			var scaleFail = imgs[i].getAttribute("scale-fail");
			if ( scaleFail && scaleFail <= scale )
				continue;

			// Skip images that have no dimensions yet.
			if ( ! ( imgs[i].width && imgs[i].height ) )
				continue;

			// Skip images from Lazy Load plugins
			if ( ! imgScale && imgs[i].getAttribute("data-lazy-src") && (imgs[i].getAttribute("data-lazy-src") !== imgs[i].getAttribute("src")))
				continue;

			if ( t.scaleImage( imgs[i], scale ) ) {
				// Mark the img as having been processed at this scale.
				imgs[i].setAttribute("scale", scale);
			}
			else {
				// Set the flag to skip this image.
				imgs[i].setAttribute("scale", "0");
			}
		}
	},

	scaleImage: function( img, scale ) {
		var t = this;
		var newSrc = img.src;

                var isFiles = false;
                var isLatex = false;
                var isPhoton = false;

		// Skip slideshow images
		if ( img.parentNode.className.match(/slideshow-slide/) )
			return false;

		// Skip CoBlocks Lightbox images
		if ( img.parentNode.className.match(/coblocks-lightbox__image/) )
			return false;

		// Scale gravatars that have ?s= or ?size=
		if ( img.src.match( /^https?:\/\/([^\/]*\.)?gravatar\.com\/.+[?&](s|size)=/ ) ) {
                        if ( this.hintsFor( "gravatar" ) === true ) {
                                return false;
                        }
			newSrc = img.src.replace( /([?&](s|size)=)(\d+)/, function( $0, $1, $2, $3 ) {
				// Stash the original size
				var originalAtt = "originals",
				originalSize = img.getAttribute(originalAtt);
				if ( originalSize === null ) {
					originalSize = $3;
					img.setAttribute(originalAtt, originalSize);
					if ( t.imgNeedsSizeAtts( img ) ) {
						// Fix width and height attributes to rendered dimensions.
						img.width = img.width;
						img.height = img.height;
					}
				}
				// Get the width/height of the image in CSS pixels
				var size = img.clientWidth;
				// Convert CSS pixels to device pixels
				var targetSize = Math.ceil(img.clientWidth * scale);
				// Don't go smaller than the original size
				targetSize = Math.max( targetSize, originalSize );
				// Don't go larger than the service supports
				targetSize = Math.min( targetSize, 512 );
				return $1 + targetSize;
			});
		}

		// Scale mshots that have width
		else if ( img.src.match(/^https?:\/\/([^\/]+\.)*(wordpress|wp)\.com\/mshots\/.+[?&]w=\d+/) ) {
                        if ( this.hintsFor( "mshots" ) === true ) {
                                return false;
                        }
			newSrc = img.src.replace( /([?&]w=)(\d+)/, function($0, $1, $2) {
				// Stash the original size
				var originalAtt = 'originalw', originalSize = img.getAttribute(originalAtt);
				if ( originalSize === null ) {
					originalSize = $2;
					img.setAttribute(originalAtt, originalSize);
					if ( t.imgNeedsSizeAtts( img ) ) {
						// Fix width and height attributes to rendered dimensions.
						img.width = img.width;
						img.height = img.height;
					}
				}
				// Get the width of the image in CSS pixels
				var size = img.clientWidth;
				// Convert CSS pixels to device pixels
				var targetSize = Math.ceil(size * scale);
				// Don't go smaller than the original size
				targetSize = Math.max( targetSize, originalSize );
				// Don't go bigger unless the current one is actually lacking
				if ( scale > img.getAttribute("scale") && targetSize <= img.naturalWidth )
					targetSize = $2;
				if ( $2 != targetSize )
					return $1 + targetSize;
				return $0;
			});

			// Update height attribute to match width
			newSrc = newSrc.replace( /([?&]h=)(\d+)/, function($0, $1, $2) {
				if ( newSrc == img.src ) {
					return $0;
				}
				// Stash the original size
				var originalAtt = 'originalh', originalSize = img.getAttribute(originalAtt);
				if ( originalSize === null ) {
					originalSize = $2;
					img.setAttribute(originalAtt, originalSize);
				}
				// Get the height of the image in CSS pixels
				var size = img.clientHeight;
				// Convert CSS pixels to device pixels
				var targetSize = Math.ceil(size * scale);
				// Don't go smaller than the original size
				targetSize = Math.max( targetSize, originalSize );
				// Don't go bigger unless the current one is actually lacking
				if ( scale > img.getAttribute("scale") && targetSize <= img.naturalHeight )
					targetSize = $2;
				if ( $2 != targetSize )
					return $1 + targetSize;
				return $0;
			});
		}

		// Scale simple imgpress queries (s0.wp.com) that only specify w/h/fit
		else if ( img.src.match(/^https?:\/\/([^\/.]+\.)*(wp|wordpress)\.com\/imgpress\?(.+)/) ) {
                        if ( this.hintsFor( "imgpress" ) === true ) {
                                return false; 
                        }
			var imgpressSafeFunctions = ["zoom", "url", "h", "w", "fit", "filter", "brightness", "contrast", "colorize", "smooth", "unsharpmask"];
			// Search the query string for unsupported functions.
			var qs = RegExp.$3.split('&');
			for ( var q in qs ) {
				q = qs[q].split('=')[0];
				if ( imgpressSafeFunctions.indexOf(q) == -1 ) {
					return false;
				}
			}
			// Fix width and height attributes to rendered dimensions.
			img.width = img.width;
			img.height = img.height;
			// Compute new src
			if ( scale == 1 )
				newSrc = img.src.replace(/\?(zoom=[^&]+&)?/, '?');
			else
				newSrc = img.src.replace(/\?(zoom=[^&]+&)?/, '?zoom=' + scale + '&');
		}

		// Scale files.wordpress.com, LaTeX, or Photon images (i#.wp.com)
		else if (
			( isFiles = img.src.match(/^https?:\/\/([^\/]+)\.files\.wordpress\.com\/.+[?&][wh]=/) ) ||
			( isLatex = img.src.match(/^https?:\/\/([^\/.]+\.)*(wp|wordpress)\.com\/latex\.php\?(latex|zoom)=(.+)/) ) ||
			( isPhoton = img.src.match(/^https?:\/\/i[\d]{1}\.wp\.com\/(.+)/) )
		) {
                        if ( false !== isFiles && this.hintsFor( "files" ) === true ) {
                                return false
                        }
                        if ( false !== isLatex && this.hintsFor( "latex" ) === true ) {
                                return false
                        }
                        if ( false !== isPhoton && this.hintsFor( "photon" ) === true ) {
                                return false
                        }
			// Fix width and height attributes to rendered dimensions.
			img.width = img.width;
			img.height = img.height;
			// Compute new src
			if ( scale == 1 ) {
				newSrc = img.src.replace(/\?(zoom=[^&]+&)?/, '?');
			} else {
				newSrc = img.src;

				var url_var = newSrc.match( /([?&]w=)(\d+)/ );
				if ( url_var !== null && url_var[2] ) {
					newSrc = newSrc.replace( url_var[0], url_var[1] + img.width );
				}

				url_var = newSrc.match( /([?&]h=)(\d+)/ );
				if ( url_var !== null && url_var[2] ) {
					newSrc = newSrc.replace( url_var[0], url_var[1] + img.height );
				}

				var zoom_arg = '&zoom=2';
				if ( !newSrc.match( /\?/ ) ) {
					zoom_arg = '?zoom=2';
				}
				img.setAttribute( 'srcset', newSrc + zoom_arg + ' ' + scale + 'x' );
			}
		}

		// Scale static assets that have a name matching *-1x.png or *@1x.png
		else if ( img.src.match(/^https?:\/\/[^\/]+\/.*[-@]([12])x\.(gif|jpeg|jpg|png)(\?|$)/) ) {
                        if ( this.hintsFor( "staticAssets" ) === true ) {
                                return false; 
                        }
			// Fix width and height attributes to rendered dimensions.
			img.width = img.width;
			img.height = img.height;
			var currentSize = RegExp.$1, newSize = currentSize;
			if ( scale <= 1 )
				newSize = 1;
			else
				newSize = 2;
			if ( currentSize != newSize )
				newSrc = img.src.replace(/([-@])[12]x\.(gif|jpeg|jpg|png)(\?|$)/, '$1'+newSize+'x.$2$3');
		}

		else {
			return false;
		}

		// Don't set img.src unless it has changed. This avoids unnecessary reloads.
		if ( newSrc != img.src ) {
			// Store the original img.src
			var prevSrc, origSrc = img.getAttribute("src-orig");
			if ( !origSrc ) {
				origSrc = img.src;
				img.setAttribute("src-orig", origSrc);
			}
			// In case of error, revert img.src
			prevSrc = img.src;
			img.onerror = function(){
				img.src = prevSrc;
				if ( img.getAttribute("scale-fail") < scale )
					img.setAttribute("scale-fail", scale);
				img.onerror = null;
			};
			// Finally load the new image
			img.src = newSrc;
		}

		return true;
	}
};

wpcom_img_zoomer.init();
;
( function( $ ) {
	var cookieValue = document.cookie.replace( /(?:(?:^|.*;\s*)eucookielaw\s*\=\s*([^;]*).*$)|^.*$/, '$1' ),
		overlay = $( '#eu-cookie-law' ),
		container = $( '.widget_eu_cookie_law_widget' ),
		initialScrollPosition,
		scrollFunction;

	if ( overlay.hasClass( 'ads-active' ) ) {
		var adsCookieValue = document.cookie.replace( /(?:(?:^|.*;\s*)personalized-ads-consent\s*\=\s*([^;]*).*$)|^.*$/, '$1' );
		if ( '' !== cookieValue && '' !== adsCookieValue ) {
			overlay.remove();
		}
	} else if ( '' !== cookieValue ) {
		overlay.remove();
	}

	$( '.widget_eu_cookie_law_widget' ).appendTo( 'body' ).fadeIn();

	overlay.find( 'form' ).on( 'submit', accept );

	if ( overlay.hasClass( 'hide-on-scroll' ) ) {
		initialScrollPosition = $( window ).scrollTop();
		scrollFunction = function() {
			if ( Math.abs( $( window ).scrollTop() - initialScrollPosition ) > 50 ) {
				accept();
			}
		};
		$( window ).on( 'scroll', scrollFunction );
	} else if ( overlay.hasClass( 'hide-on-time' ) ) {
		setTimeout( accept, overlay.data( 'hide-timeout' ) * 1000 );
	}

	var accepted = false;
	function accept( event ) {
		if ( accepted ) {
			return;
		}
		accepted = true;

		if ( event && event.preventDefault ) {
			event.preventDefault();
		}

		if ( overlay.hasClass( 'hide-on-scroll' ) ) {
			$( window ).off( 'scroll', scrollFunction );
		}

		var expireTime = new Date();
		expireTime.setTime( expireTime.getTime() + ( overlay.data( 'consent-expiration' ) * 24 * 60 * 60 * 1000 ) );

		document.cookie = 'eucookielaw=' + expireTime.getTime() + ';path=/;expires=' + expireTime.toGMTString();
		if ( overlay.hasClass( 'ads-active' ) && overlay.hasClass( 'hide-on-button' ) ) {
			document.cookie = 'personalized-ads-consent=' + expireTime.getTime() + ';path=/;expires=' + expireTime.toGMTString();
		}

		overlay.fadeOut( 400, function() {
			overlay.remove();
			container.remove();
		} );
	}
} )( jQuery );
;
/* global FB, jpfbembed */
( function ( window ) {
	var facebookEmbed = function () {
		var fbroot, src, newScript, firstScript;

		if ( 'undefined' !== typeof FB && FB.XFBML ) {
			FB.XFBML.parse();
		} else {
			fbroot = document.createElement( 'div' );
			fbroot.id = 'fb-root';
			document.getElementsByTagName( 'body' )[ 0 ].appendChild( fbroot );

			src = 'https://connect.facebook.net/' + jpfbembed.locale + '/sdk.js#xfbml=1';
			if ( jpfbembed.appid ) {
				src += '&appId=' + jpfbembed.appid;
			}
			src += '&version=v2.3';

			newScript = document.createElement( 'script' );
			newScript.setAttribute( 'src', src );
			firstScript = document.querySelector( 'script' );
			firstScript.parentNode.insertBefore( newScript, firstScript );
		}
	};

	window.fbAsyncInit = function () {
		FB.init( {
			appId: jpfbembed.appid,
			version: 'v2.3',
		} );

		FB.XFBML.parse();
	};

	if ( 'undefined' !== typeof infiniteScroll ) {
		document.body.addEventListener( 'post-load', facebookEmbed );
	}

	facebookEmbed();
} )( this );
;
!function(){"use strict";var e,n,t={843:function(e,n,t){t.d(n,{pM:function(){return o},qq:function(){return r},zq:function(){return i},a3:function(){return l},hA:function(){return u},d6:function(){return c},Uq:function(){return a},j4:function(){return s},B$:function(){return _}});var o={BANNER:"banner",MODAL:"modal",HIDDEN:""},r={PURPOSE:"purpose",VENDOR:"vendor"},i=258,l={1:!0,2:!0,3:!0,4:!0,7:!0,9:!0,10:!0},u={2:!0,3:!0,4:!0,7:!0,9:!0,10:!0},c={UI_SHOWN:"cmpuishown",LOADED:"tcloaded",USER_ACTION_COMPLETE:"useractioncomplete"},a={VISIBLE:"visible",HIDDEN:"hidden",DISABLED:"disabled"},s={STUB:"stub",LOADED:"loaded",ERROR:"error"},_="euconsent-v2"},748:function(e,n,t){t.d(n,{n4:function(){return S},Vo:function(){return C}});var o,r,i=t(400),l=[],u=i.YM.__b,c=i.YM.__r,a=i.YM.diffed,s=i.YM.__c,_=i.YM.unmount;function f(){l.forEach((function(e){if(e.__P)try{e.__H.__h.forEach(p),e.__H.__h.forEach(h),e.__H.__h=[]}catch(n){e.__H.__h=[],i.YM.__e(n,e.__v)}})),l=[]}i.YM.__b=function(e){o=null,u&&u(e)},i.YM.__r=function(e){c&&c(e),0;var n=(o=e.__c).__H;n&&(n.__h.forEach(p),n.__h.forEach(h),n.__h=[])},i.YM.diffed=function(e){a&&a(e);var n=e.__c;n&&n.__H&&n.__H.__h.length&&(1!==l.push(n)&&r===i.YM.requestAnimationFrame||((r=i.YM.requestAnimationFrame)||function(e){var n,t=function(){clearTimeout(o),d&&cancelAnimationFrame(n),setTimeout(e)},o=setTimeout(t,100);d&&(n=requestAnimationFrame(t))})(f)),o=void 0},i.YM.__c=function(e,n){n.some((function(e){try{e.__h.forEach(p),e.__h=e.__h.filter((function(e){return!e.__||h(e)}))}catch(t){n.some((function(e){e.__h&&(e.__h=[])})),n=[],i.YM.__e(t,e.__v)}})),s&&s(e,n)},i.YM.unmount=function(e){_&&_(e);var n=e.__c;if(n&&n.__H)try{n.__H.__.forEach(p)}catch(e){i.YM.__e(e,n.__v)}};var d="function"==typeof requestAnimationFrame;function p(e){var n=o;"function"==typeof e.__c&&e.__c(),o=n}function h(e){var n=o;e.__c=e.__(),o=n}function v(e,n){for(var t in n)e[t]=n[t];return e}function y(e,n){for(var t in e)if("__source"!==t&&!(t in n))return!0;for(var o in n)if("__source"!==o&&e[o]!==n[o])return!0;return!1}function m(e){this.props=e}(m.prototype=new i.wA).isPureReactComponent=!0,m.prototype.shouldComponentUpdate=function(e,n){return y(this.props,e)||y(this.state,n)};var b=i.YM.__b;i.YM.__b=function(e){e.type&&e.type.__f&&e.ref&&(e.props.ref=e.ref,e.ref=null),b&&b(e)};"undefined"!=typeof Symbol&&Symbol.for&&Symbol.for("react.forward_ref");var g=function(e,n){return null==e?null:(0,i.bR)((0,i.bR)(e).map(n))},k=(i.bR,i.YM.__e);i.YM.__e=function(e,n,t){if(e.then)for(var o,r=n;r=r.__;)if((o=r.__c)&&o.__c)return null==n.__e&&(n.__e=t.__e,n.__k=t.__k),o.__c(e,n);k(e,n,t)};var w=i.YM.unmount;function S(){this.__u=0,this.t=null,this.__b=null}function E(e){var n=e.__.__c;return n&&n.__e&&n.__e(e)}function C(e){var n,t,o;function r(r){if(n||(n=e()).then((function(e){t=e.default||e}),(function(e){o=e})),o)throw o;if(!t)throw n;return(0,i.az)(t,r)}return r.displayName="Lazy",r.__f=!0,r}function L(){this.u=null,this.o=null}i.YM.unmount=function(e){var n=e.__c;n&&n.__R&&n.__R(),n&&!0===e.__h&&(e.type=null),w&&w(e)},(S.prototype=new i.wA).__c=function(e,n){var t=n.__c,o=this;null==o.t&&(o.t=[]),o.t.push(t);var r=E(o.__v),i=!1,l=function(){i||(i=!0,t.__R=null,r?r(u):u())};t.__R=l;var u=function(){if(!--o.__u){if(o.state.__e){var e=o.state.__e;o.__v.__k[0]=function e(n,t,o){return n&&(n.__v=null,n.__k=n.__k&&n.__k.map((function(n){return e(n,t,o)})),n.__c&&n.__c.__P===t&&(n.__e&&o.insertBefore(n.__e,n.__d),n.__c.__e=!0,n.__c.__P=o)),n}(e,e.__c.__P,e.__c.__O)}var n;for(o.setState({__e:o.__b=null});n=o.t.pop();)n.forceUpdate()}},c=!0===n.__h;o.__u++||c||o.setState({__e:o.__b=o.__v.__k[0]}),e.then(l,l)},S.prototype.componentWillUnmount=function(){this.t=[]},S.prototype.render=function(e,n){if(this.__b){if(this.__v.__k){var t=document.createElement("div"),o=this.__v.__k[0].__c;this.__v.__k[0]=function e(n,t,o){return n&&(n.__c&&n.__c.__H&&(n.__c.__H.__.forEach((function(e){"function"==typeof e.__c&&e.__c()})),n.__c.__H=null),null!=(n=v({},n)).__c&&(n.__c.__P===o&&(n.__c.__P=t),n.__c=null),n.__k=n.__k&&n.__k.map((function(n){return e(n,t,o)}))),n}(this.__b,t,o.__O=o.__P)}this.__b=null}var r=n.__e&&(0,i.az)(i.HY,null,e.fallback);return r&&(r.__h=null),[(0,i.az)(i.HY,null,n.__e?null:e.children),r]};var A=function(e,n,t){if(++t[1]===t[0]&&e.o.delete(n),e.props.revealOrder&&("t"!==e.props.revealOrder[0]||!e.o.size))for(t=e.u;t;){for(;t.length>3;)t.pop()();if(t[1]<t[0])break;e.u=t=t[2]}};(L.prototype=new i.wA).__e=function(e){var n=this,t=E(n.__v),o=n.o.get(e);return o[0]++,function(r){var i=function(){n.props.revealOrder?(o.push(r),A(n,e,o)):r()};t?t(i):i()}},L.prototype.render=function(e){this.u=null,this.o=new Map;var n=(0,i.bR)(e.children);e.revealOrder&&"b"===e.revealOrder[0]&&n.reverse();for(var t=n.length;t--;)this.o.set(n[t],this.u=[1,0,this.u]);return e.children},L.prototype.componentDidUpdate=L.prototype.componentDidMount=function(){var e=this;this.o.forEach((function(n,t){A(e,t,n)}))};var P="undefined"!=typeof Symbol&&Symbol.for&&Symbol.for("react.element")||60103,O=/^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|fill|flood|font|glyph(?!R)|horiz|marker(?!H|W|U)|overline|paint|stop|strikethrough|stroke|text(?!L)|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/,M=function(e){return("undefined"!=typeof Symbol&&"symbol"==typeof Symbol()?/fil|che|rad/i:/fil|che|ra/i).test(e)};i.wA.prototype.isReactComponent={},["componentWillMount","componentWillReceiveProps","componentWillUpdate"].forEach((function(e){Object.defineProperty(i.wA.prototype,e,{configurable:!0,get:function(){return this["UNSAFE_"+e]},set:function(n){Object.defineProperty(this,e,{configurable:!0,writable:!0,value:n})}})}));var I=i.YM.event;function T(){}function H(){return this.cancelBubble}function U(){return this.defaultPrevented}i.YM.event=function(e){return I&&(e=I(e)),e.persist=T,e.isPropagationStopped=H,e.isDefaultPrevented=U,e.nativeEvent=e};var D={configurable:!0,get:function(){return this.class}},V=i.YM.vnode;i.YM.vnode=function(e){var n=e.type,t=e.props,o=t;if("string"==typeof n){for(var r in o={},t){var l=t[r];"value"===r&&"defaultValue"in t&&null==l||("defaultValue"===r&&"value"in t&&null==t.value?r="value":"download"===r&&!0===l?l="":/ondoubleclick/i.test(r)?r="ondblclick":/^onchange(textarea|input)/i.test(r+n)&&!M(t.type)?r="oninput":/^on(Ani|Tra|Tou|BeforeInp)/.test(r)?r=r.toLowerCase():O.test(r)?r=r.replace(/[A-Z0-9]/,"-$&").toLowerCase():null===l&&(l=void 0),o[r]=l)}"select"==n&&o.multiple&&Array.isArray(o.value)&&(o.value=(0,i.bR)(t.children).forEach((function(e){e.props.selected=-1!=o.value.indexOf(e.props.value)}))),"select"==n&&null!=o.defaultValue&&(o.value=(0,i.bR)(t.children).forEach((function(e){e.props.selected=o.multiple?-1!=o.defaultValue.indexOf(e.props.value):o.defaultValue==e.props.value}))),e.props=o}n&&t.class!=t.className&&(D.enumerable="className"in t,null!=t.className&&(o.class=t.className),Object.defineProperty(o,"className",D)),e.$$typeof=P,V&&V(e)};var N=i.YM.__r;i.YM.__r=function(e){N&&N(e),e.__c};"object"==typeof performance&&"function"==typeof performance.now&&performance.now.bind(performance);i.HY,i.az,i.kr,i.Vf,i.HY,i.wA,i.HY},400:function(e,n,t){t.d(n,{sY:function(){return V},ZB:function(){return N},az:function(){return d},h:function(){return d},HY:function(){return v},Vf:function(){return h},wA:function(){return y},Tm:function(){return x},kr:function(){return j},bR:function(){return E},YM:function(){return o}});var o,r,i,l,u,c={},a=[],s=/acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;function _(e,n){for(var t in n)e[t]=n[t];return e}function f(e){var n=e.parentNode;n&&n.removeChild(e)}function d(e,n,t){var o,r,i,l=arguments,u={};for(i in n)"key"==i?o=n[i]:"ref"==i?r=n[i]:u[i]=n[i];if(arguments.length>3)for(t=[t],i=3;i<arguments.length;i++)t.push(l[i]);if(null!=t&&(u.children=t),"function"==typeof e&&null!=e.defaultProps)for(i in e.defaultProps)void 0===u[i]&&(u[i]=e.defaultProps[i]);return p(e,u,o,r,null)}function p(e,n,t,r,i){var l={type:e,props:n,key:t,ref:r,__k:null,__:null,__b:0,__e:null,__d:void 0,__c:null,__h:null,constructor:void 0,__v:null==i?++o.__v:i};return null!=o.vnode&&o.vnode(l),l}function h(){return{current:null}}function v(e){return e.children}function y(e,n){this.props=e,this.context=n}function m(e,n){if(null==n)return e.__?m(e.__,e.__.__k.indexOf(e)+1):null;for(var t;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e)return t.__e;return"function"==typeof e.type?m(e):null}function b(e){var n,t;if(null!=(e=e.__)&&null!=e.__c){for(e.__e=e.__c.base=null,n=0;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e){e.__e=e.__c.base=t.__e;break}return b(e)}}function g(e){(!e.__d&&(e.__d=!0)&&r.push(e)&&!k.__r++||l!==o.debounceRendering)&&((l=o.debounceRendering)||i)(k)}function k(){for(var e;k.__r=r.length;)e=r.sort((function(e,n){return e.__v.__b-n.__v.__b})),r=[],e.some((function(e){var n,t,o,r,i,l;e.__d&&(i=(r=(n=e).__v).__e,(l=n.__P)&&(t=[],(o=_({},r)).__v=r.__v+1,M(l,r,o,n.__n,void 0!==l.ownerSVGElement,null!=r.__h?[i]:null,t,null==i?m(r):i,r.__h),I(t,r),r.__e!=i&&b(r)))}))}function w(e,n,t,o,r,i,l,u,s,_){var f,d,h,y,b,g,k,w=o&&o.__k||a,E=w.length;for(t.__k=[],f=0;f<n.length;f++)if(null!=(y=t.__k[f]=null==(y=n[f])||"boolean"==typeof y?null:"string"==typeof y||"number"==typeof y||"bigint"==typeof y?p(null,y,null,null,y):Array.isArray(y)?p(v,{children:y},null,null,null):y.__b>0?p(y.type,y.props,y.key,null,y.__v):y)){if(y.__=t,y.__b=t.__b+1,null===(h=w[f])||h&&y.key==h.key&&y.type===h.type)w[f]=void 0;else for(d=0;d<E;d++){if((h=w[d])&&y.key==h.key&&y.type===h.type){w[d]=void 0;break}h=null}M(e,y,h=h||c,r,i,l,u,s,_),b=y.__e,(d=y.ref)&&h.ref!=d&&(k||(k=[]),h.ref&&k.push(h.ref,null,y),k.push(d,y.__c||b,y)),null!=b?(null==g&&(g=b),"function"==typeof y.type&&null!=y.__k&&y.__k===h.__k?y.__d=s=S(y,s,e):s=C(e,y,h,w,b,s),_||"option"!==t.type?"function"==typeof t.type&&(t.__d=s):e.value=""):s&&h.__e==s&&s.parentNode!=e&&(s=m(h))}for(t.__e=g,f=E;f--;)null!=w[f]&&("function"==typeof t.type&&null!=w[f].__e&&w[f].__e==t.__d&&(t.__d=m(o,f+1)),U(w[f],w[f]));if(k)for(f=0;f<k.length;f++)H(k[f],k[++f],k[++f])}function S(e,n,t){var o,r;for(o=0;o<e.__k.length;o++)(r=e.__k[o])&&(r.__=e,n="function"==typeof r.type?S(r,n,t):C(t,r,r,e.__k,r.__e,n));return n}function E(e,n){return n=n||[],null==e||"boolean"==typeof e||(Array.isArray(e)?e.some((function(e){E(e,n)})):n.push(e)),n}function C(e,n,t,o,r,i){var l,u,c;if(void 0!==n.__d)l=n.__d,n.__d=void 0;else if(null==t||r!=i||null==r.parentNode)e:if(null==i||i.parentNode!==e)e.appendChild(r),l=null;else{for(u=i,c=0;(u=u.nextSibling)&&c<o.length;c+=2)if(u==r)break e;e.insertBefore(r,i),l=i}return void 0!==l?l:r.nextSibling}function L(e,n,t){"-"===n[0]?e.setProperty(n,t):e[n]=null==t?"":"number"!=typeof t||s.test(n)?t:t+"px"}function A(e,n,t,o,r){var i;e:if("style"===n)if("string"==typeof t)e.style.cssText=t;else{if("string"==typeof o&&(e.style.cssText=o=""),o)for(n in o)t&&n in t||L(e.style,n,"");if(t)for(n in t)o&&t[n]===o[n]||L(e.style,n,t[n])}else if("o"===n[0]&&"n"===n[1])i=n!==(n=n.replace(/Capture$/,"")),n=n.toLowerCase()in e?n.toLowerCase().slice(2):n.slice(2),e.l||(e.l={}),e.l[n+i]=t,t?o||e.addEventListener(n,i?O:P,i):e.removeEventListener(n,i?O:P,i);else if("dangerouslySetInnerHTML"!==n){if(r)n=n.replace(/xlink[H:h]/,"h").replace(/sName$/,"s");else if("href"!==n&&"list"!==n&&"form"!==n&&"tabIndex"!==n&&"download"!==n&&n in e)try{e[n]=null==t?"":t;break e}catch(e){}"function"==typeof t||(null!=t&&(!1!==t||"a"===n[0]&&"r"===n[1])?e.setAttribute(n,t):e.removeAttribute(n))}}function P(e){this.l[e.type+!1](o.event?o.event(e):e)}function O(e){this.l[e.type+!0](o.event?o.event(e):e)}function M(e,n,t,r,i,l,u,c,a){var s,f,d,p,h,m,b,g,k,S,E,C=n.type;if(void 0!==n.constructor)return null;null!=t.__h&&(a=t.__h,c=n.__e=t.__e,n.__h=null,l=[c]),(s=o.__b)&&s(n);try{e:if("function"==typeof C){if(g=n.props,k=(s=C.contextType)&&r[s.__c],S=s?k?k.props.value:s.__:r,t.__c?b=(f=n.__c=t.__c).__=f.__E:("prototype"in C&&C.prototype.render?n.__c=f=new C(g,S):(n.__c=f=new y(g,S),f.constructor=C,f.render=D),k&&k.sub(f),f.props=g,f.state||(f.state={}),f.context=S,f.__n=r,d=f.__d=!0,f.__h=[]),null==f.__s&&(f.__s=f.state),null!=C.getDerivedStateFromProps&&(f.__s==f.state&&(f.__s=_({},f.__s)),_(f.__s,C.getDerivedStateFromProps(g,f.__s))),p=f.props,h=f.state,d)null==C.getDerivedStateFromProps&&null!=f.componentWillMount&&f.componentWillMount(),null!=f.componentDidMount&&f.__h.push(f.componentDidMount);else{if(null==C.getDerivedStateFromProps&&g!==p&&null!=f.componentWillReceiveProps&&f.componentWillReceiveProps(g,S),!f.__e&&null!=f.shouldComponentUpdate&&!1===f.shouldComponentUpdate(g,f.__s,S)||n.__v===t.__v){f.props=g,f.state=f.__s,n.__v!==t.__v&&(f.__d=!1),f.__v=n,n.__e=t.__e,n.__k=t.__k,n.__k.forEach((function(e){e&&(e.__=n)})),f.__h.length&&u.push(f);break e}null!=f.componentWillUpdate&&f.componentWillUpdate(g,f.__s,S),null!=f.componentDidUpdate&&f.__h.push((function(){f.componentDidUpdate(p,h,m)}))}f.context=S,f.props=g,f.state=f.__s,(s=o.__r)&&s(n),f.__d=!1,f.__v=n,f.__P=e,s=f.render(f.props,f.state,f.context),f.state=f.__s,null!=f.getChildContext&&(r=_(_({},r),f.getChildContext())),d||null==f.getSnapshotBeforeUpdate||(m=f.getSnapshotBeforeUpdate(p,h)),E=null!=s&&s.type===v&&null==s.key?s.props.children:s,w(e,Array.isArray(E)?E:[E],n,t,r,i,l,u,c,a),f.base=n.__e,n.__h=null,f.__h.length&&u.push(f),b&&(f.__E=f.__=null),f.__e=!1}else null==l&&n.__v===t.__v?(n.__k=t.__k,n.__e=t.__e):n.__e=T(t.__e,n,t,r,i,l,u,a);(s=o.diffed)&&s(n)}catch(e){n.__v=null,(a||null!=l)&&(n.__e=c,n.__h=!!a,l[l.indexOf(c)]=null),o.__e(e,n,t)}}function I(e,n){o.__c&&o.__c(n,e),e.some((function(n){try{e=n.__h,n.__h=[],e.some((function(e){e.call(n)}))}catch(e){o.__e(e,n.__v)}}))}function T(e,n,t,o,r,i,l,u){var s,_,d,p,h=t.props,v=n.props,y=n.type,m=0;if("svg"===y&&(r=!0),null!=i)for(;m<i.length;m++)if((s=i[m])&&(s===e||(y?s.localName==y:3==s.nodeType))){e=s,i[m]=null;break}if(null==e){if(null===y)return document.createTextNode(v);e=r?document.createElementNS("http://www.w3.org/2000/svg",y):document.createElement(y,v.is&&v),i=null,u=!1}if(null===y)h===v||u&&e.data===v||(e.data=v);else{if(i=i&&a.slice.call(e.childNodes),_=(h=t.props||c).dangerouslySetInnerHTML,d=v.dangerouslySetInnerHTML,!u){if(null!=i)for(h={},p=0;p<e.attributes.length;p++)h[e.attributes[p].name]=e.attributes[p].value;(d||_)&&(d&&(_&&d.__html==_.__html||d.__html===e.innerHTML)||(e.innerHTML=d&&d.__html||""))}if(function(e,n,t,o,r){var i;for(i in t)"children"===i||"key"===i||i in n||A(e,i,null,t[i],o);for(i in n)r&&"function"!=typeof n[i]||"children"===i||"key"===i||"value"===i||"checked"===i||t[i]===n[i]||A(e,i,n[i],t[i],o)}(e,v,h,r,u),d)n.__k=[];else if(m=n.props.children,w(e,Array.isArray(m)?m:[m],n,t,o,r&&"foreignObject"!==y,i,l,e.firstChild,u),null!=i)for(m=i.length;m--;)null!=i[m]&&f(i[m]);u||("value"in v&&void 0!==(m=v.value)&&(m!==e.value||"progress"===y&&!m)&&A(e,"value",m,h.value,!1),"checked"in v&&void 0!==(m=v.checked)&&m!==e.checked&&A(e,"checked",m,h.checked,!1))}return e}function H(e,n,t){try{"function"==typeof e?e(n):e.current=n}catch(e){o.__e(e,t)}}function U(e,n,t){var r,i,l;if(o.unmount&&o.unmount(e),(r=e.ref)&&(r.current&&r.current!==e.__e||H(r,null,n)),t||"function"==typeof e.type||(t=null!=(i=e.__e)),e.__e=e.__d=void 0,null!=(r=e.__c)){if(r.componentWillUnmount)try{r.componentWillUnmount()}catch(e){o.__e(e,n)}r.base=r.__P=null}if(r=e.__k)for(l=0;l<r.length;l++)r[l]&&U(r[l],n,t);null!=i&&f(i)}function D(e,n,t){return this.constructor(e,t)}function V(e,n,t){var r,i,l;o.__&&o.__(e,n),i=(r="function"==typeof t)?null:t&&t.__k||n.__k,l=[],M(n,e=(!r&&t||n).__k=d(v,null,[e]),i||c,c,void 0!==n.ownerSVGElement,!r&&t?[t]:i?null:n.firstChild?a.slice.call(n.childNodes):null,l,!r&&t?t:i?i.__e:n.firstChild,r),I(l,e)}function N(e,n){V(e,n,N)}function x(e,n,t){var o,r,i,l=arguments,u=_({},e.props);for(i in n)"key"==i?o=n[i]:"ref"==i?r=n[i]:u[i]=n[i];if(arguments.length>3)for(t=[t],i=3;i<arguments.length;i++)t.push(l[i]);return null!=t&&(u.children=t),p(e.type,u,o||e.key,r||e.ref,null)}function j(e,n){var t={__c:n="__cC"+u++,__:e,Consumer:function(e,n){return e.children(n)},Provider:function(e){var t,o;return this.getChildContext||(t=[],(o={})[n]=this,this.getChildContext=function(){return o},this.shouldComponentUpdate=function(e){this.props.value!==e.value&&t.some(g)},this.sub=function(e){t.push(e);var n=e.componentWillUnmount;e.componentWillUnmount=function(){t.splice(t.indexOf(e),1),n&&n.call(e)}}),e.children}};return t.Provider.__=t.Consumer.contextType=t}o={__e:function(e,n){for(var t,o,r;n=n.__;)if((t=n.__c)&&!t.__)try{if((o=t.constructor)&&null!=o.getDerivedStateFromError&&(t.setState(o.getDerivedStateFromError(e)),r=t.__d),null!=t.componentDidCatch&&(t.componentDidCatch(e),r=t.__d),r)return t.__E=t}catch(n){e=n}throw e},__v:0},y.prototype.setState=function(e,n){var t;t=null!=this.__s&&this.__s!==this.state?this.__s:this.__s=_({},this.state),"function"==typeof e&&(e=e(_({},t),this.props)),e&&_(t,e),null!=e&&this.__v&&(n&&this.__h.push(n),g(this))},y.prototype.forceUpdate=function(e){this.__v&&(this.__e=!0,e&&this.__h.push(e),g(this))},y.prototype.render=v,r=[],i="function"==typeof Promise?Promise.prototype.then.bind(Promise.resolve()):setTimeout,k.__r=0,u=0}},o={};function r(e){var n=o[e];if(void 0!==n)return n.exports;var i=o[e]={id:e,exports:{}};return t[e](i,i.exports,r),i.exports}r.m=t,r.amdO={},r.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(n,{a:n}),n},r.d=function(e,n){for(var t in n)r.o(n,t)&&!r.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},r.f={},r.e=function(e){return Promise.all(Object.keys(r.f).reduce((function(n,t){return r.f[t](e,n),n}),[]))},r.u=function(e){return{143:"app",392:"banner",582:"modal"}[e]+".bundle.js?id="+{143:"10f08b851d8a01803359",392:"69626cb5d25b886923fc",582:"14cc5ce046861105f9cb"}[e]},r.o=function(e,n){return Object.prototype.hasOwnProperty.call(e,n)},e={},n="a8c-cmp:",r.l=function(t,o,i,l){if(e[t])e[t].push(o);else{var u,c;if(void 0!==i)for(var a=document.getElementsByTagName("script"),s=0;s<a.length;s++){var _=a[s];if(_.getAttribute("src")==t||_.getAttribute("data-webpack")==n+i){u=_;break}}u||(c=!0,(u=document.createElement("script")).charset="utf-8",u.timeout=120,r.nc&&u.setAttribute("nonce",r.nc),u.setAttribute("data-webpack",n+i),u.src=t),e[t]=[o];var f=function(n,o){u.onerror=u.onload=null,clearTimeout(d);var r=e[t];if(delete e[t],u.parentNode&&u.parentNode.removeChild(u),r&&r.forEach((function(e){return e(o)})),n)return n(o)},d=setTimeout(f.bind(null,void 0,{type:"timeout",target:u}),12e4);u.onerror=f.bind(null,u.onerror),u.onload=f.bind(null,u.onload),c&&document.head.appendChild(u)}},r.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},r.p="/",function(){var e={968:0};r.f.j=function(n,t){var o=r.o(e,n)?e[n]:void 0;if(0!==o)if(o)t.push(o[2]);else{var i=new Promise((function(t,r){o=e[n]=[t,r]}));t.push(o[2]=i);var l=r.p+r.u(n),u=new Error;r.l(l,(function(t){if(r.o(e,n)&&(0!==(o=e[n])&&(e[n]=void 0),o)){var i=t&&("load"===t.type?"missing":t.type),l=t&&t.target&&t.target.src;u.message="Loading chunk "+n+" failed.\n("+i+": "+l+")",u.name="ChunkLoadError",u.type=i,u.request=l,o[1](u)}}),"chunk-"+n,n)}};var n=function(n,t){var o,i,l=t[0],u=t[1],c=t[2],a=0;for(o in u)r.o(u,o)&&(r.m[o]=u[o]);for(c&&c(r),n&&n(t);a<l.length;a++)i=l[a],r.o(e,i)&&e[i]&&e[i][0](),e[l[a]]=0},t=self.webpackChunka8c_cmp=self.webpackChunka8c_cmp||[];t.forEach(n.bind(null,0)),t.push=n.bind(null,t.push.bind(t))}(),function(){var e=r(400),n=r(748);function t(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var o=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,o,r;return n=e,r=[{key:"decode",value:function(n){for(var t="",o=0;o<n.length;o++){for(var r=e.dictionary.indexOf(n[o]).toString(2),i=6-r.length,l=0;l<i;l++)t+="0";t+=r}return t}},{key:"encode",value:function(n){for(var t="",o=24-n.length%24,r=0;r<o;r++)n+="0";for(var i=0;i<n.length;i+=6)t+=e.dictionary[parseInt(n.substr(i,6),2)];return t}}],(o=null)&&t(n.prototype,o),r&&t(n,r),e}();function i(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}o.dictionary="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";var l=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){return parseInt(e,2)}},{key:"encode",value:function(e,n){for(var t="",o=e.toString(2),r=n-o.length,i=0;i<r;i++)t+="0";return t+o}}],(t=null)&&i(n.prototype,t),o&&i(n,o),e}();function u(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var c=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){return new Date(100*l.decode(e))}},{key:"encode",value:function(e){return l.encode(Math.round(e.getTime()/100),36)}}],(t=null)&&u(n.prototype,t),o&&u(n,o),e}();function a(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var s=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){return String.fromCharCode(l.decode(e)+65)}},{key:"encode",value:function(e){return l.encode(e.charCodeAt(0)-65,6)}}],(t=null)&&a(n.prototype,t),o&&a(n,o),e}();function _(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var f=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){return[s.decode(e.substring(0,6)),s.decode(e.substring(6))].join("")}},{key:"encode",value:function(e){return s.encode(e[0],6)+s.encode(e[1],6)}}],(t=null)&&_(n.prototype,t),o&&_(n,o),e}();function d(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var p=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){return"1"===e}},{key:"encode",value:function(e){return e?"1":"0"}}],(t=null)&&d(n.prototype,t),o&&d(n,o),e}();function h(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var v=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){for(var n={},t=0;t<e.length;t++)"1"===e[t]&&(n[t+1]=!0);return n}},{key:"encode",value:function(e,n){for(var t="",o=1;o<=n;o++)t+=e[o]?"1":"0";return t}}],(t=null)&&h(n.prototype,t),o&&h(n,o),e}();function y(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var m=function(){function e(n){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e),this.bitString=n,this.position=0}var n,t,o;return n=e,(t=[{key:"advance",value:function(e){this.position+=e}},{key:"getPosition",value:function(){return this.position}},{key:"peekToEnd",value:function(){return this.bitString.substring(this.position)}},{key:"popBits",value:function(e){var n=this.bitString.substring(this.position,this.position+e);return this.advance(e),n}}])&&y(n.prototype,t),o&&y(n,o),e}();function b(e){return function(e){if(Array.isArray(e))return g(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||function(e,n){if(!e)return;if("string"==typeof e)return g(e,n);var t=Object.prototype.toString.call(e).slice(8,-1);"Object"===t&&e.constructor&&(t=e.constructor.name);if("Map"===t||"Set"===t)return Array.from(e);if("Arguments"===t||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t))return g(e,n)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function g(e,n){(null==n||n>e.length)&&(n=e.length);for(var t=0,o=new Array(n);t<n;t++)o[t]=e[t];return o}function k(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var w=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,o;return n=e,o=[{key:"decode",value:function(e){var n=new m(e),t=l.decode(n.popBits(16));if(!p.decode(n.popBits(1)))return{value:v.decode(n.popBits(t)),bitLength:n.getPosition()};for(var o={},r=l.decode(n.popBits(12)),i=0;i<r;i++){var u=p.decode(n.popBits(1)),c=l.decode(n.popBits(16));if(u)for(var a=l.decode(n.popBits(16)),s=c;s<=a;s++)o[s]=!0;else o[c]=!0}return{value:o,bitLength:n.getPosition()}}},{key:"encode",value:function(e){var n="",t=Math.max.apply(Math,b(Object.keys(e)).concat([0]));n+=l.encode(t,16);for(var o="",r=[],i=[],u=1;u<=t;u++)o+=e[u]?"1":"0",e[u]&&(0==i.length&&i.push(u),e[u+1]||(i.push(u),r.push(i),i=[]));return 45*r.length<o.length?(n+=p.encode(!0,1),n+=l.encode(r.length,12),r.forEach((function(e){var t=e[0]!==e[1];n+=p.encode(t,1),n+=l.encode(e[0],16),t&&(n+=l.encode(e[1],16))}))):n+=p.encode(!1,1)+o,n}}],(t=null)&&k(n.prototype,t),o&&k(n,o),e}();function S(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var E=function(){function e(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e)}var n,t,r;return n=e,r=[{key:"deserialize",value:function(n){var t=new m(o.decode(n));return e.decodeFields(e.fieldMap,t)}},{key:"decodeFields",value:function(n,t){var o={};return n.forEach((function(n){if(n.children)o[n.key]=e.decodeFields(n.children,t);else if(void 0===n.bitLength){var r=n.codec.decode(t.peekToEnd());o[n.key]=r.value,t.advance(r.bitLength)}else o[n.key]=n.codec.decode(t.popBits(n.bitLength))})),o}},{key:"serialize",value:function(n){var t=e.encodeFields(e.fieldMap,n);return o.encode(t)}},{key:"encodeFields",value:function(n,t){var o="";return n.forEach((function(n){n.children?o+=e.encodeFields(n.children,t[n.key]):void 0===n.bitLength?o+=n.codec.encode(t[n.key]):o+=n.codec.encode(t[n.key],n.bitLength)})),o}}],(t=null)&&S(n.prototype,t),r&&S(n,r),e}();E.fieldMap=[{key:"version",codec:l,bitLength:6},{key:"created",codec:c,bitLength:36},{key:"lastUpdated",codec:c,bitLength:36},{key:"cmpId",codec:l,bitLength:12},{key:"cmpVersion",codec:l,bitLength:12},{key:"consentScreen",codec:l,bitLength:6},{key:"consentLanguage",codec:f,bitLength:12},{key:"vendorListVersion",codec:l,bitLength:12},{key:"tcfPolicyVersion",codec:l,bitLength:6},{key:"isServiceSpecific",codec:p,bitLength:1},{key:"useNonStandardStacks",codec:p,bitLength:1},{key:"specialFeatureOptIns",codec:v,bitLength:12},{key:"purpose",children:[{key:"consents",codec:v,bitLength:24},{key:"legitimateInterests",codec:v,bitLength:24}]},{key:"purposeOneTreatment",codec:p,bitLength:1},{key:"publisherCC",codec:f,bitLength:12},{key:"vendor",children:[{key:"consents",codec:w},{key:"legitimateInterests",codec:w}]},{key:"numPubRestrictions",codec:l,bitLength:12}];var C=function(e){return e&&decodeURIComponent(document.cookie.replace(new RegExp("(?:(?:^|.*;)\\s*"+encodeURIComponent(e).replace(/[\-\.\+\*]/g,"\\$&")+"\\s*\\=\\s*([^;]*).*$)|^.*$"),"$1"))||null},L=r(843);var A=function e(n){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e),this.version=2,this.created=new Date,this.lastUpdated=this.created,this.cmpId=L.zq,this.cmpVersion=1,this.consentScreen=0,this.consentLanguage=n.consentLanguage,this.vendorListVersion=n.gvlVersion,this.tcfPolicyVersion=2,this.isServiceSpecific=!0,this.useNonStandardStacks=!1,this.specialFeatureOptIns={},this.purpose={consents:{},legitimateInterests:L.hA},this.purposeOneTreatment=!0,this.publisherCC="US",this.vendor={consents:{},legitimateInterests:n.vendorsLegInterest},this.numPubRestrictions=0};function P(e,n){for(var t=0;t<n.length;t++){var o=n[t];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}new(function(){function t(){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,t),this.config=this.loadConfiguration(),r.p=this.config.modulePath,this.acceptAllHandler=this.acceptAllHandler.bind(this),this.rejectAllHandler=this.rejectAllHandler.bind(this),this.saveHandler=this.saveHandler.bind(this),this.fetchGlobalVendorListHandler=this.fetchGlobalVendorListHandler.bind(this),this.model={},this.listeners=[],this.eventStatus=L.d6.UI_SHOWN,this.displayStatus=L.Uq.VISIBLE,this.cmpStatus=L.j4.LOADED,this.init()}var i,l,u;return i=t,(l=[{key:"init",value:function(){var e=this,n=C(L.B$);n?(this.model=E.deserialize(n),this.eventStatus=L.d6.LOADED,this.displayStatus=L.Uq.DISABLED):(this.model=new A(this.config),document.addEventListener("DOMContentLoaded",(function(){e.renderApp(L.pM.BANNER),e.bumpStat("wordads_cmp_view","no_cookie")})));var t=window.__tcfapi("getQueue");window.__tcfapi=this.commandHandler.bind(this),t.forEach((function(n){window.__tcfapi.apply(e,n)})),this.notify(this.model)}},{key:"loadConfiguration",value:function(){var e=JSON.parse(document.getElementById("cmp-configuration").innerText);return{gvlVersion:parseInt(e.gvlVersion),consentLanguage:e.consentLanguage,locale:e.locale,vendorsAll:w.decode(o.decode(e.vendorsAll)).value,vendorsLegInterest:w.decode(o.decode(e.vendorsLegInterest)).value,ajaxNonce:e.ajaxNonce,modulePath:e.modulePath,_:e._}}},{key:"getAppContainer",value:function(){var e="cmp-app-container",n=document.getElementById(e);return n||((n=document.createElement("div")).id=e,document.body.appendChild(n),n)}},{key:"renderApp",value:function(t){var o=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=(0,n.Vo)((function(){return r.e(143).then(r.bind(r,334))}));(0,e.sY)((0,e.h)(n.n4,null,(0,e.h)(i,{model:this.model,acceptAll:this.acceptAllHandler,rejectAll:this.rejectAllHandler,save:this.saveHandler,fetchGlobalVendorList:this.fetchGlobalVendorListHandler,path:this.config.modulePath,_:this.config._,mode:t,closable:o})),this.getAppContainer())}},{key:"showUi",value:function(){this.displayStatus!==L.Uq.VISIBLE&&(this.renderApp(L.pM.MODAL,!0),this.bumpStat("wordads_cmp_view","cookie"))}},{key:"bumpStat",value:function(e,n){var t={};t["x_"+e]=n,window._stq=window._stq||[],window._stq.push(["extra",t])}},{key:"setConsentCookie",value:function(e){var n,t=new XMLHttpRequest;t.open("POST","/wp-admin/admin-ajax.php",!0),t.setRequestHeader("Content-Type","application/x-www-form-urlencoded; charset=UTF-8"),(e=null!==(n=e)&&void 0!==n?n:{}).action="gdpr_set_consent",e.security=this.config.ajaxNonce,e.consent=E.serialize(this.model);var o=Object.keys(e).map((function(n){return n+"="+encodeURIComponent(e[n])})).join("&");t.send(o)}},{key:"fetchGlobalVendorListHandler",value:function(){var e=this,n=new XMLHttpRequest;return new Promise((function(t,o){n.onreadystatechange=function(){4===n.readyState&&(200===this.status?t(JSON.parse(this.response)):o({status:n.status,statusText:n.statusText}))},n.open("GET","https://public-api.wordpress.com/wpcom/v2/cmp/gvl/"+e.config.locale+"/",!0),n.send()}))}},{key:"acceptAllHandler",value:function(){this.model.vendorListVersion=this.config.gvlVersion,this.model.lastUpdated=new Date,this.model.purpose={consents:L.a3,legitimateInterests:L.hA},this.model.vendor={consents:this.config.vendorsAll,legitimateInterests:this.config.vendorsLegInterest},this.eventStatus=L.d6.USER_ACTION_COMPLETE,this.displayStatus=L.Uq.HIDDEN,this.notify(),this.setConsentCookie({type:"accept_all"})}},{key:"rejectAllHandler",value:function(){this.model.vendorListVersion=this.config.gvlVersion,this.model.lastUpdated=new Date,this.model.purpose={consents:{},legitimateInterests:L.hA},this.model.vendor={consents:{},legitimateInterests:this.config.vendorsLegInterest},this.eventStatus=L.d6.USER_ACTION_COMPLETE,this.displayStatus=L.Uq.HIDDEN,this.notify(),this.setConsentCookie({type:"reject_all"})}},{key:"saveHandler",value:function(e){this.model=e,this.model.vendorListVersion=this.config.gvlVersion,this.model.lastUpdated=new Date,this.eventStatus=L.d6.USER_ACTION_COMPLETE,this.displayStatus=L.Uq.HIDDEN,this.notify(),this.setConsentCookie({type:"custom"})}},{key:"getTCData",value:function(){return{tcString:E.serialize(this.model),tcfPolicyVersion:this.model.tcfPolicyVersion,cmpId:this.model.cmpId,cmpVersion:this.model.cmpVersion,gdprApplies:!0,eventStatus:this.eventStatus,cmpStatus:this.cmpStatus,isServiceSpecific:this.model.isServiceSpecific,useNonStandardStacks:this.model.useNonStandardStacks,publisherCC:this.model.publisherCC,purposeOneTreatment:this.model.purposeOneTreatment,purpose:this.model.purpose,vendor:this.model.vendor,specialFeatureOptIns:this.model.specialFeatureOptIns}}},{key:"notify",value:function(){var e=this.getTCData();this.listeners.forEach((function(n){e.listenerId=n.listenerId,n.callback(e,!0)}))}},{key:"addListener",value:function(e){var n=Math.floor(999999*Math.random()),t={listenerId:n,callback:e};return this.listeners.push(t),n}},{key:"removeListener",value:function(e){this.listeners=this.listeners.filter((function(n){return n.listenerId!==e}))}},{key:"commandHandler",value:function(){var e=arguments.length<=0?void 0:arguments[0],n=arguments.length<=2?void 0:arguments[2],t=arguments.length<=3?void 0:arguments[3];if("ping"===e){var o={gdprApplies:!0,cmpLoaded:!0,cmpStatus:this.cmpStatus,displayStatus:this.displayStatus,apiVersion:"2",cmpVersion:this.model.cmpVersion,cmpId:this.model.cmpId,gvlVersion:this.model.vendorListVersion,tcfPolicyVersion:this.model.tcfPolicyVersion};"function"==typeof n&&n(o,!0)}else if("addEventListener"===e){var r=this.addListener(n),i={listenerId:r};n(i,!0)}else"removeEventListener"===e?(this.removeListener(t),n(!0)):"getTCData"===e?"function"==typeof n&&n(this.getTCData(),!0):"showUi"===e&&this.showUi()}}])&&P(i.prototype,l),u&&P(i,u),t}())}()}();;
/* globals JSON */
( function () {
	var eventName = 'wpcom_masterbar_click';

	var linksTracksEvents = {
		// top level items
		'wp-admin-bar-blog'                        : 'my_sites',
		'wp-admin-bar-newdash'                     : 'reader',
		'wp-admin-bar-ab-new-post'                 : 'write_button',
		'wp-admin-bar-my-account'                  : 'my_account',
		'wp-admin-bar-notes'                       : 'notifications',
		// my sites - top items
		'wp-admin-bar-switch-site'                 : 'my_sites_switch_site',
		'wp-admin-bar-blog-info'                   : 'my_sites_site_info',
		'wp-admin-bar-site-view'                   : 'my_sites_view_site',
		'wp-admin-bar-blog-stats'                  : 'my_sites_site_stats',
		'wp-admin-bar-plan'                        : 'my_sites_plan',
		'wp-admin-bar-plan-badge'                  : 'my_sites_plan_badge',
		// my sites - manage
		'wp-admin-bar-edit-page'                   : 'my_sites_manage_site_pages',
		'wp-admin-bar-new-page-badge'              : 'my_sites_manage_add_page',
		'wp-admin-bar-edit-post'                   : 'my_sites_manage_blog_posts',
		'wp-admin-bar-new-post-badge'              : 'my_sites_manage_add_post',
		'wp-admin-bar-edit-attachment'             : 'my_sites_manage_media',
		'wp-admin-bar-new-attachment-badge'        : 'my_sites_manage_add_media',
		'wp-admin-bar-comments'                    : 'my_sites_manage_comments',
		'wp-admin-bar-edit-jetpack-testimonial'    : 'my_sites_manage_testimonials',
		'wp-admin-bar-new-jetpack-testimonial'     : 'my_sites_manage_add_testimonial',
		'wp-admin-bar-edit-jetpack-portfolio'      : 'my_sites_manage_portfolio',
		'wp-admin-bar-new-jetpack-portfolio'       : 'my_sites_manage_add_portfolio',
		// my sites - personalize
		'wp-admin-bar-themes'                      : 'my_sites_personalize_themes',
		'wp-admin-bar-cmz'                         : 'my_sites_personalize_themes_customize',
		// my sites - configure
		'wp-admin-bar-sharing'                     : 'my_sites_configure_sharing',
		'wp-admin-bar-people'                      : 'my_sites_configure_people',
		'wp-admin-bar-people-add'                  : 'my_sites_configure_people_add_button',
		'wp-admin-bar-plugins'                     : 'my_sites_configure_plugins',
		'wp-admin-bar-domains'                     : 'my_sites_configure_domains',
		'wp-admin-bar-domains-add'                 : 'my_sites_configure_add_domain',
		'wp-admin-bar-blog-settings'               : 'my_sites_configure_settings',
		'wp-admin-bar-legacy-dashboard'            : 'my_sites_configure_wp_admin',
		// reader
		'wp-admin-bar-followed-sites'              : 'reader_followed_sites',
		'wp-admin-bar-reader-followed-sites-manage': 'reader_manage_followed_sites',
		'wp-admin-bar-discover-discover'           : 'reader_discover',
		'wp-admin-bar-discover-search'             : 'reader_search',
		'wp-admin-bar-my-activity-my-likes'        : 'reader_my_likes',
		// account
		'wp-admin-bar-user-info'                   : 'my_account_user_name',
		// account - profile
		'wp-admin-bar-my-profile'                  : 'my_account_profile_my_profile',
		'wp-admin-bar-account-settings'            : 'my_account_profile_account_settings',
		'wp-admin-bar-billing'                     : 'my_account_profile_manage_purchases',
		'wp-admin-bar-security'                    : 'my_account_profile_security',
		'wp-admin-bar-notifications'               : 'my_account_profile_notifications',
		// account - special
		'wp-admin-bar-get-apps'                    : 'my_account_special_get_apps',
		'wp-admin-bar-next-steps'                  : 'my_account_special_next_steps',
		'wp-admin-bar-help'                        : 'my_account_special_help',
	};

	var notesTracksEvents = {
		openSite: function ( data ) {
			return {
				clicked: 'masterbar_notifications_panel_site',
				site_id: data.siteId
			};
		},
		openPost: function ( data ) {
			return {
				clicked: 'masterbar_notifications_panel_post',
				site_id: data.siteId,
				post_id: data.postId
			};
		},
		openComment: function ( data ) {
			return {
				clicked: 'masterbar_notifications_panel_comment',
				site_id: data.siteId,
				post_id: data.postId,
				comment_id: data.commentId
			};
		}
	};

	// Element.prototype.matches as a standalone function, with old browser fallback
	function matches( node, selector ) {
		if ( ! node ) {
			return undefined;
		}

		if ( ! Element.prototype.matches && ! Element.prototype.msMatchesSelector ) {
			throw new Error( 'Unsupported browser' );
		}

		return Element.prototype.matches ? node.matches( selector ) : node.msMatchesSelector( selector );
	}

	// Element.prototype.closest as a standalone function, with old browser fallback
	function closest( node, selector ) {
		if ( ! node ) {
			return undefined;
		}

		if ( Element.prototype.closest ) {
			return node.closest( selector );
		}

		do {
			if ( matches( node, selector ) ) {
				return node;
			}

			node = node.parentElement || node.parentNode;
		} while ( node !== null && node.nodeType === 1 );

		return null;
	}

	function recordTracksEvent( eventProps ) {
		eventProps = eventProps || {};
		window._tkq = window._tkq || [];
		window._tkq.push( [ 'recordEvent', eventName, eventProps ] );
	}

	function parseJson( s, defaultValue ) {
		try {
			return JSON.parse( s );
		} catch ( e ) {
			return defaultValue;
		}
	}

	function createTrackableLinkEventHandler( link ) {
		return function () {
			var parent = closest( link, 'li' );

			if ( ! parent ) {
				return;
			}

			var trackingId = link.getAttribute( 'ID' ) || parent.getAttribute( 'ID' );

			if ( ! linksTracksEvents.hasOwnProperty( trackingId ) ) {
				return;
			}

			var eventProps = { 'clicked': linksTracksEvents[ trackingId ] };
			recordTracksEvent( eventProps );
		}
	}

	function init() {
		var trackableLinkSelector = '.mb-trackable .ab-item:not(div),' +
			'#wp-admin-bar-notes .ab-item,' +
			'#wp-admin-bar-user-info .ab-item,' +
			'.mb-trackable .ab-secondary';

		var trackableLinks = document.querySelectorAll( trackableLinkSelector );

		for ( var i = 0; i < trackableLinks.length; i++ ) {
			var link = trackableLinks[ i ];
			var handler = createTrackableLinkEventHandler( link );

			link.addEventListener( 'click', handler );
			link.addEventListener( 'touchstart', handler );
		}
	}

	if ( document.readyState === 'loading' ) {
		document.addEventListener( 'DOMContentLoaded', init );
	} else {
		init();
	}

	// listen for postMessage events from the notifications iframe
	window.addEventListener( 'message', function ( event ) {
		if ( event.origin !== 'https://widgets.wp.com' ) {
			return;
		}

		var data = ( typeof event.data === 'string' ) ? parseJson( event.data, {} ) : event.data;
		if ( data.type !== 'notesIframeMessage' ) {
			return;
		}

		var eventData = notesTracksEvents[ data.action ];
		if ( ! eventData ) {
			return;
		}

		recordTracksEvent( eventData( data ) );
	}, false );

} )();
;
/*! This file is auto-generated */
!function(c,d){"use strict";var e=!1,n=!1;if(d.querySelector)if(c.addEventListener)e=!0;if(c.wp=c.wp||{},!c.wp.receiveEmbedMessage)if(c.wp.receiveEmbedMessage=function(e){var t=e.data;if(t)if(t.secret||t.message||t.value)if(!/[^a-zA-Z0-9]/.test(t.secret)){for(var r,a,i,s=d.querySelectorAll('iframe[data-secret="'+t.secret+'"]'),n=d.querySelectorAll('blockquote[data-secret="'+t.secret+'"]'),o=0;o<n.length;o++)n[o].style.display="none";for(o=0;o<s.length;o++)if(r=s[o],e.source===r.contentWindow){if(r.removeAttribute("style"),"height"===t.message){if(1e3<(i=parseInt(t.value,10)))i=1e3;else if(~~i<200)i=200;r.height=i}if("link"===t.message)if(a=d.createElement("a"),i=d.createElement("a"),a.href=r.getAttribute("src"),i.href=t.value,i.host===a.host)if(d.activeElement===r)c.top.location.href=t.value}}},e)c.addEventListener("message",c.wp.receiveEmbedMessage,!1),d.addEventListener("DOMContentLoaded",t,!1),c.addEventListener("load",t,!1);function t(){if(!n){n=!0;for(var e,t,r=-1!==navigator.appVersion.indexOf("MSIE 10"),a=!!navigator.userAgent.match(/Trident.*rv:11\./),i=d.querySelectorAll("iframe.wp-embedded-content"),s=0;s<i.length;s++){if(!(e=i[s]).getAttribute("data-secret"))t=Math.random().toString(36).substr(2,10),e.src+="#?secret="+t,e.setAttribute("data-secret",t);if(r||a)(t=e.cloneNode(!0)).removeAttribute("security"),e.parentNode.replaceChild(t,e)}}}}(window,document);;