//Class simulation - invokes Class::initialize()
if( !( Class ) ) {
	var Class = {
		create: function( inheritFrom ){
			if( typeof inheritFrom == 'object' ) {
				Object.extend( this,inheritFrom );
			}
			return function(){
				this.initialize.apply( this,arguments );
			}
		}
	}
}

//Events controller - uses addEventListener or attachEvent with respect to the browser
if( !window.event )
	var Event = {};

Event.observe = function( element, eventname, handler ){
	el = document.getElementById(element);
	if(!el){
		throw('Event.observe(): object does not exist');
		return;
	}
	if(el.addEventListener){
		el.addEventListener(eventname,handler,false);
	}
	else if(el.attachEvent){
		el.attachEvent("on"+eventname,handler);
	}
	else{
		var e="on"+eventname;el.e=handler;
	}
}

//Cookie controller
var Cookie = {
	set: function(name,value,daysToExpire){
		var expire='';
		if(daysToExpire!=undefined){
			var d=new Date();
			d.setTime(d.getTime()+(86400000*parseFloat(daysToExpire)));
			expire='; expires='+d.toGMTString();
		}
		return(document.cookie = escape(name)+'='+escape(value||'')+expire);
	},
	get: function(name){
		var cookie = document.cookie.match(new RegExp('(^|;)\\s*'+escape(name)+'=([^;\\s]*)'));
		return( cookie ? unescape(cookie[2]) : null);
	},
	erase: function(name){
		var cookie=Cookie.get(name)||true;
		Cookie.set(name,'',-1);
		return cookie;
	},
	accept:function(){
		if(typeof navigator.cookieEnabled=='boolean'){
			return navigator.cookieEnabled;
		}
		Cookie.set('_test','1');
		return(Cookie.erase('_test')==='1');
	}
};

Object.extend = function(destination,source){
	for(var property in source)
		destination[property]=source[property];
	return destination;
};

window.scrollToAnimated=function(x,y){
	var initY=stepY=window.scrollY;
	var step=30;
	var interval=setInterval(function(){
		if( y > stepY + step ){
			stepY += step;
			window.scrollTo(x,stepY);
		}
		else{
			window.scrollTo(x,y);
			clearInterval(interval)
		}
	},25);
}

//Registry class - use it for global scope object
var Registry = {
	objects: {},
	getObject: function( id ){
		if( this.objects[id] )
			return this.objects[id]
		return;
	},
	setObject: function( id, content ){
		this.objects[id] = content;
	}
}