/* Minification failed. Returning unminified contents.
(11161,69-70): run-time error JS1100: Expected ',': =
(14125,42-43): run-time error JS1014: Invalid character: `
(14125,43-44): run-time error JS1195: Expected expression: <
(14125,183-184): run-time error JS1195: Expected expression: <
(14125,192-193): run-time error JS1014: Invalid character: `
(14128,50-51): run-time error JS1014: Invalid character: `
(14128,51-52): run-time error JS1195: Expected expression: <
(14128,131-166): run-time error JS1197: Too many errors. The file might not be a JavaScript file: "${employeeData[i].children[j].id}"
 */
/*!
 * jQuery Validation Plugin v1.13.1
 *
 * http://jqueryvalidation.org/
 *
 * Copyright (c) 2014 Jörn Zaefferer
 * Released under the MIT license
 */
; (function (factory) {
    if (typeof define === "function" && define.amd) {
        define(["jquery"], factory);
    } else {
        factory(jQuery);
    }
}(function (jQuery) {

    $.extend($.fn, {
        // http://jqueryvalidation.org/validate/
        validate: function (options) {

            // if nothing is selected, return nothing; can't chain anyway
            if (!this.length) {
                if (options && options.debug && window.console) {
                    console.warn("Nothing selected, can't validate, returning nothing.");
                }
                return;
            }

            // check if a validator for this form was already created
            var validator = $.data(this[0], "validator");
            if (validator) {
                return validator;
            }

            // Add novalidate tag if HTML5.
            this.attr("novalidate", "novalidate");

            validator = new $.validator(options, this[0]);
            $.data(this[0], "validator", validator);

            if (validator.settings.onsubmit) {

                this.validateDelegate(":submit", "click", function (event) {
                    if (validator.settings.submitHandler) {
                        validator.submitButton = event.target;
                    }
                    // allow suppressing validation by adding a cancel class to the submit button
                    if ($(event.target).hasClass("cancel")) {
                        validator.cancelSubmit = true;
                    }

                    // allow suppressing validation by adding the html5 formnovalidate attribute to the submit button
                    if ($(event.target).attr("formnovalidate") !== undefined) {
                        validator.cancelSubmit = true;
                    }
                });

                // validate the form on submit
                this.submit(function (event) {
                    if (validator.settings.debug) {
                        // prevent form submit to be able to see console output
                        event.preventDefault();
                    }
                    function handle() {
                        var hidden, result;
                        if (validator.settings.submitHandler) {
                            if (validator.submitButton) {
                                // insert a hidden input as a replacement for the missing submit button
                                hidden = $("<input type='hidden'/>")
                                    .attr("name", validator.submitButton.name)
                                    .val($(validator.submitButton).val())
                                    .appendTo(validator.currentForm);
                            }
                            result = validator.settings.submitHandler.call(validator, validator.currentForm, event);
                            if (validator.submitButton) {
                                // and clean up afterwards; thanks to no-block-scope, hidden can be referenced
                                hidden.remove();
                            }
                            if (result !== undefined) {
                                return result;
                            }
                            return false;
                        }
                        return true;
                    }

                    // prevent submit for invalid forms or custom submit handlers
                    if (validator.cancelSubmit) {
                        validator.cancelSubmit = false;
                        return handle();
                    }
                    if (validator.form()) {
                        if (validator.pendingRequest) {
                            validator.formSubmitted = true;
                            return false;
                        }
                        return handle();
                    } else {
                        validator.focusInvalid();
                        return false;
                    }
                });
            }

            return validator;
        },
        // http://jqueryvalidation.org/valid/
        valid: function () {
            var valid, validator;

            //if ( $( this[ 0 ] ).is( "form" ) ) {
            valid = this.validate().form();
            //} else {
            //	valid = true;
            //    //validator = $( this[ 0 ].form ).validate();
            //	validator = $(this[0]).validate();
            //	this.each( function() {
            //		valid = validator.element( this ) && valid;
            //	});
            //}
            return valid;
        },
        // attributes: space separated list of attributes to retrieve and remove
        removeAttrs: function (attributes) {
            var result = {},
                $element = this;
            $.each(attributes.split(/\s/), function (index, value) {
                result[value] = $element.attr(value);
                $element.removeAttr(value);
            });
            return result;
        },
        // http://jqueryvalidation.org/rules/
        rules: function (command, argument) {
            var element = this[0],
                settings, staticRules, existingRules, data, param, filtered;

            if (command) {
                //settings = $.data( element.form, "validator" ).settings;
                settings = $.data($(element).closest("[data-type=validcontainer]")[0], "validator").settings;
                staticRules = settings.rules;
                existingRules = $.validator.staticRules(element);
                switch (command) {
                    case "add":
                        $.extend(existingRules, $.validator.normalizeRule(argument));
                        // remove messages from rules, but allow them to be set separately
                        delete existingRules.messages;
                        staticRules[element.name] = existingRules;
                        if (argument.messages) {
                            settings.messages[element.name] = $.extend(settings.messages[element.name], argument.messages);
                        }
                        break;
                    case "remove":
                        if (!argument) {
                            delete staticRules[element.name];
                            return existingRules;
                        }
                        filtered = {};
                        $.each(argument.split(/\s/), function (index, method) {
                            filtered[method] = existingRules[method];
                            delete existingRules[method];
                            if (method === "required") {
                                $(element).removeAttr("aria-required");
                            }
                        });
                        return filtered;
                }
            }

            data = $.validator.normalizeRules(
            $.extend(
                {},
                $.validator.classRules(element),
                $.validator.attributeRules(element),
                $.validator.dataRules(element),
                $.validator.staticRules(element)
            ), element);

            // make sure required is at front
            if (data.required) {
                param = data.required;
                delete data.required;
                data = $.extend({ required: param }, data);
                $(element).attr("aria-required", "true");
            }

            // make sure remote is at back
            if (data.remote) {
                param = data.remote;
                delete data.remote;
                data = $.extend(data, { remote: param });
            }

            return data;
        }
    });

    // Custom selectors
    $.extend($.expr[":"], {
        // http://jqueryvalidation.org/blank-selector/
        blank: function (a) {
            return !$.trim("" + $(a).val());
        },
        // http://jqueryvalidation.org/filled-selector/
        filled: function (a) {
            return !!$.trim("" + $(a).val());
        },
        // http://jqueryvalidation.org/unchecked-selector/
        unchecked: function (a) {
            return !$(a).prop("checked");
        }
    });

    // constructor for validator
    $.validator = function (options, form) {
        this.settings = $.extend(true, {}, $.validator.defaults, options);
        this.currentForm = form;
        this.init();
    };

    // http://jqueryvalidation.org/jQuery.validator.format/
    $.validator.format = function (source, params) {
        if (arguments.length === 1) {
            return function () {
                var args = $.makeArray(arguments);
                args.unshift(source);
                return $.validator.format.apply(this, args);
            };
        }
        if (arguments.length > 2 && params.constructor !== Array) {
            params = $.makeArray(arguments).slice(1);
        }
        if (params.constructor !== Array) {
            params = [params];
        }
        $.each(params, function (i, n) {
            source = source.replace(new RegExp("\\{" + i + "\\}", "g"), function () {
                return n;
            });
        });
        return source;
    };

    $.extend($.validator, {

        defaults: {
            messages: {},
            groups: {},
            rules: {},
            errorClass: "errorInput",
            validClass: "valid",
            errorElement: "label",
            focusCleanup: false,
            focusInvalid: true,
            errorContainer: $([]),
            errorLabelContainer: $([]),
            onsubmit: true,
            ignore: ":hidden",
            ignoreTitle: false,
            onfocusin: function (element) {
                this.lastActive = element;

                // Hide error label and remove error class on focus if enabled
                if (this.settings.focusCleanup) {
                    if (this.settings.unhighlight) {
                        this.settings.unhighlight.call(this, element, this.settings.errorClass, this.settings.validClass);
                    }
                    this.hideThese(this.errorsFor(element));
                }
            },
            onfocusout: function (element) {
                if (!this.checkable(element) && (element.name in this.submitted || !this.optional(element))) {
                    this.element(element);
                }
            },
            onkeyup: function (element, event) {
                if (event.which === 9 && this.elementValue(element) === "") {
                    return;
                } else if (element.name in this.submitted || element === this.lastElement) {
                    this.element(element);
                }
            },
            onclick: function (element) {
                // click on selects, radiobuttons and checkboxes
                if (element.name in this.submitted) {
                    this.element(element);

                    // or option elements, check parent select in that case
                } else if (element.parentNode.name in this.submitted) {
                    this.element(element.parentNode);
                }
            },
            highlight: function (element, errorClass, validClass) {
                if (element.type === "radio") {
                    this.findByName(element.name).addClass(errorClass).removeClass(validClass);
                } else {
                    if ($(element).parent().hasClass('dropdowndiv'))
                    {
                        $(element).parent().addClass(errorClass).removeClass(validClass);
                    }
                    else {
                        $(element).addClass(errorClass).removeClass(validClass);
                    }
                }
            },
            unhighlight: function (element, errorClass, validClass) {
                if (element.type === "radio") {
                    this.findByName(element.name).removeClass(errorClass).addClass(validClass);
                } else {
                    if ($(element).parent().hasClass('dropdowndiv')) {
                        $(element).parent().removeClass(errorClass).addClass(validClass);
                    }
                    else {
                        $(element).removeClass(errorClass).addClass(validClass);
                    }
                }
            }
        },

        // http://jqueryvalidation.org/jQuery.validator.setDefaults/
        setDefaults: function (settings) {
            $.extend($.validator.defaults, settings);
        },

        messages: {
            required: "required.",
            remote: "Please fix this field.",
            email: "Please enter a valid email address.",
            url: "Please enter a valid URL.",
            date: "Please enter a valid date.",
            dateISO: "Please enter a valid date ( ISO ).",
            number: "Please enter a valid number.",
            digits: "Please enter only digits.",
            creditcard: "Please enter a valid credit card number.",
            equalTo: "Please enter the same value again.",
            maxlength: $.validator.format("Please enter no more than {0} characters."),
            minlength: $.validator.format("Please enter at least {0} characters."),
            rangelength: $.validator.format("Please enter a value between {0} and {1} characters long."),
            range: $.validator.format("Please enter a value between {0} and {1}."),
            max: $.validator.format("Please enter a value less than or equal to {0}."),
            min: $.validator.format("Please enter a value greater than or equal to {0}.")
        },

        autoCreateRanges: false,

        prototype: {

            init: function () {
                this.labelContainer = $(this.settings.errorLabelContainer);
                this.errorContext = this.labelContainer.length && this.labelContainer || $(this.currentForm);
                this.containers = $(this.settings.errorContainer).add(this.settings.errorLabelContainer);
                this.submitted = {};
                this.valueCache = {};
                this.pendingRequest = 0;
                this.pending = {};
                this.invalid = {};
                this.reset();

                var groups = (this.groups = {}),
                    rules;
                $.each(this.settings.groups, function (key, value) {
                    if (typeof value === "string") {
                        value = value.split(/\s/);
                    }
                    $.each(value, function (index, name) {
                        groups[name] = key;
                    });
                });
                rules = this.settings.rules;
                $.each(rules, function (key, value) {
                    rules[key] = $.validator.normalizeRule(value);
                });

                function delegate(event) {
                    //var validator = $.data( this[ 0 ].form, "validator" ),
                    var validator = $.data($(this[0]).closest("[data-type=validcontainer]")[0], "validator"),
                        eventType = "on" + event.type.replace(/^validate/, ""),
                        settings = validator.settings;
                    // this fixes handling the deleted validator:
                    if (!validator) return;
                    if (settings[eventType] && !this.is(settings.ignore)) {
                        settings[eventType].call(validator, this[0], event);
                    }
                }
                $(this.currentForm)
                    .validateDelegate(":text, [type='password'], [type='file'], select, textarea, " +
                        "[type='number'], [type='search'] ,[type='tel'], [type='url'], " +
                        "[type='email'], [type='datetime'], [type='date'], [type='month'], " +
                        "[type='week'], [type='time'], [type='datetime-local'], " +
                        "[type='range'], [type='color'], [type='radio'], [type='checkbox']",
                        "focusin focusout keyup", delegate)
                    // Support: Chrome, oldIE
                    // "select" is provided as event.target when clicking a option
                    .validateDelegate("select, option, [type='radio'], [type='checkbox']", "click", delegate);

                if (this.settings.invalidHandler) {
                    $(this.currentForm).bind("invalid-form.validate", this.settings.invalidHandler);
                }

                // Add aria-required to any Static/Data/Class required fields before first validation
                // Screen readers require this attribute to be present before the initial submission http://www.w3.org/TR/WCAG-TECHS/ARIA2.html
                $(this.currentForm).find("[required], [data-rule-required], .required").attr("aria-required", "true");
            },

            // http://jqueryvalidation.org/Validator.form/
            form: function () {
                this.checkForm();
                $.extend(this.submitted, this.errorMap);
                this.invalid = $.extend({}, this.errorMap);
                if (!this.valid()) {
                    $(this.currentForm).triggerHandler("invalid-form", [this]);
                }
                this.showErrors();
                return this.valid();
            },

            checkForm: function () {
                this.prepareForm();
                for (var i = 0, elements = (this.currentElements = this.elements()) ; elements[i]; i++) {
                    this.check(elements[i]);
                }
                return this.valid();
            },

            // http://jqueryvalidation.org/Validator.element/
            element: function (element) {
                var cleanElement = this.clean(element),
                    checkElement = this.validationTargetFor(cleanElement),
                    result = true;

                this.lastElement = checkElement;

                if (checkElement === undefined) {
                    delete this.invalid[cleanElement.name];
                } else {
                    this.prepareElement(checkElement);
                    this.currentElements = $(checkElement);

                    result = this.check(checkElement) !== false;
                    if (result) {
                        delete this.invalid[checkElement.name];
                    } else {
                        this.invalid[checkElement.name] = true;
                    }
                }
                // Add aria-invalid status for screen readers
                $(element).attr("aria-invalid", !result);

                if (!this.numberOfInvalids()) {
                    // Hide error containers on last error
                    this.toHide = this.toHide.add(this.containers);
                }
                this.showErrors();
                return result;
            },

            // http://jqueryvalidation.org/Validator.showErrors/
            showErrors: function (errors) {
                if (errors) {
                    // add items to error list and map
                    $.extend(this.errorMap, errors);
                    this.errorList = [];
                    for (var name in errors) {
                        this.errorList.push({
                            message: errors[name],
                            element: this.findByName(name)[0]
                        });
                    }
                    // remove items from success list
                    this.successList = $.grep(this.successList, function (element) {
                        return !(element.name in errors);
                    });
                }
                if (this.settings.showErrors) {
                    this.settings.showErrors.call(this, this.errorMap, this.errorList);
                } else {
                    this.defaultShowErrors();
                }
            },

            // http://jqueryvalidation.org/Validator.resetForm/
            resetForm: function () {
                if ($.fn.resetForm) {
                    $(this.currentForm).resetForm();
                }
                this.submitted = {};
                this.lastElement = null;
                this.prepareForm();
                this.hideErrors();
                this.elements()
                        .removeClass(this.settings.errorClass)
                        .removeData("previousValue")
                        .removeAttr("aria-invalid");
                if (this.elements().parent().hasClass('dropdowndiv')) {
                    this.elements().parent().removeClass(this.settings.errorClass);
                }
            },

            numberOfInvalids: function () {
                return this.objectLength(this.invalid);
            },

            objectLength: function (obj) {
                /* jshint unused: false */
                var count = 0,
                    i;
                for (i in obj) {
                    count++;
                }
                return count;
            },

            hideErrors: function () {
                this.hideThese(this.toHide);
            },

            hideThese: function (errors) {
                errors.not(this.containers).text("");
                this.addWrapper(errors).hide();
            },

            valid: function () {
                return this.size() === 0;
            },

            size: function () {
                return this.errorList.length;
            },

            focusInvalid: function () {
                if (this.settings.focusInvalid) {
                    try {
                        $(this.findLastActive() || this.errorList.length && this.errorList[0].element || [])
                        .filter(":visible")
                        .focus()
                        // manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find
                        .trigger("focusin");
                    } catch (e) {
                        // ignore IE throwing errors when focusing hidden elements
                    }
                }
            },

            findLastActive: function () {
                var lastActive = this.lastActive;
                return lastActive && $.grep(this.errorList, function (n) {
                    return n.element.name === lastActive.name;
                }).length === 1 && lastActive;
            },

            elements: function () {
                var validator = this,
                    rulesCache = {};

                // select all valid inputs inside the form (no submit or reset buttons)
                return $(this.currentForm)
                .find("input, select, textarea")
                .not(":submit, :reset, :image, [disabled], [readonly]")
                .not(this.settings.ignore)
                .filter(function () {
                    if (!this.name && validator.settings.debug && window.console) {
                        console.error("%o has no name assigned", this);
                    }

                    // select only the first element for each name, and only those with rules specified
                    if (this.name in rulesCache || !validator.objectLength($(this).rules())) {
                        return false;
                    }

                    rulesCache[this.name] = true;
                    return true;
                });
            },

            clean: function (selector) {
                return $(selector)[0];
            },

            errors: function () {
                var errorClass = this.settings.errorClass.split(" ").join(".");
                return $(this.settings.errorElement + "." + errorClass, this.errorContext);
            },

            reset: function () {
                this.successList = [];
                this.errorList = [];
                this.errorMap = {};
                this.toShow = $([]);
                this.toHide = $([]);
                this.currentElements = $([]);
            },

            prepareForm: function () {
                this.reset();
                this.toHide = this.errors().add(this.containers);
            },

            prepareElement: function (element) {
                this.reset();
                this.toHide = this.errorsFor(element);
            },

            elementValue: function (element) {
                var val,
                    $element = $(element),
                    type = element.type;

                if (type === "radio" || type === "checkbox") {
                    return $("input[name='" + element.name + "']:checked").val();
                } else if (type === "number" && typeof element.validity !== "undefined") {
                    return element.validity.badInput ? false : $element.val();
                }

                val = $element.val();
                if (typeof val === "string") {
                    return val.replace(/\r/g, "");
                }
                return val;
            },

            check: function (element) {
                element = this.validationTargetFor(this.clean(element));

                var rules = $(element).rules(),
                    rulesCount = $.map(rules, function (n, i) {
                        return i;
                    }).length,
                    dependencyMismatch = false,
                    val = this.elementValue(element),
                    result, method, rule;

                for (method in rules) {
                    rule = { method: method, parameters: rules[method] };
                    try {

                        result = $.validator.methods[method].call(this, val, element, rule.parameters);

                        // if a method indicates that the field is optional and therefore valid,
                        // don't mark it as valid when there are no other rules
                        if (result === "dependency-mismatch" && rulesCount === 1) {
                            dependencyMismatch = true;
                            continue;
                        }
                        dependencyMismatch = false;

                        if (result === "pending") {
                            this.toHide = this.toHide.not(this.errorsFor(element));
                            return;
                        }

                        if (!result) {
                            this.formatAndAdd(element, rule);
                            return false;
                        }
                    } catch (e) {
                        if (this.settings.debug && window.console) {
                            console.log("Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method.", e);
                        }
                        throw e;
                    }
                }
                if (dependencyMismatch) {
                    return;
                }
                if (this.objectLength(rules)) {
                    this.successList.push(element);
                }
                return true;
            },

            // return the custom message for the given element and validation method
            // specified in the element's HTML5 data attribute
            // return the generic message if present and no method specific message is present
            customDataMessage: function (element, method) {
                return $(element).data("msg" + method.charAt(0).toUpperCase() +
                    method.substring(1).toLowerCase()) || $(element).data("msg");
            },

            // return the custom message for the given element name and validation method
            customMessage: function (name, method) {
                var m = this.settings.messages[name];
                return m && (m.constructor === String ? m : m[method]);
            },

            // return the first defined argument, allowing empty strings
            findDefined: function () {
                for (var i = 0; i < arguments.length; i++) {
                    if (arguments[i] !== undefined) {
                        return arguments[i];
                    }
                }
                return undefined;
            },

            defaultMessage: function (element, method) {
                return this.findDefined(
                    this.customMessage(element.name, method),
                    this.customDataMessage(element, method),
                    // title is never undefined, so handle empty string as undefined
                    !this.settings.ignoreTitle && element.title || undefined,
                    $.validator.messages[method],
                    "<strong>Warning: No message defined for " + element.name + "</strong>"
                );
            },

            formatAndAdd: function (element, rule) {
                var message = this.defaultMessage(element, rule.method),
                    theregex = /\$?\{(\d+)\}/g;
                if (typeof message === "function") {
                    message = message.call(this, rule.parameters, element);
                } else if (theregex.test(message)) {
                    message = $.validator.format(message.replace(theregex, "{$1}"), rule.parameters);
                }
                this.errorList.push({
                    message: message,
                    element: element,
                    method: rule.method
                });

                this.errorMap[element.name] = message;
                this.submitted[element.name] = message;
            },

            addWrapper: function (toToggle) {
                if (this.settings.wrapper) {
                    toToggle = toToggle.add(toToggle.parent(this.settings.wrapper));
                }
                return toToggle;
            },

            defaultShowErrors: function () {
                var i, elements, error;
                for (i = 0; this.errorList[i]; i++) {
                    error = this.errorList[i];
                    if (this.settings.highlight) {
                        this.settings.highlight.call(this, error.element, this.settings.errorClass, this.settings.validClass);
                    }
                    this.showLabel(error.element, error.message);
                }
                if (this.errorList.length) {
                    this.toShow = this.toShow.add(this.containers);
                }
                if (this.settings.success) {
                    for (i = 0; this.successList[i]; i++) {
                        this.showLabel(this.successList[i]);
                    }
                }
                if (this.settings.unhighlight) {
                    for (i = 0, elements = this.validElements() ; elements[i]; i++) {
                        this.settings.unhighlight.call(this, elements[i], this.settings.errorClass, this.settings.validClass);
                    }
                }
                this.toHide = this.toHide.not(this.toShow);
                this.hideErrors();
                this.addWrapper(this.toShow).show();
            },

            validElements: function () {
                return this.currentElements.not(this.invalidElements());
            },

            invalidElements: function () {
                return $(this.errorList).map(function () {
                    return this.element;
                });
            },

            showLabel: function (element, message) {
                var place, group, errorID,
                    error = this.errorsFor(element),
                    elementID = this.idOrName(element),
                    describedBy = $(element).attr("aria-describedby");
                if (error.length) {
                    // refresh error/success class
                    error.removeClass(this.settings.validClass).addClass(this.settings.errorClass);
                    // replace message on existing label
                    error.html(message);
                } else {
                    // create error element
                    error = $("<" + this.settings.errorElement + ">")
                        .attr("id", elementID + "-error")
                        .addClass(this.settings.errorClass)
                        .html(message || "");

                    // Maintain reference to the element to be placed into the DOM
                    place = error;
                    if (this.settings.wrapper) {
                        // make sure the element is visible, even in IE
                        // actually showing the wrapped element is handled elsewhere
                        place = error.hide().show().wrap("<" + this.settings.wrapper + "/>").parent();
                    }
                    if (this.labelContainer.length) {
                        this.labelContainer.append(place);
                    } else if (this.settings.errorPlacement) {
                        this.settings.errorPlacement(place, $(element));
                    } else {
                        if ($(element).parent().hasClass('dropdowndiv'))
                        {
                            place.insertAfter($(element).parent());
                        }
                        else
                        place.insertAfter(element);
                    }

                    // Link error back to the element
                    if (error.is("label")) {
                        // If the error is a label, then associate using 'for'
                        error.attr("for", elementID);
                    } else if (error.parents("label[for='" + elementID + "']").length === 0) {
                        // If the element is not a child of an associated label, then it's necessary
                        // to explicitly apply aria-describedby

                        errorID = error.attr("id").replace(/(:|\.|\[|\])/g, "\\$1");
                        // Respect existing non-error aria-describedby
                        if (!describedBy) {
                            describedBy = errorID;
                        } else if (!describedBy.match(new RegExp("\\b" + errorID + "\\b"))) {
                            // Add to end of list if not already present
                            describedBy += " " + errorID;
                        }
                        $(element).attr("aria-describedby", describedBy);

                        // If this element is grouped, then assign to all elements in the same group
                        group = this.groups[element.name];
                        if (group) {
                            $.each(this.groups, function (name, testgroup) {
                                if (testgroup === group) {
                                    $("[name='" + name + "']", this.currentForm)
                                        .attr("aria-describedby", error.attr("id"));
                                }
                            });
                        }
                    }
                }
                if (!message && this.settings.success) {
                    error.text("");
                    if (typeof this.settings.success === "string") {
                        error.addClass(this.settings.success);
                    } else {
                        this.settings.success(error, element);
                    }
                }
                this.toShow = this.toShow.add(error);
            },

            errorsFor: function (element) {
                var name = this.idOrName(element),
                    describer = $(element).attr("aria-describedby"),
                    selector = "label[for='" + name + "'], label[for='" + name + "'] *";

                // aria-describedby should directly reference the error element
                if (describer) {
                    selector = selector + ", #" + describer.replace(/\s+/g, ", #");
                }
                return this
                    .errors()
                    .filter(selector);
            },

            idOrName: function (element) {
                return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name);
            },

            validationTargetFor: function (element) {

                // If radio/checkbox, validate first element in group instead
                if (this.checkable(element)) {
                    element = this.findByName(element.name);
                }

                // Always apply ignore filter
                return $(element).not(this.settings.ignore)[0];
            },

            checkable: function (element) {
                return (/radio|checkbox/i).test(element.type);
            },

            findByName: function (name) {
                return $(this.currentForm).find("[name='" + name + "']");
            },

            getLength: function (value, element) {
                switch (element.nodeName.toLowerCase()) {
                    case "select":
                        return $("option:selected", element).length;
                    case "input":
                        if (this.checkable(element)) {
                            return this.findByName(element.name).filter(":checked").length;
                        }
                }
                return value.length;
            },

            depend: function (param, element) {
                return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : true;
            },

            dependTypes: {
                "boolean": function (param) {
                    return param;
                },
                "string": function (param, element) {
                    //return !!$( param, element.form ).length;
                    return !!$(param, element).length;
                },
                "function": function (param, element) {
                    return param(element);
                }
            },

            optional: function (element) {
                var val = this.elementValue(element);
                return !$.validator.methods.required.call(this, val, element) && "dependency-mismatch";
            },

            startRequest: function (element) {
                if (!this.pending[element.name]) {
                    this.pendingRequest++;
                    this.pending[element.name] = true;
                }
            },

            stopRequest: function (element, valid) {
                this.pendingRequest--;
                // sometimes synchronization fails, make sure pendingRequest is never < 0
                if (this.pendingRequest < 0) {
                    this.pendingRequest = 0;
                }
                delete this.pending[element.name];
                if (valid && this.pendingRequest === 0 && this.formSubmitted && this.form()) {
                    $(this.currentForm).submit();
                    this.formSubmitted = false;
                } else if (!valid && this.pendingRequest === 0 && this.formSubmitted) {
                    $(this.currentForm).triggerHandler("invalid-form", [this]);
                    this.formSubmitted = false;
                }
            },

            previousValue: function (element) {
                return $.data(element, "previousValue") || $.data(element, "previousValue", {
                    old: null,
                    valid: true,
                    message: this.defaultMessage(element, "remote")
                });
            }

        },

        classRuleSettings: {
            required: { required: true },
            email: { email: true },
            url: { url: true },
            date: { date: true },
            dateISO: { dateISO: true },
            number: { number: true },
            digits: { digits: true },
            creditcard: { creditcard: true }
        },

        addClassRules: function (className, rules) {
            if (className.constructor === String) {
                this.classRuleSettings[className] = rules;
            } else {
                $.extend(this.classRuleSettings, className);
            }
        },

        classRules: function (element) {
            var rules = {},
                classes = $(element).attr("class");

            if (classes) {
                $.each(classes.split(" "), function () {
                    if (this in $.validator.classRuleSettings) {
                        $.extend(rules, $.validator.classRuleSettings[this]);
                    }
                });
            }
            return rules;
        },

        attributeRules: function (element) {
            var rules = {},
                $element = $(element),
                type = element.getAttribute("type"),
                method, value;

            for (method in $.validator.methods) {

                // support for <input required> in both html5 and older browsers
                if (method === "required") {
                    value = element.getAttribute(method);
                    // Some browsers return an empty string for the required attribute
                    // and non-HTML5 browsers might have required="" markup
                    if (value === "") {
                        value = true;
                    }
                    // force non-HTML5 browsers to return bool
                    value = !!value;
                } else {
                    value = $element.attr(method);
                }

                // convert the value to a number for number inputs, and for text for backwards compability
                // allows type="date" and others to be compared as strings
                if (/min|max/.test(method) && (type === null || /number|range|text/.test(type))) {
                    value = Number(value);
                }

                if (value || value === 0) {
                    rules[method] = value;
                } else if (type === method && type !== "range") {
                    // exception: the jquery validate 'range' method
                    // does not test for the html5 'range' type
                    rules[method] = true;
                }
            }

            // maxlength may be returned as -1, 2147483647 ( IE ) and 524288 ( safari ) for text inputs
            if (rules.maxlength && /-1|2147483647|524288/.test(rules.maxlength)) {
                delete rules.maxlength;
            }

            return rules;
        },

        dataRules: function (element) {
            var method, value,
                rules = {}, $element = $(element);
            for (method in $.validator.methods) {
                value = $element.data("rule" + method.charAt(0).toUpperCase() + method.substring(1).toLowerCase());
                if (value !== undefined) {
                    rules[method] = value;
                }
            }
            return rules;
        },

        staticRules: function (element) {
            var rules = {},
                //validator = $.data( element.form, "validator" );
            validator = $.data($(element).closest("[data-type=validcontainer]")[0], "validator");

            if (validator.settings.rules) {
                rules = $.validator.normalizeRule(validator.settings.rules[element.name]) || {};
            }
            return rules;
        },

        normalizeRules: function (rules, element) {
            // handle dependency check
            $.each(rules, function (prop, val) {
                // ignore rule when param is explicitly false, eg. required:false
                if (val === false) {
                    delete rules[prop];
                    return;
                }
                if (val.param || val.depends) {
                    var keepRule = true;
                    switch (typeof val.depends) {
                        case "string":
                            //keepRule = !!$( val.depends, element.form ).length;
                            keepRule = !!$(val.depends, element).length;
                            break;
                        case "function":
                            keepRule = val.depends.call(element, element);
                            break;
                    }
                    if (keepRule) {
                        rules[prop] = val.param !== undefined ? val.param : true;
                    } else {
                        delete rules[prop];
                    }
                }
            });

            // evaluate parameters
            $.each(rules, function (rule, parameter) {
                rules[rule] = $.isFunction(parameter) ? parameter(element) : parameter;
            });

            // clean number parameters
            $.each(["minlength", "maxlength"], function () {
                if (rules[this]) {
                    rules[this] = Number(rules[this]);
                }
            });
            $.each(["rangelength", "range"], function () {
                var parts;
                if (rules[this]) {
                    if ($.isArray(rules[this])) {
                        rules[this] = [Number(rules[this][0]), Number(rules[this][1])];
                    } else if (typeof rules[this] === "string") {
                        parts = rules[this].replace(/[\[\]]/g, "").split(/[\s,]+/);
                        rules[this] = [Number(parts[0]), Number(parts[1])];
                    }
                }
            });

            if ($.validator.autoCreateRanges) {
                // auto-create ranges
                if (rules.min != null && rules.max != null) {
                    rules.range = [rules.min, rules.max];
                    delete rules.min;
                    delete rules.max;
                }
                if (rules.minlength != null && rules.maxlength != null) {
                    rules.rangelength = [rules.minlength, rules.maxlength];
                    delete rules.minlength;
                    delete rules.maxlength;
                }
            }

            return rules;
        },

        // Converts a simple string to a {string: true} rule, e.g., "required" to {required:true}
        normalizeRule: function (data) {
            if (typeof data === "string") {
                var transformed = {};
                $.each(data.split(/\s/), function () {
                    transformed[this] = true;
                });
                data = transformed;
            }
            return data;
        },

        // http://jqueryvalidation.org/jQuery.validator.addMethod/
        addMethod: function (name, method, message) {
            $.validator.methods[name] = method;
            $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];
            if (method.length < 3) {
                $.validator.addClassRules(name, $.validator.normalizeRule(name));
            }
        },

        methods: {

            // http://jqueryvalidation.org/required-method/
            required: function (value, element, param) {
                // check if dependency is met
                if (!this.depend(param, element)) {
                    return "dependency-mismatch";
                }
                if (element.nodeName.toLowerCase() === "select") {
                    // could be an array for select-multiple or a string, both are fine this way
                    var val = $(element).val();
                    return val && val.length > 0;
                }
                if (this.checkable(element)) {
                    return this.getLength(value, element) > 0;
                }
                return $.trim(value).length > 0;
            },

            // http://jqueryvalidation.org/email-method/
            email: function (value, element) {
                // From http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#e-mail-state-%28type=email%29
                // Retrieved 2014-01-14
                // If you have a problem with this implementation, report a bug against the above spec
                // Or use custom methods to implement your own email validation
                // return this.optional(element) || /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test(value);
                return this.optional(element) || /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(value);
            },

            // http://jqueryvalidation.org/url-method/
            url: function (value, element) {
                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/iri/
                return this.optional(element) || /^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value);
            },

            // http://jqueryvalidation.org/date-method/
            date: function (value, element) {
                return this.optional(element) || !/Invalid|NaN/.test(new Date(value).toString());
            },

            // http://jqueryvalidation.org/dateISO-method/
            dateISO: function (value, element) {
                return this.optional(element) || /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/.test(value);
            },

            // http://jqueryvalidation.org/number-method/
            number: function (value, element) {
                return this.optional(element) || /^-?(?:\d+|\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test(value);
            },

            // http://jqueryvalidation.org/digits-method/
            digits: function (value, element) {
                return this.optional(element) || /^\d+$/.test(value);
            },

            // http://jqueryvalidation.org/creditcard-method/
            // based on http://en.wikipedia.org/wiki/Luhn/
            creditcard: function (value, element) {
                if (this.optional(element)) {
                    return "dependency-mismatch";
                }
                // accept only spaces, digits and dashes
                if (/[^0-9 \-]+/.test(value)) {
                    return false;
                }
                var nCheck = 0,
                    nDigit = 0,
                    bEven = false,
                    n, cDigit;

                value = value.replace(/\D/g, "");

                // Basing min and max length on
                // http://developer.ean.com/general_info/Valid_Credit_Card_Types
                if (value.length < 13 || value.length > 19) {
                    return false;
                }

                for (n = value.length - 1; n >= 0; n--) {
                    cDigit = value.charAt(n);
                    nDigit = parseInt(cDigit, 10);
                    if (bEven) {
                        if ((nDigit *= 2) > 9) {
                            nDigit -= 9;
                        }
                    }
                    nCheck += nDigit;
                    bEven = !bEven;
                }

                return (nCheck % 10) === 0;
            },

            // http://jqueryvalidation.org/minlength-method/
            minlength: function (value, element, param) {
                var length = $.isArray(value) ? value.length : this.getLength(value, element);
                return this.optional(element) || length >= param;
            },

            // http://jqueryvalidation.org/maxlength-method/
            maxlength: function (value, element, param) {
                var length = $.isArray(value) ? value.length : this.getLength(value, element);
                return this.optional(element) || length <= param;
            },

            // http://jqueryvalidation.org/rangelength-method/
            rangelength: function (value, element, param) {
                var length = $.isArray(value) ? value.length : this.getLength(value, element);
                return this.optional(element) || (length >= param[0] && length <= param[1]);
            },

            // http://jqueryvalidation.org/min-method/
            min: function (value, element, param) {
                return this.optional(element) || value >= param;
            },

            // http://jqueryvalidation.org/max-method/
            max: function (value, element, param) {
                return this.optional(element) || value <= param;
            },

            // http://jqueryvalidation.org/range-method/
            range: function (value, element, param) {
                return this.optional(element) || (value >= param[0] && value <= param[1]);
            },

            // http://jqueryvalidation.org/equalTo-method/
            equalTo: function (value, element, param) {
                // bind to the blur event of the target in order to revalidate whenever the target field is updated
                // TODO find a way to bind the event just once, avoiding the unbind-rebind overhead
                var target = $(param);
                if (this.settings.onfocusout) {
                    target.unbind(".validate-equalTo").bind("blur.validate-equalTo", function () {
                        $(element).valid();
                    });
                }
                return value === target.val();
            },

            // http://jqueryvalidation.org/remote-method/
            remote: function (value, element, param) {
                if (this.optional(element)) {
                    return "dependency-mismatch";
                }

                var previous = this.previousValue(element),
                    validator, data;

                if (!this.settings.messages[element.name]) {
                    this.settings.messages[element.name] = {};
                }
                previous.originalMessage = this.settings.messages[element.name].remote;
                this.settings.messages[element.name].remote = previous.message;

                param = typeof param === "string" && { url: param } || param;

                if (previous.old === value) {
                    return previous.valid;
                }

                previous.old = value;
                validator = this;
                this.startRequest(element);
                data = {};
                data[element.name] = value;
                $.ajax($.extend(true, {
                    url: param,
                    mode: "abort",
                    port: "validate" + element.name,
                    dataType: "json",
                    data: data,
                    context: validator.currentForm,
                    success: function (response) {
                        var valid = response === true || response === "true",
                            errors, message, submitted;

                        validator.settings.messages[element.name].remote = previous.originalMessage;
                        if (valid) {
                            submitted = validator.formSubmitted;
                            validator.prepareElement(element);
                            validator.formSubmitted = submitted;
                            validator.successList.push(element);
                            delete validator.invalid[element.name];
                            validator.showErrors();
                        } else {
                            errors = {};
                            message = response || validator.defaultMessage(element, "remote");
                            errors[element.name] = previous.message = $.isFunction(message) ? message(value) : message;
                            validator.invalid[element.name] = true;
                            validator.showErrors(errors);
                        }
                        previous.valid = valid;
                        validator.stopRequest(element, valid);
                    }
                }, param));
                return "pending";
            }

        }

    });

    $.format = function deprecated() {
        throw "$.format has been deprecated. Please use $.validator.format instead.";
    };

    // ajax mode: abort
    // usage: $.ajax({ mode: "abort"[, port: "uniqueport"]});
    // if mode:"abort" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()

    var pendingRequests = {},
        ajax;
    // Use a prefilter if available (1.5+)
    if ($.ajaxPrefilter) {
        $.ajaxPrefilter(function (settings, _, xhr) {
            var port = settings.port;
            if (settings.mode === "abort") {
                if (pendingRequests[port]) {
                    pendingRequests[port].abort();
                }
                pendingRequests[port] = xhr;
            }
        });
    } else {
        // Proxy ajax
        ajax = $.ajax;
        $.ajax = function (settings) {
            var mode = ("mode" in settings ? settings : $.ajaxSettings).mode,
                port = ("port" in settings ? settings : $.ajaxSettings).port;
            if (mode === "abort") {
                if (pendingRequests[port]) {
                    pendingRequests[port].abort();
                }
                pendingRequests[port] = ajax.apply(this, arguments);
                return pendingRequests[port];
            }
            return ajax.apply(this, arguments);
        };
    }

    // provides delegate(type: String, delegate: Selector, handler: Callback) plugin for easier event delegation
    // handler is only called when $(event.target).is(delegate), in the scope of the jquery-object for event.target

    $.extend($.fn, {
        validateDelegate: function (delegate, type, handler) {
            return this.bind(type, function (event) {
                var target = $(event.target);
                if (target.is(delegate)) {
                    return handler.apply(target, arguments);
                }
            });
        }
    });

  

}));;
/*!
 * Bootstrap v3.2.0 (http://getbootstrap.com)
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 */
if("undefined"==typeof jQuery)throw new Error("Bootstrap's JavaScript requires jQuery");+function(a){"use strict";function b(){var a=document.createElement("bootstrap"),b={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd otransitionend",transition:"transitionend"};for(var c in b)if(void 0!==a.style[c])return{end:b[c]};return!1}a.fn.emulateTransitionEnd=function(b){var c=!1,d=this;a(this).one("bsTransitionEnd",function(){c=!0});var e=function(){c||a(d).trigger(a.support.transition.end)};return setTimeout(e,b),this},a(function(){a.support.transition=b(),a.support.transition&&(a.event.special.bsTransitionEnd={bindType:a.support.transition.end,delegateType:a.support.transition.end,handle:function(b){return a(b.target).is(this)?b.handleObj.handler.apply(this,arguments):void 0}})})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var c=a(this),e=c.data("bs.alert");e||c.data("bs.alert",e=new d(this)),"string"==typeof b&&e[b].call(c)})}var c='[data-dismiss="alert"]',d=function(b){a(b).on("click",c,this.close)};d.VERSION="3.2.0",d.prototype.close=function(b){function c(){f.detach().trigger("closed.bs.alert").remove()}var d=a(this),e=d.attr("data-target");e||(e=d.attr("href"),e=e&&e.replace(/.*(?=#[^\s]*$)/,""));var f=a(e);b&&b.preventDefault(),f.length||(f=d.hasClass("alert")?d:d.parent()),f.trigger(b=a.Event("close.bs.alert")),b.isDefaultPrevented()||(f.removeClass("in"),a.support.transition&&f.hasClass("fade")?f.one("bsTransitionEnd",c).emulateTransitionEnd(150):c())};var e=a.fn.alert;a.fn.alert=b,a.fn.alert.Constructor=d,a.fn.alert.noConflict=function(){return a.fn.alert=e,this},a(document).on("click.bs.alert.data-api",c,d.prototype.close)}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.button"),f="object"==typeof b&&b;e||d.data("bs.button",e=new c(this,f)),"toggle"==b?e.toggle():b&&e.setState(b)})}var c=function(b,d){this.$element=a(b),this.options=a.extend({},c.DEFAULTS,d),this.isLoading=!1};c.VERSION="3.2.0",c.DEFAULTS={loadingText:"loading..."},c.prototype.setState=function(b){var c="disabled",d=this.$element,e=d.is("input")?"val":"html",f=d.data();b+="Text",null==f.resetText&&d.data("resetText",d[e]()),d[e](null==f[b]?this.options[b]:f[b]),setTimeout(a.proxy(function(){"loadingText"==b?(this.isLoading=!0,d.addClass(c).attr(c,c)):this.isLoading&&(this.isLoading=!1,d.removeClass(c).removeAttr(c))},this),0)},c.prototype.toggle=function(){var a=!0,b=this.$element.closest('[data-toggle="buttons"]');if(b.length){var c=this.$element.find("input");"radio"==c.prop("type")&&(c.prop("checked")&&this.$element.hasClass("active")?a=!1:b.find(".active").removeClass("active")),a&&c.prop("checked",!this.$element.hasClass("active")).trigger("change")}a&&this.$element.toggleClass("active")};var d=a.fn.button;a.fn.button=b,a.fn.button.Constructor=c,a.fn.button.noConflict=function(){return a.fn.button=d,this},a(document).on("click.bs.button.data-api",'[data-toggle^="button"]',function(c){var d=a(c.target);d.hasClass("btn")||(d=d.closest(".btn")),b.call(d,"toggle"),c.preventDefault()})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.carousel"),f=a.extend({},c.DEFAULTS,d.data(),"object"==typeof b&&b),g="string"==typeof b?b:f.slide;e||d.data("bs.carousel",e=new c(this,f)),"number"==typeof b?e.to(b):g?e[g]():f.interval&&e.pause().cycle()})}var c=function(b,c){this.$element=a(b).on("keydown.bs.carousel",a.proxy(this.keydown,this)),this.$indicators=this.$element.find(".carousel-indicators"),this.options=c,this.paused=this.sliding=this.interval=this.$active=this.$items=null,"hover"==this.options.pause&&this.$element.on("mouseenter.bs.carousel",a.proxy(this.pause,this)).on("mouseleave.bs.carousel",a.proxy(this.cycle,this))};c.VERSION="3.2.0",c.DEFAULTS={interval:5e3,pause:"hover",wrap:!0},c.prototype.keydown=function(a){switch(a.which){case 37:this.prev();break;case 39:this.next();break;default:return}a.preventDefault()},c.prototype.cycle=function(b){return b||(this.paused=!1),this.interval&&clearInterval(this.interval),this.options.interval&&!this.paused&&(this.interval=setInterval(a.proxy(this.next,this),this.options.interval)),this},c.prototype.getItemIndex=function(a){return this.$items=a.parent().children(".item"),this.$items.index(a||this.$active)},c.prototype.to=function(b){var c=this,d=this.getItemIndex(this.$active=this.$element.find(".item.active"));return b>this.$items.length-1||0>b?void 0:this.sliding?this.$element.one("slid.bs.carousel",function(){c.to(b)}):d==b?this.pause().cycle():this.slide(b>d?"next":"prev",a(this.$items[b]))},c.prototype.pause=function(b){return b||(this.paused=!0),this.$element.find(".next, .prev").length&&a.support.transition&&(this.$element.trigger(a.support.transition.end),this.cycle(!0)),this.interval=clearInterval(this.interval),this},c.prototype.next=function(){return this.sliding?void 0:this.slide("next")},c.prototype.prev=function(){return this.sliding?void 0:this.slide("prev")},c.prototype.slide=function(b,c){var d=this.$element.find(".item.active"),e=c||d[b](),f=this.interval,g="next"==b?"left":"right",h="next"==b?"first":"last",i=this;if(!e.length){if(!this.options.wrap)return;e=this.$element.find(".item")[h]()}if(e.hasClass("active"))return this.sliding=!1;var j=e[0],k=a.Event("slide.bs.carousel",{relatedTarget:j,direction:g});if(this.$element.trigger(k),!k.isDefaultPrevented()){if(this.sliding=!0,f&&this.pause(),this.$indicators.length){this.$indicators.find(".active").removeClass("active");var l=a(this.$indicators.children()[this.getItemIndex(e)]);l&&l.addClass("active")}var m=a.Event("slid.bs.carousel",{relatedTarget:j,direction:g});return a.support.transition&&this.$element.hasClass("slide")?(e.addClass(b),e[0].offsetWidth,d.addClass(g),e.addClass(g),d.one("bsTransitionEnd",function(){e.removeClass([b,g].join(" ")).addClass("active"),d.removeClass(["active",g].join(" ")),i.sliding=!1,setTimeout(function(){i.$element.trigger(m)},0)}).emulateTransitionEnd(1e3*d.css("transition-duration").slice(0,-1))):(d.removeClass("active"),e.addClass("active"),this.sliding=!1,this.$element.trigger(m)),f&&this.cycle(),this}};var d=a.fn.carousel;a.fn.carousel=b,a.fn.carousel.Constructor=c,a.fn.carousel.noConflict=function(){return a.fn.carousel=d,this},a(document).on("click.bs.carousel.data-api","[data-slide], [data-slide-to]",function(c){var d,e=a(this),f=a(e.attr("data-target")||(d=e.attr("href"))&&d.replace(/.*(?=#[^\s]+$)/,""));if(f.hasClass("carousel")){var g=a.extend({},f.data(),e.data()),h=e.attr("data-slide-to");h&&(g.interval=!1),b.call(f,g),h&&f.data("bs.carousel").to(h),c.preventDefault()}}),a(window).on("load",function(){a('[data-ride="carousel"]').each(function(){var c=a(this);b.call(c,c.data())})})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.collapse"),f=a.extend({},c.DEFAULTS,d.data(),"object"==typeof b&&b);!e&&f.toggle&&"show"==b&&(b=!b),e||d.data("bs.collapse",e=new c(this,f)),"string"==typeof b&&e[b]()})}var c=function(b,d){this.$element=a(b),this.options=a.extend({},c.DEFAULTS,d),this.transitioning=null,this.options.parent&&(this.$parent=a(this.options.parent)),this.options.toggle&&this.toggle()};c.VERSION="3.2.0",c.DEFAULTS={toggle:!0},c.prototype.dimension=function(){var a=this.$element.hasClass("width");return a?"width":"height"},c.prototype.show=function(){if(!this.transitioning&&!this.$element.hasClass("in")){var c=a.Event("show.bs.collapse");if(this.$element.trigger(c),!c.isDefaultPrevented()){var d=this.$parent&&this.$parent.find("> .panel > .in");if(d&&d.length){var e=d.data("bs.collapse");if(e&&e.transitioning)return;b.call(d,"hide"),e||d.data("bs.collapse",null)}var f=this.dimension();this.$element.removeClass("collapse").addClass("collapsing")[f](0),this.transitioning=1;var g=function(){this.$element.removeClass("collapsing").addClass("collapse in")[f](""),this.transitioning=0,this.$element.trigger("shown.bs.collapse")};if(!a.support.transition)return g.call(this);var h=a.camelCase(["scroll",f].join("-"));this.$element.one("bsTransitionEnd",a.proxy(g,this)).emulateTransitionEnd(350)[f](this.$element[0][h])}}},c.prototype.hide=function(){if(!this.transitioning&&this.$element.hasClass("in")){var b=a.Event("hide.bs.collapse");if(this.$element.trigger(b),!b.isDefaultPrevented()){var c=this.dimension();this.$element[c](this.$element[c]())[0].offsetHeight,this.$element.addClass("collapsing").removeClass("collapse").removeClass("in"),this.transitioning=1;var d=function(){this.transitioning=0,this.$element.trigger("hidden.bs.collapse").removeClass("collapsing").addClass("collapse")};return a.support.transition?void this.$element[c](0).one("bsTransitionEnd",a.proxy(d,this)).emulateTransitionEnd(350):d.call(this)}}},c.prototype.toggle=function(){this[this.$element.hasClass("in")?"hide":"show"]()};var d=a.fn.collapse;a.fn.collapse=b,a.fn.collapse.Constructor=c,a.fn.collapse.noConflict=function(){return a.fn.collapse=d,this},a(document).on("click.bs.collapse.data-api",'[data-toggle="collapse"]',function(c){var d,e=a(this),f=e.attr("data-target")||c.preventDefault()||(d=e.attr("href"))&&d.replace(/.*(?=#[^\s]+$)/,""),g=a(f),h=g.data("bs.collapse"),i=h?"toggle":e.data(),j=e.attr("data-parent"),k=j&&a(j);h&&h.transitioning||(k&&k.find('[data-toggle="collapse"][data-parent="'+j+'"]').not(e).addClass("collapsed"),e[g.hasClass("in")?"addClass":"removeClass"]("collapsed")),b.call(g,i)})}(jQuery),+function(a){"use strict";function b(b){b&&3===b.which||(a(e).remove(),a(f).each(function(){var d=c(a(this)),e={relatedTarget:this};d.hasClass("open")&&(d.trigger(b=a.Event("hide.bs.dropdown",e)),b.isDefaultPrevented()||d.removeClass("open").trigger("hidden.bs.dropdown",e))}))}function c(b){var c=b.attr("data-target");c||(c=b.attr("href"),c=c&&/#[A-Za-z]/.test(c)&&c.replace(/.*(?=#[^\s]*$)/,""));var d=c&&a(c);return d&&d.length?d:b.parent()}function d(b){return this.each(function(){var c=a(this),d=c.data("bs.dropdown");d||c.data("bs.dropdown",d=new g(this)),"string"==typeof b&&d[b].call(c)})}var e=".dropdown-backdrop",f='[data-toggle="dropdown"]',g=function(b){a(b).on("click.bs.dropdown",this.toggle)};g.VERSION="3.2.0",g.prototype.toggle=function(d){var e=a(this);if(!e.is(".disabled, :disabled")){var f=c(e),g=f.hasClass("open");if(b(),!g){"ontouchstart"in document.documentElement&&!f.closest(".navbar-nav").length&&a('<div class="dropdown-backdrop"/>').insertAfter(a(this)).on("click",b);var h={relatedTarget:this};if(f.trigger(d=a.Event("show.bs.dropdown",h)),d.isDefaultPrevented())return;e.trigger("focus"),f.toggleClass("open").trigger("shown.bs.dropdown",h)}return!1}},g.prototype.keydown=function(b){if(/(38|40|27)/.test(b.keyCode)){var d=a(this);if(b.preventDefault(),b.stopPropagation(),!d.is(".disabled, :disabled")){var e=c(d),g=e.hasClass("open");if(!g||g&&27==b.keyCode)return 27==b.which&&e.find(f).trigger("focus"),d.trigger("click");var h=" li:not(.divider):visible a",i=e.find('[role="menu"]'+h+', [role="listbox"]'+h);if(i.length){var j=i.index(i.filter(":focus"));38==b.keyCode&&j>0&&j--,40==b.keyCode&&j<i.length-1&&j++,~j||(j=0),i.eq(j).trigger("focus")}}}};var h=a.fn.dropdown;a.fn.dropdown=d,a.fn.dropdown.Constructor=g,a.fn.dropdown.noConflict=function(){return a.fn.dropdown=h,this},a(document).on("click.bs.dropdown.data-api",b).on("click.bs.dropdown.data-api",".dropdown form",function(a){a.stopPropagation()}).on("click.bs.dropdown.data-api",f,g.prototype.toggle).on("keydown.bs.dropdown.data-api",f+', [role="menu"], [role="listbox"]',g.prototype.keydown)}(jQuery),+function(a){"use strict";function b(b,d){return this.each(function(){var e=a(this),f=e.data("bs.modal"),g=a.extend({},c.DEFAULTS,e.data(),"object"==typeof b&&b);f||e.data("bs.modal",f=new c(this,g)),"string"==typeof b?f[b](d):g.show&&f.show(d)})}var c=function(b,c){this.options=c,this.$body=a(document.body),this.$element=a(b),this.$backdrop=this.isShown=null,this.scrollbarWidth=0,this.options.remote&&this.$element.find(".modal-content").load(this.options.remote,a.proxy(function(){this.$element.trigger("loaded.bs.modal")},this))};c.VERSION="3.2.0",c.DEFAULTS={backdrop:!0,keyboard:!0,show:!0},c.prototype.toggle=function(a){return this.isShown?this.hide():this.show(a)},c.prototype.show=function(b){var c=this,d=a.Event("show.bs.modal",{relatedTarget:b});this.$element.trigger(d),this.isShown||d.isDefaultPrevented()||(this.isShown=!0,this.checkScrollbar(),this.$body.addClass("modal-open"),this.setScrollbar(),this.escape(),this.$element.on("click.dismiss.bs.modal",'[data-dismiss="modal"]',a.proxy(this.hide,this)),this.backdrop(function(){var d=a.support.transition&&c.$element.hasClass("fade");c.$element.parent().length||c.$element.appendTo(c.$body),c.$element.show().scrollTop(0),d&&c.$element[0].offsetWidth,c.$element.addClass("in").attr("aria-hidden",!1),c.enforceFocus();var e=a.Event("shown.bs.modal",{relatedTarget:b});d?c.$element.find(".modal-dialog").one("bsTransitionEnd",function(){c.$element.trigger("focus").trigger(e)}).emulateTransitionEnd(300):c.$element.trigger("focus").trigger(e)}))},c.prototype.hide=function(b){b&&b.preventDefault(),b=a.Event("hide.bs.modal"),this.$element.trigger(b),this.isShown&&!b.isDefaultPrevented()&&(this.isShown=!1,this.$body.removeClass("modal-open"),this.resetScrollbar(),this.escape(),a(document).off("focusin.bs.modal"),this.$element.removeClass("in").attr("aria-hidden",!0).off("click.dismiss.bs.modal"),a.support.transition&&this.$element.hasClass("fade")?this.$element.one("bsTransitionEnd",a.proxy(this.hideModal,this)).emulateTransitionEnd(300):this.hideModal())},c.prototype.enforceFocus=function(){a(document).off("focusin.bs.modal").on("focusin.bs.modal",a.proxy(function(a){this.$element[0]===a.target||this.$element.has(a.target).length||this.$element.trigger("focus")},this))},c.prototype.escape=function(){this.isShown&&this.options.keyboard?this.$element.on("keyup.dismiss.bs.modal",a.proxy(function(a){27==a.which&&this.hide()},this)):this.isShown||this.$element.off("keyup.dismiss.bs.modal")},c.prototype.hideModal=function(){var a=this;this.$element.hide(),this.backdrop(function(){a.$element.trigger("hidden.bs.modal")})},c.prototype.removeBackdrop=function(){this.$backdrop&&this.$backdrop.remove(),this.$backdrop=null},c.prototype.backdrop=function(b){var c=this,d=this.$element.hasClass("fade")?"fade":"";if(this.isShown&&this.options.backdrop){var e=a.support.transition&&d;if(this.$backdrop=a('<div class="modal-backdrop '+d+'" />').appendTo(this.$body),this.$element.on("click.dismiss.bs.modal",a.proxy(function(a){a.target===a.currentTarget&&("static"==this.options.backdrop?this.$element[0].focus.call(this.$element[0]):this.hide.call(this))},this)),e&&this.$backdrop[0].offsetWidth,this.$backdrop.addClass("in"),!b)return;e?this.$backdrop.one("bsTransitionEnd",b).emulateTransitionEnd(150):b()}else if(!this.isShown&&this.$backdrop){this.$backdrop.removeClass("in");var f=function(){c.removeBackdrop(),b&&b()};a.support.transition&&this.$element.hasClass("fade")?this.$backdrop.one("bsTransitionEnd",f).emulateTransitionEnd(150):f()}else b&&b()},c.prototype.checkScrollbar=function(){document.body.clientWidth>=window.innerWidth||(this.scrollbarWidth=this.scrollbarWidth||this.measureScrollbar())},c.prototype.setScrollbar=function(){var a=parseInt(this.$body.css("padding-right")||0,10);this.scrollbarWidth&&this.$body.css("padding-right",a+this.scrollbarWidth)},c.prototype.resetScrollbar=function(){this.$body.css("padding-right","")},c.prototype.measureScrollbar=function(){var a=document.createElement("div");a.className="modal-scrollbar-measure",this.$body.append(a);var b=a.offsetWidth-a.clientWidth;return this.$body[0].removeChild(a),b};var d=a.fn.modal;a.fn.modal=b,a.fn.modal.Constructor=c,a.fn.modal.noConflict=function(){return a.fn.modal=d,this},a(document).on("click.bs.modal.data-api",'[data-toggle="modal"]',function(c){var d=a(this),e=d.attr("href"),f=a(d.attr("data-target")||e&&e.replace(/.*(?=#[^\s]+$)/,"")),g=f.data("bs.modal")?"toggle":a.extend({remote:!/#/.test(e)&&e},f.data(),d.data());d.is("a")&&c.preventDefault(),f.one("show.bs.modal",function(a){a.isDefaultPrevented()||f.one("hidden.bs.modal",function(){d.is(":visible")&&d.trigger("focus")})}),b.call(f,g,this)})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.tooltip"),f="object"==typeof b&&b;(e||"destroy"!=b)&&(e||d.data("bs.tooltip",e=new c(this,f)),"string"==typeof b&&e[b]())})}var c=function(a,b){this.type=this.options=this.enabled=this.timeout=this.hoverState=this.$element=null,this.init("tooltip",a,b)};c.VERSION="3.2.0",c.DEFAULTS={animation:!0,placement:"top",selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,container:!1,viewport:{selector:"body",padding:0}},c.prototype.init=function(b,c,d){this.enabled=!0,this.type=b,this.$element=a(c),this.options=this.getOptions(d),this.$viewport=this.options.viewport&&a(this.options.viewport.selector||this.options.viewport);for(var e=this.options.trigger.split(" "),f=e.length;f--;){var g=e[f];if("click"==g)this.$element.on("click."+this.type,this.options.selector,a.proxy(this.toggle,this));else if("manual"!=g){var h="hover"==g?"mouseenter":"focusin",i="hover"==g?"mouseleave":"focusout";this.$element.on(h+"."+this.type,this.options.selector,a.proxy(this.enter,this)),this.$element.on(i+"."+this.type,this.options.selector,a.proxy(this.leave,this))}}this.options.selector?this._options=a.extend({},this.options,{trigger:"manual",selector:""}):this.fixTitle()},c.prototype.getDefaults=function(){return c.DEFAULTS},c.prototype.getOptions=function(b){return b=a.extend({},this.getDefaults(),this.$element.data(),b),b.delay&&"number"==typeof b.delay&&(b.delay={show:b.delay,hide:b.delay}),b},c.prototype.getDelegateOptions=function(){var b={},c=this.getDefaults();return this._options&&a.each(this._options,function(a,d){c[a]!=d&&(b[a]=d)}),b},c.prototype.enter=function(b){var c=b instanceof this.constructor?b:a(b.currentTarget).data("bs."+this.type);return c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data("bs."+this.type,c)),clearTimeout(c.timeout),c.hoverState="in",c.options.delay&&c.options.delay.show?void(c.timeout=setTimeout(function(){"in"==c.hoverState&&c.show()},c.options.delay.show)):c.show()},c.prototype.leave=function(b){var c=b instanceof this.constructor?b:a(b.currentTarget).data("bs."+this.type);return c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data("bs."+this.type,c)),clearTimeout(c.timeout),c.hoverState="out",c.options.delay&&c.options.delay.hide?void(c.timeout=setTimeout(function(){"out"==c.hoverState&&c.hide()},c.options.delay.hide)):c.hide()},c.prototype.show=function(){var b=a.Event("show.bs."+this.type);if(this.hasContent()&&this.enabled){this.$element.trigger(b);var c=a.contains(document.documentElement,this.$element[0]);if(b.isDefaultPrevented()||!c)return;var d=this,e=this.tip(),f=this.getUID(this.type);this.setContent(),e.attr("id",f),this.$element.attr("aria-describedby",f),this.options.animation&&e.addClass("fade");var g="function"==typeof this.options.placement?this.options.placement.call(this,e[0],this.$element[0]):this.options.placement,h=/\s?auto?\s?/i,i=h.test(g);i&&(g=g.replace(h,"")||"top"),e.detach().css({top:0,left:0,display:"block"}).addClass(g).data("bs."+this.type,this),this.options.container?e.appendTo(this.options.container):e.insertAfter(this.$element);var j=this.getPosition(),k=e[0].offsetWidth,l=e[0].offsetHeight;if(i){var m=g,n=this.$element.parent(),o=this.getPosition(n);g="bottom"==g&&j.top+j.height+l-o.scroll>o.height?"top":"top"==g&&j.top-o.scroll-l<0?"bottom":"right"==g&&j.right+k>o.width?"left":"left"==g&&j.left-k<o.left?"right":g,e.removeClass(m).addClass(g)}var p=this.getCalculatedOffset(g,j,k,l);this.applyPlacement(p,g);var q=function(){d.$element.trigger("shown.bs."+d.type),d.hoverState=null};a.support.transition&&this.$tip.hasClass("fade")?e.one("bsTransitionEnd",q).emulateTransitionEnd(150):q()}},c.prototype.applyPlacement=function(b,c){var d=this.tip(),e=d[0].offsetWidth,f=d[0].offsetHeight,g=parseInt(d.css("margin-top"),10),h=parseInt(d.css("margin-left"),10);isNaN(g)&&(g=0),isNaN(h)&&(h=0),b.top=b.top+g,b.left=b.left+h,a.offset.setOffset(d[0],a.extend({using:function(a){d.css({top:Math.round(a.top),left:Math.round(a.left)})}},b),0),d.addClass("in");var i=d[0].offsetWidth,j=d[0].offsetHeight;"top"==c&&j!=f&&(b.top=b.top+f-j);var k=this.getViewportAdjustedDelta(c,b,i,j);k.left?b.left+=k.left:b.top+=k.top;var l=k.left?2*k.left-e+i:2*k.top-f+j,m=k.left?"left":"top",n=k.left?"offsetWidth":"offsetHeight";d.offset(b),this.replaceArrow(l,d[0][n],m)},c.prototype.replaceArrow=function(a,b,c){this.arrow().css(c,a?50*(1-a/b)+"%":"")},c.prototype.setContent=function(){var a=this.tip(),b=this.getTitle();a.find(".tooltip-inner")[this.options.html?"html":"text"](b),a.removeClass("fade in top bottom left right")},c.prototype.hide=function(){function b(){"in"!=c.hoverState&&d.detach(),c.$element.trigger("hidden.bs."+c.type)}var c=this,d=this.tip(),e=a.Event("hide.bs."+this.type);return this.$element.removeAttr("aria-describedby"),this.$element.trigger(e),e.isDefaultPrevented()?void 0:(d.removeClass("in"),a.support.transition&&this.$tip.hasClass("fade")?d.one("bsTransitionEnd",b).emulateTransitionEnd(150):b(),this.hoverState=null,this)},c.prototype.fixTitle=function(){var a=this.$element;(a.attr("title")||"string"!=typeof a.attr("data-original-title"))&&a.attr("data-original-title",a.attr("title")||"").attr("title","")},c.prototype.hasContent=function(){return this.getTitle()},c.prototype.getPosition=function(b){b=b||this.$element;var c=b[0],d="BODY"==c.tagName;return a.extend({},"function"==typeof c.getBoundingClientRect?c.getBoundingClientRect():null,{scroll:d?document.documentElement.scrollTop||document.body.scrollTop:b.scrollTop(),width:d?a(window).width():b.outerWidth(),height:d?a(window).height():b.outerHeight()},d?{top:0,left:0}:b.offset())},c.prototype.getCalculatedOffset=function(a,b,c,d){return"bottom"==a?{top:b.top+b.height,left:b.left+b.width/2-c/2}:"top"==a?{top:b.top-d,left:b.left+b.width/2-c/2}:"left"==a?{top:b.top+b.height/2-d/2,left:b.left-c}:{top:b.top+b.height/2-d/2,left:b.left+b.width}},c.prototype.getViewportAdjustedDelta=function(a,b,c,d){var e={top:0,left:0};if(!this.$viewport)return e;var f=this.options.viewport&&this.options.viewport.padding||0,g=this.getPosition(this.$viewport);if(/right|left/.test(a)){var h=b.top-f-g.scroll,i=b.top+f-g.scroll+d;h<g.top?e.top=g.top-h:i>g.top+g.height&&(e.top=g.top+g.height-i)}else{var j=b.left-f,k=b.left+f+c;j<g.left?e.left=g.left-j:k>g.width&&(e.left=g.left+g.width-k)}return e},c.prototype.getTitle=function(){var a,b=this.$element,c=this.options;return a=b.attr("data-original-title")||("function"==typeof c.title?c.title.call(b[0]):c.title)},c.prototype.getUID=function(a){do a+=~~(1e6*Math.random());while(document.getElementById(a));return a},c.prototype.tip=function(){return this.$tip=this.$tip||a(this.options.template)},c.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(".tooltip-arrow")},c.prototype.validate=function(){this.$element[0].parentNode||(this.hide(),this.$element=null,this.options=null)},c.prototype.enable=function(){this.enabled=!0},c.prototype.disable=function(){this.enabled=!1},c.prototype.toggleEnabled=function(){this.enabled=!this.enabled},c.prototype.toggle=function(b){var c=this;b&&(c=a(b.currentTarget).data("bs."+this.type),c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data("bs."+this.type,c))),c.tip().hasClass("in")?c.leave(c):c.enter(c)},c.prototype.destroy=function(){clearTimeout(this.timeout),this.hide().$element.off("."+this.type).removeData("bs."+this.type)};var d=a.fn.tooltip;a.fn.tooltip=b,a.fn.tooltip.Constructor=c,a.fn.tooltip.noConflict=function(){return a.fn.tooltip=d,this}}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.popover"),f="object"==typeof b&&b;(e||"destroy"!=b)&&(e||d.data("bs.popover",e=new c(this,f)),"string"==typeof b&&e[b]())})}var c=function(a,b){this.init("popover",a,b)};if(!a.fn.tooltip)throw new Error("Popover requires tooltip.js");c.VERSION="3.2.0",c.DEFAULTS=a.extend({},a.fn.tooltip.Constructor.DEFAULTS,{placement:"right",trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'}),c.prototype=a.extend({},a.fn.tooltip.Constructor.prototype),c.prototype.constructor=c,c.prototype.getDefaults=function(){return c.DEFAULTS},c.prototype.setContent=function(){var a=this.tip(),b=this.getTitle(),c=this.getContent();a.find(".popover-title")[this.options.html?"html":"text"](b),a.find(".popover-content").empty()[this.options.html?"string"==typeof c?"html":"append":"text"](c),a.removeClass("fade top bottom left right in"),a.find(".popover-title").html()||a.find(".popover-title").hide()},c.prototype.hasContent=function(){return this.getTitle()||this.getContent()},c.prototype.getContent=function(){var a=this.$element,b=this.options;return a.attr("data-content")||("function"==typeof b.content?b.content.call(a[0]):b.content)},c.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(".arrow")},c.prototype.tip=function(){return this.$tip||(this.$tip=a(this.options.template)),this.$tip};var d=a.fn.popover;a.fn.popover=b,a.fn.popover.Constructor=c,a.fn.popover.noConflict=function(){return a.fn.popover=d,this}}(jQuery),+function(a){"use strict";function b(c,d){var e=a.proxy(this.process,this);this.$body=a("body"),this.$scrollElement=a(a(c).is("body")?window:c),this.options=a.extend({},b.DEFAULTS,d),this.selector=(this.options.target||"")+" .nav li > a",this.offsets=[],this.targets=[],this.activeTarget=null,this.scrollHeight=0,this.$scrollElement.on("scroll.bs.scrollspy",e),this.refresh(),this.process()}function c(c){return this.each(function(){var d=a(this),e=d.data("bs.scrollspy"),f="object"==typeof c&&c;e||d.data("bs.scrollspy",e=new b(this,f)),"string"==typeof c&&e[c]()})}b.VERSION="3.2.0",b.DEFAULTS={offset:10},b.prototype.getScrollHeight=function(){return this.$scrollElement[0].scrollHeight||Math.max(this.$body[0].scrollHeight,document.documentElement.scrollHeight)},b.prototype.refresh=function(){var b="offset",c=0;a.isWindow(this.$scrollElement[0])||(b="position",c=this.$scrollElement.scrollTop()),this.offsets=[],this.targets=[],this.scrollHeight=this.getScrollHeight();var d=this;this.$body.find(this.selector).map(function(){var d=a(this),e=d.data("target")||d.attr("href"),f=/^#./.test(e)&&a(e);return f&&f.length&&f.is(":visible")&&[[f[b]().top+c,e]]||null}).sort(function(a,b){return a[0]-b[0]}).each(function(){d.offsets.push(this[0]),d.targets.push(this[1])})},b.prototype.process=function(){var a,b=this.$scrollElement.scrollTop()+this.options.offset,c=this.getScrollHeight(),d=this.options.offset+c-this.$scrollElement.height(),e=this.offsets,f=this.targets,g=this.activeTarget;if(this.scrollHeight!=c&&this.refresh(),b>=d)return g!=(a=f[f.length-1])&&this.activate(a);if(g&&b<=e[0])return g!=(a=f[0])&&this.activate(a);for(a=e.length;a--;)g!=f[a]&&b>=e[a]&&(!e[a+1]||b<=e[a+1])&&this.activate(f[a])},b.prototype.activate=function(b){this.activeTarget=b,a(this.selector).parentsUntil(this.options.target,".active").removeClass("active");var c=this.selector+'[data-target="'+b+'"],'+this.selector+'[href="'+b+'"]',d=a(c).parents("li").addClass("active");d.parent(".dropdown-menu").length&&(d=d.closest("li.dropdown").addClass("active")),d.trigger("activate.bs.scrollspy")};var d=a.fn.scrollspy;a.fn.scrollspy=c,a.fn.scrollspy.Constructor=b,a.fn.scrollspy.noConflict=function(){return a.fn.scrollspy=d,this},a(window).on("load.bs.scrollspy.data-api",function(){a('[data-spy="scroll"]').each(function(){var b=a(this);c.call(b,b.data())})})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.tab");e||d.data("bs.tab",e=new c(this)),"string"==typeof b&&e[b]()})}var c=function(b){this.element=a(b)};c.VERSION="3.2.0",c.prototype.show=function(){var b=this.element,c=b.closest("ul:not(.dropdown-menu)"),d=b.data("target");if(d||(d=b.attr("href"),d=d&&d.replace(/.*(?=#[^\s]*$)/,"")),!b.parent("li").hasClass("active")){var e=c.find(".active:last a")[0],f=a.Event("show.bs.tab",{relatedTarget:e});if(b.trigger(f),!f.isDefaultPrevented()){var g=a(d);this.activate(b.closest("li"),c),this.activate(g,g.parent(),function(){b.trigger({type:"shown.bs.tab",relatedTarget:e})})}}},c.prototype.activate=function(b,c,d){function e(){f.removeClass("active").find("> .dropdown-menu > .active").removeClass("active"),b.addClass("active"),g?(b[0].offsetWidth,b.addClass("in")):b.removeClass("fade"),b.parent(".dropdown-menu")&&b.closest("li.dropdown").addClass("active"),d&&d()}var f=c.find("> .active"),g=d&&a.support.transition&&f.hasClass("fade");g?f.one("bsTransitionEnd",e).emulateTransitionEnd(150):e(),f.removeClass("in")};var d=a.fn.tab;a.fn.tab=b,a.fn.tab.Constructor=c,a.fn.tab.noConflict=function(){return a.fn.tab=d,this},a(document).on("click.bs.tab.data-api",'[data-toggle="tab"], [data-toggle="pill"]',function(c){c.preventDefault(),b.call(a(this),"show")})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.affix"),f="object"==typeof b&&b;e||d.data("bs.affix",e=new c(this,f)),"string"==typeof b&&e[b]()})}var c=function(b,d){this.options=a.extend({},c.DEFAULTS,d),this.$target=a(this.options.target).on("scroll.bs.affix.data-api",a.proxy(this.checkPosition,this)).on("click.bs.affix.data-api",a.proxy(this.checkPositionWithEventLoop,this)),this.$element=a(b),this.affixed=this.unpin=this.pinnedOffset=null,this.checkPosition()};c.VERSION="3.2.0",c.RESET="affix affix-top affix-bottom",c.DEFAULTS={offset:0,target:window},c.prototype.getPinnedOffset=function(){if(this.pinnedOffset)return this.pinnedOffset;this.$element.removeClass(c.RESET).addClass("affix");var a=this.$target.scrollTop(),b=this.$element.offset();return this.pinnedOffset=b.top-a},c.prototype.checkPositionWithEventLoop=function(){setTimeout(a.proxy(this.checkPosition,this),1)},c.prototype.checkPosition=function(){if(this.$element.is(":visible")){var b=a(document).height(),d=this.$target.scrollTop(),e=this.$element.offset(),f=this.options.offset,g=f.top,h=f.bottom;"object"!=typeof f&&(h=g=f),"function"==typeof g&&(g=f.top(this.$element)),"function"==typeof h&&(h=f.bottom(this.$element));var i=null!=this.unpin&&d+this.unpin<=e.top?!1:null!=h&&e.top+this.$element.height()>=b-h?"bottom":null!=g&&g>=d?"top":!1;if(this.affixed!==i){null!=this.unpin&&this.$element.css("top","");var j="affix"+(i?"-"+i:""),k=a.Event(j+".bs.affix");this.$element.trigger(k),k.isDefaultPrevented()||(this.affixed=i,this.unpin="bottom"==i?this.getPinnedOffset():null,this.$element.removeClass(c.RESET).addClass(j).trigger(a.Event(j.replace("affix","affixed"))),"bottom"==i&&this.$element.offset({top:b-this.$element.height()-h}))}}};var d=a.fn.affix;a.fn.affix=b,a.fn.affix.Constructor=c,a.fn.affix.noConflict=function(){return a.fn.affix=d,this},a(window).on("load",function(){a('[data-spy="affix"]').each(function(){var c=a(this),d=c.data();d.offset=d.offset||{},d.offsetBottom&&(d.offset.bottom=d.offsetBottom),d.offsetTop&&(d.offset.top=d.offsetTop),b.call(c,d)})})}(jQuery);;
/*!
 * Webflow: Front-end site library
 * @license MIT
 * Inline scripts may access the api using an async handler:
 *   var Webflow = Webflow || [];
 *   Webflow.push(readyFunction);
 */!function (t) { var e = {}; function n(r) { if (e[r]) return e[r].exports; var i = e[r] = { i: r, l: !1, exports: {} }; return t[r].call(i.exports, i, i.exports, n), i.l = !0, i.exports } n.m = t, n.c = e, n.d = function (t, e, r) { n.o(t, e) || Object.defineProperty(t, e, { configurable: !1, enumerable: !0, get: r }) }, n.n = function (t) { var e = t && t.__esModule ? function () { return t.default } : function () { return t }; return n.d(e, "a", e), e }, n.o = function (t, e) { return Object.prototype.hasOwnProperty.call(t, e) }, n.p = "", n(n.s = 87) }([function (t, e) { var n = Array.isArray; t.exports = n }, function (t, e, n) { var r = {}, i = {}, o = [], a = window.Webflow || [], u = window.jQuery, c = u(window), s = u(document), f = u.isFunction, l = r._ = n(89), d = n(46) && u.tram, p = !1, v = !1; function h(t) { r.env() && (f(t.design) && c.on("__wf_design", t.design), f(t.preview) && c.on("__wf_preview", t.preview)), f(t.destroy) && c.on("__wf_destroy", t.destroy), t.ready && f(t.ready) && function (t) { if (p) return void t.ready(); if (l.contains(o, t.ready)) return; o.push(t.ready) }(t) } function g(t) { f(t.design) && c.off("__wf_design", t.design), f(t.preview) && c.off("__wf_preview", t.preview), f(t.destroy) && c.off("__wf_destroy", t.destroy), t.ready && f(t.ready) && function (t) { o = l.filter(o, function (e) { return e !== t.ready }) }(t) } d.config.hideBackface = !1, d.config.keepInherited = !0, r.define = function (t, e, n) { i[t] && g(i[t]); var r = i[t] = e(u, l, n) || {}; return h(r), r }, r.require = function (t) { return i[t] }, r.push = function (t) { p ? f(t) && t() : a.push(t) }, r.env = function (t) { var e = window.__wf_design, n = void 0 !== e; return t ? "design" === t ? n && e : "preview" === t ? n && !e : "slug" === t ? n && window.__wf_slug : "editor" === t ? window.WebflowEditor : "test" === t ? window.__wf_test : "frame" === t ? window !== window.top : void 0 : n }; var m, y = navigator.userAgent.toLowerCase(), b = r.env.touch = "ontouchstart" in window || window.DocumentTouch && document instanceof window.DocumentTouch, w = r.env.chrome = /chrome/.test(y) && /Google/.test(navigator.vendor) && parseInt(y.match(/chrome\/(\d+)\./)[1], 10), x = r.env.ios = /(ipod|iphone|ipad)/.test(y); r.env.safari = /safari/.test(y) && !w && !x, b && s.on("touchstart mousedown", function (t) { m = t.target }), r.validClick = b ? function (t) { return t === m || u.contains(t, m) } : function () { return !0 }; var _, O = "resize.webflow orientationchange.webflow load.webflow"; function j(t, e) { var n = [], r = {}; return r.up = l.throttle(function (t) { l.each(n, function (e) { e(t) }) }), t && e && t.on(e, r.up), r.on = function (t) { "function" == typeof t && (l.contains(n, t) || n.push(t)) }, r.off = function (t) { n = arguments.length ? l.filter(n, function (e) { return e !== t }) : [] }, r } function I(t) { f(t) && t() } function E() { _ && (_.reject(), c.off("load", _.resolve)), _ = new u.Deferred, c.on("load", _.resolve) } r.resize = j(c, O), r.scroll = j(c, "scroll.webflow resize.webflow orientationchange.webflow load.webflow"), r.redraw = j(), r.location = function (t) { window.location = t }, r.env() && (r.location = function () { }), r.ready = function () { p = !0, v ? (v = !1, l.each(i, h)) : l.each(o, I), l.each(a, I), r.resize.up() }, r.load = function (t) { _.then(t) }, r.destroy = function (t) { t = t || {}, v = !0, c.triggerHandler("__wf_destroy"), null != t.domready && (p = t.domready), l.each(i, g), r.resize.off(), r.scroll.off(), r.redraw.off(), o = [], a = [], "pending" === _.state() && E() }, u(r.ready), E(), t.exports = window.Webflow = r }, function (t, e, n) { var r = n(60), i = "object" == typeof self && self && self.Object === Object && self, o = r || i || Function("return this")(); t.exports = o }, function (t, e) { t.exports = function (t) { var e = typeof t; return null != t && ("object" == e || "function" == e) } }, function (t, e, n) { var r = n(132), i = n(137); t.exports = function (t, e) { var n = i(t, e); return r(n) ? n : void 0 } }, function (t, e) { t.exports = function (t) { return null != t && "object" == typeof t } }, function (t, e, n) { "use strict"; n.d(e, "l", function () { return r }), n.d(e, "m", function () { return i }), n.d(e, "n", function () { return o }), n.d(e, "o", function () { return a }), n.d(e, "k", function () { return u }), n.d(e, "j", function () { return c }), n.d(e, "p", function () { return s }), n.d(e, "c", function () { return f }), n.d(e, "d", function () { return l }), n.d(e, "e", function () { return d }), n.d(e, "b", function () { return p }), n.d(e, "i", function () { return v }), n.d(e, "f", function () { return h }), n.d(e, "h", function () { return g }), n.d(e, "g", function () { return m }), n.d(e, "a", function () { return y }), n.d(e, "q", function () { return b }); var r = "IX2_RAW_DATA_IMPORTED", i = "IX2_SESSION_INITIALIZED", o = "IX2_SESSION_STARTED", a = "IX2_SESSION_STOPPED", u = "IX2_PREVIEW_REQUESTED", c = "IX2_PLAYBACK_REQUESTED", s = "IX2_STOP_REQUESTED", f = "IX2_CLEAR_REQUESTED", l = "IX2_EVENT_LISTENER_ADDED", d = "IX2_EVENT_STATE_CHANGED", p = "IX2_ANIMATION_FRAME_CHANGED", v = "IX2_PARAMETER_CHANGED", h = "IX2_INSTANCE_ADDED", g = "IX2_INSTANCE_STARTED", m = "IX2_INSTANCE_REMOVED", y = "IX2_ACTION_LIST_PLAYBACK_CHANGED", b = "IX2_VIEWPORT_WIDTH_CHANGED" }, function (t, e, n) { var r = n(120), i = n(174), o = n(37), a = n(0), u = n(181); t.exports = function (t) { return "function" == typeof t ? t : null == t ? o : "object" == typeof t ? a(t) ? i(t[0], t[1]) : r(t) : u(t) } }, function (t, e, n) { var r = n(10), i = n(133), o = n(134), a = "[object Null]", u = "[object Undefined]", c = r ? r.toStringTag : void 0; t.exports = function (t) { return null == t ? void 0 === t ? u : a : c && c in Object(t) ? i(t) : o(t) } }, function (t, e, n) { var r = n(59), i = n(31); t.exports = function (t) { return null != t && i(t.length) && !r(t) } }, function (t, e, n) { var r = n(2).Symbol; t.exports = r }, function (t, e, n) { var r = n(21), i = 1 / 0; t.exports = function (t) { if ("string" == typeof t || r(t)) return t; var e = t + ""; return "0" == e && 1 / t == -i ? "-0" : e } }, function (t, e, n) { var r = n(113), i = Object.prototype.hasOwnProperty, o = Array.prototype.splice, a = Object.assign || function (t, e) { return u(e).forEach(function (n) { i.call(e, n) && (t[n] = e[n]) }), t }, u = "function" == typeof Object.getOwnPropertySymbols ? function (t) { return Object.keys(t).concat(Object.getOwnPropertySymbols(t)) } : function (t) { return Object.keys(t) }; function c(t) { return t instanceof Array ? t.slice() : t && "object" == typeof t ? a(new t.constructor, t) : t } function s() { var t = a({}, f); return e.extend = function (e, n) { t[e] = n }, e; function e(n, o) { Array.isArray(n) && Array.isArray(o) || r(!Array.isArray(o), "update(): You provided an invalid spec to update(). The spec may not contain an array except as the value of $set, $push, $unshift, $splice or any custom command allowing an array value."), r("object" == typeof o && null !== o, "update(): You provided an invalid spec to update(). The spec and every included key path must be plain objects containing one of the following commands: %s.", Object.keys(t).join(", ")); var a = n; u(o); return u(o).forEach(function (r) { if (i.call(t, r)) a = t[r](o[r], a, o, n); else { var u = e(n[r], o[r]); u !== a[r] && (a === n && (a = c(n)), a[r] = u) } }), a } } var f = { $push: function (t, e, n) { return l(e, n, "$push"), e.concat(t) }, $unshift: function (t, e, n) { return l(e, n, "$unshift"), t.concat(e) }, $splice: function (t, e, n, i) { var a = e === i ? c(i) : e; return function (t, e) { r(Array.isArray(t), "Expected $splice target to be an array; got %s", t), d(e.$splice) }(a, n), t.forEach(function (t) { d(t), o.apply(a, t) }), a }, $set: function (t, e, n) { return function (t) { r(1 === Object.keys(t).length, "Cannot have more than one key in an object with $set") }(n), t }, $unset: function (t, e, n, i) { r(Array.isArray(t), "update(): expected spec of $unset to be an array; got %s. Did you forget to wrap the key(s) in an array?", t); var o = e; return t.forEach(function (t) { Object.hasOwnProperty.call(o, t) && (e === i && (e = c(i)), delete e[t]) }), e }, $merge: function (t, e, n, i) { var o, a; return o = e = e, r((a = t) && "object" == typeof a, "update(): $merge expects a spec of type 'object'; got %s", a), r(o && "object" == typeof o, "update(): $merge expects a target of type 'object'; got %s", o), u(t).forEach(function (n) { t[n] !== e[n] && (e === i && (e = c(i)), e[n] = t[n]) }), e }, $apply: function (t, e) { var n; return r("function" == typeof (n = t), "update(): expected spec of $apply to be a function; got %s.", n), t(e) } }; function l(t, e, n) { r(Array.isArray(t), "update(): expected target of %s to be an array; got %s.", n, t); var i = e[n]; r(Array.isArray(i), "update(): expected spec of %s to be an array; got %s. Did you forget to wrap your parameter in an array?", n, i) } function d(t) { r(Array.isArray(t), "update(): expected spec of $splice to be an array of arrays; got %s. Did you forget to wrap your parameters in an array?", t) } t.exports = s(), t.exports.newContext = s }, function (t, e, n) { var r = n(122), i = n(123), o = n(124), a = n(125), u = n(126); function c(t) { var e = -1, n = null == t ? 0 : t.length; for (this.clear() ; ++e < n;) { var r = t[e]; this.set(r[0], r[1]) } } c.prototype.clear = r, c.prototype.delete = i, c.prototype.get = o, c.prototype.has = a, c.prototype.set = u, t.exports = c }, function (t, e, n) { var r = n(24); t.exports = function (t, e) { for (var n = t.length; n--;) if (r(t[n][0], e)) return n; return -1 } }, function (t, e, n) { var r = n(4)(Object, "create"); t.exports = r }, function (t, e, n) { var r = n(146); t.exports = function (t, e) { var n = t.__data__; return r(e) ? n["string" == typeof e ? "string" : "hash"] : n.map } }, function (t, e, n) { var r = n(67), i = n(32), o = n(9); t.exports = function (t) { return o(t) ? r(t) : i(t) } }, function (t, e, n) { var r = n(164), i = n(5), o = Object.prototype, a = o.hasOwnProperty, u = o.propertyIsEnumerable, c = r(function () { return arguments }()) ? r : function (t) { return i(t) && a.call(t, "callee") && !u.call(t, "callee") }; t.exports = c }, function (t, e, n) { var r = n(35); t.exports = function (t, e, n) { var i = null == t ? void 0 : r(t, e); return void 0 === i ? n : i } }, function (t, e, n) { var r = n(0), i = n(36), o = n(175), a = n(73); t.exports = function (t, e) { return r(t) ? t : i(t, e) ? [t] : o(a(t)) } }, function (t, e, n) { var r = n(8), i = n(5), o = "[object Symbol]"; t.exports = function (t) { return "symbol" == typeof t || i(t) && r(t) == o } }, function (t, e, n) { "use strict"; n.d(e, "o", function () { return r }), n.d(e, "E", function () { return i }), n.d(e, "f", function () { return o }), n.d(e, "A", function () { return a }), n.d(e, "B", function () { return u }), n.d(e, "C", function () { return c }), n.d(e, "D", function () { return s }), n.d(e, "u", function () { return f }), n.d(e, "v", function () { return l }), n.d(e, "w", function () { return d }), n.d(e, "r", function () { return p }), n.d(e, "s", function () { return v }), n.d(e, "t", function () { return h }), n.d(e, "y", function () { return g }), n.d(e, "z", function () { return m }), n.d(e, "p", function () { return y }), n.d(e, "F", function () { return b }), n.d(e, "m", function () { return w }), n.d(e, "c", function () { return x }), n.d(e, "b", function () { return _ }), n.d(e, "e", function () { return O }), n.d(e, "i", function () { return j }), n.d(e, "k", function () { return I }), n.d(e, "l", function () { return E }), n.d(e, "G", function () { return S }), n.d(e, "a", function () { return T }), n.d(e, "j", function () { return A }), n.d(e, "h", function () { return k }), n.d(e, "d", function () { return M }), n.d(e, "g", function () { return L }), n.d(e, "n", function () { return C }), n.d(e, "x", function () { return P }), n.d(e, "q", function () { return R }); var r = "|", i = "data-wf-page", o = ".w-dyn-item", a = "transform", u = "translateX", c = "translateY", s = "translateZ", f = "scaleX", l = "scaleY", d = "scaleZ", p = "rotateX", v = "rotateY", h = "rotateZ", g = "skewX", m = "skewY", y = "opacity", b = "width", w = "height", x = "backgroundColor", _ = "background", O = "borderColor", j = "color", I = "display", E = "flex", S = "willChange", T = "AUTO", A = ",", k = ":", M = "|", L = "CHILDREN", C = "IMMEDIATE_CHILDREN", P = "SIBLINGS", R = "preserve-3d" }, function (t, e) { var n; n = function () { return this }(); try { n = n || Function("return this")() || (0, eval)("this") } catch (t) { "object" == typeof window && (n = window) } t.exports = n }, function (t, e) { t.exports = function (t, e) { return t === e || t != t && e != e } }, function (t, e, n) { var r = n(4)(n(2), "Map"); t.exports = r }, function (t, e, n) { var r = n(138), i = n(145), o = n(147), a = n(148), u = n(149); function c(t) { var e = -1, n = null == t ? 0 : t.length; for (this.clear() ; ++e < n;) { var r = t[e]; this.set(r[0], r[1]) } } c.prototype.clear = r, c.prototype.delete = i, c.prototype.get = o, c.prototype.has = a, c.prototype.set = u, t.exports = c }, function (t, e) { t.exports = function (t, e) { for (var n = -1, r = e.length, i = t.length; ++n < r;) t[i + n] = e[n]; return t } }, function (t, e, n) { (function (t) { var r = n(2), i = n(165), o = "object" == typeof e && e && !e.nodeType && e, a = o && "object" == typeof t && t && !t.nodeType && t, u = a && a.exports === o ? r.Buffer : void 0, c = (u ? u.isBuffer : void 0) || i; t.exports = c }).call(e, n(68)(t)) }, function (t, e) { var n = 9007199254740991, r = /^(?:0|[1-9]\d*)$/; t.exports = function (t, e) { var i = typeof t; return !!(e = null == e ? n : e) && ("number" == i || "symbol" != i && r.test(t)) && t > -1 && t % 1 == 0 && t < e } }, function (t, e, n) { var r = n(166), i = n(167), o = n(168), a = o && o.isTypedArray, u = a ? i(a) : r; t.exports = u }, function (t, e) { var n = 9007199254740991; t.exports = function (t) { return "number" == typeof t && t > -1 && t % 1 == 0 && t <= n } }, function (t, e, n) { var r = n(33), i = n(169), o = Object.prototype.hasOwnProperty; t.exports = function (t) { if (!r(t)) return i(t); var e = []; for (var n in Object(t)) o.call(t, n) && "constructor" != n && e.push(n); return e } }, function (t, e) { var n = Object.prototype; t.exports = function (t) { var e = t && t.constructor; return t === ("function" == typeof e && e.prototype || n) } }, function (t, e, n) { var r = n(170), i = n(25), o = n(171), a = n(172), u = n(70), c = n(8), s = n(61), f = s(r), l = s(i), d = s(o), p = s(a), v = s(u), h = c; (r && "[object DataView]" != h(new r(new ArrayBuffer(1))) || i && "[object Map]" != h(new i) || o && "[object Promise]" != h(o.resolve()) || a && "[object Set]" != h(new a) || u && "[object WeakMap]" != h(new u)) && (h = function (t) { var e = c(t), n = "[object Object]" == e ? t.constructor : void 0, r = n ? s(n) : ""; if (r) switch (r) { case f: return "[object DataView]"; case l: return "[object Map]"; case d: return "[object Promise]"; case p: return "[object Set]"; case v: return "[object WeakMap]" } return e }), t.exports = h }, function (t, e, n) { var r = n(20), i = n(11); t.exports = function (t, e) { for (var n = 0, o = (e = r(e, t)).length; null != t && n < o;) t = t[i(e[n++])]; return n && n == o ? t : void 0 } }, function (t, e, n) { var r = n(0), i = n(21), o = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, a = /^\w*$/; t.exports = function (t, e) { if (r(t)) return !1; var n = typeof t; return !("number" != n && "symbol" != n && "boolean" != n && null != t && !i(t)) || a.test(t) || !o.test(t) || null != e && t in Object(e) } }, function (t, e) { t.exports = function (t) { return t } }, function (t, e, n) { var r = n(3), i = n(21), o = NaN, a = /^\s+|\s+$/g, u = /^[-+]0x[0-9a-f]+$/i, c = /^0b[01]+$/i, s = /^0o[0-7]+$/i, f = parseInt; t.exports = function (t) { if ("number" == typeof t) return t; if (i(t)) return o; if (r(t)) { var e = "function" == typeof t.valueOf ? t.valueOf() : t; t = r(e) ? e + "" : e } if ("string" != typeof t) return 0 === t ? t : +t; t = t.replace(a, ""); var n = c.test(t); return n || s.test(t) ? f(t.slice(2), n ? 2 : 8) : u.test(t) ? o : +t } }, function (t, e, n) { "use strict"; e.f = function () { return "i" + O++ }, e.l = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, e = t.events, n = t.actionLists, r = t.site, i = l()(e, function (t, e) { var n = e.eventTypeId; return t[n] || (t[n] = {}), t[n][e.id] = e, t }, {}), o = r && r.mediaQueries, a = []; o ? a = o.map(function (t) { return t.key }) : (o = [], console.warn("IX2 missing mediaQueries in site data")); return { ixData: { events: e, actionLists: n, eventTypeMap: i, mediaQueries: o, mediaQueryKeys: a } } }, e.j = function (t) { var e = t.store, n = t.select, r = t.onChange, i = t.comparator, o = void 0 === i ? j : i, a = e.getState, u = (0, e.subscribe)(function () { var t = n(a()); if (null == t) return void u(); o(t, c) || r(c = t, e) }), c = n(a()); return u }, e.c = E, e.d = function (t) { var e = t.element, n = t.actionItem; if (!m.c) return {}; switch (n.actionTypeId) { case v.g: case v.d: case v.e: case v.h: case v.b: return window.getComputedStyle(e); default: return {} } }, e.g = function (t) { var e = t.element, n = t.actionItem, r = t.computedStyle, i = void 0 === r ? {} : r, o = t.elementApi.getStyle, a = n.actionTypeId, u = n.config; switch (a) { case v.i: case v.k: case v.j: case v.l: return function (t, e) { var n = T[e]; if (!t) return n; var r = function (t) { return { xValue: s()(parseFloat(t[0]), n.xValue), yValue: s()(parseFloat(t[1]), n.yValue), zValue: s()(parseFloat(t[2]), n.zValue) } }; switch (e) { case v.i: var i = [G(k, t), G(M, t), G(L, t)]; return r(i); case v.k: var o = [G(C, t), G(P, t), G(R, t)]; return r(o); case v.j: var a = [G(N, t), G(D, t), G(z, t)]; return r(a); case v.l: var u = [G(V, t), G($, t)]; return { xValue: s()(parseFloat(u[0]), n.xValue), yValue: s()(parseFloat(u[1]), n.yValue) }; default: return } }(o(e, m.d), a); case v.f: return { value: s()(parseFloat(o(e, g.p)), 1) }; case v.g: var c = o(e, g.F), f = o(e, g.m), l = void 0, d = void 0; return l = u.widthUnit === g.a ? S.test(c) ? parseFloat(c) : parseFloat(i.width) : s()(parseFloat(c), parseFloat(i.width)), d = u.heightUnit === g.a ? S.test(f) ? parseFloat(f) : parseFloat(i.height) : s()(parseFloat(f), parseFloat(i.height)), { widthValue: l, heightValue: d }; case v.d: case v.e: case v.h: return function (t) { var e = t.element, n = t.actionTypeId, r = t.computedStyle, i = t.getStyle, o = x[n], a = i(e, o), u = X.test(a) ? a : r[o], c = G(W, u).split(g.j); return { rValue: s()(parseInt(c[0], 10), 255), gValue: s()(parseInt(c[1], 10), 255), bValue: s()(parseInt(c[2], 10), 255), aValue: s()(parseFloat(c[3]), 1) } }({ element: e, actionTypeId: a, computedStyle: i, getStyle: o }); case v.b: return { value: s()(o(e, g.k), i.display) }; default: return } }, e.e = function (t) { var e = t.element, n = t.actionItem, r = t.elementApi; switch (n.actionTypeId) { case v.i: case v.k: case v.j: case v.l: var i = n.config, o = i.xValue, a = i.yValue, u = i.zValue; return { xValue: o, yValue: a, zValue: u }; case v.g: var c = r.getStyle, s = r.setStyle, f = r.getProperty, l = n.config, d = l.widthUnit, p = l.heightUnit, h = n.config, y = h.widthValue, b = h.heightValue; if (!m.c) return { widthValue: y, heightValue: b }; if (d === g.a) { var w = c(e, g.F); s(e, g.F, ""), y = f(e, "offsetWidth"), s(e, g.F, w) } if (p === g.a) { var x = c(e, g.m); s(e, g.m, ""), b = f(e, "offsetHeight"), s(e, g.m, x) } return { widthValue: y, heightValue: b }; case v.d: case v.e: case v.h: var _ = n.config, O = _.rValue, j = _.gValue, I = _.bValue, E = _.aValue; return { rValue: O, gValue: j, bValue: I, aValue: E }; default: var S = n.config.value; return { value: S } } }, e.m = function (t, e) { var n = t.isTransform, r = t.isStyle, i = t.isGeneral; if (n) return function (t, e) { var n = t.element, r = t.current, i = t.actionItem, o = e.getStyle, a = e.setStyle, u = o(n, m.d), c = function (t, e, n) { var r = e.actionTypeId, i = e.config, o = i.xUnit, a = void 0 === o ? "" : o, u = i.yUnit, c = void 0 === u ? "" : u, s = i.zUnit, f = void 0 === s ? "" : s, l = n.xValue, d = n.yValue, p = n.zValue, h = t || F; switch (r) { case v.i: return void 0 !== l && (h = q(h, k, g.B, l + a)), void 0 !== d && (h = q(h, M, g.C, d + c)), void 0 !== p && (h = q(h, L, g.D, p + f)), h; case v.k: return void 0 !== l && (h = q(h, C, g.u, l + a)), void 0 !== d && (h = q(h, P, g.v, d + c)), void 0 !== p && (h = q(h, R, g.w, p + f)), h; case v.j: return void 0 !== l && (h = q(h, N, g.r, l + a)), void 0 !== d && (h = q(h, D, g.s, d + c)), void 0 !== p && (h = q(h, z, g.t, p + f)), h; case v.l: return void 0 !== l && (h = q(h, V, g.y, l + a)), void 0 !== d && (h = q(h, $, g.z, d + c)), h; default: return h } }(u, i, r); u !== c && (H(n, m.d, e), a(n, m.d, c), s = r, f = i.actionTypeId, l = s.xValue, d = s.yValue, p = s.zValue, (f === v.i && void 0 !== p || f === v.k && void 0 !== p || f === v.j && (void 0 !== l || void 0 !== d)) && a(n, m.e, g.q)); var s, f, l, d, p }(t, e); if (r) return function (t, e) { var n = t.element, r = t.actionItem, i = t.current, o = t.styleProp, a = e.setStyle, u = r.actionTypeId, c = r.config; switch (u) { case v.g: var s = r.config, f = s.widthUnit, l = void 0 === f ? "" : f, d = s.heightUnit, p = void 0 === d ? "" : d, h = i.widthValue, m = i.heightValue; void 0 !== h && (l === g.a && (l = "px"), H(n, g.F, e), a(n, g.F, h + l)), void 0 !== m && (p === g.a && (p = "px"), H(n, g.m, e), a(n, g.m, m + p)); break; case v.d: case v.e: case v.h: var y = x[u], b = i.rValue, w = i.gValue, _ = i.bValue, O = i.aValue; H(n, y, e), a(n, y, O >= 1 ? "rgb(" + Math.round(b) + "," + Math.round(w) + "," + Math.round(_) + ")" : "rgba(" + Math.round(b) + "," + Math.round(w) + "," + Math.round(_) + "," + O + ")"); break; default: var j = c.unit, I = void 0 === j ? "" : j; H(n, o, e), a(n, o, i.value + I) } }(t, e); if (i) return function (t, e) { var n = t.element, r = t.actionItem, i = e.setStyle; switch (r.actionTypeId) { case v.b: var o = r.config.value; return void (o === g.l && m.c ? i(n, g.k, m.b) : i(n, g.k, o)) } }(t, e) }, e.b = function (t) { var e = t.store, n = t.elementApi, r = e.getState().ixData, i = r.events, o = void 0 === i ? {} : i, a = r.actionLists, u = void 0 === a ? {} : a; Object.keys(o).forEach(function (t) { var e = o[t], r = e.action.config, i = r.actionListId, a = u[i]; a && Q({ actionList: a, event: e, elementApi: n }) }), Object.keys(u).forEach(function (t) { Q({ actionList: u[t], elementApi: n }) }) }, e.a = function (t, e) { var n = t.actionItem, r = t.element, i = e.setStyle, o = e.getStyle, a = n.actionTypeId; if (a === v.g) { var u = n.config; u.widthUnit === g.a && i(r, g.F, ""), u.heightUnit === g.a && i(r, g.m, "") } o(r, g.G) && Y({ effect: U, actionTypeId: a, elementApi: e })(r) }, e.h = J, e.k = function (t) { var e = t.actionListId, n = t.actionItemId, r = t.rawData, i = r.actionLists[e], o = i.actionItemGroups, a = i.continuousParameterGroups, u = [], c = function (t) { return u.push(p()(t, { config: { $merge: { delay: 0, duration: 0 } } })), t.id === n }; return o && o.some(function (t) { return t.actionItems.some(c) }), a && a.some(function (t) { return t.continuousActionGroups.some(function (t) { return t.actionItems.some(c) }) }), p()(r, { actionLists: { $set: b({}, e, { id: e, actionItemGroups: [{ actionItems: u }] }) } }) }, e.o = function (t, e) { var n = e.basedOn; return t === h.u && (n === h.e || null == n) || t === h.h && n === h.e }, e.i = function (t, e) { return t + g.h + e }, e.n = function (t, e) { if (null == e) return !0; return -1 !== t.indexOf(e) }, e.p = function (t) { if ("string" == typeof t) return t; var e = t.id, n = void 0 === e ? "" : e, r = t.selector, i = void 0 === r ? "" : r, o = t.useEventTarget, a = void 0 === o ? "" : o; return n + g.d + i + g.d + a }; var r, i, o, a = n(19), u = n.n(a), c = n(218), s = n.n(c), f = n(219), l = n.n(f), d = n(12), p = n.n(d), v = (n(55), n(40)), h = n(41), g = n(22), m = n(83), y = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (t) { return typeof t } : function (t) { return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t }; function b(t, e, n) { return e in t ? Object.defineProperty(t, e, { value: n, enumerable: !0, configurable: !0, writable: !0 }) : t[e] = n, t } var w = function (t) { return t.trim() }, x = Object.freeze((b(r = {}, v.d, g.c), b(r, v.e, g.e), b(r, v.h, g.i), r)), _ = Object.freeze((b(i = {}, m.d, g.A), b(i, g.c, g.b), b(i, g.p, g.p), b(i, g.F, g.F), b(i, g.m, g.m), i)), O = 1; var j = function (t, e) { return t === e }; function I(t) { var e = void 0 === t ? "undefined" : y(t); return "string" === e ? { id: t } : null != t && "object" === e ? { id: t.id, selector: t.selector, selectorGuids: t.selectorGuids, appliesTo: t.appliesTo, useEventTarget: t.useEventTarget } : {} } function E(t) { var e = t.config, n = t.event, r = t.eventTarget, i = t.elementRoot, o = t.elementApi; if (!o) throw new Error("IX2 missing elementApi"); var a = o.getValidDocument, c = o.getQuerySelector, s = o.queryDocument, f = o.getChildElements, l = o.getSiblingElements, d = o.matchSelector, p = o.elementContains, v = o.isSiblingNode, y = e.target; if (!y) return []; var b = I(y), w = b.id, x = b.selector, _ = b.selectorGuids, O = b.appliesTo, j = b.useEventTarget; if (O === h.o) { var E = a(w); return E ? [E] : [] } var S = u()(n, "action.config.affectedElements", {})[w || x] || {}, T = Boolean(S.id || S.selector), A = void 0, k = void 0, M = void 0, L = n && c(I(n.target)); if (T ? (A = S.limitAffectedElements, k = L, M = c(S)) : k = M = c({ id: w, selector: x, selectorGuids: _ }), n && j) { var C = r && (M || !0 === j) ? [r] : s(L); if (M) { if (j === g.g) return s(M).filter(function (t) { return C.some(function (e) { return p(e, t) }) }); if (j === g.x) return s(M).filter(function (t) { return C.some(function (e) { return v(e, t) }) }) } return C } return null == k || null == M ? [] : m.c && i ? s(M).filter(function (t) { return i.contains(t) }) : A === g.g ? s(k, M) : A === g.n ? f(s(k)).filter(d(M)) : A === g.x ? l(s(k)).filter(d(M)) : s(M) } var S = /px/; var T = (b(o = {}, v.i, Object.freeze({ xValue: 0, yValue: 0, zValue: 0 })), b(o, v.k, Object.freeze({ xValue: 1, yValue: 1, zValue: 1 })), b(o, v.j, Object.freeze({ xValue: 0, yValue: 0, zValue: 0 })), b(o, v.l, Object.freeze({ xValue: 0, yValue: 0 })), o), A = "\\(([^)]+)\\)", k = RegExp("" + g.B + A), M = RegExp("" + g.C + A), L = RegExp("" + g.D + A), C = RegExp("" + g.u + A), P = RegExp("" + g.v + A), R = RegExp("" + g.w + A), N = RegExp("" + g.r + A), D = RegExp("" + g.s + A), z = RegExp("" + g.t + A), V = RegExp("" + g.y + A), $ = RegExp("" + g.z + A), F = Object.keys(T).map(function (t) { var e = T[t], n = e.xValue, r = e.yValue, i = e.zValue; switch (t) { case v.i: return B([[g.B, n], [g.C, r], [g.D, i]]); case v.k: return B([[g.u, n], [g.v, r], [g.w, i]]); case v.j: return B([[g.r, n], [g.s, r], [g.t, i]]); case v.l: return B([[g.y, n], [g.z, r]]); default: return "" } }).join(" "); function B(t) { return t.map(function (t) { return t[0] + "(" + t[1] + ")" }).join(" ") } function G(t, e) { var n = t.exec(e); return n ? n[1] : "" } function q(t, e, n, r) { return t.replace(e, n + "(" + r + ")") } var X = /^rgb/, W = RegExp("rgba?\\(([^)]+)\\)"); function H(t, e, n) { if (m.c) { var r = _[e]; if (r) { var i = n.getStyle, o = n.setStyle, a = i(t, g.G); if (a) { var u = a.split(g.j).map(w); -1 === u.indexOf(r) && o(t, g.G, u.concat(r).join(g.j)) } else o(t, g.G, r) } } } function U(t, e, n) { if (m.c) { var r = _[e]; if (r) { var i = n.getStyle, o = n.setStyle, a = i(t, g.G); a && -1 !== a.indexOf(r) && o(t, g.G, a.split(g.j).map(w).filter(function (t) { return t !== r }).join(g.j)) } } } function Q(t) { var e = t.actionList, n = void 0 === e ? {} : e, r = t.event, i = t.elementApi, o = n.actionItemGroups, a = n.continuousParameterGroups; o && o.forEach(function (t) { K({ actionGroup: t, event: r, elementApi: i }) }), a && a.forEach(function (t) { t.continuousActionGroups.forEach(function (t) { K({ actionGroup: t, event: r, elementApi: i }) }) }) } function K(t) { var e = t.actionGroup, n = t.event, r = t.elementApi; e.actionItems.forEach(function (t) { var e = t.actionTypeId, i = t.config, o = Y({ effect: Z, actionTypeId: e, elementApi: r }); E({ config: i, event: n, elementApi: r }).forEach(o) }) } var Y = function (t) { var e = t.effect, n = t.actionTypeId, r = t.elementApi; return function (t) { switch (n) { case v.i: case v.k: case v.j: case v.l: e(t, m.d, r); break; case v.f: e(t, g.p, r); break; case v.g: e(t, g.F, r), e(t, g.m, r); break; case v.d: case v.e: case v.h: e(t, x[n], r); break; case v.b: e(t, g.k, r) } } }; function Z(t, e, n) { var r = n.setStyle; U(t, e, n), r(t, e, ""), e === m.d && r(t, m.e, "") } function J(t) { var e = 0, n = 0; return t.forEach(function (t, r) { var i = t.config, o = i.delay + i.duration; o >= e && (e = o, n = r) }), n } }, function (t, e, n) { "use strict"; n.d(e, "i", function () { return r }), n.d(e, "k", function () { return i }), n.d(e, "j", function () { return o }), n.d(e, "l", function () { return a }), n.d(e, "f", function () { return u }), n.d(e, "g", function () { return c }), n.d(e, "d", function () { return s }), n.d(e, "e", function () { return f }), n.d(e, "h", function () { return l }), n.d(e, "b", function () { return d }), n.d(e, "a", function () { return p }), n.d(e, "c", function () { return v }); var r = "TRANSFORM_MOVE", i = "TRANSFORM_SCALE", o = "TRANSFORM_ROTATE", a = "TRANSFORM_SKEW", u = "STYLE_OPACITY", c = "STYLE_SIZE", s = "STYLE_BACKGROUND_COLOR", f = "STYLE_BORDER", l = "STYLE_TEXT_COLOR", d = "GENERAL_DISPLAY", p = "GENERAL_CONTINUOUS_ACTION", v = "GENERAL_START_ACTION" }, function (t, e, n) { "use strict"; n.d(e, "f", function () { return r }), n.d(e, "k", function () { return i }), n.d(e, "g", function () { return o }), n.d(e, "l", function () { return a }), n.d(e, "j", function () { return u }), n.d(e, "i", function () { return c }), n.d(e, "h", function () { return s }), n.d(e, "v", function () { return f }), n.d(e, "w", function () { return l }), n.d(e, "u", function () { return d }), n.d(e, "z", function () { return p }), n.d(e, "A", function () { return v }), n.d(e, "n", function () { return h }), n.d(e, "m", function () { return g }), n.d(e, "x", function () { return m }), n.d(e, "y", function () { return y }), n.d(e, "d", function () { return b }), n.d(e, "c", function () { return w }), n.d(e, "a", function () { return x }), n.d(e, "b", function () { return _ }), n.d(e, "t", function () { return O }), n.d(e, "p", function () { return j }), n.d(e, "s", function () { return I }), n.d(e, "r", function () { return E }), n.d(e, "q", function () { return S }), n.d(e, "e", function () { return T }), n.d(e, "B", function () { return A }), n.d(e, "o", function () { return k }); var r = "MOUSE_CLICK", i = "MOUSE_SECOND_CLICK", o = "MOUSE_DOWN", a = "MOUSE_UP", u = "MOUSE_OVER", c = "MOUSE_OUT", s = "MOUSE_MOVE", f = "SCROLL_INTO_VIEW", l = "SCROLL_OUT_OF_VIEW", d = "SCROLLING_IN_VIEW", p = "TAB_ACTIVE", v = "TAB_INACTIVE", h = "NAVBAR_OPEN", g = "NAVBAR_CLOSE", m = "SLIDER_ACTIVE", y = "SLIDER_INACTIVE", b = "DROPDOWN_OPEN", w = "DROPDOWN_CLOSE", x = "COMPONENT_ACTIVE", _ = "COMPONENT_INACTIVE", O = "PAGE_START", j = "PAGE_FINISH", I = "PAGE_SCROLL_UP", E = "PAGE_SCROLL_DOWN", S = "PAGE_SCROLL", T = "ELEMENT", A = "VIEWPORT", k = "PAGE" }, function (t, e, n) { "use strict"; Object.defineProperty(e, "__esModule", { value: !0 }), n.d(e, "rawDataImported", function () { return u }), n.d(e, "sessionInitialized", function () { return c }), n.d(e, "sessionStarted", function () { return s }), n.d(e, "sessionStopped", function () { return f }), n.d(e, "previewRequested", function () { return l }), n.d(e, "playbackRequested", function () { return d }), n.d(e, "stopRequested", function () { return p }), n.d(e, "clearRequested", function () { return v }), n.d(e, "eventListenerAdded", function () { return h }), n.d(e, "eventStateChanged", function () { return g }), n.d(e, "animationFrameChanged", function () { return m }), n.d(e, "parameterChanged", function () { return y }), n.d(e, "instanceAdded", function () { return b }), n.d(e, "instanceStarted", function () { return w }), n.d(e, "instanceRemoved", function () { return x }), n.d(e, "actionListPlaybackChanged", function () { return _ }), n.d(e, "viewportWidthChanged", function () { return O }); var r = n(6), i = n(40), o = n(39), a = Object.assign || function (t) { for (var e = 1; e < arguments.length; e++) { var n = arguments[e]; for (var r in n) Object.prototype.hasOwnProperty.call(n, r) && (t[r] = n[r]) } return t }, u = function (t) { return { type: r.l, payload: a({}, Object(o.l)(t)) } }, c = function (t) { var e = t.hasBoundaryNodes; return { type: r.m, payload: { hasBoundaryNodes: e } } }, s = function () { return { type: r.n, payload: {} } }, f = function () { return { type: r.o, payload: {} } }, l = function (t) { var e = t.rawData; return { type: r.k, payload: { rawData: e } } }, d = function (t) { var e = t.actionTypeId, n = void 0 === e ? i.c : e, o = t.actionListId, a = t.actionItemId, u = t.eventId, c = t.allowEvents, s = t.immediate, f = t.verbose, l = t.rawData; return { type: r.j, payload: { actionTypeId: n, actionListId: o, actionItemId: a, eventId: u, allowEvents: c, immediate: s, verbose: f, rawData: l } } }, p = function (t) { return { type: r.p, payload: { actionListId: t } } }, v = function () { return { type: r.c, payload: {} } }, h = function (t, e) { return { type: r.d, payload: { target: t, listenerParams: e } } }, g = function (t, e) { return { type: r.e, payload: { stateKey: t, newState: e } } }, m = function (t, e) { return { type: r.b, payload: { now: t, parameters: e } } }, y = function (t, e) { return { type: r.i, payload: { key: t, value: e } } }, b = function (t) { return { type: r.f, payload: a({}, t) } }, w = function (t) { return { type: r.h, payload: { instanceId: t } } }, x = function (t) { return { type: r.g, payload: { instanceId: t } } }, _ = function (t) { var e = t.actionListId, n = t.isPlaying; return { type: r.a, payload: { actionListId: e, isPlaying: n } } }, O = function (t) { var e = t.width, n = t.mediaQueries; return { type: r.q, payload: { width: e, mediaQueries: n } } } }, function (t, e, n) { var r = n(84), i = n(44); function o(t, e) { this.__wrapped__ = t, this.__actions__ = [], this.__chain__ = !!e, this.__index__ = 0, this.__values__ = void 0 } o.prototype = r(i.prototype), o.prototype.constructor = o, t.exports = o }, function (t, e) { t.exports = function () { } }, function (t, e, n) { var r = n(84), i = n(44), o = 4294967295; function a(t) { this.__wrapped__ = t, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = o, this.__views__ = [] } a.prototype = r(i.prototype), a.prototype.constructor = a, t.exports = a }, function (t, e) { var n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (t) { return typeof t } : function (t) { return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t }; window.tram = function (t) { function e(t, e) { return (new D.Bare).init(t, e) } function r(t) { return t.replace(/[A-Z]/g, function (t) { return "-" + t.toLowerCase() }) } function i(t) { var e = parseInt(t.slice(1), 16); return [e >> 16 & 255, e >> 8 & 255, 255 & e] } function o(t, e, n) { return "#" + (1 << 24 | t << 16 | e << 8 | n).toString(16).slice(1) } function a() { } function u(t, e, n) { s("Units do not match [" + t + "]: " + e + ", " + n) } function c(t, e, n) { if (void 0 !== e && (n = e), void 0 === t) return n; var r = n; return Y.test(t) || !Z.test(t) ? r = parseInt(t, 10) : Z.test(t) && (r = 1e3 * parseFloat(t)), 0 > r && (r = 0), r == r ? r : n } function s(t) { X.debug && window && window.console.warn(t) } var f = function (t, e, r) { function i(t) { return "object" == (void 0 === t ? "undefined" : n(t)) } function o(t) { return "function" == typeof t } function a() { } return function n(u, c) { function s() { var t = new f; return o(t.init) && t.init.apply(t, arguments), t } function f() { } c === r && (c = u, u = Object), s.Bare = f; var l, d = a[t] = u[t], p = f[t] = s[t] = new a; return p.constructor = s, s.mixin = function (e) { return f[t] = s[t] = n(s, e)[t], s }, s.open = function (t) { if (l = {}, o(t) ? l = t.call(s, p, d, s, u) : i(t) && (l = t), i(l)) for (var n in l) e.call(l, n) && (p[n] = l[n]); return o(p.init) || (p.init = u), s }, s.open(c) } }("prototype", {}.hasOwnProperty), l = { ease: ["ease", function (t, e, n, r) { var i = (t /= r) * t, o = i * t; return e + n * (-2.75 * o * i + 11 * i * i + -15.5 * o + 8 * i + .25 * t) }], "ease-in": ["ease-in", function (t, e, n, r) { var i = (t /= r) * t, o = i * t; return e + n * (-1 * o * i + 3 * i * i + -3 * o + 2 * i) }], "ease-out": ["ease-out", function (t, e, n, r) { var i = (t /= r) * t, o = i * t; return e + n * (.3 * o * i + -1.6 * i * i + 2.2 * o + -1.8 * i + 1.9 * t) }], "ease-in-out": ["ease-in-out", function (t, e, n, r) { var i = (t /= r) * t, o = i * t; return e + n * (2 * o * i + -5 * i * i + 2 * o + 2 * i) }], linear: ["linear", function (t, e, n, r) { return n * t / r + e }], "ease-in-quad": ["cubic-bezier(0.550, 0.085, 0.680, 0.530)", function (t, e, n, r) { return n * (t /= r) * t + e }], "ease-out-quad": ["cubic-bezier(0.250, 0.460, 0.450, 0.940)", function (t, e, n, r) { return -n * (t /= r) * (t - 2) + e }], "ease-in-out-quad": ["cubic-bezier(0.455, 0.030, 0.515, 0.955)", function (t, e, n, r) { return (t /= r / 2) < 1 ? n / 2 * t * t + e : -n / 2 * (--t * (t - 2) - 1) + e }], "ease-in-cubic": ["cubic-bezier(0.550, 0.055, 0.675, 0.190)", function (t, e, n, r) { return n * (t /= r) * t * t + e }], "ease-out-cubic": ["cubic-bezier(0.215, 0.610, 0.355, 1)", function (t, e, n, r) { return n * ((t = t / r - 1) * t * t + 1) + e }], "ease-in-out-cubic": ["cubic-bezier(0.645, 0.045, 0.355, 1)", function (t, e, n, r) { return (t /= r / 2) < 1 ? n / 2 * t * t * t + e : n / 2 * ((t -= 2) * t * t + 2) + e }], "ease-in-quart": ["cubic-bezier(0.895, 0.030, 0.685, 0.220)", function (t, e, n, r) { return n * (t /= r) * t * t * t + e }], "ease-out-quart": ["cubic-bezier(0.165, 0.840, 0.440, 1)", function (t, e, n, r) { return -n * ((t = t / r - 1) * t * t * t - 1) + e }], "ease-in-out-quart": ["cubic-bezier(0.770, 0, 0.175, 1)", function (t, e, n, r) { return (t /= r / 2) < 1 ? n / 2 * t * t * t * t + e : -n / 2 * ((t -= 2) * t * t * t - 2) + e }], "ease-in-quint": ["cubic-bezier(0.755, 0.050, 0.855, 0.060)", function (t, e, n, r) { return n * (t /= r) * t * t * t * t + e }], "ease-out-quint": ["cubic-bezier(0.230, 1, 0.320, 1)", function (t, e, n, r) { return n * ((t = t / r - 1) * t * t * t * t + 1) + e }], "ease-in-out-quint": ["cubic-bezier(0.860, 0, 0.070, 1)", function (t, e, n, r) { return (t /= r / 2) < 1 ? n / 2 * t * t * t * t * t + e : n / 2 * ((t -= 2) * t * t * t * t + 2) + e }], "ease-in-sine": ["cubic-bezier(0.470, 0, 0.745, 0.715)", function (t, e, n, r) { return -n * Math.cos(t / r * (Math.PI / 2)) + n + e }], "ease-out-sine": ["cubic-bezier(0.390, 0.575, 0.565, 1)", function (t, e, n, r) { return n * Math.sin(t / r * (Math.PI / 2)) + e }], "ease-in-out-sine": ["cubic-bezier(0.445, 0.050, 0.550, 0.950)", function (t, e, n, r) { return -n / 2 * (Math.cos(Math.PI * t / r) - 1) + e }], "ease-in-expo": ["cubic-bezier(0.950, 0.050, 0.795, 0.035)", function (t, e, n, r) { return 0 === t ? e : n * Math.pow(2, 10 * (t / r - 1)) + e }], "ease-out-expo": ["cubic-bezier(0.190, 1, 0.220, 1)", function (t, e, n, r) { return t === r ? e + n : n * (1 - Math.pow(2, -10 * t / r)) + e }], "ease-in-out-expo": ["cubic-bezier(1, 0, 0, 1)", function (t, e, n, r) { return 0 === t ? e : t === r ? e + n : (t /= r / 2) < 1 ? n / 2 * Math.pow(2, 10 * (t - 1)) + e : n / 2 * (2 - Math.pow(2, -10 * --t)) + e }], "ease-in-circ": ["cubic-bezier(0.600, 0.040, 0.980, 0.335)", function (t, e, n, r) { return -n * (Math.sqrt(1 - (t /= r) * t) - 1) + e }], "ease-out-circ": ["cubic-bezier(0.075, 0.820, 0.165, 1)", function (t, e, n, r) { return n * Math.sqrt(1 - (t = t / r - 1) * t) + e }], "ease-in-out-circ": ["cubic-bezier(0.785, 0.135, 0.150, 0.860)", function (t, e, n, r) { return (t /= r / 2) < 1 ? -n / 2 * (Math.sqrt(1 - t * t) - 1) + e : n / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + e }], "ease-in-back": ["cubic-bezier(0.600, -0.280, 0.735, 0.045)", function (t, e, n, r, i) { return void 0 === i && (i = 1.70158), n * (t /= r) * t * ((i + 1) * t - i) + e }], "ease-out-back": ["cubic-bezier(0.175, 0.885, 0.320, 1.275)", function (t, e, n, r, i) { return void 0 === i && (i = 1.70158), n * ((t = t / r - 1) * t * ((i + 1) * t + i) + 1) + e }], "ease-in-out-back": ["cubic-bezier(0.680, -0.550, 0.265, 1.550)", function (t, e, n, r, i) { return void 0 === i && (i = 1.70158), (t /= r / 2) < 1 ? n / 2 * t * t * ((1 + (i *= 1.525)) * t - i) + e : n / 2 * ((t -= 2) * t * ((1 + (i *= 1.525)) * t + i) + 2) + e }] }, d = { "ease-in-back": "cubic-bezier(0.600, 0, 0.735, 0.045)", "ease-out-back": "cubic-bezier(0.175, 0.885, 0.320, 1)", "ease-in-out-back": "cubic-bezier(0.680, 0, 0.265, 1)" }, p = document, v = window, h = "bkwld-tram", g = /[\-\.0-9]/g, m = /[A-Z]/, y = "number", b = /^(rgb|#)/, w = /(em|cm|mm|in|pt|pc|px)$/, x = /(em|cm|mm|in|pt|pc|px|%)$/, _ = /(deg|rad|turn)$/, O = "unitless", j = /(all|none) 0s ease 0s/, I = /^(width|height)$/, E = " ", S = p.createElement("a"), T = ["Webkit", "Moz", "O", "ms"], A = ["-webkit-", "-moz-", "-o-", "-ms-"], k = function (t) { if (t in S.style) return { dom: t, css: t }; var e, n, r = "", i = t.split("-"); for (e = 0; e < i.length; e++) r += i[e].charAt(0).toUpperCase() + i[e].slice(1); for (e = 0; e < T.length; e++) if ((n = T[e] + r) in S.style) return { dom: n, css: A[e] + t } }, M = e.support = { bind: Function.prototype.bind, transform: k("transform"), transition: k("transition"), backface: k("backface-visibility"), timing: k("transition-timing-function") }; if (M.transition) { var L = M.timing.dom; if (S.style[L] = l["ease-in-back"][0], !S.style[L]) for (var C in d) l[C][0] = d[C] } var P = e.frame = function () { var t = v.requestAnimationFrame || v.webkitRequestAnimationFrame || v.mozRequestAnimationFrame || v.oRequestAnimationFrame || v.msRequestAnimationFrame; return t && M.bind ? t.bind(v) : function (t) { v.setTimeout(t, 16) } }(), R = e.now = function () { var t = v.performance, e = t && (t.now || t.webkitNow || t.msNow || t.mozNow); return e && M.bind ? e.bind(t) : Date.now || function () { return +new Date } }(), N = f(function (e) { function i(t, e) { var n = function (t) { for (var e = -1, n = t ? t.length : 0, r = []; ++e < n;) { var i = t[e]; i && r.push(i) } return r }(("" + t).split(E)), r = n[0]; e = e || {}; var i = Q[r]; if (!i) return s("Unsupported property: " + r); if (!e.weak || !this.props[r]) { var o = i[0], a = this.props[r]; return a || (a = this.props[r] = new o.Bare), a.init(this.$el, n, i, e), a } } function o(t, e, r) { if (t) { var o = void 0 === t ? "undefined" : n(t); if (e || (this.timer && this.timer.destroy(), this.queue = [], this.active = !1), "number" == o && e) return this.timer = new G({ duration: t, context: this, complete: a }), void (this.active = !0); if ("string" == o && e) { switch (t) { case "hide": f.call(this); break; case "stop": u.call(this); break; case "redraw": l.call(this); break; default: i.call(this, t, r && r[1]) } return a.call(this) } if ("function" == o) return void t.call(this, this); if ("object" == o) { var s = 0; p.call(this, t, function (t, e) { t.span > s && (s = t.span), t.stop(), t.animate(e) }, function (t) { "wait" in t && (s = c(t.wait, 0)) }), d.call(this), s > 0 && (this.timer = new G({ duration: s, context: this }), this.active = !0, e && (this.timer.complete = a)); var v = this, h = !1, g = {}; P(function () { p.call(v, t, function (t) { t.active && (h = !0, g[t.name] = t.nextStyle) }), h && v.$el.css(g) }) } } } function a() { if (this.timer && this.timer.destroy(), this.active = !1, this.queue.length) { var t = this.queue.shift(); o.call(this, t.options, !0, t.args) } } function u(t) { var e; this.timer && this.timer.destroy(), this.queue = [], this.active = !1, "string" == typeof t ? (e = {})[t] = 1 : e = "object" == (void 0 === t ? "undefined" : n(t)) && null != t ? t : this.props, p.call(this, e, v), d.call(this) } function f() { u.call(this), this.el.style.display = "none" } function l() { this.el.offsetHeight } function d() { var t, e, n = []; for (t in this.upstream && n.push(this.upstream), this.props) (e = this.props[t]).active && n.push(e.string); n = n.join(","), this.style !== n && (this.style = n, this.el.style[M.transition.dom] = n) } function p(t, e, n) { var o, a, u, c, s = e !== v, f = {}; for (o in t) u = t[o], o in K ? (f.transform || (f.transform = {}), f.transform[o] = u) : (m.test(o) && (o = r(o)), o in Q ? f[o] = u : (c || (c = {}), c[o] = u)); for (o in f) { if (u = f[o], !(a = this.props[o])) { if (!s) continue; a = i.call(this, o) } e.call(this, a, u) } n && c && n.call(this, c) } function v(t) { t.stop() } function g(t, e) { t.set(e) } function y(t) { this.$el.css(t) } function b(t, n) { e[t] = function () { return this.children ? function (t, e) { var n, r = this.children.length; for (n = 0; r > n; n++) t.apply(this.children[n], e); return this }.call(this, n, arguments) : (this.el && n.apply(this, arguments), this) } } e.init = function (e) { if (this.$el = t(e), this.el = this.$el[0], this.props = {}, this.queue = [], this.style = "", this.active = !1, X.keepInherited && !X.fallback) { var n = H(this.el, "transition"); n && !j.test(n) && (this.upstream = n) } M.backface && X.hideBackface && W(this.el, M.backface.css, "hidden") }, b("add", i), b("start", o), b("wait", function (t) { t = c(t, 0), this.active ? this.queue.push({ options: t }) : (this.timer = new G({ duration: t, context: this, complete: a }), this.active = !0) }), b("then", function (t) { return this.active ? (this.queue.push({ options: t, args: arguments }), void (this.timer.complete = a)) : s("No active transition timer. Use start() or wait() before then().") }), b("next", a), b("stop", u), b("set", function (t) { u.call(this, t), p.call(this, t, g, y) }), b("show", function (t) { "string" != typeof t && (t = "block"), this.el.style.display = t }), b("hide", f), b("redraw", l), b("destroy", function () { u.call(this), t.removeData(this.el, h), this.$el = this.el = null }) }), D = f(N, function (e) { function n(e, n) { var r = t.data(e, h) || t.data(e, h, new N.Bare); return r.el || r.init(e), n ? r.start(n) : r } e.init = function (e, r) { var i = t(e); if (!i.length) return this; if (1 === i.length) return n(i[0], r); var o = []; return i.each(function (t, e) { o.push(n(e, r)) }), this.children = o, this } }), z = f(function (t) { function e() { var t = this.get(); this.update("auto"); var e = this.get(); return this.update(t), e } function r(t) { var e = /rgba?\((\d+),\s*(\d+),\s*(\d+)/.exec(t); return (e ? o(e[1], e[2], e[3]) : t).replace(/#(\w)(\w)(\w)$/, "#$1$1$2$2$3$3") } var i = 500, a = "ease", u = 0; t.init = function (t, e, n, r) { this.$el = t, this.el = t[0]; var o = e[0]; n[2] && (o = n[2]), U[o] && (o = U[o]), this.name = o, this.type = n[1], this.duration = c(e[1], this.duration, i), this.ease = function (t, e, n) { return void 0 !== e && (n = e), t in l ? t : n }(e[2], this.ease, a), this.delay = c(e[3], this.delay, u), this.span = this.duration + this.delay, this.active = !1, this.nextStyle = null, this.auto = I.test(this.name), this.unit = r.unit || this.unit || X.defaultUnit, this.angle = r.angle || this.angle || X.defaultAngle, X.fallback || r.fallback ? this.animate = this.fallback : (this.animate = this.transition, this.string = this.name + E + this.duration + "ms" + ("ease" != this.ease ? E + l[this.ease][0] : "") + (this.delay ? E + this.delay + "ms" : "")) }, t.set = function (t) { t = this.convert(t, this.type), this.update(t), this.redraw() }, t.transition = function (t) { this.active = !0, t = this.convert(t, this.type), this.auto && ("auto" == this.el.style[this.name] && (this.update(this.get()), this.redraw()), "auto" == t && (t = e.call(this))), this.nextStyle = t }, t.fallback = function (t) { var n = this.el.style[this.name] || this.convert(this.get(), this.type); t = this.convert(t, this.type), this.auto && ("auto" == n && (n = this.convert(this.get(), this.type)), "auto" == t && (t = e.call(this))), this.tween = new B({ from: n, to: t, duration: this.duration, delay: this.delay, ease: this.ease, update: this.update, context: this }) }, t.get = function () { return H(this.el, this.name) }, t.update = function (t) { W(this.el, this.name, t) }, t.stop = function () { (this.active || this.nextStyle) && (this.active = !1, this.nextStyle = null, W(this.el, this.name, this.get())); var t = this.tween; t && t.context && t.destroy() }, t.convert = function (t, e) { if ("auto" == t && this.auto) return t; var i, o = "number" == typeof t, a = "string" == typeof t; switch (e) { case y: if (o) return t; if (a && "" === t.replace(g, "")) return +t; i = "number(unitless)"; break; case b: if (a) { if ("" === t && this.original) return this.original; if (e.test(t)) return "#" == t.charAt(0) && 7 == t.length ? t : r(t) } i = "hex or rgb string"; break; case w: if (o) return t + this.unit; if (a && e.test(t)) return t; i = "number(px) or string(unit)"; break; case x: if (o) return t + this.unit; if (a && e.test(t)) return t; i = "number(px) or string(unit or %)"; break; case _: if (o) return t + this.angle; if (a && e.test(t)) return t; i = "number(deg) or string(angle)"; break; case O: if (o) return t; if (a && x.test(t)) return t; i = "number(unitless) or string(unit or %)" } return function (t, e) { s("Type warning: Expected: [" + t + "] Got: [" + (void 0 === e ? "undefined" : n(e)) + "] " + e) }(i, t), t }, t.redraw = function () { this.el.offsetHeight } }), V = f(z, function (t, e) { t.init = function () { e.init.apply(this, arguments), this.original || (this.original = this.convert(this.get(), b)) } }), $ = f(z, function (t, e) { t.init = function () { e.init.apply(this, arguments), this.animate = this.fallback }, t.get = function () { return this.$el[this.name]() }, t.update = function (t) { this.$el[this.name](t) } }), F = f(z, function (t, e) { function n(t, e) { var n, r, i, o, a; for (n in t) i = (o = K[n])[0], r = o[1] || n, a = this.convert(t[n], i), e.call(this, r, a, i) } t.init = function () { e.init.apply(this, arguments), this.current || (this.current = {}, K.perspective && X.perspective && (this.current.perspective = X.perspective, W(this.el, this.name, this.style(this.current)), this.redraw())) }, t.set = function (t) { n.call(this, t, function (t, e) { this.current[t] = e }), W(this.el, this.name, this.style(this.current)), this.redraw() }, t.transition = function (t) { var e = this.values(t); this.tween = new q({ current: this.current, values: e, duration: this.duration, delay: this.delay, ease: this.ease }); var n, r = {}; for (n in this.current) r[n] = n in e ? e[n] : this.current[n]; this.active = !0, this.nextStyle = this.style(r) }, t.fallback = function (t) { var e = this.values(t); this.tween = new q({ current: this.current, values: e, duration: this.duration, delay: this.delay, ease: this.ease, update: this.update, context: this }) }, t.update = function () { W(this.el, this.name, this.style(this.current)) }, t.style = function (t) { var e, n = ""; for (e in t) n += e + "(" + t[e] + ") "; return n }, t.values = function (t) { var e, r = {}; return n.call(this, t, function (t, n, i) { r[t] = n, void 0 === this.current[t] && (e = 0, ~t.indexOf("scale") && (e = 1), this.current[t] = this.convert(e, i)) }), r } }), B = f(function (e) { function n() { var t, e, r, i = c.length; if (i) for (P(n), e = R(), t = i; t--;) (r = c[t]) && r.render(e) } var r = { ease: l.ease[1], from: 0, to: 1 }; e.init = function (t) { this.duration = t.duration || 0, this.delay = t.delay || 0; var e = t.ease || r.ease; l[e] && (e = l[e][1]), "function" != typeof e && (e = r.ease), this.ease = e, this.update = t.update || a, this.complete = t.complete || a, this.context = t.context || this, this.name = t.name; var n = t.from, i = t.to; void 0 === n && (n = r.from), void 0 === i && (i = r.to), this.unit = t.unit || "", "number" == typeof n && "number" == typeof i ? (this.begin = n, this.change = i - n) : this.format(i, n), this.value = this.begin + this.unit, this.start = R(), !1 !== t.autoplay && this.play() }, e.play = function () { var t; this.active || (this.start || (this.start = R()), this.active = !0, t = this, 1 === c.push(t) && P(n)) }, e.stop = function () { var e, n, r; this.active && (this.active = !1, e = this, (r = t.inArray(e, c)) >= 0 && (n = c.slice(r + 1), c.length = r, n.length && (c = c.concat(n)))) }, e.render = function (t) { var e, n = t - this.start; if (this.delay) { if (n <= this.delay) return; n -= this.delay } if (n < this.duration) { var r = this.ease(n, 0, 1, this.duration); return e = this.startRGB ? function (t, e, n) { return o(t[0] + n * (e[0] - t[0]), t[1] + n * (e[1] - t[1]), t[2] + n * (e[2] - t[2])) }(this.startRGB, this.endRGB, r) : function (t) { return Math.round(t * s) / s }(this.begin + r * this.change), this.value = e + this.unit, void this.update.call(this.context, this.value) } e = this.endHex || this.begin + this.change, this.value = e + this.unit, this.update.call(this.context, this.value), this.complete.call(this.context), this.destroy() }, e.format = function (t, e) { if (e += "", "#" == (t += "").charAt(0)) return this.startRGB = i(e), this.endRGB = i(t), this.endHex = t, this.begin = 0, void (this.change = 1); if (!this.unit) { var n = e.replace(g, ""); n !== t.replace(g, "") && u("tween", e, t), this.unit = n } e = parseFloat(e), t = parseFloat(t), this.begin = this.value = e, this.change = t - e }, e.destroy = function () { this.stop(), this.context = null, this.ease = this.update = this.complete = a }; var c = [], s = 1e3 }), G = f(B, function (t) { t.init = function (t) { this.duration = t.duration || 0, this.complete = t.complete || a, this.context = t.context, this.play() }, t.render = function (t) { t - this.start < this.duration || (this.complete.call(this.context), this.destroy()) } }), q = f(B, function (t, e) { t.init = function (t) { var e, n; for (e in this.context = t.context, this.update = t.update, this.tweens = [], this.current = t.current, t.values) n = t.values[e], this.current[e] !== n && this.tweens.push(new B({ name: e, from: this.current[e], to: n, duration: t.duration, delay: t.delay, ease: t.ease, autoplay: !1 })); this.play() }, t.render = function (t) { var e, n, r = !1; for (e = this.tweens.length; e--;) (n = this.tweens[e]).context && (n.render(t), this.current[n.name] = n.value, r = !0); return r ? void (this.update && this.update.call(this.context)) : this.destroy() }, t.destroy = function () { if (e.destroy.call(this), this.tweens) { var t; for (t = this.tweens.length; t--;) this.tweens[t].destroy(); this.tweens = null, this.current = null } } }), X = e.config = { debug: !1, defaultUnit: "px", defaultAngle: "deg", keepInherited: !1, hideBackface: !1, perspective: "", fallback: !M.transition, agentTests: [] }; e.fallback = function (t) { if (!M.transition) return X.fallback = !0; X.agentTests.push("(" + t + ")"); var e = new RegExp(X.agentTests.join("|"), "i"); X.fallback = e.test(navigator.userAgent) }, e.fallback("6.0.[2-5] Safari"), e.tween = function (t) { return new B(t) }, e.delay = function (t, e, n) { return new G({ complete: e, duration: t, context: n }) }, t.fn.tram = function (t) { return e.call(null, this, t) }; var W = t.style, H = t.css, U = { transform: M.transform && M.transform.css }, Q = { color: [V, b], background: [V, b, "background-color"], "outline-color": [V, b], "border-color": [V, b], "border-top-color": [V, b], "border-right-color": [V, b], "border-bottom-color": [V, b], "border-left-color": [V, b], "border-width": [z, w], "border-top-width": [z, w], "border-right-width": [z, w], "border-bottom-width": [z, w], "border-left-width": [z, w], "border-spacing": [z, w], "letter-spacing": [z, w], margin: [z, w], "margin-top": [z, w], "margin-right": [z, w], "margin-bottom": [z, w], "margin-left": [z, w], padding: [z, w], "padding-top": [z, w], "padding-right": [z, w], "padding-bottom": [z, w], "padding-left": [z, w], "outline-width": [z, w], opacity: [z, y], top: [z, x], right: [z, x], bottom: [z, x], left: [z, x], "font-size": [z, x], "text-indent": [z, x], "word-spacing": [z, x], width: [z, x], "min-width": [z, x], "max-width": [z, x], height: [z, x], "min-height": [z, x], "max-height": [z, x], "line-height": [z, O], "scroll-top": [$, y, "scrollTop"], "scroll-left": [$, y, "scrollLeft"] }, K = {}; M.transform && (Q.transform = [F], K = { x: [x, "translateX"], y: [x, "translateY"], rotate: [_], rotateX: [_], rotateY: [_], scale: [y], scaleX: [y], scaleY: [y], skew: [_], skewX: [_], skewY: [_] }), M.transform && M.backface && (K.z = [x, "translateZ"], K.rotateZ = [_], K.scaleZ = [y], K.perspective = [w]); var Y = /ms/, Z = /s|\./; return t.tram = e }(window.jQuery) }, function (t, e, n) { "use strict"; var r = n(48); function i(t, e) { var n = document.createEvent("CustomEvent"); n.initCustomEvent(e, !0, !0, null), t.dispatchEvent(n) } var o = window.jQuery, a = {}, u = { reset: function (t, e) { r.triggers.reset(t, e) }, intro: function (t, e) { r.triggers.intro(t, e), i(e, "COMPONENT_ACTIVE") }, outro: function (t, e) { r.triggers.outro(t, e), i(e, "COMPONENT_INACTIVE") } }; a.triggers = {}, a.types = { INTRO: "w-ix-intro.w-ix", OUTRO: "w-ix-outro.w-ix" }, o.extend(a.triggers, u), t.exports = a }, function (t, e, n) { "use strict"; var r = window.jQuery, i = {}, o = [], a = { reset: function (t, e) { e.__wf_intro = null }, intro: function (t, e) { e.__wf_intro || (e.__wf_intro = !0, r(e).triggerHandler(i.types.INTRO)) }, outro: function (t, e) { e.__wf_intro && (e.__wf_intro = null, r(e).triggerHandler(i.types.OUTRO)) } }; i.triggers = {}, i.types = { INTRO: "w-ix-intro.w-ix", OUTRO: "w-ix-outro.w-ix" }, i.init = function () { for (var t = o.length, e = 0; e < t; e++) { var n = o[e]; n[0](0, n[1]) } o = [], r.extend(i.triggers, a) }, i.async = function () { for (var t in a) { var e = a[t]; a.hasOwnProperty(t) && (i.triggers[t] = function (t, n) { o.push([e, n]) }) } }, i.async(), t.exports = i }, function (t, e, n) { "use strict"; var r = n(50), i = n(107); n(108), n(109), n(54), n(53); n.d(e, "b", function () { return r.b }), n.d(e, "a", function () { return i.a }) }, function (t, e, n) { "use strict"; n.d(e, "a", function () { return o }), e.b = function t(e, n, a) { var u; "function" == typeof n && void 0 === a && (a = n, n = void 0); if (void 0 !== a) { if ("function" != typeof a) throw new Error("Expected the enhancer to be a function."); return a(t)(e, n) } if ("function" != typeof e) throw new Error("Expected the reducer to be a function."); var c = e; var s = n; var f = []; var l = f; var d = !1; function p() { l === f && (l = f.slice()) } function v() { return s } function h(t) { if ("function" != typeof t) throw new Error("Expected listener to be a function."); var e = !0; return p(), l.push(t), function () { if (e) { e = !1, p(); var n = l.indexOf(t); l.splice(n, 1) } } } function g(t) { if (!Object(r.a)(t)) throw new Error("Actions must be plain objects. Use custom middleware for async actions."); if (void 0 === t.type) throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?'); if (d) throw new Error("Reducers may not dispatch actions."); try { d = !0, s = c(s, t) } finally { d = !1 } for (var e = f = l, n = 0; n < e.length; n++) e[n](); return t } g({ type: o.INIT }); return u = { dispatch: g, subscribe: h, getState: v, replaceReducer: function (t) { if ("function" != typeof t) throw new Error("Expected the nextReducer to be a function."); c = t, g({ type: o.INIT }) } }, u[i.a] = function () { var t, e = h; return (t = { subscribe: function (t) { if ("object" != typeof t) throw new TypeError("Expected the observer to be an object."); function n() { t.next && t.next(v()) } n(); var r = e(n); return { unsubscribe: r } } })[i.a] = function () { return this }, t }, u }; var r = n(51), i = n(104), o = { INIT: "@@redux/INIT" } }, function (t, e, n) { "use strict"; var r = n(96), i = n(101), o = n(103), a = "[object Object]", u = Function.prototype, c = Object.prototype, s = u.toString, f = c.hasOwnProperty, l = s.call(Object); e.a = function (t) { if (!Object(o.a)(t) || Object(r.a)(t) != a) return !1; var e = Object(i.a)(t); if (null === e) return !0; var n = f.call(e, "constructor") && e.constructor; return "function" == typeof n && n instanceof n && s.call(n) == l } }, function (t, e, n) { "use strict"; var r = n(97).a.Symbol; e.a = r }, function (t, e, n) { "use strict" }, function (t, e, n) { "use strict"; e.a = function () { for (var t = arguments.length, e = Array(t), n = 0; n < t; n++) e[n] = arguments[n]; if (0 === e.length) return function (t) { return t }; if (1 === e.length) return e[0]; var r = e[e.length - 1], i = e.slice(0, -1); return function () { return i.reduceRight(function (t, e) { return e(t) }, r.apply(void 0, arguments)) } } }, function (t, e, n) { "use strict"; e.b = i, e.a = function (t, e) { if (0 === e) return 0; if (1 === e) return 1; return i(e > 0 && t && r[t] ? r[t](e) : e) }; var r = n(116); function i(t) { var e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 5, n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 10, r = Math.pow(n, e), i = Number(Math.round(t * r) / r); return Math.abs(i) > 1e-4 ? i : 0 } }, function (t, e, n) { "use strict"; e.a = function (t) { Object(O.j)({ store: t, select: function (t) { var e = t.ixRequest; return e.preview }, onChange: P }), Object(O.j)({ store: t, select: function (t) { var e = t.ixRequest; return e.playback }, onChange: N }), Object(O.j)({ store: t, select: function (t) { var e = t.ixRequest; return e.stop }, onChange: D }), Object(O.j)({ store: t, select: function (t) { var e = t.ixRequest; return e.clear }, onChange: z }) }, e.c = V, e.e = $, e.d = H, e.b = U; var r = n(57), i = n.n(r), o = n(19), a = n.n(o), u = n(186), c = n.n(u), s = n(192), f = n.n(s), l = n(204), d = n.n(l), p = n(205), v = n.n(p), h = n(208), g = n.n(h), m = n(212), y = n.n(m), b = n(213), w = n.n(b), x = n(216), _ = n.n(x), O = n(39), j = n(41), I = n(42), E = n(222), S = n(22), T = n(40), A = n(223), k = Object.assign || function (t) { for (var e = 1; e < arguments.length; e++) { var n = arguments[e]; for (var r in n) Object.prototype.hasOwnProperty.call(n, r) && (t[r] = n[r]) } return t }; var M = navigator.userAgent, L = M.match(/iPad/i) || M.match(/iPhone/), C = 12; function P(t, e) { V({ store: e, rawData: t.rawData, allowEvents: !0 }), document.dispatchEvent(new CustomEvent("IX2_PREVIEW_LOAD")) } function R(t) { return t && y()(t, "_EFFECT") } function N(t, e) { var n = t.actionTypeId, r = t.actionListId, i = t.actionItemId, o = t.eventId, a = t.allowEvents, u = t.immediate, c = t.verbose, s = void 0 === c || c, f = t.rawData; if (r && i && f && u && (f = Object(O.k)({ actionListId: r, actionItemId: i, rawData: f })), V({ store: e, rawData: f, allowEvents: a }), r && n === T.c || R(n)) { H({ store: e, actionListId: r }), W({ store: e, actionListId: r, eventId: o }); var l = U({ store: e, eventId: o, actionListId: r, immediate: u, verbose: s }); s && l && e.dispatch(Object(I.actionListPlaybackChanged)({ actionListId: r, isPlaying: !u })) } } function D(t, e) { var n = t.actionListId; n ? H({ store: e, actionListId: n }) : function (t) { var e = t.store, n = e.getState().ixInstances; g()(n, function (t) { if (!t.continuous) { var n = t.actionListId, r = t.verbose; K(t, e), r && e.dispatch(Object(I.actionListPlaybackChanged)({ actionListId: n, isPlaying: !1 })) } }) }({ store: e }), $(e) } function z(t, e) { $(e), Object(O.b)({ store: e, elementApi: E }) } function V(t) { var e = t.store, n = t.rawData, r = t.allowEvents, o = e.getState().ixSession; n && e.dispatch(Object(I.rawDataImported)(n)), o.active || (e.dispatch(Object(I.sessionInitialized)({ hasBoundaryNodes: Boolean(document.querySelector(S.f)) })), r && function (t) { var e = t.getState().ixData.eventTypeMap; g()(e, function (e, n) { var r = A.a[n]; r ? function (t) { var e = t.logic, n = t.store, r = t.events; !function (t) { if (L) { var e = {}, n = ""; for (var r in t) { var i = t[r], o = i.eventTypeId, a = i.target, u = E.getQuerySelector(a); e[u] || o !== j.f && o !== j.k || (e[u] = !0, n += u + "{cursor: pointer;touch-action: manipulation;}") } if (n) { var c = document.createElement("style"); c.textContent = n, document.body.appendChild(c) } } }(r); var o = e.types, u = e.handler, s = n.getState().ixData, f = s.actionLists, l = G(r, X); if (c()(l)) { g()(l, function (t, e) { var o = r[e], u = o.action, c = o.id, s = u.config.actionListId; if (u.actionTypeId === T.a) { var l = Array.isArray(o.config) ? o.config : [o.config]; l.forEach(function (e) { var r = e.continuousParameterGroupId, o = a()(f, s + ".continuousParameterGroups", []), u = i()(o, function (t) { var e = t.id; return e === r }), l = (e.smoothing || 0) / 100, d = (e.restingState || 0) / 100; u && t.forEach(function (t, r) { var i = c + S.h + r; !function (t) { var e = t.store, n = t.eventStateKey, r = t.eventTarget, i = t.eventId, o = t.eventConfig, u = t.actionListId, c = t.parameterGroup, s = t.smoothing, f = t.restingValue, l = e.getState(), d = l.ixData, p = l.ixSession, v = d.events[i], h = v.eventTypeId, g = {}, m = {}, y = [], b = c.continuousActionGroups, w = c.id; Object(O.o)(h, o) && (w = Object(O.i)(n, w)); var x = p.hasBoundaryNodes && r ? E.getClosestElement(r, S.f) : null; b.forEach(function (t) { var e = t.keyframe, n = t.actionItems; n.forEach(function (t) { var n = t.actionTypeId, i = t.config.target; if (i) { var o = i.boundaryMode ? x : null, a = Object(O.p)(i) + S.h + n; if (m[a] = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [], e = arguments[1], n = arguments[2], r = [].concat(function (t) { if (Array.isArray(t)) { for (var e = 0, n = Array(t.length) ; e < t.length; e++) n[e] = t[e]; return n } return Array.from(t) }(t)), i = void 0; return r.some(function (t, n) { return t.keyframe === e && (i = n, !0) }), null == i && (i = r.length, r.push({ keyframe: e, actionItems: [] })), r[i].actionItems.push(n), r }(m[a], e, t), !g[a]) { g[a] = !0; var u = t.config; Object(O.c)({ config: u, event: v, eventTarget: r, elementRoot: o, elementApi: E }).forEach(function (t) { y.push({ element: t, key: a }) }) } } }) }), y.forEach(function (t) { var n = t.element, r = t.key, o = m[r], c = a()(o, "[0].actionItems[0]", {}), l = Object(O.e)({ element: n, actionItem: c, elementApi: E }); Q({ store: e, element: n, eventId: i, actionListId: u, actionItem: c, destination: l, continuous: !0, parameterId: w, actionGroups: o, smoothing: s, restingValue: f }) }) }({ store: n, eventStateKey: i, eventTarget: t, eventId: c, eventConfig: e, actionListId: s, parameterGroup: u, smoothing: l, restingValue: d }) }) }) } (u.actionTypeId === T.c || R(u.actionTypeId)) && W({ store: n, actionListId: s, eventId: c }) }); var d = function (t) { var e = n.getState(), i = e.ixSession; q(l, function (e, o, a) { var c = r[o], f = i.eventState[a], l = c.action, d = c.mediaQueries, p = void 0 === d ? s.mediaQueryKeys : d; if (Object(O.n)(p, i.mediaQueryKey)) { var v = function () { var r = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, i = u({ store: n, element: e, event: c, eventConfig: r, nativeEvent: t, eventStateKey: a }, f); _()(i, f) || n.dispatch(Object(I.eventStateChanged)(a, i)) }; if (l.actionTypeId === T.a) { var h = Array.isArray(c.config) ? c.config : [c.config]; h.forEach(v) } else v() } }) }, p = w()(d, C), v = function (t) { var e = t.target, r = void 0 === e ? document : e, i = t.types, o = t.throttle; i.split(" ").filter(Boolean).forEach(function (t) { var e = o ? p : d; r.addEventListener(t, e), n.dispatch(Object(I.eventListenerAdded)(r, [t, e])) }) }; Array.isArray(o) ? o.forEach(v) : "string" == typeof o && v(e) } }({ logic: r, store: t, events: e }) : console.warn("IX2 event type not configured: " + n) }), t.getState().ixSession.eventListeners.length && function (t) { function e() { var e = t.getState(), n = e.ixSession, r = e.ixData, i = window.innerWidth; if (i !== n.viewportWidth) { var o = r.mediaQueries; t.dispatch(Object(I.viewportWidthChanged)({ width: i, mediaQueries: o })) } } B.forEach(function (n) { window.addEventListener(n, e), t.dispatch(Object(I.eventListenerAdded)(window, [n, e])) }), e() }(t) }(e), e.dispatch(Object(I.sessionStarted)()), function (t) { !function e(n) { var r = t.getState(), i = r.ixSession, o = r.ixParameters; i.active && (t.dispatch(Object(I.animationFrameChanged)(n, o)), requestAnimationFrame(e)) }(window.performance.now()) }(e)) } function $(t) { var e = t.getState().ixSession; e.active && (e.eventListeners.forEach(F), t.dispatch(Object(I.sessionStopped)())) } function F(t) { var e = t.target, n = t.listenerParams; e.removeEventListener.apply(e, n) } var B = ["resize", "orientationchange"]; var G = function (t, e) { return f()(v()(t, e), d.a) }, q = function (t, e) { g()(t, function (t, n) { t.forEach(function (t, r) { var i = n + S.h + r; e(t, n, i) }) }) }, X = function (t) { var e = { target: t.target }; return Object(O.c)({ config: e, elementApi: E }) }; function W(t) { var e = t.store, n = t.actionListId, r = t.eventId, i = e.getState().ixData, o = i.actionLists, u = i.events[r], c = o[n]; c && c.useFirstGroupAsInitialState && a()(c, "actionItemGroups[0].actionItems", []).forEach(function (t) { var i = t.config; Object(O.c)({ config: i, event: u, elementApi: E }).forEach(function (i) { Q({ destination: Object(O.e)({ element: i, actionItem: t, elementApi: E }), origin: Object(O.g)({ element: i, actionItem: t, elementApi: E }), immediate: !0, store: e, element: i, eventId: r, actionItem: t, actionListId: n }) }) }) } function H(t) { var e = t.store, n = t.eventId, r = t.eventTarget, i = t.eventStateKey, o = t.actionListId, u = e.getState(), c = u.ixInstances, s = u.ixSession.hasBoundaryNodes && r ? E.getClosestElement(r, S.f) : null; g()(c, function (t) { var r = a()(t, "actionItem.config.target.boundaryMode"), u = !i || t.eventStateKey === i; if (t.actionListId === o && t.eventId === n && u) { if (s && r && !E.elementContains(s, t.element)) return; K(t, e), t.verbose && e.dispatch(Object(I.actionListPlaybackChanged)({ actionListId: o, isPlaying: !1 })) } }) } function U(t) { var e = t.store, n = t.eventId, r = t.eventTarget, i = t.eventStateKey, o = t.actionListId, u = t.groupIndex, c = void 0 === u ? 0 : u, s = t.immediate, f = t.verbose, l = e.getState(), d = l.ixData, p = l.ixSession, v = d.events[n] || {}, h = v.mediaQueries, g = void 0 === h ? d.mediaQueryKeys : h, m = a()(d, "actionLists." + o, {}), y = m.actionItemGroups; c >= y.length && a()(v, "config.loop") && (c = 0), 0 === c && m.useFirstGroupAsInitialState && c++; var b = a()(y, [c, "actionItems"], []); if (!b.length) return !1; if (!Object(O.n)(g, p.mediaQueryKey)) return !1; var w = p.hasBoundaryNodes && r ? E.getClosestElement(r, S.f) : null, x = Object(O.h)(b), _ = !1; return b.forEach(function (t, a) { var u = t.config, l = u.target; if (l) { var d = l.boundaryMode ? w : null; Object(O.c)({ config: u, event: v, eventTarget: r, elementRoot: d, elementApi: E }).forEach(function (u, l) { _ = !0; var d = x === a && 0 === l, p = Object(O.d)({ element: u, actionItem: t }), v = Object(O.g)({ element: u, actionItem: t, computedStyle: p, elementApi: E }), h = Object(O.e)({ element: u, actionItem: t, elementApi: E }); Q({ store: e, element: u, actionItem: t, eventId: n, eventTarget: r, eventStateKey: i, actionListId: o, groupIndex: c, isCarrier: d, origin: v, destination: h, immediate: s, verbose: f }) }) } }), _ } function Q(t) { var e = t.store, n = function (t, e) { var n = {}; for (var r in t) e.indexOf(r) >= 0 || Object.prototype.hasOwnProperty.call(t, r) && (n[r] = t[r]); return n }(t, ["store"]), r = !n.continuous, i = n.immediate, o = Object(O.f)(); e.dispatch(Object(I.instanceAdded)(k({ instanceId: o }, n))), i ? function (t, e) { t.dispatch(Object(I.instanceStarted)(e)); var n = t.getState().ixParameters; t.dispatch(Object(I.animationFrameChanged)(Number.POSITIVE_INFINITY, n)), Y(t.getState().ixInstances[e], t) }(e, o) : (Object(O.j)({ store: e, select: function (t) { return t.ixInstances[o] }, onChange: Y }), r && e.dispatch(Object(I.instanceStarted)(o))) } function K(t, e) { Object(O.a)(t, E), e.dispatch(Object(I.instanceRemoved)(t.id)) } function Y(t, e) { var n = t.active, r = t.continuous, i = t.complete, o = t.current, a = t.groupIndex, u = t.eventId, c = t.eventTarget, s = t.eventStateKey, f = t.actionListId, l = t.isGeneral, d = t.isCarrier, p = t.verbose, v = e.getState(), h = v.ixData, g = v.ixSession, m = (h.events[u] || {}).mediaQueries, y = void 0 === m ? h.mediaQueryKeys : m; if (Object(O.n)(y, g.mediaQueryKey) && (r || n || i) && ((o || l && i) && Object(O.m)(t, E), i)) { if (d) { var b = U({ store: e, eventId: u, eventTarget: c, eventStateKey: s, actionListId: f, groupIndex: a + 1, verbose: p }); p && !b && e.dispatch(Object(I.actionListPlaybackChanged)({ actionListId: f, isPlaying: !1 })) } K(t, e) } } }, function (t, e, n) { var r = n(119)(n(183)); t.exports = r }, function (t, e, n) { var r = n(13), i = n(127), o = n(128), a = n(129), u = n(130), c = n(131); function s(t) { var e = this.__data__ = new r(t); this.size = e.size } s.prototype.clear = i, s.prototype.delete = o, s.prototype.get = a, s.prototype.has = u, s.prototype.set = c, t.exports = s }, function (t, e, n) { var r = n(8), i = n(3), o = "[object AsyncFunction]", a = "[object Function]", u = "[object GeneratorFunction]", c = "[object Proxy]"; t.exports = function (t) { if (!i(t)) return !1; var e = r(t); return e == a || e == u || e == o || e == c } }, function (t, e, n) { (function (e) { var n = "object" == typeof e && e && e.Object === Object && e; t.exports = n }).call(e, n(23)) }, function (t, e) { var n = Function.prototype.toString; t.exports = function (t) { if (null != t) { try { return n.call(t) } catch (t) { } try { return t + "" } catch (t) { } } return "" } }, function (t, e, n) { var r = n(150), i = n(5); t.exports = function t(e, n, o, a, u) { return e === n || (null == e || null == n || !i(e) && !i(n) ? e != e && n != n : r(e, n, o, a, t, u)) } }, function (t, e, n) { var r = n(151), i = n(154), o = n(155), a = 1, u = 2; t.exports = function (t, e, n, c, s, f) { var l = n & a, d = t.length, p = e.length; if (d != p && !(l && p > d)) return !1; var v = f.get(t); if (v && f.get(e)) return v == e; var h = -1, g = !0, m = n & u ? new r : void 0; for (f.set(t, e), f.set(e, t) ; ++h < d;) { var y = t[h], b = e[h]; if (c) var w = l ? c(b, y, h, e, t, f) : c(y, b, h, t, e, f); if (void 0 !== w) { if (w) continue; g = !1; break } if (m) { if (!i(e, function (t, e) { if (!o(m, e) && (y === t || s(y, t, n, c, f))) return m.push(e) })) { g = !1; break } } else if (y !== b && !s(y, b, n, c, f)) { g = !1; break } } return f.delete(t), f.delete(e), g } }, function (t, e, n) { var r = n(27), i = n(0); t.exports = function (t, e, n) { var o = e(t); return i(t) ? o : r(o, n(t)) } }, function (t, e, n) { var r = n(162), i = n(66), o = Object.prototype.propertyIsEnumerable, a = Object.getOwnPropertySymbols, u = a ? function (t) { return null == t ? [] : (t = Object(t), r(a(t), function (e) { return o.call(t, e) })) } : i; t.exports = u }, function (t, e) { t.exports = function () { return [] } }, function (t, e, n) { var r = n(163), i = n(18), o = n(0), a = n(28), u = n(29), c = n(30), s = Object.prototype.hasOwnProperty; t.exports = function (t, e) { var n = o(t), f = !n && i(t), l = !n && !f && a(t), d = !n && !f && !l && c(t), p = n || f || l || d, v = p ? r(t.length, String) : [], h = v.length; for (var g in t) !e && !s.call(t, g) || p && ("length" == g || l && ("offset" == g || "parent" == g) || d && ("buffer" == g || "byteLength" == g || "byteOffset" == g) || u(g, h)) || v.push(g); return v } }, function (t, e) { t.exports = function (t) { return t.webpackPolyfill || (t.deprecate = function () { }, t.paths = [], t.children || (t.children = []), Object.defineProperty(t, "loaded", { enumerable: !0, get: function () { return t.l } }), Object.defineProperty(t, "id", { enumerable: !0, get: function () { return t.i } }), t.webpackPolyfill = 1), t } }, function (t, e) { t.exports = function (t, e) { return function (n) { return t(e(n)) } } }, function (t, e, n) { var r = n(4)(n(2), "WeakMap"); t.exports = r }, function (t, e, n) { var r = n(3); t.exports = function (t) { return t == t && !r(t) } }, function (t, e) { t.exports = function (t, e) { return function (n) { return null != n && n[t] === e && (void 0 !== e || t in Object(n)) } } }, function (t, e, n) { var r = n(74); t.exports = function (t) { return null == t ? "" : r(t) } }, function (t, e, n) { var r = n(10), i = n(75), o = n(0), a = n(21), u = 1 / 0, c = r ? r.prototype : void 0, s = c ? c.toString : void 0; t.exports = function t(e) { if ("string" == typeof e) return e; if (o(e)) return i(e, t) + ""; if (a(e)) return s ? s.call(e) : ""; var n = e + ""; return "0" == n && 1 / e == -u ? "-0" : n } }, function (t, e) { t.exports = function (t, e) { for (var n = -1, r = null == t ? 0 : t.length, i = Array(r) ; ++n < r;) i[n] = e(t[n], n, t); return i } }, function (t, e) { t.exports = function (t) { return function (e) { return null == e ? void 0 : e[t] } } }, function (t, e, n) { var r = n(185); t.exports = function (t) { var e = r(t), n = e % 1; return e == e ? n ? e - n : e : 0 } }, function (t, e, n) { var r = n(79); t.exports = function (t, e, n) { "__proto__" == e && r ? r(t, e, { configurable: !0, enumerable: !0, value: n, writable: !0 }) : t[e] = n } }, function (t, e, n) { var r = n(4), i = function () { try { var t = r(Object, "defineProperty"); return t({}, "", {}), t } catch (t) { } }(); t.exports = i }, function (t, e, n) { var r = n(206), i = n(17); t.exports = function (t, e) { return t && r(t, e, i) } }, function (t, e, n) { var r = n(80), i = n(210)(r); t.exports = i }, function (t, e) { t.exports = function (t, e, n) { return t == t && (void 0 !== n && (t = t <= n ? t : n), void 0 !== e && (t = t >= e ? t : e)), t } }, function (t, e, n) { "use strict"; n.d(e, "c", function () { return o }), n.d(e, "a", function () { return u }), n.d(e, "b", function () { return c }), n.d(e, "d", function () { return s }), n.d(e, "e", function () { return l }); var r = n(57), i = n.n(r), o = "undefined" != typeof window, a = function (t, e) { return o ? t() : e }, u = a(function () { return i()(["matches", "matchesSelector", "mozMatchesSelector", "msMatchesSelector", "oMatchesSelector", "webkitMatchesSelector"], function (t) { return t in Element.prototype }) }), c = a(function () { var t = document.createElement("i"), e = ["flex", "-webkit-flex", "-ms-flexbox", "-moz-box", "-webkit-box"]; try { for (var n = e.length, r = 0; r < n; r++) { var i = e[r]; if (t.style.display = i, t.style.display === i) return i } return "" } catch (t) { return "" } }, "flex"), s = a(function () { var t = document.createElement("i"); if (null == t.style.transform) for (var e = ["Webkit", "Moz", "ms"], n = e.length, r = 0; r < n; r++) { var i = e[r] + "Transform"; if (void 0 !== t.style[i]) return i } return "transform" }, "transform"), f = s.split("transform")[0], l = f ? f + "TransformStyle" : "transformStyle" }, function (t, e, n) { var r = n(3), i = Object.create, o = function () { function t() { } return function (e) { if (!r(e)) return {}; if (i) return i(e); t.prototype = e; var n = new t; return t.prototype = void 0, n } }(); t.exports = o }, function (t, e, n) { var r = n(236), i = n(237), o = r ? function (t) { return r.get(t) } : i; t.exports = o }, function (t, e, n) { var r = n(238), i = Object.prototype.hasOwnProperty; t.exports = function (t) { for (var e = t.name + "", n = r[e], o = i.call(r, e) ? n.length : 0; o--;) { var a = n[o], u = a.func; if (null == u || u == t) return a.name } return e } }, function (t, e, n) { n(88), n(90), n(91), n(93), n(94), n(244), n(245), n(246), n(247), n(248), t.exports = n(249) }, function (t, e, n) { var r = n(1); r.define("brand", t.exports = function (t) { var e, n = {}, i = document, o = t("html"), a = t("body"), u = ".w-webflow-badge", c = window.location, s = /PhantomJS/i.test(navigator.userAgent), f = "fullscreenchange webkitfullscreenchange mozfullscreenchange msfullscreenchange"; function l() { var n = i.fullScreen || i.mozFullScreen || i.webkitIsFullScreen || i.msFullscreenElement || Boolean(i.webkitFullscreenElement); t(e).attr("style", n ? "display: none !important;" : "") } function d() { var t = a.children(u), n = t.length && t.get(0) === e, i = r.env("editor"); n ? i && t.remove() : (t.length && t.remove(), i || a.append(e)) } return n.ready = function () { var n, r, a, u = o.attr("data-wf-status"), p = o.attr("data-wf-domain") || ""; /\.webflow\.io$/i.test(p) && c.hostname !== p && (u = !0), u && !s && (e = e || (n = t('<a class="w-webflow-badge"></a>').attr("href", "https://webflow.com?utm_campaign=brandjs"), r = t("<img>").attr("src", "../../ext_iframe/img/webflow-badge-icon.60efbf6ec9.svg").css({ marginRight: "8px", width: "16px" }), a = t("<img>").attr("src", "../../ext_iframe/img/webflow-badge-text.6faa6a38cd.svg"), n.append(r, a), n[0]), d(), setTimeout(d, 500), t(i).off(f, l).on(f, l)) }, n }) }, function (t, e, n) {
     var r = window.$, i = n(46) && r.tram;
     /*!
      * Webflow._ (aka) Underscore.js 1.6.0 (custom build)
      * _.each
      * _.map
      * _.find
      * _.filter
      * _.any
      * _.contains
      * _.delay
      * _.defer
      * _.throttle (webflow)
      * _.debounce
      * _.keys
      * _.has
      * _.now
      *
      * http://underscorejs.org
      * (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
      * Underscore may be freely distributed under the MIT license.
      * @license MIT
      */
     t.exports = function () { var t = { VERSION: "1.6.0-Webflow" }, e = {}, n = Array.prototype, r = Object.prototype, o = Function.prototype, a = (n.push, n.slice), u = (n.concat, r.toString, r.hasOwnProperty), c = n.forEach, s = n.map, f = (n.reduce, n.reduceRight, n.filter), l = (n.every, n.some), d = n.indexOf, p = (n.lastIndexOf, Array.isArray, Object.keys), v = (o.bind, t.each = t.forEach = function (n, r, i) { if (null == n) return n; if (c && n.forEach === c) n.forEach(r, i); else if (n.length === +n.length) { for (var o = 0, a = n.length; o < a; o++) if (r.call(i, n[o], o, n) === e) return } else { var u = t.keys(n); for (o = 0, a = u.length; o < a; o++) if (r.call(i, n[u[o]], u[o], n) === e) return } return n }); t.map = t.collect = function (t, e, n) { var r = []; return null == t ? r : s && t.map === s ? t.map(e, n) : (v(t, function (t, i, o) { r.push(e.call(n, t, i, o)) }), r) }, t.find = t.detect = function (t, e, n) { var r; return h(t, function (t, i, o) { if (e.call(n, t, i, o)) return r = t, !0 }), r }, t.filter = t.select = function (t, e, n) { var r = []; return null == t ? r : f && t.filter === f ? t.filter(e, n) : (v(t, function (t, i, o) { e.call(n, t, i, o) && r.push(t) }), r) }; var h = t.some = t.any = function (n, r, i) { r || (r = t.identity); var o = !1; return null == n ? o : l && n.some === l ? n.some(r, i) : (v(n, function (t, n, a) { if (o || (o = r.call(i, t, n, a))) return e }), !!o) }; t.contains = t.include = function (t, e) { return null != t && (d && t.indexOf === d ? -1 != t.indexOf(e) : h(t, function (t) { return t === e })) }, t.delay = function (t, e) { var n = a.call(arguments, 2); return setTimeout(function () { return t.apply(null, n) }, e) }, t.defer = function (e) { return t.delay.apply(t, [e, 1].concat(a.call(arguments, 1))) }, t.throttle = function (t) { var e, n, r; return function () { e || (e = !0, n = arguments, r = this, i.frame(function () { e = !1, t.apply(r, n) })) } }, t.debounce = function (e, n, r) { var i, o, a, u, c, s = function s() { var f = t.now() - u; f < n ? i = setTimeout(s, n - f) : (i = null, r || (c = e.apply(a, o), a = o = null)) }; return function () { a = this, o = arguments, u = t.now(); var f = r && !i; return i || (i = setTimeout(s, n)), f && (c = e.apply(a, o), a = o = null), c } }, t.defaults = function (e) { if (!t.isObject(e)) return e; for (var n = 1, r = arguments.length; n < r; n++) { var i = arguments[n]; for (var o in i) void 0 === e[o] && (e[o] = i[o]) } return e }, t.keys = function (e) { if (!t.isObject(e)) return []; if (p) return p(e); var n = []; for (var r in e) t.has(e, r) && n.push(r); return n }, t.has = function (t, e) { return u.call(t, e) }, t.isObject = function (t) { return t === Object(t) }, t.now = Date.now || function () { return (new Date).getTime() }, t.templateSettings = { evaluate: /<%([\s\S]+?)%>/g, interpolate: /<%=([\s\S]+?)%>/g, escape: /<%-([\s\S]+?)%>/g }; var g = /(.)^/, m = { "'": "'", "\\": "\\", "\r": "r", "\n": "n", "\u2028": "u2028", "\u2029": "u2029" }, y = /\\|'|\r|\n|\u2028|\u2029/g, b = function (t) { return "\\" + m[t] }; return t.template = function (e, n, r) { !n && r && (n = r), n = t.defaults({}, n, t.templateSettings); var i = RegExp([(n.escape || g).source, (n.interpolate || g).source, (n.evaluate || g).source].join("|") + "|$", "g"), o = 0, a = "__p+='"; e.replace(i, function (t, n, r, i, u) { return a += e.slice(o, u).replace(y, b), o = u + t.length, n ? a += "'+\n((__t=(" + n + "))==null?'':_.escape(__t))+\n'" : r ? a += "'+\n((__t=(" + r + "))==null?'':__t)+\n'" : i && (a += "';\n" + i + "\n__p+='"), t }), a += "';\n", n.variable || (a = "with(obj||{}){\n" + a + "}\n"), a = "var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n" + a + "return __p;\n"; try { var u = new Function(n.variable || "obj", "_", a) } catch (t) { throw t.source = a, t } var c = function (e) { return u.call(this, e, t) }, s = n.variable || "obj"; return c.source = "function(" + s + "){\n" + a + "}", c }, t }()
 }, function (t, e, n) { var r = n(1), i = n(47); r.define("dropdown", t.exports = function (t, e) { var n, o, a = {}, u = t(document), c = r.env(), s = r.env.touch, f = ".w-dropdown", l = "w--open", d = "w-close" + f, p = i.triggers, v = 900, h = !1; function g() { o = c && r.env("design"), (n = u.find(f)).each(m) } function m(n, i) { var a = t(i), s = t.data(i, f); s || (s = t.data(i, f, { open: !1, el: a, config: {} })), s.list = a.children(".w-dropdown-list"), s.toggle = a.children(".w-dropdown-toggle"), s.links = s.list.children(".w-dropdown-link"), s.outside = function (n) { n.outside && u.off(_() + f, n.outside); return e.debounce(function (e) { if (n.open) { var i = t(e.target); if (!i.closest(".w-dropdown-toggle").length) { var o = -1 === t.inArray(n.el[0], i.parents(f)), a = r.env("editor"); if (o) { if (a) { var u = 1 === i.parents().length && 1 === i.parents("svg").length, c = i.parents(".w-editor-bem-EditorHoverControls").length; if (u || c) return } x(n) } } } }) }(s), s.complete = function (t) { return function () { t.list.removeClass(l), t.toggle.removeClass(l), t.manageZ && t.el.css("z-index", "") } }(s), s.leave = function (t) { return function () { t.hovering = !1, x(t) } }(s), s.moveOutside = function (n) { return e.debounce(function (e) { if (n.open) { var r = t(e.target), i = -1 === t.inArray(n.el[0], r.parents(f)); if (i) { var o = r.parents(".w-editor-bem-EditorHoverControls").length, a = r.parents(".w-editor-bem-RTToolbar").length, u = t(".w-editor-bem-EditorOverlay"), c = u.find(".w-editor-edit-outline").length || u.find(".w-editor-bem-RTToolbar").length; if (o || a || c) return; n.hovering = !1, x(n) } } }) }(s), a.off(f), s.toggle.off(f), y(s), s.nav && s.nav.off(f), s.nav = a.closest(".w-nav"), s.nav.on(d, b(s)), o ? a.on("setting" + f, b(s)) : (s.toggle.on(_() + f, function (t) { return e.debounce(function () { t.open ? x(t) : w(t) }) }(s)), s.config.hover && s.toggle.on("mouseenter" + f, function (t) { return function () { t.hovering = !0, w(t) } }(s)), a.on(d, b(s)), c && (s.hovering = !1, x(s))) } function y(t) { var e = Number(t.el.css("z-index")); t.manageZ = e === v || e === v + 1, t.config = { hover: Boolean(t.el.attr("data-hover")) && !s, delay: Number(t.el.attr("data-delay")) || 0 } } function b(t) { return function (e, n) { return n = n || {}, "w-close" === e.type ? x(t) : "setting" === e.type ? (y(t), !0 === n.open && w(t), void (!1 === n.open && x(t, !0))) : void 0 } } function w(e) { if (!e.open) { !function (e) { var r = e.el[0]; n.each(function (e, n) { var i = t(n); i.is(r) || i.has(r).length || i.triggerHandler(d) }) }(e), e.open = !0, e.list.addClass(l), e.toggle.addClass(l), p.intro(0, e.el[0]), r.redraw.up(), e.manageZ && e.el.css("z-index", v + 1); var i = r.env("editor"); o || u.on(_() + f, e.outside), e.hovering && !i && e.el.on("mouseleave" + f, e.leave), e.hovering && i && u.on("mousemove" + f, e.moveOutside), window.clearTimeout(e.delayId) } } function x(t, e) { if (t.open && (!t.config.hover || !t.hovering)) { t.open = !1; var n = t.config; if (p.outro(0, t.el[0]), u.off(_() + f, t.outside), t.el.off("mouseleave" + f, t.leave), u.off("mousemove" + f, t.moveOutside), window.clearTimeout(t.delayId), !n.delay || e) return t.complete(); t.delayId = window.setTimeout(t.complete, n.delay) } } function _() { return s ? "tap" : "mouseup" } return a.ready = g, a.design = function () { h && u.find(f).each(function (e, n) { t(n).triggerHandler(d) }), h = !1, g() }, a.preview = function () { h = !0, g() }, a }) }, function (t, e, n) { var r = n(1); r.define("forms", t.exports = function (t, e) { var i = {}; n(92); var o, a, u, c = t(document), s = window.location, f = (window.XDomainRequest && window.atob, ".w-form"), l = /e(-)?mail/i, d = /^\S+@\S+$/, p = window.alert, v = r.env(), h = /list-manage[1-9]?.com/i, g = e.debounce(function () { p("Oops! This page has improperly configured forms. Please contact your website administrator to fix this issue.") }, 100); function m(e, n) { var r = t(n), i = t.data(n, f); i || (i = t.data(n, f, { form: r })), y(i); var o = r.closest("div.w-form"); i.done = o.find("> .w-form-done"), i.fail = o.find("> .w-form-fail"); var u = i.action = r.attr("action"); i.handler = null, i.redirect = r.attr("data-redirect"), h.test(u) ? i.handler = x : u || (a ? i.handler = "function" == typeof hostedSubmitWebflow ? hostedSubmitWebflow : w : g()) } function y(t) { var e = t.btn = t.form.find(':input[type="submit"]'); t.wait = t.btn.attr("data-wait") || null, t.success = !1, e.prop("disabled", !1), t.label && e.val(t.label) } function b(e, n) { var r = null; return n = n || {}, e.find(':input:not([type="submit"])').each(function (i, o) { var a = t(o), u = a.attr("type"), c = a.attr("data-name") || a.attr("name") || "Field " + (i + 1), s = a.val(); if ("checkbox" === u && (s = a.is(":checked")), "radio" === u) { if (null === n[c] || "string" == typeof n[c]) return; s = e.find('input[name="' + a.attr("name") + '"]:checked').val() || null } "string" == typeof s && (s = t.trim(s)), n[c] = s, r = r || function (t, e, n, r) { var i = null; "password" === e ? i = "Passwords cannot be submitted." : t.attr("required") && (r ? l.test(t.attr("type")) && (d.test(r) || (i = "Please enter a valid email address for: " + n)) : i = "Please fill out the required field: " + n); return i }(a, u, c, s) }), r } function w(t) { O(t), _(t) } function x(n) { y(n); var r = n.form, i = {}; if (!/^https/.test(s.href) || /^https/.test(n.action)) { O(n); var o, a = b(r, i); if (a) return p(a); !function (t) { var e = t.btn, n = t.wait; e.prop("disabled", !0), n && (t.label = e.val(), e.val(n)) }(n), e.each(i, function (t, e) { l.test(e) && (i.EMAIL = t), /^((full[ _-]?)?name)$/i.test(e) && (o = t), /^(first[ _-]?name)$/i.test(e) && (i.FNAME = t), /^(last[ _-]?name)$/i.test(e) && (i.LNAME = t) }), o && !i.FNAME && (o = o.split(" "), i.FNAME = o[0], i.LNAME = i.LNAME || o[1]); var u = n.action.replace("/post?", "/post-json?") + "&c=?", c = u.indexOf("u=") + 2; c = u.substring(c, u.indexOf("&", c)); var f = u.indexOf("id=") + 3; f = u.substring(f, u.indexOf("&", f)), i["b_" + c + "_" + f] = "", t.ajax({ url: u, data: i, dataType: "jsonp" }).done(function (t) { n.success = "success" === t.result || /already/.test(t.msg), n.success || console.info("MailChimp error: " + t.msg), _(n) }).fail(function () { _(n) }) } else r.attr("method", "post") } function _(t) { var e = t.form, n = t.redirect, i = t.success; i && n ? r.location(n) : (t.done.toggle(i), t.fail.toggle(!i), e.toggle(!i), y(t)) } function O(t) { t.evt && t.evt.preventDefault(), t.evt = null } return i.ready = i.design = i.preview = function () { !function () { if (a = t("html").attr("data-wf-site"), !(o = t(f + " form")).length) return; o.each(m) }(), v || u || (u = !0, c.on("submit", f + " form", function (e) { var n = t.data(this, f); n.handler && (n.evt = e, n.handler(n)) })) }, i }) }, function (t, e) {
     /*!
      * jQuery-ajaxTransport-XDomainRequest - v1.0.3
      * 2014-12-16 WEBFLOW - Removed UMD wrapper
      * https://github.com/MoonScript/jQuery-ajaxTransport-XDomainRequest
      * Copyright (c) 2014 Jason Moon (@JSONMOON)
      * @license MIT (/blob/master/LICENSE.txt)
      */
     t.exports = function (t) { if (!t.support.cors && t.ajaxTransport && window.XDomainRequest) { var e = /^https?:\/\//i, n = /^get|post$/i, r = new RegExp("^" + location.protocol, "i"); t.ajaxTransport("* text html xml json", function (i, o, a) { if (i.crossDomain && i.async && n.test(i.type) && e.test(i.url) && r.test(i.url)) { var u = null; return { send: function (e, n) { var r = "", a = (o.dataType || "").toLowerCase(); u = new XDomainRequest, /^\d+$/.test(o.timeout) && (u.timeout = o.timeout), u.ontimeout = function () { n(500, "timeout") }, u.onload = function () { var e = "Content-Length: " + u.responseText.length + "\r\nContent-Type: " + u.contentType, r = { code: 200, message: "success" }, i = { text: u.responseText }; try { if ("html" === a || /text\/html/i.test(u.contentType)) i.html = u.responseText; else if ("json" === a || "text" !== a && /\/json/i.test(u.contentType)) try { i.json = t.parseJSON(u.responseText) } catch (t) { r.code = 500, r.message = "parseerror" } else if ("xml" === a || "text" !== a && /\/xml/i.test(u.contentType)) { var o = new ActiveXObject("Microsoft.XMLDOM"); o.async = !1; try { o.loadXML(u.responseText) } catch (t) { o = void 0 } if (!o || !o.documentElement || o.getElementsByTagName("parsererror").length) throw r.code = 500, r.message = "parseerror", "Invalid XML: " + u.responseText; i.xml = o } } catch (t) { throw t } finally { n(r.code, r.message, i, e) } }, u.onprogress = function () { }, u.onerror = function () { n(500, "error", { text: u.responseText }) }, o.data && (r = "string" === t.type(o.data) ? o.data : t.param(o.data)), u.open(i.type, i.url), u.send(r) }, abort: function () { u && u.abort() } } } }) } }(window.jQuery)
 }, function (t, e, n) { var r = n(1), i = n(48); r.define("ix", t.exports = function (t, e) { var n, o, a = {}, u = t(window), c = ".w-ix", s = t.tram, f = r.env, l = f(), d = f.chrome && f.chrome < 35, p = "none 0s ease 0s", v = t(), h = {}, g = [], m = [], y = [], b = 1, w = { tabs: ".w-tab-link, .w-tab-pane", dropdown: ".w-dropdown", slider: ".w-slide", navbar: ".w-nav" }; function x(t) { t && (h = {}, e.each(t, function (t) { h[t.slug] = t.value }), _()) } function _() { !function () { var e = t("[data-ix]"); if (!e.length) return; e.each(I), e.each(O), g.length && (r.scroll.on(E), setTimeout(E, 1)); m.length && r.load(S); y.length && setTimeout(T, b) }(), i.init(), r.redraw.up() } function O(n, o) { var u = t(o), s = u.attr("data-ix"), f = h[s]; if (f) { var d = f.triggers; d && (a.style(u, f.style), e.each(d, function (t) { var e = {}, n = t.type, o = t.stepsB && t.stepsB.length; function a() { A(t, u, { group: "A" }) } function s() { A(t, u, { group: "B" }) } if ("load" !== n) { if ("click" === n) return u.on("click" + c, function (n) { r.validClick(n.currentTarget) && ("#" === u.attr("href") && n.preventDefault(), A(t, u, { group: e.clicked ? "B" : "A" }), o && (e.clicked = !e.clicked)) }), void (v = v.add(u)); if ("hover" === n) return u.on("mouseenter" + c, a), u.on("mouseleave" + c, s), void (v = v.add(u)); if ("scroll" !== n) { var f = w[n]; if (f) { var d = u.closest(f); return d.on(i.types.INTRO, a).on(i.types.OUTRO, s), void (v = v.add(d)) } } else g.push({ el: u, trigger: t, state: { active: !1 }, offsetTop: j(t.offsetTop), offsetBot: j(t.offsetBot) }) } else t.preload && !l ? m.push(a) : y.push(a) })) } } function j(t) { if (!t) return 0; t = String(t); var e = parseInt(t, 10); return e != e ? 0 : (t.indexOf("%") > 0 && (e /= 100) >= 1 && (e = .999), e) } function I(e, n) { t(n).off(c) } function E() { for (var t = u.scrollTop(), e = u.height(), n = g.length, r = 0; r < n; r++) { var i = g[r], o = i.el, a = i.trigger, c = a.stepsB && a.stepsB.length, s = i.state, f = o.offset().top, l = o.outerHeight(), d = i.offsetTop, p = i.offsetBot; d < 1 && d > 0 && (d *= e), p < 1 && p > 0 && (p *= e); var v = f + l - d >= t && f + p <= t + e; v !== s.active && ((!1 !== v || c) && (s.active = v, A(a, o, { group: v ? "A" : "B" }))) } } function S() { for (var t = m.length, e = 0; e < t; e++) m[e]() } function T() { for (var t = y.length, e = 0; e < t; e++) y[e]() } function A(e, r, i, o) { var a = (i = i || {}).done, u = e.preserve3d; if (!n || i.force) { var c = i.group || "A", f = e["loop" + c], p = e["steps" + c]; if (p && p.length) { if (p.length < 2 && (f = !1), !o) { var v = e.selector; v && (r = e.descend ? r.find(v) : e.siblings ? r.siblings(v) : t(v), l && r.attr("data-ix-affect", 1)), d && r.addClass("w-ix-emptyfix"), u && r.css("transform-style", "preserve-3d") } for (var h = s(r), g = { omit3d: !u }, m = 0; m < p.length; m++) k(h, p[m], g); g.start ? h.then(y) : y() } } function y() { if (f) return A(e, r, i, !0); "auto" === g.width && h.set({ width: "auto" }), "auto" === g.height && h.set({ height: "auto" }), a && a() } } function k(t, e, n) { var i = "add", o = "start"; n.start && (i = o = "then"); var a = e.transition; if (a) { a = a.split(","); for (var u = 0; u < a.length; u++) { var c = a[u]; t[i](c) } } var s = M(e, n) || {}; if (null != s.width && (n.width = s.width), null != s.height && (n.height = s.height), null == a) { n.start ? t.then(function () { var e = this.queue; this.set(s), s.display && (t.redraw(), r.redraw.up()), this.queue = e, this.next() }) : (t.set(s), s.display && (t.redraw(), r.redraw.up())); var f = s.wait; null != f && (t.wait(f), n.start = !0) } else { if (s.display) { var l = s.display; delete s.display, n.start ? t.then(function () { var t = this.queue; this.set({ display: l }).redraw(), r.redraw.up(), this.queue = t, this.next() }) : (t.set({ display: l }).redraw(), r.redraw.up()) } t[o](s), n.start = !0 } } function M(t, e) { var n = e && e.omit3d, r = {}, i = !1; for (var o in t) "transition" !== o && "keysort" !== o && (!n || "z" !== o && "rotateX" !== o && "rotateY" !== o && "scaleZ" !== o) && (r[o] = t[o], i = !0); return i ? r : null } return a.init = function (t) { setTimeout(function () { x(t) }, 1) }, a.preview = function () { n = !1, b = 100, setTimeout(function () { x(window.__wf_ix) }, 1) }, a.design = function () { n = !0, a.destroy() }, a.destroy = function () { o = !0, v.each(I), r.scroll.off(E), i.async(), g = [], m = [], y = [] }, a.ready = function () { if (l) return f("design") ? a.design() : a.preview(); h && o && (o = !1, _()) }, a.run = A, a.style = l ? function (e, n) { var r = s(e); if (t.isEmptyObject(n)) return; e.css("transition", ""); var i = e.css("transition"); i === p && (i = r.upstream = null); r.upstream = p, r.set(M(n)), r.upstream = i } : function (t, e) { s(t).set(M(e)) }, a }) }, function (t, e, n) { var r = n(1), i = n(95); r.define("ix2", t.exports = function () { return i }) }, function (t, e, n) { "use strict"; Object.defineProperty(e, "__esModule", { value: !0 }), n.d(e, "init", function () { return f }), n.d(e, "destroy", function () { return l }), n.d(e, "store", function () { return s }); var r = n(49), i = n(110), o = n(56), a = n(1), u = n.n(a), c = n(42); n.d(e, "actions", function () { return c }); var s = Object(r.b)(i.a); function f(t) { l(), Object(o.c)({ store: s, rawData: t, allowEvents: !0 }) } function l() { Object(o.e)(s) } u.a.env() && Object(o.a)(s) }, function (t, e, n) { "use strict"; var r = n(52), i = n(99), o = n(100), a = "[object Null]", u = "[object Undefined]", c = r.a ? r.a.toStringTag : void 0; e.a = function (t) { return null == t ? void 0 === t ? u : a : c && c in Object(t) ? Object(i.a)(t) : Object(o.a)(t) } }, function (t, e, n) { "use strict"; var r = n(98), i = "object" == typeof self && self && self.Object === Object && self, o = r.a || i || Function("return this")(); e.a = o }, function (t, e, n) { "use strict"; (function (t) { var n = "object" == typeof t && t && t.Object === Object && t; e.a = n }).call(e, n(23)) }, function (t, e, n) { "use strict"; var r = n(52), i = Object.prototype, o = i.hasOwnProperty, a = i.toString, u = r.a ? r.a.toStringTag : void 0; e.a = function (t) { var e = o.call(t, u), n = t[u]; try { t[u] = void 0; var r = !0 } catch (t) { } var i = a.call(t); return r && (e ? t[u] = n : delete t[u]), i } }, function (t, e, n) { "use strict"; var r = Object.prototype.toString; e.a = function (t) { return r.call(t) } }, function (t, e, n) { "use strict"; var r = n(102), i = Object(r.a)(Object.getPrototypeOf, Object); e.a = i }, function (t, e, n) { "use strict"; e.a = function (t, e) { return function (n) { return t(e(n)) } } }, function (t, e, n) { "use strict"; e.a = function (t) { return null != t && "object" == typeof t } }, function (t, e, n) { "use strict"; (function (t, r) { var i, o = n(106); i = "undefined" != typeof self ? self : "undefined" != typeof window ? window : void 0 !== t ? t : r; var a = Object(o.a)(i); e.a = a }).call(e, n(23), n(105)(t)) }, function (t, e) { t.exports = function (t) { if (!t.webpackPolyfill) { var e = Object.create(t); e.children || (e.children = []), Object.defineProperty(e, "loaded", { enumerable: !0, get: function () { return e.l } }), Object.defineProperty(e, "id", { enumerable: !0, get: function () { return e.i } }), Object.defineProperty(e, "exports", { enumerable: !0 }), e.webpackPolyfill = 1 } return e } }, function (t, e, n) { "use strict"; e.a = function (t) { var e, n = t.Symbol; "function" == typeof n ? n.observable ? e = n.observable : (e = n("observable"), n.observable = e) : e = "@@observable"; return e } }, function (t, e, n) { "use strict"; e.a = function (t) { for (var e = Object.keys(t), n = {}, o = 0; o < e.length; o++) { var a = e[o]; 0, "function" == typeof t[a] && (n[a] = t[a]) } var u, c = Object.keys(n); try { !function (t) { Object.keys(t).forEach(function (e) { var n = t[e], i = n(void 0, { type: r.a.INIT }); if (void 0 === i) throw new Error('Reducer "' + e + '" returned undefined during initialization. If the state passed to the reducer is undefined, you must explicitly return the initial state. The initial state may not be undefined.'); var o = "@@redux/PROBE_UNKNOWN_ACTION_" + Math.random().toString(36).substring(7).split("").join("."); if (void 0 === n(void 0, { type: o })) throw new Error('Reducer "' + e + "\" returned undefined when probed with a random type. Don't try to handle " + r.a.INIT + ' or other actions in "redux/*" namespace. They are considered private. Instead, you must return the current state for any unknown actions, unless it is undefined, in which case you must return the initial state, regardless of the action type. The initial state may not be undefined.') }) }(n) } catch (t) { u = t } return function () { var t = arguments.length <= 0 || void 0 === arguments[0] ? {} : arguments[0], e = arguments[1]; if (u) throw u; for (var r = !1, o = {}, a = 0; a < c.length; a++) { var s = c[a], f = n[s], l = t[s], d = f(l, e); if (void 0 === d) { var p = i(s, e); throw new Error(p) } o[s] = d, r = r || d !== l } return r ? o : t } }; var r = n(50); n(51), n(53); function i(t, e) { var n = e && e.type; return "Given action " + (n && '"' + n.toString() + '"' || "an action") + ', reducer "' + t + '" returned undefined. To ignore an action, you must explicitly return the previous state.' } }, function (t, e, n) { "use strict" }, function (t, e, n) { "use strict"; n(54), Object.assign }, function (t, e, n) { "use strict"; var r = n(49), i = n(111), o = n(112), a = n(114), u = n(115), c = n(118); e.a = Object(r.a)({ ixData: i.a, ixRequest: o.a, ixSession: a.a, ixInstances: u.a, ixParameters: c.a }) }, function (t, e, n) { "use strict"; n.d(e, "a", function () { return i }); var r = n(6), i = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : Object.freeze({}), e = arguments[1]; switch (e.type) { case r.l: return e.payload.ixData || Object.freeze({}); default: return t } } }, function (t, e, n) { "use strict"; n.d(e, "a", function () { return l }); var r, i = n(6), o = n(12), a = n.n(o), u = Object.assign || function (t) { for (var e = 1; e < arguments.length; e++) { var n = arguments[e]; for (var r in n) Object.prototype.hasOwnProperty.call(n, r) && (t[r] = n[r]) } return t }; function c(t, e, n) { return e in t ? Object.defineProperty(t, e, { value: n, enumerable: !0, configurable: !0, writable: !0 }) : t[e] = n, t } var s = { preview: {}, playback: {}, stop: {}, clear: {} }, f = Object.create(null, (c(r = {}, i.k, { value: "preview" }), c(r, i.j, { value: "playback" }), c(r, i.p, { value: "stop" }), c(r, i.c, { value: "clear" }), r)), l = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : s, e = arguments[1]; return e.type in f ? a()(t, c({}, f[e.type], { $set: u({}, e.payload) })) : t } }, function (t, e, n) { "use strict"; t.exports = function (t, e, n, r, i, o, a, u) { if (!t) { var c; if (void 0 === e) c = new Error("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings."); else { var s = [n, r, i, o, a, u], f = 0; (c = new Error(e.replace(/%s/g, function () { return s[f++] }))).name = "Invariant Violation" } throw c.framesToPop = 1, c } } }, function (t, e, n) { "use strict"; n.d(e, "a", function () { return c }); var r = n(6), i = n(12), o = n.n(i); function a(t, e, n) { return e in t ? Object.defineProperty(t, e, { value: n, enumerable: !0, configurable: !0, writable: !0 }) : t[e] = n, t } var u = { active: !1, eventListeners: [], eventState: {}, playbackState: {}, viewportWidth: 0, mediaQueryKey: null, hasBoundaryNodes: !1 }, c = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : u, e = arguments[1]; switch (e.type) { case r.m: var n = e.payload.hasBoundaryNodes; return o()(t, { hasBoundaryNodes: { $set: n } }); case r.n: return o()(t, { active: { $set: !0 } }); case r.o: return u; case r.d: return o()(t, { eventListeners: { $push: [e.payload] } }); case r.e: return o()(t, { eventState: a({}, e.payload.stateKey, { $set: e.payload.newState }) }); case r.a: var i = e.payload, c = i.actionListId, s = i.isPlaying; return o()(t, { playbackState: a({}, c, { $set: s }) }); case r.q: for (var f = e.payload, l = f.width, d = f.mediaQueries, p = d.length, v = null, h = 0; h < p; h++) { var g = d[h], m = g.key, y = g.min, b = g.max; if (l >= y && l <= b) { v = m; break } } return o()(t, { viewportWidth: { $set: l }, mediaQueryKey: { $set: v } }); default: return t } } }, function (t, e, n) { "use strict"; n.d(e, "a", function () { return f }); var r = n(6), i = n(12), o = n.n(i), a = n(55); function u(t, e, n) { return e in t ? Object.defineProperty(t, e, { value: n, enumerable: !0, configurable: !0, writable: !0 }) : t[e] = n, t } var c = function (t, e) { var n = t.position, r = t.parameterId, i = t.actionGroups, u = t.destinationKeys, c = t.smoothing, s = t.restingValue, f = e.payload.parameters, l = Math.max(1 - c, .01), d = f[r]; null == d && (l = 1, d = s); var p = Math.max(d, 0) || 0, v = Object(a.b)(p - n), h = Object(a.b)(n + v * l), g = 100 * h; if (h === n && t.current) return t; for (var m = void 0, y = void 0, b = void 0, w = void 0, x = 0, _ = i.length; x < _; x++) { var O = i[x], j = O.keyframe, I = O.actionItems; if (0 === x && (m = I[0]), g >= j) { m = I[0]; var E = i[x + 1], S = E && g !== j; y = S ? E.actionItems[0] : null, S && (b = j / 100, w = (E.keyframe - j) / 100) } } var T = {}; if (m && !y) for (var A = 0, k = u.length; A < k; A++) { var M = u[A]; T[M] = m.config[M] } else if (m && y) for (var L = (h - b) / w, C = m.config.easing, P = Object(a.a)(C, L), R = 0, N = u.length; R < N; R++) { var D = u[R], z = m.config[D], V = (y.config[D] - z) * P + z; T[D] = V } return o()(t, { position: { $set: h }, current: { $set: T } }) }, s = function (t, e) { var n = t, r = n.active, i = n.origin, u = n.start, c = n.immediate, s = n.isGeneral, f = n.verbose, l = n.actionItem, d = n.destination, p = n.destinationKeys, v = l.config.easing, h = l.config, g = h.duration, m = h.delay; s ? g = 0 : c && (g = m = 0); var y = e.payload.now; if (r && i) { var b = y - (u + m); if (f) { var w = y - u, x = g + m, _ = Object(a.b)(Math.min(Math.max(0, w / x), 1)); t = o()(t, { verboseTimeElapsed: { $set: x * _ } }) } if (b < 0) return t; var O = Object(a.b)(Math.min(Math.max(0, b / g), 1)), j = Object(a.a)(v, O), I = {}, E = p.length ? p.reduce(function (t, e) { var n = d[e], r = parseFloat(i[e]) || 0, o = (parseFloat(n) - r) * j + r; return t[e] = o, t }, {}) : null; return I.current = { $set: E }, I.position = { $set: O }, 1 === O && (I.active = { $set: !1 }, I.complete = { $set: !0 }), o()(t, I) } return t }, f = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : Object.freeze({}), e = arguments[1]; switch (e.type) { case r.l: return e.payload.ixInstances || Object.freeze({}); case r.o: return Object.freeze({}); case r.f: var n = e.payload, i = n.instanceId, a = n.actionItem, f = n.element, l = n.eventId, d = n.eventTarget, p = n.eventStateKey, v = n.actionListId, h = n.groupIndex, g = n.isCarrier, m = n.origin, y = n.destination, b = n.immediate, w = n.verbose, x = n.continuous, _ = n.parameterId, O = n.actionGroups, j = n.smoothing, I = n.restingValue, E = a.actionTypeId, S = void 0, T = S = /^TRANSFORM_/.test(E), A = !S && (S = /^STYLE_/.test(E)), k = !S && (S = /^GENERAL_/.test(E)), M = A && E.replace("STYLE_", "").toLowerCase(), L = Object.keys(y).filter(function (t) { return null != y[t] }); return o()(t, u({}, i, { $set: { id: i, active: !1, position: 0, start: 0, origin: m, destination: y, destinationKeys: L, immediate: b, verbose: w, current: null, actionItem: a, element: f, eventId: l, eventTarget: d, eventStateKey: p, actionListId: v, groupIndex: h, isTransform: T, isStyle: A, isGeneral: k, isCarrier: g, styleProp: M, continuous: x, parameterId: _, actionGroups: O, smoothing: j, restingValue: I } })); case r.h: var C = e.payload.instanceId; return o()(t, u({}, C, { $merge: { active: !0, complete: !1, start: window.performance.now() } })); case r.g: var P = e.payload.instanceId; return o()(t, { $unset: [P] }); case r.b: for (var R = t, N = Object.keys(t), D = N.length, z = 0; z < D; z++) { var V = N[z], $ = t[V], F = $.continuous ? c : s; R = o()(R, u({}, V, { $set: F($, e) })) } return R; default: return t } } }, function (t, e, n) { "use strict"; Object.defineProperty(e, "__esModule", { value: !0 }), n.d(e, "ease", function () { return a }), n.d(e, "easeIn", function () { return u }), n.d(e, "easeOut", function () { return c }), n.d(e, "easeInOut", function () { return s }), e.inQuad = function (t) { return Math.pow(t, 2) }, e.outQuad = function (t) { return -(Math.pow(t - 1, 2) - 1) }, e.inOutQuad = function (t) { if ((t /= .5) < 1) return .5 * Math.pow(t, 2); return -.5 * ((t -= 2) * t - 2) }, e.inCubic = function (t) { return Math.pow(t, 3) }, e.outCubic = function (t) { return Math.pow(t - 1, 3) + 1 }, e.inOutCubic = function (t) { if ((t /= .5) < 1) return .5 * Math.pow(t, 3); return .5 * (Math.pow(t - 2, 3) + 2) }, e.inQuart = function (t) { return Math.pow(t, 4) }, e.outQuart = function (t) { return -(Math.pow(t - 1, 4) - 1) }, e.inOutQuart = function (t) { if ((t /= .5) < 1) return .5 * Math.pow(t, 4); return -.5 * ((t -= 2) * Math.pow(t, 3) - 2) }, e.inQuint = function (t) { return Math.pow(t, 5) }, e.outQuint = function (t) { return Math.pow(t - 1, 5) + 1 }, e.inOutQuint = function (t) { if ((t /= .5) < 1) return .5 * Math.pow(t, 5); return .5 * (Math.pow(t - 2, 5) + 2) }, e.inSine = function (t) { return 1 - Math.cos(t * (Math.PI / 2)) }, e.outSine = function (t) { return Math.sin(t * (Math.PI / 2)) }, e.inOutSine = function (t) { return -.5 * (Math.cos(Math.PI * t) - 1) }, e.inExpo = function (t) { return 0 === t ? 0 : Math.pow(2, 10 * (t - 1)) }, e.outExpo = function (t) { return 1 === t ? 1 : 1 - Math.pow(2, -10 * t) }, e.inOutExpo = function (t) { if (0 === t) return 0; if (1 === t) return 1; if ((t /= .5) < 1) return .5 * Math.pow(2, 10 * (t - 1)); return .5 * (2 - Math.pow(2, -10 * --t)) }, e.inCirc = function (t) { return -(Math.sqrt(1 - t * t) - 1) }, e.outCirc = function (t) { return Math.sqrt(1 - Math.pow(t - 1, 2)) }, e.inOutCirc = function (t) { if ((t /= .5) < 1) return -.5 * (Math.sqrt(1 - t * t) - 1); return .5 * (Math.sqrt(1 - (t -= 2) * t) + 1) }, e.outBounce = function (t) { return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375 }, e.inBack = function (t) { return t * t * ((o + 1) * t - o) }, e.outBack = function (t) { return (t -= 1) * t * ((o + 1) * t + o) + 1 }, e.inOutBack = function (t) { var e = o; if ((t /= .5) < 1) return t * t * ((1 + (e *= 1.525)) * t - e) * .5; return .5 * ((t -= 2) * t * ((1 + (e *= 1.525)) * t + e) + 2) }, e.inElastic = function (t) { var e = o, n = 0, r = 1; if (0 === t) return 0; if (1 === t) return 1; n || (n = .3); r < 1 ? (r = 1, e = n / 4) : e = n / (2 * Math.PI) * Math.asin(1 / r); return -r * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - e) * (2 * Math.PI) / n) }, e.outElastic = function (t) { var e = o, n = 0, r = 1; if (0 === t) return 0; if (1 === t) return 1; n || (n = .3); r < 1 ? (r = 1, e = n / 4) : e = n / (2 * Math.PI) * Math.asin(1 / r); return r * Math.pow(2, -10 * t) * Math.sin((t - e) * (2 * Math.PI) / n) + 1 }, e.inOutElastic = function (t) { var e = o, n = 0, r = 1; if (0 === t) return 0; if (2 == (t /= .5)) return 1; n || (n = .3 * 1.5); r < 1 ? (r = 1, e = n / 4) : e = n / (2 * Math.PI) * Math.asin(1 / r); if (t < 1) return r * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - e) * (2 * Math.PI) / n) * -.5; return r * Math.pow(2, -10 * (t -= 1)) * Math.sin((t - e) * (2 * Math.PI) / n) * .5 + 1 }, e.swingFromTo = function (t) { var e = o; return (t /= .5) < 1 ? t * t * ((1 + (e *= 1.525)) * t - e) * .5 : .5 * ((t -= 2) * t * ((1 + (e *= 1.525)) * t + e) + 2) }, e.swingFrom = function (t) { return t * t * ((o + 1) * t - o) }, e.swingTo = function (t) { return (t -= 1) * t * ((o + 1) * t + o) + 1 }, e.bounce = function (t) { return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375 }, e.bouncePast = function (t) { return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 2 - (7.5625 * (t -= 1.5 / 2.75) * t + .75) : t < 2.5 / 2.75 ? 2 - (7.5625 * (t -= 2.25 / 2.75) * t + .9375) : 2 - (7.5625 * (t -= 2.625 / 2.75) * t + .984375) }; var r = n(117), i = n.n(r), o = 1.70158, a = i()(.25, .1, .25, 1), u = i()(.42, 0, 1, 1), c = i()(0, 0, .58, 1), s = i()(.42, 0, .58, 1) }, function (t, e) { var n = 4, r = .001, i = 1e-7, o = 10, a = 11, u = 1 / (a - 1), c = "function" == typeof Float32Array; function s(t, e) { return 1 - 3 * e + 3 * t } function f(t, e) { return 3 * e - 6 * t } function l(t) { return 3 * t } function d(t, e, n) { return ((s(e, n) * t + f(e, n)) * t + l(e)) * t } function p(t, e, n) { return 3 * s(e, n) * t * t + 2 * f(e, n) * t + l(e) } t.exports = function (t, e, s, f) { if (!(0 <= t && t <= 1 && 0 <= s && s <= 1)) throw new Error("bezier x values must be in [0, 1] range"); var l = c ? new Float32Array(a) : new Array(a); if (t !== e || s !== f) for (var v = 0; v < a; ++v) l[v] = d(v * u, t, s); function h(e) { for (var c = 0, f = 1, v = a - 1; f !== v && l[f] <= e; ++f) c += u; var h = c + (e - l[--f]) / (l[f + 1] - l[f]) * u, g = p(h, t, s); return g >= r ? function (t, e, r, i) { for (var o = 0; o < n; ++o) { var a = p(e, r, i); if (0 === a) return e; e -= (d(e, r, i) - t) / a } return e }(e, h, t, s) : 0 === g ? h : function (t, e, n, r, a) { var u, c, s = 0; do { (u = d(c = e + (n - e) / 2, r, a) - t) > 0 ? n = c : e = c } while (Math.abs(u) > i && ++s < o); return c }(e, c, c + u, t, s) } return function (n) { return t === e && s === f ? n : 0 === n ? 0 : 1 === n ? 1 : d(h(n), e, f) } } }, function (t, e, n) { "use strict"; n.d(e, "a", function () { return i }); var r = n(6), i = function () { var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, e = arguments[1]; switch (e.type) { case r.l: return e.payload.ixParameters || {}; case r.o: return {}; case r.i: var n = e.payload, i = n.key, o = n.value; return t[i] = o, t; default: return t } } }, function (t, e, n) { var r = n(7), i = n(9), o = n(17); t.exports = function (t) { return function (e, n, a) { var u = Object(e); if (!i(e)) { var c = r(n, 3); e = o(e), n = function (t) { return c(u[t], t, u) } } var s = t(e, n, a); return s > -1 ? u[c ? e[s] : s] : void 0 } } }, function (t, e, n) { var r = n(121), i = n(173), o = n(72); t.exports = function (t) { var e = i(t); return 1 == e.length && e[0][2] ? o(e[0][0], e[0][1]) : function (n) { return n === t || r(n, t, e) } } }, function (t, e, n) { var r = n(58), i = n(62), o = 1, a = 2; t.exports = function (t, e, n, u) { var c = n.length, s = c, f = !u; if (null == t) return !s; for (t = Object(t) ; c--;) { var l = n[c]; if (f && l[2] ? l[1] !== t[l[0]] : !(l[0] in t)) return !1 } for (; ++c < s;) { var d = (l = n[c])[0], p = t[d], v = l[1]; if (f && l[2]) { if (void 0 === p && !(d in t)) return !1 } else { var h = new r; if (u) var g = u(p, v, d, t, e, h); if (!(void 0 === g ? i(v, p, o | a, u, h) : g)) return !1 } } return !0 } }, function (t, e) { t.exports = function () { this.__data__ = [], this.size = 0 } }, function (t, e, n) { var r = n(14), i = Array.prototype.splice; t.exports = function (t) { var e = this.__data__, n = r(e, t); return !(n < 0 || (n == e.length - 1 ? e.pop() : i.call(e, n, 1), --this.size, 0)) } }, function (t, e, n) { var r = n(14); t.exports = function (t) { var e = this.__data__, n = r(e, t); return n < 0 ? void 0 : e[n][1] } }, function (t, e, n) { var r = n(14); t.exports = function (t) { return r(this.__data__, t) > -1 } }, function (t, e, n) { var r = n(14); t.exports = function (t, e) { var n = this.__data__, i = r(n, t); return i < 0 ? (++this.size, n.push([t, e])) : n[i][1] = e, this } }, function (t, e, n) { var r = n(13); t.exports = function () { this.__data__ = new r, this.size = 0 } }, function (t, e) { t.exports = function (t) { var e = this.__data__, n = e.delete(t); return this.size = e.size, n } }, function (t, e) { t.exports = function (t) { return this.__data__.get(t) } }, function (t, e) { t.exports = function (t) { return this.__data__.has(t) } }, function (t, e, n) { var r = n(13), i = n(25), o = n(26), a = 200; t.exports = function (t, e) { var n = this.__data__; if (n instanceof r) { var u = n.__data__; if (!i || u.length < a - 1) return u.push([t, e]), this.size = ++n.size, this; n = this.__data__ = new o(u) } return n.set(t, e), this.size = n.size, this } }, function (t, e, n) { var r = n(59), i = n(135), o = n(3), a = n(61), u = /^\[object .+?Constructor\]$/, c = Function.prototype, s = Object.prototype, f = c.toString, l = s.hasOwnProperty, d = RegExp("^" + f.call(l).replace(/[\\^$.*+?()[\]{}|]/g, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"); t.exports = function (t) { return !(!o(t) || i(t)) && (r(t) ? d : u).test(a(t)) } }, function (t, e, n) { var r = n(10), i = Object.prototype, o = i.hasOwnProperty, a = i.toString, u = r ? r.toStringTag : void 0; t.exports = function (t) { var e = o.call(t, u), n = t[u]; try { t[u] = void 0; var r = !0 } catch (t) { } var i = a.call(t); return r && (e ? t[u] = n : delete t[u]), i } }, function (t, e) { var n = Object.prototype.toString; t.exports = function (t) { return n.call(t) } }, function (t, e, n) { var r, i = n(136), o = (r = /[^.]+$/.exec(i && i.keys && i.keys.IE_PROTO || "")) ? "Symbol(src)_1." + r : ""; t.exports = function (t) { return !!o && o in t } }, function (t, e, n) { var r = n(2)["__core-js_shared__"]; t.exports = r }, function (t, e) { t.exports = function (t, e) { return null == t ? void 0 : t[e] } }, function (t, e, n) { var r = n(139), i = n(13), o = n(25); t.exports = function () { this.size = 0, this.__data__ = { hash: new r, map: new (o || i), string: new r } } }, function (t, e, n) { var r = n(140), i = n(141), o = n(142), a = n(143), u = n(144); function c(t) { var e = -1, n = null == t ? 0 : t.length; for (this.clear() ; ++e < n;) { var r = t[e]; this.set(r[0], r[1]) } } c.prototype.clear = r, c.prototype.delete = i, c.prototype.get = o, c.prototype.has = a, c.prototype.set = u, t.exports = c }, function (t, e, n) { var r = n(15); t.exports = function () { this.__data__ = r ? r(null) : {}, this.size = 0 } }, function (t, e) { t.exports = function (t) { var e = this.has(t) && delete this.__data__[t]; return this.size -= e ? 1 : 0, e } }, function (t, e, n) { var r = n(15), i = "__lodash_hash_undefined__", o = Object.prototype.hasOwnProperty; t.exports = function (t) { var e = this.__data__; if (r) { var n = e[t]; return n === i ? void 0 : n } return o.call(e, t) ? e[t] : void 0 } }, function (t, e, n) { var r = n(15), i = Object.prototype.hasOwnProperty; t.exports = function (t) { var e = this.__data__; return r ? void 0 !== e[t] : i.call(e, t) } }, function (t, e, n) { var r = n(15), i = "__lodash_hash_undefined__"; t.exports = function (t, e) { var n = this.__data__; return this.size += this.has(t) ? 0 : 1, n[t] = r && void 0 === e ? i : e, this } }, function (t, e, n) { var r = n(16); t.exports = function (t) { var e = r(this, t).delete(t); return this.size -= e ? 1 : 0, e } }, function (t, e) { t.exports = function (t) { var e = typeof t; return "string" == e || "number" == e || "symbol" == e || "boolean" == e ? "__proto__" !== t : null === t } }, function (t, e, n) { var r = n(16); t.exports = function (t) { return r(this, t).get(t) } }, function (t, e, n) { var r = n(16); t.exports = function (t) { return r(this, t).has(t) } }, function (t, e, n) { var r = n(16); t.exports = function (t, e) { var n = r(this, t), i = n.size; return n.set(t, e), this.size += n.size == i ? 0 : 1, this } }, function (t, e, n) { var r = n(58), i = n(63), o = n(156), a = n(160), u = n(34), c = n(0), s = n(28), f = n(30), l = 1, d = "[object Arguments]", p = "[object Array]", v = "[object Object]", h = Object.prototype.hasOwnProperty; t.exports = function (t, e, n, g, m, y) { var b = c(t), w = c(e), x = b ? p : u(t), _ = w ? p : u(e), O = (x = x == d ? v : x) == v, j = (_ = _ == d ? v : _) == v, I = x == _; if (I && s(t)) { if (!s(e)) return !1; b = !0, O = !1 } if (I && !O) return y || (y = new r), b || f(t) ? i(t, e, n, g, m, y) : o(t, e, x, n, g, m, y); if (!(n & l)) { var E = O && h.call(t, "__wrapped__"), S = j && h.call(e, "__wrapped__"); if (E || S) { var T = E ? t.value() : t, A = S ? e.value() : e; return y || (y = new r), m(T, A, n, g, y) } } return !!I && (y || (y = new r), a(t, e, n, g, m, y)) } }, function (t, e, n) { var r = n(26), i = n(152), o = n(153); function a(t) { var e = -1, n = null == t ? 0 : t.length; for (this.__data__ = new r; ++e < n;) this.add(t[e]) } a.prototype.add = a.prototype.push = i, a.prototype.has = o, t.exports = a }, function (t, e) { var n = "__lodash_hash_undefined__"; t.exports = function (t) { return this.__data__.set(t, n), this } }, function (t, e) { t.exports = function (t) { return this.__data__.has(t) } }, function (t, e) { t.exports = function (t, e) { for (var n = -1, r = null == t ? 0 : t.length; ++n < r;) if (e(t[n], n, t)) return !0; return !1 } }, function (t, e) { t.exports = function (t, e) { return t.has(e) } }, function (t, e, n) { var r = n(10), i = n(157), o = n(24), a = n(63), u = n(158), c = n(159), s = 1, f = 2, l = "[object Boolean]", d = "[object Date]", p = "[object Error]", v = "[object Map]", h = "[object Number]", g = "[object RegExp]", m = "[object Set]", y = "[object String]", b = "[object Symbol]", w = "[object ArrayBuffer]", x = "[object DataView]", _ = r ? r.prototype : void 0, O = _ ? _.valueOf : void 0; t.exports = function (t, e, n, r, _, j, I) { switch (n) { case x: if (t.byteLength != e.byteLength || t.byteOffset != e.byteOffset) return !1; t = t.buffer, e = e.buffer; case w: return !(t.byteLength != e.byteLength || !j(new i(t), new i(e))); case l: case d: case h: return o(+t, +e); case p: return t.name == e.name && t.message == e.message; case g: case y: return t == e + ""; case v: var E = u; case m: var S = r & s; if (E || (E = c), t.size != e.size && !S) return !1; var T = I.get(t); if (T) return T == e; r |= f, I.set(t, e); var A = a(E(t), E(e), r, _, j, I); return I.delete(t), A; case b: if (O) return O.call(t) == O.call(e) } return !1 } }, function (t, e, n) { var r = n(2).Uint8Array; t.exports = r }, function (t, e) { t.exports = function (t) { var e = -1, n = Array(t.size); return t.forEach(function (t, r) { n[++e] = [r, t] }), n } }, function (t, e) { t.exports = function (t) { var e = -1, n = Array(t.size); return t.forEach(function (t) { n[++e] = t }), n } }, function (t, e, n) { var r = n(161), i = 1, o = Object.prototype.hasOwnProperty; t.exports = function (t, e, n, a, u, c) { var s = n & i, f = r(t), l = f.length; if (l != r(e).length && !s) return !1; for (var d = l; d--;) { var p = f[d]; if (!(s ? p in e : o.call(e, p))) return !1 } var v = c.get(t); if (v && c.get(e)) return v == e; var h = !0; c.set(t, e), c.set(e, t); for (var g = s; ++d < l;) { var m = t[p = f[d]], y = e[p]; if (a) var b = s ? a(y, m, p, e, t, c) : a(m, y, p, t, e, c); if (!(void 0 === b ? m === y || u(m, y, n, a, c) : b)) { h = !1; break } g || (g = "constructor" == p) } if (h && !g) { var w = t.constructor, x = e.constructor; w != x && "constructor" in t && "constructor" in e && !("function" == typeof w && w instanceof w && "function" == typeof x && x instanceof x) && (h = !1) } return c.delete(t), c.delete(e), h } }, function (t, e, n) { var r = n(64), i = n(65), o = n(17); t.exports = function (t) { return r(t, o, i) } }, function (t, e) { t.exports = function (t, e) { for (var n = -1, r = null == t ? 0 : t.length, i = 0, o = []; ++n < r;) { var a = t[n]; e(a, n, t) && (o[i++] = a) } return o } }, function (t, e) { t.exports = function (t, e) { for (var n = -1, r = Array(t) ; ++n < t;) r[n] = e(n); return r } }, function (t, e, n) { var r = n(8), i = n(5), o = "[object Arguments]"; t.exports = function (t) { return i(t) && r(t) == o } }, function (t, e) { t.exports = function () { return !1 } }, function (t, e, n) { var r = n(8), i = n(31), o = n(5), a = {}; a["[object Float32Array]"] = a["[object Float64Array]"] = a["[object Int8Array]"] = a["[object Int16Array]"] = a["[object Int32Array]"] = a["[object Uint8Array]"] = a["[object Uint8ClampedArray]"] = a["[object Uint16Array]"] = a["[object Uint32Array]"] = !0, a["[object Arguments]"] = a["[object Array]"] = a["[object ArrayBuffer]"] = a["[object Boolean]"] = a["[object DataView]"] = a["[object Date]"] = a["[object Error]"] = a["[object Function]"] = a["[object Map]"] = a["[object Number]"] = a["[object Object]"] = a["[object RegExp]"] = a["[object Set]"] = a["[object String]"] = a["[object WeakMap]"] = !1, t.exports = function (t) { return o(t) && i(t.length) && !!a[r(t)] } }, function (t, e) { t.exports = function (t) { return function (e) { return t(e) } } }, function (t, e, n) { (function (t) { var r = n(60), i = "object" == typeof e && e && !e.nodeType && e, o = i && "object" == typeof t && t && !t.nodeType && t, a = o && o.exports === i && r.process, u = function () { try { var t = o && o.require && o.require("util").types; return t || a && a.binding && a.binding("util") } catch (t) { } }(); t.exports = u }).call(e, n(68)(t)) }, function (t, e, n) { var r = n(69)(Object.keys, Object); t.exports = r }, function (t, e, n) { var r = n(4)(n(2), "DataView"); t.exports = r }, function (t, e, n) { var r = n(4)(n(2), "Promise"); t.exports = r }, function (t, e, n) { var r = n(4)(n(2), "Set"); t.exports = r }, function (t, e, n) { var r = n(71), i = n(17); t.exports = function (t) { for (var e = i(t), n = e.length; n--;) { var o = e[n], a = t[o]; e[n] = [o, a, r(a)] } return e } }, function (t, e, n) { var r = n(62), i = n(19), o = n(178), a = n(36), u = n(71), c = n(72), s = n(11), f = 1, l = 2; t.exports = function (t, e) { return a(t) && u(e) ? c(s(t), e) : function (n) { var a = i(n, t); return void 0 === a && a === e ? o(n, t) : r(e, a, f | l) } } }, function (t, e, n) { var r = n(176), i = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g, o = /\\(\\)?/g, a = r(function (t) { var e = []; return 46 === t.charCodeAt(0) && e.push(""), t.replace(i, function (t, n, r, i) { e.push(r ? i.replace(o, "$1") : n || t) }), e }); t.exports = a }, function (t, e, n) { var r = n(177), i = 500; t.exports = function (t) { var e = r(t, function (t) { return n.size === i && n.clear(), t }), n = e.cache; return e } }, function (t, e, n) { var r = n(26), i = "Expected a function"; function o(t, e) { if ("function" != typeof t || null != e && "function" != typeof e) throw new TypeError(i); var n = function () { var r = arguments, i = e ? e.apply(this, r) : r[0], o = n.cache; if (o.has(i)) return o.get(i); var a = t.apply(this, r); return n.cache = o.set(i, a) || o, a }; return n.cache = new (o.Cache || r), n } o.Cache = r, t.exports = o }, function (t, e, n) { var r = n(179), i = n(180); t.exports = function (t, e) { return null != t && i(t, e, r) } }, function (t, e) { t.exports = function (t, e) { return null != t && e in Object(t) } }, function (t, e, n) { var r = n(20), i = n(18), o = n(0), a = n(29), u = n(31), c = n(11); t.exports = function (t, e, n) { for (var s = -1, f = (e = r(e, t)).length, l = !1; ++s < f;) { var d = c(e[s]); if (!(l = null != t && n(t, d))) break; t = t[d] } return l || ++s != f ? l : !!(f = null == t ? 0 : t.length) && u(f) && a(d, f) && (o(t) || i(t)) } }, function (t, e, n) { var r = n(76), i = n(182), o = n(36), a = n(11); t.exports = function (t) { return o(t) ? r(a(t)) : i(t) } }, function (t, e, n) { var r = n(35); t.exports = function (t) { return function (e) { return r(e, t) } } }, function (t, e, n) { var r = n(184), i = n(7), o = n(77), a = Math.max; t.exports = function (t, e, n) { var u = null == t ? 0 : t.length; if (!u) return -1; var c = null == n ? 0 : o(n); return c < 0 && (c = a(u + c, 0)), r(t, i(e, 3), c) } }, function (t, e) { t.exports = function (t, e, n, r) { for (var i = t.length, o = n + (r ? 1 : -1) ; r ? o-- : ++o < i;) if (e(t[o], o, t)) return o; return -1 } }, function (t, e, n) { var r = n(38), i = 1 / 0, o = 1.7976931348623157e308; t.exports = function (t) { return t ? (t = r(t)) === i || t === -i ? (t < 0 ? -1 : 1) * o : t == t ? t : 0 : 0 === t ? t : 0 } }, function (t, e, n) { var r = n(32), i = n(34), o = n(9), a = n(187), u = n(188), c = "[object Map]", s = "[object Set]"; t.exports = function (t) { if (null == t) return 0; if (o(t)) return a(t) ? u(t) : t.length; var e = i(t); return e == c || e == s ? t.size : r(t).length } }, function (t, e, n) { var r = n(8), i = n(0), o = n(5), a = "[object String]"; t.exports = function (t) { return "string" == typeof t || !i(t) && o(t) && r(t) == a } }, function (t, e, n) { var r = n(189), i = n(190), o = n(191); t.exports = function (t) { return i(t) ? o(t) : r(t) } }, function (t, e, n) { var r = n(76)("length"); t.exports = r }, function (t, e) { var n = RegExp("[\\u200d\\ud800-\\udfff\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff\\ufe0e\\ufe0f]"); t.exports = function (t) { return n.test(t) } }, function (t, e) { var n = "[\\ud800-\\udfff]", r = "[\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff]", i = "\\ud83c[\\udffb-\\udfff]", o = "[^\\ud800-\\udfff]", a = "(?:\\ud83c[\\udde6-\\uddff]){2}", u = "[\\ud800-\\udbff][\\udc00-\\udfff]", c = "(?:" + r + "|" + i + ")" + "?", s = "[\\ufe0e\\ufe0f]?" + c + ("(?:\\u200d(?:" + [o, a, u].join("|") + ")[\\ufe0e\\ufe0f]?" + c + ")*"), f = "(?:" + [o + r + "?", r, a, u, n].join("|") + ")", l = RegExp(i + "(?=" + i + ")|" + f + s, "g"); t.exports = function (t) { for (var e = l.lastIndex = 0; l.test(t) ;)++e; return e } }, function (t, e, n) { var r = n(7), i = n(193), o = n(194); t.exports = function (t, e) { return o(t, i(r(e))) } }, function (t, e) { var n = "Expected a function"; t.exports = function (t) { if ("function" != typeof t) throw new TypeError(n); return function () { var e = arguments; switch (e.length) { case 0: return !t.call(this); case 1: return !t.call(this, e[0]); case 2: return !t.call(this, e[0], e[1]); case 3: return !t.call(this, e[0], e[1], e[2]) } return !t.apply(this, e) } } }, function (t, e, n) { var r = n(75), i = n(7), o = n(195), a = n(198); t.exports = function (t, e) { if (null == t) return {}; var n = r(a(t), function (t) { return [t] }); return e = i(e), o(t, n, function (t, n) { return e(t, n[0]) }) } }, function (t, e, n) { var r = n(35), i = n(196), o = n(20); t.exports = function (t, e, n) { for (var a = -1, u = e.length, c = {}; ++a < u;) { var s = e[a], f = r(t, s); n(f, s) && i(c, o(s, t), f) } return c } }, function (t, e, n) { var r = n(197), i = n(20), o = n(29), a = n(3), u = n(11); t.exports = function (t, e, n, c) { if (!a(t)) return t; for (var s = -1, f = (e = i(e, t)).length, l = f - 1, d = t; null != d && ++s < f;) { var p = u(e[s]), v = n; if (s != l) { var h = d[p]; void 0 === (v = c ? c(h, p, d) : void 0) && (v = a(h) ? h : o(e[s + 1]) ? [] : {}) } r(d, p, v), d = d[p] } return t } }, function (t, e, n) { var r = n(78), i = n(24), o = Object.prototype.hasOwnProperty; t.exports = function (t, e, n) { var a = t[e]; o.call(t, e) && i(a, n) && (void 0 !== n || e in t) || r(t, e, n) } }, function (t, e, n) { var r = n(64), i = n(199), o = n(201); t.exports = function (t) { return r(t, o, i) } }, function (t, e, n) { var r = n(27), i = n(200), o = n(65), a = n(66), u = Object.getOwnPropertySymbols ? function (t) { for (var e = []; t;) r(e, o(t)), t = i(t); return e } : a; t.exports = u }, function (t, e, n) { var r = n(69)(Object.getPrototypeOf, Object); t.exports = r }, function (t, e, n) { var r = n(67), i = n(202), o = n(9); t.exports = function (t) { return o(t) ? r(t, !0) : i(t) } }, function (t, e, n) { var r = n(3), i = n(33), o = n(203), a = Object.prototype.hasOwnProperty; t.exports = function (t) { if (!r(t)) return o(t); var e = i(t), n = []; for (var u in t) ("constructor" != u || !e && a.call(t, u)) && n.push(u); return n } }, function (t, e) { t.exports = function (t) { var e = []; if (null != t) for (var n in Object(t)) e.push(n); return e } }, function (t, e, n) { var r = n(32), i = n(34), o = n(18), a = n(0), u = n(9), c = n(28), s = n(33), f = n(30), l = "[object Map]", d = "[object Set]", p = Object.prototype.hasOwnProperty; t.exports = function (t) { if (null == t) return !0; if (u(t) && (a(t) || "string" == typeof t || "function" == typeof t.splice || c(t) || f(t) || o(t))) return !t.length; var e = i(t); if (e == l || e == d) return !t.size; if (s(t)) return !r(t).length; for (var n in t) if (p.call(t, n)) return !1; return !0 } }, function (t, e, n) { var r = n(78), i = n(80), o = n(7); t.exports = function (t, e) { var n = {}; return e = o(e, 3), i(t, function (t, i, o) { r(n, i, e(t, i, o)) }), n } }, function (t, e, n) { var r = n(207)(); t.exports = r }, function (t, e) { t.exports = function (t) { return function (e, n, r) { for (var i = -1, o = Object(e), a = r(e), u = a.length; u--;) { var c = a[t ? u : ++i]; if (!1 === n(o[c], c, o)) break } return e } } }, function (t, e, n) { var r = n(209), i = n(81), o = n(211), a = n(0); t.exports = function (t, e) { return (a(t) ? r : i)(t, o(e)) } }, function (t, e) { t.exports = function (t, e) { for (var n = -1, r = null == t ? 0 : t.length; ++n < r && !1 !== e(t[n], n, t) ;); return t } }, function (t, e, n) { var r = n(9); t.exports = function (t, e) { return function (n, i) { if (null == n) return n; if (!r(n)) return t(n, i); for (var o = n.length, a = e ? o : -1, u = Object(n) ; (e ? a-- : ++a < o) && !1 !== i(u[a], a, u) ;); return n } } }, function (t, e, n) { var r = n(37); t.exports = function (t) { return "function" == typeof t ? t : r } }, function (t, e, n) { var r = n(82), i = n(74), o = n(77), a = n(73); t.exports = function (t, e, n) { t = a(t), e = i(e); var u = t.length, c = n = void 0 === n ? u : r(o(n), 0, u); return (n -= e.length) >= 0 && t.slice(n, c) == e } }, function (t, e, n) { var r = n(214), i = n(3), o = "Expected a function"; t.exports = function (t, e, n) { var a = !0, u = !0; if ("function" != typeof t) throw new TypeError(o); return i(n) && (a = "leading" in n ? !!n.leading : a, u = "trailing" in n ? !!n.trailing : u), r(t, e, { leading: a, maxWait: e, trailing: u }) } }, function (t, e, n) { var r = n(3), i = n(215), o = n(38), a = "Expected a function", u = Math.max, c = Math.min; t.exports = function (t, e, n) { var s, f, l, d, p, v, h = 0, g = !1, m = !1, y = !0; if ("function" != typeof t) throw new TypeError(a); function b(e) { var n = s, r = f; return s = f = void 0, h = e, d = t.apply(r, n) } function w(t) { var n = t - v; return void 0 === v || n >= e || n < 0 || m && t - h >= l } function x() { var t = i(); if (w(t)) return _(t); p = setTimeout(x, function (t) { var n = e - (t - v); return m ? c(n, l - (t - h)) : n }(t)) } function _(t) { return p = void 0, y && s ? b(t) : (s = f = void 0, d) } function O() { var t = i(), n = w(t); if (s = arguments, f = this, v = t, n) { if (void 0 === p) return function (t) { return h = t, p = setTimeout(x, e), g ? b(t) : d }(v); if (m) return p = setTimeout(x, e), b(v) } return void 0 === p && (p = setTimeout(x, e)), d } return e = o(e) || 0, r(n) && (g = !!n.leading, l = (m = "maxWait" in n) ? u(o(n.maxWait) || 0, e) : l, y = "trailing" in n ? !!n.trailing : y), O.cancel = function () { void 0 !== p && clearTimeout(p), h = 0, s = v = f = p = void 0 }, O.flush = function () { return void 0 === p ? d : _(i()) }, O } }, function (t, e, n) { var r = n(2); t.exports = function () { return r.Date.now() } }, function (t, e, n) { "use strict"; e.__esModule = !0; var r, i = n(217), o = (r = i) && r.__esModule ? r : { default: r }; e.default = o.default }, function (t, e, n) { "use strict"; var r = Object.prototype.hasOwnProperty; function i(t, e) { return t === e ? 0 !== t || 0 !== e || 1 / t == 1 / e : t != t && e != e } t.exports = function (t, e) { if (i(t, e)) return !0; if ("object" != typeof t || null === t || "object" != typeof e || null === e) return !1; var n = Object.keys(t), o = Object.keys(e); if (n.length !== o.length) return !1; for (var a = 0; a < n.length; a++) if (!r.call(e, n[a]) || !i(t[n[a]], e[n[a]])) return !1; return !0 } }, function (t, e) { t.exports = function (t, e) { return null == t || t != t ? e : t } }, function (t, e, n) { var r = n(220), i = n(81), o = n(7), a = n(221), u = n(0); t.exports = function (t, e, n) { var c = u(t) ? r : a, s = arguments.length < 3; return c(t, o(e, 4), n, s, i) } }, function (t, e) { t.exports = function (t, e, n, r) { var i = -1, o = null == t ? 0 : t.length; for (r && o && (n = t[++i]) ; ++i < o;) n = e(n, t[i], i, t); return n } }, function (t, e) { t.exports = function (t, e, n, r, i) { return i(t, function (t, i, o) { n = r ? (r = !1, t) : e(n, t, i, o) }), n } }, function (t, e, n) { "use strict"; Object.defineProperty(e, "__esModule", { value: !0 }), e.setStyle = function (t, e, n) { t.style[e] = n }, e.getStyle = function (t, e) { return t.style[e] }, e.getProperty = function (t, e) { return t[e] }, e.matchSelector = function (t) { return function (e) { return e[i.a](t) } }, e.getQuerySelector = function (t) { var e = t.id, n = t.selector; if (e) { var i = e; if (-1 !== e.indexOf(r.o)) { var o = e.split(r.o), a = o[0]; if (i = o[1], a !== document.documentElement.getAttribute(r.E)) return null } return '[data-w-id^="' + i + '"]' } return n }, e.getValidDocument = function (t) { if (null == t || t === document.documentElement.getAttribute(r.E)) return document; return null }, e.queryDocument = function (t, e) { return Array.prototype.slice.call(document.querySelectorAll(e ? t + " " + e : t)) }, e.elementContains = function (t, e) { return t.contains(e) }, e.isSiblingNode = function (t, e) { return t !== e && t.parentNode === e.parentNode }, e.getChildElements = function () { for (var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [], e = [], n = 0, r = t.length; n < r; n++) { var i = t[n].children, o = i.length; if (o) for (var a = 0; a < o; a++) e.push(i[a]) } return e }, e.getSiblingElements = function () { for (var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [], e = [], n = [], r = 0, i = t.length; r < i; r++) { var o = t[r].parentNode; if (o && o.children && o.children.length && -1 === n.indexOf(o)) { n.push(o); for (var a = o.firstElementChild; null != a;) -1 === t.indexOf(a) && e.push(a), a = a.nextElementSibling } } return e }, n.d(e, "getClosestElement", function () { return o }); var r = n(22), i = n(83); var o = Element.prototype.closest ? function (t, e) { return document.documentElement.contains(t) ? t.closest(e) : null } : function (t, e) { if (!document.documentElement.contains(t)) return null; var n = t; do { if (n[i.a] && n[i.a](e)) return n; n = n.parentNode } while (null != n); return null } }, function (t, e, n) { "use strict"; var r, i = n(224), o = n.n(i), a = n(19), u = n.n(a), c = n(243), s = n.n(c), f = n(56), l = n(39), d = n(42), p = n(41), v = n(22), h = Object.assign || function (t) { for (var e = 1; e < arguments.length; e++) { var n = arguments[e]; for (var r in n) Object.prototype.hasOwnProperty.call(n, r) && (t[r] = n[r]) } return t }, g = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (t) { return typeof t } : function (t) { return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t }; function m(t, e, n) { return e in t ? Object.defineProperty(t, e, { value: n, enumerable: !0, configurable: !0, writable: !0 }) : t[e] = n, t } var y, b, w, x = function (t) { return function (e) { return !("object" !== (void 0 === e ? "undefined" : g(e)) || !t(e)) || e } }, _ = x(function (t) { return t.element === t.nativeEvent.target }), O = x(function (t) { var e = t.element, n = t.nativeEvent; return e.contains(n.target) }), j = o()([_, O]), I = function (t, e) { return e ? t.getState().ixData.events[e] : null }, E = function (t, e) { var n = t.store, r = t.event, i = t.element, o = t.eventStateKey, a = r.action, c = r.id, s = a.config, l = s.actionListId, d = s.autoStopEventId, p = I(n, d); return p && Object(f.d)({ store: n, eventId: d, eventTarget: i, eventStateKey: d + v.h + o.split(v.h)[1], actionListId: u()(p, "action.config.actionListId") }), Object(f.d)({ store: n, eventId: c, eventTarget: i, eventStateKey: o, actionListId: l }), Object(f.b)({ store: n, eventId: c, eventTarget: i, eventStateKey: o, actionListId: l }), e }, S = function (t, e) { return function (n, r) { return !0 === t(n, r) ? e(n, r) : r } }, T = { handler: S(j, E) }, A = h({}, T, { types: [p.a, p.b].join(" ") }), k = [{ target: window, types: "resize orientationchange", throttle: !0 }, { target: document, types: "scroll wheel readystatechange IX2_PREVIEW_LOAD", throttle: !0 }], M = { types: [{ target: document, types: "scroll wheel", throttle: !0 }] }, L = (y = void 0 !== window.pageXOffset, b = "CSS1Compat" === document.compatMode ? document.documentElement : document.body, function () { return { scrollLeft: y ? window.pageXOffset : b.scrollLeft, scrollTop: y ? window.pageYOffset : b.scrollTop, stiffScrollTop: s()(y ? window.pageYOffset : b.scrollTop, 0, b.scrollHeight - window.innerHeight), scrollWidth: b.scrollWidth, scrollHeight: b.scrollHeight, clientWidth: b.clientWidth, clientHeight: b.clientHeight, innerWidth: window.innerWidth, innerHeight: window.innerHeight } }), C = function (t) { return function (e, n) { var r = -1 !== [p.a, p.b].indexOf(e.nativeEvent.type) ? e.nativeEvent.type === p.a : n.isActive, i = h({}, n, { isActive: r }); return n && i.isActive === n.isActive ? i : t(e, i) || i } }, P = function (t) { return function (e, n) { var r = { elementHovered: function (t) { var e = t.element, n = t.nativeEvent, r = n.type, i = n.target, o = n.relatedTarget, a = e.contains(i); if ("mouseover" === r && a) return !0; var u = e.contains(o); return !("mouseout" !== r || !a || !u) }(e) }; return (n ? r.elementHovered !== n.elementHovered : r.elementHovered) && t(e, r) || r } }, R = function (t) { return function (e) { var n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, r = L(), i = r.stiffScrollTop, o = r.scrollHeight, a = r.innerHeight, u = e.event, c = u.config, s = u.eventTypeId, f = c.scrollOffsetValue, l = "PX" === c.scrollOffsetUnit, d = o - a, v = Number((i / d).toFixed(2)); if (n && n.percentTop === v) return n; var g = (l ? f : a * (f || 0) / 100) / d, m = void 0, y = void 0, b = 0; n && (m = v > n.percentTop, b = (y = n.scrollingDown !== m) ? v : n.anchorTop); var w = s === p.r ? v >= b + g : v <= b - g, x = h({}, n, { percentTop: v, inBounds: w, anchorTop: b, scrollingDown: m }); return n && w && (y || x.inBounds !== n.inBounds) && t(e, x) || x } }, N = function (t) { return function (e) { var n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : { clickCount: 0 }, r = { clickCount: n.clickCount % 2 + 1 }; return r.clickCount !== n.clickCount && t(e, r) || r } }, D = function () { var t = !(arguments.length > 0 && void 0 !== arguments[0]) || arguments[0]; return h({}, A, { handler: S(t ? j : _, C(function (t, e) { return e.isActive ? T.handler(t, e) : e })) }) }, z = function () { var t = !(arguments.length > 0 && void 0 !== arguments[0]) || arguments[0]; return h({}, A, { handler: S(t ? j : _, C(function (t, e) { return e.isActive ? e : T.handler(t, e) })) }) }, V = h({}, M, { handler: (w = function (t, e) { var n = e.elementVisible, r = t.event; return !t.store.getState().ixData.events[r.action.config.autoStopEventId] && e.triggered ? e : r.eventTypeId === p.v === n ? (E(t), h({}, e, { triggered: !0 })) : e }, function (t, e) { var n = h({}, e, { elementVisible: function (t) { var e, n, r = t.element, i = t.event.config, o = L(), a = o.clientWidth, u = o.clientHeight, c = i.scrollOffsetValue, s = "PX" === i.scrollOffsetUnit ? c : u * (c || 0) / 100; return e = r.getBoundingClientRect(), n = { left: 0, top: s, right: a, bottom: u - s }, !(e.left > n.right || e.right < n.left || e.top > n.bottom || e.bottom < n.top) }(t) }); return (e ? n.elementVisible !== e.elementVisible : n.elementVisible) && w(t, n) || n }) }); e.a = (m(r = {}, p.x, D()), m(r, p.y, z()), m(r, p.d, D()), m(r, p.c, z()), m(r, p.n, D(!1)), m(r, p.m, z(!1)), m(r, p.z, D()), m(r, p.A, z()), m(r, p.f, { types: "click", handler: S(j, N(function (t, e) { var n, r, i, o = e.clickCount; r = (n = t).store, i = n.event.action.config.autoStopEventId, Boolean(I(r, i)) ? 1 === o && E(t) : E(t) })) }), m(r, p.k, { types: "click", handler: S(j, N(function (t, e) { 2 === e.clickCount && E(t) })) }), m(r, p.g, h({}, T, { types: "mousedown" })), m(r, p.l, h({}, T, { types: "mouseup" })), m(r, p.j, { types: "mouseover mouseout", handler: S(j, P(function (t, e) { e.elementHovered && E(t) })) }), m(r, p.i, { types: "mouseover mouseout", handler: S(j, P(function (t, e) { e.elementHovered || E(t) })) }), m(r, p.h, { types: "mousemove mouseout scroll", handler: function (t) { var e = t.store, n = t.element, r = t.eventConfig, i = t.nativeEvent, o = t.eventStateKey, a = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : { clientX: 0, clientY: 0, pageX: 0, pageY: 0 }, u = r.basedOn, c = r.selectedAxis, s = r.continuousParameterGroupId, f = r.reverse, v = r.restingState, h = void 0 === v ? 0 : v, g = i.clientX, m = void 0 === g ? a.clientX : g, y = i.clientY, b = void 0 === y ? a.clientY : y, w = i.pageX, x = void 0 === w ? a.pageX : w, _ = i.pageY, O = void 0 === _ ? a.pageY : _, I = "X_AXIS" === c, E = "mouseout" === i.type, S = h / 100, T = s, A = !1; switch (u) { case p.B: S = I ? Math.min(m, window.innerWidth) / window.innerWidth : Math.min(b, window.innerHeight) / window.innerHeight; break; case p.o: var k = L(), M = k.scrollLeft, C = k.scrollTop, P = k.scrollWidth, R = k.scrollHeight; S = I ? Math.min(M + x, P) / P : Math.min(C + O, R) / R; break; case p.e: default: T = Object(l.i)(o, s); var N = 0 === i.type.indexOf("mouse"); if (N && !0 !== j({ element: n, nativeEvent: i })) break; var D = n.getBoundingClientRect(), z = D.left, V = D.top, $ = D.width, F = D.height; if (!N && !function (t, e) { return t.left > e.left && t.left < e.right && t.top > e.top && t.top < e.bottom }({ left: m, top: b }, D)) break; A = !0, S = I ? (m - z) / $ : (b - V) / F } return E && (S > .95 || S < .05) && (S = Math.round(S)), (u !== p.e || A || A !== a.elementHovered) && (S = f ? 1 - S : S, e.dispatch(Object(d.parameterChanged)(T, S))), { elementHovered: A, clientX: m, clientY: b, pageX: x, pageY: O } } }), m(r, p.q, { types: k, handler: function (t) { var e = t.store, n = t.eventConfig, r = n.continuousParameterGroupId, i = n.reverse, o = L(), a = o.scrollTop / (o.scrollHeight - o.clientHeight); a = i ? 1 - a : a, e.dispatch(Object(d.parameterChanged)(r, a)) } }), m(r, p.u, { types: k, handler: function (t) { var e = t.element, n = t.store, r = t.eventConfig, i = t.eventStateKey, o = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : { scrollPercent: 0 }, a = L(), u = a.scrollLeft, c = a.scrollTop, s = a.scrollWidth, f = a.scrollHeight, v = a.clientWidth, h = a.clientHeight, g = s - v, m = f - h, y = r.basedOn, b = r.selectedAxis, w = r.continuousParameterGroupId, x = r.startsEntering, _ = r.startsExiting, O = r.addEndOffset, j = r.addStartOffset, I = r.addOffsetValue, E = void 0 === I ? 0 : I, S = r.endOffsetValue, T = void 0 === S ? 0 : S, A = "X_AXIS" === b; if (y === p.B) { var k = A ? u / g : c / m; return k !== o.scrollPercent && n.dispatch(Object(d.parameterChanged)(w, k)), { scrollPercent: k } } var M = Object(l.i)(i, w), C = e.getBoundingClientRect(), P = (j ? E : 0) / 100, R = (O ? T : 0) / 100; P = x ? P : 1 - P, R = _ ? R : 1 - R; var N = C.top + Math.min(C.height * P, h), D = C.top + C.height * R - N, z = Math.min(h + D, m), V = Math.min(Math.max(0, h - N), z) / z; return V !== o.scrollPercent && n.dispatch(Object(d.parameterChanged)(M, V)), { scrollPercent: V } } }), m(r, p.v, V), m(r, p.w, V), m(r, p.r, h({}, M, { handler: R(function (t, e) { e.scrollingDown && E(t) }) })), m(r, p.s, h({}, M, { handler: R(function (t, e) { e.scrollingDown || E(t) }) })), m(r, p.p, { types: "readystatechange IX2_PREVIEW_LOAD", handler: S(_, function (t) { return function (e, n) { var r = { finished: "complete" === document.readyState }; return !r.finished || n && n.finshed || t(e), r } }(E)) }), m(r, p.t, { types: "readystatechange IX2_PREVIEW_LOAD", handler: S(_, function (t) { return function (e, n) { return n || t(e), { started: !0 } } }(E)) }), r) }, function (t, e, n) { var r = n(225)(); t.exports = r }, function (t, e, n) { var r = n(43), i = n(226), o = n(85), a = n(86), u = n(0), c = n(239), s = "Expected a function", f = 8, l = 32, d = 128, p = 256; t.exports = function (t) { return i(function (e) { var n = e.length, i = n, v = r.prototype.thru; for (t && e.reverse() ; i--;) { var h = e[i]; if ("function" != typeof h) throw new TypeError(s); if (v && !g && "wrapper" == a(h)) var g = new r([], !0) } for (i = g ? i : n; ++i < n;) { h = e[i]; var m = a(h), y = "wrapper" == m ? o(h) : void 0; g = y && c(y[0]) && y[1] == (d | f | l | p) && !y[4].length && 1 == y[9] ? g[a(y[0])].apply(g, y[3]) : 1 == h.length && c(h) ? g[m]() : g.thru(h) } return function () { var t = arguments, r = t[0]; if (g && 1 == t.length && u(r)) return g.plant(r).value(); for (var i = 0, o = n ? e[i].apply(this, t) : r; ++i < n;) o = e[i].call(this, o); return o } }) } }, function (t, e, n) { var r = n(227), i = n(230), o = n(232); t.exports = function (t) { return o(i(t, void 0, r), t + "") } }, function (t, e, n) { var r = n(228); t.exports = function (t) { return null != t && t.length ? r(t, 1) : [] } }, function (t, e, n) { var r = n(27), i = n(229); t.exports = function t(e, n, o, a, u) { var c = -1, s = e.length; for (o || (o = i), u || (u = []) ; ++c < s;) { var f = e[c]; n > 0 && o(f) ? n > 1 ? t(f, n - 1, o, a, u) : r(u, f) : a || (u[u.length] = f) } return u } }, function (t, e, n) { var r = n(10), i = n(18), o = n(0), a = r ? r.isConcatSpreadable : void 0; t.exports = function (t) { return o(t) || i(t) || !!(a && t && t[a]) } }, function (t, e, n) { var r = n(231), i = Math.max; t.exports = function (t, e, n) { return e = i(void 0 === e ? t.length - 1 : e, 0), function () { for (var o = arguments, a = -1, u = i(o.length - e, 0), c = Array(u) ; ++a < u;) c[a] = o[e + a]; a = -1; for (var s = Array(e + 1) ; ++a < e;) s[a] = o[a]; return s[e] = n(c), r(t, this, s) } } }, function (t, e) { t.exports = function (t, e, n) { switch (n.length) { case 0: return t.call(e); case 1: return t.call(e, n[0]); case 2: return t.call(e, n[0], n[1]); case 3: return t.call(e, n[0], n[1], n[2]) } return t.apply(e, n) } }, function (t, e, n) { var r = n(233), i = n(235)(r); t.exports = i }, function (t, e, n) { var r = n(234), i = n(79), o = n(37), a = i ? function (t, e) { return i(t, "toString", { configurable: !0, enumerable: !1, value: r(e), writable: !0 }) } : o; t.exports = a }, function (t, e) { t.exports = function (t) { return function () { return t } } }, function (t, e) { var n = 800, r = 16, i = Date.now; t.exports = function (t) { var e = 0, o = 0; return function () { var a = i(), u = r - (a - o); if (o = a, u > 0) { if (++e >= n) return arguments[0] } else e = 0; return t.apply(void 0, arguments) } } }, function (t, e, n) { var r = n(70), i = r && new r; t.exports = i }, function (t, e) { t.exports = function () { } }, function (t, e) { t.exports = {} }, function (t, e, n) { var r = n(45), i = n(85), o = n(86), a = n(240); t.exports = function (t) { var e = o(t), n = a[e]; if ("function" != typeof n || !(e in r.prototype)) return !1; if (t === n) return !0; var u = i(n); return !!u && t === u[0] } }, function (t, e, n) { var r = n(45), i = n(43), o = n(44), a = n(0), u = n(5), c = n(241), s = Object.prototype.hasOwnProperty; function f(t) { if (u(t) && !a(t) && !(t instanceof r)) { if (t instanceof i) return t; if (s.call(t, "__wrapped__")) return c(t) } return new i(t) } f.prototype = o.prototype, f.prototype.constructor = f, t.exports = f }, function (t, e, n) { var r = n(45), i = n(43), o = n(242); t.exports = function (t) { if (t instanceof r) return t.clone(); var e = new i(t.__wrapped__, t.__chain__); return e.__actions__ = o(t.__actions__), e.__index__ = t.__index__, e.__values__ = t.__values__, e } }, function (t, e) { t.exports = function (t, e) { var n = -1, r = t.length; for (e || (e = Array(r)) ; ++n < r;) e[n] = t[n]; return e } }, function (t, e, n) { var r = n(82), i = n(38); t.exports = function (t, e, n) { return void 0 === n && (n = e, e = void 0), void 0 !== n && (n = (n = i(n)) == n ? n : 0), void 0 !== e && (e = (e = i(e)) == e ? e : 0), r(i(t), e, n) } }, function (t, e, n) { var r = n(1); function i(t, e, n, r) { var i, o, a, u = n.tram, c = Array.isArray, s = "w-lightbox-", f = /(^|\s+)/g, l = []; function d(t, e) { return l = c(t) ? t : [t], o || d.build(), l.length > 1 && (o.items = o.empty, l.forEach(function (t) { var e = k("thumbnail"), n = k("item").append(e); o.items = o.items.add(n), O(t.thumbnailUrl || t.url, function (t) { t.prop("width") > t.prop("height") ? S(t, "wide") : S(t, "tall"), e.append(S(t, "thumbnail-image")) }) }), o.strip.empty().append(o.items), S(o.content, "group")), u(T(o.lightbox, "hide").trigger("focus")).add("opacity .3s").start({ opacity: 1 }), S(o.html, "noscroll"), d.show(e || 0) } function p(t) { return function (e) { this === e.target && (e.stopPropagation(), e.preventDefault(), t()) } } d.build = function () { return d.destroy(), (o = { html: n(e.documentElement), empty: n() }).arrowLeft = k("control left inactive"), o.arrowRight = k("control right inactive"), o.close = k("control close"), o.spinner = k("spinner"), o.strip = k("strip"), a = new j(o.spinner, I("hide")), o.content = k("content").append(o.spinner, o.arrowLeft, o.arrowRight, o.close), o.container = k("container").append(o.content, o.strip), o.lightbox = k("backdrop hide").append(o.container), o.strip.on("tap", E("item"), m), o.content.on("swipe", y).on("tap", E("left"), v).on("tap", E("right"), h).on("tap", E("close"), g).on("tap", E("image, caption"), h), o.container.on("tap", E("view"), g).on("dragstart", E("img"), w), o.lightbox.on("keydown", x).on("focusin", b), n(r).append(o.lightbox.prop("tabIndex", 0)), d }, d.destroy = function () { o && (T(o.html, "noscroll"), o.lightbox.remove(), o = void 0) }, d.show = function (t) { if (t !== i) { var e = l[t]; if (!e) return d.hide(); var r, c, s = i; return i = t, a.show(), O(e.html && (r = e.width, c = e.height, "data:image/svg+xml;charset=utf-8," + encodeURI('<svg xmlns="http://www.w3.org/2000/svg" width="' + r + '" height="' + c + '"/>')) || e.url, function (r) { if (t === i) { var c, f, d = k("figure", "figure").append(S(r, "image")), p = k("frame").append(d), v = k("view").append(p); e.html && ((f = (c = n(e.html)).is("iframe")) && c.on("load", h), d.append(S(c, "embed"))), e.caption && d.append(k("caption", "figcaption").text(e.caption)), o.spinner.before(v), f || h() } function h() { var e, n, r, c; if (a.hide(), t === i) { if (A(o.arrowLeft, "inactive", t <= 0), A(o.arrowRight, "inactive", t >= l.length - 1), o.view ? (u(o.view).add("opacity .3s").start({ opacity: 0 }).then((e = o.view, function () { e.remove() })), u(v).add("opacity .3s").add("transform .3s").set({ x: t > s ? "80px" : "-80px" }).start({ opacity: 1, x: 0 })) : v.css("opacity", 1), o.view = v, o.items) { T(o.items, "active"); var f = o.items.eq(t); S(f, "active"), n = f.position().left, r = o.strip.scrollLeft(), c = o.strip.width(), (n < r || n > c + r) && u(o.strip).add("scroll-left 500ms").start({ "scroll-left": n }) } } else v.remove() } }), d } }, d.hide = function () { return u(o.lightbox).add("opacity .3s").start({ opacity: 0 }).then(_), d }, d.prev = function () { i > 0 && d.show(i - 1) }, d.next = function () { i < l.length - 1 && d.show(i + 1) }; var v = p(d.prev), h = p(d.next), g = p(d.hide), m = function (t) { var e = n(this).index(); t.preventDefault(), d.show(e) }, y = function (t, e) { t.preventDefault(), "left" === e.direction ? d.next() : "right" === e.direction && d.prev() }, b = function () { this.focus() }; function w(t) { t.preventDefault() } function x(t) { var e = t.keyCode; 27 === e ? d.hide() : 37 === e ? d.prev() : 39 === e && d.next() } function _() { o && (o.strip.scrollLeft(0).empty(), T(o.html, "noscroll"), S(o.lightbox, "hide"), o.view && o.view.remove(), T(o.content, "group"), S(o.arrowLeft, "inactive"), S(o.arrowRight, "inactive"), i = o.view = void 0) } function O(t, e) { var n = k("img", "img"); return n.one("load", function () { e(n) }), n.attr("src", t), n } function j(t, e, n) { this.$element = t, this.className = e, this.delay = n || 200, this.hide() } function I(t, e) { return t.replace(f, (e ? " ." : " ") + s) } function E(t) { return I(t, !0) } function S(t, e) { return t.addClass(I(e)) } function T(t, e) { return t.removeClass(I(e)) } function A(t, e, n) { return t.toggleClass(I(e), n) } function k(t, r) { return S(n(e.createElement(r || "div")), t) } return j.prototype.show = function () { var t = this; t.timeoutId || (t.timeoutId = setTimeout(function () { t.$element.removeClass(t.className), delete t.timeoutId }, t.delay)) }, j.prototype.hide = function () { if (this.timeoutId) return clearTimeout(this.timeoutId), void delete this.timeoutId; this.$element.addClass(this.className) }, function () { var n = t.navigator.userAgent, r = n.match(/(iPhone|iPad|iPod);[^OS]*OS (\d)/); if (n.indexOf("Android ") > -1 && -1 === n.indexOf("Chrome") || r && !(r[2] > 7)) { var i = e.createElement("style"); e.head.appendChild(i), t.addEventListener("orientationchange", o, !0), o() } function o() { var e = t.innerHeight, n = t.innerWidth, r = ".w-lightbox-content, .w-lightbox-view, .w-lightbox-view:before {height:" + e + "px}.w-lightbox-view {width:" + n + "px}.w-lightbox-group, .w-lightbox-group .w-lightbox-view, .w-lightbox-group .w-lightbox-view:before {height:" + .86 * e + "px}.w-lightbox-image {max-width:" + n + "px;max-height:" + e + "px}.w-lightbox-group .w-lightbox-image {max-height:" + .86 * e + "px}.w-lightbox-strip {padding: 0 " + .01 * e + "px}.w-lightbox-item {width:" + .1 * e + "px;padding:" + .02 * e + "px " + .01 * e + "px}.w-lightbox-thumbnail {height:" + .1 * e + "px}@media (min-width: 768px) {.w-lightbox-content, .w-lightbox-view, .w-lightbox-view:before {height:" + .96 * e + "px}.w-lightbox-content {margin-top:" + .02 * e + "px}.w-lightbox-group, .w-lightbox-group .w-lightbox-view, .w-lightbox-group .w-lightbox-view:before {height:" + .84 * e + "px}.w-lightbox-image {max-width:" + .96 * n + "px;max-height:" + .96 * e + "px}.w-lightbox-group .w-lightbox-image {max-width:" + .823 * n + "px;max-height:" + .84 * e + "px}}"; i.textContent = r } }(), d } r.define("lightbox", t.exports = function (t) { var e, n, o = {}, a = r.env(), u = i(window, document, t, a ? "#lightbox-mountpoint" : "body"), c = t(document), s = ".w-lightbox"; function f(t) { var e, r, i = t.el.children(".w-json").html(); if (i) { try { i = JSON.parse(i) } catch (t) { console.error("Malformed lightbox JSON configuration.", t) } !function (t) { t.images && (t.images.forEach(function (t) { t.type = "image" }), t.items = t.images); t.embed && (t.embed.type = "video", t.items = [t.embed]); t.groupId && (t.group = t.groupId) }(i), (e = i.group) ? ((r = n[e]) || (r = n[e] = []), t.items = r, i.items.length && (t.index = r.length, r.push.apply(r, i.items))) : t.items = i.items } else t.items = [] } return o.ready = o.design = o.preview = function () { e = a && r.env("design"), u.destroy(), n = {}, c.find(s).webflowLightBox() }, jQuery.fn.extend({ webflowLightBox: function () { t.each(this, function (n, r) { var i = t.data(r, s); i || (i = t.data(r, s, { el: t(r), mode: "images", images: [], embed: "" })), i.el.off(s), f(i), e ? i.el.on("setting" + s, f.bind(null, i)) : i.el.on("tap" + s, function (t) { return function () { t.items.length && u(t.items, t.index || 0) } }(i)).on("click" + s, function (t) { t.preventDefault() }) }) } }), o }) }, function (t, e, n) { var r = n(1); r.define("links", t.exports = function (t, e) { var n, i, o, a = {}, u = t(window), c = r.env(), s = window.location, f = document.createElement("a"), l = "w--current", d = /^#[\w:.-]+$/, p = /index\.(html|php)$/, v = /\/$/; function h(e) { var r = n && e.getAttribute("href-disabled") || e.getAttribute("href"); if (f.href = r, !(r.indexOf(":") >= 0)) { var a = t(e); if (0 === r.indexOf("#") && d.test(r)) { var u = t(r); u.length && i.push({ link: a, sec: u, active: !1 }) } else if ("#" !== r && "" !== r) { var c = f.href === s.href || r === o || p.test(r) && v.test(o); m(a, l, c) } } } function g() { var t = u.scrollTop(), n = u.height(); e.each(i, function (e) { var r = e.link, i = e.sec, o = i.offset().top, a = i.outerHeight(), u = .5 * n, c = i.is(":visible") && o + a - u >= t && o + u <= t + n; e.active !== c && (e.active = c, m(r, l, c)) }) } function m(t, e, n) { var r = t.hasClass(e); n && r || (n || r) && (n ? t.addClass(e) : t.removeClass(e)) } return a.ready = a.design = a.preview = function () { n = c && r.env("design"), o = r.env("slug") || s.pathname || "", r.scroll.off(g), i = []; for (var t = document.links, e = 0; e < t.length; ++e) h(t[e]); i.length && (r.scroll.on(g), g()) }, a }) }, function (t, e, n) { var r = n(1); r.define("maps", t.exports = function (t, e) { var n, i = {}, o = t(document), a = null, u = ".w-widget-map", c = "AIzaSyBQ4EYEg4aRz9-yiCnerTV7bk8GCWgZOhk"; function s() { r.resize.off(l), r.redraw.off(l) } function f(e, n) { v(n, t(n).data()) } function l() { n.each(d) } function d(t, e) { var n = v(e); a.maps.event.trigger(n.map, "resize"), n.setMapPosition() } i.ready = function () { r.env() || function () { if (!(n = o.find(u)).length) return; null === a ? (t.getScript("https://maps.googleapis.com/maps/api/js?v=3.31&sensor=false&callback=_wf_maps_loaded&key=" + c), window._wf_maps_loaded = e) : e(); function e() { window._wf_maps_loaded = function () { }, a = window.google, n.each(f), s(), r.resize.on(l), r.redraw.on(l) } }() }, i.destroy = s; var p = "w-widget-map"; function v(e, n) { var i = t.data(e, p); if (i) return i; var o = t(e); i = t.data(e, p, { latLng: "51.511214,-0.119824", tooltip: "", style: "roadmap", zoom: 12, marker: new a.maps.Marker({ draggable: !1 }), infowindow: new a.maps.InfoWindow({ disableAutoPan: !0 }) }); var u = n.widgetLatlng || i.latLng; i.latLng = u; var c = u.split(","), s = new a.maps.LatLng(c[0], c[1]); i.latLngObj = s; var f = !(r.env.touch && n.disableTouch); i.map = new a.maps.Map(e, { center: i.latLngObj, zoom: i.zoom, maxZoom: 18, mapTypeControl: !1, panControl: !1, streetViewControl: !1, scrollwheel: !n.disableScroll, draggable: f, zoomControl: !0, zoomControlOptions: { style: a.maps.ZoomControlStyle.SMALL }, mapTypeId: i.style }), i.marker.setMap(i.map), i.setMapPosition = function () { i.map.setCenter(i.latLngObj); var t = 0, e = 0, n = o.css(["paddingTop", "paddingRight", "paddingBottom", "paddingLeft"]); t -= parseInt(n.paddingLeft, 10), t += parseInt(n.paddingRight, 10), e -= parseInt(n.paddingTop, 10), e += parseInt(n.paddingBottom, 10), (t || e) && i.map.panBy(t, e), o.css("position", "") }, a.maps.event.addListener(i.map, "tilesloaded", function () { a.maps.event.clearListeners(i.map, "tilesloaded"), i.setMapPosition() }), i.setMapPosition(), i.marker.setPosition(i.latLngObj), i.infowindow.setPosition(i.latLngObj); var l = n.widgetTooltip; l && (i.tooltip = l, i.infowindow.setContent(l), i.infowindowOpen || (i.infowindow.open(i.map, i.marker), i.infowindowOpen = !0)); var d = n.widgetStyle; d && i.map.setMapTypeId(d); var v = n.widgetZoom; return null != v && (i.zoom = v, i.map.setZoom(Number(v))), a.maps.event.addListener(i.marker, "click", function () { window.open("https://maps.google.com/?z=" + i.zoom + "&daddr=" + i.latLng) }), i } return i }) }, function (t, e, n) { var r = n(1); r.define("scroll", t.exports = function (t) { var e = t(document), n = window, i = n.location, o = function () { try { return Boolean(n.frameElement) } catch (t) { return !0 } }() ? null : n.history, a = /^[a-zA-Z0-9][\w:.-]*$/; function u(e, u) { if (a.test(e)) { var c = t("#" + e); if (c.length) { if (u && (u.preventDefault(), u.stopPropagation()), i.hash !== e && o && o.pushState && (!r.env.chrome || "file:" !== i.protocol)) (o.state && o.state.hash) !== e && o.pushState({ hash: e }, "", "#" + e); var s = r.env("editor") ? ".w-editor-body" : "body", f = t("header, " + s + " > .header, " + s + " > .w-nav:not([data-no-scroll])"), l = "fixed" === f.css("position") ? f.outerHeight() : 0; n.setTimeout(function () { !function (e, r) { var i = t(n).scrollTop(), o = e.offset().top - r; if ("mid" === e.data("scroll")) { var a = t(n).height() - r, u = e.outerHeight(); u < a && (o -= Math.round((a - u) / 2)) } var c = 1; t("body").add(e).each(function () { var e = parseFloat(t(this).attr("data-scroll-time"), 10); !isNaN(e) && (0 === e || e > 0) && (c = e) }), Date.now || (Date.now = function () { return (new Date).getTime() }); var s = Date.now(), f = n.requestAnimationFrame || n.mozRequestAnimationFrame || n.webkitRequestAnimationFrame || function (t) { n.setTimeout(t, 15) }, l = (472.143 * Math.log(Math.abs(i - o) + 125) - 2e3) * c; !function t() { var e = Date.now() - s; n.scroll(0, function (t, e, n, r) { if (n > r) return e; return t + (e - t) * (i = n / r, i < .5 ? 4 * i * i * i : (i - 1) * (2 * i - 2) * (2 * i - 2) + 1); var i }(i, o, e, l)), e <= l && f(t) }() }(c, l) }, u ? 0 : 300) } } } return { ready: function () { i.hash && u(i.hash.substring(1)); var n = i.href.split("#")[0]; e.on("click", "a", function (e) { if (!(r.env("design") || window.$.mobile && t(e.currentTarget).hasClass("ui-link"))) if ("#" !== this.getAttribute("href")) { var i = this.href.split("#"), o = i[0] === n ? i[1] : null; o && u(o, e) } else e.preventDefault() }) } } }) }, function (t, e, n) { var r = n(1), i = n(47); r.define("tabs", t.exports = function (t) { var e, n, o = {}, a = t.tram, u = t(document), c = r.env, s = c.safari, f = c(), l = "data-w-tab", d = ".w-tabs", p = "w--current", v = "w--tab-active", h = i.triggers, g = !1; function m() { n = f && r.env("design"), (e = u.find(d)).length && (e.each(w), r.env("preview") && !g && e.each(b), y(), r.redraw.on(o.redraw)) } function y() { r.redraw.off(o.redraw) } function b(e, n) { var r = t.data(n, d); r && (r.links && r.links.each(h.reset), r.panes && r.panes.each(h.reset)) } function w(e, r) { var i = t(r), o = t.data(r, d); if (o || (o = t.data(r, d, { el: i, config: {} })), o.current = null, o.menu = i.children(".w-tab-menu"), o.links = o.menu.children(".w-tab-link"), o.content = i.children(".w-tab-content"), o.panes = o.content.children(".w-tab-pane"), o.el.off(d), o.links.off(d), function (t) { var e = {}; e.easing = t.el.attr("data-easing") || "ease"; var n = parseInt(t.el.attr("data-duration-in"), 10); n = e.intro = n == n ? n : 0; var r = parseInt(t.el.attr("data-duration-out"), 10); r = e.outro = r == r ? r : 0, e.immediate = !n && !r, t.config = e }(o), !n) { o.links.on("click" + d, function (t) { return function (e) { var n = e.currentTarget.getAttribute(l); n && x(t, { tab: n }) } }(o)); var a = o.links.filter("." + p).attr(l); a && x(o, { tab: a, immediate: !0 }) } } function x(e, n) { n = n || {}; var i = e.config, o = i.easing, u = n.tab; if (u !== e.current) { e.current = u, e.links.each(function (e, n) { var r = t(n); n.getAttribute(l) === u ? r.addClass(p).each(h.intro) : r.hasClass(p) && r.removeClass(p).each(h.outro) }); var c = [], f = []; e.panes.each(function (e, n) { var r = t(n); n.getAttribute(l) === u ? c.push(n) : r.hasClass(v) && f.push(n) }); var d = t(c), m = t(f); if (n.immediate || i.immediate) return d.addClass(v).each(h.intro), m.removeClass(v), void (g || r.redraw.up()); m.length && i.outro ? (m.each(h.outro), a(m).add("opacity " + i.outro + "ms " + o, { fallback: s }).start({ opacity: 0 }).then(y)) : y() } function y() { if (m.removeClass(v).css({ opacity: "", transition: "", transform: "", width: "", height: "" }), d.addClass(v).each(h.intro), r.redraw.up(), !i.intro) return a(d).set({ opacity: 1 }); a(d).set({ opacity: 0 }).redraw().add("opacity " + i.intro + "ms " + o, { fallback: s }).start({ opacity: 1 }) } } return o.ready = o.design = o.preview = m, o.redraw = function () { g = !0, m(), g = !1 }, o.destroy = function () { (e = u.find(d)).length && (e.each(b), y()) }, o }) }, function (t, e, n) { n(1).define("touch", t.exports = function (t) { var e = {}, n = !document.addEventListener, r = window.getSelection; function i(e, n, r) { var i = t.Event(e, { originalEvent: n }); t(n.target).trigger(i, r) } return n && (t.event.special.tap = { bindType: "click", delegateType: "click" }), e.init = function (e) { return n ? null : (e = "string" == typeof e ? t(e).get(0) : e) ? new function (t) { var e, n, o, a = !1, u = !1, c = !1, s = Math.min(Math.round(.04 * window.innerWidth), 40); function f(t) { var r = t.touches; r && r.length > 1 || (a = !0, u = !1, r ? (c = !0, e = r[0].clientX, n = r[0].clientY) : (e = t.clientX, n = t.clientY), o = e) } function l(t) { if (a) { if (c && "mousemove" === t.type) return t.preventDefault(), void t.stopPropagation(); var f = t.touches, l = f ? f[0].clientX : t.clientX, d = f ? f[0].clientY : t.clientY, v = l - o; o = l, Math.abs(v) > s && r && "" === String(r()) && (i("swipe", t, { direction: v > 0 ? "right" : "left" }), p()), (Math.abs(l - e) > 10 || Math.abs(d - n) > 10) && (u = !0) } } function d(t) { if (a) { if (a = !1, c && "mouseup" === t.type) return t.preventDefault(), t.stopPropagation(), void (c = !1); u || i("tap", t) } } function p() { a = !1 } t.addEventListener("touchstart", f, !1), t.addEventListener("touchmove", l, !1), t.addEventListener("touchend", d, !1), t.addEventListener("touchcancel", p, !1), t.addEventListener("mousedown", f, !1), t.addEventListener("mousemove", l, !1), t.addEventListener("mouseup", d, !1), t.addEventListener("mouseout", p, !1), this.destroy = function () { t.removeEventListener("touchstart", f, !1), t.removeEventListener("touchmove", l, !1), t.removeEventListener("touchend", d, !1), t.removeEventListener("touchcancel", p, !1), t.removeEventListener("mousedown", f, !1), t.removeEventListener("mousemove", l, !1), t.removeEventListener("mouseup", d, !1), t.removeEventListener("mouseout", p, !1), t = null } }(e) : null }, e.instance = e.init(document), e }) }]);/**
 * ----------------------------------------------------------------------
 * Webflow: Interactions: Init
 */
Webflow.require('ix').init([
  { "slug": "close-popup", "name": "close popup", "value": { "style": {}, "triggers": [{ "type": "scroll", "selector": ".business-tabs-fixed", "stepsA": [{ "display": "none", "opacity": 0, "transition": "opacity 500ms ease 0ms" }], "stepsB": [{ "display": "flex", "opacity": 1, "transition": "opacity 200ms ease 0ms" }] }, { "type": "click", "selector": ".modal-wrapper", "preserve3d": true, "stepsA": [{ "display": "none", "opacity": 0, "transition": "transform 200 ease 0, opacity 200 ease 0", "x": "0px", "y": "46px", "z": "0px" }, { "display": "none" }], "stepsB": [] }] } },
  { "slug": "popup-date-picker", "name": "Popup Date Picker", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".calendar-overall-div", "stepsA": [{ "display": "block", "opacity": 0 }, { "display": "block", "opacity": 1, "transition": "opacity 500ms ease 0ms" }], "stepsB": [{ "display": "block", "opacity": 0, "transition": "opacity 500ms ease 0ms" }, { "display": "none", "opacity": 0 }] }] } },
  { "slug": "book-date-popup", "name": "Book Date Popup", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".book-calendar-overall-div", "stepsA": [{ "display": "block", "opacity": 0 }, { "display": "block", "opacity": 1, "transition": "opacity 500ms ease 0ms" }], "stepsB": [{ "display": "block", "opacity": 0, "transition": "opacity 500ms ease 0ms" }, { "display": "none", "opacity": 0 }] }] } },
  { "slug": "mobile-search-div", "name": "Mobile Search Div", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".mobile-search-background-div", "stepsA": [{ "display": "block", "opacity": 1, "transition": "opacity 500ms ease 0ms" }], "stepsB": [] }] } },
  { "slug": "mobile-search-close", "name": "Mobile Search Close", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".mobile-search-background-div", "stepsA": [{ "display": "none", "opacity": 0, "transition": "opacity 500ms ease 0ms" }], "stepsB": [] }] } },
  { "slug": "aesop-product-popup", "name": "Aesop Product Popup", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".product-popup-background", "stepsA": [{ "display": "flex", "opacity": 0 }, { "opacity": 1, "transition": "opacity 500ms ease 0ms" }], "stepsB": [] }] } },
  { "slug": "close-product-popup", "name": "Close Product Popup", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".product-popup-background", "stepsA": [{ "opacity": 0, "transition": "opacity 500ms ease 0ms" }, { "display": "none" }], "stepsB": [] }] } },
  { "slug": "background-click-dissappear", "name": "Background Click Dissappear", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "opacity": 0, "transition": "opacity 500ms ease 0ms" }, { "display": "none" }], "stepsB": [] }] } },
  { "slug": "mobile-close-product-popup", "name": "Mobile Close Product Popup", "value": { "style": {}, "triggers": [] } },
  { "slug": "mobile-menu-expand", "name": "Mobile Menu Expand", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".mobile-menu-background-div", "stepsA": [{ "display": "block", "opacity": 0 }, { "display": "block", "opacity": 1, "transition": "opacity 500ms ease 0ms" }], "stepsB": [{ "display": "block", "opacity": 0, "transition": "opacity 500ms ease 0ms" }, { "display": "none", "opacity": 0 }] }] } },
  { "slug": "show-map", "name": "Show Map", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".listings-map-40", "stepsA": [{ "display": "block", "opacity": 1, "transition": "opacity 500ms ease 0ms" }], "stepsB": [{ "display": "none", "opacity": 0, "transition": "opacity 500ms ease 0ms" }] }] } },
  { "slug": "new-interaction-2", "name": "New Interaction 2", "value": { "style": {}, "triggers": [{ "type": "hover", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "mobile-show-pricing", "name": "Mobile Show Pricing", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".hidden-mobile", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "change-address", "name": "Change Address", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".change-address-div", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "change-address-2", "name": "Change Address 2", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".change-address-div", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "heart-appear", "name": "Heart Appear", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".heart-appear", "stepsA": [{ "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [{ "opacity": 0, "transition": "opacity 200 ease 0" }] }] } },
  { "slug": "like-heart", "name": "Like Heart", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".heart-appear-fill", "siblings": true, "stepsA": [{ "display": "block", "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "like-disappear", "name": "Like Disappear", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "display": "none", "opacity": 0, "transition": "opacity 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "show-text-editor", "name": "Show Text Editor", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".text-editor-div", "stepsA": [{ "display": "block", "opacity": 0 }, { "display": "block", "opacity": 1, "transition": "opacity 300ms ease 0" }], "stepsB": [{ "display": "block", "opacity": 0, "transition": "opacity 300ms ease 0" }, { "display": "none", "opacity": 0 }] }] } },
  { "slug": "expand-services", "name": "Expand Services", "value": { "style": {}, "triggers": [{ "type": "click", "siblings": true, "stepsA": [{ "display": "block", "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [{ "display": "none", "opacity": 0, "transition": "opacity 200 ease 0" }] }] } },
  { "slug": "show-more-description", "name": "Show More Description", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".listing-business-description", "stepsA": [{ "height": "auto", "transition": "height 200 ease 0" }], "stepsB": [{ "height": "41px", "transition": "height 200 ease 0" }] }] } },
  { "slug": "gallery-solo-hover-heart", "name": "Gallery Solo Hover Heart", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".gallery-hover-div", "descend": true, "stepsA": [{ "display": "flex", "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [{ "display": "none" }] }, { "type": "click", "selector": ".gallery-popup-background", "stepsA": [{ "display": "flex" }], "stepsB": [] }, { "type": "click", "selector": ".gallery-popup-white-overall", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "gallery-solo-hover-heart-2", "name": "Gallery Solo Hover Heart 2", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".gallery-hover-div", "descend": true, "stepsA": [{ "display": "flex", "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [{ "display": "none" }] }, { "type": "click", "selector": ".gallery-popup-background", "stepsA": [{ "display": "flex" }], "stepsB": [] }, { "type": "click", "selector": ".gallery-popup-venue", "stepsA": [{ "display": "flex" }], "stepsB": [] }] } },
  { "slug": "close-gallery-popup", "name": "Close Gallery Popup", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".gallery-popup-white-overall", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".gallery-popup-venue", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".gallery-popup-background", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "open-gallery-popup", "name": "Open Gallery Popup", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".gallery-popup-background", "stepsA": [{ "display": "flex", "transition": "transform 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "where-dropdown", "name": "Where Dropdown", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".where-dropdown", "descend": true, "stepsA": [{ "display": "block" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "message-service-provider", "name": "Message Service Provider", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".message-service-provider-background", "stepsA": [{ "display": "flex" }], "stepsB": [] }, { "type": "click", "selector": ".modal", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "hide-message-service-provider", "name": "Hide Message Service Provider", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".modal", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".message-service-provider-background", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "show-phone-number", "name": "Show Phone Number", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".show-phone-number", "stepsA": [{ "display": "block" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "open-shopping-cart", "name": "Open Shopping Cart", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".shopping-cart-background", "stepsA": [{ "display": "block" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "close-shopping-cart", "name": "Close Shopping Cart", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "hover-day-circle", "name": "Hover Day Circle", "value": { "style": {}, "triggers": [{ "type": "hover", "descend": true, "stepsA": [{ "display": "flex", "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "open-filters", "name": "Open Filters", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".filter-background", "stepsA": [{ "display": "block", "opacity": 0 }, { "display": "block", "opacity": 1, "transition": "opacity 400ms ease 0" }], "stepsB": [] }, { "type": "click", "selector": ".filters-div", "preserve3d": true, "stepsA": [{ "display": "flex", "opacity": 1, "x": "-1200px", "y": "0px", "z": "0px" }, { "display": "block", "transition": "transform 300ms ease-out 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "close-filter", "name": "Close Filter", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".filter-background", "stepsA": [{ "display": "block", "opacity": 0, "transition": "opacity 400ms ease 0" }, { "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".filters-div", "preserve3d": true, "stepsA": [{ "display": "block", "opacity": 0, "transition": "transform 400ms ease 0, opacity 400ms ease 0", "x": "-1200px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "checkbox-click", "name": "Checkbox Click", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".inner-check", "descend": true, "stepsA": [{ "display": "flex" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "show-delete-item-x", "name": "Show Delete Item X", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".delete-item-link", "descend": true, "stepsA": [{ "display": "flex", "opacity": 0 }, { "display": "flex", "opacity": 1, "transition": "opacity 300ms ease 0" }], "stepsB": [{ "display": "none" }, { "display": "flex", "opacity": 0 }] }] } },
  { "slug": "show-quantity-dropdown-arrow", "name": "Show Quantity Dropdown Arrow", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".quantity-dropdown-arrow", "descend": true, "stepsA": [{ "opacity": 0.8, "transition": "opacity 300ms ease 0" }], "stepsB": [{ "opacity": 0, "transition": "opacity 300ms ease 0" }] }] } },
  { "slug": "review-show-more-stars", "name": "Review Show More Stars", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".second-stars-div", "stepsA": [{ "display": "block", "height": "0px" }, { "display": "block", "height": "auto", "transition": "height 300ms ease 0" }], "stepsB": [] }] } },
  { "slug": "hide-your-review-div", "name": "Hide Your Review Div", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".your-review-div", "stepsA": [{ "height": "0px", "transition": "height 300ms ease 0" }], "stepsB": [] }, { "type": "click", "selector": ".review-form-wrapper", "stepsA": [{ "display": "block", "height": "0px" }, { "display": "block", "height": "auto", "transition": "transform 200 ease 0, height 300ms ease 0" }], "stepsB": [] }] } },
  { "slug": "hero-list-move", "name": "Hero List Move", "value": { "style": {}, "triggers": [{ "type": "load", "loopA": true, "stepsA": [{ "wait": "3s" }, { "transition": "transform 250ms ease-out 0", "x": "0px", "y": "-50px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 250ms ease-out 0", "x": "0px", "y": "-100px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 250ms ease-out 0", "x": "0px", "y": "-150px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 250ms ease-out 0", "x": "0px", "y": "-200px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 600ms ease-out 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "open-mobile-dropown", "name": "Open Mobile Dropown", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".mobile-menu-dropdown", "stepsA": [{ "display": "flex", "height": "100vh", "transition": "transform 400ms ease 0, height 400ms ease 0" }], "stepsB": [{ "display": "flex", "height": "0px", "transition": "transform 400ms ease 0, height 400ms ease 0" }, { "display": "none" }] }, { "type": "click", "selector": ".dropdown-arrow", "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "180deg" }], "stepsB": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "0deg" }] }] } },
  { "slug": "move-categories-left", "name": "Move Categories Left", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "transition": "transform 200 ease 0", "x": "-667px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "hide-map-icon", "name": "Hide Map Icon", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "opacity": 0, "transition": "opacity 100ms ease 0" }], "stepsB": [{ "opacity": 1, "transition": "opacity 100ms ease 0" }] }] } },
  { "slug": "show-map-icon", "name": "Show Map Icon", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [], "stepsB": [] }] } },
  { "slug": "show-service-link", "name": "Show Service Link", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".service-link", "descend": true, "stepsA": [{ "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [{ "opacity": 0, "transition": "opacity 200 ease 0" }] }, { "type": "click", "selector": ".service-mobile-hide", "descend": true, "stepsA": [{ "display": "block" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "show-order-summary", "name": "Show Order Summary", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".show-hide-div", "stepsA": [{ "display": "flex", "height": "0px" }, { "display": "flex", "height": "auto", "transition": "height 300ms ease 0" }], "stepsB": [{ "display": "flex", "height": "0px", "transition": "height 300ms ease 0" }, { "display": "none" }] }, { "type": "click", "selector": ".dropdown-checkout", "descend": true, "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "-90deg" }], "stepsB": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "90deg" }] }, { "type": "click", "selector": ".view-order-summary", "descend": true, "stepsA": [{ "opacity": 0, "transition": "opacity 200 ease 0" }], "stepsB": [{ "opacity": 1, "transition": "opacity 200 ease 0" }] }] } },
  { "slug": "initial-show-none", "name": "Initial Show None", "value": { "style": { "display": "none" }, "triggers": [] } },
  { "slug": "add-service", "name": "Add Service", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "display": "flex", "height": "0px" }, { "display": "flex", "height": "auto", "transition": "height 500ms ease 0" }], "stepsB": [] }] } },
  { "slug": "hover-back-arrow", "name": "Hover Back Arrow", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".back-arrow", "preserve3d": true, "stepsA": [{ "transition": "transform 200 ease 0", "x": "-4px", "y": "0px", "z": "0px" }], "stepsB": [{ "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }] }] } },
  { "slug": "open-class-booking", "name": "open class booking", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".class-popup-background", "stepsA": [{ "display": "flex" }], "stepsB": [] }, { "type": "click", "selector": ".review-modal", "stepsA": [{ "display": "block", "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "close-class-modal", "name": "Close Class Modal", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".class-popup-background", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".review-modal", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".popup", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "bg-modal-hide", "name": "BG Modal Hide", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".modal", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "review-back-button", "name": "Review Back Button", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".review-form-wrapper", "stepsA": [{ "height": "0px", "transition": "height 300ms ease 0" }], "stepsB": [] }, { "type": "click", "selector": ".review-stars", "stepsA": [{ "height": "auto", "transition": "height 300ms ease 0" }], "stepsB": [] }] } },
  { "slug": "close-review-modal", "name": "Close Review Modal", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".review-modal", "stepsA": [{ "opacity": 0, "transition": "opacity 300ms ease 0" }, { "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".review-background-div", "stepsA": [{ "opacity": 0, "transition": "opacity 300ms ease 0" }, { "display": "none" }], "stepsB": [] }] } },
  { "slug": "close-class-modal-2", "name": "Close Class Modal 2", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".review-modal", "stepsA": [{ "opacity": 0, "transition": "opacity 300ms ease 0" }, { "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".class-popup-background", "stepsA": [{ "opacity": 0, "transition": "opacity 300ms ease 0" }, { "display": "none" }], "stepsB": [] }] } },
  { "slug": "review-popup-5-sec", "name": "Review Popup 5 sec", "value": { "style": {}, "triggers": [{ "type": "load", "selector": ".review-background-div", "stepsA": [{ "wait": "5s" }, { "display": "flex", "opacity": 0 }, { "display": "flex", "opacity": 1, "transition": "opacity 300ms ease 0" }], "stepsB": [] }, { "type": "load", "selector": ".review-modal", "preserve3d": true, "stepsA": [{ "wait": "5s" }, { "display": "inline-block", "opacity": 0, "scaleX": 0.88, "scaleY": 0.88, "scaleZ": 1 }, { "display": "block", "opacity": 1, "transition": "opacity 300ms ease 0, transform 200 ease 0", "scaleX": 1, "scaleY": 1, "scaleZ": 1 }], "stepsB": [] }] } },
  { "slug": "show-share-popup", "name": "Show Share Popup", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".share-popup", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "gc-category-slide", "name": "GC Category Slide", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".gc-flex-container", "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "x": "-100%", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".build-gc-container", "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "x": "-100%", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".purchase", "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "x": "-100%", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "gc-category-slide-2", "name": "GC Category Slide 2", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".build-gc-container", "preserve3d": true, "stepsA": [{ "transition": "transform 400ms ease 0", "x": "-100%", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".purchase", "preserve3d": true, "stepsA": [{ "transition": "transform 400ms ease 0", "x": "-100%", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "back-to-gc-categories", "name": "Back to GC Categories", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".build-gc-container", "preserve3d": true, "stepsA": [{ "transition": "transform 400ms ease 0", "x": "0%", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".gc-flex-container", "preserve3d": true, "stepsA": [{ "transition": "transform 400ms ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".purchase", "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "back-to-builder", "name": "Back to Builder", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".build-gc-container", "preserve3d": true, "stepsA": [{ "transition": "transform 400ms ease 0", "x": "100%", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".gc-flex-container", "preserve3d": true, "stepsA": [{ "transition": "transform 400ms ease 0", "x": "100%", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".purchase", "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "calendar-fall", "name": "Calendar Fall", "value": { "style": { "opacity": 0, "x": "0px", "y": "-100px", "z": "0px" }, "triggers": [{ "type": "load", "stepsA": [{ "wait": "400ms" }, { "opacity": 1, "transition": "transform 400ms ease-out-back 0, opacity 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "cal-success-check", "name": "Cal Success Check", "value": { "style": { "scaleX": 0.01, "scaleY": 0.01, "scaleZ": 1 }, "triggers": [{ "type": "load", "stepsA": [{ "wait": "800ms" }, { "transition": "transform 200 ease-out-back 0", "scaleX": 1, "scaleY": 1, "scaleZ": 1 }], "stepsB": [] }] } },
  { "slug": "cal-success-check-2", "name": "Cal Success Check 2", "value": { "style": { "scaleX": 0.01, "scaleY": 0.01, "scaleZ": 1 }, "triggers": [{ "type": "load", "stepsA": [{ "wait": "800ms" }, { "transition": "transform 200 ease-out-back 0", "scaleX": 1, "scaleY": 1, "scaleZ": 1 }], "stepsB": [] }] } },
  { "slug": "fade-in", "name": "Fade In", "value": { "style": { "opacity": 0, "x": "0px", "y": "13px", "z": "0px" }, "triggers": [{ "type": "load", "stepsA": [{ "opacity": 1, "transition": "opacity 500ms ease 0, transform 500ms ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "fade-in-delay", "name": "Fade in Delay", "value": { "style": { "opacity": 0 }, "triggers": [{ "type": "load", "stepsA": [{ "wait": "1500ms" }, { "opacity": 1, "transition": "opacity 1000ms ease 0" }], "stepsB": [] }] } },
  { "slug": "rotate-forever", "name": "Rotate Forever", "value": { "style": {}, "triggers": [{ "type": "load", "loopA": true, "stepsA": [{ "transition": "transform 600ms linear 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "360deg" }], "stepsB": [] }] } },
  { "slug": "login-slide-load", "name": "Login Slide Load", "value": { "style": {}, "triggers": [{ "type": "load", "stepsA": [{ "transition": "transform 200 ease 0", "x": "-100%", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "map-card-initial", "name": "Map Card Initial", "value": { "style": { "opacity": 0, "scaleX": 0.01, "scaleY": 0.01, "scaleZ": 1 }, "triggers": [] } },
  { "slug": "point-expand-card", "name": "Point Expand Card", "value": { "style": {}, "triggers": [{ "type": "hover", "selector": ".map-hover-parent", "preserve3d": true, "stepsA": [{ "wait": "250ms" }, { "opacity": 1, "transition": "transform 300ms ease-out-back 0, opacity 200 ease 0", "scaleX": 1, "scaleY": 1, "scaleZ": 1 }], "stepsB": [{ "opacity": 0, "transition": "opacity 200 ease 0, transform 200 ease 0", "scaleX": 0.01, "scaleY": 0.01, "scaleZ": 1 }] }] } },
  { "slug": "open-popup", "name": "Open Popup", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".popup", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": ".review-modal", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "click-map", "name": "Click Map", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".listings-business-parent-div", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".listings-map-40", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": ".map-pill-pkg", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".list-pill-pkg", "stepsA": [{ "display": "flex" }], "stepsB": [] }] } },
  { "slug": "click-map-deals", "name": "Click Map Deals", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".home-page-section", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".listings-map-40", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": ".map-pill-pkg", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".list-pill-pkg", "stepsA": [{ "display": "flex" }], "stepsB": [] }] } },
  { "slug": "click-list", "name": "Click List", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".listings-business-parent-div", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": ".listings-map-40", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".map-pill-pkg", "stepsA": [{ "display": "flex" }], "stepsB": [] }, { "type": "click", "selector": ".list-pill-pkg", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "click-list-deals", "name": "Click List Deals", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".home-page-section", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": ".listings-map-40", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".map-pill-pkg", "stepsA": [{ "display": "flex" }], "stepsB": [] }, { "type": "click", "selector": ".list-pill-pkg", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "close-modal", "name": "Close Modal", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".login-background", "stepsA": [{ "display": "none", "transition": "transform 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "listing-selected", "name": "Listing Selected", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".listing-selected", "descend": true, "stepsA": [{ "opacity": 1, "transition": "opacity 200 ease 0" }], "stepsB": [{ "opacity": 0, "transition": "opacity 200 ease 0" }] }] } },
  { "slug": "new-interaction-3", "name": "New Interaction 3", "value": { "style": {}, "triggers": [{ "type": "scroll", "selector": ".back-to-top-container", "stepsA": [{ "display": "none" }], "stepsB": [{ "display": "flex" }] }] } },
  { "slug": "show-passive-alert", "name": "Show Passive Alert", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".passive-alert-parent", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 400ms ease 0", "x": "0px", "y": "85px", "z": "0px" }, { "wait": "2s" }, { "transition": "transform 300ms ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".message-service-provider-background", "stepsA": [{ "display": "none" }], "stepsB": [] }, { "type": "click", "selector": ".modal", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "open-mobile-search", "name": "Open Mobile Search", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".mobile-search-background-div", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "close-mobile-search", "name": "Close Mobile Search", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "delete-servicediv", "name": "Delete ServiceDiv", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".add-service-div", "stepsA": [{ "height": "0px", "transition": "height 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "add-service-div", "name": "Add Service Div", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".add-service-div", "stepsA": [{ "height": "auto", "transition": "height 200 ease 0" }], "stepsB": [] }] } },
  { "slug": "open-side-business-panel", "name": "Open Side Business Panel", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".inner", "preserve3d": true, "stepsA": [{ "display": "flex", "opacity": 0, "x": "-910px", "y": "0px", "z": "0px" }, { "display": "flex", "opacity": 1, "transition": "opacity 300ms ease 0, transform 300ms ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": ".div-block-172", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": "._77-east", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "open-side-business-panel-2", "name": "Open Side Business Panel 2", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".inner", "preserve3d": true, "stepsA": [{ "display": "flex", "opacity": 0, "x": "-910px", "y": "0px", "z": "0px" }, { "display": "flex", "opacity": 1, "transition": "opacity 300ms ease 0, transform 300ms ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }, { "type": "click", "selector": "._77-east", "stepsA": [{ "display": "block" }], "stepsB": [] }, { "type": "click", "selector": ".div-block-172", "stepsA": [{ "display": "none" }], "stepsB": [] }] } },
  { "slug": "close-side-business-panel", "name": "Close Side Business Panel", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".inner", "preserve3d": true, "stepsA": [{ "display": "flex", "opacity": 0, "transition": "transform 300ms ease 0, opacity 300ms ease 0", "x": "-910px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] }] } },
  { "slug": "accordion", "name": "Accordion", "value": { "style": {}, "triggers": [{ "type": "dropdown", "stepsA": [{ "height": "auto", "transition": "transform 200 ease 0, height 400ms ease 0" }], "stepsB": [{ "height": "0px", "transition": "height 400ms ease 0" }] }] } },
  { "slug": "drop-auto", "name": "Drop Auto", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".services-flexy-copy", "stepsA": [{ "height": "auto", "transition": "height 300ms ease 0" }], "stepsB": [{ "height": "0px", "transition": "height 300ms ease 0" }] }, { "type": "click", "selector": ".open-close-icon", "descend": true, "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "90deg" }], "stepsB": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "0deg" }] }] } },
  { "slug": "drop-auto-2", "name": "Drop Auto 2", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".services-flexy-copy-2", "stepsA": [{ "height": "auto", "transition": "height 300ms ease 0" }], "stepsB": [{ "height": "0px", "transition": "height 300ms ease 0" }] }, { "type": "click", "selector": ".open-close-icon-2", "descend": true, "preserve3d": true, "stepsA": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "90deg" }], "stepsB": [{ "transition": "transform 300ms ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "0deg" }] }, { "type": "click", "selector": ".services-flexy-copy", "stepsA": [{ "height": "0px", "transition": "height 300ms ease 0" }], "stepsB": [] }, { "type": "click", "selector": ".open-close-icon", "preserve3d": true, "stepsA": [{ "transition": "transform 200 ease 0", "rotateX": "0deg", "rotateY": "0deg", "rotateZ": "0deg" }], "stepsB": [] }] } },
  { "slug": "click-about-tab", "name": "Click About Tab", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".about-tab", "stepsA": [{ "display": "block" }], "stepsB": [] }] } },
  { "slug": "select-gc", "name": "Select GC", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".blue-checkmark", "descend": true, "stepsA": [{ "display": "block" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "modal-interaction", "name": "modal interaction", "value": { "style": { "display": "none", "opacity": 0 }, "triggers": [] } },
  { "slug": "new-interaction-4", "name": "New Interaction 4", "value": { "style": {}, "triggers": [] } },
  { "slug": "add-to-waitlist", "name": "Add to Waitlist", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".modal-wrapper", "preserve3d": true, "stepsA": [{ "display": "flex" }, { "opacity": 1, "transition": "transform 200 ease 0, opacity 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "new-ddsp", "name": "New DDSP", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".sp-names-drdn", "preserve3d": true, "stepsA": [{ "display": "block", "opacity": 1, "transition": "transform 200 ease 0, opacity 200 ease 0", "x": "0px", "y": "5px", "z": "0px" }], "stepsB": [] }] } },
  { "slug": "dd-interaction", "name": "DD Interaction", "value": { "style": {}, "triggers": [{ "type": "click", "selector": ".sp-names-drdn", "stepsA": [{ "display": "block" }], "stepsB": [{ "display": "none" }] }] } },
  { "slug": "new-interaction-5", "name": "New Interaction 5", "value": { "style": {}, "triggers": [{ "type": "click", "stepsA": [{}], "stepsB": [] }] } }
]);
/**
 * ----------------------------------------------------------------------
 * Webflow: Interactions 2.0: Init
 */
Webflow.require('ix2').init(
{ "events": { "e": { "id": "e", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-2" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|21d6b867-1e31-1675-9f15-191b7ee2bc12" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512171637024 }, "e-2": { "id": "e-2", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|21d6b867-1e31-1675-9f15-191b7ee2bc12" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512171637024 }, "e-3": { "id": "e-3", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|733b527b-c48c-2caf-790c-a330d4346b6f": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|e8d66065-874d-f41e-c75a-a348aa29fdbb": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-4" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|d2abf274-2dbf-8a9f-d51c-2f75002fe7d5" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512172115892 }, "e-4": { "id": "e-4", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-3" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|d2abf274-2dbf-8a9f-d51c-2f75002fe7d5" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512172115892 }, "e-7": { "id": "e-7", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|e54d0e34-dc20-77f4-94ee-abf589cd8f81": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|c68a45f7-0bce-323d-c797-c1eaeaf79c4c": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-8" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|f986e859-c19e-c9ce-a6e8-f07210c59aad" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512172261770 }, "e-8": { "id": "e-8", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-7" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|f986e859-c19e-c9ce-a6e8-f07210c59aad" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512172261770 }, "e-9": { "id": "e-9", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|5917b1dd-527d-c29f-1dd4-bb837b25bf2d": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|db7616c2-3b92-983c-c38c-2ba1d0e12f80": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-10" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|b4b5b705-45e0-fdec-d128-f823432a5258" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512177962951 }, "e-10": { "id": "e-10", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-9" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c2bde690334|b4b5b705-45e0-fdec-d128-f823432a5258" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1512177962951 }, "e-11": { "id": "e-11", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-3", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-12" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c969b690181|8a106a29-8aa1-2566-d05d-8e66f7f04ec4" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1515455505485 }, "e-12": { "id": "e-12", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-3", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-11" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c969b690181|8a106a29-8aa1-2566-d05d-8e66f7f04ec4" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1515455505486 }, "e-13": { "id": "e-13", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-4", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-14" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c969b690181|99011d90-cc06-135c-34cc-613506971fe9" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1515456305656 }, "e-16": { "id": "e-16", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-4", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-15" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c969b690181|43402794-4edf-f2f3-e7b2-664489f7c9ed" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1515456317863 }, "e-17": { "id": "e-17", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-5", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-18" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|21d6b867-1e31-1675-9f15-191b7ee2bc12" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-18": { "id": "e-18", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-6", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-17" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|21d6b867-1e31-1675-9f15-191b7ee2bc12" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-19": { "id": "e-19", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-5", "affectedElements": { "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|733b527b-c48c-2caf-790c-a330d4346b6f": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|e8d66065-874d-f41e-c75a-a348aa29fdbb": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-20" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|d2abf274-2dbf-8a9f-d51c-2f75002fe7d5" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-20": { "id": "e-20", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-6", "affectedElements": { "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-19" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|d2abf274-2dbf-8a9f-d51c-2f75002fe7d5" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-21": { "id": "e-21", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-5", "affectedElements": { "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|e54d0e34-dc20-77f4-94ee-abf589cd8f81": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|c68a45f7-0bce-323d-c797-c1eaeaf79c4c": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-22" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|f986e859-c19e-c9ce-a6e8-f07210c59aad" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-22": { "id": "e-22", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-6", "affectedElements": { "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-21" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|f986e859-c19e-c9ce-a6e8-f07210c59aad" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-23": { "id": "e-23", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-5", "affectedElements": { "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|5917b1dd-527d-c29f-1dd4-bb837b25bf2d": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|db7616c2-3b92-983c-c38c-2ba1d0e12f80": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-24" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|b4b5b705-45e0-fdec-d128-f823432a5258" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-24": { "id": "e-24", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-6", "affectedElements": { "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-23" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c30a5690378|b4b5b705-45e0-fdec-d128-f823432a5258" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516132956071 }, "e-27": { "id": "e-27", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|5917b1dd-527d-c29f-1dd4-bb837b25bf2d": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|db7616c2-3b92-983c-c38c-2ba1d0e12f80": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-28" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|fbc4b416-ae75-a2c4-f820-026f34015cca" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-28": { "id": "e-28", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-27" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|fbc4b416-ae75-a2c4-f820-026f34015cca" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-29": { "id": "e-29", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|e54d0e34-dc20-77f4-94ee-abf589cd8f81": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|c68a45f7-0bce-323d-c797-c1eaeaf79c4c": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-30" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|5f8ec1d8-add7-6fb5-345d-7afb5621ba7d" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-30": { "id": "e-30", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-29" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|5f8ec1d8-add7-6fb5-345d-7afb5621ba7d" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-31": { "id": "e-31", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-32" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|997e90d0-4a68-c79a-0eee-8336e6c39fcb" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-32": { "id": "e-32", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-31" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|997e90d0-4a68-c79a-0eee-8336e6c39fcb" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-33": { "id": "e-33", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|733b527b-c48c-2caf-790c-a330d4346b6f": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|e8d66065-874d-f41e-c75a-a348aa29fdbb": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-34" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|f7cf6ebf-82b4-7fb5-a8e7-34ca612e3d49" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-34": { "id": "e-34", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-33" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c4cd9690356|f7cf6ebf-82b4-7fb5-a8e7-34ca612e3d49" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516406411866 }, "e-35": { "id": "e-35", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|5917b1dd-527d-c29f-1dd4-bb837b25bf2d": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|db7616c2-3b92-983c-c38c-2ba1d0e12f80": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-36" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|b438b100-bfa5-4b8b-2ad4-46162f95ec59" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-36": { "id": "e-36", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy", "selectorGuids": ["482dac50-616e-8770-ffe9-d86d0a5f5b36"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon", "selectorGuids": ["bea368e7-adaa-0cfe-a32b-2ee5f3b29b0e"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-35" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|b438b100-bfa5-4b8b-2ad4-46162f95ec59" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-37": { "id": "e-37", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|e54d0e34-dc20-77f4-94ee-abf589cd8f81": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|c68a45f7-0bce-323d-c797-c1eaeaf79c4c": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-38" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|dac20a22-2d56-23b3-240a-e96d4c842575" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-38": { "id": "e-38", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-2", "selectorGuids": ["3d2eb9ea-6bf6-64d5-7f85-84af1288c916"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-2", "selectorGuids": ["1a933cf7-fe2c-656c-be05-1d6c82fc0078"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-37" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|dac20a22-2d56-23b3-240a-e96d4c842575" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-39": { "id": "e-39", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-40" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|0b4e811c-7000-a5f0-f644-383190427e24" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-40": { "id": "e-40", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-39" } }, "mediaQueries": ["small", "tiny", "main", "medium"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|0b4e811c-7000-a5f0-f644-383190427e24" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-41": { "id": "e-41", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|733b527b-c48c-2caf-790c-a330d4346b6f": { "selector": ".services-flexy-copy-3", "selectorGuids": ["2d3bf6e8-26e1-2bbc-7723-8ee74b737466"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|e8d66065-874d-f41e-c75a-a348aa29fdbb": { "selector": ".open-close-icon-3", "selectorGuids": ["d9417e36-78ca-eb8c-7eb5-9d41d54686e0"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-42" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|0fac9918-3238-eac4-9a54-98759175f853" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-42": { "id": "e-42", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-2", "affectedElements": { "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080": { "selector": ".services-flexy-copy-4", "selectorGuids": ["1638ede7-20c6-07a5-5a63-b0f348a7f6a4"], "limitAffectedElements": null }, "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481": { "selector": ".open-close-icon-4", "selectorGuids": ["7fe15023-d2a6-bf15-35d7-7df2908dbf95"], "limitAffectedElements": null } }, "playInReverse": false, "autoStopEventId": "e-41" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c65bf69039a|0fac9918-3238-eac4-9a54-98759175f853" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1516412851148 }, "e-43": { "id": "e-43", "eventTypeId": "PAGE_START", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-7", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-44" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "PAGE", "styleBlockIds": [], "id": "5ab2e96d11322c45666903ab" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1517527845935 }, "e-45": { "id": "e-45", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-8", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-46" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|056c3730-6fdb-e33a-47a5-90db535541b6" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518214966726 }, "e-46": { "id": "e-46", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-9", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-45" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|056c3730-6fdb-e33a-47a5-90db535541b6" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518214966726 }, "e-47": { "id": "e-47", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-10", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-48" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|100c27d5-70a7-2a7c-665e-078608ad3edc" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518220255320 }, "e-49": { "id": "e-49", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-11", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-50" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|75e82e10-027a-45a5-3c04-cad4ded54598" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518220458234 }, "e-51": { "id": "e-51", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-11", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-52" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|a7072b09-cba9-34e9-2462-5fa655c28189" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518220489150 }, "e-53": { "id": "e-53", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-8", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-54" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf91169024a|4dbf6f22-0943-8925-2bda-2aab1fa444b0" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518220814323 }, "e-54": { "id": "e-54", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-9", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-53" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf91169024a|4dbf6f22-0943-8925-2bda-2aab1fa444b0" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518220814323 }, "e-59": { "id": "e-59", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-8", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-60" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf91169024a|5c08e2b3-4546-cdf9-dfc7-43d1bb60004d" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518636876730 }, "e-60": { "id": "e-60", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-9", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-59" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf91169024a|5c08e2b3-4546-cdf9-dfc7-43d1bb60004d" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1518636876730 }, "e-63": { "id": "e-63", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-17", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-64" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c7b8c690213|99011d90-cc06-135c-34cc-613506971fe9" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519249445537 }, "e-65": { "id": "e-65", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-18", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-66" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c7b8c690213|5b566f04-60b4-dc0c-7c6b-a7581ae12f1b" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519256436572 }, "e-66": { "id": "e-66", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-19", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-65" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c7b8c690213|5b566f04-60b4-dc0c-7c6b-a7581ae12f1b" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519256436573 }, "e-67": { "id": "e-67", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-20", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-68" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c282269019b|945b308a-a6f8-508e-3bab-c3e6bc8fba66" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519415145589 }, "e-68": { "id": "e-68", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-21", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-67" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c282269019b|945b308a-a6f8-508e-3bab-c3e6bc8fba66" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519415145590 }, "e-71": { "id": "e-71", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-22", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-72" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c282269019b|c347a922-1014-e8fc-4f98-231e392252c8" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519423114862 }, "e-73": { "id": "e-73", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-11", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-74" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c282269019b|e07d67c5-2d1b-c36e-8932-14b7af3ae417" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519423445407 }, "e-75": { "id": "e-75", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-11", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-76" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c282269019b|ca165bf6-1620-2d23-77be-0a42e2ede588" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519423445407 }, "e-77": { "id": "e-77", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-23", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-78" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c282269019b|fde5ea7c-3d8e-a8cc-548a-3d4cd95596fa" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519424128592 }, "e-79": { "id": "e-79", "eventTypeId": "PAGE_START", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-29", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-80" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "PAGE", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1519756678813 }, "e-81": { "id": "e-81", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-12", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-82" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|af75c768-c978-d60a-0459-9d5bf011bea5" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1520362670365 }, "e-82": { "id": "e-82", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-13", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-81" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|af75c768-c978-d60a-0459-9d5bf011bea5" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1520362670366 }, "e-83": { "id": "e-83", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-14", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-84" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|86a9b41f-b24e-d92b-758d-fe07c33c6ee3" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1520363412448 }, "e-84": { "id": "e-84", "eventTypeId": "MOUSE_SECOND_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-15", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-83" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|86a9b41f-b24e-d92b-758d-fe07c33c6ee3" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1520363412450 }, "e-87": { "id": "e-87", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-11", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-88" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|e9e4ca88-de85-1026-b012-8b824106c0ed" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521052622915 }, "e-89": { "id": "e-89", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-90" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|19319210-762f-8f6e-f672-829fa2999c1a" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061511249 }, "e-91": { "id": "e-91", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-31", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-92" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|77b1e94f-5483-b4ea-4978-09ef75a30f7e" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061626552 }, "e-93": { "id": "e-93", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-94" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|fc7f48ae-2974-8233-0077-8675b12b1632" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061826709 }, "e-95": { "id": "e-95", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-96" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|6c57e643-6750-a6fe-d15f-160e52229cd7" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061835596 }, "e-97": { "id": "e-97", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-98" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|f15a45e7-8cc3-c06c-8038-3a413653e5e3" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061839646 }, "e-99": { "id": "e-99", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-100" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|bb513d0b-ee09-7005-0ee9-06d1778dad19" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061844102 }, "e-101": { "id": "e-101", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-102" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|6647a7db-6591-a387-e0a2-ef831e3a7f4f" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061848140 }, "e-103": { "id": "e-103", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-30", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-104" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322c0f436903b1|04ce4fc9-b914-fad4-1411-9f9f78197a91" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521061851931 }, "e-105": { "id": "e-105", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-32", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-106" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cca1c6903b6|e9e4ca88-de85-1026-b012-8b824106c0ed" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521657848777 }, "e-109": { "id": "e-109", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-34", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-110" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cca1c6903b6|77b1e94f-5483-b4ea-4978-09ef75a30f7e" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1521657848777 }, "e-111": { "id": "e-111", "eventTypeId": "SCROLL_INTO_VIEW", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-36", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-112" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|e6d5bc0d-749a-5e59-a881-556b38fe945f" }, "config": { "loop": true, "scrollOffsetValue": 0, "scrollOffsetUnit": "%", "delay": null, "direction": null, "effectIn": null }, "createdOn": 1524676095873 }, "e-113": { "id": "e-113", "eventTypeId": "MOUSE_CLICK", "action": { "id": "", "actionTypeId": "GENERAL_START_ACTION", "config": { "delay": 0, "easing": "", "duration": 0, "actionListId": "a-37", "affectedElements": {}, "playInReverse": false, "autoStopEventId": "e-114" } }, "mediaQueries": ["main", "medium", "small", "tiny"], "target": { "appliesTo": "ELEMENT", "styleBlockIds": [], "id": "5ab2e96d11322cf8ee690248|175a14ee-baa4-4578-d40d-608d55b00291" }, "config": { "loop": false, "scrollOffsetValue": null, "scrollOffsetUnit": null, "delay": null, "direction": null, "effectIn": null }, "createdOn": 1524677563670 }, "e-115": { "id": "e-115", "eventTypeId": "PAGE_SCROLL", "action": { "id": "", "actionTypeId": "GENERAL_CONTINUOUS_ACTION", "config": { "actionListId": "a-40", "affectedElements": {}, "duration": 0 } }, "mediaQueries": ["main", "medium"], "target": { "appliesTo": "PAGE", "styleBlockIds": [], "id": null }, "config": [{ "continuousParameterGroupId": "a-40-p", "smoothing": 75, "startsEntering": true, "addStartOffset": false, "addOffsetValue": 50, "startsExiting": false, "addEndOffset": false, "endOffsetValue": 50 }], "createdOn": 1526517241168 } }, "actionLists": { "a": { "id": "a", "title": "Open Panel", "actionItemGroups": [{ "actionItems": [{ "id": "a-n-10", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080" }, "heightValue": 450, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-n-2", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481" }, "zValue": 90, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }, { "id": "a-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c2bde690334|5917b1dd-527d-c29f-1dd4-bb837b25bf2d" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-n-4", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c2bde690334|e54d0e34-dc20-77f4-94ee-abf589cd8f81" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-n-5", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c2bde690334|733b527b-c48c-2caf-790c-a330d4346b6f" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-n-6", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c2bde690334|db7616c2-3b92-983c-c38c-2ba1d0e12f80" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }, { "id": "a-n-7", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c2bde690334|c68a45f7-0bce-323d-c797-c1eaeaf79c4c" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }, { "id": "a-n-8", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c2bde690334|e8d66065-874d-f41e-c75a-a348aa29fdbb" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }], "createdOn": 1512171669300, "useFirstGroupAsInitialState": false }, "a-2": { "id": "a-2", "title": "Close Panel", "actionItemGroups": [{ "actionItems": [{ "id": "a-2-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c2bde690334|49e373cb-fe9f-2dfe-be39-54a39de7d080" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-2-n-2", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c2bde690334|cbe6a5f9-68cc-f64f-448c-3c8555c10481" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }], "createdOn": 1512171842832, "useFirstGroupAsInitialState": false }, "a-3": { "id": "a-3", "title": "Flag Open", "actionItemGroups": [{ "actionItems": [{ "id": "a-3-n-4", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 200, "target": { "id": "5ab2e96d11322c969b690181|19473c40-3f5f-c889-742c-68d8b1ee7bcc" }, "value": 1, "unit": "" } }] }], "createdOn": 1515452913846, "useFirstGroupAsInitialState": false }, "a-4": { "id": "a-4", "title": "Flag Close", "actionItemGroups": [{ "actionItems": [{ "id": "a-4-n-2", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 200, "target": { "id": "5ab2e96d11322c969b690181|19473c40-3f5f-c889-742c-68d8b1ee7bcc" }, "value": 0, "unit": "" } }] }], "createdOn": 1515453056687, "useFirstGroupAsInitialState": false }, "a-5": { "id": "a-5", "title": "Open Panel 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-5-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080" }, "heightValue": 348, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-5-n-2", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481" }, "zValue": 90, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }, { "id": "a-5-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c30a5690378|5917b1dd-527d-c29f-1dd4-bb837b25bf2d" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-5-n-4", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c30a5690378|e54d0e34-dc20-77f4-94ee-abf589cd8f81" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-5-n-5", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c30a5690378|733b527b-c48c-2caf-790c-a330d4346b6f" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-5-n-6", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c30a5690378|db7616c2-3b92-983c-c38c-2ba1d0e12f80" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }, { "id": "a-5-n-7", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c30a5690378|c68a45f7-0bce-323d-c797-c1eaeaf79c4c" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }, { "id": "a-5-n-8", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c30a5690378|e8d66065-874d-f41e-c75a-a348aa29fdbb" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }], "createdOn": 1512171669300, "useFirstGroupAsInitialState": false }, "a-6": { "id": "a-6", "title": "Close Panel 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-6-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c30a5690378|49e373cb-fe9f-2dfe-be39-54a39de7d080" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-6-n-2", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322c30a5690378|cbe6a5f9-68cc-f64f-448c-3c8555c10481" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }], "createdOn": 1512171842832, "useFirstGroupAsInitialState": false }, "a-7": { "id": "a-7", "title": "Load Checkmark", "actionItemGroups": [], "createdOn": 1517527859367, "useFirstGroupAsInitialState": false }, "a-8": { "id": "a-8", "title": "Open Share Dropdown", "actionItemGroups": [{ "actionItems": [{ "id": "a-8-n-4", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|8f6a7939-eef3-a9d1-ce82-0fad56ca451e" }, "heightValue": 100, "widthUnit": "PX", "heightUnit": "%" } }] }], "createdOn": 1518214973330, "useFirstGroupAsInitialState": false }, "a-12": { "id": "a-12", "title": "Open Book Now Dropdown", "actionItemGroups": [{ "actionItems": [{ "id": "a-12-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 500, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|1c33d2d5-2bc1-7061-c23f-9295818e22ac" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-12-n-2", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 200, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|1c33d2d5-2bc1-7061-c23f-9295818e22ac" }, "widthUnit": "PX", "heightUnit": "AUTO" } }] }], "createdOn": 1518214973330, "useFirstGroupAsInitialState": true }, "a-9": { "id": "a-9", "title": "Close Share Dropdown", "actionItemGroups": [{ "actionItems": [{ "id": "a-9-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|8f6a7939-eef3-a9d1-ce82-0fad56ca451e" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }], "createdOn": 1518214973330, "useFirstGroupAsInitialState": false }, "a-13": { "id": "a-13", "title": "Close Book Now Dropdown", "actionItemGroups": [{ "actionItems": [{ "id": "a-13-n-2", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 200, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|1c33d2d5-2bc1-7061-c23f-9295818e22ac" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }], "createdOn": 1518214973330, "useFirstGroupAsInitialState": false }, "a-10": { "id": "a-10", "title": "Open Share Mobile", "actionItemGroups": [{ "actionItems": [{ "id": "a-10-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322cf8ee690248|a7072b09-cba9-34e9-2462-5fa655c28189" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-22": { "id": "a-22", "title": "Open Appt. Mobile", "actionItemGroups": [{ "actionItems": [{ "id": "a-22-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322c282269019b|e07d67c5-2d1b-c36e-8932-14b7af3ae417" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-23": { "id": "a-23", "title": "Close Appt. Mobile", "actionItemGroups": [{ "actionItems": [{ "id": "a-23-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c282269019b|e07d67c5-2d1b-c36e-8932-14b7af3ae417" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-11": { "id": "a-11", "title": "Close Share Mobile", "actionItemGroups": [{ "actionItems": [{ "id": "a-11-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cf8ee690248|a7072b09-cba9-34e9-2462-5fa655c28189" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-14": { "id": "a-14", "title": "Book Mobile Open", "actionItemGroups": [{ "actionItems": [{ "id": "a-14-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 500, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|db413621-1035-c1a8-e0b2-e084edda5234" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-14-n-5", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 0, "target": { "id": "5ab2e96d11322cf8ee690248|f237b1e9-73f9-ecb0-1af0-655a10b310ae" }, "value": 0, "unit": "" } }, { "id": "a-14-n-4", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322cf8ee690248|f237b1e9-73f9-ecb0-1af0-655a10b310ae" } } }] }, { "actionItems": [{ "id": "a-14-n-6", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322cf8ee690248|f237b1e9-73f9-ecb0-1af0-655a10b310ae" }, "value": 1, "unit": "" } }, { "id": "a-14-n-2", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 200, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|db413621-1035-c1a8-e0b2-e084edda5234" }, "widthUnit": "PX", "heightUnit": "AUTO" } }] }], "createdOn": 1518573595528, "useFirstGroupAsInitialState": true }, "a-15": { "id": "a-15", "title": "Book Mobile Open 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-15-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 200, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|db413621-1035-c1a8-e0b2-e084edda5234" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-15-n-2", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 300, "target": { "id": "5ab2e96d11322cf8ee690248|f237b1e9-73f9-ecb0-1af0-655a10b310ae" }, "value": 0, "unit": "" } }] }, { "actionItems": [{ "id": "a-15-n-3", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cf8ee690248|f237b1e9-73f9-ecb0-1af0-655a10b310ae" } } }] }], "createdOn": 1518573595528, "useFirstGroupAsInitialState": false }, "a-16": { "id": "a-16", "title": "Flag Open 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-16-n", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 200, "target": { "id": "5ab2e96d11322c7b8c690213|19473c40-3f5f-c889-742c-68d8b1ee7bcc" }, "value": 1, "unit": "" } }] }], "createdOn": 1515452913846, "useFirstGroupAsInitialState": false }, "a-17": { "id": "a-17", "title": "Flag Close 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-17-n", "actionTypeId": "STYLE_OPACITY", "config": { "delay": 0, "easing": "", "duration": 200, "target": { "id": "5ab2e96d11322c7b8c690213|19473c40-3f5f-c889-742c-68d8b1ee7bcc" }, "value": 0, "unit": "" } }] }], "createdOn": 1515453056687, "useFirstGroupAsInitialState": false }, "a-18": { "id": "a-18", "title": "Search Dropdown", "actionItemGroups": [{ "actionItems": [{ "id": "a-18-n-3", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322c7b8c690213|dff28fa7-5486-c909-4cde-3f421adfb36d" } } }] }, { "actionItems": [{ "id": "a-18-n-2", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c7b8c690213|dff28fa7-5486-c909-4cde-3f421adfb36d" }, "heightValue": 280, "widthUnit": "PX", "heightUnit": "PX" } }] }], "createdOn": 1519256450894, "useFirstGroupAsInitialState": false }, "a-19": { "id": "a-19", "title": "Search Dropdown Close", "actionItemGroups": [{ "actionItems": [{ "id": "a-19-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c7b8c690213|dff28fa7-5486-c909-4cde-3f421adfb36d" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-19-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c7b8c690213|dff28fa7-5486-c909-4cde-3f421adfb36d" } } }] }], "createdOn": 1519256450894, "useFirstGroupAsInitialState": false }, "a-20": { "id": "a-20", "title": "Appt Dropdown Open", "actionItemGroups": [{ "actionItems": [{ "id": "a-20-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "block", "target": { "id": "5ab2e96d11322c282269019b|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" } } }] }, { "actionItems": [{ "id": "a-20-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c282269019b|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" }, "heightValue": 164, "widthUnit": "PX", "heightUnit": "PX" } }] }], "createdOn": 1519415153836, "useFirstGroupAsInitialState": false }, "a-21": { "id": "a-21", "title": "Appt Dropdown Close", "actionItemGroups": [{ "actionItems": [{ "id": "a-21-n-2", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c282269019b|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-21-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c282269019b|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" } } }] }], "createdOn": 1519415153836, "useFirstGroupAsInitialState": false }, "a-24": { "id": "a-24", "title": "Appt Dropdown Open 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-24-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "block", "target": { "id": "5ab2e96d11322c4d356903b4|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" } } }] }, { "actionItems": [{ "id": "a-24-n-2", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c4d356903b4|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" }, "heightValue": 164, "widthUnit": "PX", "heightUnit": "PX" } }] }], "createdOn": 1519415153836, "useFirstGroupAsInitialState": false }, "a-25": { "id": "a-25", "title": "Appt Dropdown Close 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-25-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 300, "locked": false, "target": { "id": "5ab2e96d11322c4d356903b4|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" }, "heightValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-25-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c4d356903b4|f6d27bcf-a7ba-1a06-f3e5-3ed248fdd542" } } }] }], "createdOn": 1519415153836, "useFirstGroupAsInitialState": false }, "a-26": { "id": "a-26", "title": "Open Appt. Mobile 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-26-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322c4d356903b4|e07d67c5-2d1b-c36e-8932-14b7af3ae417" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-27": { "id": "a-27", "title": "Close Share Mobile 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-27-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c4d356903b4|a7072b09-cba9-34e9-2462-5fa655c28189" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-28": { "id": "a-28", "title": "Close Appt. Mobile 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-28-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c4d356903b4|e07d67c5-2d1b-c36e-8932-14b7af3ae417" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-29": { "id": "a-29", "title": "Page Load", "actionItemGroups": [{ "actionItems": [{ "id": "a-29-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "outQuad", "duration": 3000, "locked": false, "target": { "id": "5ab2e96d11322cf8ee690248|8c4d1814-0acd-2cf2-4d62-7e64f6af03c2" }, "widthValue": 100, "widthUnit": "%", "heightUnit": "PX" } }] }, { "actionItems": [{ "id": "a-29-n-3", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 500, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cf8ee690248|19f191df-57c0-6a90-f92c-660b0df9c831" } } }] }], "createdOn": 1519756682559, "useFirstGroupAsInitialState": false }, "a-30": { "id": "a-30", "title": "Info Click", "actionItemGroups": [{ "actionItems": [{ "id": "a-30-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322c0f436903b1|77b1e94f-5483-b4ea-4978-09ef75a30f7e" } } }] }], "createdOn": 1521061540298, "useFirstGroupAsInitialState": false }, "a-31": { "id": "a-31", "title": "Close Info Popup", "actionItemGroups": [{ "actionItems": [{ "id": "a-31-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322c0f436903b1|77b1e94f-5483-b4ea-4978-09ef75a30f7e" } } }] }], "createdOn": 1521061540298, "useFirstGroupAsInitialState": false }, "a-32": { "id": "a-32", "title": "Close Share Mobile 3", "actionItemGroups": [{ "actionItems": [{ "id": "a-32-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cca1c6903b6|a7072b09-cba9-34e9-2462-5fa655c28189" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-33": { "id": "a-33", "title": "Info Click 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-33-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322cca1c6903b6|77b1e94f-5483-b4ea-4978-09ef75a30f7e" } } }] }], "createdOn": 1521061540298, "useFirstGroupAsInitialState": false }, "a-34": { "id": "a-34", "title": "Close Info Popup 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-34-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cca1c6903b6|77b1e94f-5483-b4ea-4978-09ef75a30f7e" } } }] }], "createdOn": 1521061540298, "useFirstGroupAsInitialState": false }, "a-35": { "id": "a-35", "title": "Spinner", "actionItemGroups": [{ "actionItems": [{ "id": "a-35-n", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 2000, "target": { "id": "5ab2e96d11322cf8ee690248|e6d5bc0d-749a-5e59-a881-556b38fe945f" }, "zValue": 359, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }, { "actionItems": [{ "id": "a-35-n-2", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 0, "target": { "id": "5ab2e96d11322cf8ee690248|e6d5bc0d-749a-5e59-a881-556b38fe945f" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }], "createdOn": 1524676117338, "useFirstGroupAsInitialState": false }, "a-36": { "id": "a-36", "title": "Spinner Load Reviews", "actionItemGroups": [{ "actionItems": [{ "id": "a-36-n", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 2000, "target": { "id": "5ab2e96d11322cf8ee690248|e6d5bc0d-749a-5e59-a881-556b38fe945f" }, "zValue": 359, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }, { "actionItems": [{ "id": "a-36-n-2", "actionTypeId": "TRANSFORM_ROTATE", "config": { "delay": 0, "easing": "", "duration": 0, "target": { "id": "5ab2e96d11322cf8ee690248|e6d5bc0d-749a-5e59-a881-556b38fe945f" }, "zValue": 0, "xUnit": "DEG", "yUnit": "DEG", "zUnit": "DEG" } }] }, { "actionItems": [{ "id": "a-36-n-3", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cf8ee690248|e6d5bc0d-749a-5e59-a881-556b38fe945f" } } }] }, { "actionItems": [{ "id": "a-36-n-4", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "block", "target": { "id": "5ab2e96d11322cf8ee690248|8f52f12d-3885-a6fc-d245-b60eaaaf1ae5" } } }] }, { "actionItems": [{ "id": "a-36-n-5", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "flex", "target": { "id": "5ab2e96d11322cf8ee690248|175a14ee-baa4-4578-d40d-608d55b00291" } } }] }], "createdOn": 1524676117338, "useFirstGroupAsInitialState": false }, "a-37": { "id": "a-37", "title": "Show More Reviews", "actionItemGroups": [{ "actionItems": [{ "id": "a-37-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5ab2e96d11322cf8ee690248|175a14ee-baa4-4578-d40d-608d55b00291" } } }] }, { "actionItems": [{ "id": "a-37-n-2", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "block", "target": { "id": "5ab2e96d11322cf8ee690248|ec5c1c4c-50cb-5f33-160c-7902fe885e93" } } }] }], "createdOn": 1524677568991, "useFirstGroupAsInitialState": false }, "a-38": { "id": "a-38", "title": "Form Progress", "actionItemGroups": [{ "actionItems": [{ "id": "a-38-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 500, "locked": false, "target": { "id": "08bb4a0b-21ff-6c77-4673-b97d9f7816d7" }, "widthValue": 0, "widthUnit": "PX", "heightUnit": "PX" } }] }], "createdOn": 1526517087693, "useFirstGroupAsInitialState": true }, "a-39": { "id": "a-39", "title": "Form Progress 2", "actionItemGroups": [{ "actionItems": [{ "id": "a-39-n", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 500, "locked": false, "target": { "id": "08bb4a0b-21ff-6c77-4673-b97d9f7816d7" }, "widthValue": 100, "widthUnit": "%", "heightUnit": "PX" } }] }], "createdOn": 1526517087693, "useFirstGroupAsInitialState": false }, "a-40": { "id": "a-40", "title": "Form Progress Scroll", "continuousParameterGroups": [{ "id": "a-40-p", "type": "SCROLL_PROGRESS", "parameterLabel": "Scroll", "continuousActionGroups": [{ "keyframe": 0, "actionItems": [{ "id": "a-40-n-3", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "ease", "duration": 500, "locked": false, "target": { "id": "08bb4a0b-21ff-6c77-4673-b97d9f7816d7" }, "widthValue": 0, "widthUnit": "%", "heightUnit": "PX" } }, { "id": "a-40-n-5", "actionTypeId": "TRANSFORM_SCALE", "config": { "delay": 0, "easing": "", "duration": 500, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefacb" }, "xValue": 1, "yValue": 1, "locked": true } }, { "id": "a-40-n-9", "actionTypeId": "TRANSFORM_MOVE", "config": { "delay": 0, "easing": "", "duration": 500, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefacb" }, "xValue": 0, "yValue": 0, "xUnit": "PX", "yUnit": "PX", "zUnit": "PX" } }, { "id": "a-40-n-10", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 500, "locked": false, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefaca" }, "heightValue": 160, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-40-n-12", "actionTypeId": "TRANSFORM_MOVE", "config": { "delay": 0, "easing": "", "duration": 500, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefaf9" }, "xValue": 0, "xUnit": "PX", "yUnit": "PX", "zUnit": "PX" } }] }, { "keyframe": 10, "actionItems": [{ "id": "a-40-n-6", "actionTypeId": "TRANSFORM_SCALE", "config": { "delay": 0, "easing": "", "duration": 500, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefacb" }, "xValue": 0.5, "yValue": 0.5, "locked": true } }, { "id": "a-40-n-7", "actionTypeId": "TRANSFORM_MOVE", "config": { "delay": 0, "easing": "", "duration": 500, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefacb" }, "xValue": -50, "yValue": -30, "xUnit": "PX", "yUnit": "PX", "zUnit": "PX" } }, { "id": "a-40-n-8", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "", "duration": 500, "locked": false, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefaca" }, "heightValue": 94, "widthUnit": "PX", "heightUnit": "PX" } }, { "id": "a-40-n-11", "actionTypeId": "TRANSFORM_MOVE", "config": { "delay": 0, "easing": "", "duration": 500, "target": { "id": "7b699583-5e24-b759-b87b-ee755beefaf9" }, "xValue": -100, "xUnit": "PX", "yUnit": "PX", "zUnit": "PX" } }] }, { "keyframe": 100, "actionItems": [{ "id": "a-40-n-4", "actionTypeId": "STYLE_SIZE", "config": { "delay": 0, "easing": "ease", "duration": 500, "locked": false, "target": { "id": "08bb4a0b-21ff-6c77-4673-b97d9f7816d7" }, "widthValue": 100, "widthUnit": "%", "heightUnit": "PX" } }] }] }], "createdOn": 1526517251618 }, "a-41": { "id": "a-41", "title": "Close Share Mobile 4", "actionItemGroups": [{ "actionItems": [{ "id": "a-41-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5b033d4fd315e718179c41cb|a7072b09-cba9-34e9-2462-5fa655c28189" } } }] }], "createdOn": 1518220266913, "useFirstGroupAsInitialState": false }, "a-42": { "id": "a-42", "title": "Close Info Popup 3", "actionItemGroups": [{ "actionItems": [{ "id": "a-42-n", "actionTypeId": "GENERAL_DISPLAY", "config": { "delay": 0, "easing": "", "duration": 0, "value": "none", "target": { "id": "5b033d4fd315e718179c41cb|77b1e94f-5483-b4ea-4978-09ef75a30f7e" } } }] }], "createdOn": 1521061540298, "useFirstGroupAsInitialState": false } }, "site": { "mediaQueries": [{ "key": "main", "min": 992, "max": 10000 }, { "key": "medium", "min": 768, "max": 991 }, { "key": "small", "min": 480, "max": 767 }, { "key": "tiny", "min": 0, "max": 479 }] } }
);
;
/*!
 * Lazy Load - jQuery plugin for lazy loading images
 *
 * Copyright (c) 2007-2015 Mika Tuupola
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * Project home:
 *   http://www.appelsiini.net/projects/lazyload
 *
 * Version:  1.9.5
 *
 */

(function ($, window, document, undefined) {
    var $window = $(window);

    $.fn.lazyload = function (options) {
        var elements = this;
        var $container;
        var settings = {
            threshold: 0,
            failure_limit: 0,
            event: "scroll",
            effect: "show",
            container: window,
            data_attribute: "original",
            data_error: null,
            skip_invisible: false,
            appear: null,
            load: null,
            placeholder: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXYzh8+PB/AAffA0nNPuCLAAAAAElFTkSuQmCC",
            imgLoadClass: null,
            isShowIntials: false,
            intial_selecter: null,
        };

        function update() {
            var counter = 0;

            elements.each(function () {
                var $this = $(this);
                if (settings.skip_invisible && !$this.is(":visible")) {
                    return;
                }
                if ($.abovethetop(this, settings) ||
                    $.leftofbegin(this, settings)) {
                    /* Nothing. */
                } else if (!$.belowthefold(this, settings) &&
                    !$.rightoffold(this, settings)) {
                    $this.trigger("appear");
                    /* if we found an image we'll load, reset the counter */
                    counter = 0;
                } else {
                    if (++counter > settings.failure_limit) {
                        return false;
                    }
                }
            });

        }

        if (options) {
            /* Maintain BC for a couple of versions. */
            if (undefined !== options.failurelimit) {
                options.failure_limit = options.failurelimit;
                delete options.failurelimit;
            }
            if (undefined !== options.effectspeed) {
                options.effect_speed = options.effectspeed;
                delete options.effectspeed;
            }

            $.extend(settings, options);
        }

        /* Cache container as jQuery as object. */
        $container = (settings.container === undefined ||
                      settings.container === window) ? $window : $(settings.container);

        /* Fire one scroll event per scroll. Not one scroll event per image. */
        if (0 === settings.event.indexOf("scroll")) {
            $container.bind(settings.event, function () {
                return update();
            });
        }

        this.each(function () {
            var self = this;
            var $self = $(self);

            self.loaded = false;

            /* If no src attribute given use data:uri. */
            if ($self.attr("src") === undefined || $self.attr("src") === false) {
                if ($self.is("img")) {
                    $self.attr("src", settings.placeholder);
                }
            }

            /* When appear is triggered load original image. */
            $self.one("appear", function () {
                if (!this.loaded) {
                    if (settings.appear) {
                        var elements_left = elements.length;
                        settings.appear.call(self, elements_left, settings);
                    }
                    $("<img />")
                        .bind("load", function () {

                            var original = $self.attr("data-" + settings.data_attribute);
                            $self.hide();
                            /* add class to loaded image */
                            try {
                                var laodCls = settings.imgLoadClass;
                                if (laodCls != null && laodCls != undefined) {
                                    $self.addClass(laodCls);
                                }
                            } catch (e) {
                            }

                            if ($self.is("img")) {
                                $self.attr("src", original);
                            } else {

                                if (settings.isShowIntials == true) {
                                    $self.find(settings.intial_selecter).hide();
                                    if (original.indexOf("/user-male-img_155_new.png") > 0 || original.indexOf("/user-female-img_155.jpg") > 0) {
                                        //$self.attr("data-original", "");
                                        original = "";
                                        $self.find(settings.intial_selecter).show();
                                    }
                                }
                                //$self.css("background-image", "url('" + original + "')");
                                if (original != undefined && original != "" && original != '' && original != null) {
                                    $self.css("background-image", "url('" + original + "')");
                                }
                                else {
                                    $self.css("background-image", "none");
                                }
                            }
                            $self[settings.effect](settings.effect_speed);

                            self.loaded = true;

                            /* Remove image from array so it is not looped next time. */
                            var temp = $.grep(elements, function (element) {
                                return !element.loaded;
                            });
                            elements = $(temp);

                            if (settings.load) {
                                var elements_left = elements.length;
                                settings.load.call(self, elements_left, settings);
                            }
                        })
                         .bind("error", function () {

                             var imgerror = settings.data_error;
                             if (imgerror != null || settings.isShowIntials == true) {
                                 $self.hide();
                                 /* add class to loaded image */
                                 try {
                                     var laodCls = settings.imgLoadClass;
                                     if (laodCls != null && laodCls != undefined) {
                                         $self.addClass(laodCls);
                                     }
                                 } catch (e) {
                                 }

                                 if ($self.is("img")) {
                                     $self.attr("src", imgerror);
                                 } else {
                                     if (settings.isShowIntials == true) {
                                         $self.find(settings.intial_selecter).show();
                                         //$self.css("background-image", "url()");
                                         $self.css("background-image", 'none');
                                     }
                                     else {
                                         //$self.css("background-image", "url('" + imgerror + "')");
                                         if (imgerror != undefined && imgerror != "" && imgerror != '' && imgerror != null) {
                                             $self.css("background-image", "url('" + imgerror + "')");
                                         }
                                         else {
                                             $self.css("background-image", "none");
                                         }
                                     }

                                 }
                                 $self[settings.effect](settings.effect_speed);

                                 self.loaded = true;

                                 /* Remove image from array so it is not looped next time. */
                                 var temp = $.grep(elements, function (element) {
                                     return !element.loaded;
                                 });
                                 elements = $(temp);

                                 if (settings.load) {
                                     var elements_left = elements.length;
                                     settings.load.call(self, elements_left, settings);
                                 }
                             }
                         })
                        .attr("src", $self.attr("data-" + settings.data_attribute));
                }
            });

            /* When wanted event is triggered load original image */
            /* by triggering appear.                              */
            if (0 !== settings.event.indexOf("scroll")) {
                $self.bind(settings.event, function () {
                    if (!self.loaded) {
                        $self.trigger("appear");
                    }
                });
            }
        });

        /* Check if something appears when window is resized. */
        $window.bind("resize", function () {
            update();
        });

        /* With IOS5 force loading images when navigating with back button. */
        /* Non optimal workaround. */
        if ((/(?:iphone|ipod|ipad).*os 5/gi).test(navigator.appVersion)) {
            $window.bind("pageshow", function (event) {
                if (event.originalEvent && event.originalEvent.persisted) {
                    elements.each(function () {
                        $(this).trigger("appear");
                    });
                }
            });
        }

        /* Force initial check if images should appear. */
        $(document).ready(function () {
            update();
        });

        return this;
    };

    /* Convenience methods in jQuery namespace.           */
    /* Use as  $.belowthefold(element, {threshold : 100, container : window}) */

    $.belowthefold = function (element, settings) {
        var fold;

        if (settings.container === undefined || settings.container === window) {
            fold = (window.innerHeight ? window.innerHeight : $window.height()) + $window.scrollTop();
        } else {
            fold = $(settings.container).offset().top + $(settings.container).height();
        }

        return fold <= $(element).offset().top - settings.threshold;
    };

    $.rightoffold = function (element, settings) {
        var fold;

        if (settings.container === undefined || settings.container === window) {
            fold = $window.width() + $window.scrollLeft();
        } else {
            fold = $(settings.container).offset().left + $(settings.container).width();
        }

        return fold <= $(element).offset().left - settings.threshold;
    };

    $.abovethetop = function (element, settings) {
        var fold;

        if (settings.container === undefined || settings.container === window) {
            fold = $window.scrollTop();
        } else {
            fold = $(settings.container).offset().top;
        }

        return fold >= $(element).offset().top + settings.threshold + $(element).height();
    };

    $.leftofbegin = function (element, settings) {
        var fold;

        if (settings.container === undefined || settings.container === window) {
            fold = $window.scrollLeft();
        } else {
            fold = $(settings.container).offset().left;
        }

        return fold >= $(element).offset().left + settings.threshold + $(element).width();
    };

    $.inviewport = function (element, settings) {
        return !$.rightoffold(element, settings) && !$.leftofbegin(element, settings) &&
               !$.belowthefold(element, settings) && !$.abovethetop(element, settings);
    };

    /* Custom selectors for your convenience.   */
    /* Use as $("img:below-the-fold").something() or */
    /* $("img").filter(":below-the-fold").something() which is faster */

    $.extend($.expr[":"], {
        "below-the-fold": function (a) { return $.belowthefold(a, { threshold: 0 }); },
        "above-the-top": function (a) { return !$.belowthefold(a, { threshold: 0 }); },
        "right-of-screen": function (a) { return $.rightoffold(a, { threshold: 0 }); },
        "left-of-screen": function (a) { return !$.rightoffold(a, { threshold: 0 }); },
        "in-viewport": function (a) { return $.inviewport(a, { threshold: 0 }); },
        /* Maintain BC for couple of versions. */
        "above-the-fold": function (a) { return !$.belowthefold(a, { threshold: 0 }); },
        "right-of-fold": function (a) { return $.rightoffold(a, { threshold: 0 }); },
        "left-of-fold": function (a) { return !$.rightoffold(a, { threshold: 0 }); }
    });

})(jQuery, window, document);
;
/*!
 * jQuery & Zepto Lazy - v1.7.10
 * http://jquery.eisbehr.de/lazy/
 *
 * Copyright 2012 - 2018, Daniel 'Eisbehr' Kern
 *
 * Dual licensed under the MIT and GPL-2.0 licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl-2.0.html
 *
 * $("img.lazy").lazy();
 */

;(function(window, undefined) {
    "use strict";

    // noinspection JSUnresolvedVariable
    /**
     * library instance - here and not in construct to be shorter in minimization
     * @return void
     */
    var $ = window.jQuery || window.Zepto,

    /**
     * unique plugin instance id counter
     * @type {number}
     */
    lazyInstanceId = 0,

    /**
     * helper to register window load for jQuery 3
     * @type {boolean}
     */    
    windowLoaded = false;

    /**
     * make lazy available to jquery - and make it a bit more case-insensitive :)
     * @access public
     * @type {function}
     * @param {object} settings
     * @return {LazyPlugin}
     */
    $.fn.Lazy = $.fn.lazy = function(settings) {
        return new LazyPlugin(this, settings);
    };

    /**
     * helper to add plugins to lazy prototype configuration
     * @access public
     * @type {function}
     * @param {string|Array} names
     * @param {string|Array|function} [elements]
     * @param {function} loader
     * @return void
     */
    $.Lazy = $.lazy = function(names, elements, loader) {
        // make second parameter optional
        if ($.isFunction(elements)) {
            loader = elements;
            elements = [];
        }

        // exit here if parameter is not a callable function
        if (!$.isFunction(loader)) {
            return;
        }

        // make parameters an array of names to be sure
        names = $.isArray(names) ? names : [names];
        elements = $.isArray(elements) ? elements : [elements];

        var config = LazyPlugin.prototype.config,
            forced = config._f || (config._f = {});

        // add the loader plugin for every name
        for (var i = 0, l = names.length; i < l; i++) {
            if (config[names[i]] === undefined || $.isFunction(config[names[i]])) {
                config[names[i]] = loader;
            }
        }

        // add forced elements loader
        for (var c = 0, a = elements.length; c < a; c++) {
            forced[elements[c]] = names[0];
        }
    };

    /**
     * contains all logic and the whole element handling
     * is packed in a private function outside class to reduce memory usage, because it will not be created on every plugin instance
     * @access private
     * @type {function}
     * @param {LazyPlugin} instance
     * @param {object} config
     * @param {object|Array} items
     * @param {object} events
     * @param {string} namespace
     * @return void
     */
    function _executeLazy(instance, config, items, events, namespace) {
        /**
         * a helper to trigger the 'onFinishedAll' callback after all other events
         * @access private
         * @type {number}
         */
        var _awaitingAfterLoad = 0,

        /**
         * visible content width
         * @access private
         * @type {number}
         */
        _actualWidth = -1,

        /**
         * visible content height
         * @access private
         * @type {number}
         */
        _actualHeight = -1,

        /**
         * determine possibly detected high pixel density
         * @access private
         * @type {boolean}
         */
        _isRetinaDisplay = false, 

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _afterLoad = 'afterLoad',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _load = 'load',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _error = 'error',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _img = 'img',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _src = 'src',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _srcset = 'srcset',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _sizes = 'sizes',

        /**
         * dictionary entry for better minimization
         * @access private
         * @type {string}
         */
        _backgroundImage = 'background-image';

        /**
         * initialize plugin
         * bind loading to events or set delay time to load all items at once
         * @access private
         * @return void
         */
        function _initialize() {
            // detect actual device pixel ratio
            // noinspection JSUnresolvedVariable
            _isRetinaDisplay = window.devicePixelRatio > 1;

            // prepare all initial items
            items = _prepareItems(items);

            // if delay time is set load all items at once after delay time
            if (config.delay >= 0) {
                setTimeout(function() {
                    _lazyLoadItems(true);
                }, config.delay);
            }

            // if no delay is set or combine usage is active bind events
            if (config.delay < 0 || config.combined) {
                // create unique event function
                events.e = _throttle(config.throttle, function(event) {
                    // reset detected window size on resize event
                    if (event.type === 'resize') {
                        _actualWidth = _actualHeight = -1;
                    }

                    // execute 'lazy magic'
                    _lazyLoadItems(event.all);
                });

                // create function to add new items to instance
                events.a = function(additionalItems) {
                    additionalItems = _prepareItems(additionalItems);
                    items.push.apply(items, additionalItems);
                };

                // create function to get all instance items left
                events.g = function() {
                    // filter loaded items before return in case internal filter was not running until now
                    return (items = $(items).filter(function() {
                        return !$(this).data(config.loadedName);
                    }));
                };

                // create function to force loading elements
                events.f = function(forcedItems) {
                    for (var i = 0; i < forcedItems.length; i++) {
                        // only handle item if available in current instance
                        // use a compare function, because Zepto can't handle object parameter for filter
                        // var item = items.filter(forcedItems[i]);
                        /* jshint loopfunc: true */
                        var item = items.filter(function() {
                            return this === forcedItems[i];
                        });

                        if (item.length) {
                            _lazyLoadItems(false, item);   
                        }
                    }
                };

                // load initial items
                _lazyLoadItems();

                // bind lazy load functions to scroll and resize event
                // noinspection JSUnresolvedVariable
                $(config.appendScroll).on('scroll.' + namespace + ' resize.' + namespace, events.e);
            }
        }

        /**
         * prepare items before handle them
         * @access private
         * @param {Array|object|jQuery} items
         * @return {Array|object|jQuery}
         */
        function _prepareItems(items) {
            // fetch used configurations before loops
            var defaultImage = config.defaultImage,
                placeholder = config.placeholder,
                imageBase = config.imageBase,
                srcsetAttribute = config.srcsetAttribute,
                loaderAttribute = config.loaderAttribute,
                forcedTags = config._f || {};

            // filter items and only add those who not handled yet and got needed attributes available
            items = $(items).filter(function() {
                var element = $(this),
                    tag = _getElementTagName(this);

                return !element.data(config.handledName) && 
                       (element.attr(config.attribute) || element.attr(srcsetAttribute) || element.attr(loaderAttribute) || forcedTags[tag] !== undefined);
            })

            // append plugin instance to all elements
            .data('plugin_' + config.name, instance);

            for (var i = 0, l = items.length; i < l; i++) {
                var element = $(items[i]),
                    tag = _getElementTagName(items[i]),
                    elementImageBase = element.attr(config.imageBaseAttribute) || imageBase;

                // generate and update source set if an image base is set
                if (tag === _img && elementImageBase && element.attr(srcsetAttribute)) {
                    element.attr(srcsetAttribute, _getCorrectedSrcSet(element.attr(srcsetAttribute), elementImageBase));
                }

                // add loader to forced element types
                if (forcedTags[tag] !== undefined && !element.attr(loaderAttribute)) {
                    element.attr(loaderAttribute, forcedTags[tag]);
                }

                // set default image on every element without source
                if (tag === _img && defaultImage && !element.attr(_src)) {
                    element.attr(_src, defaultImage);
                }

                // set placeholder on every element without background image
                else if (tag !== _img && placeholder && (!element.css(_backgroundImage) || element.css(_backgroundImage) === 'none')) {
                    element.css(_backgroundImage, "url('" + placeholder + "')");
                }
            }

            return items;
        }

        /**
         * the 'lazy magic' - check all items
         * @access private
         * @param {boolean} [allItems]
         * @param {object} [forced]
         * @return void
         */
        function _lazyLoadItems(allItems, forced) {
            // skip if no items where left
            if (!items.length) {
                // destroy instance if option is enabled
                if (config.autoDestroy) {
                    // noinspection JSUnresolvedFunction
                    instance.destroy();
                }

                return;
            }

            var elements = forced || items,
                loadTriggered = false,
                imageBase = config.imageBase || '',
                srcsetAttribute = config.srcsetAttribute,
                handledName = config.handledName;

            // loop all available items
            for (var i = 0; i < elements.length; i++) {
                // item is at least in loadable area
                if (allItems || forced || _isInLoadableArea(elements[i])) {
                    var element = $(elements[i]),
                        tag = _getElementTagName(elements[i]),
                        attribute = element.attr(config.attribute),
                        elementImageBase = element.attr(config.imageBaseAttribute) || imageBase,
                        customLoader = element.attr(config.loaderAttribute);

                        // is not already handled 
                    if (!element.data(handledName) &&
                        // and is visible or visibility doesn't matter
                        (!config.visibleOnly || element.is(':visible')) && (
                        // and image source or source set attribute is available
                        (attribute || element.attr(srcsetAttribute)) && (
                            // and is image tag where attribute is not equal source or source set
                            (tag === _img && (elementImageBase + attribute !== element.attr(_src) || element.attr(srcsetAttribute) !== element.attr(_srcset))) ||
                            // or is non image tag where attribute is not equal background
                            (tag !== _img && elementImageBase + attribute !== element.css(_backgroundImage))
                        ) ||
                        // or custom loader is available
                        customLoader))
                    {
                        // mark element always as handled as this point to prevent double handling
                        loadTriggered = true;
                        element.data(handledName, true);

                        // load item
                        _handleItem(element, tag, elementImageBase, customLoader);
                    }
                }
            }

            // when something was loaded remove them from remaining items
            if (loadTriggered) {
                items = $(items).filter(function() {
                    return !$(this).data(handledName);
                });
            }
        }

        /**
         * load the given element the lazy way
         * @access private
         * @param {object} element
         * @param {string} tag
         * @param {string} imageBase
         * @param {function} [customLoader]
         * @return void
         */
        function _handleItem(element, tag, imageBase, customLoader) {
            // increment count of items waiting for after load
            ++_awaitingAfterLoad;

            // extended error callback for correct 'onFinishedAll' handling
            var errorCallback = function() {
                _triggerCallback('onError', element);
                _reduceAwaiting();

                // prevent further callback calls
                errorCallback = $.noop;
            };

            // trigger function before loading image
            _triggerCallback('beforeLoad', element);

            // fetch all double used data here for better code minimization
            var srcAttribute = config.attribute,
                srcsetAttribute = config.srcsetAttribute,
                sizesAttribute = config.sizesAttribute,
                retinaAttribute = config.retinaAttribute,
                removeAttribute = config.removeAttribute,
                loadedName = config.loadedName,
                elementRetina = element.attr(retinaAttribute);

            // handle custom loader
            if (customLoader) {
                // on load callback
                var loadCallback = function() {
                    // remove attribute from element
                    if (removeAttribute) {
                        element.removeAttr(config.loaderAttribute);
                    }

                    // mark element as loaded
                    element.data(loadedName, true);

                    // call after load event
                    _triggerCallback(_afterLoad, element);

                    // remove item from waiting queue and possibly trigger finished event
                    // it's needed to be asynchronous to run after filter was in _lazyLoadItems
                    setTimeout(_reduceAwaiting, 1);

                    // prevent further callback calls
                    loadCallback = $.noop;
                };

                // bind error event to trigger callback and reduce waiting amount
                element.off(_error).one(_error, errorCallback)

                // bind after load callback to element
                .one(_load, loadCallback);

                // trigger custom loader and handle response
                if (!_triggerCallback(customLoader, element, function(response) {
                    if(response) {
                        element.off(_load);
                        loadCallback();
                    }
                    else {
                        element.off(_error);
                        errorCallback();
                    }
                })) {
                    element.trigger(_error);
                }
            }

            // handle images
            else {
                // create image object
                var imageObj = $(new Image());

                // bind error event to trigger callback and reduce waiting amount
                imageObj.one(_error, errorCallback)

                // bind after load callback to image
                .one(_load, function() {
                    // remove element from view
                    element.hide();

                    // set image back to element
                    // do it as single 'attr' calls, to be sure 'src' is set after 'srcset'
                    if (tag === _img) {
                        element.attr(_sizes, imageObj.attr(_sizes))
                               .attr(_srcset, imageObj.attr(_srcset))
                               .attr(_src, imageObj.attr(_src));
                    }
                    else {
                        element.css(_backgroundImage, "url('" + imageObj.attr(_src) + "')");
                    }

                    // bring it back with some effect!
                    element[config.effect](config.effectTime);

                    // remove attribute from element
                    if (removeAttribute) {
                        element.removeAttr(srcAttribute + ' ' + srcsetAttribute + ' ' + retinaAttribute + ' ' + config.imageBaseAttribute);

                        // only remove 'sizes' attribute, if it was a custom one
                        if (sizesAttribute !== _sizes) {
                            element.removeAttr(sizesAttribute);
                        }
                    }

                    // mark element as loaded
                    element.data(loadedName, true);

                    // call after load event
                    _triggerCallback(_afterLoad, element);

                    // cleanup image object
                    imageObj.remove();

                    // remove item from waiting queue and possibly trigger finished event
                    _reduceAwaiting();
                });

                // set sources
                // do it as single 'attr' calls, to be sure 'src' is set after 'srcset'
                var imageSrc = (_isRetinaDisplay && elementRetina ? elementRetina : element.attr(srcAttribute)) || '';
                imageObj.attr(_sizes, element.attr(sizesAttribute))
                        .attr(_srcset, element.attr(srcsetAttribute))
                        .attr(_src, imageSrc ? imageBase + imageSrc : null);

                // call after load even on cached image
                imageObj.complete && imageObj.trigger(_load); // jshint ignore : line
            }
        }

        /**
         * check if the given element is inside the current viewport or threshold
         * @access private
         * @param {object} element
         * @return {boolean}
         */
        function _isInLoadableArea(element) {
            var elementBound = element.getBoundingClientRect(),
                direction    = config.scrollDirection,
                threshold    = config.threshold,
                vertical     = // check if element is in loadable area from top
                               ((_getActualHeight() + threshold) > elementBound.top) &&
                               // check if element is even in loadable are from bottom
                               (-threshold < elementBound.bottom),
                horizontal   = // check if element is in loadable area from left
                               ((_getActualWidth() + threshold) > elementBound.left) &&
                               // check if element is even in loadable area from right
                               (-threshold < elementBound.right);

            if (direction === 'vertical') {
                return vertical;
            }
            else if (direction === 'horizontal') {
                return horizontal;
            }

            return vertical && horizontal;
        }

        /**
         * receive the current viewed width of the browser
         * @access private
         * @return {number}
         */
        function _getActualWidth() {
            return _actualWidth >= 0 ? _actualWidth : (_actualWidth = $(window).width());
        }

        /**
         * receive the current viewed height of the browser
         * @access private
         * @return {number}
         */
        function _getActualHeight() {
            return _actualHeight >= 0 ? _actualHeight : (_actualHeight = $(window).height());
        }

        /**
         * get lowercase tag name of an element
         * @access private
         * @param {object} element
         * @returns {string}
         */
        function _getElementTagName(element) {
            return element.tagName.toLowerCase();
        }

        /**
         * prepend image base to all srcset entries
         * @access private
         * @param {string} srcset
         * @param {string} imageBase
         * @returns {string}
         */
        function _getCorrectedSrcSet(srcset, imageBase) {
            if (imageBase) {
                // trim, remove unnecessary spaces and split entries
                var entries = srcset.split(',');
                srcset = '';

                for (var i = 0, l = entries.length; i < l; i++) {
                    srcset += imageBase + entries[i].trim() + (i !== l - 1 ? ',' : '');
                }
            }

            return srcset;
        }

        /**
         * helper function to throttle down event triggering
         * @access private
         * @param {number} delay
         * @param {function} callback
         * @return {function}
         */
        function _throttle(delay, callback) {
            var timeout,
                lastExecute = 0;

            return function(event, ignoreThrottle) {
                var elapsed = +new Date() - lastExecute;

                function run() {
                    lastExecute = +new Date();
                    // noinspection JSUnresolvedFunction
                    callback.call(instance, event);
                }

                timeout && clearTimeout(timeout); // jshint ignore : line

                if (elapsed > delay || !config.enableThrottle || ignoreThrottle) {
                    run();
                }
                else {
                    timeout = setTimeout(run, delay - elapsed);
                }
            };
        }

        /**
         * reduce count of awaiting elements to 'afterLoad' event and fire 'onFinishedAll' if reached zero
         * @access private
         * @return void
         */
        function _reduceAwaiting() {
            --_awaitingAfterLoad;

            // if no items were left trigger finished event
            if (!items.length && !_awaitingAfterLoad) {
                _triggerCallback('onFinishedAll');
            }
        }

        /**
         * single implementation to handle callbacks, pass element and set 'this' to current instance
         * @access private
         * @param {string|function} callback
         * @param {object} [element]
         * @param {*} [args]
         * @return {boolean}
         */
        function _triggerCallback(callback, element, args) {
            if ((callback = config[callback])) {
                // jQuery's internal '$(arguments).slice(1)' are causing problems at least on old iPads
                // below is shorthand of 'Array.prototype.slice.call(arguments, 1)'
                callback.apply(instance, [].slice.call(arguments, 1));
                return true;
            }

            return false;
        }

        // if event driven or window is already loaded don't wait for page loading
        if (config.bind === 'event' || windowLoaded) {
            _initialize();
        }

        // otherwise load initial items and start lazy after page load
        else {
            // noinspection JSUnresolvedVariable
            $(window).on(_load + '.' + namespace, _initialize);
        }  
    }

    /**
     * lazy plugin class constructor
     * @constructor
     * @access private
     * @param {object} elements
     * @param {object} settings
     * @return {object|LazyPlugin}
     */
    function LazyPlugin(elements, settings) {
        /**
         * this lazy plugin instance
         * @access private
         * @type {object|LazyPlugin|LazyPlugin.prototype}
         */
        var _instance = this,

        /**
         * this lazy plugin instance configuration
         * @access private
         * @type {object}
         */
        _config = $.extend({}, _instance.config, settings),

        /**
         * instance generated event executed on container scroll or resize
         * packed in an object to be referenceable and short named because properties will not be minified
         * @access private
         * @type {object}
         */
        _events = {},

        /**
         * unique namespace for instance related events
         * @access private
         * @type {string}
         */
        _namespace = _config.name + '-' + (++lazyInstanceId);

        // noinspection JSUndefinedPropertyAssignment
        /**
         * wrapper to get or set an entry from plugin instance configuration
         * much smaller on minify as direct access
         * @access public
         * @type {function}
         * @param {string} entryName
         * @param {*} [value]
         * @return {LazyPlugin|*}
         */
        _instance.config = function(entryName, value) {
            if (value === undefined) {
                return _config[entryName];
            }

            _config[entryName] = value;
            return _instance;
        };

        // noinspection JSUndefinedPropertyAssignment
        /**
         * add additional items to current instance
         * @access public
         * @param {Array|object|string} items
         * @return {LazyPlugin}
         */
        _instance.addItems = function(items) {
            _events.a && _events.a($.type(items) === 'string' ? $(items) : items); // jshint ignore : line
            return _instance;
        };

        // noinspection JSUndefinedPropertyAssignment
        /**
         * get all left items of this instance
         * @access public
         * @returns {object}
         */
        _instance.getItems = function() {
            return _events.g ? _events.g() : {};
        };

        // noinspection JSUndefinedPropertyAssignment
        /**
         * force lazy to load all items in loadable area right now
         * by default without throttle
         * @access public
         * @type {function}
         * @param {boolean} [useThrottle]
         * @return {LazyPlugin}
         */
        _instance.update = function(useThrottle) {
            _events.e && _events.e({}, !useThrottle); // jshint ignore : line
            return _instance;
        };

        // noinspection JSUndefinedPropertyAssignment
        /**
         * force element(s) to load directly, ignoring the viewport
         * @access public
         * @param {Array|object|string} items
         * @return {LazyPlugin}
         */
        _instance.force = function(items) {
            _events.f && _events.f($.type(items) === 'string' ? $(items) : items); // jshint ignore : line
            return _instance;
        };

        // noinspection JSUndefinedPropertyAssignment
        /**
         * force lazy to load all available items right now
         * this call ignores throttling
         * @access public
         * @type {function}
         * @return {LazyPlugin}
         */
        _instance.loadAll = function() {
            _events.e && _events.e({all: true}, true); // jshint ignore : line
            return _instance;
        };

        // noinspection JSUndefinedPropertyAssignment
        /**
         * destroy this plugin instance
         * @access public
         * @type {function}
         * @return undefined
         */
        _instance.destroy = function() {
            // unbind instance generated events
            // noinspection JSUnresolvedFunction, JSUnresolvedVariable
            $(_config.appendScroll).off('.' + _namespace, _events.e);
            // noinspection JSUnresolvedVariable
            $(window).off('.' + _namespace);

            // clear events
            _events = {};

            return undefined;
        };

        // start using lazy and return all elements to be chainable or instance for further use
        // noinspection JSUnresolvedVariable
        _executeLazy(_instance, _config, elements, _events, _namespace);
        return _config.chainable ? elements : _instance;
    }

    /**
     * settings and configuration data
     * @access public
     * @type {object|*}
     */
    LazyPlugin.prototype.config = {
        // general
        name               : 'lazy',
        chainable          : true,
        autoDestroy        : true,
        bind               : 'load',
        threshold          : 500,
        visibleOnly        : false,
        appendScroll       : window,
        scrollDirection    : 'both',
        imageBase          : null,
        defaultImage       : 'data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==',
        placeholder        : null,
        delay              : -1,
        combined           : false,

        // attributes
        attribute          : 'data-src',
        srcsetAttribute    : 'data-srcset',
        sizesAttribute     : 'data-sizes',
        retinaAttribute    : 'data-retina',
        loaderAttribute    : 'data-loader',
        imageBaseAttribute : 'data-imagebase',
        removeAttribute    : true,
        handledName        : 'handled',
        loadedName         : 'loaded',

        // effect
        effect             : 'show',
        effectTime         : 0,

        // throttle
        enableThrottle     : true,
        throttle           : 250,

        // callbacks
        beforeLoad         : undefined,
        afterLoad          : undefined,
        onError            : undefined,
        onFinishedAll      : undefined
    };

    // register window load event globally to prevent not loading elements
    // since jQuery 3.X ready state is fully async and may be executed after 'load' 
    $(window).on('load', function() {
        windowLoaded = true;
    });
})(window);;
//! moment.js
//! version : 2.9.0
//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
//! license : MIT
//! momentjs.com
(function(n){function it(n,t,i){switch(arguments.length){case 2:return n!=null?n:t;case 3:return n!=null?n:t!=null?t:i;default:throw new Error("Implement me");}}function g(n,t){return dr.call(n,t)}function vt(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1}}function pi(n){t.suppressDeprecationWarnings===!1&&typeof console!="undefined"&&console.warn&&console.warn("Deprecation warning: "+n)}function o(n,t){var i=!0;return nt(function(){return i&&(pi(n),i=!1),t.apply(this,arguments)},t)}function bu(n,t){vi[n]||(pi(t),vi[n]=!0)}function wi(n,t){return function(i){return r(n.call(this,i),t)}}function ku(n,t){return function(i){return this.localeData().ordinal(n.call(this,i),t)}}function du(n,t){var r=(t.year()-n.year())*12+(t.month()-n.month()),i=n.clone().add(r,"months"),u,f;return t-i<0?(u=n.clone().add(r-1,"months"),f=(t-i)/(i-u)):(u=n.clone().add(r+1,"months"),f=(t-i)/(u-i)),-(r+f)}function gu(n,t,i){var r;return i==null?t:n.meridiemHour!=null?n.meridiemHour(t,i):n.isPM!=null?(r=n.isPM(i),r&&t<12&&(t+=12),r||t!==12||(t=0),t):t}function bi(){}function et(n,i){i!==!1&&er(n);ki(this,n);this._d=new Date(+n._d);at===!1&&(at=!0,t.updateOffset(this),at=!1)}function yt(n){var i=ir(n),r=i.year||0,u=i.quarter||0,f=i.month||0,e=i.week||0,o=i.day||0,s=i.hour||0,h=i.minute||0,c=i.second||0,l=i.millisecond||0;this._milliseconds=+l+c*1e3+h*6e4+s*36e5;this._days=+o+e*7;this._months=+f+u*3+r*12;this._data={};this._locale=t.localeData();this._bubble()}function nt(n,t){for(var i in t)g(t,i)&&(n[i]=t[i]);return g(t,"toString")&&(n.toString=t.toString),g(t,"valueOf")&&(n.valueOf=t.valueOf),n}function ki(n,t){var u,i,r;if(typeof t._isAMomentObject!="undefined"&&(n._isAMomentObject=t._isAMomentObject),typeof t._i!="undefined"&&(n._i=t._i),typeof t._f!="undefined"&&(n._f=t._f),typeof t._l!="undefined"&&(n._l=t._l),typeof t._strict!="undefined"&&(n._strict=t._strict),typeof t._tzm!="undefined"&&(n._tzm=t._tzm),typeof t._isUTC!="undefined"&&(n._isUTC=t._isUTC),typeof t._offset!="undefined"&&(n._offset=t._offset),typeof t._pf!="undefined"&&(n._pf=t._pf),typeof t._locale!="undefined"&&(n._locale=t._locale),ut.length>0)for(u in ut)i=ut[u],r=t[i],typeof r!="undefined"&&(n[i]=r);return n}function h(n){return n<0?Math.ceil(n):Math.floor(n)}function r(n,t,i){for(var r=""+Math.abs(n),u=n>=0;r.length<t;)r="0"+r;return(u?i?"+":"":"-")+r}function di(n,t){var i={milliseconds:0,months:0};return i.months=t.month()-n.month()+(t.year()-n.year())*12,n.clone().add(i.months,"M").isAfter(t)&&--i.months,i.milliseconds=+t-+n.clone().add(i.months,"M"),i}function nf(n,t){var i;return t=bt(t,n),n.isBefore(t)?i=di(n,t):(i=di(t,n),i.milliseconds=-i.milliseconds,i.months=-i.months),i}function gi(n,i){return function(r,u){var f,e;return u===null||isNaN(+u)||(bu(i,"moment()."+i+"(period, number) is deprecated. Please use moment()."+i+"(number, period)."),e=r,r=u,u=e),r=typeof r=="string"?+r:r,f=t.duration(r,u),nr(this,f,n),this}}function nr(n,i,r,u){var o=i._milliseconds,f=i._days,e=i._months;u=u==null?!0:u;o&&n._d.setTime(+n._d+o*r);f&&pr(n,"Date",ii(n,"Date")+f*r);e&&yr(n,ii(n,"Month")+e*r);u&&t.updateOffset(n,f||e)}function ot(n){return Object.prototype.toString.call(n)==="[object Array]"}function pt(n){return Object.prototype.toString.call(n)==="[object Date]"||n instanceof Date}function tr(n,t,r){for(var e=Math.min(n.length,t.length),o=Math.abs(n.length-t.length),f=0,u=0;u<e;u++)(r&&n[u]!==t[u]||!r&&i(n[u])!==i(t[u]))&&f++;return f+o}function e(n){if(n){var t=n.toLowerCase().replace(/(.)s$/,"$1");n=pu[n]||wu[t]||t}return n}function ir(n){var r={},t;for(var i in n)g(n,i)&&(t=e(i),t&&(r[t]=n[i]));return r}function tf(i){var r,u;if(i.indexOf("week")===0)r=7,u="day";else if(i.indexOf("month")===0)r=12,u="month";else return;t[i]=function(f,e){var o,s,c=t._locale[i],h=[];if(typeof f=="number"&&(e=f,f=n),s=function(n){var i=t().utc().set(u,n);return c.call(t._locale,i,f||"")},e!=null)return s(e);for(o=0;o<r;o++)h.push(s(o));return h}}function i(n){var t=+n,i=0;return t!==0&&isFinite(t)&&(i=t>=0?Math.floor(t):Math.ceil(t)),i}function wt(n,t){return new Date(Date.UTC(n,t+1,0)).getUTCDate()}function rr(n,i,r){return tt(t([n,11,31+i-r]),i,r).week}function ur(n){return fr(n)?366:365}function fr(n){return n%4==0&&n%100!=0||n%400==0}function er(n){var t;n._a&&n._pf.overflow===-2&&(t=n._a[l]<0||n._a[l]>11?l:n._a[s]<1||n._a[s]>wt(n._a[c],n._a[l])?s:n._a[f]<0||n._a[f]>24||n._a[f]===24&&(n._a[w]!==0||n._a[b]!==0||n._a[k]!==0)?f:n._a[w]<0||n._a[w]>59?w:n._a[b]<0||n._a[b]>59?b:n._a[k]<0||n._a[k]>999?k:-1,n._pf._overflowDayOfYear&&(t<c||t>s)&&(t=s),n._pf.overflow=t)}function or(t){return t._isValid==null&&(t._isValid=!isNaN(t._d.getTime())&&t._pf.overflow<0&&!t._pf.empty&&!t._pf.invalidMonth&&!t._pf.nullInput&&!t._pf.invalidFormat&&!t._pf.userInvalidated,t._strict&&(t._isValid=t._isValid&&t._pf.charsLeftOver===0&&t._pf.unusedTokens.length===0&&t._pf.bigHour===n)),t._isValid}function sr(n){return n?n.toLowerCase().replace("_","-"):n}function rf(n){for(var r=0,i,t,f,u;r<n.length;){for(u=sr(n[r]).split("-"),i=u.length,t=sr(n[r+1]),t=t?t.split("-"):null;i>0;){if(f=hr(u.slice(0,i).join("-")),f)return f;if(t&&t.length>=i&&tr(u,t,!0)>=i-1)break;i--}r++}return null}function hr(n){var i=null;if(!d[n]&&ui)try{i=t.locale();require("./locale/"+n);t.locale(i)}catch(r){}return d[n]}function bt(n,i){var r,u;return i._isUTC?(r=i.clone(),u=(t.isMoment(n)||pt(n)?+n:+t(n))-+r,r._d.setTime(+r._d+u),t.updateOffset(r,!1),r):t(n).local()}function uf(n){return n.match(/\[[\s\S]/)?n.replace(/^\[|\]$/g,""):n.replace(/\\/g,"")}function ff(n){for(var i=n.match(fi),t=0,r=i.length;t<r;t++)i[t]=a[i[t]]?a[i[t]]:uf(i[t]);return function(u){var f="";for(t=0;t<r;t++)f+=i[t]instanceof Function?i[t].call(u,n):i[t];return f}}function kt(n,t){return n.isValid()?(t=cr(t,n.localeData()),lt[t]||(lt[t]=ff(t)),lt[t](n)):n.localeData().invalidDate()}function cr(n,t){function r(n){return t.longDateFormat(n)||n}var i=5;for(ft.lastIndex=0;i>=0&&ft.test(n);)n=n.replace(ft,r),ft.lastIndex=0,i-=1;return n}function ef(n,t){var i=t._strict;switch(n){case"Q":return oi;case"DDDD":return hi;case"YYYY":case"GGGG":case"gggg":return i?cu:ru;case"Y":case"G":case"g":return au;case"YYYYYY":case"YYYYY":case"GGGGG":case"ggggg":return i?lu:uu;case"S":if(i)return oi;case"SS":if(i)return si;case"SSS":if(i)return hi;case"DDD":return iu;case"MMM":case"MMMM":case"dd":case"ddd":case"dddd":return eu;case"a":case"A":return t._locale._meridiemParse;case"x":return su;case"X":return hu;case"Z":case"ZZ":return st;case"T":return ou;case"SSSS":return fu;case"MM":case"DD":case"YY":case"GG":case"gg":case"HH":case"hh":case"mm":case"ss":case"ww":case"WW":return i?si:ei;case"M":case"D":case"d":case"H":case"h":case"m":case"s":case"w":case"W":case"e":case"E":return ei;case"Do":return i?t._locale._ordinalParse:t._locale._ordinalParseLenient;default:return new RegExp(af(lf(n.replace("\\","")),"i"))}}function dt(n){n=n||"";var r=n.match(st)||[],f=r[r.length-1]||[],t=(f+"").match(yu)||["-",0,0],u=+(t[1]*60)+i(t[2]);return t[0]==="+"?u:-u}function of(n,r,u){var o,e=u._a;switch(n){case"Q":r!=null&&(e[l]=(i(r)-1)*3);break;case"M":case"MM":r!=null&&(e[l]=i(r)-1);break;case"MMM":case"MMMM":o=u._locale.monthsParse(r,n,u._strict);o!=null?e[l]=o:u._pf.invalidMonth=r;break;case"D":case"DD":r!=null&&(e[s]=i(r));break;case"Do":r!=null&&(e[s]=i(parseInt(r.match(/\d{1,2}/)[0],10)));break;case"DDD":case"DDDD":r!=null&&(u._dayOfYear=i(r));break;case"YY":e[c]=t.parseTwoDigitYear(r);break;case"YYYY":case"YYYYY":case"YYYYYY":e[c]=i(r);break;case"a":case"A":u._meridiem=r;break;case"h":case"hh":u._pf.bigHour=!0;case"H":case"HH":e[f]=i(r);break;case"m":case"mm":e[w]=i(r);break;case"s":case"ss":e[b]=i(r);break;case"S":case"SS":case"SSS":case"SSSS":e[k]=i(("0."+r)*1e3);break;case"x":u._d=new Date(i(r));break;case"X":u._d=new Date(parseFloat(r)*1e3);break;case"Z":case"ZZ":u._useUTC=!0;u._tzm=dt(r);break;case"dd":case"ddd":case"dddd":o=u._locale.weekdaysParse(r);o!=null?(u._w=u._w||{},u._w.d=o):u._pf.invalidWeekday=r;break;case"w":case"ww":case"W":case"WW":case"d":case"e":case"E":n=n.substr(0,1);case"gggg":case"GGGG":case"GGGGG":n=n.substr(0,2);r&&(u._w=u._w||{},u._w[n]=i(r));break;case"gg":case"GG":u._w=u._w||{};u._w[n]=t.parseTwoDigitYear(r)}}function sf(n){var i,o,f,u,r,e,s;i=n._w;i.GG!=null||i.W!=null||i.E!=null?(r=1,e=4,o=it(i.GG,n._a[c],tt(t(),1,4).year),f=it(i.W,1),u=it(i.E,1)):(r=n._locale._week.dow,e=n._locale._week.doy,o=it(i.gg,n._a[c],tt(t(),r,e).year),f=it(i.w,1),i.d!=null?(u=i.d,u<r&&++f):u=i.e!=null?i.e+r:r);s=ne(o,f,u,e,r);n._a[c]=s.year;n._dayOfYear=s.dayOfYear}function gt(n){var t,i,r=[],u,e;if(!n._d){for(u=cf(n),n._w&&n._a[s]==null&&n._a[l]==null&&sf(n),n._dayOfYear&&(e=it(n._a[c],u[c]),n._dayOfYear>ur(e)&&(n._pf._overflowDayOfYear=!0),i=ti(e,0,n._dayOfYear),n._a[l]=i.getUTCMonth(),n._a[s]=i.getUTCDate()),t=0;t<3&&n._a[t]==null;++t)n._a[t]=r[t]=u[t];for(;t<7;t++)n._a[t]=r[t]=n._a[t]==null?t===2?1:0:n._a[t];n._a[f]===24&&n._a[w]===0&&n._a[b]===0&&n._a[k]===0&&(n._nextDay=!0,n._a[f]=0);n._d=(n._useUTC?ti:bf).apply(null,r);n._tzm!=null&&n._d.setUTCMinutes(n._d.getUTCMinutes()-n._tzm);n._nextDay&&(n._a[f]=24)}}function hf(n){var t;n._d||(t=ir(n._i),n._a=[t.year,t.month,t.day||t.date,t.hour,t.minute,t.second,t.millisecond],gt(n))}function cf(n){var t=new Date;return n._useUTC?[t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()]:[t.getFullYear(),t.getMonth(),t.getDate()]}function ni(i){if(i._f===t.ISO_8601){lr(i);return}i._a=[];i._pf.empty=!0;for(var r=""+i._i,u,e,h,l=r.length,c=0,s=cr(i._f,i._locale).match(fi)||[],o=0;o<s.length;o++)e=s[o],u=(r.match(ef(e,i))||[])[0],u&&(h=r.substr(0,r.indexOf(u)),h.length>0&&i._pf.unusedInput.push(h),r=r.slice(r.indexOf(u)+u.length),c+=u.length),a[e]?(u?i._pf.empty=!1:i._pf.unusedTokens.push(e),of(e,u,i)):i._strict&&!u&&i._pf.unusedTokens.push(e);i._pf.charsLeftOver=l-c;r.length>0&&i._pf.unusedInput.push(r);i._pf.bigHour===!0&&i._a[f]<=12&&(i._pf.bigHour=n);i._a[f]=gu(i._locale,i._a[f],i._meridiem);gt(i);er(i)}function lf(n){return n.replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(n,t,i,r,u){return t||i||r||u})}function af(n){return n.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function vf(n){var t,f,u,r,i;if(n._f.length===0){n._pf.invalidFormat=!0;n._d=new Date(NaN);return}for(r=0;r<n._f.length;r++)(i=0,t=ki({},n),n._useUTC!=null&&(t._useUTC=n._useUTC),t._pf=vt(),t._f=n._f[r],ni(t),or(t))&&(i+=t._pf.charsLeftOver,i+=t._pf.unusedTokens.length*10,t._pf.score=i,(u==null||i<u)&&(u=i,f=t));nt(n,f||t)}function lr(n){var t,i,r=n._i,u=vu.exec(r);if(u){for(n._pf.iso=!0,t=0,i=ht.length;t<i;t++)if(ht[t][1].exec(r)){n._f=ht[t][0]+(u[6]||" ");break}for(t=0,i=ct.length;t<i;t++)if(ct[t][1].exec(r)){n._f+=ct[t][0];break}r.match(st)&&(n._f+="Z");ni(n)}else n._isValid=!1}function yf(n){lr(n);n._isValid===!1&&(delete n._isValid,t.createFromInputFallback(n))}function pf(n,t){for(var r=[],i=0;i<n.length;++i)r.push(t(n[i],i));return r}function wf(i){var r=i._i,u;r===n?i._d=new Date:pt(r)?i._d=new Date(+r):(u=gr.exec(r))!==null?i._d=new Date(+u[1]):typeof r=="string"?yf(i):ot(r)?(i._a=pf(r.slice(0),function(n){return parseInt(n,10)}),gt(i)):typeof r=="object"?hf(i):typeof r=="number"?i._d=new Date(r):t.createFromInputFallback(i)}function bf(n,t,i,r,u,f,e){var o=new Date(n,t,i,r,u,f,e);return n<1970&&o.setFullYear(n),o}function ti(n){var t=new Date(Date.UTC.apply(null,arguments));return n<1970&&t.setUTCFullYear(n),t}function kf(n,t){if(typeof n=="string")if(isNaN(n)){if(n=t.weekdaysParse(n),typeof n!="number")return null}else n=parseInt(n,10);return n}function df(n,t,i,r,u){return u.relativeTime(t||1,!!i,n,r)}function gf(n,i,r){var u=t.duration(n).abs(),c=p(u.as("s")),e=p(u.as("m")),o=p(u.as("h")),s=p(u.as("d")),h=p(u.as("M")),l=p(u.as("y")),f=c<y.s&&["s",c]||e===1&&["m"]||e<y.m&&["mm",e]||o===1&&["h"]||o<y.h&&["hh",o]||s===1&&["d"]||s<y.d&&["dd",s]||h===1&&["M"]||h<y.M&&["MM",h]||l===1&&["y"]||["yy",l];return f[2]=i,f[3]=+n>0,f[4]=r,df.apply({},f)}function tt(n,i,r){var e=r-i,u=r-n.day(),f;return u>e&&(u-=7),u<e-7&&(u+=7),f=t(n).add(u,"d"),{week:Math.ceil(f.dayOfYear()/7),year:f.year()}}function ne(n,t,i,r,u){var f=ti(n,0,1).getUTCDay(),o,e;return f=f===0?7:f,i=i!=null?i:u,o=u-f+(f>r?7:0)-(f<u?7:0),e=7*(t-1)+(i-u)+o+1,{year:e>0?n:n-1,dayOfYear:e>0?e:ur(n-1)+e}}function ar(i){var r=i._i,f=i._f,u;return(i._locale=i._locale||t.localeData(i._l),r===null||f===n&&r==="")?t.invalid({nullInput:!0}):(typeof r=="string"&&(i._i=r=i._locale.preparse(r)),t.isMoment(r))?new et(r,!0):(f?ot(f)?vf(i):ni(i):wf(i),u=new et(i),u._nextDay&&(u.add(1,"d"),u._nextDay=n),u)}function vr(n,i){var u,r;if(i.length===1&&ot(i[0])&&(i=i[0]),!i.length)return t();for(u=i[0],r=1;r<i.length;++r)i[r][n](u)&&(u=i[r]);return u}function yr(n,t){var i;return typeof t=="string"&&(t=n.localeData().monthsParse(t),typeof t!="number")?n:(i=Math.min(n.date(),wt(n.year(),t)),n._d["set"+(n._isUTC?"UTC":"")+"Month"](t,i),n)}function ii(n,t){return n._d["get"+(n._isUTC?"UTC":"")+t]()}function pr(n,t,i){return t==="Month"?yr(n,i):n._d["set"+(n._isUTC?"UTC":"")+t](i)}function v(n,i){return function(r){return r!=null?(pr(this,n,r),t.updateOffset(this,i),this):ii(this,n)}}function wr(n){return n*400/146097}function br(n){return n*146097/400}function te(n){t.duration.fn[n]=function(){return this._data[n]}}function kr(n){typeof ender=="undefined"&&(ri=rt.moment,rt.moment=n?o("Accessing Moment through the global scope is deprecated, and will be removed in an upcoming release.",t):t)}for(var t,rt=typeof global!="undefined"&&(typeof window=="undefined"||window===global.window)?global:this,ri,p=Math.round,dr=Object.prototype.hasOwnProperty,u,c=0,l=1,s=2,f=3,w=4,b=5,k=6,d={},ut=[],ui=typeof module!="undefined"&&module&&module.exports,gr=/^\/?Date\((\-?\d+)/i,nu=/(\-)?(?:(\d*)\.)?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?)?/,tu=/^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/,fi=/(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Q|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,4}|x|X|zz?|ZZ?|.)/g,ft=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,ei=/\d\d?/,iu=/\d{1,3}/,ru=/\d{1,4}/,uu=/[+\-]?\d{1,6}/,fu=/\d+/,eu=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,st=/Z|[\+\-]\d\d:?\d\d/gi,ou=/T/i,su=/[\+\-]?\d+/,hu=/[\+\-]?\d+(\.\d{1,3})?/,oi=/\d/,si=/\d\d/,hi=/\d{3}/,cu=/\d{4}/,lu=/[+-]?\d{6}/,au=/[+-]?\d+/,vu=/^\s*(?:[+-]\d{6}|\d{4})-(?:(\d\d-\d\d)|(W\d\d$)|(W\d\d-\d)|(\d\d\d))((T| )(\d\d(:\d\d(:\d\d(\.\d+)?)?)?)?([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,ht=[["YYYYYY-MM-DD",/[+-]\d{6}-\d{2}-\d{2}/],["YYYY-MM-DD",/\d{4}-\d{2}-\d{2}/],["GGGG-[W]WW-E",/\d{4}-W\d{2}-\d/],["GGGG-[W]WW",/\d{4}-W\d{2}/],["YYYY-DDD",/\d{4}-\d{3}/]],ct=[["HH:mm:ss.SSSS",/(T| )\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss",/(T| )\d\d:\d\d:\d\d/],["HH:mm",/(T| )\d\d:\d\d/],["HH",/(T| )\d\d/]],yu=/([\+\-]|\d\d)/gi,ie="Date|Hours|Minutes|Seconds|Milliseconds".split("|"),ci={Milliseconds:1,Seconds:1e3,Minutes:6e4,Hours:36e5,Days:864e5,Months:2592e6,Years:31536e6},pu={ms:"millisecond",s:"second",m:"minute",h:"hour",d:"day",D:"date",w:"week",W:"isoWeek",M:"month",Q:"quarter",y:"year",DDD:"dayOfYear",e:"weekday",E:"isoWeekday",gg:"weekYear",GG:"isoWeekYear"},wu={dayofyear:"dayOfYear",isoweekday:"isoWeekday",isoweek:"isoWeek",weekyear:"weekYear",isoweekyear:"isoWeekYear"},lt={},y={s:45,m:45,h:22,d:26,M:11},li="DDD w W M D d".split(" "),ai="M D H h m s w W".split(" "),a={M:function(){return this.month()+1},MMM:function(n){return this.localeData().monthsShort(this,n)},MMMM:function(n){return this.localeData().months(this,n)},D:function(){return this.date()},DDD:function(){return this.dayOfYear()},d:function(){return this.day()},dd:function(n){return this.localeData().weekdaysMin(this,n)},ddd:function(n){return this.localeData().weekdaysShort(this,n)},dddd:function(n){return this.localeData().weekdays(this,n)},w:function(){return this.week()},W:function(){return this.isoWeek()},YY:function(){return r(this.year()%100,2)},YYYY:function(){return r(this.year(),4)},YYYYY:function(){return r(this.year(),5)},YYYYYY:function(){var n=this.year(),t=n>=0?"+":"-";return t+r(Math.abs(n),6)},gg:function(){return r(this.weekYear()%100,2)},gggg:function(){return r(this.weekYear(),4)},ggggg:function(){return r(this.weekYear(),5)},GG:function(){return r(this.isoWeekYear()%100,2)},GGGG:function(){return r(this.isoWeekYear(),4)},GGGGG:function(){return r(this.isoWeekYear(),5)},e:function(){return this.weekday()},E:function(){return this.isoWeekday()},a:function(){return this.localeData().meridiem(this.hours(),this.minutes(),!0)},A:function(){return this.localeData().meridiem(this.hours(),this.minutes(),!1)},H:function(){return this.hours()},h:function(){return this.hours()%12||12},m:function(){return this.minutes()},s:function(){return this.seconds()},S:function(){return i(this.milliseconds()/100)},SS:function(){return r(i(this.milliseconds()/10),2)},SSS:function(){return r(this.milliseconds(),3)},SSSS:function(){return r(this.milliseconds(),3)},Z:function(){var n=this.utcOffset(),t="+";return n<0&&(n=-n,t="-"),t+r(i(n/60),2)+":"+r(i(n)%60,2)},ZZ:function(){var n=this.utcOffset(),t="+";return n<0&&(n=-n,t="-"),t+r(i(n/60),2)+r(i(n)%60,2)},z:function(){return this.zoneAbbr()},zz:function(){return this.zoneName()},x:function(){return this.valueOf()},X:function(){return this.unix()},Q:function(){return this.quarter()}},vi={},yi=["months","monthsShort","weekdays","weekdaysShort","weekdaysMin"],at=!1;li.length;)u=li.pop(),a[u+"o"]=ku(a[u],u);while(ai.length)u=ai.pop(),a[u+u]=wi(a[u],2);for(a.DDDD=wi(a.DDD,3),nt(bi.prototype,{set:function(n){var t;for(var i in n)t=n[i],typeof t=="function"?this[i]=t:this["_"+i]=t;this._ordinalParseLenient=new RegExp(this._ordinalParse.source+"|"+/\d{1,2}/.source)},_months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),months:function(n){return this._months[n.month()]},_monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),monthsShort:function(n){return this._monthsShort[n.month()]},monthsParse:function(n,i,r){var u,f,e;for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),u=0;u<12;u++)if((f=t.utc([2e3,u]),r&&!this._longMonthsParse[u]&&(this._longMonthsParse[u]=new RegExp("^"+this.months(f,"").replace(".","")+"$","i"),this._shortMonthsParse[u]=new RegExp("^"+this.monthsShort(f,"").replace(".","")+"$","i")),r||this._monthsParse[u]||(e="^"+this.months(f,"")+"|^"+this.monthsShort(f,""),this._monthsParse[u]=new RegExp(e.replace(".",""),"i")),r&&i==="MMMM"&&this._longMonthsParse[u].test(n))||r&&i==="MMM"&&this._shortMonthsParse[u].test(n)||!r&&this._monthsParse[u].test(n))return u},_weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdays:function(n){return this._weekdays[n.day()]},_weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysShort:function(n){return this._weekdaysShort[n.day()]},_weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),weekdaysMin:function(n){return this._weekdaysMin[n.day()]},weekdaysParse:function(n){var i,r,u;for(this._weekdaysParse||(this._weekdaysParse=[]),i=0;i<7;i++)if(this._weekdaysParse[i]||(r=t([2e3,1]).day(i),u="^"+this.weekdays(r,"")+"|^"+this.weekdaysShort(r,"")+"|^"+this.weekdaysMin(r,""),this._weekdaysParse[i]=new RegExp(u.replace(".",""),"i")),this._weekdaysParse[i].test(n))return i},_longDateFormat:{LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY LT",LLLL:"dddd, MMMM D, YYYY LT"},longDateFormat:function(n){var t=this._longDateFormat[n];return!t&&this._longDateFormat[n.toUpperCase()]&&(t=this._longDateFormat[n.toUpperCase()].replace(/MMMM|MM|DD|dddd/g,function(n){return n.slice(1)}),this._longDateFormat[n]=t),t},isPM:function(n){return(n+"").toLowerCase().charAt(0)==="p"},_meridiemParse:/[ap]\.?m?\.?/i,meridiem:function(n,t,i){return n>11?i?"pm":"PM":i?"am":"AM"},_calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},calendar:function(n,t,i){var r=this._calendar[n];return typeof r=="function"?r.apply(t,[i]):r},_relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},relativeTime:function(n,t,i,r){var u=this._relativeTime[i];return typeof u=="function"?u(n,t,i,r):u.replace(/%d/i,n)},pastFuture:function(n,t){var i=this._relativeTime[n>0?"future":"past"];return typeof i=="function"?i(t):i.replace(/%s/i,t)},ordinal:function(n){return this._ordinal.replace("%d",n)},_ordinal:"%d",_ordinalParse:/\d{1,2}/,preparse:function(n){return n},postformat:function(n){return n},week:function(n){return tt(n,this._week.dow,this._week.doy).week},_week:{dow:0,doy:6},firstDayOfWeek:function(){return this._week.dow},firstDayOfYear:function(){return this._week.doy},_invalidDate:"Invalid date",invalidDate:function(){return this._invalidDate}}),t=function(t,i,r,u){var f;return typeof r=="boolean"&&(u=r,r=n),f={},f._isAMomentObject=!0,f._i=t,f._f=i,f._l=r,f._strict=u,f._isUTC=!1,f._pf=vt(),ar(f)},t.suppressDeprecationWarnings=!1,t.createFromInputFallback=o("moment construction falls back to js Date. This is discouraged and will be removed in upcoming major release. Please refer to https://github.com/moment/moment/issues/1407 for more info.",function(n){n._d=new Date(n._i+(n._useUTC?" UTC":""))}),t.min=function(){var n=[].slice.call(arguments,0);return vr("isBefore",n)},t.max=function(){var n=[].slice.call(arguments,0);return vr("isAfter",n)},t.utc=function(t,i,r,u){var f;return typeof r=="boolean"&&(u=r,r=n),f={},f._isAMomentObject=!0,f._useUTC=!0,f._isUTC=!0,f._l=r,f._i=t,f._f=i,f._strict=u,f._pf=vt(),ar(f).utc()},t.unix=function(n){return t(n*1e3)},t.duration=function(n,r){var u=n,e=null,o,c,h,l;return t.isDuration(n)?u={ms:n._milliseconds,d:n._days,M:n._months}:typeof n=="number"?(u={},r?u[r]=n:u.milliseconds=n):(e=nu.exec(n))?(o=e[1]==="-"?-1:1,u={y:0,d:i(e[s])*o,h:i(e[f])*o,m:i(e[w])*o,s:i(e[b])*o,ms:i(e[k])*o}):(e=tu.exec(n))?(o=e[1]==="-"?-1:1,h=function(n){var t=n&&parseFloat(n.replace(",","."));return(isNaN(t)?0:t)*o},u={y:h(e[2]),M:h(e[3]),d:h(e[4]),h:h(e[5]),m:h(e[6]),s:h(e[7]),w:h(e[8])}):u==null?u={}:typeof u=="object"&&("from"in u||"to"in u)&&(l=nf(t(u.from),t(u.to)),u={},u.ms=l.milliseconds,u.M=l.months),c=new yt(u),t.isDuration(n)&&g(n,"_locale")&&(c._locale=n._locale),c},t.version="2.9.0",t.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",t.ISO_8601=function(){},t.momentProperties=ut,t.updateOffset=function(){},t.relativeTimeThreshold=function(t,i){return y[t]===n?!1:i===n?y[t]:(y[t]=i,!0)},t.lang=o("moment.lang is deprecated. Use moment.locale instead.",function(n,i){return t.locale(n,i)}),t.locale=function(n,i){var r;return n&&(r=typeof i!="undefined"?t.defineLocale(n,i):t.localeData(n),r&&(t.duration._locale=t._locale=r)),t._locale._abbr},t.defineLocale=function(n,i){return i!==null?(i.abbr=n,d[n]||(d[n]=new bi),d[n].set(i),t.locale(n),d[n]):(delete d[n],null)},t.langData=o("moment.langData is deprecated. Use moment.localeData instead.",function(n){return t.localeData(n)}),t.localeData=function(n){var i;if(n&&n._locale&&n._locale._abbr&&(n=n._locale._abbr),!n)return t._locale;if(!ot(n)){if(i=hr(n),i)return i;n=[n]}return rf(n)},t.isMoment=function(n){return n instanceof et||n!=null&&g(n,"_isAMomentObject")},t.isDuration=function(n){return n instanceof yt},u=yi.length-1;u>=0;--u)tf(yi[u]);t.normalizeUnits=function(n){return e(n)};t.invalid=function(n){var i=t.utc(NaN);return n!=null?nt(i._pf,n):i._pf.userInvalidated=!0,i};t.parseZone=function(){return t.apply(null,arguments).parseZone()};t.parseTwoDigitYear=function(n){return i(n)+(i(n)>68?1900:2e3)};t.isDate=pt;nt(t.fn=et.prototype,{clone:function(){return t(this)},valueOf:function(){return+this._d-(this._offset||0)*6e4},unix:function(){return Math.floor(+this/1e3)},toString:function(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")},toDate:function(){return this._offset?new Date(+this):this._d},toISOString:function(){var n=t(this).utc();return 0<n.year()&&n.year()<=9999?"function"==typeof Date.prototype.toISOString?this.toDate().toISOString():kt(n,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):kt(n,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")},toArray:function(){var n=this;return[n.year(),n.month(),n.date(),n.hours(),n.minutes(),n.seconds(),n.milliseconds()]},isValid:function(){return or(this)},isDSTShifted:function(){return this._a?this.isValid()&&tr(this._a,(this._isUTC?t.utc(this._a):t(this._a)).toArray())>0:!1},parsingFlags:function(){return nt({},this._pf)},invalidAt:function(){return this._pf.overflow},utc:function(n){return this.utcOffset(0,n)},local:function(n){return this._isUTC&&(this.utcOffset(0,n),this._isUTC=!1,n&&this.subtract(this._dateUtcOffset(),"m")),this},format:function(n){var i=kt(this,n||t.defaultFormat);return this.localeData().postformat(i)},add:gi(1,"add"),subtract:gi(-1,"subtract"),diff:function(n,t,i){var f=bt(n,this),o=(f.utcOffset()-this.utcOffset())*6e4,u,r;return t=e(t),t==="year"||t==="month"||t==="quarter"?(r=du(this,f),t==="quarter"?r=r/3:t==="year"&&(r=r/12)):(u=this-f,r=t==="second"?u/1e3:t==="minute"?u/6e4:t==="hour"?u/36e5:t==="day"?(u-o)/864e5:t==="week"?(u-o)/6048e5:u),i?r:h(r)},from:function(n,i){return t.duration({to:this,from:n}).locale(this.locale()).humanize(!i)},fromNow:function(n){return this.from(t(),n)},calendar:function(n){var r=n||t(),u=bt(r,this).startOf("day"),i=this.diff(u,"days",!0),f=i<-6?"sameElse":i<-1?"lastWeek":i<0?"lastDay":i<1?"sameDay":i<2?"nextDay":i<7?"nextWeek":"sameElse";return this.format(this.localeData().calendar(f,this,t(r)))},isLeapYear:function(){return fr(this.year())},isDST:function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},day:function(n){var t=this._isUTC?this._d.getUTCDay():this._d.getDay();return n!=null?(n=kf(n,this.localeData()),this.add(n-t,"d")):t},month:v("Month",!0),startOf:function(n){n=e(n);switch(n){case"year":this.month(0);case"quarter":case"month":this.date(1);case"week":case"isoWeek":case"day":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return n==="week"?this.weekday(0):n==="isoWeek"&&this.isoWeekday(1),n==="quarter"&&this.month(Math.floor(this.month()/3)*3),this},endOf:function(t){return(t=e(t),t===n||t==="millisecond")?this:this.startOf(t).add(1,t==="isoWeek"?"week":t).subtract(1,"ms")},isAfter:function(n,i){var r;return i=e(typeof i!="undefined"?i:"millisecond"),i==="millisecond"?(n=t.isMoment(n)?n:t(n),+this>+n):(r=t.isMoment(n)?+n:+t(n),r<+this.clone().startOf(i))},isBefore:function(n,i){var r;return i=e(typeof i!="undefined"?i:"millisecond"),i==="millisecond"?(n=t.isMoment(n)?n:t(n),+this<+n):(r=t.isMoment(n)?+n:+t(n),+this.clone().endOf(i)<r)},isBetween:function(n,t,i){return this.isAfter(n,i)&&this.isBefore(t,i)},isSame:function(n,i){var r;return i=e(i||"millisecond"),i==="millisecond"?(n=t.isMoment(n)?n:t(n),+this==+n):(r=+t(n),+this.clone().startOf(i)<=r&&r<=+this.clone().endOf(i))},min:o("moment().min is deprecated, use moment.min instead. https://github.com/moment/moment/issues/1548",function(n){return n=t.apply(null,arguments),n<this?this:n}),max:o("moment().max is deprecated, use moment.max instead. https://github.com/moment/moment/issues/1548",function(n){return n=t.apply(null,arguments),n>this?this:n}),zone:o("moment().zone is deprecated, use moment().utcOffset instead. https://github.com/moment/moment/issues/1779",function(n,t){return n!=null?(typeof n!="string"&&(n=-n),this.utcOffset(n,t),this):-this.utcOffset()}),utcOffset:function(n,i){var r=this._offset||0,u;return n!=null?(typeof n=="string"&&(n=dt(n)),Math.abs(n)<16&&(n=n*60),!this._isUTC&&i&&(u=this._dateUtcOffset()),this._offset=n,this._isUTC=!0,u!=null&&this.add(u,"m"),r!==n&&(!i||this._changeInProgress?nr(this,t.duration(n-r,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,t.updateOffset(this,!0),this._changeInProgress=null)),this):this._isUTC?r:this._dateUtcOffset()},isLocal:function(){return!this._isUTC},isUtcOffset:function(){return this._isUTC},isUtc:function(){return this._isUTC&&this._offset===0},zoneAbbr:function(){return this._isUTC?"UTC":""},zoneName:function(){return this._isUTC?"Coordinated Universal Time":""},parseZone:function(){return this._tzm?this.utcOffset(this._tzm):typeof this._i=="string"&&this.utcOffset(dt(this._i)),this},hasAlignedHourOffset:function(n){return n=n?t(n).utcOffset():0,(this.utcOffset()-n)%60==0},daysInMonth:function(){return wt(this.year(),this.month())},dayOfYear:function(n){var i=p((t(this).startOf("day")-t(this).startOf("year"))/864e5)+1;return n==null?i:this.add(n-i,"d")},quarter:function(n){return n==null?Math.ceil((this.month()+1)/3):this.month((n-1)*3+this.month()%3)},weekYear:function(n){var t=tt(this,this.localeData()._week.dow,this.localeData()._week.doy).year;return n==null?t:this.add(n-t,"y")},isoWeekYear:function(n){var t=tt(this,1,4).year;return n==null?t:this.add(n-t,"y")},week:function(n){var t=this.localeData().week(this);return n==null?t:this.add((n-t)*7,"d")},isoWeek:function(n){var t=tt(this,1,4).week;return n==null?t:this.add((n-t)*7,"d")},weekday:function(n){var t=(this.day()+7-this.localeData()._week.dow)%7;return n==null?t:this.add(n-t,"d")},isoWeekday:function(n){return n==null?this.day()||7:this.day(this.day()%7?n:n-7)},isoWeeksInYear:function(){return rr(this.year(),1,4)},weeksInYear:function(){var n=this.localeData()._week;return rr(this.year(),n.dow,n.doy)},get:function(n){return n=e(n),this[n]()},set:function(n,t){var i;if(typeof n=="object")for(i in n)this.set(i,n[i]);else n=e(n),typeof this[n]=="function"&&this[n](t);return this},locale:function(i){var r;return i===n?this._locale._abbr:(r=t.localeData(i),r!=null&&(this._locale=r),this)},lang:o("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(t){return t===n?this.localeData():this.locale(t)}),localeData:function(){return this._locale},_dateUtcOffset:function(){return-Math.round(this._d.getTimezoneOffset()/15)*15}});t.fn.millisecond=t.fn.milliseconds=v("Milliseconds",!1);t.fn.second=t.fn.seconds=v("Seconds",!1);t.fn.minute=t.fn.minutes=v("Minutes",!1);t.fn.hour=t.fn.hours=v("Hours",!0);t.fn.date=v("Date",!0);t.fn.dates=o("dates accessor is deprecated. Use date instead.",v("Date",!0));t.fn.year=v("FullYear",!0);t.fn.years=o("years accessor is deprecated. Use year instead.",v("FullYear",!0));t.fn.days=t.fn.day;t.fn.months=t.fn.month;t.fn.weeks=t.fn.week;t.fn.isoWeeks=t.fn.isoWeek;t.fn.quarters=t.fn.quarter;t.fn.toJSON=t.fn.toISOString;t.fn.isUTC=t.fn.isUtc;nt(t.duration.fn=yt.prototype,{_bubble:function(){var o=this._milliseconds,t=this._days,i=this._months,n=this._data,u,f,e,r=0;n.milliseconds=o%1e3;u=h(o/1e3);n.seconds=u%60;f=h(u/60);n.minutes=f%60;e=h(f/60);n.hours=e%24;t+=h(e/24);r=h(wr(t));t-=h(br(r));i+=h(t/30);t%=30;r+=h(i/12);i%=12;n.days=t;n.months=i;n.years=r},abs:function(){return this._milliseconds=Math.abs(this._milliseconds),this._days=Math.abs(this._days),this._months=Math.abs(this._months),this._data.milliseconds=Math.abs(this._data.milliseconds),this._data.seconds=Math.abs(this._data.seconds),this._data.minutes=Math.abs(this._data.minutes),this._data.hours=Math.abs(this._data.hours),this._data.months=Math.abs(this._data.months),this._data.years=Math.abs(this._data.years),this},weeks:function(){return h(this.days()/7)},valueOf:function(){return this._milliseconds+this._days*864e5+this._months%12*2592e6+i(this._months/12)*31536e6},humanize:function(n){var t=gf(this,!n,this.localeData());return n&&(t=this.localeData().pastFuture(+this,t)),this.localeData().postformat(t)},add:function(n,i){var r=t.duration(n,i);return this._milliseconds+=r._milliseconds,this._days+=r._days,this._months+=r._months,this._bubble(),this},subtract:function(n,i){var r=t.duration(n,i);return this._milliseconds-=r._milliseconds,this._days-=r._days,this._months-=r._months,this._bubble(),this},get:function(n){return n=e(n),this[n.toLowerCase()+"s"]()},as:function(n){var t,i;if(n=e(n),n==="month"||n==="year")return t=this._days+this._milliseconds/864e5,i=this._months+wr(t)*12,n==="month"?i:i/12;t=this._days+Math.round(br(this._months/12));switch(n){case"week":return t/7+this._milliseconds/6048e5;case"day":return t+this._milliseconds/864e5;case"hour":return t*24+this._milliseconds/36e5;case"minute":return t*1440+this._milliseconds/6e4;case"second":return t*86400+this._milliseconds/1e3;case"millisecond":return Math.floor(t*864e5)+this._milliseconds;default:throw new Error("Unknown unit "+n);}},lang:t.fn.lang,locale:t.fn.locale,toIsoString:o("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",function(){return this.toISOString()}),toISOString:function(){var r=Math.abs(this.years()),u=Math.abs(this.months()),f=Math.abs(this.days()),n=Math.abs(this.hours()),t=Math.abs(this.minutes()),i=Math.abs(this.seconds()+this.milliseconds()/1e3);return this.asSeconds()?(this.asSeconds()<0?"-":"")+"P"+(r?r+"Y":"")+(u?u+"M":"")+(f?f+"D":"")+(n||t||i?"T":"")+(n?n+"H":"")+(t?t+"M":"")+(i?i+"S":""):"P0D"},localeData:function(){return this._locale},toJSON:function(){return this.toISOString()}});t.duration.fn.toString=t.duration.fn.toISOString;for(u in ci)g(ci,u)&&te(u.toLowerCase());t.duration.fn.asMilliseconds=function(){return this.as("ms")};t.duration.fn.asSeconds=function(){return this.as("s")};t.duration.fn.asMinutes=function(){return this.as("m")};t.duration.fn.asHours=function(){return this.as("h")};t.duration.fn.asDays=function(){return this.as("d")};t.duration.fn.asWeeks=function(){return this.as("weeks")};t.duration.fn.asMonths=function(){return this.as("M")};t.duration.fn.asYears=function(){return this.as("y")};t.locale("en",{ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(n){var t=n%10,r=i(n%100/10)===1?"th":t===1?"st":t===2?"nd":t===3?"rd":"th";return n+r}});ui?module.exports=t:typeof define=="function"&&define.amd?(define(function(n,i,r){return r.config&&r.config()&&r.config().noGlobal===!0&&(rt.moment=ri),t}),kr(!0)):kr()}).call(this);
//# sourceMappingURL=moment.min.js.map
;
/*!
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2017
 * @version 1.3.4
 *
 * Date formatter utility library that allows formatting date/time variables or Date objects using PHP DateTime format.
 * This library is a standalone javascript library and does not depend on other libraries or plugins like jQuery.
 * 
 * @see http://php.net/manual/en/function.date.php
 *
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */
var DateFormatter;
var xdsoft_moveStart = false;
(function () {
    "use strict";
    var _compare, _lpad, _extend, _indexOf, defaultSettings, DAY, HOUR;
    DAY = 1000 * 60 * 60 * 24;
    HOUR = 3600;

    _compare = function (str1, str2) {
        return typeof (str1) === 'string' && typeof (str2) === 'string' && str1.toLowerCase() === str2.toLowerCase();
    };
    _lpad = function (value, length, chr) {
        var val = value.toString();
        chr = chr || '0';
        return val.length < length ? _lpad(chr + val, length) : val;
    };
    _extend = function (out) {
        var i, obj;
        out = out || {};
        for (i = 1; i < arguments.length; i++) {
            obj = arguments[i];
            if (!obj) {
                continue;
            }
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    if (typeof obj[key] === 'object') {
                        _extend(out[key], obj[key]);
                    } else {
                        out[key] = obj[key];
                    }
                }
            }
        }
        return out;
    };
    _indexOf = function (val, arr) {
        for (var i = 0; i < arr.length; i++) {
            if (arr[i].toLowerCase() === val.toLowerCase()) {
                return i;
            }
        }
        return -1;
    };
    defaultSettings = {
        dateSettings: {
            days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
            daysShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
            months: [
                'January', 'February', 'March', 'April', 'May', 'June', 'July',
                'August', 'September', 'October', 'November', 'December'
            ],
            monthsShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
            meridiem: ['AM', 'PM'],
            ordinal: function (number) {
                var n = number % 10, suffixes = { 1: 'st', 2: 'nd', 3: 'rd' };
                return Math.floor(number % 100 / 10) === 1 || !suffixes[n] ? 'th' : suffixes[n];
            }
        },
        separators: /[ \-+\/\.T:@]/g,
        validParts: /[dDjlNSwzWFmMntLoYyaABgGhHisueTIOPZcrU]/g,
        intParts: /[djwNzmnyYhHgGis]/g,
        tzParts: /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,
        tzClip: /[^-+\dA-Z]/g
    };

    DateFormatter = function (options) {
        var self = this, config = _extend(defaultSettings, options);
        self.dateSettings = config.dateSettings;
        self.separators = config.separators;
        self.validParts = config.validParts;
        self.intParts = config.intParts;
        self.tzParts = config.tzParts;
        self.tzClip = config.tzClip;
    };

    DateFormatter.prototype = {
        constructor: DateFormatter,
        getMonth: function (val) {
            var self = this, i;
            i = _indexOf(val, self.dateSettings.monthsShort) + 1;
            if (i === 0) {
                i = _indexOf(val, self.dateSettings.months) + 1;
            }
            return i;
        },
        parseDate: function (vDate, vFormat) {
            var self = this, vFormatParts, vDateParts, i, vDateFlag = false, vTimeFlag = false, vDatePart, iDatePart,
                vSettings = self.dateSettings, vMonth, vMeriIndex, vMeriOffset, len, mer,
                out = { date: null, year: null, month: null, day: null, hour: 0, min: 0, sec: 0 };
            if (!vDate) {
                return null;
            }
            if (vDate instanceof Date) {
                return vDate;
            }
            if (vFormat === 'U') {
                i = parseInt(vDate);
                return i ? new Date(i * 1000) : vDate;
            }
            switch (typeof vDate) {
                case 'number':
                    return new Date(vDate);
                case 'string':
                    break;
                default:
                    return null;
            }
            vFormatParts = vFormat.match(self.validParts);
            if (!vFormatParts || vFormatParts.length === 0) {
                throw new Error("Invalid date format definition.");
            }
            vDateParts = vDate.replace(self.separators, '\0').split('\0');
            for (i = 0; i < vDateParts.length; i++) {
                vDatePart = vDateParts[i];
                iDatePart = parseInt(vDatePart);
                switch (vFormatParts[i]) {
                    case 'y':
                    case 'Y':
                        if (iDatePart) {
                            len = vDatePart.length;
                            out.year = len === 2 ? parseInt((iDatePart < 70 ? '20' : '19') + vDatePart) : iDatePart;
                        } else {
                            return null;
                        }
                        vDateFlag = true;
                        break;
                    case 'm':
                    case 'n':
                    case 'M':
                    case 'F':
                        if (isNaN(iDatePart)) {
                            vMonth = self.getMonth(vDatePart);
                            if (vMonth > 0) {
                                out.month = vMonth;
                            } else {
                                return null;
                            }
                        } else {
                            if (iDatePart >= 1 && iDatePart <= 12) {
                                out.month = iDatePart;
                            } else {
                                return null;
                            }
                        }
                        vDateFlag = true;
                        break;
                    case 'd':
                    case 'j':
                        if (iDatePart >= 1 && iDatePart <= 31) {
                            out.day = iDatePart;
                        } else {
                            return null;
                        }
                        vDateFlag = true;
                        break;
                    case 'g':
                    case 'h':
                        vMeriIndex = (vFormatParts.indexOf('a') > -1) ? vFormatParts.indexOf('a') :
                            (vFormatParts.indexOf('A') > -1) ? vFormatParts.indexOf('A') : -1;
                        mer = vDateParts[vMeriIndex];
                        if (vMeriIndex !== -1) {
                            vMeriOffset = _compare(mer, vSettings.meridiem[0]) ? 0 :
                                (_compare(mer, vSettings.meridiem[1]) ? 12 : -1);
                            if (iDatePart >= 1 && iDatePart <= 12 && vMeriOffset !== -1) {
                                out.hour = iDatePart % 12 === 0 ? vMeriOffset : iDatePart + vMeriOffset;
                            } else {
                                if (iDatePart >= 0 && iDatePart <= 23) {
                                    out.hour = iDatePart;
                                }
                            }
                        } else {
                            if (iDatePart >= 0 && iDatePart <= 23) {
                                out.hour = iDatePart;
                            } else {
                                return null;
                            }
                        }
                        vTimeFlag = true;
                        break;
                    case 'G':
                    case 'H':
                        if (iDatePart >= 0 && iDatePart <= 23) {
                            out.hour = iDatePart;
                        } else {
                            return null;
                        }
                        vTimeFlag = true;
                        break;
                    case 'i':
                        if (iDatePart >= 0 && iDatePart <= 59) {
                            out.min = iDatePart;
                        } else {
                            return null;
                        }
                        vTimeFlag = true;
                        break;
                    case 's':
                        if (iDatePart >= 0 && iDatePart <= 59) {
                            out.sec = iDatePart;
                        } else {
                            return null;
                        }
                        vTimeFlag = true;
                        break;
                }
            }
            if (vDateFlag === true && out.year && out.month && out.day) {
                out.date = new Date(out.year, out.month - 1, out.day, out.hour, out.min, out.sec, 0);
            } else {
                if (vTimeFlag !== true) {
                    return null;
                }
                out.date = new Date(0, 0, 0, out.hour, out.min, out.sec, 0);
            }
            return out.date;
        },
        guessDate: function (vDateStr, vFormat) {
            if (typeof vDateStr !== 'string') {
                return vDateStr;
            }
            var self = this, vParts = vDateStr.replace(self.separators, '\0').split('\0'), vPattern = /^[djmn]/g, len,
                vFormatParts = vFormat.match(self.validParts), vDate = new Date(), vDigit = 0, vYear, i, n, iPart, iSec;

            if (!vPattern.test(vFormatParts[0])) {
                return vDateStr;
            }

            for (i = 0; i < vParts.length; i++) {
                vDigit = 2;
                iPart = vParts[i];
                iSec = parseInt(iPart.substr(0, 2));
                if (isNaN(iSec)) {
                    return null;
                }
                switch (i) {
                    case 0:
                        if (vFormatParts[0] === 'm' || vFormatParts[0] === 'n') {
                            vDate.setMonth(iSec - 1);
                        } else {
                            vDate.setDate(iSec);
                        }
                        break;
                    case 1:
                        if (vFormatParts[0] === 'm' || vFormatParts[0] === 'n') {
                            vDate.setDate(iSec);
                        } else {
                            vDate.setMonth(iSec - 1);
                        }
                        break;
                    case 2:
                        vYear = vDate.getFullYear();
                        len = iPart.length;
                        vDigit = len < 4 ? len : 4;
                        vYear = parseInt(len < 4 ? vYear.toString().substr(0, 4 - len) + iPart : iPart.substr(0, 4));
                        if (!vYear) {
                            return null;
                        }
                        vDate.setFullYear(vYear);
                        break;
                    case 3:
                        vDate.setHours(iSec);
                        break;
                    case 4:
                        vDate.setMinutes(iSec);
                        break;
                    case 5:
                        vDate.setSeconds(iSec);
                        break;
                }
                n = iPart.substr(vDigit);
                if (n.length > 0) {
                    vParts.splice(i + 1, 0, n);
                }
            }
            return vDate;
        },
        parseFormat: function (vChar, vDate) {
            var self = this, vSettings = self.dateSettings, fmt, backslash = /\\?(.?)/gi, doFormat = function (t, s) {
                return fmt[t] ? fmt[t]() : s;
            };
            fmt = {
                /////////
                // DAY //
                /////////
                /**
                 * Day of month with leading 0: `01..31`
                 * @return {string}
                 */
                d: function () {
                    return _lpad(fmt.j(), 2);
                },
                /**
                 * Shorthand day name: `Mon...Sun`
                 * @return {string}
                 */
                D: function () {
                    return vSettings.daysShort[fmt.w()];
                },
                /**
                 * Day of month: `1..31`
                 * @return {number}
                 */
                j: function () {
                    return vDate.getDate();
                },
                /**
                 * Full day name: `Monday...Sunday`
                 * @return {number}
                 */
                l: function () {
                    return vSettings.days[fmt.w()];
                },
                /**
                 * ISO-8601 day of week: `1[Mon]..7[Sun]`
                 * @return {number}
                 */
                N: function () {
                    return fmt.w() || 7;
                },
                /**
                 * Day of week: `0[Sun]..6[Sat]`
                 * @return {number}
                 */
                w: function () {
                    return vDate.getDay();
                },
                /**
                 * Day of year: `0..365`
                 * @return {number}
                 */
                z: function () {
                    var a = new Date(fmt.Y(), fmt.n() - 1, fmt.j()), b = new Date(fmt.Y(), 0, 1);
                    return Math.round((a - b) / DAY);
                },

                //////////
                // WEEK //
                //////////
                /**
                 * ISO-8601 week number
                 * @return {number}
                 */
                W: function () {
                    var a = new Date(fmt.Y(), fmt.n() - 1, fmt.j() - fmt.N() + 3), b = new Date(a.getFullYear(), 0, 4);
                    return _lpad(1 + Math.round((a - b) / DAY / 7), 2);
                },

                ///////////
                // MONTH //
                ///////////
                /**
                 * Full month name: `January...December`
                 * @return {string}
                 */
                F: function () {
                    return vSettings.months[vDate.getMonth()];
                },
                /**
                 * Month w/leading 0: `01..12`
                 * @return {string}
                 */
                m: function () {
                    return _lpad(fmt.n(), 2);
                },
                /**
                 * Shorthand month name; `Jan...Dec`
                 * @return {string}
                 */
                M: function () {
                    return vSettings.monthsShort[vDate.getMonth()];
                },
                /**
                 * Month: `1...12`
                 * @return {number}
                 */
                n: function () {
                    return vDate.getMonth() + 1;
                },
                /**
                 * Days in month: `28...31`
                 * @return {number}
                 */
                t: function () {
                    return (new Date(fmt.Y(), fmt.n(), 0)).getDate();
                },

                //////////
                // YEAR //
                //////////
                /**
                 * Is leap year? `0 or 1`
                 * @return {number}
                 */
                L: function () {
                    var Y = fmt.Y();
                    return (Y % 4 === 0 && Y % 100 !== 0 || Y % 400 === 0) ? 1 : 0;
                },
                /**
                 * ISO-8601 year
                 * @return {number}
                 */
                o: function () {
                    var n = fmt.n(), W = fmt.W(), Y = fmt.Y();
                    return Y + (n === 12 && W < 9 ? 1 : n === 1 && W > 9 ? -1 : 0);
                },
                /**
                 * Full year: `e.g. 1980...2010`
                 * @return {number}
                 */
                Y: function () {
                    return vDate.getFullYear();
                },
                /**
                 * Last two digits of year: `00...99`
                 * @return {string}
                 */
                y: function () {
                    return fmt.Y().toString().slice(-2);
                },

                //////////
                // TIME //
                //////////
                /**
                 * Meridian lower: `am or pm`
                 * @return {string}
                 */
                a: function () {
                    return fmt.A().toLowerCase();
                },
                /**
                 * Meridian upper: `AM or PM`
                 * @return {string}
                 */
                A: function () {
                    var n = fmt.G() < 12 ? 0 : 1;
                    return vSettings.meridiem[n];
                },
                /**
                 * Swatch Internet time: `000..999`
                 * @return {string}
                 */
                B: function () {
                    var H = vDate.getUTCHours() * HOUR, i = vDate.getUTCMinutes() * 60, s = vDate.getUTCSeconds();
                    return _lpad(Math.floor((H + i + s + HOUR) / 86.4) % 1000, 3);
                },
                /**
                 * 12-Hours: `1..12`
                 * @return {number}
                 */
                g: function () {
                    return fmt.G() % 12 || 12;
                },
                /**
                 * 24-Hours: `0..23`
                 * @return {number}
                 */
                G: function () {
                    return vDate.getHours();
                },
                /**
                 * 12-Hours with leading 0: `01..12`
                 * @return {string}
                 */
                h: function () {
                    return _lpad(fmt.g(), 2);
                },
                /**
                 * 24-Hours w/leading 0: `00..23`
                 * @return {string}
                 */
                H: function () {
                    return _lpad(fmt.G(), 2);
                },
                /**
                 * Minutes w/leading 0: `00..59`
                 * @return {string}
                 */
                i: function () {
                    return _lpad(vDate.getMinutes(), 2);
                },
                /**
                 * Seconds w/leading 0: `00..59`
                 * @return {string}
                 */
                s: function () {
                    return _lpad(vDate.getSeconds(), 2);
                },
                /**
                 * Microseconds: `000000-999000`
                 * @return {string}
                 */
                u: function () {
                    return _lpad(vDate.getMilliseconds() * 1000, 6);
                },

                //////////////
                // TIMEZONE //
                //////////////
                /**
                 * Timezone identifier: `e.g. Atlantic/Azores, ...`
                 * @return {string}
                 */
                e: function () {
                    var str = /\((.*)\)/.exec(String(vDate))[1];
                    return str || 'Coordinated Universal Time';
                },
                /**
                 * DST observed? `0 or 1`
                 * @return {number}
                 */
                I: function () {
                    var a = new Date(fmt.Y(), 0), c = Date.UTC(fmt.Y(), 0),
                        b = new Date(fmt.Y(), 6), d = Date.UTC(fmt.Y(), 6);
                    return ((a - c) !== (b - d)) ? 1 : 0;
                },
                /**
                 * Difference to GMT in hour format: `e.g. +0200`
                 * @return {string}
                 */
                O: function () {
                    var tzo = vDate.getTimezoneOffset(), a = Math.abs(tzo);
                    return (tzo > 0 ? '-' : '+') + _lpad(Math.floor(a / 60) * 100 + a % 60, 4);
                },
                /**
                 * Difference to GMT with colon: `e.g. +02:00`
                 * @return {string}
                 */
                P: function () {
                    var O = fmt.O();
                    return (O.substr(0, 3) + ':' + O.substr(3, 2));
                },
                /**
                 * Timezone abbreviation: `e.g. EST, MDT, ...`
                 * @return {string}
                 */
                T: function () {
                    var str = (String(vDate).match(self.tzParts) || [""]).pop().replace(self.tzClip, "");
                    return str || 'UTC';
                },
                /**
                 * Timezone offset in seconds: `-43200...50400`
                 * @return {number}
                 */
                Z: function () {
                    return -vDate.getTimezoneOffset() * 60;
                },

                ////////////////////
                // FULL DATE TIME //
                ////////////////////
                /**
                 * ISO-8601 date
                 * @return {string}
                 */
                c: function () {
                    return 'Y-m-d\\TH:i:sP'.replace(backslash, doFormat);
                },
                /**
                 * RFC 2822 date
                 * @return {string}
                 */
                r: function () {
                    return 'D, d M Y H:i:s O'.replace(backslash, doFormat);
                },
                /**
                 * Seconds since UNIX epoch
                 * @return {number}
                 */
                U: function () {
                    return vDate.getTime() / 1000 || 0;
                }
            };
            return doFormat(vChar, vChar);
        },
        formatDate: function (vDate, vFormat) {
            var self = this, i, n, len, str, vChar, vDateStr = '', BACKSLASH = '\\';
            if (typeof vDate === 'string') {
                vDate = self.parseDate(vDate, vFormat);
                if (!vDate) {
                    return null;
                }
            }
            if (vDate instanceof Date) {
                len = vFormat.length;
                for (i = 0; i < len; i++) {
                    vChar = vFormat.charAt(i);
                    if (vChar === 'S' || vChar === BACKSLASH) {
                        continue;
                    }
                    if (i > 0 && vFormat.charAt(i - 1) === BACKSLASH) {
                        vDateStr += vChar;
                        continue;
                    }
                    if (vChar === 'a') {
                        if (i + 1 < len) {
                            var nxtvChar = vFormat.charAt(i + 1);
                            if (nxtvChar === "t") {
                                vDateStr += vChar;
                                continue;
                            }
                        }
                    }
                    if (vChar === 't') {
                        if (i + 1 < len) {
                            var prevChar = vFormat.charAt(i - 1);
                            if (prevChar === "a") {
                                vDateStr += vChar;
                                continue;
                            }
                        }
                    }
                    str = self.parseFormat(vChar, vDate);
                    if (i !== (len - 1) && self.intParts.test(vChar) && vFormat.charAt(i + 1) === 'S') {
                        n = parseInt(str) || 0;
                        str += self.dateSettings.ordinal(n);
                    }
                    vDateStr += str;
                }
                return vDateStr;
            }
            return '';
        }
    };
})();
/**
 * @preserve jQuery DateTimePicker plugin v2.5.4
 * @homepage http://xdsoft.net/jqplugins/datetimepicker/
 * @author Chupurnov Valeriy (<chupurnov@gmail.com>)
 */
/*global DateFormatter, document,window,jQuery,setTimeout,clearTimeout,HighlightedDate,getCurrentValue*/
; (function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery', 'jquery-mousewheel'], factory);
    } else if (typeof exports === 'object') {
        // Node/CommonJS style for Browserify
        module.exports = factory;
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {
    'use strict';
    var default_options = {
        i18n: {
            ar: { // Arabic
                months: [
					"كانون الثاني", "شباط", "آذار", "نيسان", "مايو", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"
                ],
                dayOfWeekShort: [
					"ن", "ث", "ع", "خ", "ج", "س", "ح"
                ],
                dayOfWeek: ["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت", "الأحد"]
            },
            ro: { // Romanian
                months: [
					"Ianuarie", "Februarie", "Martie", "Aprilie", "Mai", "Iunie", "Iulie", "August", "Septembrie", "Octombrie", "Noiembrie", "Decembrie"
                ],
                dayOfWeekShort: [
					"Du", "Lu", "Ma", "Mi", "Jo", "Vi", "Sâ"
                ],
                dayOfWeek: ["Duminică", "Luni", "Marţi", "Miercuri", "Joi", "Vineri", "Sâmbătă"]
            },
            id: { // Indonesian
                months: [
					"Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"
                ],
                dayOfWeekShort: [
					"Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"
                ],
                dayOfWeek: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"]
            },
            is: { // Icelandic
                months: [
					"Janúar", "Febrúar", "Mars", "Apríl", "Maí", "Júní", "Júlí", "Ágúst", "September", "Október", "Nóvember", "Desember"
                ],
                dayOfWeekShort: [
					"Sun", "Mán", "Þrið", "Mið", "Fim", "Fös", "Lau"
                ],
                dayOfWeek: ["Sunnudagur", "Mánudagur", "Þriðjudagur", "Miðvikudagur", "Fimmtudagur", "Föstudagur", "Laugardagur"]
            },
            bg: { // Bulgarian
                months: [
					"Януари", "Февруари", "Март", "Април", "Май", "Юни", "Юли", "Август", "Септември", "Октомври", "Ноември", "Декември"
                ],
                dayOfWeekShort: [
					"Нд", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"
                ],
                dayOfWeek: ["Неделя", "Понеделник", "Вторник", "Сряда", "Четвъртък", "Петък", "Събота"]
            },
            fa: { // Persian/Farsi
                months: [
					'فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'
                ],
                dayOfWeekShort: [
					'یکشنبه', 'دوشنبه', 'سه شنبه', 'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'
                ],
                dayOfWeek: ["یک‌شنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنج‌شنبه", "جمعه", "شنبه", "یک‌شنبه"]
            },
            ru: { // Russian
                months: [
					'Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'
                ],
                dayOfWeekShort: [
					"Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"
                ],
                dayOfWeek: ["Воскресенье", "Понедельник", "Вторник", "Среда", "Четверг", "Пятница", "Суббота"]
            },
            uk: { // Ukrainian
                months: [
					'Січень', 'Лютий', 'Березень', 'Квітень', 'Травень', 'Червень', 'Липень', 'Серпень', 'Вересень', 'Жовтень', 'Листопад', 'Грудень'
                ],
                dayOfWeekShort: [
					"Ндл", "Пнд", "Втр", "Срд", "Чтв", "Птн", "Сбт"
                ],
                dayOfWeek: ["Неділя", "Понеділок", "Вівторок", "Середа", "Четвер", "П'ятниця", "Субота"]
            },
            en: { // English
                months: [
					"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
                ],
                dayOfWeekShort: [
					"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"
                ],
                dayOfWeek: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
            },
            el: { // Ελληνικά
                months: [
					"Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"
                ],
                dayOfWeekShort: [
					"Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"
                ],
                dayOfWeek: ["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"]
            },
            de: { // German
                months: [
					'Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'
                ],
                dayOfWeekShort: [
					"So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"
                ],
                dayOfWeek: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]
            },
            nl: { // Dutch
                months: [
					"januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"
                ],
                dayOfWeekShort: [
					"zo", "ma", "di", "wo", "do", "vr", "za"
                ],
                dayOfWeek: ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"]
            },
            tr: { // Turkish
                months: [
					"Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"
                ],
                dayOfWeekShort: [
					"Paz", "Pts", "Sal", "Çar", "Per", "Cum", "Cts"
                ],
                dayOfWeek: ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"]
            },
            fr: { //French
                months: [
					"Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre"
                ],
                dayOfWeekShort: [
					"Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"
                ],
                dayOfWeek: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]
            },
            es: { // Spanish
                months: [
					"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
                ],
                dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"
                ],
                dayOfWeek: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"]
            },
            th: { // Thai
                months: [
					'มกราคม', 'กุมภาพันธ์', 'มีนาคม', 'เมษายน', 'พฤษภาคม', 'มิถุนายน', 'กรกฎาคม', 'สิงหาคม', 'กันยายน', 'ตุลาคม', 'พฤศจิกายน', 'ธันวาคม'
                ],
                dayOfWeekShort: [
					'อา.', 'จ.', 'อ.', 'พ.', 'พฤ.', 'ศ.', 'ส.'
                ],
                dayOfWeek: ["อาทิตย์", "จันทร์", "อังคาร", "พุธ", "พฤหัส", "ศุกร์", "เสาร์", "อาทิตย์"]
            },
            pl: { // Polish
                months: [
					"styczeń", "luty", "marzec", "kwiecień", "maj", "czerwiec", "lipiec", "sierpień", "wrzesień", "październik", "listopad", "grudzień"
                ],
                dayOfWeekShort: [
					"nd", "pn", "wt", "śr", "cz", "pt", "sb"
                ],
                dayOfWeek: ["niedziela", "poniedziałek", "wtorek", "środa", "czwartek", "piątek", "sobota"]
            },
            pt: { // Portuguese
                months: [
					"Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"
                ],
                dayOfWeekShort: [
					"Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"
                ],
                dayOfWeek: ["Domingo", "Segunda", "Terça", "Quarta", "Quinta", "Sexta", "Sábado"]
            },
            ch: { // Simplified Chinese
                months: [
					"一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"
                ],
                dayOfWeekShort: [
					"日", "一", "二", "三", "四", "五", "六"
                ]
            },
            se: { // Swedish
                months: [
					"Januari", "Februari", "Mars", "April", "Maj", "Juni", "Juli", "Augusti", "September", "Oktober", "November", "December"
                ],
                dayOfWeekShort: [
					"Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"
                ]
            },
            km: { // Khmer
                months: [
                    "មករា​", "កុម្ភៈ", "មិនា​", "មេសា​", "ឧសភា​", "មិថុនា​", "កក្កដា​", "សីហា​", "កញ្ញា​", "តុលា​", "វិច្ឋិកា​", "ធ្នូ​"
                ],
                dayOfWeekShort: ["អាទិ​", "ចន្ទ​", "អង្គារ​", "ពុធ​", "ព្រហ​​", "សុក្រ​", "សៅរ៍"],
                dayOfWeek: ["អាទិត្យ​", "ចន្ទ​", "អង្គារ​", "ពុធ​", "ព្រហស្បតិ៍​", "សុក្រ​", "សៅរ៍"]
            },
            kr: { // Korean
                months: [
					"1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"
                ],
                dayOfWeekShort: [
					"일", "월", "화", "수", "목", "금", "토"
                ],
                dayOfWeek: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"]
            },
            it: { // Italian
                months: [
					"Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"
                ],
                dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"
                ],
                dayOfWeek: ["Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"]
            },
            da: { // Dansk
                months: [
					"January", "Februar", "Marts", "April", "Maj", "Juni", "July", "August", "September", "Oktober", "November", "December"
                ],
                dayOfWeekShort: [
					"Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"
                ],
                dayOfWeek: ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"]
            },
            no: { // Norwegian
                months: [
					"Januar", "Februar", "Mars", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Desember"
                ],
                dayOfWeekShort: [
					"Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"
                ],
                dayOfWeek: ['Søndag', 'Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag']
            },
            ja: { // Japanese
                months: [
					"1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"
                ],
                dayOfWeekShort: [
					"日", "月", "火", "水", "木", "金", "土"
                ],
                dayOfWeek: ["日曜", "月曜", "火曜", "水曜", "木曜", "金曜", "土曜"]
            },
            vi: { // Vietnamese
                months: [
					"Tháng 1", "Tháng 2", "Tháng 3", "Tháng 4", "Tháng 5", "Tháng 6", "Tháng 7", "Tháng 8", "Tháng 9", "Tháng 10", "Tháng 11", "Tháng 12"
                ],
                dayOfWeekShort: [
					"CN", "T2", "T3", "T4", "T5", "T6", "T7"
                ],
                dayOfWeek: ["Chủ nhật", "Thứ hai", "Thứ ba", "Thứ tư", "Thứ năm", "Thứ sáu", "Thứ bảy"]
            },
            sl: { // Slovenščina
                months: [
					"Januar", "Februar", "Marec", "April", "Maj", "Junij", "Julij", "Avgust", "September", "Oktober", "November", "December"
                ],
                dayOfWeekShort: [
					"Ned", "Pon", "Tor", "Sre", "Čet", "Pet", "Sob"
                ],
                dayOfWeek: ["Nedelja", "Ponedeljek", "Torek", "Sreda", "Četrtek", "Petek", "Sobota"]
            },
            cs: { // Čeština
                months: [
					"Leden", "Únor", "Březen", "Duben", "Květen", "Červen", "Červenec", "Srpen", "Září", "Říjen", "Listopad", "Prosinec"
                ],
                dayOfWeekShort: [
					"Ne", "Po", "Út", "St", "Čt", "Pá", "So"
                ]
            },
            hu: { // Hungarian
                months: [
					"Január", "Február", "Március", "Április", "Május", "Június", "Július", "Augusztus", "Szeptember", "Október", "November", "December"
                ],
                dayOfWeekShort: [
					"Va", "Hé", "Ke", "Sze", "Cs", "Pé", "Szo"
                ],
                dayOfWeek: ["vasárnap", "hétfő", "kedd", "szerda", "csütörtök", "péntek", "szombat"]
            },
            az: { //Azerbaijanian (Azeri)
                months: [
					"Yanvar", "Fevral", "Mart", "Aprel", "May", "Iyun", "Iyul", "Avqust", "Sentyabr", "Oktyabr", "Noyabr", "Dekabr"
                ],
                dayOfWeekShort: [
					"B", "Be", "Ça", "Ç", "Ca", "C", "Ş"
                ],
                dayOfWeek: ["Bazar", "Bazar ertəsi", "Çərşənbə axşamı", "Çərşənbə", "Cümə axşamı", "Cümə", "Şənbə"]
            },
            bs: { //Bosanski
                months: [
					"Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"
                ],
                dayOfWeekShort: [
					"Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"
                ],
                dayOfWeek: ["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"]
            },
            ca: { //Català
                months: [
					"Gener", "Febrer", "Març", "Abril", "Maig", "Juny", "Juliol", "Agost", "Setembre", "Octubre", "Novembre", "Desembre"
                ],
                dayOfWeekShort: [
					"Dg", "Dl", "Dt", "Dc", "Dj", "Dv", "Ds"
                ],
                dayOfWeek: ["Diumenge", "Dilluns", "Dimarts", "Dimecres", "Dijous", "Divendres", "Dissabte"]
            },
            'en-GB': { //English (British)
                months: [
					"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
                ],
                dayOfWeekShort: [
					"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"
                ],
                dayOfWeek: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
            },
            et: { //"Eesti"
                months: [
					"Jaanuar", "Veebruar", "Märts", "Aprill", "Mai", "Juuni", "Juuli", "August", "September", "Oktoober", "November", "Detsember"
                ],
                dayOfWeekShort: [
					"P", "E", "T", "K", "N", "R", "L"
                ],
                dayOfWeek: ["Pühapäev", "Esmaspäev", "Teisipäev", "Kolmapäev", "Neljapäev", "Reede", "Laupäev"]
            },
            eu: { //Euskara
                months: [
					"Urtarrila", "Otsaila", "Martxoa", "Apirila", "Maiatza", "Ekaina", "Uztaila", "Abuztua", "Iraila", "Urria", "Azaroa", "Abendua"
                ],
                dayOfWeekShort: [
					"Ig.", "Al.", "Ar.", "Az.", "Og.", "Or.", "La."
                ],
                dayOfWeek: ['Igandea', 'Astelehena', 'Asteartea', 'Asteazkena', 'Osteguna', 'Ostirala', 'Larunbata']
            },
            fi: { //Finnish (Suomi)
                months: [
					"Tammikuu", "Helmikuu", "Maaliskuu", "Huhtikuu", "Toukokuu", "Kesäkuu", "Heinäkuu", "Elokuu", "Syyskuu", "Lokakuu", "Marraskuu", "Joulukuu"
                ],
                dayOfWeekShort: [
					"Su", "Ma", "Ti", "Ke", "To", "Pe", "La"
                ],
                dayOfWeek: ["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"]
            },
            gl: { //Galego
                months: [
					"Xan", "Feb", "Maz", "Abr", "Mai", "Xun", "Xul", "Ago", "Set", "Out", "Nov", "Dec"
                ],
                dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mer", "Xov", "Ven", "Sab"
                ],
                dayOfWeek: ["Domingo", "Luns", "Martes", "Mércores", "Xoves", "Venres", "Sábado"]
            },
            hr: { //Hrvatski
                months: [
					"Siječanj", "Veljača", "Ožujak", "Travanj", "Svibanj", "Lipanj", "Srpanj", "Kolovoz", "Rujan", "Listopad", "Studeni", "Prosinac"
                ],
                dayOfWeekShort: [
					"Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"
                ],
                dayOfWeek: ["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"]
            },
            ko: { //Korean (한국어)
                months: [
					"1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"
                ],
                dayOfWeekShort: [
					"일", "월", "화", "수", "목", "금", "토"
                ],
                dayOfWeek: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"]
            },
            lt: { //Lithuanian (lietuvių)
                months: [
					"Sausio", "Vasario", "Kovo", "Balandžio", "Gegužės", "Birželio", "Liepos", "Rugpjūčio", "Rugsėjo", "Spalio", "Lapkričio", "Gruodžio"
                ],
                dayOfWeekShort: [
					"Sek", "Pir", "Ant", "Tre", "Ket", "Pen", "Šeš"
                ],
                dayOfWeek: ["Sekmadienis", "Pirmadienis", "Antradienis", "Trečiadienis", "Ketvirtadienis", "Penktadienis", "Šeštadienis"]
            },
            lv: { //Latvian (Latviešu)
                months: [
					"Janvāris", "Februāris", "Marts", "Aprīlis ", "Maijs", "Jūnijs", "Jūlijs", "Augusts", "Septembris", "Oktobris", "Novembris", "Decembris"
                ],
                dayOfWeekShort: [
					"Sv", "Pr", "Ot", "Tr", "Ct", "Pk", "St"
                ],
                dayOfWeek: ["Svētdiena", "Pirmdiena", "Otrdiena", "Trešdiena", "Ceturtdiena", "Piektdiena", "Sestdiena"]
            },
            mk: { //Macedonian (Македонски)
                months: [
					"јануари", "февруари", "март", "април", "мај", "јуни", "јули", "август", "септември", "октомври", "ноември", "декември"
                ],
                dayOfWeekShort: [
					"нед", "пон", "вто", "сре", "чет", "пет", "саб"
                ],
                dayOfWeek: ["Недела", "Понеделник", "Вторник", "Среда", "Четврток", "Петок", "Сабота"]
            },
            mn: { //Mongolian (Монгол)
                months: [
					"1-р сар", "2-р сар", "3-р сар", "4-р сар", "5-р сар", "6-р сар", "7-р сар", "8-р сар", "9-р сар", "10-р сар", "11-р сар", "12-р сар"
                ],
                dayOfWeekShort: [
					"Дав", "Мяг", "Лха", "Пүр", "Бсн", "Бям", "Ням"
                ],
                dayOfWeek: ["Даваа", "Мягмар", "Лхагва", "Пүрэв", "Баасан", "Бямба", "Ням"]
            },
            'pt-BR': { //Português(Brasil)
                months: [
					"Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"
                ],
                dayOfWeekShort: [
					"Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"
                ],
                dayOfWeek: ["Domingo", "Segunda", "Terça", "Quarta", "Quinta", "Sexta", "Sábado"]
            },
            sk: { //Slovenčina
                months: [
					"Január", "Február", "Marec", "Apríl", "Máj", "Jún", "Júl", "August", "September", "Október", "November", "December"
                ],
                dayOfWeekShort: [
					"Ne", "Po", "Ut", "St", "Št", "Pi", "So"
                ],
                dayOfWeek: ["Nedeľa", "Pondelok", "Utorok", "Streda", "Štvrtok", "Piatok", "Sobota"]
            },
            sq: { //Albanian (Shqip)
                months: [
					"Janar", "Shkurt", "Mars", "Prill", "Maj", "Qershor", "Korrik", "Gusht", "Shtator", "Tetor", "Nëntor", "Dhjetor"
                ],
                dayOfWeekShort: [
					"Die", "Hën", "Mar", "Mër", "Enj", "Pre", "Shtu"
                ],
                dayOfWeek: ["E Diel", "E Hënë", "E Martē", "E Mërkurë", "E Enjte", "E Premte", "E Shtunë"]
            },
            'sr-YU': { //Serbian (Srpski)
                months: [
					"Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"
                ],
                dayOfWeekShort: [
					"Ned", "Pon", "Uto", "Sre", "čet", "Pet", "Sub"
                ],
                dayOfWeek: ["Nedelja", "Ponedeljak", "Utorak", "Sreda", "Četvrtak", "Petak", "Subota"]
            },
            sr: { //Serbian Cyrillic (Српски)
                months: [
					"јануар", "фебруар", "март", "април", "мај", "јун", "јул", "август", "септембар", "октобар", "новембар", "децембар"
                ],
                dayOfWeekShort: [
					"нед", "пон", "уто", "сре", "чет", "пет", "суб"
                ],
                dayOfWeek: ["Недеља", "Понедељак", "Уторак", "Среда", "Четвртак", "Петак", "Субота"]
            },
            sv: { //Svenska
                months: [
					"Januari", "Februari", "Mars", "April", "Maj", "Juni", "Juli", "Augusti", "September", "Oktober", "November", "December"
                ],
                dayOfWeekShort: [
					"Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"
                ],
                dayOfWeek: ["Söndag", "Måndag", "Tisdag", "Onsdag", "Torsdag", "Fredag", "Lördag"]
            },
            'zh-TW': { //Traditional Chinese (繁體中文)
                months: [
					"一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"
                ],
                dayOfWeekShort: [
					"日", "一", "二", "三", "四", "五", "六"
                ],
                dayOfWeek: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"]
            },
            zh: { //Simplified Chinese (简体中文)
                months: [
					"一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"
                ],
                dayOfWeekShort: [
					"日", "一", "二", "三", "四", "五", "六"
                ],
                dayOfWeek: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"]
            },
            he: { //Hebrew (עברית)
                months: [
					'ינואר', 'פברואר', 'מרץ', 'אפריל', 'מאי', 'יוני', 'יולי', 'אוגוסט', 'ספטמבר', 'אוקטובר', 'נובמבר', 'דצמבר'
                ],
                dayOfWeekShort: [
					'א\'', 'ב\'', 'ג\'', 'ד\'', 'ה\'', 'ו\'', 'שבת'
                ],
                dayOfWeek: ["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת", "ראשון"]
            },
            hy: { // Armenian
                months: [
					"Հունվար", "Փետրվար", "Մարտ", "Ապրիլ", "Մայիս", "Հունիս", "Հուլիս", "Օգոստոս", "Սեպտեմբեր", "Հոկտեմբեր", "Նոյեմբեր", "Դեկտեմբեր"
                ],
                dayOfWeekShort: [
					"Կի", "Երկ", "Երք", "Չոր", "Հնգ", "Ուրբ", "Շբթ"
                ],
                dayOfWeek: ["Կիրակի", "Երկուշաբթի", "Երեքշաբթի", "Չորեքշաբթի", "Հինգշաբթի", "Ուրբաթ", "Շաբաթ"]
            },
            kg: { // Kyrgyz
                months: [
					'Үчтүн айы', 'Бирдин айы', 'Жалган Куран', 'Чын Куран', 'Бугу', 'Кулжа', 'Теке', 'Баш Оона', 'Аяк Оона', 'Тогуздун айы', 'Жетинин айы', 'Бештин айы'
                ],
                dayOfWeekShort: [
					"Жек", "Дүй", "Шей", "Шар", "Бей", "Жум", "Ише"
                ],
                dayOfWeek: [
					"Жекшемб", "Дүйшөмб", "Шейшемб", "Шаршемб", "Бейшемби", "Жума", "Ишенб"
                ]
            },
            rm: { // Romansh
                months: [
					"Schaner", "Favrer", "Mars", "Avrigl", "Matg", "Zercladur", "Fanadur", "Avust", "Settember", "October", "November", "December"
                ],
                dayOfWeekShort: [
					"Du", "Gli", "Ma", "Me", "Gie", "Ve", "So"
                ],
                dayOfWeek: [
					"Dumengia", "Glindesdi", "Mardi", "Mesemna", "Gievgia", "Venderdi", "Sonda"
                ]
            },
            ka: { // Georgian
                months: [
					'იანვარი', 'თებერვალი', 'მარტი', 'აპრილი', 'მაისი', 'ივნისი', 'ივლისი', 'აგვისტო', 'სექტემბერი', 'ოქტომბერი', 'ნოემბერი', 'დეკემბერი'
                ],
                dayOfWeekShort: [
					"კვ", "ორშ", "სამშ", "ოთხ", "ხუთ", "პარ", "შაბ"
                ],
                dayOfWeek: ["კვირა", "ორშაბათი", "სამშაბათი", "ოთხშაბათი", "ხუთშაბათი", "პარასკევი", "შაბათი"]
            }
        },

        ownerDocument: document,
        contentWindow: window,

        value: '',
        rtl: false,

        format: 'YYYY/M/D h:mm',
        formatTime: 'h:mm',
        formatDate: 'MMM DD,YYYY',

        startDate: false, // new Date(), '1986/12/08', '-1970/01/05','-1970/01/05',
        step: 60,
        monthChangeSpinner: true,

        closeOnDateSelect: false,
        closeOnTimeSelect: true,
        closeOnWithoutClick: true,
        closeOnInputClick: true,

        timepicker: true,
        datepicker: true,
        weeks: false,

        defaultTime: false,	// use formatTime format (ex. '10:00' for formatTime:	'H:i')
        defaultDate: false,	// use formatDate format (ex new Date() or '1986/12/08' or '-1970/01/05' or '-1970/01/05')

        minDate: false,
        maxDate: false,
        minTime: false,
        maxTime: false,
        disabledMinTime: false,
        disabledMaxTime: false,

        allowTimes: [],
        opened: false,
        initTime: true,
        inline: false,
        theme: '',

        onSelectDate: function () { },
        onSelectTime: function () { },
        onChangeMonth: function () { },
        onGetWeekOfYear: function () { },
        onChangeYear: function () { },
        onChangeDateTime: function () { },
        onShow: function () { },
        onClose: function () { },
        onGenerate: function () { },

        withoutCopyright: true,
        inverseButton: false,
        hours12: false,
        next: 'xdsoft_next',
        prev: 'xdsoft_prev',
        dayOfWeekStart: 0,
        parentID: 'body',
        timeHeightInTimePicker: 34,
        timepickerScrollbar: true,
        todayButton: true,
        prevButton: true,
        nextButton: true,
        defaultSelect: true,

        scrollMonth: true,
        scrollTime: true,
        scrollInput: false,

        lazyInit: false,
        mask: false,
        validateOnBlur: true,
        allowBlank: true,
        yearStart: 2008,
        yearEnd: 2050,
        monthStart: 0,
        monthEnd: 11,
        style: '',
        id: '',
        fixed: false,
        roundTime: 'round', // ceil, floor
        className: '',
        weekends: [],
        highlightedDates: [],
        highlightedPeriods: [],
        allowDates: [],
        allowDateRe: null,
        disabledDates: [],
        disabledWeekDays: [],        
        yearOffset: 0,
        beforeShowDay: null,

        enterLikeTab: true,
        //showApplyButton: true,
        //showCancelButton: true,
        showOkCloseButtons: true
    };

    var dateHelper = null,
		globalLocaleDefault = 'en',
		globalLocale = 'en';

    var dateFormatterOptionsDefault = {
        meridiem: ['AM', 'PM']
    };

    var initDateFormatter = function () {
        var locale = default_options.i18n[globalLocale],
			opts = {
			    days: locale.dayOfWeek,
			    daysShort: locale.dayOfWeekShort,
			    months: locale.months,
			    monthsShort: $.map(locale.months, function (n) { return n.substring(0, 3) })
			};

        if (typeof DateFormatter === 'function') {
            dateHelper = new DateFormatter({
                dateSettings: $.extend({}, dateFormatterOptionsDefault, opts)
            });
        }
    };

    // for locale settings
    $.datetimepicker = {
        setLocale: function (locale) {
            var newLocale = default_options.i18n[locale] ? locale : globalLocaleDefault;
            if (globalLocale != newLocale) {
                globalLocale = newLocale;
                // reinit date formatter
                initDateFormatter();
            }
        },
        setDateFormatter: function (dateFormatter) {
            dateHelper = dateFormatter;
        },
        RFC_2822: 'D, d M Y H:i:s O',
        ATOM: 'Y-m-d\TH:i:sP',
        ISO_8601: 'Y-m-d\TH:i:sO',
        RFC_822: 'D, d M y H:i:s O',
        RFC_850: 'l, d-M-y H:i:s T',
        RFC_1036: 'D, d M y H:i:s O',
        RFC_1123: 'D, d M Y H:i:s O',
        RSS: 'D, d M Y H:i:s O',
        W3C: 'Y-m-d\TH:i:sP'
    };

    // first init date formatter
    initDateFormatter();

    // fix for ie8
    if (!window.getComputedStyle) {
        window.getComputedStyle = function (el, pseudo) {
            this.el = el;
            this.getPropertyValue = function (prop) {
                var re = /(\-([a-z]){1})/g;
                if (prop === 'float') {
                    prop = 'styleFloat';
                }
                if (re.test(prop)) {
                    prop = prop.replace(re, function (a, b, c) {
                        return c.toUpperCase();
                    });
                }
                return el.currentStyle[prop] || null;
            };
            return this;
        };
    }
    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (obj, start) {
            var i, j;
            for (i = (start || 0), j = this.length; i < j; i += 1) {
                if (this[i] === obj) { return i; }
            }
            return -1;
        };
    }
    Date.prototype.countDaysInMonth = function () {
        return new Date(this.getFullYear(), this.getMonth() + 1, 0).getDate();
    };
    $.fn.xdsoftScroller = function (options, percent) {
        return this.each(function () {
            var timeboxparent = $(this),
				pointerEventToXY = function (e) {
				    var out = { x: 0, y: 0 },
						touch;
				    if (e.type === 'touchstart' || e.type === 'touchmove' || e.type === 'touchend' || e.type === 'touchcancel') {
				        touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
				        out.x = touch.clientX;
				        out.y = touch.clientY;
				    } else if (e.type === 'mousedown' || e.type === 'mouseup' || e.type === 'mousemove' || e.type === 'mouseover' || e.type === 'mouseout' || e.type === 'mouseenter' || e.type === 'mouseleave') {
				        out.x = e.clientX;
				        out.y = e.clientY;
				    }
				    return out;
				},
				timebox,
				parentHeight,
				height,
				scrollbar,
				scroller,
				maximumOffset = 100,
				start = false,
				startY = 0,
				startTop = 0,
				h1 = 0,
				touchStart = false,
				startTopScroll = 0,
				calcOffset = function () { };
            if (percent === 'hide') {
                timeboxparent.find('.xdsoft_scrollbar').hide();
                return;
            }
            if (!$(this).hasClass('xdsoft_scroller_box')) {
                timebox = timeboxparent.children().eq(0);
                parentHeight = timeboxparent[0].clientHeight;
                height = timebox[0].offsetHeight;
                scrollbar = $('<div class="xdsoft_scrollbar"></div>');
                scroller = $('<div class="xdsoft_scroller"></div>');
                scrollbar.append(scroller);

                timeboxparent.addClass('xdsoft_scroller_box').append(scrollbar);
                calcOffset = function calcOffset(event) {
                    var offset = pointerEventToXY(event).y - startY + startTopScroll;
                    if (offset < 0) {
                        offset = 0;
                    }
                    if (offset + scroller[0].offsetHeight > h1) {
                        offset = h1 - scroller[0].offsetHeight;
                    }
                    timeboxparent.trigger('scroll_element.xdsoft_scroller', [maximumOffset ? offset / maximumOffset : 0]);
                };

                scroller
					.on('touchstart.xdsoft_scroller mousedown.xdsoft_scroller', function (event) {
					    if (!parentHeight) {
					        timeboxparent.trigger('resize_scroll.xdsoft_scroller', [percent]);
					    }

					    startY = pointerEventToXY(event).y;
					    startTopScroll = parseInt(scroller.css('margin-top'), 10);
					    h1 = scrollbar[0].offsetHeight;

					    if (event.type === 'mousedown' || event.type === 'touchstart') {
					        if (options.ownerDocument) {
					            $(options.ownerDocument.body).addClass('xdsoft_noselect');
					        }
					        $([options.ownerDocument.body, options.contentWindow]).on('touchend mouseup.xdsoft_scroller', function arguments_callee() {
					            $([options.ownerDocument.body, options.contentWindow]).off('touchend mouseup.xdsoft_scroller', arguments_callee)
									.off('mousemove.xdsoft_scroller', calcOffset)
									.removeClass('xdsoft_noselect');
					        });
					        $(options.ownerDocument.body).on('mousemove.xdsoft_scroller', calcOffset);
					    } else {
					        touchStart = true;
					        event.stopPropagation();
					        event.preventDefault();
					    }
					})
					.on('touchmove', function (event) {
					    if (touchStart) {
					        event.preventDefault();
					        calcOffset(event);
					    }
					})
					.on('touchend touchcancel', function () {
					    touchStart = false;
					    startTopScroll = 0;
					});

                timeboxparent
					.on('scroll_element.xdsoft_scroller', function (event, percentage) {
					    if (!parentHeight) {
					        timeboxparent.trigger('resize_scroll.xdsoft_scroller', [percentage, true]);
					    }
					    percentage = percentage > 1 ? 1 : (percentage < 0 || isNaN(percentage)) ? 0 : percentage;

					    scroller.css('margin-top', maximumOffset * percentage);

					    setTimeout(function () {
					        timebox.css('marginTop', -parseInt((timebox[0].offsetHeight - parentHeight) * percentage, 10));
					    }, 10);
					})
					.on('resize_scroll.xdsoft_scroller', function (event, percentage, noTriggerScroll) {
					    var percent, sh;
					    parentHeight = timeboxparent[0].clientHeight;
					    height = timebox[0].offsetHeight;
					    percent = parentHeight / height;
					    sh = percent * scrollbar[0].offsetHeight;
					    if (percent > 1) {
					        scroller.hide();
					    } else {
					        scroller.show();
					        scroller.css('height', parseInt(sh > 10 ? sh : 10, 10));
					        maximumOffset = scrollbar[0].offsetHeight - scroller[0].offsetHeight;
					        if (noTriggerScroll !== true) {
					            timeboxparent.trigger('scroll_element.xdsoft_scroller', [percentage || Math.abs(parseInt(timebox.css('marginTop'), 10)) / (height - parentHeight)]);
					        }
					    }
					});

                timeboxparent.on('mousewheel', function (event) {
                    var top = Math.abs(parseInt(timebox.css('marginTop'), 10));

                    top = top - (event.deltaY * 20);
                    if (top < 0) {
                        top = 0;
                    }

                    timeboxparent.trigger('scroll_element.xdsoft_scroller', [top / (height - parentHeight)]);
                    event.stopPropagation();
                    return false;
                });

                timeboxparent.on('touchstart', function (event) {
                    start = pointerEventToXY(event);
                    startTop = Math.abs(parseInt(timebox.css('marginTop'), 10));
                });

                timeboxparent.on('touchmove', function (event) {
                    if (start) {
                        event.preventDefault();
                        var coord = pointerEventToXY(event);
                        timeboxparent.trigger('scroll_element.xdsoft_scroller', [(startTop - (coord.y - start.y)) / (height - parentHeight)]);
                    }
                });

                timeboxparent.on('touchend touchcancel', function () {
                    start = false;
                    startTop = 0;
                });
            }
            timeboxparent.trigger('resize_scroll.xdsoft_scroller', [percent]);
        });
    };

    $.fn.datetimepicker = function (opt, opt2) {
        var result = this,
			KEY0 = 48,
			KEY9 = 57,
			_KEY0 = 96,
			_KEY9 = 105,
			CTRLKEY = 17,
			DEL = 46,
			ENTER = 13,
			ESC = 27,
			BACKSPACE = 8,
			ARROWLEFT = 37,
			ARROWUP = 38,
			ARROWRIGHT = 39,
			ARROWDOWN = 40,
			TAB = 9,
			F5 = 116,
			AKEY = 65,
			CKEY = 67,
			VKEY = 86,
			ZKEY = 90,
			YKEY = 89,
			ctrlDown = false,
			options = ($.isPlainObject(opt) || !opt) ? $.extend(true, {}, default_options, opt) : $.extend(true, {}, default_options),

			lazyInitTimer = 0,
			createDateTimePicker,
			destroyDateTimePicker,

			lazyInit = function (input) {
			    input
					.on('open.xdsoft focusin.xdsoft mousedown.xdsoft touchstart', function initOnActionCallback() {
					    if (input.is(':disabled') || input.data('xdsoft_datetimepicker')) {
					        return;
					    }
					    clearTimeout(lazyInitTimer);
					    lazyInitTimer = setTimeout(function () {

					        if (!input.data('xdsoft_datetimepicker')) {
					            createDateTimePicker(input);
					        }
					        input
								.off('open.xdsoft focusin.xdsoft mousedown.xdsoft touchstart', initOnActionCallback)
								.trigger('open.xdsoft');
					    }, 100);
					});
			};
        createDateTimePicker = function (input) {
            var datetimepicker = $('<div class="xdsoft_datetimepicker xdsoft_noselect"></div>'),
				xdsoft_copyright = $('<div class="xdsoft_copyright"><a target="_blank" href="http://xdsoft.net/jqplugins/datetimepicker/">xdsoft.net</a></div>'),
				datepicker = $('<div class="xdsoft_datepicker active"></div>'),
				month_picker = $('<div class="xdsoft_monthpicker"><button type="button" class="xdsoft_prev">&#xf104;</button><button type="button" class="xdsoft_today_button"></button>' +
					'<div class="xdsoft_label xdsoft_month"><span></span><i>&#xf107;</i></div>' +
					'<div class="xdsoft_label xdsoft_year"><span></span><i>&#xf107;</i></div>' +
					'<button type="button" class="xdsoft_next">&#xf105</button></div>'),
				calendar = $('<div class="xdsoft_calendar"></div>'),
				timepicker = $('<div class="xdsoft_timepicker active"><button type="button" class="xdsoft_prev"></button><div class="xdsoft_time_box"></div><button type="button" class="xdsoft_next"></button></div>'),
				timeboxparent = timepicker.find('.xdsoft_time_box').eq(0),
				timebox = $('<div class="xdsoft_time_variant"></div>'),
				applyButton = $('<button type="button" class="xdsoft_save_button w-button-primary w-button border-radius3px">OK</button>'),
                cancelButton = $('<button type="button" class="xdsoft_cancel w-button-default w-button border-radius3px">Cancel</button>'),
                ButtonContainer = $('<div class="xdsoft_datepicker-buttons w-clearfix"></div>'),
                cancelButton = $('<button type="button" class="xdsoft_cancel w-button-default w-button border-radius3px">Cancel</button>'),
				monthselect = $('<div class="xdsoft_select xdsoft_monthselect"><div></div></div>'),
				yearselect = $('<div class="xdsoft_select xdsoft_yearselect"><div></div></div>'),
				triggerAfterOpen = false,
				XDSoft_datetime,

				xchangeTimer,
				timerclick,
				current_time_index,
				setPos,
				timer = 0,
				_xdsoft_datetime,
				forEachAncestorOf,
				throttle;

            if (options.id) {
                datetimepicker.attr('id', options.id);
            }
            if (options.style) {
                datetimepicker.attr('style', options.style);
            }
            if (options.weeks) {
                datetimepicker.addClass('xdsoft_showweeks');
            }
            if (options.rtl) {
                datetimepicker.addClass('xdsoft_rtl');
            }

            datetimepicker.addClass('xdsoft_' + options.theme);
            datetimepicker.addClass(options.className);

            month_picker
				.find('.xdsoft_month span')
					.after(monthselect);
            month_picker
				.find('.xdsoft_year span')
					.after(yearselect);

            month_picker
				.find('.xdsoft_month,.xdsoft_year')
					.on('touchstart mousedown.xdsoft', function (event) {
					    var select = $(this).find('.xdsoft_select').eq(0),
                            val = 0,
                            top = 0,
                            visible = select.is(':visible'),
                            items,
                            i;

					    month_picker
                            .find('.xdsoft_select')
                                .hide();
					    if (_xdsoft_datetime.currentTime) {
					        val = _xdsoft_datetime.currentTime[$(this).hasClass('xdsoft_month') ? 'getMonth' : 'getFullYear']();
					    }
					    $(".scroller_custom").removeClass("scroller_custom");
					    if (!visible) {
					        $(this).addClass("scroller_custom");
					    }
					    select[visible ? 'hide' : 'show']();
					    for (items = select.find('div.xdsoft_option'), i = 0; i < items.length; i += 1) {
					        if (items.eq(i).data('value') === val) {
					            break;
					        } else {
					            top += items[0].offsetHeight;
					        }
					    }

					    select.xdsoftScroller(options, top / (select.children()[0].offsetHeight - (select[0].clientHeight)));
					    event.stopPropagation();
					    return false;
					});

            month_picker
				.find('.xdsoft_select')
					.xdsoftScroller(options)
				.on('touchstart mousedown.xdsoft', function (event) {
				    event.stopPropagation();
				    event.preventDefault();
				})
                .on('touchmove', '.xdsoft_option', function (event) {                    
                    xdsoft_moveStart = true;
                })
				.on('touchend mousedown.xdsoft', '.xdsoft_option', function () {
				    if (typeof xdsoft_moveStart != 'undefined' && xdsoft_moveStart == true)
				    {
				        xdsoft_moveStart = false;
				        return;
				    }
				    if (_xdsoft_datetime.currentTime === undefined || _xdsoft_datetime.currentTime === null) {
				        _xdsoft_datetime.currentTime = _xdsoft_datetime.now();
				    }

				    var year = _xdsoft_datetime.currentTime.getFullYear();
				    if (_xdsoft_datetime && _xdsoft_datetime.currentTime) {
				        _xdsoft_datetime.currentTime[$(this).parent().parent().hasClass('xdsoft_monthselect') ? 'setMonth' : 'setFullYear']($(this).data('value'));
				    }

				    $(this).parent().parent().hide();
				    $(this).parent().parent().parent().removeClass("scroller_custom");
				    datetimepicker.trigger('xchange.xdsoft');
				    if (options.onChangeMonth && $.isFunction(options.onChangeMonth)) {
				        options.onChangeMonth.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'));
				    }

				    if (year !== _xdsoft_datetime.currentTime.getFullYear() && $.isFunction(options.onChangeYear)) {
				        options.onChangeYear.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'));
				    }
				});

            datetimepicker.getValue = function () {
                return _xdsoft_datetime.getCurrentTime();
            };

            datetimepicker.setOptions = function (_options) {
                var highlightedDates = {};

                options = $.extend(true, {}, options, _options);

                if (_options.allowTimes && $.isArray(_options.allowTimes) && _options.allowTimes.length) {
                    options.allowTimes = $.extend(true, [], _options.allowTimes);
                }

                if (_options.weekends && $.isArray(_options.weekends) && _options.weekends.length) {
                    options.weekends = $.extend(true, [], _options.weekends);
                }

                if (_options.allowDates && $.isArray(_options.allowDates) && _options.allowDates.length) {
                    options.allowDates = $.extend(true, [], _options.allowDates);
                }

                if (_options.allowDateRe && Object.prototype.toString.call(_options.allowDateRe) === "[object String]") {
                    options.allowDateRe = new RegExp(_options.allowDateRe);
                }

                if (_options.highlightedDates && $.isArray(_options.highlightedDates) && _options.highlightedDates.length) {
                    $.each(_options.highlightedDates, function (index, value) {
                        var splitData = $.map(value.split(','), $.trim),
							exDesc,
							hDate = new HighlightedDate(dateHelper.parseDate(splitData[0], options.formatDate), splitData[1], splitData[2]), // date, desc, style
							keyDate = dateHelper.formatDate(hDate.date, options.formatDate);
                        if (highlightedDates[keyDate] !== undefined) {
                            exDesc = highlightedDates[keyDate].desc;
                            if (exDesc && exDesc.length && hDate.desc && hDate.desc.length) {
                                highlightedDates[keyDate].desc = exDesc + "\n" + hDate.desc;
                            }
                        } else {
                            highlightedDates[keyDate] = hDate;
                        }
                    });

                    options.highlightedDates = $.extend(true, [], highlightedDates);
                }

                if (_options.highlightedPeriods && $.isArray(_options.highlightedPeriods) && _options.highlightedPeriods.length) {
                    highlightedDates = $.extend(true, [], options.highlightedDates);
                    $.each(_options.highlightedPeriods, function (index, value) {
                        var dateTest, // start date
							dateEnd,
							desc,
							hDate,
							keyDate,
							exDesc,
							style;
                        if ($.isArray(value)) {
                            dateTest = value[0];
                            dateEnd = value[1];
                            desc = value[2];
                            style = value[3];
                        }
                        else {
                            var splitData = $.map(value.split(','), $.trim);
                            dateTest = dateHelper.parseDate(splitData[0], options.formatDate);
                            dateEnd = dateHelper.parseDate(splitData[1], options.formatDate);
                            desc = splitData[2];
                            style = splitData[3];
                        }

                        while (dateTest <= dateEnd) {
                            hDate = new HighlightedDate(dateTest, desc, style);
                            keyDate = dateHelper.formatDate(dateTest, options.formatDate);
                            dateTest.setDate(dateTest.getDate() + 1);
                            if (highlightedDates[keyDate] !== undefined) {
                                exDesc = highlightedDates[keyDate].desc;
                                if (exDesc && exDesc.length && hDate.desc && hDate.desc.length) {
                                    highlightedDates[keyDate].desc = exDesc + "\n" + hDate.desc;
                                }
                            } else {
                                highlightedDates[keyDate] = hDate;
                            }
                        }
                    });

                    options.highlightedDates = $.extend(true, [], highlightedDates);
                }

                if (_options.disabledDates && $.isArray(_options.disabledDates) && _options.disabledDates.length) {
                    options.disabledDates = $.extend(true, [], _options.disabledDates);
                }

                if (_options.disabledWeekDays && $.isArray(_options.disabledWeekDays) && _options.disabledWeekDays.length) {
                    options.disabledWeekDays = $.extend(true, [], _options.disabledWeekDays);
                }

                if ((options.open || options.opened) && (!options.inline)) {
                    input.trigger('open.xdsoft');
                }

                if (options.inline) {
                    triggerAfterOpen = true;
                    datetimepicker.addClass('xdsoft_inline');
                    input.after(datetimepicker).hide();
                }

                if (options.inverseButton) {
                    options.next = 'xdsoft_prev';
                    options.prev = 'xdsoft_next';
                }

                if (options.datepicker) {
                    datepicker.addClass('active');
                } else {
                    datepicker.removeClass('active');
                }

                if (options.timepicker) {
                    timepicker.addClass('active');
                } else {
                    timepicker.removeClass('active');
                }

                if (options.value) {
                    _xdsoft_datetime.setCurrentTime(options.value);
                    if (input && input.val) {
                        input.val(_xdsoft_datetime.str);
                    }
                }

                if (isNaN(options.dayOfWeekStart)) {
                    options.dayOfWeekStart = 0;
                } else {
                    options.dayOfWeekStart = parseInt(options.dayOfWeekStart, 10) % 7;
                }

                if (!options.timepickerScrollbar) {
                    timeboxparent.xdsoftScroller(options, 'hide');
                }

                if (options.minDate && /^[\+\-](.*)$/.test(options.minDate)) {
                    options.minDate = dateHelper.formatDate(_xdsoft_datetime.strToDateTime(options.minDate), options.formatDate);
                }

                if (options.maxDate && /^[\+\-](.*)$/.test(options.maxDate)) {
                    options.maxDate = dateHelper.formatDate(_xdsoft_datetime.strToDateTime(options.maxDate), options.formatDate);
                }

                ButtonContainer.toggle(options.showOkCloseButtons);
                //applyButton.toggle(options.ButtonContainer);
                //cancelButton.toggle(options.ButtonContainer);
                
                month_picker
					.find('.xdsoft_today_button')
						.css('display', !options.todayButton ? 'none' : 'block');

                month_picker
					.find('.' + options.prev)
						.css('visibility', !options.prevButton ? 'hidden' : 'visible');

                month_picker
					.find('.' + options.next)
						.css('visibility', !options.nextButton ? 'hidden' : 'visible');

                setMask(options);

                if (options.validateOnBlur) {
                    input
						.off('blur.xdsoft')
						.on('blur.xdsoft', function () {
						    if (options.allowBlank && (!$.trim($(this).val()).length || (typeof options.mask == "string" && $.trim($(this).val()) === options.mask.replace(/[0-9]/g, '_')))) {
						        $(this).val(null);
						        datetimepicker.data('xdsoft_datetime').empty();
						    } else {
						        var d = dateHelper.parseDate($(this).val(), options.format);
						        if (d) { // parseDate() may skip some invalid parts like date or time, so make it clear for user: show parsed date/time
						            $(this).val(dateHelper.formatDate(d, options.format));
						        } else {
						            var splittedHours = +([$(this).val()[0], $(this).val()[1]].join('')),
										splittedMinutes = +([$(this).val()[2], $(this).val()[3]].join(''));

						            // parse the numbers as 0312 => 03:12
						            if (!options.datepicker && options.timepicker && splittedHours >= 0 && splittedHours < 24 && splittedMinutes >= 0 && splittedMinutes < 60) {
						                $(this).val([splittedHours, splittedMinutes].map(function (item) {
						                    return item > 9 ? item : '0' + item;
						                }).join(':'));
						            } else {
						                $(this).val(dateHelper.formatDate(_xdsoft_datetime.now(), options.format));
						            }
						        }
						        datetimepicker.data('xdsoft_datetime').setCurrentTime($(this).val());
						    }

						    datetimepicker.trigger('changedatetime.xdsoft');
						    datetimepicker.trigger('close.xdsoft');
						});
                }
                options.dayOfWeekStartPrev = (options.dayOfWeekStart === 0) ? 6 : options.dayOfWeekStart - 1;

                datetimepicker
					.trigger('xchange.xdsoft')
					.trigger('afterOpen.xdsoft');
            };

            datetimepicker
				.data('options', options)
				.on('touchstart mousedown.xdsoft', function (event) {
				    event.stopPropagation();
				    event.preventDefault();
				    yearselect.parent().removeClass("scroller_custom");
				    yearselect.hide();
				    monthselect.parent().removeClass("scroller_custom");
				    monthselect.hide();
				    return false;
				});

            //scroll_element = timepicker.find('.xdsoft_time_box');
            timeboxparent.append(timebox);
            timeboxparent.xdsoftScroller(options);

            datetimepicker.on('afterOpen.xdsoft', function () {
                timeboxparent.xdsoftScroller(options);
            });

            datetimepicker
				.append(datepicker)
				.append(timepicker)
                .append(ButtonContainer);
                

            if (options.withoutCopyright !== true) {
                datetimepicker
					.append(xdsoft_copyright);
            }

            ButtonContainer
                .append(cancelButton)
				.append(applyButton);

            datepicker
				.append(month_picker)
				.append(calendar);

            $(options.parentID)
				.append(datetimepicker);

            XDSoft_datetime = function () {
                var _this = this;
                _this.now = function (norecursion) {
                    var d = new Date(),
						date,
						time;

                    if (!norecursion && options.defaultDate) {
                        date = _this.strToDateTime(options.defaultDate);
                        d.setDate(1);
                        d.setFullYear(date.getFullYear());
                        d.setMonth(date.getMonth());
                        d.setDate(date.getDate());
                    }

                    if (options.yearOffset) {
                        d.setFullYear(d.getFullYear() + options.yearOffset);
                    }

                    if (!norecursion && options.defaultTime) {
                        time = _this.strtotime(options.defaultTime);
                        d.setHours(time.getHours());
                        d.setMinutes(time.getMinutes());
                    }
                    return d;
                };

                _this.isValidDate = function (d) {
                    if (Object.prototype.toString.call(d) !== "[object Date]") {
                        return false;
                    }
                    return !isNaN(d.getTime());
                };

                _this.setCurrentTime = function (dTime, requireValidDate) {
                    if (typeof dTime === 'string') {
                        _this.currentTime = _this.strToDateTime(dTime);
                    }
                    else if (_this.isValidDate(dTime)) {
                        _this.currentTime = dTime;
                    }
                    else if (!dTime && !requireValidDate && options.allowBlank) {
                        _this.currentTime = null;
                    }
                    else {
                        _this.currentTime = _this.now();
                    }

                    datetimepicker.trigger('xchange.xdsoft');
                };

                _this.empty = function () {
                    _this.currentTime = null;
                };

                _this.getCurrentTime = function (dTime) {
                    return _this.currentTime;
                };

                _this.nextMonth = function () {

                    if (_this.currentTime === undefined || _this.currentTime === null) {
                        _this.currentTime = _this.now();
                    }

                    var month = _this.currentTime.getMonth() + 1,
						year;
                    if (month === 12) {
                        if ((_this.currentTime.getFullYear() + 1) > options.yearEnd) {
                            $this.removeClass(options.next);
                        }

                        _this.currentTime.setFullYear(_this.currentTime.getFullYear() + 1);
                        month = 0;
                    }
                    year = _this.currentTime.getFullYear();

                    _this.currentTime.setDate(
						Math.min(
							new Date(_this.currentTime.getFullYear(), month + 1, 0).getDate(),
							_this.currentTime.getDate()
						)
					);
                    _this.currentTime.setMonth(month);

                    if (options.onChangeMonth && $.isFunction(options.onChangeMonth)) {
                        options.onChangeMonth.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'));
                    }

                    if (year !== _this.currentTime.getFullYear() && $.isFunction(options.onChangeYear)) {
                        options.onChangeYear.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'));
                    }

                    datetimepicker.trigger('xchange.xdsoft');
                    return month;
                };

                _this.prevMonth = function () {

                    if (_this.currentTime === undefined || _this.currentTime === null) {
                        _this.currentTime = _this.now();
                    }

                    var month = _this.currentTime.getMonth() - 1;
                    if (month === -1) {
                        if ((_this.currentTime.getFullYear() - 1) < options.yearStart) {
                            $this.removeClass(options.prev);
                        }

                        _this.currentTime.setFullYear(_this.currentTime.getFullYear() - 1);
                        month = 11;
                    }
                    _this.currentTime.setDate(
						Math.min(
							new Date(_this.currentTime.getFullYear(), month + 1, 0).getDate(),
							_this.currentTime.getDate()
						)
					);
                    _this.currentTime.setMonth(month);
                    if (options.onChangeMonth && $.isFunction(options.onChangeMonth)) {
                        options.onChangeMonth.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'));
                    }
                    datetimepicker.trigger('xchange.xdsoft');
                    return month;
                };

                _this.getWeekOfYear = function (datetime) {
                    if (options.onGetWeekOfYear && $.isFunction(options.onGetWeekOfYear)) {
                        var week = options.onGetWeekOfYear.call(datetimepicker, datetime);
                        if (typeof week !== 'undefined') {
                            return week;
                        }
                    }
                    var onejan = new Date(datetime.getFullYear(), 0, 1);
                    //First week of the year is th one with the first Thursday according to ISO8601
                    if (onejan.getDay() != 4)
                        onejan.setMonth(0, 1 + ((4 - onejan.getDay() + 7) % 7));
                    return Math.ceil((((datetime - onejan) / 86400000) + onejan.getDay() + 1) / 7);
                };

                _this.strToDateTime = function (sDateTime) {
                    var tmpDate = [], timeOffset, currentTime;

                    if (sDateTime && sDateTime instanceof Date && _this.isValidDate(sDateTime)) {
                        return sDateTime;
                    }

                    tmpDate = /^(\+|\-)(.*)$/.exec(sDateTime);
                    if (tmpDate) {
                        tmpDate[2] = dateHelper.parseDate(tmpDate[2], options.formatDate);
                    }
                    if (tmpDate && tmpDate[2]) {
                        timeOffset = tmpDate[2].getTime() - (tmpDate[2].getTimezoneOffset()) * 60000;
                        currentTime = new Date((_this.now(true)).getTime() + parseInt(tmpDate[1] + '1', 10) * timeOffset);
                    } else {

                        if (typeof (_xdsoft_datetime.currentTime) && _xdsoft_datetime.currentTime != null && _xdsoft_datetime.currentTime != "") {
                            currentTime = _xdsoft_datetime.currentTime;
                        }
                        else {
                            currentTime = sDateTime ? dateHelper.parseDate(sDateTime, options.format) : _this.now();
                        }
                    }

                    if (!_this.isValidDate(currentTime)) {
                        currentTime = _this.now();
                    }

                    return currentTime;
                };

                _this.strToDate = function (sDate) {
                    if (sDate && sDate instanceof Date && _this.isValidDate(sDate)) {
                        return sDate;
                    }

                    var currentTime = sDate ? dateHelper.parseDate(sDate, options.formatDate) : _this.now(true);
                    if (!_this.isValidDate(currentTime)) {
                        currentTime = _this.now(true);
                    }
                    return currentTime;
                };

                _this.strtotime = function (sTime) {
                    if (sTime && sTime instanceof Date && _this.isValidDate(sTime)) {
                        return sTime;
                    }
                    var currentTime = sTime ? dateHelper.parseDate(sTime, options.formatTime) : _this.now(true);
                    if (!_this.isValidDate(currentTime)) {
                        currentTime = _this.now(true);
                    }
                    return currentTime;
                };

                _this.str = function () {
                    return dateHelper.formatDate(_this.currentTime, options.format);
                };
                _this.currentTime = this.now();
            };

            _xdsoft_datetime = new XDSoft_datetime();

            applyButton.on('touchend click', function (e) {//pathbrite
                e.preventDefault();
                datetimepicker.data('changed', true);
                _xdsoft_datetime.setCurrentTime(getCurrentValue());
                input.val(_xdsoft_datetime.str());
                datetimepicker.trigger('close.xdsoft');
            });
            cancelButton.on('touchend click', function (e) {//pathbrite
                e.preventDefault();
                datetimepicker.trigger('close.xdsoft');
            });
            month_picker
				.find('.xdsoft_today_button')
				.on('touchend mousedown.xdsoft', function () {
				    datetimepicker.data('changed', true);
				    _xdsoft_datetime.setCurrentTime(0, true);
				    datetimepicker.trigger('afterOpen.xdsoft');
				}).on('dblclick.xdsoft', function () {
				    var currentDate = _xdsoft_datetime.getCurrentTime(), minDate, maxDate;
				    currentDate = new Date(currentDate.getFullYear(), currentDate.getMonth(), currentDate.getDate());
				    minDate = _xdsoft_datetime.strToDate(options.minDate);
				    minDate = new Date(minDate.getFullYear(), minDate.getMonth(), minDate.getDate());
				    if (currentDate < minDate) {
				        return;
				    }
				    maxDate = _xdsoft_datetime.strToDate(options.maxDate);
				    maxDate = new Date(maxDate.getFullYear(), maxDate.getMonth(), maxDate.getDate());
				    if (currentDate > maxDate) {
				        return;
				    }
				    input.val(_xdsoft_datetime.str());
				    input.trigger('change');
				    datetimepicker.trigger('close.xdsoft');
				});
            month_picker
				.find('.xdsoft_prev,.xdsoft_next')
				.on('touchend mousedown.xdsoft', function () {
				    var $this = $(this),
						timer = 0,
						stop = false;

				    (function arguments_callee1(v) {
				        if ($this.hasClass(options.next)) {
				            _xdsoft_datetime.nextMonth();
				        } else if ($this.hasClass(options.prev)) {
				            _xdsoft_datetime.prevMonth();
				        }
				        if (options.monthChangeSpinner) {
				            if (!stop) {
				                timer = setTimeout(arguments_callee1, v || 100);
				            }
				        }
				    }(500));

				    $([options.ownerDocument.body, options.contentWindow]).on('touchend mouseup.xdsoft', function arguments_callee2() {
				        clearTimeout(timer);
				        stop = true;
				        $([options.ownerDocument.body, options.contentWindow]).off('touchend mouseup.xdsoft', arguments_callee2);
				    });
				});

            timepicker
				.find('.xdsoft_prev,.xdsoft_next')
				.on('touchend mousedown.xdsoft', function () {
				    var $this = $(this),
						timer = 0,
						stop = false,
						period = 110;
				    (function arguments_callee4(v) {
				        var pheight = timeboxparent[0].clientHeight,
							height = timebox[0].offsetHeight,
							top = Math.abs(parseInt(timebox.css('marginTop'), 10));
				        if ($this.hasClass(options.next) && (height - pheight) - options.timeHeightInTimePicker >= top) {
				            timebox.css('marginTop', '-' + (top + options.timeHeightInTimePicker) + 'px');
				        } else if ($this.hasClass(options.prev) && top - options.timeHeightInTimePicker >= 0) {
				            timebox.css('marginTop', '-' + (top - options.timeHeightInTimePicker) + 'px');
				        }
				        /**
                         * Fixed bug:
                         * When using css3 transition, it will cause a bug that you cannot scroll the timepicker list.
                         * The reason is that the transition-duration time, if you set it to 0, all things fine, otherwise, this
                         * would cause a bug when you use jquery.css method.
                         * Let's say: * { transition: all .5s ease; }
                         * jquery timebox.css('marginTop') will return the original value which is before you clicking the next/prev button,
                         * meanwhile the timebox[0].style.marginTop will return the right value which is after you clicking the
                         * next/prev button.
                         *
                         * What we should do:
                         * Replace timebox.css('marginTop') with timebox[0].style.marginTop.
                         */
				        timeboxparent.trigger('scroll_element.xdsoft_scroller', [Math.abs(parseInt(timebox[0].style.marginTop, 10) / (height - pheight))]);
				        period = (period > 10) ? 10 : period - 10;
				        if (!stop) {
				            timer = setTimeout(arguments_callee4, v || period);
				        }
				    }(500));
				    $([options.ownerDocument.body, options.contentWindow]).on('touchend mouseup.xdsoft', function arguments_callee5() {
				        clearTimeout(timer);
				        stop = true;
				        $([options.ownerDocument.body, options.contentWindow])
							.off('touchend mouseup.xdsoft', arguments_callee5);
				    });
				});

            xchangeTimer = 0;
            // base handler - generating a calendar and timepicker
            datetimepicker
				.on('xchange.xdsoft', function (event) {
				    clearTimeout(xchangeTimer);
				    xchangeTimer = setTimeout(function () {

				        if (_xdsoft_datetime.currentTime === undefined || _xdsoft_datetime.currentTime === null) {
				            //In case blanks are allowed, delay construction until we have a valid date
				            if (options.allowBlank)
				                return;

				            _xdsoft_datetime.currentTime = _xdsoft_datetime.now();
				        }

				        if ((options.minDateTime !== false && options.minDateTime > _xdsoft_datetime.currentTime)) {
				            _xdsoft_datetime.currentTime = new Date(options.minDateTime);
				            input.val(_xdsoft_datetime.str());
				        }

				        var table = '',
							start = new Date(_xdsoft_datetime.currentTime.getFullYear(), _xdsoft_datetime.currentTime.getMonth(), 1, 12, 0, 0),
							i = 0,
							j,
							today = _xdsoft_datetime.now(),
							maxDate = false,
							minDate = false,
							hDate,
							day,
							d,
							y,
							m,
							w,
							classes = [],
							customDateSettings,
							newRow = true,
							time = '',
							h = '',
							line_time,
							description;

				        while (start.getDay() !== options.dayOfWeekStart) {
				            start.setDate(start.getDate() - 1);
				        }

				        table += '<table><thead><tr>';

				        if (options.weeks) {
				            table += '<th></th>';
				        }

				        for (j = 0; j < 7; j += 1) {
				            table += '<th>' + options.i18n[globalLocale].dayOfWeekShort[(j + options.dayOfWeekStart) % 7] + '</th>';
				        }

				        table += '</tr></thead>';
				        table += '<tbody>';

				        if (options.maxDate !== false) {
				            maxDate = _xdsoft_datetime.strToDate(options.maxDate);
				            maxDate = new Date(maxDate.getFullYear(), maxDate.getMonth(), maxDate.getDate(), 23, 59, 59, 999);
				        }

				        if (options.minDate !== false) {
				            minDate = _xdsoft_datetime.strToDate(options.minDate);
				            minDate = new Date(minDate.getFullYear(), minDate.getMonth(), minDate.getDate());
				        }

				        while (i < _xdsoft_datetime.currentTime.countDaysInMonth() || start.getDay() !== options.dayOfWeekStart || _xdsoft_datetime.currentTime.getMonth() === start.getMonth()) {
				            classes = [];
				            i += 1;

				            day = start.getDay();
				            d = start.getDate();
				            y = start.getFullYear();
				            m = start.getMonth();
				            w = _xdsoft_datetime.getWeekOfYear(start);
				            description = '';

				            classes.push('xdsoft_date');

				            if (options.beforeShowDay && $.isFunction(options.beforeShowDay.call)) {
				                customDateSettings = options.beforeShowDay.call(datetimepicker, start);
				            } else {
				                customDateSettings = null;
				            }

				            if (options.allowDateRe && Object.prototype.toString.call(options.allowDateRe) === "[object RegExp]") {
				                if (!options.allowDateRe.test(dateHelper.formatDate(start, options.formatDate))) {
				                    classes.push('xdsoft_disabled');
				                }
				            } else if (options.allowDates && options.allowDates.length > 0) {
				                if (options.allowDates.indexOf(dateHelper.formatDate(start, options.formatDate)) === -1) {
				                    classes.push('xdsoft_disabled');
				                }
				            } else if ((maxDate !== false && start > maxDate) || (minDate !== false && start < minDate) || (customDateSettings && customDateSettings[0] === false)) {
				                classes.push('xdsoft_disabled');
				            } else if (options.disabledDates.indexOf(dateHelper.formatDate(start, options.formatDate)) !== -1) {
				                classes.push('xdsoft_disabled');
				            } else if (options.disabledWeekDays.indexOf(day) !== -1) {
				                classes.push('xdsoft_disabled');
				            } else if (input.is('[readonly]')) {
				                classes.push('xdsoft_disabled');
				            }

				            if (customDateSettings && customDateSettings[1] !== "") {
				                classes.push(customDateSettings[1]);
				            }

				            if (_xdsoft_datetime.currentTime.getMonth() !== m) {
				                classes.push('xdsoft_other_month');
				            }

				            if ((options.defaultSelect || datetimepicker.data('changed')) && dateHelper.formatDate(_xdsoft_datetime.currentTime, options.formatDate) === dateHelper.formatDate(start, options.formatDate)) {
				                classes.push('xdsoft_current');
				            }

				            if (dateHelper.formatDate(today, options.formatDate) === dateHelper.formatDate(start, options.formatDate)) {
				                classes.push('xdsoft_today');
				            }

				            if (start.getDay() === 0 || start.getDay() === 6 || options.weekends.indexOf(dateHelper.formatDate(start, options.formatDate)) !== -1) {
				                classes.push('xdsoft_weekend');
				            }

				            if (options.highlightedDates[dateHelper.formatDate(start, options.formatDate)] !== undefined) {
				                hDate = options.highlightedDates[dateHelper.formatDate(start, options.formatDate)];
				                classes.push(hDate.style === undefined ? 'xdsoft_highlighted_default' : hDate.style);
				                description = hDate.desc === undefined ? '' : hDate.desc;
				            }

				            if (options.beforeShowDay && $.isFunction(options.beforeShowDay)) {
				                classes.push(options.beforeShowDay(start));
				            }

				            if (newRow) {
				                table += '<tr>';
				                newRow = false;
				                if (options.weeks) {
				                    table += '<th>' + w + '</th>';
				                }
				            }

				            table += '<td data-date="' + d + '" data-month="' + m + '" data-year="' + y + '"' + ' class="xdsoft_date xdsoft_day_of_week' + start.getDay() + ' ' + classes.join(' ') + '" title="' + description + '">' +
										'<div>' + d + '</div>' +
									'</td>';

				            if (start.getDay() === options.dayOfWeekStartPrev) {
				                table += '</tr>';
				                newRow = true;
				            }

				            start.setDate(d + 1);
				        }
				        table += '</tbody></table>';

				        calendar.html(table);

				        month_picker.find('.xdsoft_label span').eq(0).text(options.i18n[globalLocale].months[_xdsoft_datetime.currentTime.getMonth()]);
				        month_picker.find('.xdsoft_label span').eq(1).text(_xdsoft_datetime.currentTime.getFullYear());

				        // generate timebox
				        time = '';
				        h = '';
				        m = '';

				        line_time = function line_time(h, m) {
				            var now = _xdsoft_datetime.now(), optionDateTime, current_time,
								isALlowTimesInit = options.allowTimes && $.isArray(options.allowTimes) && options.allowTimes.length;
				            now.setHours(h);
				            h = parseInt(now.getHours(), 10);
				            now.setMinutes(m);
				            m = parseInt(now.getMinutes(), 10);
				            optionDateTime = new Date(_xdsoft_datetime.currentTime);
				            optionDateTime.setHours(h);
				            optionDateTime.setMinutes(m);
				            classes = [];
				            if ((options.minDateTime !== false && options.minDateTime > optionDateTime) || (options.maxTime !== false && _xdsoft_datetime.strtotime(options.maxTime).getTime() < now.getTime()) || (options.minTime !== false && _xdsoft_datetime.strtotime(options.minTime).getTime() > now.getTime())) {
				                classes.push('xdsoft_disabled');
				            } else if ((options.minDateTime !== false && options.minDateTime > optionDateTime) || ((options.disabledMinTime !== false && now.getTime() > _xdsoft_datetime.strtotime(options.disabledMinTime).getTime()) && (options.disabledMaxTime !== false && now.getTime() < _xdsoft_datetime.strtotime(options.disabledMaxTime).getTime()))) {
				                classes.push('xdsoft_disabled');
				            } else if (input.is('[readonly]')) {
				                classes.push('xdsoft_disabled');
				            }

				            current_time = new Date(_xdsoft_datetime.currentTime);
				            current_time.setHours(parseInt(_xdsoft_datetime.currentTime.getHours(), 10));

				            if (!isALlowTimesInit) {
				                current_time.setMinutes(Math[options.roundTime](_xdsoft_datetime.currentTime.getMinutes() / options.step) * options.step);
				            }

				            if ((options.initTime || options.defaultSelect || datetimepicker.data('changed')) && current_time.getHours() === parseInt(h, 10) && ((!isALlowTimesInit && options.step > 59) || current_time.getMinutes() === parseInt(m, 10))) {
				                if (options.defaultSelect || datetimepicker.data('changed')) {
				                    classes.push('xdsoft_current');
				                } else if (options.initTime) {
				                    classes.push('xdsoft_init_time');
				                }
				            }
				            if (parseInt(today.getHours(), 10) === parseInt(h, 10) && parseInt(today.getMinutes(), 10) === parseInt(m, 10)) {
				                classes.push('xdsoft_today');
				            }
				            time += '<div class="xdsoft_time ' + classes.join(' ') + '" data-hour="' + h + '" data-minute="' + m + '">' + dateHelper.formatDate(now, options.formatTime) + '</div>';
				        };

				        if (!options.allowTimes || !$.isArray(options.allowTimes) || !options.allowTimes.length) {
				            for (i = 0, j = 0; i < (options.hours12 ? 12 : 24) ; i += 1) {
				                for (j = 0; j < 60; j += options.step) {
				                    h = (i < 10 ? '0' : '') + i;
				                    m = (j < 10 ? '0' : '') + j;
				                    line_time(h, m);
				                }
				            }
				        } else {
				            for (i = 0; i < options.allowTimes.length; i += 1) {
				                h = _xdsoft_datetime.strtotime(options.allowTimes[i]).getHours();
				                m = _xdsoft_datetime.strtotime(options.allowTimes[i]).getMinutes();
				                line_time(h, m);
				            }
				        }

				        timebox.html(time);

				        opt = '';
				        i = 0;

				        for (i = parseInt(options.yearStart, 10) + options.yearOffset; i <= parseInt(options.yearEnd, 10) + options.yearOffset; i += 1) {
				            opt += '<div class="xdsoft_option ' + (_xdsoft_datetime.currentTime.getFullYear() === i ? 'xdsoft_current' : '') + '" data-value="' + i + '">' + i + '</div>';
				        }
				        yearselect.children().eq(0)
												.html(opt);

				        for (i = parseInt(options.monthStart, 10), opt = ''; i <= parseInt(options.monthEnd, 10) ; i += 1) {
				            opt += '<div class="xdsoft_option ' + (_xdsoft_datetime.currentTime.getMonth() === i ? 'xdsoft_current' : '') + '" data-value="' + i + '">' + options.i18n[globalLocale].months[i] + '</div>';
				        }
				        monthselect.children().eq(0).html(opt);
				        $(datetimepicker)
							.trigger('generate.xdsoft');
				    }, 10);
				    event.stopPropagation();
				})
				.on('afterOpen.xdsoft', function () {
				    if (options.timepicker) {
				        var classType, pheight, height, top;
				        if (timebox.find('.xdsoft_current').length) {
				            classType = '.xdsoft_current';
				        } else if (timebox.find('.xdsoft_init_time').length) {
				            classType = '.xdsoft_init_time';
				        }
				        if (classType) {
				            pheight = timeboxparent[0].clientHeight;
				            height = timebox[0].offsetHeight;
				            top = timebox.find(classType).index() * options.timeHeightInTimePicker;
				            if ((height - pheight) < top) {
				                top = height - pheight;
				            }
				            timeboxparent.trigger('scroll_element.xdsoft_scroller', [parseInt(top, 10) / (height - pheight)]);
				        } else {
				            timeboxparent.trigger('scroll_element.xdsoft_scroller', [0]);
				        }
				    }
				});

            timerclick = 0;
            calendar
				.on('touchend click.xdsoft', 'td', function (xdevent) {
				    xdevent.stopPropagation();  // Prevents closing of Pop-ups, Modals and Flyouts in Bootstrap
				    timerclick += 1;
				    var $this = $(this),
						currentTime = _xdsoft_datetime.currentTime;

				    if (currentTime === undefined || currentTime === null) {
				        _xdsoft_datetime.currentTime = _xdsoft_datetime.now();
				        currentTime = _xdsoft_datetime.currentTime;
				    }

				    if ($this.hasClass('xdsoft_disabled')) {
				        return false;
				    }

				    currentTime.setDate(1);
				    currentTime.setFullYear($this.data('year'));
				    currentTime.setMonth($this.data('month'));
				    currentTime.setDate($this.data('date'));

				    datetimepicker.trigger('select.xdsoft', [currentTime]);

				    input.val(_xdsoft_datetime.str());

				    if (options.onSelectDate && $.isFunction(options.onSelectDate)) {
				        options.onSelectDate.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'), xdevent);
				    }

				    datetimepicker.data('changed', true);
				    datetimepicker.trigger('xchange.xdsoft');
				    datetimepicker.trigger('changedatetime.xdsoft');
				    if ((timerclick > 1 || (options.closeOnDateSelect === true || (options.closeOnDateSelect === false && !options.timepicker))) && !options.inline) {
				        datetimepicker.trigger('close.xdsoft');
				    }
				    setTimeout(function () {
				        timerclick = 0;
				    }, 200);
				});

            timebox
				.on('touchend click.xdsoft', 'div', function (xdevent) {
				    xdevent.stopPropagation();
				    var $this = $(this),
						currentTime = _xdsoft_datetime.currentTime;

				    if (currentTime === undefined || currentTime === null) {
				        _xdsoft_datetime.currentTime = _xdsoft_datetime.now();
				        currentTime = _xdsoft_datetime.currentTime;
				    }

				    if ($this.hasClass('xdsoft_disabled')) {
				        return false;
				    }
				    currentTime.setHours($this.data('hour'));
				    currentTime.setMinutes($this.data('minute'));
				    datetimepicker.trigger('select.xdsoft', [currentTime]);

				    datetimepicker.data('input').val(_xdsoft_datetime.str());

				    if (options.onSelectTime && $.isFunction(options.onSelectTime)) {
				        options.onSelectTime.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'), xdevent);
				    }
				    datetimepicker.data('changed', true);
				    datetimepicker.trigger('xchange.xdsoft');
				    datetimepicker.trigger('changedatetime.xdsoft');
				    if (options.inline !== true && options.closeOnTimeSelect === true) {
				        datetimepicker.trigger('close.xdsoft');
				    }
				});

            datepicker
				.on('mousewheel.xdsoft', function (event) {
				    if (!options.scrollMonth) {
				        return true;
				    }
				    if (event.deltaY < 0) {
				        _xdsoft_datetime.nextMonth();
				    } else {
				        _xdsoft_datetime.prevMonth();
				    }
				    return false;
				});

            input
				.on('mousewheel.xdsoft', function (event) {
				    if (!options.scrollInput) {
				        return true;
				    }
				    if (!options.datepicker && options.timepicker) {
				        current_time_index = timebox.find('.xdsoft_current').length ? timebox.find('.xdsoft_current').eq(0).index() : 0;
				        if (current_time_index + event.deltaY >= 0 && current_time_index + event.deltaY < timebox.children().length) {
				            current_time_index += event.deltaY;
				        }
				        if (timebox.children().eq(current_time_index).length) {
				            timebox.children().eq(current_time_index).trigger('mousedown');
				        }
				        return false;
				    }
				    if (options.datepicker && !options.timepicker) {
				        datepicker.trigger(event, [event.deltaY, event.deltaX, event.deltaY]);
				        if (input.val) {
				            input.val(_xdsoft_datetime.str());
				        }
				        datetimepicker.trigger('changedatetime.xdsoft');
				        return false;
				    }
				});

            datetimepicker
				.on('changedatetime.xdsoft', function (event) {
				    if (options.onChangeDateTime && $.isFunction(options.onChangeDateTime)) {
				        var $input = datetimepicker.data('input');
				        options.onChangeDateTime.call(datetimepicker, _xdsoft_datetime.currentTime, $input, event);
				        delete options.value;
				        $input.trigger('change');
				    }
				})
				.on('generate.xdsoft', function () {
				    if (options.onGenerate && $.isFunction(options.onGenerate)) {
				        options.onGenerate.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'));
				    }
				    if (triggerAfterOpen) {
				        datetimepicker.trigger('afterOpen.xdsoft');
				        triggerAfterOpen = false;
				    }
				})
				.on('click.xdsoft', function (xdevent) {
				    xdevent.stopPropagation();
				});

            current_time_index = 0;

            /**
			 * Runs the callback for each of the specified node's ancestors.
			 *
			 * Return FALSE from the callback to stop ascending.
			 *
			 * @param {DOMNode} node
			 * @param {Function} callback
			 * @returns {undefined}
			 */
            forEachAncestorOf = function (node, callback) {
                do {
                    node = node.parentNode;

                    if (callback(node) === false) {
                        break;
                    }
                } while (node.nodeName !== 'HTML');
            };

            /**
			 * Sets the position of the picker.
			 *
			 * @returns {undefined}
			 */
            setPos = function () {
                var dateInputOffset,
					dateInputElem,
					verticalPosition,
					left,
					position,
					datetimepickerElem,
					dateInputHasFixedAncestor,
					$dateInput,
					windowWidth,
					verticalAnchorEdge,
					datetimepickerCss,
					windowHeight,
					windowScrollTop;

                $dateInput = datetimepicker.data('input');
                dateInputOffset = $dateInput.offset();
                dateInputElem = $dateInput[0];

                verticalAnchorEdge = 'top';
                verticalPosition = (dateInputOffset.top + dateInputElem.offsetHeight) - 1;
                left = dateInputOffset.left;
                position = "absolute";

                windowWidth = $(options.contentWindow).width();
                windowHeight = $(options.contentWindow).height();
                windowScrollTop = $(options.contentWindow).scrollTop();

                if ((options.ownerDocument.documentElement.clientWidth - dateInputOffset.left) < datepicker.parent().outerWidth(true)) {
                    var diff = datepicker.parent().outerWidth(true) - dateInputElem.offsetWidth;
                    left = left - diff;
                }

                if ($dateInput.parent().css('direction') === 'rtl') {
                    left -= (datetimepicker.outerWidth() - $dateInput.outerWidth());
                }

                if (options.fixed) {
                    verticalPosition -= windowScrollTop;
                    left -= $(options.contentWindow).scrollLeft();
                    position = "fixed";
                } else {
                    dateInputHasFixedAncestor = false;

                    forEachAncestorOf(dateInputElem, function (ancestorNode) {
                        if (window.getComputedStyle(ancestorNode).getPropertyValue('position') === 'fixed') {
                            dateInputHasFixedAncestor = true;
                            return false;
                        }
                    });

                    if (dateInputHasFixedAncestor) {
                        position = 'fixed';

                        //If the picker won't fit entirely within the viewport then display it above the date input.
                        if (verticalPosition + datetimepicker.outerHeight() > windowHeight + windowScrollTop) {
                            verticalAnchorEdge = 'bottom';
                            verticalPosition = (windowHeight + windowScrollTop) - dateInputOffset.top;
                        } else {
                            verticalPosition -= windowScrollTop;
                        }
                    } else {
                        if (verticalPosition + dateInputElem.offsetHeight > windowHeight + windowScrollTop) {
                            verticalPosition = dateInputOffset.top - dateInputElem.offsetHeight + 1;
                        }
                    }

                    if (verticalPosition < 0) {
                        verticalPosition = 0;
                    }

                    if (left + dateInputElem.offsetWidth > windowWidth) {
                        left = windowWidth - dateInputElem.offsetWidth;
                    }
                }

                datetimepickerElem = datetimepicker[0];

                forEachAncestorOf(datetimepickerElem, function (ancestorNode) {
                    var ancestorNodePosition;

                    ancestorNodePosition = window.getComputedStyle(ancestorNode).getPropertyValue('position');

                    if (ancestorNodePosition === 'relative' && windowWidth >= ancestorNode.offsetWidth) {
                        left = left - ((windowWidth - ancestorNode.offsetWidth) / 2);
                        return false;
                    }
                });

                datetimepickerCss = {
                    position: position,
                    left: left,
                    top: '',  //Initialize to prevent previous values interfering with new ones.
                    bottom: ''  //Initialize to prevent previous values interfering with new ones.
                };

                datetimepickerCss[verticalAnchorEdge] = verticalPosition;

                datetimepicker.css(datetimepickerCss);
            };

            datetimepicker
				.on('open.xdsoft', function (event) {
				    var onShow = true;
				    if (options.onShow && $.isFunction(options.onShow)) {
				        onShow = options.onShow.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'), event);
				    }
				    if (onShow !== false) {
				        datetimepicker.show();
				        setPos();
				        $(options.contentWindow)
							.off('resize.xdsoft')
							.on('resize.xdsoft', setPos)
				            .off('scroll.xdsoft')
							.on('scroll.xdsoft', setPos);
				        if (options.closeOnWithoutClick && event.type != 'open') {
				            $([options.ownerDocument.body, options.contentWindow]).on('touchstart mousedown.xdsoft', function arguments_callee6() {
				                datetimepicker.trigger('close.xdsoft');
				                $([options.ownerDocument.body, options.contentWindow]).off('touchstart mousedown.xdsoft', arguments_callee6);
				            });
				        }
				    }
				    setTimeout(function () {
				        $(datetimepicker).data("isshowdatepicker", "true");
				    }, 500);
				})
				.on('close.xdsoft', function (event) {
				    if (options.allowDates != null && options.allowDates.length > 0) {
				        if (options.allowDates.indexOf(_xdsoft_datetime.currentTime.format(options.formatDate)) === -1) {
				            _xdsoft_datetime.currentTime = new Date(moment(options.allowDates[0])._d);
                        }
				    }

				    var onClose = true;
				    month_picker
						.find('.xdsoft_month,.xdsoft_year')
							.find('.xdsoft_select')
								.hide();
				    month_picker.find('.xdsoft_month,.xdsoft_year').removeClass("scroller_custom");
				    if (options.onClose && $.isFunction(options.onClose)) {
				        onClose = options.onClose.call(datetimepicker, _xdsoft_datetime.currentTime, datetimepicker.data('input'), event);
				    }
				    if (onClose !== false && !options.opened && !options.inline) {
				        datetimepicker.hide();
				    }
				    $(datetimepicker).data("isshowdatepicker", "false");
				    event.stopPropagation();
				})
				.on('toggle.xdsoft', function () {
				    if (datetimepicker.is(':visible')) {
				        datetimepicker.trigger('close.xdsoft');
				    } else {
				        datetimepicker.trigger('open.xdsoft');
				    }
				})
				.data('input', input);

            timer = 0;

            datetimepicker.data('xdsoft_datetime', _xdsoft_datetime);
            datetimepicker.setOptions(options);

            function getCurrentValue() {
                var ct = false, time;

                if (options.startDate) {
                    ct = _xdsoft_datetime.strToDate(options.startDate);
                } else {
                    ct = options.value || ((input && input.val && input.val()) ? input.val() : '');
                    if (ct) {
                        ct = _xdsoft_datetime.strToDateTime(ct);
                    } else if (options.defaultDate) {
                        ct = _xdsoft_datetime.strToDateTime(options.defaultDate);
                        if (options.defaultTime) {
                            time = _xdsoft_datetime.strtotime(options.defaultTime);
                            ct.setHours(time.getHours());
                            ct.setMinutes(time.getMinutes());
                        }
                    }
                }

                if (ct && _xdsoft_datetime.isValidDate(ct)) {
                    datetimepicker.data('changed', true);
                } else {
                    ct = '';
                }

                return ct || 0;
            }

            function setMask(options) {

                var isValidValue = function (mask, value) {
                    var reg = mask
						.replace(/([\[\]\/\{\}\(\)\-\.\+]{1})/g, '\\$1')
						.replace(/_/g, '{digit+}')
						.replace(/([0-9]{1})/g, '{digit$1}')
						.replace(/\{digit([0-9]{1})\}/g, '[0-$1_]{1}')
						.replace(/\{digit[\+]\}/g, '[0-9_]{1}');
                    return (new RegExp(reg)).test(value);
                },
				getCaretPos = function (input) {
				    try {
				        if (options.ownerDocument.selection && options.ownerDocument.selection.createRange) {
				            var range = options.ownerDocument.selection.createRange();
				            return range.getBookmark().charCodeAt(2) - 2;
				        }
				        if (input.setSelectionRange) {
				            return input.selectionStart;
				        }
				    } catch (e) {
				        return 0;
				    }
				},
				setCaretPos = function (node, pos) {
				    node = (typeof node === "string" || node instanceof String) ? options.ownerDocument.getElementById(node) : node;
				    if (!node) {
				        return false;
				    }
				    if (node.createTextRange) {
				        var textRange = node.createTextRange();
				        textRange.collapse(true);
				        textRange.moveEnd('character', pos);
				        textRange.moveStart('character', pos);
				        textRange.select();
				        return true;
				    }
				    if (node.setSelectionRange) {
				        node.setSelectionRange(pos, pos);
				        return true;
				    }
				    return false;
				};
                if (options.mask) {
                    input.off('keydown.xdsoft');
                }
                if (options.mask === true) {
                    if (typeof moment != 'undefined') {
                        options.mask = options.format
                                .replace(/Y{4}/g, '9999')
                                .replace(/Y{2}/g, '99')
                                .replace(/M{2}/g, '19')
                                .replace(/D{2}/g, '39')
                                .replace(/H{2}/g, '29')
                                .replace(/m{2}/g, '59')
                                .replace(/s{2}/g, '59');
                    } else {
                        options.mask = options.format
                                .replace(/Y/g, '9999')
                                .replace(/F/g, '9999')
                                .replace(/m/g, '19')
                                .replace(/d/g, '39')
                                .replace(/H/g, '29')
                                .replace(/i/g, '59')
                                .replace(/s/g, '59');
                    }
                }

                if ($.type(options.mask) === 'string') {
                    if (!isValidValue(options.mask, input.val())) {
                        input.val(options.mask.replace(/[0-9]/g, '_'));
                        setCaretPos(input[0], 0);
                    }

                    input.on('keydown.xdsoft', function (event) {
                        var val = this.value,
							key = event.which,
							pos,
							digit;

                        if (((key >= KEY0 && key <= KEY9) || (key >= _KEY0 && key <= _KEY9)) || (key === BACKSPACE || key === DEL)) {
                            pos = getCaretPos(this);
                            digit = (key !== BACKSPACE && key !== DEL) ? String.fromCharCode((_KEY0 <= key && key <= _KEY9) ? key - KEY0 : key) : '_';

                            if ((key === BACKSPACE || key === DEL) && pos) {
                                pos -= 1;
                                digit = '_';
                            }

                            while (/[^0-9_]/.test(options.mask.substr(pos, 1)) && pos < options.mask.length && pos > 0) {
                                pos += (key === BACKSPACE || key === DEL) ? -1 : 1;
                            }

                            val = val.substr(0, pos) + digit + val.substr(pos + 1);
                            if ($.trim(val) === '') {
                                val = options.mask.replace(/[0-9]/g, '_');
                            } else {
                                if (pos === options.mask.length) {
                                    event.preventDefault();
                                    return false;
                                }
                            }

                            pos += (key === BACKSPACE || key === DEL) ? 0 : 1;
                            while (/[^0-9_]/.test(options.mask.substr(pos, 1)) && pos < options.mask.length && pos > 0) {
                                pos += (key === BACKSPACE || key === DEL) ? -1 : 1;
                            }

                            if (isValidValue(options.mask, val)) {
                                this.value = val;
                                setCaretPos(this, pos);
                            } else if ($.trim(val) === '') {
                                this.value = options.mask.replace(/[0-9]/g, '_');
                            } else {
                                input.trigger('error_input.xdsoft');
                            }
                        } else {
                            if (([AKEY, CKEY, VKEY, ZKEY, YKEY].indexOf(key) !== -1 && ctrlDown) || [ESC, ARROWUP, ARROWDOWN, ARROWLEFT, ARROWRIGHT, F5, CTRLKEY, TAB, ENTER].indexOf(key) !== -1) {
                                return true;
                            }
                        }

                        event.preventDefault();
                        return false;
                    });
                }
            }

            _xdsoft_datetime.setCurrentTime(getCurrentValue());

            input
				.data('xdsoft_datetimepicker', datetimepicker)
				.on('open.xdsoft focusin.xdsoft mousedown.xdsoft touchstart', function () {
				    if (input.is(':disabled') || (input.data('xdsoft_datetimepicker').is(':visible') && options.closeOnInputClick)) {
				        return;
				    }
				    clearTimeout(timer);
				    timer = setTimeout(function () {
				        if (input.is(':disabled')) {
				            return;
				        }
				        triggerAfterOpen = true;
				        _xdsoft_datetime.setCurrentTime(getCurrentValue(), true);
				        if (options.mask) {
				            setMask(options);
				        }
				        datetimepicker.trigger('open.xdsoft');
				    }, 100);
				})
				.on('keydown.xdsoft', function (event) {
				    var elementSelector,
						key = event.which;
				    if ([ENTER].indexOf(key) !== -1 && options.enterLikeTab) {
				        elementSelector = $("input:visible,textarea:visible,button:visible,a:visible");
				        datetimepicker.trigger('close.xdsoft');
				        elementSelector.eq(elementSelector.index(this) + 1).focus();
				        return false;
				    }
				    if ([TAB].indexOf(key) !== -1) {
				        datetimepicker.trigger('close.xdsoft');
				        return true;
				    }
				})
				.on('blur.xdsoft', function () {
				    if (('ontouchstart' in document.documentElement) == false) {
                        //If not touchable device then hide date picker on blur
				        setTimeout(function () {
				            datetimepicker.trigger('close.xdsoft');
				        }, 200);
				    }
				});
            
            //Unbind old event
            $("body").unbind("click touchstart");

            //Close date picker on outside click
            $("body").on("click touchstart", function (event) {
                if ($(".xdsoft_datetimepicker:visible").data("isshowdatepicker") == "true") {
                    $(".xdsoft_datetimepicker:visible").data("isshowdatepicker", "false");
                    $(".xdsoft_datetimepicker:visible").hide();
                }
            });
        };
        destroyDateTimePicker = function (input) {
            var datetimepicker = input.data('xdsoft_datetimepicker');
            if (datetimepicker) {
                datetimepicker.data('xdsoft_datetime', null);
                datetimepicker.remove();
                input
					.data('xdsoft_datetimepicker', null)
					.off('.xdsoft');
                $(options.contentWindow).off('resize.xdsoft');
                $(options.contentWindow).off('scroll.xdsoft');
                $([options.contentWindow, options.ownerDocument.body]).off('mousedown.xdsoft touchstart');
                if (input.unmousewheel) {
                    input.unmousewheel();
                }
            }
        };
        $(options.ownerDocument)
			.off('keydown.xdsoftctrl keyup.xdsoftctrl')
			.on('keydown.xdsoftctrl', function (e) {
			    if (e.keyCode === CTRLKEY) {
			        ctrlDown = true;
			    }
			})
			.on('keyup.xdsoftctrl', function (e) {
			    if (e.keyCode === CTRLKEY) {
			        ctrlDown = false;
			    }
			});

        this.each(function () {
            var datetimepicker = $(this).data('xdsoft_datetimepicker'), $input;
            if (datetimepicker) {
                if ($.type(opt) === 'string') {
                    switch (opt) {
                        case 'show':
                            $(this).select().focus();
                            datetimepicker.trigger('open.xdsoft');
                            break;
                        case 'hide':
                            datetimepicker.trigger('close.xdsoft');
                            break;
                        case 'toggle':
                            datetimepicker.trigger('toggle.xdsoft');
                            break;
                        case 'destroy':
                            destroyDateTimePicker($(this));
                            break;
                        case 'reset':
                            this.value = this.defaultValue;
                            if (!this.value || !datetimepicker.data('xdsoft_datetime').isValidDate(dateHelper.parseDate(this.value, options.format))) {
                                datetimepicker.data('changed', false);
                            }
                            datetimepicker.data('xdsoft_datetime').setCurrentTime(this.value);
                            break;
                        case 'validate':
                            $input = datetimepicker.data('input');
                            $input.trigger('blur.xdsoft');
                            break;
                        default:
                            if (datetimepicker[opt] && $.isFunction(datetimepicker[opt])) {
                                result = datetimepicker[opt](opt2);
                            }
                    }
                } else {
                    datetimepicker
						.setOptions(opt);
                }
                return 0;
            }
            if ($.type(opt) !== 'string') {
                if (!options.lazyInit || options.open || options.inline) {
                    createDateTimePicker($(this));
                } else {
                    lazyInit($(this));
                }
            }
        });

        return result;
    };

    $.fn.datetimepicker.defaults = default_options;

    function HighlightedDate(date, desc, style) {
        "use strict";
        this.date = date;
        this.desc = desc;
        this.style = style;
    }
}));

/*!
 * jQuery Mousewheel 3.1.13
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 */

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof exports === 'object') {
        // Node/CommonJS style for Browserify
        module.exports = factory;
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {

    var toFix = ['wheel', 'mousewheel', 'DOMMouseScroll', 'MozMousePixelScroll'],
        toBind = ('onwheel' in document || document.documentMode >= 9) ?
                    ['wheel'] : ['mousewheel', 'DomMouseScroll', 'MozMousePixelScroll'],
        slice = Array.prototype.slice,
        nullLowestDeltaTimeout, lowestDelta;

    if ($.event.fixHooks) {
        for (var i = toFix.length; i;) {
            $.event.fixHooks[toFix[--i]] = $.event.mouseHooks;
        }
    }

    var special = $.event.special.mousewheel = {
        version: '3.1.12',

        setup: function () {
            if (this.addEventListener) {
                for (var i = toBind.length; i;) {
                    this.addEventListener(toBind[--i], handler, false);
                }
            } else {
                this.onmousewheel = handler;
            }
            // Store the line height and page height for this particular element
            $.data(this, 'mousewheel-line-height', special.getLineHeight(this));
            $.data(this, 'mousewheel-page-height', special.getPageHeight(this));
        },

        teardown: function () {
            if (this.removeEventListener) {
                for (var i = toBind.length; i;) {
                    this.removeEventListener(toBind[--i], handler, false);
                }
            } else {
                this.onmousewheel = null;
            }
            // Clean up the data we added to the element
            $.removeData(this, 'mousewheel-line-height');
            $.removeData(this, 'mousewheel-page-height');
        },

        getLineHeight: function (elem) {
            var $elem = $(elem),
                $parent = $elem['offsetParent' in $.fn ? 'offsetParent' : 'parent']();
            if (!$parent.length) {
                $parent = $('body');
            }
            return parseInt($parent.css('fontSize'), 10) || parseInt($elem.css('fontSize'), 10) || 16;
        },

        getPageHeight: function (elem) {
            return $(elem).height();
        },

        settings: {
            adjustOldDeltas: true, // see shouldAdjustOldDeltas() below
            normalizeOffset: true  // calls getBoundingClientRect for each event
        }
    };

    $.fn.extend({
        mousewheel: function (fn) {
            return fn ? this.bind('mousewheel', fn) : this.trigger('mousewheel');
        },

        unmousewheel: function (fn) {
            return this.unbind('mousewheel', fn);
        }
    });


    function handler(event) {
        var orgEvent = event || window.event,
            args = slice.call(arguments, 1),
            delta = 0,
            deltaX = 0,
            deltaY = 0,
            absDelta = 0,
            offsetX = 0,
            offsetY = 0;
        event = $.event.fix(orgEvent);
        event.type = 'mousewheel';

        // Old school scrollwheel delta
        if ('detail' in orgEvent) { deltaY = orgEvent.detail * -1; }
        if ('wheelDelta' in orgEvent) { deltaY = orgEvent.wheelDelta; }
        if ('wheelDeltaY' in orgEvent) { deltaY = orgEvent.wheelDeltaY; }
        if ('wheelDeltaX' in orgEvent) { deltaX = orgEvent.wheelDeltaX * -1; }

        // Firefox < 17 horizontal scrolling related to DOMMouseScroll event
        if ('axis' in orgEvent && orgEvent.axis === orgEvent.HORIZONTAL_AXIS) {
            deltaX = deltaY * -1;
            deltaY = 0;
        }

        // Set delta to be deltaY or deltaX if deltaY is 0 for backwards compatabilitiy
        delta = deltaY === 0 ? deltaX : deltaY;

        // New school wheel delta (wheel event)
        if ('deltaY' in orgEvent) {
            deltaY = orgEvent.deltaY * -1;
            delta = deltaY;
        }
        if ('deltaX' in orgEvent) {
            deltaX = orgEvent.deltaX;
            if (deltaY === 0) { delta = deltaX * -1; }
        }

        // No change actually happened, no reason to go any further
        if (deltaY === 0 && deltaX === 0) { return; }

        // Need to convert lines and pages to pixels if we aren't already in pixels
        // There are three delta modes:
        //   * deltaMode 0 is by pixels, nothing to do
        //   * deltaMode 1 is by lines
        //   * deltaMode 2 is by pages
        if (orgEvent.deltaMode === 1) {
            var lineHeight = $.data(this, 'mousewheel-line-height');
            delta *= lineHeight;
            deltaY *= lineHeight;
            deltaX *= lineHeight;
        } else if (orgEvent.deltaMode === 2) {
            var pageHeight = $.data(this, 'mousewheel-page-height');
            delta *= pageHeight;
            deltaY *= pageHeight;
            deltaX *= pageHeight;
        }

        // Store lowest absolute delta to normalize the delta values
        absDelta = Math.max(Math.abs(deltaY), Math.abs(deltaX));

        if (!lowestDelta || absDelta < lowestDelta) {
            lowestDelta = absDelta;

            // Adjust older deltas if necessary
            if (shouldAdjustOldDeltas(orgEvent, absDelta)) {
                lowestDelta /= 40;
            }
        }

        // Adjust older deltas if necessary
        if (shouldAdjustOldDeltas(orgEvent, absDelta)) {
            // Divide all the things by 40!
            delta /= 40;
            deltaX /= 40;
            deltaY /= 40;
        }

        // Get a whole, normalized value for the deltas
        delta = Math[delta >= 1 ? 'floor' : 'ceil'](delta / lowestDelta);
        deltaX = Math[deltaX >= 1 ? 'floor' : 'ceil'](deltaX / lowestDelta);
        deltaY = Math[deltaY >= 1 ? 'floor' : 'ceil'](deltaY / lowestDelta);

        // Normalise offsetX and offsetY properties
        if (special.settings.normalizeOffset && this.getBoundingClientRect) {
            var boundingRect = this.getBoundingClientRect();
            offsetX = event.clientX - boundingRect.left;
            offsetY = event.clientY - boundingRect.top;
        }

        // Add information to the event object
        event.deltaX = deltaX;
        event.deltaY = deltaY;
        event.deltaFactor = lowestDelta;
        event.offsetX = offsetX;
        event.offsetY = offsetY;
        // Go ahead and set deltaMode to 0 since we converted to pixels
        // Although this is a little odd since we overwrite the deltaX/Y
        // properties with normalized deltas.
        event.deltaMode = 0;

        // Add event and delta to the front of the arguments
        args.unshift(event, delta, deltaX, deltaY);

        // Clearout lowestDelta after sometime to better
        // handle multiple device types that give different
        // a different lowestDelta
        // Ex: trackpad = 3 and mouse wheel = 120
        if (nullLowestDeltaTimeout) { clearTimeout(nullLowestDeltaTimeout); }
        nullLowestDeltaTimeout = setTimeout(nullLowestDelta, 200);

        return ($.event.dispatch || $.event.handle).apply(this, args);
    }

    function nullLowestDelta() {
        lowestDelta = null;
    }

    function shouldAdjustOldDeltas(orgEvent, absDelta) {
        // If this is an older event and the delta is divisable by 120,
        // then we are assuming that the browser is treating this as an
        // older mouse wheel event and that we should divide the deltas
        // by 40 to try and get a more usable deltaFactor.
        // Side note, this actually impacts the reported scroll distance
        // in older browsers and can cause scrolling to be slower than native.
        // Turn this off by setting $.event.special.mousewheel.settings.adjustOldDeltas to false.
        return special.settings.adjustOldDeltas && orgEvent.type === 'mousewheel' && absDelta % 120 === 0;
    }

}));
;
/**
* @version: 1.3.21
* @author: Dan Grossman http://www.dangrossman.info/
* @copyright: Copyright (c) 2012-2015 Dan Grossman. All rights reserved.
* @license: Licensed under the MIT license. See http://www.opensource.org/licenses/mit-license.php
* @website: https://www.improvely.com/
*/

(function(root, factory) {

  if (typeof define === 'function' && define.amd) {
    define(['moment', 'jquery', 'exports'], function(momentjs, $, exports) {
      root.daterangepicker = factory(root, exports, momentjs, $);
    });

  } else if (typeof exports !== 'undefined') {
    var momentjs = require('moment');
    var jQuery;
    try {
      jQuery = require('jquery');
    } catch (err) {
      jQuery = window.jQuery;
      if (!jQuery) throw new Error('jQuery dependency not found');
    }

    factory(root, exports, momentjs, jQuery);

  // Finally, as a browser global.
  } else {
    root.daterangepicker = factory(root, {}, root.moment, (root.jQuery || root.Zepto || root.ender || root.$));
  }

}(this, function(root, daterangepicker, moment, $) {

    var DateRangePicker = function (element, options, cb) {

        // by default, the daterangepicker element is placed at the bottom of HTML body
        this.parentEl = 'body';

        //element that triggered the date range picker
        this.element = $(element);

        //tracks visible state
        this.isShowing = false;

        //create the picker HTML object
        var DRPTemplate = '<div class="daterangepicker dropdown-menu">' +
            '<div class="daterangepicker-row clearfix">' +
                '<div class="calendar first left"></div>' +
                '<div class="calendar second right"></div>' +
                '<div class="ranges">' +
                  '<div class="range_inputs clearfix"><div class="from-to-picker clearfix">' +
                    '<div class="daterangepicker_start_input">' +
                      '<label for="daterangepicker_start"></label>' +
                      '<input class="input-mini" type="text" name="daterangepicker_start" value="" />' +
                    '</div>' +
                    '<div class="daterangepicker_end_input">' +
                      '<label for="daterangepicker_end"></label>' +
                      '<input class="input-mini" type="text" name="daterangepicker_end" value="" />' +
                    '</div></div>' +
                    '<button class="applyBtn" disabled="disabled"></button>&nbsp;' +
                    '<button class="cancelBtn"></button>' +
                  '</div>' +
                '</div>' +
              '</div></div>';

        //custom options
        if (typeof options !== 'object' || options === null)
            options = {};

        this.parentEl = (typeof options === 'object' && options.parentEl && $(options.parentEl).length) ? $(options.parentEl) : $(this.parentEl);
        this.container = $(DRPTemplate).appendTo(this.parentEl);

        this.setOptions(options, cb);

        //event listeners
        this.container.find('.calendar')
            .on('click.daterangepicker', '.prev', $.proxy(this.clickPrev, this))
            .on('click.daterangepicker', '.next', $.proxy(this.clickNext, this))
            .on('click.daterangepicker', 'td.available', $.proxy(this.clickDate, this))
            .on('mouseenter.daterangepicker', 'td.available', $.proxy(this.hoverDate, this))
            .on('mouseleave.daterangepicker', 'td.available', $.proxy(this.updateFormInputs, this))
            .on('change.daterangepicker', 'select.yearselect', $.proxy(this.updateMonthYear, this))
            .on('change.daterangepicker', 'select.monthselect', $.proxy(this.updateMonthYear, this))
            .on('change.daterangepicker', 'select.hourselect,select.minuteselect,select.secondselect,select.ampmselect', $.proxy(this.updateTime, this));

        this.container.find('.ranges')
            .on('click.daterangepicker', 'button.applyBtn', $.proxy(this.clickApply, this))
            .on('click.daterangepicker', 'button.cancelBtn', $.proxy(this.clickCancel, this))
            .on('click.daterangepicker', '.daterangepicker_start_input,.daterangepicker_end_input', $.proxy(this.showCalendars, this))
            .on('change.daterangepicker', '.daterangepicker_start_input,.daterangepicker_end_input', $.proxy(this.inputsChanged, this))
            .on('keydown.daterangepicker', '.daterangepicker_start_input,.daterangepicker_end_input', $.proxy(this.inputsKeydown, this))
            .on('click.daterangepicker', 'li', $.proxy(this.clickRange, this))
            .on('mouseenter.daterangepicker', 'li', $.proxy(this.enterRange, this))
            .on('mouseleave.daterangepicker', 'li', $.proxy(this.updateFormInputs, this));

        if (this.element.is('input')) {
            this.element.on({
                'click.daterangepicker': $.proxy(this.show, this),
                'focus.daterangepicker': $.proxy(this.show, this),
                'keyup.daterangepicker': $.proxy(this.updateFromControl, this),
                'keydown.daterangepicker': $.proxy(this.keydown, this)
            });
        } else {
            this.element.on('click.daterangepicker', $.proxy(this.toggle, this));
        }

    };

    DateRangePicker.prototype = {

        constructor: DateRangePicker,

        setOptions: function(options, callback) {

            this.startDate = moment().startOf('day');
            this.endDate = moment().endOf('day');
            this.timeZone = moment().utcOffset();
            this.minDate = false;
            this.maxDate = false;
            this.dateLimit = false;

            this.showDropdowns = false;
            this.showWeekNumbers = false;
            this.timePicker = false;
            this.timePickerSeconds = false;
            this.timePickerIncrement = 30;
            this.timePicker12Hour = true;
            this.singleDatePicker = false;
            this.ranges = {};

            this.opens = 'right';
            if (this.element.hasClass('pull-right'))
                this.opens = 'left';

            this.drops = 'down';
            if (this.element.hasClass('dropup'))
                this.drops = 'up';

            this.buttonClasses = ['btn', 'btn-small btn-sm'];
            this.applyClass = 'btn-success';
            this.cancelClass = 'btn-default';

            this.format = 'MM/DD/YYYY';
            this.separator = ' - ';

            this.locale = {
                applyLabel: 'Apply',
                cancelLabel: 'Cancel',
                fromLabel: 'From',
                toLabel: 'To',
                weekLabel: 'W',
                customRangeLabel: 'Custom Range',
                daysOfWeek: moment.weekdaysMin(),
                monthNames: moment.monthsShort(),
                firstDay: moment.localeData()._week.dow
            };

            this.cb = function () { };

            if (typeof options.format === 'string')
                this.format = options.format;

            if (typeof options.separator === 'string')
                this.separator = options.separator;

            if (typeof options.startDate === 'string')
                this.startDate = moment(options.startDate, this.format);

            if (typeof options.endDate === 'string')
                this.endDate = moment(options.endDate, this.format);

            if (typeof options.minDate === 'string')
                this.minDate = moment(options.minDate, this.format);

            if (typeof options.maxDate === 'string')
                this.maxDate = moment(options.maxDate, this.format);

            if (typeof options.startDate === 'object')
                this.startDate = moment(options.startDate);

            if (typeof options.endDate === 'object')
                this.endDate = moment(options.endDate);

            if (typeof options.minDate === 'object')
                this.minDate = moment(options.minDate);

            if (typeof options.maxDate === 'object')
                this.maxDate = moment(options.maxDate);

            if (typeof options.applyClass === 'string')
                this.applyClass = options.applyClass;

            if (typeof options.cancelClass === 'string')
                this.cancelClass = options.cancelClass;

            if (typeof options.dateLimit === 'object')
                this.dateLimit = options.dateLimit;

            if (typeof options.locale === 'object') {

                if (typeof options.locale.daysOfWeek === 'object') {
                    // Create a copy of daysOfWeek to avoid modification of original
                    // options object for reusability in multiple daterangepicker instances
                    this.locale.daysOfWeek = options.locale.daysOfWeek.slice();
                }

                if (typeof options.locale.monthNames === 'object') {
                  this.locale.monthNames = options.locale.monthNames.slice();
                }

                if (typeof options.locale.firstDay === 'number') {
                  this.locale.firstDay = options.locale.firstDay;
                }

                if (typeof options.locale.applyLabel === 'string') {
                  this.locale.applyLabel = options.locale.applyLabel;
                }

                if (typeof options.locale.cancelLabel === 'string') {
                  this.locale.cancelLabel = options.locale.cancelLabel;
                }

                if (typeof options.locale.fromLabel === 'string') {
                  this.locale.fromLabel = options.locale.fromLabel;
                }

                if (typeof options.locale.toLabel === 'string') {
                  this.locale.toLabel = options.locale.toLabel;
                }

                if (typeof options.locale.weekLabel === 'string') {
                  this.locale.weekLabel = options.locale.weekLabel;
                }

                if (typeof options.locale.customRangeLabel === 'string') {
                  this.locale.customRangeLabel = options.locale.customRangeLabel;
                }
            }

            if (typeof options.opens === 'string')
                this.opens = options.opens;

            if (typeof options.drops === 'string')
                this.drops = options.drops;

            if (typeof options.showWeekNumbers === 'boolean') {
                this.showWeekNumbers = options.showWeekNumbers;
            }

            if (typeof options.buttonClasses === 'string') {
                this.buttonClasses = [options.buttonClasses];
            }

            if (typeof options.buttonClasses === 'object') {
                this.buttonClasses = options.buttonClasses;
            }

            if (typeof options.showDropdowns === 'boolean') {
                this.showDropdowns = options.showDropdowns;
            }

            if (typeof options.singleDatePicker === 'boolean') {
                this.singleDatePicker = options.singleDatePicker;
                if (this.singleDatePicker) {
                    this.endDate = this.startDate.clone();
                }
            }

            if (typeof options.timePicker === 'boolean') {
                this.timePicker = options.timePicker;
            }

            if (typeof options.timePickerSeconds === 'boolean') {
                this.timePickerSeconds = options.timePickerSeconds;
            }

            if (typeof options.timePickerIncrement === 'number') {
                this.timePickerIncrement = options.timePickerIncrement;
            }

            if (typeof options.timePicker12Hour === 'boolean') {
                this.timePicker12Hour = options.timePicker12Hour;
            }

            // update day names order to firstDay
            if (this.locale.firstDay != 0) {
                var iterator = this.locale.firstDay;
                while (iterator > 0) {
                    this.locale.daysOfWeek.push(this.locale.daysOfWeek.shift());
                    iterator--;
                }
            }

            var start, end, range;

            //if no start/end dates set, check if an input element contains initial values
            if (typeof options.startDate === 'undefined' && typeof options.endDate === 'undefined') {
                if ($(this.element).is('input[type=text]')) {
                    var val = $(this.element).val(),
                        split = val.split(this.separator);

                    start = end = null;

                    if (split.length == 2) {
                        start = moment(split[0], this.format);
                        end = moment(split[1], this.format);
                    } else if (this.singleDatePicker && val !== "") {
                        start = moment(val, this.format);
                        end = moment(val, this.format);
                    }
                    if (start !== null && end !== null) {
                        this.startDate = start;
                        this.endDate = end;
                    }
                }
            }

            // bind the time zone used to build the calendar to either the timeZone passed in through the options or the zone of the startDate (which will be the local time zone by default)
            if (typeof options.timeZone === 'string' || typeof options.timeZone === 'number') {
            	if (typeof options.timeZone === 'string' && typeof moment.tz !== 'undefined') {
            		this.timeZone = moment.tz.zone(options.timeZone).parse(new Date) * -1;	// Offset is positive if the timezone is behind UTC and negative if it is ahead.
            	} else {
            		this.timeZone = options.timeZone;
            	}
              this.startDate.utcOffset(this.timeZone);
              this.endDate.utcOffset(this.timeZone);
            } else {
                this.timeZone = moment(this.startDate).utcOffset();
            }

            if (typeof options.ranges === 'object') {
                for (range in options.ranges) {

                    if (typeof options.ranges[range][0] === 'string')
                        start = moment(options.ranges[range][0], this.format);
                    else
                        start = moment(options.ranges[range][0]);

                    if (typeof options.ranges[range][1] === 'string')
                        end = moment(options.ranges[range][1], this.format);
                    else
                        end = moment(options.ranges[range][1]);

                    // If we have a min/max date set, bound this range
                    // to it, but only if it would otherwise fall
                    // outside of the min/max.
                    if (this.minDate && start.isBefore(this.minDate))
                        start = moment(this.minDate);

                    if (this.maxDate && end.isAfter(this.maxDate))
                        end = moment(this.maxDate);

                    // If the end of the range is before the minimum (if min is set) OR
                    // the start of the range is after the max (also if set) don't display this
                    // range option.
                    if ((this.minDate && end.isBefore(this.minDate)) || (this.maxDate && start.isAfter(this.maxDate))) {
                        continue;
                    }

                    this.ranges[range] = [start, end];
                }

                var list = '<ul>';
                for (range in this.ranges) {
                    list += '<li>' + range + '</li>';
                }
                list += '<li class="no_display_strict">' + this.locale.customRangeLabel + '</li>';
                list += '</ul>';
                this.container.find('.ranges ul').remove();
                this.container.find('.ranges').prepend(list);
            }

            if (typeof callback === 'function') {
                this.cb = callback;
            }

            if (!this.timePicker) {
                this.startDate = this.startDate.startOf('day');
                this.endDate = this.endDate.endOf('day');
            }

            if (this.singleDatePicker) {
                this.opens = 'right';
                this.container.addClass('single');
                this.container.find('.calendar.right').show();
                this.container.find('.calendar.left').hide();
                if (!this.timePicker) {
                    this.container.find('.ranges').hide();
                } else {
                    this.container.find('.ranges .daterangepicker_start_input, .ranges .daterangepicker_end_input').hide();
                }
                if (!this.container.find('.calendar.right').hasClass('single'))
                    this.container.find('.calendar.right').addClass('single');
            } else {
                this.container.removeClass('single');
                this.container.find('.calendar.right').removeClass('single');
                this.container.find('.ranges').show();
            }

            this.oldStartDate = this.startDate.clone();
            this.oldEndDate = this.endDate.clone();
            this.oldChosenLabel = this.chosenLabel;

            this.leftCalendar = {
                month: moment([this.startDate.year(), this.startDate.month(), 1, this.startDate.hour(), this.startDate.minute(), this.startDate.second()]),
                calendar: []
            };

            this.rightCalendar = {
                month: moment([this.endDate.year(), this.endDate.month(), 1, this.endDate.hour(), this.endDate.minute(), this.endDate.second()]),
                calendar: []
            };

            if (this.opens == 'right' || this.opens == 'center') {
                //swap calendar positions
                var first = this.container.find('.calendar.second');
                var second = this.container.find('.calendar.first');

                if (second.hasClass('single')) {
                    second.removeClass('single');
                    first.addClass('single');
                }

                first.removeClass('left').addClass('right');
                second.removeClass('right').addClass('left');

                if (this.singleDatePicker) {
                    first.show();
                    second.hide();
                }
            }

            if (typeof options.ranges === 'undefined' && !this.singleDatePicker) {
                this.container.addClass('show-calendar');
            }

            this.container.removeClass('opensleft opensright').addClass('opens' + this.opens);

            this.updateView();
            this.updateCalendars();

            //apply CSS classes and labels to buttons
            var c = this.container;
            $.each(this.buttonClasses, function (idx, val) {
                c.find('button').addClass(val);
            });
            this.container.find('.daterangepicker_start_input label').html(this.locale.fromLabel);
            this.container.find('.daterangepicker_end_input label').html(this.locale.toLabel);
            if (this.applyClass.length)
                this.container.find('.applyBtn').addClass(this.applyClass);
            if (this.cancelClass.length)
                this.container.find('.cancelBtn').addClass(this.cancelClass);
            this.container.find('.applyBtn').html(this.locale.applyLabel);
            this.container.find('.cancelBtn').html(this.locale.cancelLabel);
        },

        setStartDate: function(startDate) {
            if (typeof startDate === 'string')
                this.startDate = moment(startDate, this.format).utcOffset(this.timeZone);

            if (typeof startDate === 'object')
                this.startDate = moment(startDate);

            if (!this.timePicker)
                this.startDate = this.startDate.startOf('day');

            this.oldStartDate = this.startDate.clone();

            this.updateView();
            this.updateCalendars();
            this.updateInputText();
        },

        setEndDate: function(endDate) {
            if (typeof endDate === 'string')
                this.endDate = moment(endDate, this.format).utcOffset(this.timeZone);

            if (typeof endDate === 'object')
                this.endDate = moment(endDate);

            if (!this.timePicker)
                this.endDate = this.endDate.endOf('day');

            this.oldEndDate = this.endDate.clone();

            this.updateView();
            this.updateCalendars();
            this.updateInputText();
        },

        updateView: function () {
            this.leftCalendar.month.month(this.startDate.month()).year(this.startDate.year()).hour(this.startDate.hour()).minute(this.startDate.minute());
            this.rightCalendar.month.month(this.endDate.month()).year(this.endDate.year()).hour(this.endDate.hour()).minute(this.endDate.minute());
            this.updateFormInputs();
        },

        updateFormInputs: function () {
            this.container.find('input[name=daterangepicker_start]').val(this.startDate.format(this.format));
            this.container.find('input[name=daterangepicker_end]').val(this.endDate.format(this.format));

            if (this.startDate.isSame(this.endDate) || this.startDate.isBefore(this.endDate)) {
                this.container.find('button.applyBtn').removeAttr('disabled');
            } else {
                this.container.find('button.applyBtn').attr('disabled', 'disabled');
            }
        },

        updateFromControl: function () {
            if (!this.element.is('input')) return;
            if (!this.element.val().length) return;

            var dateString = this.element.val().split(this.separator),
                start = null,
                end = null;

            if(dateString.length === 2) {
                start = moment(dateString[0], this.format).utcOffset(this.timeZone);
                end = moment(dateString[1], this.format).utcOffset(this.timeZone);
            }

            if (this.singleDatePicker || start === null || end === null) {
                start = moment(this.element.val(), this.format).utcOffset(this.timeZone);
                end = start;
            }

            if (end.isBefore(start)) return;

            this.oldStartDate = this.startDate.clone();
            this.oldEndDate = this.endDate.clone();

            this.startDate = start;
            this.endDate = end;

            if (!this.startDate.isSame(this.oldStartDate) || !this.endDate.isSame(this.oldEndDate))
                this.notify();

            this.updateCalendars();
        },
        
        keydown: function (e) {
            //hide on tab or enter
        	if ((e.keyCode === 9) || (e.keyCode === 13)) {
        		this.hide();
        	}
        },

        notify: function () {
            this.updateView();
            this.cb(this.startDate, this.endDate, this.chosenLabel);
        },

        move: function () {
            var parentOffset = { top: 0, left: 0 },
            	containerTop;
            var parentRightEdge = $(window).width();
            if (!this.parentEl.is('body')) {
                parentOffset = {
                    top: this.parentEl.offset().top - this.parentEl.scrollTop(),
                    left: this.parentEl.offset().left - this.parentEl.scrollLeft()
                };
                parentRightEdge = this.parentEl[0].clientWidth + this.parentEl.offset().left;
            }
            
            if (this.drops == 'up')
            	containerTop = this.element.offset().top - this.container.outerHeight() - parentOffset.top;
            else
            	containerTop = this.element.offset().top + this.element.outerHeight() - parentOffset.top;
            this.container[this.drops == 'up' ? 'addClass' : 'removeClass']('dropup');

            if (this.opens == 'left') {
                this.container.css({
                    top: containerTop,
                    right: parentRightEdge - this.element.offset().left - this.element.outerWidth(),
                    left: 'auto'
                });
                if (this.container.offset().left < 0) {
                    this.container.css({
                        right: 'auto',
                        left: 9
                    });
                }
            } else if (this.opens == 'center') {
                this.container.css({
                    top: containerTop,
                    left: this.element.offset().left - parentOffset.left + this.element.outerWidth() / 2
                            - this.container.outerWidth() / 2,
                    right: 'auto'
                });
                if (this.container.offset().left < 0) {
                    this.container.css({
                        right: 'auto',
                        left: 9
                    });
                }
            } else {
                this.container.css({
                    top: containerTop,
                    left: this.element.offset().left - parentOffset.left,
                    right: 'auto'
                });
                if (this.container.offset().left + this.container.outerWidth() > $(window).width()) {
                    this.container.css({
                        left: 'auto',
                        right: 0
                    });
                }
            }
        },

        toggle: function (e) {
            if (this.element.hasClass('active')) {
                this.hide();
            } else {
                this.show();
            }
        },

        show: function (e) {
            if (this.isShowing) return;

            this.element.addClass('active');
            this.container.show();
            this.move();

            // Create a click proxy that is private to this instance of datepicker, for unbinding
            this._outsideClickProxy = $.proxy(function (e) { this.outsideClick(e); }, this);
            // Bind global datepicker mousedown for hiding and
            $(document)
              .on('mousedown.daterangepicker', this._outsideClickProxy)
              // also support mobile devices
              .on('touchend.daterangepicker', this._outsideClickProxy)
              // also explicitly play nice with Bootstrap dropdowns, which stopPropagation when clicking them
              .on('click.daterangepicker', '[data-toggle=dropdown]', this._outsideClickProxy)
              // and also close when focus changes to outside the picker (eg. tabbing between controls)
              .on('focusin.daterangepicker', this._outsideClickProxy);

            this.isShowing = true;
            this.element.trigger('show.daterangepicker', this);
        },

        outsideClick: function (e) {
            var target = $(e.target);
            // if the page is clicked anywhere except within the daterangerpicker/button
            // itself then call this.hide()
            if (
                // ie modal dialog fix
                e.type == "focusin" ||
                target.closest(this.element).length ||
                target.closest(this.container).length ||
                target.closest('.calendar-date').length
                ) return;
            this.hide();
        },

        hide: function (e) {
            if (!this.isShowing) return;

            $(document)
              .off('.daterangepicker');

            this.element.removeClass('active');
            this.container.hide();

            if (!this.startDate.isSame(this.oldStartDate) || !this.endDate.isSame(this.oldEndDate))
                this.notify();

            this.oldStartDate = this.startDate.clone();
            this.oldEndDate = this.endDate.clone();

            this.isShowing = false;
            this.element.trigger('hide.daterangepicker', this);
        },

        enterRange: function (e) {
            // mouse pointer has entered a range label
            var label = e.target.innerHTML;
            if (label == this.locale.customRangeLabel) {
                this.updateView();
            } else {
                var dates = this.ranges[label];
                this.container.find('input[name=daterangepicker_start]').val(dates[0].format(this.format));
                this.container.find('input[name=daterangepicker_end]').val(dates[1].format(this.format));
            }
        },

        showCalendars: function() {
            this.container.addClass('show-calendar');
            this.move();
            this.element.trigger('showCalendar.daterangepicker', this);
        },

        hideCalendars: function() {
            this.container.removeClass('show-calendar');
            this.element.trigger('hideCalendar.daterangepicker', this);
        },

        // when a date is typed into the start to end date textboxes
        inputsChanged: function (e) {
            var el = $(e.target);
            var date = moment(moment(el.val()).format(this.format), this.format);
            if (!date.isValid()) return;

            var startDate, endDate;
            if (el.attr('name') === 'daterangepicker_start') {
                startDate = (false !== this.minDate && date.isBefore(this.minDate)) ? this.minDate : date;
                endDate = this.endDate;
            } else {
                startDate = this.startDate;
                endDate = (false !== this.maxDate && date.isAfter(this.maxDate)) ? this.maxDate : date;
            }
            this.setCustomDates(startDate, endDate);
        },

        inputsKeydown: function(e) {
            if (e.keyCode === 13) {
                this.inputsChanged(e);
                this.notify();
            }
        },

        updateInputText: function() {
            if (this.element.is('input') && !this.singleDatePicker) {
                this.element.val(this.startDate.format(this.format) + this.separator + this.endDate.format(this.format));
                this.element.trigger('change');
            } else if (this.element.is('input')) {
                this.element.val(this.endDate.format(this.format));
                this.element.trigger('change');
            }
        },

        clickRange: function (e) {
            var label = e.target.innerHTML;
            this.chosenLabel = label;
            if (label == this.locale.customRangeLabel) {
                this.showCalendars();
            } else {
                var dates = this.ranges[label];

                this.startDate = dates[0];
                this.endDate = dates[1];

                if (!this.timePicker) {
                    this.startDate.startOf('day');
                    this.endDate.endOf('day');
                }

                this.leftCalendar.month.month(this.startDate.month()).year(this.startDate.year()).hour(this.startDate.hour()).minute(this.startDate.minute());
                this.rightCalendar.month.month(this.endDate.month()).year(this.endDate.year()).hour(this.endDate.hour()).minute(this.endDate.minute());
                this.updateCalendars();

                this.updateInputText();

                this.hideCalendars();
                this.hide();
                this.element.trigger('apply.daterangepicker', this);
            }
        },

        clickPrev: function (e) {
            var cal = $(e.target).parents('.calendar');
            if (cal.hasClass('left')) {
                this.leftCalendar.month.subtract(1, 'month');
            } else {
                this.rightCalendar.month.subtract(1, 'month');
            }
            this.updateCalendars();
        },

        clickNext: function (e) {
            var cal = $(e.target).parents('.calendar');
            if (cal.hasClass('left')) {
                this.leftCalendar.month.add(1, 'month');
            } else {
                this.rightCalendar.month.add(1, 'month');
            }
            this.updateCalendars();
        },

        hoverDate: function (e) {
            var title = $(e.target).attr('data-title');
            var row = title.substr(1, 1);
            var col = title.substr(3, 1);
            var cal = $(e.target).parents('.calendar');

            if (cal.hasClass('left')) {
                this.container.find('input[name=daterangepicker_start]').val(this.leftCalendar.calendar[row][col].format(this.format));
            } else {
                this.container.find('input[name=daterangepicker_end]').val(this.rightCalendar.calendar[row][col].format(this.format));
            }
        },

        setCustomDates: function(startDate, endDate) {
            this.chosenLabel = this.locale.customRangeLabel;
            if (startDate.isAfter(endDate)) {
                var difference = this.endDate.diff(this.startDate);
                endDate = moment(startDate).add(difference, 'ms');
                if (this.maxDate && endDate.isAfter(this.maxDate)) {
                  endDate = this.maxDate.clone();
                }
            }
            this.startDate = startDate;
            this.endDate = endDate;

            this.updateView();
            this.updateCalendars();
        },

        clickDate: function (e) {
            var title = $(e.target).attr('data-title');
            var row = title.substr(1, 1);
            var col = title.substr(3, 1);
            var cal = $(e.target).parents('.calendar');

            var startDate, endDate;
            if (cal.hasClass('left')) {
                startDate = this.leftCalendar.calendar[row][col];
                endDate = this.endDate;
                if (typeof this.dateLimit === 'object') {
                    var maxDate = moment(startDate).add(this.dateLimit).startOf('day');
                    if (endDate.isAfter(maxDate)) {
                        endDate = maxDate;
                    }
                }
            } else {
                startDate = this.startDate;
                endDate = this.rightCalendar.calendar[row][col];
                if (typeof this.dateLimit === 'object') {
                    var minDate = moment(endDate).subtract(this.dateLimit).startOf('day');
                    if (startDate.isBefore(minDate)) {
                        startDate = minDate;
                    }
                }
            }

            if (this.singleDatePicker && cal.hasClass('left')) {
                endDate = startDate.clone();
            } else if (this.singleDatePicker && cal.hasClass('right')) {
                startDate = endDate.clone();
            }

            cal.find('td').removeClass('active');

            $(e.target).addClass('active');

            this.setCustomDates(startDate, endDate);

            if (!this.timePicker)
                endDate.endOf('day');

            if (this.singleDatePicker && !this.timePicker)
                this.clickApply();
        },

        clickApply: function (e) {
            this.updateInputText();
            this.hide();
            this.element.trigger('apply.daterangepicker', this);
            return false;
        },

        clickCancel: function (e) {
            this.startDate = this.oldStartDate;
            this.endDate = this.oldEndDate;
            this.chosenLabel = this.oldChosenLabel;
            this.updateView();
            this.updateCalendars();
            this.hide();
            this.element.trigger('cancel.daterangepicker', this);
            return false;
        },

        updateMonthYear: function (e) {
            var isLeft = $(e.target).closest('.calendar').hasClass('left'),
                leftOrRight = isLeft ? 'left' : 'right',
                cal = this.container.find('.calendar.'+leftOrRight);

            // Month must be Number for new moment versions
            var month = parseInt(cal.find('.monthselect').val(), 10);
            var year = cal.find('.yearselect').val();

            if (!isLeft && !this.singleDatePicker) {
                if (year < this.startDate.year() || (year == this.startDate.year() && month < this.startDate.month())) {
                    month = this.startDate.month();
                    year = this.startDate.year();
                }
            }

            if (this.minDate) {
                if (year < this.minDate.year() || (year == this.minDate.year() && month < this.minDate.month())) {
                    month = this.minDate.month();
                    year = this.minDate.year();
                }
            }

            if (this.maxDate) {
                if (year > this.maxDate.year() || (year == this.maxDate.year() && month > this.maxDate.month())) {
                    month = this.maxDate.month();
                    year = this.maxDate.year();
                }
            }


            this[leftOrRight+'Calendar'].month.month(month).year(year);
            this.updateCalendars();
        },

        updateTime: function(e) {

            var cal = $(e.target).closest('.calendar'),
                isLeft = cal.hasClass('left');

            var hour = parseInt(cal.find('.hourselect').val(), 10);
            var minute = parseInt(cal.find('.minuteselect').val(), 10);
            var second = 0;

            if (this.timePickerSeconds) {
                second = parseInt(cal.find('.secondselect').val(), 10);
            }

            if (this.timePicker12Hour) {
                var ampm = cal.find('.ampmselect').val();
                if (ampm === 'PM' && hour < 12)
                    hour += 12;
                if (ampm === 'AM' && hour === 12)
                    hour = 0;
            }

            if (isLeft) {
                var start = this.startDate.clone();
                start.hour(hour);
                start.minute(minute);
                start.second(second);
                this.startDate = start;
                this.leftCalendar.month.hour(hour).minute(minute).second(second);
                if (this.singleDatePicker)
                    this.endDate = start.clone();
            } else {
                var end = this.endDate.clone();
                end.hour(hour);
                end.minute(minute);
                end.second(second);
                this.endDate = end;
                if (this.singleDatePicker)
                    this.startDate = end.clone();
                this.rightCalendar.month.hour(hour).minute(minute).second(second);
            }

            this.updateView();
            this.updateCalendars();
        },

        updateCalendars: function () {
            this.leftCalendar.calendar = this.buildCalendar(this.leftCalendar.month.month(), this.leftCalendar.month.year(), this.leftCalendar.month.hour(), this.leftCalendar.month.minute(), this.leftCalendar.month.second(), 'left');
            this.rightCalendar.calendar = this.buildCalendar(this.rightCalendar.month.month(), this.rightCalendar.month.year(), this.rightCalendar.month.hour(), this.rightCalendar.month.minute(), this.rightCalendar.month.second(), 'right');
            this.container.find('.calendar.left').empty().html(this.renderCalendar(this.leftCalendar.calendar, this.startDate, this.minDate, this.maxDate, 'left'));
            this.container.find('.calendar.right').empty().html(this.renderCalendar(this.rightCalendar.calendar, this.endDate, this.singleDatePicker ? this.minDate : this.startDate, this.maxDate, 'right'));

            this.container.find('.ranges li').removeClass('active');
            var customRange = true;
            var i = 0;
            for (var range in this.ranges) {
                if (this.timePicker) {
                    if (this.startDate.isSame(this.ranges[range][0]) && this.endDate.isSame(this.ranges[range][1])) {
                        customRange = false;
                        this.chosenLabel = this.container.find('.ranges li:eq(' + i + ')')
                            .addClass('active').html();
                    }
                } else {
                    //ignore times when comparing dates if time picker is not enabled
                    if (this.startDate.format('YYYY-MM-DD') == this.ranges[range][0].format('YYYY-MM-DD') && this.endDate.format('YYYY-MM-DD') == this.ranges[range][1].format('YYYY-MM-DD')) {
                        customRange = false;
                        this.chosenLabel = this.container.find('.ranges li:eq(' + i + ')')
                            .addClass('active').html();
                    }
                }
                i++;
            }
            if (customRange) {
                this.chosenLabel = this.container.find('.ranges li:last').addClass('active').html();
                this.showCalendars();
            }
        },

        buildCalendar: function (month, year, hour, minute, second, side) {
            var daysInMonth = moment([year, month]).daysInMonth();
            var firstDay = moment([year, month, 1]);
            var lastDay = moment([year, month, daysInMonth]);
            var lastMonth = moment(firstDay).subtract(1, 'month').month();
            var lastYear = moment(firstDay).subtract(1, 'month').year();

            var daysInLastMonth = moment([lastYear, lastMonth]).daysInMonth();

            var dayOfWeek = firstDay.day();

            var i;

            //initialize a 6 rows x 7 columns array for the calendar
            var calendar = [];
            calendar.firstDay = firstDay;
            calendar.lastDay = lastDay;

            for (i = 0; i < 6; i++) {
                calendar[i] = [];
            }

            //populate the calendar with date objects
            var startDay = daysInLastMonth - dayOfWeek + this.locale.firstDay + 1;
            if (startDay > daysInLastMonth)
                startDay -= 7;

            if (dayOfWeek == this.locale.firstDay)
                startDay = daysInLastMonth - 6;

            var curDate = moment([lastYear, lastMonth, startDay, 12, minute, second]).utcOffset(this.timeZone);

            var col, row;
            for (i = 0, col = 0, row = 0; i < 42; i++, col++, curDate = moment(curDate).add(24, 'hour')) {
                if (i > 0 && col % 7 === 0) {
                    col = 0;
                    row++;
                }
                calendar[row][col] = curDate.clone().hour(hour);
                curDate.hour(12);

                if (this.minDate && calendar[row][col].format('YYYY-MM-DD') == this.minDate.format('YYYY-MM-DD') && calendar[row][col].isBefore(this.minDate) && side == 'left') {
                    calendar[row][col] = this.minDate.clone();
                }

                if (this.maxDate && calendar[row][col].format('YYYY-MM-DD') == this.maxDate.format('YYYY-MM-DD') && calendar[row][col].isAfter(this.maxDate) && side == 'right') {
                    calendar[row][col] = this.maxDate.clone();
                }

            }

            return calendar;
        },

        renderDropdowns: function (selected, minDate, maxDate) {
            var currentMonth = selected.month();
            var currentYear = selected.year();
            var maxYear = (maxDate && maxDate.year()) || (currentYear + 5);
            var minYear = (minDate && minDate.year()) || (currentYear - 50);

            //var monthHtml = '<select class="monthselect">';
            var monthHtml = '<div class="vg-default-small-dropdown monthselectwidth "><select class="monthselect">';
            var inMinYear = currentYear == minYear;
            var inMaxYear = currentYear == maxYear;

            for (var m = 0; m < 12; m++) {
                if ((!inMinYear || m >= minDate.month()) && (!inMaxYear || m <= maxDate.month())) {
                    monthHtml += "<option value='" + m + "'" +
                        (m === currentMonth ? " selected='selected'" : "") +
                        ">" + this.locale.monthNames[m] + "</option>";
                }
            }
            monthHtml += "</select></div>";
            //monthHtml += "</select>";

            //var yearHtml = '<select class="yearselect">';
            var yearHtml = '<div class="vg-default-small-dropdown yearselectwidth "><select class="yearselect">';

            for (var y = minYear; y <= maxYear; y++) {
                yearHtml += '<option value="' + y + '"' +
                    (y === currentYear ? ' selected="selected"' : '') +
                    '>' + y + '</option>';
            }

            //yearHtml += '</select>';
            yearHtml += '</select></div>';

            return monthHtml + yearHtml;
        },

        renderCalendar: function (calendar, selected, minDate, maxDate, side) {

            var html = '<div class="calendar-date">';
            html += '<table class="table-condensed">';
            html += '<thead>';
            html += '<tr>';

            // add empty cell for week number
            if (this.showWeekNumbers)
                html += '<th style="display:none;"></th>';

            if (!minDate || minDate.isBefore(calendar.firstDay)) {
                html += '<th class="prev available"><i class="fa fa-arrow-left icon icon-arrow-left"></i></th>';
            } else {
                html += '<th></th>';
            }

            var dateHtml = this.locale.monthNames[calendar[1][1].month()] + calendar[1][1].format(" YYYY");

            if (this.showDropdowns) {
                dateHtml = this.renderDropdowns(calendar[1][1], minDate, maxDate);
            }

            if (this.showWeekNumbers == false) {
                html += '<th colspan="5" class="month">' + dateHtml + '</th>';
            }
            else {
                html += '<th colspan="6" class="month">' + dateHtml + '</th>';
            }

            if (!maxDate || maxDate.isAfter(calendar.lastDay)) {
                html += '<th class="next available"><i class="fa fa-arrow-right icon icon-arrow-right"></i></th>';
            } else {
                html += '<th></th>';
            }

            html += '</tr>';
            html += '<tr>';

            // add week number label
            if (this.showWeekNumbers)
                html += '<th class="week">' + this.locale.weekLabel + '</th>';

            $.each(this.locale.daysOfWeek, function (index, dayOfWeek) {
                html += '<th>' + dayOfWeek + '</th>';
            });

            html += '</tr>';
            html += '</thead>';
            html += '<tbody>';

            for (var row = 0; row < 6; row++) {
                html += '<tr>';

                // add week number
                if (this.showWeekNumbers)
                    html += '<td class="week">' + calendar[row][0].week() + '</td>';

                for (var col = 0; col < 7; col++) {
                    var cname = 'available ';
                    cname += (calendar[row][col].month() == calendar[1][1].month()) ? '' : 'off';

                    if ((minDate && calendar[row][col].isBefore(minDate, 'day')) || (maxDate && calendar[row][col].isAfter(maxDate, 'day'))) {
                        cname = ' off disabled ';
                    } else if (calendar[row][col].format('YYYY-MM-DD') == selected.format('YYYY-MM-DD')) {
                        cname += ' active ';
                        if (calendar[row][col].format('YYYY-MM-DD') == this.startDate.format('YYYY-MM-DD')) {
                            cname += ' start-date ';
                        }
                        if (calendar[row][col].format('YYYY-MM-DD') == this.endDate.format('YYYY-MM-DD')) {
                            cname += ' end-date ';
                        }
                    } else if (calendar[row][col] >= this.startDate && calendar[row][col] <= this.endDate) {
                        cname += ' in-range ';
                        if (calendar[row][col].isSame(this.startDate)) { cname += ' start-date '; }
                        if (calendar[row][col].isSame(this.endDate)) { cname += ' end-date '; }
                    }

                    var title = 'r' + row + 'c' + col;
                    html += '<td class="' + cname.replace(/\s+/g, ' ').replace(/^\s?(.*?)\s?$/, '$1') + '" data-title="' + title + '">' + calendar[row][col].date() + '</td>';
                }
                html += '</tr>';
            }

            html += '</tbody>';
            html += '</table>';
            html += '</div>';

            var i;
            if (this.timePicker) {

                html += '<div class="calendar-time">';
                html += '<select class="hourselect">';

                // Disallow selections before the minDate or after the maxDate
                var min_hour = 0;
                var max_hour = 23;

                if (minDate && (side == 'left' || this.singleDatePicker) && selected.format('YYYY-MM-DD') == minDate.format('YYYY-MM-DD')) {
                    min_hour = minDate.hour();
                    if (selected.hour() < min_hour)
                        selected.hour(min_hour);
                    if (this.timePicker12Hour && min_hour >= 12 && selected.hour() >= 12)
                        min_hour -= 12;
                    if (this.timePicker12Hour && min_hour == 12)
                        min_hour = 1;
                }

                if (maxDate && (side == 'right' || this.singleDatePicker) && selected.format('YYYY-MM-DD') == maxDate.format('YYYY-MM-DD')) {
                    max_hour = maxDate.hour();
                    if (selected.hour() > max_hour)
                        selected.hour(max_hour);
                    if (this.timePicker12Hour && max_hour >= 12 && selected.hour() >= 12)
                        max_hour -= 12;
                }

                var start = 0;
                var end = 23;
                var selected_hour = selected.hour();
                if (this.timePicker12Hour) {
                    start = 1;
                    end = 12;
                    if (selected_hour >= 12)
                        selected_hour -= 12;
                    if (selected_hour === 0)
                        selected_hour = 12;
                }

                for (i = start; i <= end; i++) {

                    if (i == selected_hour) {
                        html += '<option value="' + i + '" selected="selected">' + i + '</option>';
                    } else if (i < min_hour || i > max_hour) {
                        html += '<option value="' + i + '" disabled="disabled" class="disabled">' + i + '</option>';
                    } else {
                        html += '<option value="' + i + '">' + i + '</option>';
                    }
                }

                html += '</select> : ';

                html += '<select class="minuteselect">';

                // Disallow selections before the minDate or after the maxDate
                var min_minute = 0;
                var max_minute = 59;

                if (minDate && (side == 'left' || this.singleDatePicker) && selected.format('YYYY-MM-DD h A') == minDate.format('YYYY-MM-DD h A')) {
                    min_minute = minDate.minute();
                    if (selected.minute() < min_minute)
                        selected.minute(min_minute);
                }

                if (maxDate && (side == 'right' || this.singleDatePicker) && selected.format('YYYY-MM-DD h A') == maxDate.format('YYYY-MM-DD h A')) {
                    max_minute = maxDate.minute();
                    if (selected.minute() > max_minute)
                        selected.minute(max_minute);
                }

                for (i = 0; i < 60; i += this.timePickerIncrement) {
                    var num = i;
                    if (num < 10)
                        num = '0' + num;
                    if (i == selected.minute()) {
                        html += '<option value="' + i + '" selected="selected">' + num + '</option>';
                    } else if (i < min_minute || i > max_minute) {
                        html += '<option value="' + i + '" disabled="disabled" class="disabled">' + num + '</option>';
                    } else {
                        html += '<option value="' + i + '">' + num + '</option>';
                    }
                }

                html += '</select> ';

                if (this.timePickerSeconds) {
                    html += ': <select class="secondselect">';

                    for (i = 0; i < 60; i += this.timePickerIncrement) {
                        var num = i;
                        if (num < 10)
                            num = '0' + num;
                        if (i == selected.second()) {
                            html += '<option value="' + i + '" selected="selected">' + num + '</option>';
                        } else {
                            html += '<option value="' + i + '">' + num + '</option>';
                        }
                    }

                    html += '</select>';
                }

                if (this.timePicker12Hour) {
                    html += '<select class="ampmselect">';

                    // Disallow selection before the minDate or after the maxDate
                    var am_html = '';
                    var pm_html = '';

                    if (minDate && (side == 'left' || this.singleDatePicker) && selected.format('YYYY-MM-DD') == minDate.format('YYYY-MM-DD') && minDate.hour() >= 12) {
                        am_html = ' disabled="disabled" class="disabled"';
                    }

                    if (maxDate && (side == 'right' || this.singleDatePicker) && selected.format('YYYY-MM-DD') == maxDate.format('YYYY-MM-DD') && maxDate.hour() < 12) {
                        pm_html = ' disabled="disabled" class="disabled"';
                    }

                    if (selected.hour() >= 12) {
                        html += '<option value="AM"' + am_html + '>AM</option><option value="PM" selected="selected"' + pm_html + '>PM</option>';
                    } else {
                        html += '<option value="AM" selected="selected"' + am_html + '>AM</option><option value="PM"' + pm_html + '>PM</option>';
                    }
                    html += '</select>';
                }

                html += '</div>';

            }

            return html;

        },

        remove: function() {

            this.container.remove();
            this.element.off('.daterangepicker');
            this.element.removeData('daterangepicker');

        }

    };

    $.fn.daterangepicker = function (options, cb) {
        this.each(function () {
            var el = $(this);
            if (el.data('daterangepicker'))
                el.data('daterangepicker').remove();
            el.data('daterangepicker', new DateRangePicker(el, options, cb));
        });
        return this;
    };

}));
;
(function ($) {
    $.fn.mobileFullDatePicker = function (settings) {
        var vg = {
            defaultOptions: {
                numberOfMonths: 3,
                selectedDate: new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate()),
                minDate: new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate()),
                maxDate: new Date(new Date().getFullYear(), new Date().getMonth() + 7, new Date().getDate()),
                preset: "date",
                dateFormat: "MMM DD, YYYY",
                arrValidDates: [],
                arrInValidDates: [],
                validDatesFormat: "MMM DD,YYYY",
                inValidDatesFormat: "MMM DD,YYYY",
                disabledWeekDays: []
            },
            monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
            disabledClass: "vg_disable",
            todayClass: "vg_today",
            activeClass: "vg_current",
            currentDate: null
        };

        (function (input, options) {
            //Element not found
            if ($(input).length == 0) {
                return;
            }
            var objContainerDiv = $("#vgCalendar_" + input.attr("id"));

            //Destroy date time picker
            if (typeof (options) == "string" && options.toLowerCase() == "destroy") {
                destroyDatePicker();
                return;
            }
            else if (typeof (options) == "string" && options.toLowerCase() == "show") {
                if (!objContainerDiv.is(":visible")) {
                    showHide(true);
                }
                return;
            }
            else if (typeof (options) == "string" && options.toLowerCase() == "hide") {
                if (objContainerDiv.is(":visible")) {
                    showHide(false);
                }
                return;
            }
            else if (typeof (options) == "object" && typeof (options.value) != "undefined" && isValidDate(options.value)) {
                if (objContainerDiv.length > 0 && $("#hdnOldOptions", objContainerDiv).length > 0 && $("#hdnOldOptions", objContainerDiv).val() != "") {
                    var objOldOptions = $.parseJSON($("#hdnOldOptions", objContainerDiv).val());
                    if (objOldOptions != null) {
                        setOptionValues(objOldOptions);
                    }
                }
                setSelectedDate(input, options.value);
                return;
            }
            else {
                if (typeof (options) != "undefined" && options != null) {
                    setOptionValues(vg.defaultOptions);
                }
                else {
                    options = vg.defaultOptions;
                }

                if (objContainerDiv.length > 0) {
                    destroyDatePicker();
                }
                //Generate calendar initialy
                initializeCalendar();

                //Generate calendar on textbox click
                $(input).on("click touchstart", function (e) {
                    e.preventDefault();
                    if ($(input).prop('disabled')) {
                        return;
                    }

                    vg.currentDate = getSelectedDate(input);
                    var objCalendar = $("#vgCalendar_" + input.attr("id"));
                    if (objCalendar.length == 0) {
                        initializeCalendar();
                    }
                    showHide(true);
                });
            }

            //Set missing option values from default option
            function setOptionValues(objOldOptions) {
                if (typeof (options.preset) == "undefined" || options.preset == null || options.preset == "") {
                    options.preset = "date";
                }

                if (typeof (options.container) == "undefined" || options.container == null) {
                    options.container = $('body');
                }

                if (typeof (options.numberOfMonths) == "undefined" || isNaN(parseInt(options.numberOfMonths))) {
                    options.numberOfMonths = objOldOptions.numberOfMonths;
                }

                if (typeof (options.selectedDate) == "undefined" || isNaN(options.selectedDate.getDate())) {
                    options.selectedDate = new Date(objOldOptions.selectedDate);
                }

                if (typeof (options.minDate) == "undefined" || isNaN(options.minDate.getDate())) {
                    options.minDate = new Date(objOldOptions.minDate);
                }

                if (typeof (options.maxDate) == "undefined" || isNaN(options.maxDate.getDate())) {
                    options.maxDate = new Date(objOldOptions.maxDate);
                }

                if (typeof (options.dateFormat) == "undefined" || options.dateFormat == null || options.dateFormat == "") {
                    options.dateFormat = objOldOptions.dateFormat;
                }

                if (typeof (options.arrValidDates) == "undefined" || options.arrValidDates == null || options.arrValidDates == "") {
                    options.arrValidDates = objOldOptions.arrValidDates;
                }

                if (typeof (options.arrInValidDates) == "undefined" || options.arrInValidDates == null || options.arrInValidDates == "") {
                    options.arrInValidDates = objOldOptions.arrInValidDates;
                }

                if (typeof (options.validDatesFormat) == "undefined" || options.validDatesFormat == null || options.validDatesFormat == "") {
                    options.validDatesFormat = objOldOptions.validDatesFormat;
                }
                else {
                    options.validDatesFormat = options.validDatesFormat.toUpperCase();
                }

                if (typeof (options.inValidDatesFormat) == "undefined" || options.inValidDatesFormat == null || options.inValidDatesFormat == "") {
                    options.inValidDatesFormat = objOldOptions.inValidDatesFormat;
                }
                else {
                    options.inValidDatesFormat = options.inValidDatesFormat.toUpperCase();
                }

                if (typeof (options.disabledWeekDays) == "undefined" || options.disabledWeekDays == null || options.disabledWeekDays == "") {
                    options.disabledWeekDays = objOldOptions.disabledWeekDays;
                }
            }

            //Check if date is valid or not based on mindate, maxdate and valid/invalid dates
            function isValidDate(dateToValidate) {
                var flagValid = true;
                var date = new Date(dateToValidate);
                var minDate = new Date(options.minDate);
                var maxDate = new Date(options.maxDate);
                if (options.preset.toLowerCase() == "date") {
                    date = new Date(date.getFullYear(), date.getMonth(), date.getDate());
                    minDate = new Date(minDate.getFullYear(), minDate.getMonth(), minDate.getDate());
                    maxDate = new Date(maxDate.getFullYear(), maxDate.getMonth(), maxDate.getDate());
                }
                else if (options.preset.toLowerCase() == "datetime") {
                    date = new Date(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), 0, 0);
                    minDate = new Date(minDate.getFullYear(), minDate.getMonth(), minDate.getDate(), minDate.getHours(), minDate.getMinutes(), 0, 0);
                    maxDate = new Date(maxDate.getFullYear(), maxDate.getMonth(), maxDate.getDate(), maxDate.getHours(), maxDate.getMinutes(), 0, 0);
                }
                else if (options.preset.toLowerCase() == "time") {
                    return true;
                }

                if (date < minDate || date > maxDate) {
                    return false;
                }

                if (typeof (options.arrValidDates) != "undefined" && options.arrValidDates != null && options.arrValidDates.length > 0) {
                    if (options.arrValidDates.indexOf(moment(date).format(options.validDatesFormat)) == -1) {
                        flagValid = false;
                    }
                }

                if (flagValid) {
                    if (typeof (options.arrInValidDates) != "undefined" && options.arrInValidDates != null && options.arrInValidDates.length > 0) {
                        if (options.arrInValidDates.indexOf(moment(date).format(options.inValidDatesFormat)) > -1) {
                            return false;
                        }
                    }
                }

                return flagValid;
            }

            //Check for leap year
            function isLeapYear(year) {
                return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
            }

            //Get date difference in month
            function getDateDiffInMonth(date1, date2) {
                var months;
                months = (date2.getFullYear() - date1.getFullYear()) * 12;
                if (months > 0) {
                    months -= date1.getMonth() + 1;
                    months += date2.getMonth();
                }
                else {
                    months = date2.getMonth() - date1.getMonth();
                }
                return months <= 0 ? 0 : months;
            }

            //Get total number days in month
            function getDaysOfMonth(month, year) {
                return new Date(year, month, 0).getDate();
            }

            function initializeCalendar() {
                var objCalendar = $('<div id="vgCalendar_' + input.attr("id") + '" class="vg_calendar-container' + (options.preset.toLowerCase() == "time" ? " vg_timepicker-design" : "") + '" />');
                var objHdnOldOptions = $('<input type="hidden" id="hdnOldOptions" value="" />');
                var objHeader = $('<div class="vg_cal-header" />');
                var objCloseButton = $('<div class="vg_cal_head"><div class="vg_cal-close font-awesome-light">&#xf00d;</div></div>');
                
                if (options.preset.toLowerCase() != "time") {
                    var objParent = $('<div id="divYears" class="w-custom-dropdown dropdown-datepicker" />');
                    var ddlYears = $('<select class="vg_cal_years" />');
                    ddlYears.on("change", function () {
                        var objContainer = $("#vgCalendar_" + input.attr("id"));
                        var objMonthContent = objContainer.find(".vg_calendar-date-div");
                        var objNextButton = objContainer.find(".vg_cal-next-button");
                        var year = parseInt(ddlYears.val());

                        objMonthContent.empty();
                        objNextButton.data("nextmonth", 0);
                        objNextButton.data("nextyear", year);
                        objNextButton.click();
                    });

                    for (i = options.minDate.getFullYear() ; i <= options.maxDate.getFullYear() ; i++) {
                        $('<option value="' + i + '"' + (i == options.selectedDate.getFullYear() ? " selected" : "") + '>' + i + '</option>').appendTo(ddlYears);
                    }
                    ddlYears.appendTo(objParent);
                    objParent.appendTo(objHeader);
                }
                if (options.preset.toLowerCase() == "datetime") {
                    var btnBack = $('<div class="vg_back-arrow" style="display:none;">&#xf104;</div>');
                    $(btnBack).click(function () {
                        objCalendar.removeClass("vg_timepicker-design");
                        $(".vg_calendar-times", objCalendar).hide();
                        $(".vg_back-arrow", objCalendar).hide();
                        $("#divYears", objCalendar).show();
                        $(".vg_calendar-dates", objCalendar).show();
                        $(".vg_cal-week-div", objCalendar).show();
                        $(".vg_cal-next-button", objCalendar).show();
                    });
                    $(btnBack).appendTo(objHeader);
                }
                objHdnOldOptions.val(JSON.stringify(options));
                objHdnOldOptions.appendTo(objCalendar);
                $(objCloseButton).on("click touchstart", function (e1) {
                    e1.preventDefault();
                    closeDatePicker();
                });
                $(objCloseButton).appendTo(objHeader);
                $(objHeader).appendTo(objCalendar);
                $(objCalendar).appendTo(options.container);
                if (options.preset.toLowerCase() == "date" || options.preset.toLowerCase() == "datetime") {
                    var objWeekDays = $('<div class="vg_cal-week-div w-clearfix"><div class="vg_cal-week-day">Su</div><div class="vg_cal-week-day">Mo</div><div class="vg_cal-week-day">Tu</div><div class="vg_cal-week-day">We</div><div class="vg_cal-week-day">Th</div><div class="vg_cal-week-day">Fr</div><div class="vg_cal-week-day">Sa</div></div>');
                    var objMain = $('<div class="vg_calendar-dates" />');
                    var objMainDate = $('<div class="vg_calendar-date-div" />');
                    var objNextButton = $('<div class="vg_cal-next-button font-awesome-light">&#xf107;</div>');
                    $(objWeekDays).appendTo(objHeader);
                    $(objMainDate).appendTo(objMain);
                    $(objNextButton).on("click", function (e2) {
                        e2.preventDefault();
                        generateCalendarDates(input);
                        setDateHights();
                    });
                    $(objNextButton).data("nextmonth", options.selectedDate.getMonth());
                    $(objNextButton).data("nextyear", options.selectedDate.getFullYear());
                    $(objNextButton).appendTo(objMain);
                    $(objMain).appendTo(objCalendar);

                    var numberOfMonths = options.numberOfMonths;
                    var diff = getDateDiffInMonth(options.selectedDate, options.minDate);
                    if (diff > numberOfMonths) {
                        options.numberOfMonths = diff;
                    }

                    //Initial Generate Calendar
                    generateCalendarDates(input);
                    options.numberOfMonths = numberOfMonths;
                    setSelectedDate(input, isValidDate(options.selectedDate) ? options.selectedDate : options.minDate, false);
                }
                
                if (options.preset.toLowerCase() == "time" || options.preset.toLowerCase() == "datetime") {
                    var objMain = $('<div class="vg_calendar-times" style="' + (options.preset.toLowerCase() == "datetime" ? "display:none;" : "") + '" />');
                    var objMainTime = $('<div class="vg_calendar-time-div" />');
                    var objAmPm = $('<div class="vg_calendar-time-ampm" />');
                    var objAm = $('<div class="vg_calendar-time-am active">AM</div>');
                    var objPm = $('<div class="vg_calendar-time-pm">PM</div>');
                    var objButtons = $('<div class="vg_calendar-time-buttons" />');
                    var btnCancel = $('<button class="vg_calendar-btn-default">Cancel</button>');
                    var btnOk = $('<button class="vg_calendar-btn-primary">Ok</button>');
                    objAm.click(function (e) {
                        e.preventDefault();
                        if ($(this).hasClass(vg.disabledClass)) {
                            return false;
                        }
                        objPm.removeClass("active");
                        objAm.addClass("active");

                        if (options.preset.toLowerCase() == "datetime") {
                            //Disable previous time
                            disableTime(input);
                        }
                    });
                    objAm.appendTo(objAmPm);
                    objPm.click(function (e) {
                        e.preventDefault();
                        if ($(this).hasClass(vg.disabledClass)) {
                            return false;
                        }
                        objAm.removeClass("active");
                        objPm.addClass("active");

                        if (options.preset.toLowerCase() == "datetime") {
                            //Disable previous time
                            disableTime(input);
                        }
                    });
                    objPm.appendTo(objAmPm);
                    
                    btnCancel.click(function (e) {
                        e.preventDefault();
                        closeDatePicker();
                    });
                    btnOk.click(function (e) {
                        e.preventDefault();
                        var selectedDate = new Date();
                        if (options.preset == "date" || options.preset == "datetime") {
                            var objDatesDiv = $(".vg_calendar-dates", objCalendar);
                            var date = objDatesDiv.find("." + vg.activeClass).data("value").split("-");
                            selectedDate = new Date(date[0], date[1] - 1, date[2]);
                        }
                        if (options.preset == "time" || options.preset == "datetime") {
                            var objTimeDiv = $(".vg_calendar-times", objCalendar)
                            var tblHours = $(".vg_cal-hours", objTimeDiv);
                            var tblMinutes = $(".vg_cal-minutes", objTimeDiv);
                            var hours = tblHours.find("." + vg.activeClass).data("value");
                            var minutes = tblMinutes.find("." + vg.activeClass).data("value");

                            if ($(".vg_calendar-time-pm", objTimeDiv).hasClass("active") && hours < 12) {
                                hours += 12;
                            }

                            selectedDate.setHours(hours);
                            selectedDate.setMinutes(minutes);
                        }
                        setSelectedDate(input, selectedDate);
                        closeDatePicker();
                    });
                    btnCancel.appendTo(objButtons);
                    btnOk.appendTo(objButtons);
                    objMainTime.appendTo(objMain);
                    objAmPm.appendTo(objMain);
                    objButtons.appendTo(objMain);
                    objMain.appendTo(objCalendar);
                    generateCalendarTime(input);
                    setDateHights();
                }
            }

            //Generate calendar for number of months
            function generateCalendarDates(input) {
                var objContainer = $("#vgCalendar_" + input.attr("id"));
                var objMonthContent = objContainer.find(".vg_calendar-date-div");
                var objNextButton = objContainer.find(".vg_cal-next-button");
                var intMonth = objNextButton.data("nextmonth");
                var intYear = objNextButton.data("nextyear");

                for (i = 0; i < options.numberOfMonths; i++) {
                    var tempDate = new Date(intYear, intMonth + i, 1);
                    var year = tempDate.getFullYear();
                    var month = tempDate.getMonth();
                    var monthString = vg.monthNames[month] + ' ' + year;
                    var monthTitle = $('<div class="vg_cal-month"><div class="vg_cal-month-title">' + monthString + '</div></div>');
                    var monthTable = $('<div class="vg_cal-month-div" />');
                    var table = $('<table class="vg_cal-month-div" role="presentation" />');
                    var tbody = $('<tbody />');

                    var tr = $('<tr />');
                    var dayOfWeek = new Date(year, month, 1).getDay();
                    for (j = 0; j < dayOfWeek; j++) {
                        var objEmptyDiv = $('<td class="vg_cal-days-placeholder"></td>');
                        objEmptyDiv.appendTo(tr);
                    }

                    var index = dayOfWeek;
                    var daysOfMonth = getDaysOfMonth(month + 1, year);
                    for (k = 1; k <= daysOfMonth; k++) {
                        var currDate = new Date(year, month, k, options.selectedDate.getHours(), options.selectedDate.getMinutes(), options.selectedDate.getMilliseconds());
                        var tdDate = $('<td class="vg_cal-days" data-value="' + moment(currDate).format("YYYY-MM-DD") + '">' + k + '</td>');
                        var flagDisabledWeekDay = (typeof (options.disabledWeekDays) != "undefined" && options.disabledWeekDays != null && options.disabledWeekDays.length > 0 && options.disabledWeekDays.indexOf(currDate.getDay() + 1) > -1);

                        if (currDate.getFullYear() == options.selectedDate.getFullYear() && currDate.getMonth() == options.selectedDate.getMonth() && currDate.getDate() == options.selectedDate.getDate()) {
                            tdDate.addClass(vg.todayClass);
                        }

                        if (!isValidDate(currDate) || flagDisabledWeekDay) {
                            tdDate.addClass(vg.disabledClass);
                        }

                        tdDate.on("click", function (e3) {
                            e3.preventDefault();
                            if ($(this).hasClass(vg.disabledClass)) {
                                return;
                            }

                            if (options.preset.toLowerCase() == "datetime") {
                                $(".vg_calendar-dates", objContainer).find("td").removeClass(vg.activeClass);
                                $(this).addClass(vg.activeClass);
                                objContainer.addClass("vg_timepicker-design");
                                $(".vg_calendar-dates", objContainer).hide();
                                $(".vg_cal-week-div", objContainer).hide();
                                objNextButton.hide();
                                $(".vg_calendar-time-am", objContainer).removeClass(vg.disabledClass);
                                $(".vg_calendar-time-pm", objContainer).removeClass(vg.disabledClass);
                                var date = $(this).data("value").split("-");
                                var selectedDate = new Date(date[0], date[1] - 1, date[2], 11, 55, 0, 0);
                                if (!isValidDate(selectedDate)) {
                                    $(".vg_calendar-time-am", objContainer).addClass(vg.disabledClass);
                                    $(".vg_calendar-time-am", objContainer).removeClass("active");
                                    $(".vg_calendar-time-pm", objContainer).addClass("active");
                                }

                                selectedDate = new Date(date[0], date[1] - 1, date[2], 23, 55, 0, 0);
                                if (!isValidDate(selectedDate)) {
                                    $(".vg_calendar-time-pm", objContainer).addClass(vg.disabledClass);
                                    $(".vg_calendar-time-pm", objContainer).removeClass("active");
                                    $(".vg_calendar-time-am", objContainer).addClass("active");
                                }

                                //Disable previous time
                                disableTime(input);
                                //Display time picker
                                $(".vg_calendar-times", objContainer).show();
                                //Display button for back to dates
                                $(".vg_back-arrow", objContainer).show();

                                //hide years drop down
                                $("#divYears", objContainer).hide();
                            }
                            else {
                                var date = $(this).data("value").split("-");
                                setSelectedDate(input, new Date(date[0], date[1] - 1, date[2]));

                                if (typeof (options.ondatechange) == "function") {
                                    options.ondatechange(vg.currentDate);
                                }
                                closeDatePicker();
                            }
                        });

                        if (index % 7 == 0) {
                            $(tr).appendTo(tbody);
                            tr = $('<tr />');
                        }
                        tdDate.appendTo(tr);
                        index++;
                    }
                    $(tr).appendTo(tbody);

                    $(monthTitle).appendTo(objMonthContent);
                    $(tbody).appendTo(table);
                    $(table).appendTo(monthTable);
                    $(monthTable).appendTo(objMonthContent);
                    objNextButton.data("nextmonth", month + 1);
                    objNextButton.data("nextyear", year);

                    if (year == options.maxDate.getFullYear() && month == options.maxDate.getMonth()) {
                        objNextButton.remove();
                        break;
                    }
                }
            }

            //Generate time calendar
            function generateCalendarTime(input) {
                var objContainer = $("#vgCalendar_" + input.attr("id"));
                var timeContent = objContainer.find(".vg_calendar-time-div");

                for (t = 0; t < 2; t++) {
                    var titleDiv = $('<div class="vg_cal-month"><div class="vg_cal-month-title">' + (t == 0 ? "Hours" : "Minutes") + '</div></div>');
                    var tableDiv = $('<div class="vg_cal-month-div" />');
                    var selectedHours = options.selectedDate.getHours(), selectedMinutes = options.selectedDate.getMinutes();
                    if (selectedHours > 12 || (selectedHours == 12 && selectedMinutes > 0)) {
                        $(".vg_calendar-time-am", objContainer).removeClass("active");
                        $(".vg_calendar-time-pm", objContainer).addClass("active");
                        if (selectedHours > 12) {
                            selectedHours = selectedHours - 12;
                        }
                    }
                    if (t == 0) {
                        var table = $('<table class="vg_cal-month-div vg_cal-hours" role="presentation" />');
                        var tbody = $('<tbody />');
                        var tr = $('<tr />');
                        for (i = 0; i <= 11; i++) {
                            if (i == 0) {
                                i = 12;
                            }
                            var td = $('<td class="vg_cal-days' + (i == selectedHours ? " " + vg.activeClass : "") + '" data-value="' + i + '">' + i + '</td>');
                            td.on("click", function (e3) {
                                e3.preventDefault();
                                if ($(this).hasClass(vg.disabledClass)) {
                                    return;
                                }
                                else {
                                    $(".vg_cal-hours", timeContent).find("td").removeClass(vg.activeClass);
                                    $(this).addClass(vg.activeClass);

                                    if (options.preset.toLowerCase() == "datetime") {
                                        //Disable previous time
                                        disableTime(input);
                                    }
                                }
                            });
                            td.appendTo(tr);
                            if (i == 12) {
                                i = 0;
                            }

                            if ((i + 1) % 6 == 0) {
                                $(tr).appendTo(tbody);
                                tr = $('<tr />');
                            }
                        }
                    }
                    else {
                        var selectedMinutes = options.selectedDate.getMinutes();
                        var table = $('<table class="vg_cal-month-div vg_cal-minutes" role="presentation" />');
                        var tbody = $('<tbody />');
                        var tr = $('<tr />');
                        var index = 1;
                        for (i = 0; i < 59; (i += 5)) {
                            var td = $('<td class="vg_cal-days' + (i == selectedMinutes ? " " + vg.activeClass : "") + '" data-value="' + i + '">' + (i < 10 ? "0" : "") + i + '</td>');
                            td.on("click", function (e3) {
                                e3.preventDefault();
                                if ($(this).hasClass(vg.disabledClass)) {
                                    return;
                                }
                                else {
                                    $(".vg_cal-minutes", timeContent).find("td").removeClass(vg.activeClass);
                                    $(this).addClass(vg.activeClass);

                                    if (options.preset.toLowerCase() == "datetime") {
                                        //Disable previous time
                                        disableTime(input);
                                    }
                                }
                            });
                            td.appendTo(tr);
                            if (index % 6 == 0) {
                                $(tr).appendTo(tbody);
                                tr = $('<tr />');
                            }
                            index++;
                        }
                    }
                    $(tr).appendTo(tbody);
                    $(titleDiv).appendTo(timeContent);
                    $(tbody).appendTo(table);
                    $(table).appendTo(tableDiv);
                    $(tableDiv).appendTo(timeContent);
                }
            }

            //Disable previous time based on selected date
            function disableTime(input) {
                var objCalendar = $("#vgCalendar_" + input.attr("id"));
                var objDatesDiv = $(".vg_calendar-dates", objCalendar);
                var objTimeDiv = $(".vg_calendar-times", objCalendar);
                var date = objDatesDiv.find("." + vg.activeClass).data("value").split("-");
                var selectedDate = new Date(date[0], date[1] - 1, date[2]);
                
                var objHoursDiv = $(".vg_cal-hours", objTimeDiv);
                var objMinutesDiv = $(".vg_cal-minutes", objTimeDiv);
                var minutes = objMinutesDiv.find("." + vg.activeClass).length > 0 ? parseInt(objMinutesDiv.find("." + vg.activeClass).data("value")) : 0;
                var flagHourSelected = objHoursDiv.find("." + vg.activeClass).length > 0;
                $("td", objHoursDiv).each(function (i, obj) {
                    var currHours = parseInt($(obj).data("value"));
                    if ($(".vg_calendar-time-pm", objTimeDiv).hasClass("active") && currHours < 12) {
                        currHours += 12;
                    }

                    var tempDate = new Date(selectedDate);
                    tempDate.setHours(currHours);
                    tempDate.setMinutes(minutes);
                    if (!isValidDate(tempDate)) {
                        $(obj).addClass(vg.disabledClass);
                        if ($(obj).hasClass(vg.activeClass)) {
                            flagHourSelected = false;
                            $(obj).removeClass(vg.activeClass);
                        }
                    }
                    else {
                        if (flagHourSelected == false) {
                            flagHourSelected = true;
                            $(obj).addClass(vg.activeClass);
                        }
                        $(obj).removeClass(vg.disabledClass);
                    }
                });

                var hours = objHoursDiv.find("." + vg.activeClass).length > 0 ? parseInt(objHoursDiv.find("." + vg.activeClass).data("value")) : 0;
                if ($(".vg_calendar-time-pm", objTimeDiv).hasClass("active") && hours < 12) {
                    hours += 12;
                }
                var flagMinutesSelected = objMinutesDiv.find("." + vg.activeClass).length > 0;
                $("td", objMinutesDiv).each(function (i, obj) {
                    var currMinutes = parseInt($(obj).data("value"));
                    var tempDate = new Date(selectedDate);
                    tempDate.setHours(hours);
                    tempDate.setMinutes(currMinutes);
                    if (!isValidDate(tempDate)) {
                        $(obj).addClass(vg.disabledClass);
                        if ($(obj).hasClass(vg.activeClass)) {
                            flagMinutesSelected = false;
                            $(obj).removeClass(vg.activeClass);
                        }
                    }
                    else {
                        if (flagMinutesSelected == false) {
                            flagMinutesSelected = true;
                            $(obj).addClass(vg.activeClass);
                        }
                        $(obj).removeClass(vg.disabledClass);
                    }
                });
            }

            //Get calendar selected date
            function getSelectedDate(input) {
                if (typeof ($(input).data("vgselectedvalue")) != "undefined" && $(input).data("vgselectedvalue") != "") {
                    var arrDateTime = $(input).data("vgselectedvalue").split(' ');
                    var selectedTime = [0, 0];
                    
                    if (options.preset.toLowerCase() == "time") {
                        selectedTime = arrDateTime[0].split(":");
                        arrDateTime = [moment(new Date()).format("YYYY-MM-DD")];
                    }
                    else if (options.preset.toLowerCase() == "datetime") {
                        selectedTime = arrDateTime[1].split(":");
                    }
                    var selectedDate = arrDateTime[0].split("-");
                    return new Date(selectedDate[0], selectedDate[1] - 1, selectedDate[2], selectedTime[0], selectedTime[1]);
                }
                else {
                    //return new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate());
                    return options.selectedDate;
                }
            }

            //Get selected date in calendar
            function setSelectedDate(input, value, flagFillInputValue) {
                if (typeof (flagFillInputValue) == "undefined" || flagFillInputValue == null) {
                    flagFillInputValue = true;
                }
                var flagIgnoreValidation = typeof (options.ignoreValidation) != "undefined" && options.ignoreValidation;
                if (flagIgnoreValidation || isValidDate(new Date(value))) {
                    var objCalendar = $("#vgCalendar_" + input.attr("id"));
                    if (options.preset.toLowerCase() == "time") {
                        $(input).data("vgselectedvalue", moment(value).format("HH:mm"));
                        if (flagFillInputValue) {
                            $(input).val(moment(value).format(options.dateFormat));
                        }
                        var hours = new Date(value).getHours(), minutes = new Date(value).getMinutes();
                        if (hours > 12 || (hours == 12 && minutes > 0)) {
                            $(".vg_calendar-time-am", objCalendar).removeClass("active");
                            $(".vg_calendar-time-pm", objCalendar).addClass("active");
                            if (hours > 12) {
                                hours = hours - 12;
                            }
                        }
                        var selectedTd = $(".vg_cal-hours", objCalendar).find("[data-value='" + hours + "']");
                        $(".vg_cal-hours", objCalendar).find("td").removeClass(vg.activeClass);
                        $(selectedTd).addClass(vg.activeClass);

                        selectedTd = $(".vg_cal-minutes", objCalendar).find("[data-value='" + minutes + "']");
                        $(".vg_cal-minutes", objCalendar).find("td").removeClass(vg.activeClass);
                        $(selectedTd).addClass(vg.activeClass);
                    }
                    else {
                        //Generate month if not generated
                        generateCalendarForNewDate(new Date(value));

                        var dateContainer = $(".vg_calendar-dates", objCalendar);
                        var objContentDiv = objCalendar.find(".vg_calendar-date-div");
                        var selectedTd = $(objContentDiv).find("[data-value='" + moment(value).format("YYYY-MM-DD") + "']");
                        if (flagIgnoreValidation || (selectedTd.length > 0 && !selectedTd.hasClass(vg.disabledClass))) {
                            var dateFormat = "YYYY-MM-DD" + (options.preset.toLowerCase() == "datetime" ? " HH:mm" : "");
                            $(input).data("vgselectedvalue", moment(value).format(dateFormat));
                            if (flagFillInputValue) {
                                $(input).val(moment(value).format(options.dateFormat));
                            }
                            $(dateContainer).find("td").removeClass(vg.activeClass);
                            $(selectedTd).addClass(vg.activeClass);
                        }
                    }
                    vg.currentDate = new Date(value);
                    return true;
                }
                return false;
            }

            //Generat calendar month if generated
            function generateCalendarForNewDate(newDate){
                var objCalendar = $("#vgCalendar_" + input.attr("id"));
                var btnNext = objCalendar.find(".vg_cal-next-button");
                var nextMonth = btnNext.data("nextmonth") - 1;
                var nextYear = btnNext.data("nextyear");
                var tempDate = new Date(nextYear, nextMonth, getDaysOfMonth(nextMonth + 1, nextYear));
                newDate.setHours(0);
                newDate.setMinutes(0);
                newDate.setMilliseconds(0);
                if (newDate > tempDate) {
                    var diff = getDateDiffInMonth(tempDate, newDate);
                    var numberOfMonths = options.numberOfMonths;
                    if (diff > 0) {
                        options.numberOfMonths = diff;
                    }

                    //Initial Generate Calendar
                    generateCalendarDates(input);
                    options.numberOfMonths = numberOfMonths;
                }
            }

            //Closing date picker
            function closeDatePicker() {
                showHide(false);
                if (typeof (options.onclose) == "function") {
                    options.onclose();
                }
                setTimeout(function () {
                    if (options.preset.toLowerCase() != "time") {
                        var objCalendar = $("#vgCalendar_" + input.attr("id"));
                        objCalendar.removeClass("vg_timepicker-design");
                    }
                    if (options.preset.toLowerCase() != "date") {
                        if (vg.currentDate == null) {
                            vg.currentDate = options.selectedDate;
                        }
                        //Set dafult selected value
                        setSelectedDate(input, vg.currentDate, false);
                    }
                }, 310);
            }

            //Show hide calendar
            function showHide(flagShow) {                
                var strClass = options.preset.toLowerCase() == "time" ? "vg_calendar-times" : "vg_calendar-dates"
                var objCalendar = $("#vgCalendar_" + input.attr("id"));
                var objInnerDiv = objCalendar.find("." + strClass);

                if (flagShow) {
                    frm.DatePickerScrollSetUp(JSON.stringify({ isDatePickerVisible: true, position: 0 }));
                    objCalendar.slideDown(300);
                    objInnerDiv.slideDown(300);
                    $("html, body").addClass("overflowHidden");
                    if (options.preset.toLowerCase() == "datetime") {
                        //Hide  time picker and show date picker
                        $(".vg_back-arrow", objCalendar).hide();
                        $("#divYears", objCalendar).show();
                        $(".vg_calendar-times", objCalendar).hide();
                        $(".vg_calendar-dates", objCalendar).show();
                        $(".vg_cal-week-div", objCalendar).show();
                        objCalendar.find(".vg_cal-next-button").show();
                    }
                    setDateHights();

                    setTimeout(function () {
                        var selectedTd = objInnerDiv.find("." + vg.activeClass).parent().parent().parent().parent();
                        if (selectedTd.length > 0) {
                            var scrollTop = objInnerDiv.scrollTop();
                            objInnerDiv.scrollTop(scrollTop + selectedTd.offset().top - objInnerDiv.height() + 283);
                        }
                    }, 350);
                    if (deviceIsMobile == true) {
                        _form.setParentDivHeight();
                    }
                }
                else {
                    frm.DatePickerScrollSetUp(JSON.stringify({ isDatePickerVisible: false, position: $('#'+input.attr("id")).offset().top }));
                    objCalendar.slideUp(300);
                    objInnerDiv.slideUp(300);
                    $("html, body").removeClass("overflowHidden");

                    if (deviceIsMobile == true && typeof $("#divFormContainer")[0] != "undefined" && $("#divFormContainer")[0] != "") {
                        _form.setIframeHeight($("#divFormContainer")[0].scrollHeight + 50);
                        _form.setScrollPosition($('#' + input.attr("id")).offset().top);
                    }
                }
            }

            function setDateHights() {
                setTimeout(function () {
                    var objCalendar = $("#vgCalendar_" + input.attr("id"));
                    var objContentDiv = objCalendar.find(".vg_calendar-date-div");
                    objContentDiv.find("td").each(function (i, obj) {
                        $(this).height($(this).width() - 1);
                    });

                    var objCalendar = $("#vgCalendar_" + input.attr("id"));
                    var objContentDiv = objCalendar.find(".vg_calendar-time-div");
                    objContentDiv.find("td").each(function (i, obj) {
                        $(this).height($(this).width() - 1);
                    });
                }, 200);
            }

            function destroyDatePicker() {
                $(input).removeAttr("data-vgselectedvalue");
                $(input).unbind("click touchstart");
                objContainerDiv.remove();
            }

            $(window).resize(function () {
                setDateHights();
            });
        })($(this), settings);
    };
})(jQuery);;
/////////////////////////////////////////// Date : Prototype Functions :: Start ////////////////////////////////////
var gsMonthNames = new Array(
'January',
'February',
'March',
'April',
'May',
'June',
'July',
'August',
'September',
'October',
'November',
'December'
);

// a global day names array
var gsDayNames = new Array(
'Sunday',
'Monday',
'Tuesday',
'Wednesday',
'Thursday',
'Friday',
'Saturday'
);

if (!String.prototype.times) {
    String.prototype.times = function (n) { var s = ''; for (var i = 0; i < n; i++) s += this; return s; }
}

if (!String.prototype.zp) {
    String.prototype.zp = function (n) { return '0'.times(n - this.length) + this; }
}

if (!Number.prototype.zp) {
    Number.prototype.zp = function (n) { return this.toString().zp(n); }
}

// the date format prototype
if (!Date.prototype.format) {
    Date.prototype.format = function (f) {
        if (!this.valueOf())
            return '&nbsp;';

        var d = this;

        return f.replace(/(yyyy|mmmm|mmm|mm|dddd|ddd|dd|hh|nn|ss|ms|a\/p)/gi,
            function ($1) {
                switch ($1.toLowerCase()) {
                    case 'yyyy': return d.getFullYear();
                    case 'mmmm': return gsMonthNames[d.getMonth()];
                    case 'mmm': return gsMonthNames[d.getMonth()].substr(0, 3);
                    case 'mm': return (d.getMonth() + 1).zp(2);
                    case 'dddd': return gsDayNames[d.getDay()];
                    case 'ddd': return gsDayNames[d.getDay()].substr(0, 3);
                    case 'dd': return d.getDate().zp(2);
                    case 'hh': return ((h = d.getHours() % 12) ? h : 12).zp(2);
                    case 'nn': return d.getMinutes().zp(2);
                    case 'ss': return d.getSeconds().zp(2);
                    case 'ms': return d.getMilliseconds().zp(2);
                    case 'a/p': return d.getHours() < 12 ? 'AM' : 'PM';
                }
            }
        );
    }
}

// the date format prototype
if (!Date.prototype.formatdate) {
    Date.prototype.formatdate = function (f) {
        if (!this.valueOf())
            return '&nbsp;';

        var d = this;

        return f.replace(/(yyyy|mmmm|mmm|mm|dddd|ddd|dd|hh|nn|ss|ms|a\/p)/gi,
            function ($1) {
                switch ($1.toLowerCase()) {
                    case 'yyyy': return d.getFullYear();
                    case 'mmmm': return gsMonthNames[d.getMonth()];
                    case 'mmm': return gsMonthNames[d.getMonth()].substr(0, 3);
                    case 'mm': return (d.getMonth() + 1).zp(2);
                    case 'dddd': return gsDayNames[d.getDay()];
                    case 'ddd': return gsDayNames[d.getDay()].substr(0, 3);
                    case 'dd': return d.getDate().zp(2);
                    case 'hh': return ((h = d.getHours() % 12) ? h : 12).zp(2);
                    case 'nn': return d.getMinutes().zp(2);
                    case 'ss': return d.getSeconds().zp(2);
                    case 'ms': return d.getMilliseconds().zp(2);
                    case 'a/p': return d.getHours() < 12 ? 'AM' : 'PM';
                }
            }
        );
    }
}
/////////////////////////////////////////// Date : Prototype Functions :: End ////////////////////////////////////

// Alert messages declarations...
var cdnImagePath;
var deleteConfirm = "Are you sure you want to delete?";
var archieveConfirm = "Are you sure you want to archieve?";
var keepAlive = undefined;

var defaultErrorMessage = "Something went wrong";

function selectString(str) {
    return "Please select " + str + ".";
}

function requiredString(str) {
    return "Please enter value of " + str + ".";
}
// Alert messages ends...

function cbo_OnClientLoad(sender) {
    var input = sender.get_inputDomElement();
    input.readOnly = "readonly";
}

function RedirectPage(sUrl) {
    location.href = sUrl;
}

function IgnoreCharacters(e, checkCharacters) {
    if (checkCharacters == "")
        checkCharacters = '&#%*:"\\|\/.<>?';
    document.all ? k = e.keyCode : k = e.which;
    for (var i = 0; i < checkCharacters.length; i++) {
        if (checkCharacters.charCodeAt(i) == k) {
            e.returnValue = null;
            return false;
        }
    }
    return;
}
function IgnoreCharactersWithSingleQuote(e, checkCharacters) {
    if (checkCharacters == "")
        checkCharacters = '&#%*:"\\|\/.<>?\'';
    document.all ? k = e.keyCode : k = e.which;
    for (var i = 0; i < checkCharacters.length; i++) {
        if (checkCharacters.charCodeAt(i) == k) {
            e.returnValue = null;
            return false;
        }
    }
    return;
}

// ShowModalDialog starts...
//var dFeatures = 'dialogHeight: 200px; dialogWidth: 400px; dialogTop: 646px; dialogLeft: 220px; edge: Raised; center: Yes; help: Yes; resizable: Yes; status: Yes;'; //default features
var dFeatures = 'dialogHeight: 200px; dialogWidth: 400px; edge: Raised; center: Yes; help: Yes; resizable: Yes; status: Yes;'; //default features

var modalWin = "null";
var returnValue = "";
var pHeight, pWidth;
function xShowModalDialog(sURL, vArguments, sFeatures) {
    if (sURL == null || sURL == '') {
        alert("Invalid URL input.");
        return false;
    }
    if (vArguments == null || vArguments == '') {
        vArguments = '';
    }
    if (sFeatures == null || sFeatures == '') {
        sFeatures = dFeatures;
    }
    //alert("window.navigator.appVersion="+window.navigator.appVersion);
    if (window.navigator.appVersion.indexOf("MSIE") != -1) {
        returnValue = window.showModalDialog(sURL, vArguments, sFeatures);
        return false;
    }
    sFeatures = sFeatures.replace(/ /gi, '');
    aFeatures = sFeatures.split(";");
    sWinFeat = "directories=0,menubar=0,titlebar=0,toolbar=0,";
    for (x in aFeatures) {
        aTmp = aFeatures[x].split(":");
        sKey = aTmp[0].toLowerCase();
        sVal = aTmp[1];
        switch (sKey) {
            case "dialogheight":
                sWinFeat += "height=" + sVal + ",";
                pHeight = sVal.replace('px', '');
                break;
            case "dialogwidth":
                sWinFeat += "width=" + sVal + ",";
                pWidth = sVal.replace('px', '');
                break;
            case "dialogtop":
                sWinFeat += "screenY=" + sVal + ",";
                break;
            case "dialogleft":
                sWinFeat += "screenX=" + sVal + ",";
                break;
            case "resizable":
                sWinFeat += "resizable=" + sVal + ",";
                break;
            case "status":
                sWinFeat += "status=" + sVal + ",";
                break;
            case "center":
                if (sVal.toLowerCase() == "yes") {
                    sWinFeat += "screenY=" + ((screen.availHeight - pHeight) / 2) + ",";
                    sWinFeat += "screenX=" + ((screen.availWidth - pWidth) / 2) + ",";
                }
                break;
        }
    }
    modalWin = window.open(String(sURL), "", sWinFeat);
    if (vArguments != null && vArguments != '') {
        modalWin.dialogArguments = vArguments;
    }
}
// ShowModalDialog ends...


// Input box functions...
function CheckAlpha(e) {
    var k;
    document.all ? k = e.keyCode : k = e.which;
    return ((k > 64 && k < 91) || (k > 96 && k < 123) || k == 8 || k == 0);
}
function CheckAlphaWithSpace(e) {
    var k;
    document.all ? k = e.keyCode : k = e.which;
    return ((k > 64 && k < 91) || (k > 96 && k < 123) || k == 8 || k == 0 || k == 32);
}
function CheckNumeric(e, cnt) {
    var k;
    document.all ? k = e.keyCode : k = e.which;
    var srcVal = e.srcElement.value;
    if (srcVal.indexOf('.') > -1) {
        if (k == 46) return false;
        if (srcVal.substring(srcVal.indexOf('.'), srcVal.length).length > cnt) {
            return false;
        }
    }
    return ((k >= 48 && k <= 57) || k == 46 || k == 8 || k == 0);
}
function CheckCompany(e) {
    var k;
    document.all ? k = e.keyCode : k = e.which;
    return ((k > 64 && k < 91) || (k > 96 && k < 123) || k == 8 || k == 0 || k == 38 || k == 39 || k == 45 || k == 46 || k == 32);
}
function CheckContactNo(e) {
    var k;
    document.all ? k = e.keyCode : k = e.which;
    return ((k >= 48 && k <= 57) || k == 8 || k == 0);
}
// Input box functions end...

//Created function for display server side message when client side exception occurs.
//Created by Pranav Rajyaguru on 15/05/2006
function RemoveErrorMsg() {
    var diverr = document.getElementById('divError');
    diverr.innerHTML = '';
}

//Open window in popup
function openwindow(windowURL) {
    window.open(windowURL, '', '', '');
}
var ratingDescSearch = new Array("Poor", "Fair", "Average", "Good", "Excellent");
var ratingDescNormal = new Array("Excellent", "Good", "Average", "Fair", "Poor");
var ratingDesc;
KeepValue = new Array();
function SetRatingControlBehavior(RatingID, IsSearch, ctrlindex) {
    if (IsSearch)
        ratingDesc = ratingDescSearch;
    else
        ratingDesc = ratingDescSearch;
    //document.getElementById(RatingID).onmouseout = FixClearValue;
    if (document.getElementById(RatingID) != null) {
        document.getElementById(RatingID).onmouseout = new Function("FixClearValue(" + ctrlindex + ");")
        KeepValue[ctrlindex] = '';
        for (i = 0; i < 5; i++) {
            var ratingCtrl = document.getElementById(RatingID + "_Star_" + (i + 1).toString());
            ratingCtrl.title = '';

            ratingCtrl.onmouseover = new Function("ShowRatingDesc('" + ratingDesc[i] + "',-1," + ctrlindex + ");")
            ratingCtrl.onclick = new Function("ShowRatingDesc('" + ratingDesc[i] + "',1," + ctrlindex + ");")
        }
    }
}
function ShowRatingDesc(desc, j, index) {

    document.getElementById('spn' + index).innerHTML = desc;
    //alert(document.getElementById('spn' + index).innerHTML);
    if (j != undefined && j == 1)
        KeepValue[index] = desc;
}
// Added By: Nishant Dave...4th Aug 2010
function SetRatingControlBehaviorToSetVal(RatingID, IsSearch, ctrlindex) {
    if (IsSearch)
        ratingDesc = ratingDescSearch;
    else
        ratingDesc = ratingDescSearch;
    document.getElementById(RatingID).onmouseout = new Function("FixClearValue(" + ctrlindex + ");")
    KeepValue[ctrlindex] = '';
    for (i = 0; i < 5; i++) {
        var ratingCtrl = document.getElementById(RatingID + "_Star_" + (i + 1).toString());
        ratingCtrl.title = '';

        ratingCtrl.onmouseover = new Function("ShowRatingDesc('" + ratingDesc[i] + "',-1," + ctrlindex + ");")
        ratingCtrl.onclick = new Function("ShowRatingDesc('" + ratingDesc[i] + "',1," + ctrlindex + ");")
    }
}
function ShowRatingDescToSetVal(RatingID, val, index) {
    ratingDesc = ratingDescSearch;
    document.getElementById('spn' + index).innerHTML = ratingDescSearch[val];
    KeepValue[index] = ratingDescSearch[val];
    //document.getElementById(RatingID).onmouseout = new Function("FixClearValueToSetVal(" + index + ","+val+");")
    //document.getElementById(RatingID).onclick = new Function("ShowRatingDesc('" + ratingDesc[val] + "',1," + index + ");")
    //    for (i = 0; i < 5; i++) {
    //        var ratingCtrl = document.getElementById(RatingID + "_Star_" + (i + 1).toString());
    //        ratingCtrl.title = '';

    //        //ratingCtrl.onmouseover = new Function("ShowRatingDesc('" + ratingDesc[i] + "',-1," + ctrlindex + ");")
    //        //ratingCtrl.onmouseout = new Function("FixClearValueToSetVal(" + index + ","+val+");")
    //        ratingCtrl.onmouseover = new Function("ShowRatingDesc('" + ratingDesc[i] + "',-1," + index + ");")
    //        ratingCtrl.onclick = new Function("ShowRatingDesc('" + ratingDesc[i] + "',1," + index + ");")
    //        
    //    }
}

function FixClearValueToSetVal(index, val) {
    document.getElementById('spn' + index).innerHTML = ratingDescSearch[val];
}
// Finished By: Nishant Dave...4th Aug 2010
function FixClearValue(index) {
    document.getElementById('spn' + index).innerHTML = KeepValue[index];
}
function trim(strValue) {
    var objRegExp = /^(\s*)$/;
    if (objRegExp.test(strValue)) {
        strValue = strValue.replace(objRegExp, '');
        if (strValue.length == 0)
            return strValue;
    }
    objRegExp = /^(\s*)([\W\w]*)(\b\s*$)/;
    if (objRegExp.test(strValue)) {
        strValue = strValue.replace(objRegExp, '$2');
    }
    return strValue;
}
function rTrim(strValue) {
    var objRegExp = /^([\w\W]*)(\b\s*)$/;
    if (objRegExp.test(strValue)) {
        strValue = strValue.replace(objRegExp, '$1');
    }
    return strValue;
}
function lTrim(strValue) {
    var objRegExp = /^(\s*)(\b[\w\W]*)$/;

    if (objRegExp.test(strValue)) {
        strValue = strValue.replace(objRegExp, '$2');
    }
    return strValue;
}
function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
}
function SetFocusOnError() {
    setTimeout("scroll(0, 0)", 50);
}

//Function is Created by Pranav ON 23-Oct-2009 for using common function for printing the page
function PrintPage(pagetype, isexport) {
    var url = '/Users/PrintGrid.aspx?PageType=' + pagetype;
    if (isexport != undefined && isexport == '1')
        url = url + '&isexport=1';
    window.open(url, '', 'left=0,top=0,width=750,height=650,toolbar=0,scrollbars=0,status=0,resizable=0');
}
function echeck(str) {

    //var emailReg = "^[A-Za-z0-9_\+-]+(\.[A-Za-z0-9_\+-]+)*@[A-Za-z0-9-]+(\.[A-Za-z0-9-]+)*\.([A-Za-z]{2,4})$";

    //        var emailReg = '^([a-zA-Z0-9_\-\.]+)@(([[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\‌​.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(]?)$';
    //        var regex = new RegExp(emailReg);       
    //        alert(emailReg);
    //        var resval = regex.test(str);
    //        alert(resval);
    if (trim(str) == "") {
        return false;
    }
    else {
        var resval = true;
        //var filter = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;                        
        var filter = /^[A-Za-z0-9_\+-]+(\.[A-Za-z0-9_\+-]+)*@[A-Za-z0-9-]+(\.[A-Za-z0-9-]+)*\.([A-Za-z]{2,10})$/;
        if (!filter.test(str)) {
            resval = false;
        }
        return resval;
    }

    //    var at = "@"
    //    var dot = "."
    //    var lat = str.indexOf(at)
    //    var lstr = str.length
    //    var ldot = str.indexOf(dot)
    //    if (str.indexOf(at) == -1) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    if (str.indexOf(at) == -1 || str.indexOf(at) == 0 || str.indexOf(at) == lstr) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    if (str.indexOf(dot) == -1 || str.indexOf(dot) == 0 || str.indexOf(dot) == lstr) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    if (str.indexOf(at, (lat + 1)) != -1) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    if (str.substring(lat - 1, lat) == dot || str.substring(lat + 1, lat + 2) == dot) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    if (str.indexOf(dot, (lat + 2)) == -1) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    if (str.indexOf(" ") != -1) {
    //        //alert("Invalid E-mail ID")
    //        return false
    //    }

    //    return true
}
function CallFailed(res) {
    alert(res.get_message());
}
/* ENCRYPT DECRYPT IN JAVASCRIPT */

//<!-- This script and many more are available free online at -->
//<!-- The JavaScript Source!! http://javascript.internet.com -->
//<!-- http://javascript.internet.com/passwords/ascii-encryption.html -->

//<!-- Begin
function Encrypt(theText) {
    output = new String;
    Temp = new Array();
    Temp2 = new Array();
    TextSize = theText.length;
    for (i = 0; i < TextSize; i++) {
        rnd = Math.round(Math.random() * 122) + 68;
        Temp[i] = theText.charCodeAt(i) + rnd;
        Temp2[i] = rnd;
    }
    for (i = 0; i < TextSize; i++) {
        output += String.fromCharCode(Temp[i], Temp2[i]);
    }
    return output;
}
function unEncrypt(theText) {
    output = new String;
    Temp = new Array();
    Temp2 = new Array();
    TextSize = theText.length;
    for (i = 0; i < TextSize; i++) {
        Temp[i] = theText.charCodeAt(i);
        Temp2[i] = theText.charCodeAt(i + 1);
    }
    for (i = 0; i < TextSize; i = i + 2) {
        output += String.fromCharCode(Temp[i] - Temp2[i]);
    }
    return output;
}
//  End -->

function HtmlDecode(s) {
    var out = "";
    if (s == null) return;
    var l = s.length;
    for (var i = 0; i < l; i++) {
        var ch = s.charAt(i);
        if (ch == '&') {
            var semicolonIndex = s.indexOf(';', i + 1);
            if (semicolonIndex > 0) {
                var entity = s.substring(i + 1, semicolonIndex);
                if (entity.length > 1 && entity.charAt(0) == '#') {
                    if (entity.charAt(1) == 'x' || entity.charAt(1) == 'X')
                        ch = String.fromCharCode(eval('0' + entity.substring(1)));
                    else
                        ch = String.fromCharCode(eval(entity.substring(1)));
                }
                else {
                    switch (entity) {
                        case 'quot': ch = String.fromCharCode(0x0022); break;
                        case 'amp': ch = String.fromCharCode(0x0026); break;
                        case 'lt': ch = String.fromCharCode(0x003c); break;
                        case 'gt': ch = String.fromCharCode(0x003e); break;
                        case 'nbsp': ch = String.fromCharCode(0x00a0); break;
                        case 'iexcl': ch = String.fromCharCode(0x00a1); break;
                        case 'cent': ch = String.fromCharCode(0x00a2); break;
                        case 'pound': ch = String.fromCharCode(0x00a3); break;
                        case 'curren': ch = String.fromCharCode(0x00a4); break;
                        case 'yen': ch = String.fromCharCode(0x00a5); break;
                        case 'brvbar': ch = String.fromCharCode(0x00a6); break;
                        case 'sect': ch = String.fromCharCode(0x00a7); break;
                        case 'uml': ch = String.fromCharCode(0x00a8); break;
                        case 'copy': ch = String.fromCharCode(0x00a9); break;
                        case 'ordf': ch = String.fromCharCode(0x00aa); break;
                        case 'laquo': ch = String.fromCharCode(0x00ab); break;
                        case 'not': ch = String.fromCharCode(0x00ac); break;
                        case 'shy': ch = String.fromCharCode(0x00ad); break;
                        case 'reg': ch = String.fromCharCode(0x00ae); break;
                        case 'macr': ch = String.fromCharCode(0x00af); break;
                        case 'deg': ch = String.fromCharCode(0x00b0); break;
                        case 'plusmn': ch = String.fromCharCode(0x00b1); break;
                        case 'sup2': ch = String.fromCharCode(0x00b2); break;
                        case 'sup3': ch = String.fromCharCode(0x00b3); break;
                        case 'acute': ch = String.fromCharCode(0x00b4); break;
                        case 'micro': ch = String.fromCharCode(0x00b5); break;
                        case 'para': ch = String.fromCharCode(0x00b6); break;
                        case 'middot': ch = String.fromCharCode(0x00b7); break;
                        case 'cedil': ch = String.fromCharCode(0x00b8); break;
                        case 'sup1': ch = String.fromCharCode(0x00b9); break;
                        case 'ordm': ch = String.fromCharCode(0x00ba); break;
                        case 'raquo': ch = String.fromCharCode(0x00bb); break;
                        case 'frac14': ch = String.fromCharCode(0x00bc); break;
                        case 'frac12': ch = String.fromCharCode(0x00bd); break;
                        case 'frac34': ch = String.fromCharCode(0x00be); break;
                        case 'iquest': ch = String.fromCharCode(0x00bf); break;
                        case 'Agrave': ch = String.fromCharCode(0x00c0); break;
                        case 'Aacute': ch = String.fromCharCode(0x00c1); break;
                        case 'Acirc': ch = String.fromCharCode(0x00c2); break;
                        case 'Atilde': ch = String.fromCharCode(0x00c3); break;
                        case 'Auml': ch = String.fromCharCode(0x00c4); break;
                        case 'Aring': ch = String.fromCharCode(0x00c5); break;
                        case 'AElig': ch = String.fromCharCode(0x00c6); break;
                        case 'Ccedil': ch = String.fromCharCode(0x00c7); break;
                        case 'Egrave': ch = String.fromCharCode(0x00c8); break;
                        case 'Eacute': ch = String.fromCharCode(0x00c9); break;
                        case 'Ecirc': ch = String.fromCharCode(0x00ca); break;
                        case 'Euml': ch = String.fromCharCode(0x00cb); break;
                        case 'Igrave': ch = String.fromCharCode(0x00cc); break;
                        case 'Iacute': ch = String.fromCharCode(0x00cd); break;
                        case 'Icirc': ch = String.fromCharCode(0x00ce); break;
                        case 'Iuml': ch = String.fromCharCode(0x00cf); break;
                        case 'ETH': ch = String.fromCharCode(0x00d0); break;
                        case 'Ntilde': ch = String.fromCharCode(0x00d1); break;
                        case 'Ograve': ch = String.fromCharCode(0x00d2); break;
                        case 'Oacute': ch = String.fromCharCode(0x00d3); break;
                        case 'Ocirc': ch = String.fromCharCode(0x00d4); break;
                        case 'Otilde': ch = String.fromCharCode(0x00d5); break;
                        case 'Ouml': ch = String.fromCharCode(0x00d6); break;
                        case 'times': ch = String.fromCharCode(0x00d7); break;
                        case 'Oslash': ch = String.fromCharCode(0x00d8); break;
                        case 'Ugrave': ch = String.fromCharCode(0x00d9); break;
                        case 'Uacute': ch = String.fromCharCode(0x00da); break;
                        case 'Ucirc': ch = String.fromCharCode(0x00db); break;
                        case 'Uuml': ch = String.fromCharCode(0x00dc); break;
                        case 'Yacute': ch = String.fromCharCode(0x00dd); break;
                        case 'THORN': ch = String.fromCharCode(0x00de); break;
                        case 'szlig': ch = String.fromCharCode(0x00df); break;
                        case 'agrave': ch = String.fromCharCode(0x00e0); break;
                        case 'aacute': ch = String.fromCharCode(0x00e1); break;
                        case 'acirc': ch = String.fromCharCode(0x00e2); break;
                        case 'atilde': ch = String.fromCharCode(0x00e3); break;
                        case 'auml': ch = String.fromCharCode(0x00e4); break;
                        case 'aring': ch = String.fromCharCode(0x00e5); break;
                        case 'aelig': ch = String.fromCharCode(0x00e6); break;
                        case 'ccedil': ch = String.fromCharCode(0x00e7); break;
                        case 'egrave': ch = String.fromCharCode(0x00e8); break;
                        case 'eacute': ch = String.fromCharCode(0x00e9); break;
                        case 'ecirc': ch = String.fromCharCode(0x00ea); break;
                        case 'euml': ch = String.fromCharCode(0x00eb); break;
                        case 'igrave': ch = String.fromCharCode(0x00ec); break;
                        case 'iacute': ch = String.fromCharCode(0x00ed); break;
                        case 'icirc': ch = String.fromCharCode(0x00ee); break;
                        case 'iuml': ch = String.fromCharCode(0x00ef); break;
                        case 'eth': ch = String.fromCharCode(0x00f0); break;
                        case 'ntilde': ch = String.fromCharCode(0x00f1); break;
                        case 'ograve': ch = String.fromCharCode(0x00f2); break;
                        case 'oacute': ch = String.fromCharCode(0x00f3); break;
                        case 'ocirc': ch = String.fromCharCode(0x00f4); break;
                        case 'otilde': ch = String.fromCharCode(0x00f5); break;
                        case 'ouml': ch = String.fromCharCode(0x00f6); break;
                        case 'divide': ch = String.fromCharCode(0x00f7); break;
                        case 'oslash': ch = String.fromCharCode(0x00f8); break;
                        case 'ugrave': ch = String.fromCharCode(0x00f9); break;
                        case 'uacute': ch = String.fromCharCode(0x00fa); break;
                        case 'ucirc': ch = String.fromCharCode(0x00fb); break;
                        case 'uuml': ch = String.fromCharCode(0x00fc); break;
                        case 'yacute': ch = String.fromCharCode(0x00fd); break;
                        case 'thorn': ch = String.fromCharCode(0x00fe); break;
                        case 'yuml': ch = String.fromCharCode(0x00ff); break;
                        case 'OElig': ch = String.fromCharCode(0x0152); break;
                        case 'oelig': ch = String.fromCharCode(0x0153); break;
                        case 'Scaron': ch = String.fromCharCode(0x0160); break;
                        case 'scaron': ch = String.fromCharCode(0x0161); break;
                        case 'Yuml': ch = String.fromCharCode(0x0178); break;
                        case 'fnof': ch = String.fromCharCode(0x0192); break;
                        case 'circ': ch = String.fromCharCode(0x02c6); break;
                        case 'tilde': ch = String.fromCharCode(0x02dc); break;
                        case 'Alpha': ch = String.fromCharCode(0x0391); break;
                        case 'Beta': ch = String.fromCharCode(0x0392); break;
                        case 'Gamma': ch = String.fromCharCode(0x0393); break;
                        case 'Delta': ch = String.fromCharCode(0x0394); break;
                        case 'Epsilon': ch = String.fromCharCode(0x0395); break;
                        case 'Zeta': ch = String.fromCharCode(0x0396); break;
                        case 'Eta': ch = String.fromCharCode(0x0397); break;
                        case 'Theta': ch = String.fromCharCode(0x0398); break;
                        case 'Iota': ch = String.fromCharCode(0x0399); break;
                        case 'Kappa': ch = String.fromCharCode(0x039a); break;
                        case 'Lambda': ch = String.fromCharCode(0x039b); break;
                        case 'Mu': ch = String.fromCharCode(0x039c); break;
                        case 'Nu': ch = String.fromCharCode(0x039d); break;
                        case 'Xi': ch = String.fromCharCode(0x039e); break;
                        case 'Omicron': ch = String.fromCharCode(0x039f); break;
                        case 'Pi': ch = String.fromCharCode(0x03a0); break;
                        case ' Rho ': ch = String.fromCharCode(0x03a1); break;
                        case 'Sigma': ch = String.fromCharCode(0x03a3); break;
                        case 'Tau': ch = String.fromCharCode(0x03a4); break;
                        case 'Upsilon': ch = String.fromCharCode(0x03a5); break;
                        case 'Phi': ch = String.fromCharCode(0x03a6); break;
                        case 'Chi': ch = String.fromCharCode(0x03a7); break;
                        case 'Psi': ch = String.fromCharCode(0x03a8); break;
                        case 'Omega': ch = String.fromCharCode(0x03a9); break;
                        case 'alpha': ch = String.fromCharCode(0x03b1); break;
                        case 'beta': ch = String.fromCharCode(0x03b2); break;
                        case 'gamma': ch = String.fromCharCode(0x03b3); break;
                        case 'delta': ch = String.fromCharCode(0x03b4); break;
                        case 'epsilon': ch = String.fromCharCode(0x03b5); break;
                        case 'zeta': ch = String.fromCharCode(0x03b6); break;
                        case 'eta': ch = String.fromCharCode(0x03b7); break;
                        case 'theta': ch = String.fromCharCode(0x03b8); break;
                        case 'iota': ch = String.fromCharCode(0x03b9); break;
                        case 'kappa': ch = String.fromCharCode(0x03ba); break;
                        case 'lambda': ch = String.fromCharCode(0x03bb); break;
                        case 'mu': ch = String.fromCharCode(0x03bc); break;
                        case 'nu': ch = String.fromCharCode(0x03bd); break;
                        case 'xi': ch = String.fromCharCode(0x03be); break;
                        case 'omicron': ch = String.fromCharCode(0x03bf); break;
                        case 'pi': ch = String.fromCharCode(0x03c0); break;
                        case 'rho': ch = String.fromCharCode(0x03c1); break;
                        case 'sigmaf': ch = String.fromCharCode(0x03c2); break;
                        case 'sigma': ch = String.fromCharCode(0x03c3); break;
                        case 'tau': ch = String.fromCharCode(0x03c4); break;
                        case 'upsilon': ch = String.fromCharCode(0x03c5); break;
                        case 'phi': ch = String.fromCharCode(0x03c6); break;
                        case 'chi': ch = String.fromCharCode(0x03c7); break;
                        case 'psi': ch = String.fromCharCode(0x03c8); break;
                        case 'omega': ch = String.fromCharCode(0x03c9); break;
                        case 'thetasym': ch = String.fromCharCode(0x03d1); break;
                        case 'upsih': ch = String.fromCharCode(0x03d2); break;
                        case 'piv': ch = String.fromCharCode(0x03d6); break;
                        case 'ensp': ch = String.fromCharCode(0x2002); break;
                        case 'emsp': ch = String.fromCharCode(0x2003); break;
                        case 'thinsp': ch = String.fromCharCode(0x2009); break;
                        case 'zwnj': ch = String.fromCharCode(0x200c); break;
                        case 'zwj': ch = String.fromCharCode(0x200d); break;
                        case 'lrm': ch = String.fromCharCode(0x200e); break;
                        case 'rlm': ch = String.fromCharCode(0x200f); break;
                        case 'ndash': ch = String.fromCharCode(0x2013); break;
                        case 'mdash': ch = String.fromCharCode(0x2014); break;
                        case 'lsquo': ch = String.fromCharCode(0x2018); break;
                        case 'rsquo': ch = String.fromCharCode(0x2019); break;
                        case 'sbquo': ch = String.fromCharCode(0x201a); break;
                        case 'ldquo': ch = String.fromCharCode(0x201c); break;
                        case 'rdquo': ch = String.fromCharCode(0x201d); break;
                        case 'bdquo': ch = String.fromCharCode(0x201e); break;
                        case 'dagger': ch = String.fromCharCode(0x2020); break;
                        case 'Dagger': ch = String.fromCharCode(0x2021); break;
                        case 'bull': ch = String.fromCharCode(0x2022); break;
                        case 'hellip': ch = String.fromCharCode(0x2026); break;
                        case 'permil': ch = String.fromCharCode(0x2030); break;
                        case 'prime': ch = String.fromCharCode(0x2032); break;
                        case 'Prime': ch = String.fromCharCode(0x2033); break;
                        case 'lsaquo': ch = String.fromCharCode(0x2039); break;
                        case 'rsaquo': ch = String.fromCharCode(0x203a); break;
                        case 'oline': ch = String.fromCharCode(0x203e); break;
                        case 'frasl': ch = String.fromCharCode(0x2044); break;
                        case 'euro': ch = String.fromCharCode(0x20ac); break;
                        case 'image': ch = String.fromCharCode(0x2111); break;
                        case 'weierp': ch = String.fromCharCode(0x2118); break;
                        case 'real': ch = String.fromCharCode(0x211c); break;
                        case 'trade': ch = String.fromCharCode(0x2122); break;
                        case 'alefsym': ch = String.fromCharCode(0x2135); break;
                        case 'larr': ch = String.fromCharCode(0x2190); break;
                        case 'uarr': ch = String.fromCharCode(0x2191); break;
                        case 'rarr': ch = String.fromCharCode(0x2192); break;
                        case 'darr': ch = String.fromCharCode(0x2193); break;
                        case 'harr': ch = String.fromCharCode(0x2194); break;
                        case 'crarr': ch = String.fromCharCode(0x21b5); break;
                        case 'lArr': ch = String.fromCharCode(0x21d0); break;
                        case 'uArr': ch = String.fromCharCode(0x21d1); break;
                        case 'rArr': ch = String.fromCharCode(0x21d2); break;
                        case 'dArr': ch = String.fromCharCode(0x21d3); break;
                        case 'hArr': ch = String.fromCharCode(0x21d4); break;
                        case 'forall': ch = String.fromCharCode(0x2200); break;
                        case 'part': ch = String.fromCharCode(0x2202); break;
                        case 'exist': ch = String.fromCharCode(0x2203); break;
                        case 'empty': ch = String.fromCharCode(0x2205); break;
                        case 'nabla': ch = String.fromCharCode(0x2207); break;
                        case 'isin': ch = String.fromCharCode(0x2208); break;
                        case 'notin': ch = String.fromCharCode(0x2209); break;
                        case 'ni': ch = String.fromCharCode(0x220b); break;
                        case 'prod': ch = String.fromCharCode(0x220f); break;
                        case 'sum': ch = String.fromCharCode(0x2211); break;
                        case 'minus': ch = String.fromCharCode(0x2212); break;
                        case 'lowast': ch = String.fromCharCode(0x2217); break;
                        case 'radic': ch = String.fromCharCode(0x221a); break;
                        case 'prop': ch = String.fromCharCode(0x221d); break;
                        case 'infin': ch = String.fromCharCode(0x221e); break;
                        case 'ang': ch = String.fromCharCode(0x2220); break;
                        case 'and': ch = String.fromCharCode(0x2227); break;
                        case 'or': ch = String.fromCharCode(0x2228); break;
                        case 'cap': ch = String.fromCharCode(0x2229); break;
                        case 'cup': ch = String.fromCharCode(0x222a); break;
                        case 'int': ch = String.fromCharCode(0x222b); break;
                        case 'there4': ch = String.fromCharCode(0x2234); break;
                        case 'sim': ch = String.fromCharCode(0x223c); break;
                        case 'cong': ch = String.fromCharCode(0x2245); break;
                        case 'asymp': ch = String.fromCharCode(0x2248); break;
                        case 'ne': ch = String.fromCharCode(0x2260); break;
                        case 'equiv': ch = String.fromCharCode(0x2261); break;
                        case 'le': ch = String.fromCharCode(0x2264); break;
                        case 'ge': ch = String.fromCharCode(0x2265); break;
                        case 'sub': ch = String.fromCharCode(0x2282); break;
                        case 'sup': ch = String.fromCharCode(0x2283); break;
                        case 'nsub': ch = String.fromCharCode(0x2284); break;
                        case 'sube': ch = String.fromCharCode(0x2286); break;
                        case 'supe': ch = String.fromCharCode(0x2287); break;
                        case 'oplus': ch = String.fromCharCode(0x2295); break;
                        case 'otimes': ch = String.fromCharCode(0x2297); break;
                        case 'perp': ch = String.fromCharCode(0x22a5); break;
                        case 'sdot': ch = String.fromCharCode(0x22c5); break;
                        case 'lceil': ch = String.fromCharCode(0x2308); break;
                        case 'rceil': ch = String.fromCharCode(0x2309); break;
                        case 'lfloor': ch = String.fromCharCode(0x230a); break;
                        case 'rfloor': ch = String.fromCharCode(0x230b); break;
                        case 'lang': ch = String.fromCharCode(0x2329); break;
                        case 'rang': ch = String.fromCharCode(0x232a); break;
                        case 'loz': ch = String.fromCharCode(0x25ca); break;
                        case 'spades': ch = String.fromCharCode(0x2660); break;
                        case 'clubs': ch = String.fromCharCode(0x2663); break;
                        case 'hearts': ch = String.fromCharCode(0x2665); break;
                        case 'diams': ch = String.fromCharCode(0x2666); break;
                        default: ch = ''; break;
                    }
                }
                i = semicolonIndex;
            }
        }
        out += ch;
    }
    return out;
}
function addOption(selectbox, text, value, isSelected) {
    var optn = document.createElement("OPTION");
    optn.text = text;
    optn.value = value;
    selectbox.options.add(optn);
    if (isSelected)
        optn.selected = true;
}
/*For opening shop detail page*/
var shopdetailkeyword;
function ShowMyVagaroPage(type, url, isCheckedInDB) {
    shopdetailkeyword = url;
    //type 1 = shop detail page same as vagaro, and 2 = shop detail page with customizable page
    Vagaro.MySampleService.ShowVagaroPage(type, isCheckedInDB, CallSuccess_ShowMyVagaroPage, CallFailed)
}
function CallSuccess_ShowMyVagaroPage(val) {
    if (navigator.appName == "Microsoft Internet Explorer") {
        var fakeLink = document.createElement("a");
        fakeLink.href = location.protocol + '//' + location.host + shopdetailkeyword;
        fakeLink.target = "_blank"
        document.body.appendChild(fakeLink);
        fakeLink.click();   // click() method defined in IE only
    }
    else {
        var PopupBlock = window.open(location.protocol + '//' + location.host + shopdetailkeyword);
        if (PopupBlock == null)
            alert('popup is blocked in your browser please enable popup first.');
    }
}
/*For opening shop detail page END*/

function IsNullOrEmpty(stringValue) {
    if (stringValue == null) {
        return true;
    }
    else {
        if ((trim(stringValue.toString()).length == 0) || trim(stringValue.toString()) == 'null') {
            return true;
        }
        else { return false; }
    }
}

/* For Setfocus , select function in all Browsers*/
function selectTextboxContent(textbox) {
    var isIpad = ((navigator.userAgent.match(/iPad/i)) && (navigator.userAgent.match(/iPad/i) !== null));

    if (isIpad)
        setTimeout(function () { textbox.setSelectionRange(0, parseInt(((textbox.value).length) + 1)); }, 10);
    else
        setTimeout(function () { textbox.select(); }, 10);
}
//function DoWaterMarkOnFocus(txt, text, ispassword) {
//    if (navigator.appName != "Microsoft Internet Explorer") {
//        if (ispassword)
//            txt.type = "password";
//    }
//    if (txt.value == text) {
//        txt.value = "";
//        txt.style.color = "";
//    }
//}
//function DoWaterMarkOnBlur(txt, text) {
//    if (txt.value == "") {
//        if (navigator.appName != "Microsoft Internet Explorer") {
//            txt.type = "text";
//        }
//        txt.value = text;
//        txt.style.color = "Gray";
//    }
//}
function changeCSS(theCSS, theClass, element, value) {
    //Last Updated on July 28, 2010
    //documentation for this script at
    //http://www.shawnolson.net/a/503/altering-css-class-attributes-with-javascript.html        
    var cssRules;
    var added = false;

    if (theCSS['rules']) {
        cssRules = 'rules';
    } else if (theCSS['cssRules']) {
        cssRules = 'cssRules';
    } else {
        //no rules found... browser unknown
    }

    for (var R = 0; R < theCSS[cssRules].length; R++) {
        if (theCSS[cssRules][R].selectorText == theClass) {
            if (theCSS[cssRules][R].style[element]) {
                theCSS[cssRules][R].style[element] = value;
                added = true;
                break;
            }
        }
    }
    if (!added) {
        if (theCSS.insertRule) {
            theCSS.insertRule(theClass + ' { ' + element + ': ' + value + '; }', theCSS[cssRules].length);
        } else if (theCSS.addRule) {
            theCSS.addRule(theClass, element + ': ' + value + ';');
        }
    }
}
function getQuerystring(key, default_) {
    if (default_ == null) default_ = "";
    key = key.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
    var regex = new RegExp("[\\?&]" + key + "=([^&#]*)");
    var qs = regex.exec(window.location.href);
    if (qs == null)
        return default_;
    else
        return qs[1];
}
function getViewPortHeightWidth() {
    //****************************************************************************************************************
    // Viewportwidth and height
    var viewportwidth;
    var viewportheight;

    // the more standards compliant browsers (mozilla/netscape/opera/IE7) use window.innerWidth and window.innerHeight
    if (typeof window.innerWidth != 'undefined') {
        viewportwidth = window.innerWidth,
        viewportheight = window.innerHeight
    }
        // IE6 in standards compliant mode (i.e. with a valid doctype as the first line in the document)
    else if (typeof document.documentElement != 'undefined'
             && typeof document.documentElement.clientWidth !=
            'undefined' && document.documentElement.clientWidth != 0) {
        viewportwidth = document.documentElement.clientWidth,
                viewportheight = document.documentElement.clientHeight
    }
        // older versions of IE
    else {
        viewportwidth = document.getElementsByTagName('body')[0].clientWidth,
        viewportheight = document.getElementsByTagName('body')[0].clientHeight
    }
    return viewportheight + '|' + viewportwidth;
}
function trimPassword(stringToTrim) {
    return stringToTrim.replace(/^\s+|\s+$/g, "");
}

/* Featured */
function SetRatingStar(star) {
    if (cdnImagePath == null) {
        cdnImagePath = "";
    }
    var cStarHTML = '';
    cStarHTML += "<span class='rating-span'>";
    cStarHTML += "<img src='" + cdnImagePath + "/Images/star-ratting" + ((star.split(':')[0]) >= 1 ? "" : "-off") + ".png' alt='' id='Overall1' style='float: left;' />";
    cStarHTML += "<img src='" + cdnImagePath + "/Images/star-ratting" + ((star.split(':')[0]) >= 2 ? "" : "-off") + ".png' alt='' id='Overall2' style='float: left;' />";
    cStarHTML += "<img src='" + cdnImagePath + "/Images/star-ratting" + ((star.split(':')[0]) >= 3 ? "" : "-off") + ".png' alt='' id='Overall3' style='float: left;' />";
    cStarHTML += "<img src='" + cdnImagePath + "/Images/star-ratting" + ((star.split(':')[0]) >= 4 ? "" : "-off") + ".png' alt='' id='Overall4' style='float: left;' />";
    cStarHTML += "<img src='" + cdnImagePath + "/Images/star-ratting" + ((star.split(':')[0]) >= 5 ? "" : "-off") + ".png' alt='' id='Overall5' style='float: left;' />";
    cStarHTML += "</span>";

    return cStarHTML;
}
function GetFixLengthString(sData, len) {
    if (sData.length > len)
        return sData.substring(0, len - 1) + '..';
    else
        return sData;
}
function setText(element, text) {

    if (typeof element.textContent != 'undefined') {
        element.textContent = text;
    }
    else if (typeof element.innerText != 'undefined') {
        element.innerText = text;
    }
}
/* Featured */
function getTimezoneName() {
    tmSummer = new Date(Date.UTC(2005, 6, 30, 0, 0, 0, 0));
    so = -1 * tmSummer.getTimezoneOffset();
    tmWinter = new Date(Date.UTC(2005, 12, 30, 0, 0, 0, 0));
    wo = -1 * tmWinter.getTimezoneOffset();
    gblso = so;
    gblwo = wo;
    if (-660 == so && -660 == wo) return 'Pacific/Midway';
    if (-600 == so && -600 == wo) return 'Pacific/Tahiti';
    if (-570 == so && -570 == wo) return 'Pacific/Marquesas';
    if (-540 == so && -600 == wo) return 'America/Adak';
    if (-540 == so && -540 == wo) return 'Pacific/Gambier';
    if (-480 == so && -540 == wo) return 'US/Alaska';
    if (-480 == so && -480 == wo) return 'Pacific/Pitcairn';
    if (-420 == so && -480 == wo) return 'US/Pacific';
    if (-420 == so && -420 == wo) return 'US/Arizona';
    if (-360 == so && -420 == wo) return 'US/Mountain';
    if (-360 == so && -360 == wo) return 'America/Guatemala';
    if (-360 == so && -300 == wo) return 'Pacific/Easter';
    if (-300 == so && -360 == wo) return 'US/Central';
    if (-300 == so && -300 == wo) return 'America/Bogota';
    if (-240 == so && -300 == wo) return 'US/Eastern';
    if (-240 == so && -240 == wo) return 'America/Caracas';
    if (-240 == so && -180 == wo) return 'America/Santiago';
    if (-180 == so && -240 == wo) return 'Canada/Atlantic';
    if (-180 == so && -180 == wo) return 'America/Montevideo';
    if (-180 == so && -120 == wo) return 'America/Sao_Paulo';
    if (-150 == so && -210 == wo) return 'America/St_Johns';
    if (-120 == so && -180 == wo) return 'America/Godthab';
    if (-120 == so && -120 == wo) return 'America/Noronha';
    if (-60 == so && -60 == wo) return 'Atlantic/Cape_Verde';
    if (0 == so && -60 == wo) return 'Atlantic/Azores';
    if (0 == so && 0 == wo) return 'Africa/Casablanca';
    if (60 == so && 0 == wo) return 'Europe/London';
    if (60 == so && 60 == wo) return 'Africa/Algiers';
    if (60 == so && 120 == wo) return 'Africa/Windhoek';
    if (120 == so && 60 == wo) return 'Europe/Amsterdam';
    if (120 == so && 120 == wo) return 'Africa/Harare';
    if (180 == so && 120 == wo) return 'Europe/Athens';
    if (180 == so && 180 == wo) return 'Africa/Nairobi';
    if (240 == so && 180 == wo) return 'Europe/Moscow';
    if (240 == so && 240 == wo) return 'Asia/Dubai';
    if (270 == so && 210 == wo) return 'Asia/Tehran';
    if (270 == so && 270 == wo) return 'Asia/Kabul';
    if (300 == so && 240 == wo) return 'Asia/Baku';
    if (300 == so && 300 == wo) return 'Asia/Karachi';
    if (330 == so && 330 == wo) return 'Asia/Calcutta';
    if (345 == so && 345 == wo) return 'Asia/Katmandu';
    if (360 == so && 300 == wo) return 'Asia/Yekaterinburg';
    if (360 == so && 360 == wo) return 'Asia/Colombo';
    if (390 == so && 390 == wo) return 'Asia/Rangoon';
    if (420 == so && 360 == wo) return 'Asia/Almaty';
    if (420 == so && 420 == wo) return 'Asia/Bangkok';
    if (480 == so && 420 == wo) return 'Asia/Krasnoyarsk';
    if (480 == so && 480 == wo) return 'Australia/Perth';
    if (540 == so && 480 == wo) return 'Asia/Irkutsk';
    if (540 == so && 540 == wo) return 'Asia/Tokyo';
    if (570 == so && 570 == wo) return 'Australia/Darwin';
    if (570 == so && 630 == wo) return 'Australia/Adelaide';
    if (600 == so && 540 == wo) return 'Asia/Yakutsk';
    if (600 == so && 600 == wo) return 'Australia/Brisbane';
    if (600 == so && 660 == wo) return 'Australia/Sydney';
    if (630 == so && 660 == wo) return 'Australia/Lord_Howe';
    if (660 == so && 600 == wo) return 'Asia/Vladivostok';
    if (660 == so && 660 == wo) return 'Pacific/Guadalcanal';
    if (690 == so && 690 == wo) return 'Pacific/Norfolk';
    if (720 == so && 660 == wo) return 'Asia/Magadan';
    if (720 == so && 720 == wo) return 'Pacific/Fiji';
    if (720 == so && 780 == wo) return 'Pacific/Auckland';
    if (765 == so && 825 == wo) return 'Pacific/Chatham';
    if (780 == so && 780 == wo) return 'Pacific/Enderbury'
    if (840 == so && 840 == wo) return 'Pacific/Kiritimati';
    return 'US/Pacific';
}
function setCookie(c_name, value, exdays) {
    var exdate = new Date();
    exdate.setDate(exdate.getDate() + exdays);
    var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString()) + "; path=/;";
    document.cookie = c_name + "=" + c_value;
}
function getCookie(c_name) {
    var i, x, y, ARRcookies = document.cookie.split(";");
    for (i = 0; i < ARRcookies.length; i++) {
        x = ARRcookies[i].substr(0, ARRcookies[i].indexOf("="));
        y = ARRcookies[i].substr(ARRcookies[i].indexOf("=") + 1);
        x = x.replace(/^\s+|\s+$/g, "");
        if (x == c_name) {
            return unescape(y);
        }
    }
}

function LoadFacebook(cAppID, cChannelURL) {

}


//Dynamic Review code :: Set Rating

function PrepareReviewStars(SPReviewCount) {
    var objData = document.createElement('a');
    objData.setAttribute("style", "text-decoration:none");
    objData.setAttribute("title", SPReviewCount.toString());
    objData.setAttribute("href", "#");

    if (SPReviewCount >= 1 && SPReviewCount < 2) {
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
    }
    else if (SPReviewCount >= 2 && SPReviewCount < 3) {
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
    }
    else if (SPReviewCount >= 3 && SPReviewCount < 4) {
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
    }
    else if (SPReviewCount >= 4 && SPReviewCount < 5) {
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
    }
    else if (SPReviewCount >= 5) {
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar filledRatingStar\" >&nbsp;</span>";
    }
    else {
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
        objData.innerHTML += "<span style=\"float:left;\" class=\"ratingStar emptyRatingStar\">&nbsp;</span>";
    }
    objData.innerHTML += "</a>";

    return objData.innerHTML;
}

function GetValueFromRank(iRank) {
    var strReturnValue = '';
    iRank = parseFloat(iRank);
    switch (iRank) {
        case 1:
            strReturnValue = "Poor";
            break;
        case 2:
            strReturnValue = "Fair";
            break;
        case 3:
            strReturnValue = "Average";
            break;
        case 4:
            strReturnValue = "Good";
            break;
        case 5:
            strReturnValue = "Excellent";
            break;
    }
    return strReturnValue;
}

function GetRoundValueFromRank(iRank) {
    var strReturnValue = '';
    iRank = Math.round(iRank);
    switch (iRank) {
        case 1:
            strReturnValue = "Poor";
            break;
        case 2:
            strReturnValue = "Fair";
            break;
        case 3:
            strReturnValue = "Average";
            break;
        case 4:
            strReturnValue = "Good";
            break;
        case 5:
            strReturnValue = "Excellent";
            break;
    }
    return strReturnValue;
}

function ScrollToTop() {
    $('html, body').animate({ scrollTop: 0 }, 'slow');
}
function ScrollToTopMenu() {
    $('html, body').animate({ scrollTop: 156 }, 'slow');
}
function ScrollToTopShopDetail() {
    $('html, body').animate({ scrollTop: $('#aTopShopDetail').offset().top }, 'slow');
}
function ScrollToTopPublicAcc() {
    $('html, body').animate({ scrollTop: $('#aTopPublic').offset().top }, 'slow');
}

//CheckSplashScreen();
function CheckSplashScreen(cameFrom, mobileType) {
    Vagaro.MySampleService.CheckToShowSplashScreen(cameFrom, mobileType, CallSuccessCheckSplashShow, CheckSplashShow_CallFailed);
}
function CheckSplashShow_CallFailed(res) {
    //do nothing
}
function CallSuccessCheckSplashShow(val) {
    if (val.toString() == "true")
        location.href = "MobileSplash.aspx";
}
//checkSplashCookie();


/* New Design Update :: Added by rahul :: 19 March 2013 */
function RegisterLazyLoad() {
    $("img.lazy").lazyload({ event: "sporty" });
}
function SetLazyTime() {
    var timeout = setTimeout(function () { $("img.lazy").trigger("sporty"); }, 2000);
}



function ShowLoader(obj) {
    if (obj == true) {
        $("#apgLoading").show();

        if (typeof vgAppicationType != 'undefined' && vgAppicationType == 1) {
            CallbackforMobileApp(0, 0, '', '', 0, 14);
        }
    }
    else {
        $("#apgLoading").hide();
    }
}

//var _0xc5c0 = ["\x70\x72\x6F\x74\x6F\x63\x6F\x6C", "\x2F\x2F", "\x68\x6F\x73\x74\x6E\x61\x6D\x65", "\x70\x6F\x72\x74", "\x3A", "\x2F", "\x57\x65\x62\x53\x65\x72\x76\x69\x63\x65\x73\x2F", "\x50\x4F\x53\x54", "\x61\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x2F\x6A\x73\x6F\x6E\x3B\x20\x63\x68\x61\x72\x73\x65\x74\x3D\x75\x74\x66\x2D\x38", "\x7B", "\x7D", "\x4B", "\x73\x65\x74\x52\x65\x71\x75\x65\x73\x74\x48\x65\x61\x64\x65\x72", "\x49", "\x56\x61\x6C", "\x6A\x73\x6F\x6E", "\x61\x6A\x61\x78"]; function CallWebServicehed(_0x5964x2, _0x5964x3, _0x5964x4, _0x5964x5) { var _0x5964x6 = location[_0xc5c0[0]] + _0xc5c0[1] + location[_0xc5c0[2]] + (location[_0xc5c0[3]] && _0xc5c0[4] + location[_0xc5c0[3]]) + _0xc5c0[5]; _0x5964x2 = _0x5964x6 + _0xc5c0[6] + _0x5964x2; $[_0xc5c0[16]]({ type: _0xc5c0[7], contentType: _0xc5c0[8], url: _0x5964x2, data: _0xc5c0[9] + _0x5964x3 + _0xc5c0[10], beforeSend: function (_0x5964x7) { _0x5964x7[_0xc5c0[12]](_0xc5c0[11], getek()); _0x5964x7[_0xc5c0[12]](_0xc5c0[13], getei()); _0x5964x7[_0xc5c0[12]](_0xc5c0[14], EncIV()); }, dataType: _0xc5c0[15], success: _0x5964x4, error: _0x5964x5 }); };
//var _0x129d = ["\x75\x6E\x64\x65\x66\x69\x6E\x65\x64", "\x6C\x65\x6E\x67\x74\x68", "\x23\x49\x73\x57\x61\x69\x74\x66\x6F\x72\x4B\x65\x65\x70\x41\x4C\x69\x76\x65", "\x76\x61\x6C", "\x74\x6F\x4C\x6F\x77\x65\x72\x43\x61\x73\x65", "\x74\x72\x75\x65", "\x70\x72\x6F\x74\x6F\x63\x6F\x6C", "\x2F\x2F", "\x68\x6F\x73\x74\x6E\x61\x6D\x65", "\x70\x6F\x72\x74", "\x3A", "\x2F", "\x57\x65\x62\x53\x65\x72\x76\x69\x63\x65\x73\x2F", "\x50\x4F\x53\x54", "\x61\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x2F\x6A\x73\x6F\x6E\x3B\x20\x63\x68\x61\x72\x73\x65\x74\x3D\x75\x74\x66\x2D\x38", "\x7B", "\x7D", "\x4B", "\x73\x65\x74\x52\x65\x71\x75\x65\x73\x74\x48\x65\x61\x64\x65\x72", "\x49", "\x56\x61\x6C", "\x6B\x65\x65\x70\x41\x6C\x69\x76\x65", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x31", "\x74\x6F\x6B\x65\x6E\x31", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x32", "\x74\x6F\x6B\x65\x6E\x32", "\x6A\x73\x6F\x6E", "\x61\x6A\x61\x78"]; function CallWebServicehed(_0xf0c3x2, _0xf0c3x3, _0xf0c3x4, _0xf0c3x5) { if (typeof keepAlive == _0x129d[0] && $(_0x129d[2])[_0x129d[1]] > 0 && typeof $(_0x129d[2])[_0x129d[3]]() != _0x129d[0] && $(_0x129d[2])[_0x129d[3]]()[_0x129d[4]]() === _0x129d[5]) { setTimeout(function () { CallWebServicehed(_0xf0c3x2, _0xf0c3x3, _0xf0c3x4, _0xf0c3x5) }, 500); return }; var _0xf0c3x6 = location[_0x129d[6]] + _0x129d[7] + location[_0x129d[8]] + (location[_0x129d[9]] && _0x129d[10] + location[_0x129d[9]]) + _0x129d[11]; _0xf0c3x2 = _0xf0c3x6 + _0x129d[12] + _0xf0c3x2; $[_0x129d[27]]({ type: _0x129d[13], contentType: _0x129d[14], url: _0xf0c3x2, data: _0x129d[15] + _0xf0c3x3 + _0x129d[16], beforeSend: function (_0xf0c3x7) { _0xf0c3x7[_0x129d[18]](_0x129d[17], getek()); _0xf0c3x7[_0x129d[18]](_0x129d[19], getei()); _0xf0c3x7[_0x129d[18]](_0x129d[20], EncIV()); if (typeof keepAlive != _0x129d[0]) { _0xf0c3x7[_0x129d[18]](_0x129d[21], keepAlive) }; if ($(_0x129d[22])[_0x129d[1]] == 1 && typeof $(_0x129d[22])[_0x129d[3]]() != _0x129d[0]) { _0xf0c3x7[_0x129d[18]](_0x129d[23], $(_0x129d[22])[_0x129d[3]]()) }; if ($(_0x129d[24])[_0x129d[1]] == 1 && typeof $(_0x129d[24])[_0x129d[3]]() != _0x129d[0]) { _0xf0c3x7[_0x129d[18]](_0x129d[25], $(_0x129d[24])[_0x129d[3]]()) } }, dataType: _0x129d[26], success: _0xf0c3x4, error: _0xf0c3x5 }) }
//var _0xdb5d = ["\x75\x6E\x64\x65\x66\x69\x6E\x65\x64", "\x6C\x65\x6E\x67\x74\x68", "\x23\x49\x73\x57\x61\x69\x74\x66\x6F\x72\x4B\x65\x65\x70\x41\x4C\x69\x76\x65", "\x76\x61\x6C", "\x74\x6F\x4C\x6F\x77\x65\x72\x43\x61\x73\x65", "\x74\x72\x75\x65", "\x70\x72\x6F\x74\x6F\x63\x6F\x6C", "\x2F\x2F", "\x68\x6F\x73\x74\x6E\x61\x6D\x65", "\x70\x6F\x72\x74", "\x3A", "\x2F", "\x57\x65\x62\x53\x65\x72\x76\x69\x63\x65\x73\x2F", "\x50\x4F\x53\x54", "\x61\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x2F\x6A\x73\x6F\x6E\x3B\x20\x63\x68\x61\x72\x73\x65\x74\x3D\x75\x74\x66\x2D\x38", "\x7B", "\x7D", "\x4B", "\x73\x65\x74\x52\x65\x71\x75\x65\x73\x74\x48\x65\x61\x64\x65\x72", "\x49", "\x56\x61\x6C", "\x6B\x65\x65\x70\x41\x6C\x69\x76\x65", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x31", "\x74\x6F\x6B\x65\x6E\x31", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x32", "\x74\x6F\x6B\x65\x6E\x32", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x30", "\x74\x6F\x6B\x65\x6E\x30", "\x6A\x73\x6F\x6E", "\x61\x6A\x61\x78"]; function CallWebServicehed(_0x549fx2, _0x549fx3, _0x549fx4, _0x549fx5) { if (typeof keepAlive == _0xdb5d[0] && $(_0xdb5d[2])[_0xdb5d[1]] > 0 && typeof $(_0xdb5d[2])[_0xdb5d[3]]() != _0xdb5d[0] && $(_0xdb5d[2])[_0xdb5d[3]]()[_0xdb5d[4]]() === _0xdb5d[5]) { setTimeout(function () { CallWebServicehed(_0x549fx2, _0x549fx3, _0x549fx4, _0x549fx5) }, 500); return }; var _0x549fx6 = location[_0xdb5d[6]] + _0xdb5d[7] + location[_0xdb5d[8]] + (location[_0xdb5d[9]] && _0xdb5d[10] + location[_0xdb5d[9]]) + _0xdb5d[11]; _0x549fx2 = _0x549fx6 + _0xdb5d[12] + _0x549fx2; $[_0xdb5d[29]]({ type: _0xdb5d[13], contentType: _0xdb5d[14], url: _0x549fx2, data: _0xdb5d[15] + _0x549fx3 + _0xdb5d[16], beforeSend: function (_0x549fx7) { _0x549fx7[_0xdb5d[18]](_0xdb5d[17], getek()); _0x549fx7[_0xdb5d[18]](_0xdb5d[19], getei()); _0x549fx7[_0xdb5d[18]](_0xdb5d[20], EncIV()); if (typeof keepAlive != _0xdb5d[0]) { _0x549fx7[_0xdb5d[18]](_0xdb5d[21], keepAlive) }; if ($(_0xdb5d[22])[_0xdb5d[1]] == 1 && typeof $(_0xdb5d[22])[_0xdb5d[3]]() != _0xdb5d[0]) { _0x549fx7[_0xdb5d[18]](_0xdb5d[23], $(_0xdb5d[22])[_0xdb5d[3]]()) }; if ($(_0xdb5d[24])[_0xdb5d[1]] == 1 && typeof $(_0xdb5d[24])[_0xdb5d[3]]() != _0xdb5d[0]) { _0x549fx7[_0xdb5d[18]](_0xdb5d[25], $(_0xdb5d[24])[_0xdb5d[3]]()) }; if ($(_0xdb5d[26])[_0xdb5d[1]] == 1 && typeof $(_0xdb5d[26])[_0xdb5d[3]]() != _0xdb5d[0]) { _0x549fx7[_0xdb5d[18]](_0xdb5d[27], $(_0xdb5d[26])[_0xdb5d[3]]()) } }, dataType: _0xdb5d[28], success: _0x549fx4, error: _0x549fx5 }) }
var _0x76b1 = ["\x75\x6E\x64\x65\x66\x69\x6E\x65\x64", "\x6C\x65\x6E\x67\x74\x68", "\x23\x49\x73\x57\x61\x69\x74\x66\x6F\x72\x4B\x65\x65\x70\x41\x4C\x69\x76\x65", "\x76\x61\x6C", "\x74\x6F\x4C\x6F\x77\x65\x72\x43\x61\x73\x65", "\x74\x72\x75\x65", "\x70\x72\x6F\x74\x6F\x63\x6F\x6C", "\x2F\x2F", "\x68\x6F\x73\x74\x6E\x61\x6D\x65", "\x70\x6F\x72\x74", "\x3A", "\x2F", "\x57\x65\x62\x53\x65\x72\x76\x69\x63\x65\x73\x2F", "\x50\x4F\x53\x54", "\x61\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x2F\x6A\x73\x6F\x6E\x3B\x20\x63\x68\x61\x72\x73\x65\x74\x3D\x75\x74\x66\x2D\x38", "\x7B", "\x7D", "\x4B", "\x73\x65\x74\x52\x65\x71\x75\x65\x73\x74\x48\x65\x61\x64\x65\x72", "\x49", "\x56\x61\x6C", "\x6B\x65\x65\x70\x41\x6C\x69\x76\x65", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x31", "\x74\x6F\x6B\x65\x6E\x31", "\x23\x68\x64\x6E\x54\x6F\x6B\x65\x6E\x32", "\x74\x6F\x6B\x65\x6E\x32", "\x67\x72\x6F\x75\x70\x74\x6F\x6B\x65\x6E", "\x6A\x73\x6F\x6E", "\x61\x6A\x61\x78"]; function CallWebServicehed(_0xe170x2, _0xe170x3, _0xe170x4, _0xe170x5) { if (typeof keepAlive == _0x76b1[0] && $(_0x76b1[2])[_0x76b1[1]] > 0 && typeof $(_0x76b1[2])[_0x76b1[3]]() != _0x76b1[0] && $(_0x76b1[2])[_0x76b1[3]]()[_0x76b1[4]]() === _0x76b1[5]) { setTimeout(function () { CallWebServicehed(_0xe170x2, _0xe170x3, _0xe170x4, _0xe170x5) }, 500); return }; var _0xe170x6 = location[_0x76b1[6]] + _0x76b1[7] + location[_0x76b1[8]] + (location[_0x76b1[9]] && _0x76b1[10] + location[_0x76b1[9]]) + _0x76b1[11]; _0xe170x2 = _0xe170x6 + _0x76b1[12] + _0xe170x2; $[_0x76b1[28]]({ type: _0x76b1[13], contentType: _0x76b1[14], url: _0xe170x2, data: _0x76b1[15] + _0xe170x3 + _0x76b1[16], beforeSend: function (_0xe170x7) { _0xe170x7[_0x76b1[18]](_0x76b1[17], getek()); _0xe170x7[_0x76b1[18]](_0x76b1[19], getei()); _0xe170x7[_0x76b1[18]](_0x76b1[20], EncIV()); if (typeof keepAlive != _0x76b1[0]) { _0xe170x7[_0x76b1[18]](_0x76b1[21], keepAlive) }; if ($(_0x76b1[22])[_0x76b1[1]] == 1 && typeof $(_0x76b1[22])[_0x76b1[3]]() != _0x76b1[0]) { _0xe170x7[_0x76b1[18]](_0x76b1[23], $(_0x76b1[22])[_0x76b1[3]]()) }; if ($(_0x76b1[24])[_0x76b1[1]] == 1 && typeof $(_0x76b1[24])[_0x76b1[3]]() != _0x76b1[0]) { _0xe170x7[_0x76b1[18]](_0x76b1[25], $(_0x76b1[24])[_0x76b1[3]]()) }; if (typeof (groupID) != _0x76b1[0]) { _0xe170x7[_0x76b1[18]](_0x76b1[26], groupID) } }, dataType: _0x76b1[27], success: _0xe170x4, error: _0xe170x5 }) }
function CallWS(strURL, strData, OnSuccess, OnFailure) {
    //strURL="../WebServices/"+strURL;
    strData = "{" + strData + "}";
    CallWSJSON(strURL, strData, OnSuccess, OnFailure);
    //var baseURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/";
    //strURL=baseURl +"WebServices/"+strURL;
    //$.ajax({
    //    type: "POST",
    //    contentType: "application/json; charset=utf-8",
    //    url: strURL,
    //    data: "{" + strData + "}",
    //    dataType: "json",
    //    success: OnSuccess,
    //    error: OnFailure
    //});             
}

//Added By Divyesh On 07/05/2016
function CallWSJSON(strURL, strData, OnSuccess, OnFailure) {
    if (typeof keepAlive == "undefined" && $('#IsWaitforKeepALive').length > 0 && typeof $('#IsWaitforKeepALive').val() != "undefined" && $('#IsWaitforKeepALive').val().toLowerCase() === "true") {
        setTimeout(function () { CallWSJSON(strURL, strData, OnSuccess, OnFailure) }, 500);
        return;
    }

    //strURL="../WebServices/"+strURL;
    var baseURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/";
    strURL = baseURl + "WebServices/" + strURL;
    $.ajax({
        type: "POST",
        contentType: "application/json; charset=utf-8",
        beforeSend: function (xhr) {
            if (typeof keepAlive != 'undefined') {
                xhr.setRequestHeader('keepAlive', keepAlive);
            }
            if ($('#hdnToken1').length == 1 && typeof $('#hdnToken1').val() != 'undefined') {
                xhr.setRequestHeader('token1', $('#hdnToken1').val());
            }
            if ($('#hdnToken2').length == 1 && typeof $('#hdnToken2').val() != 'undefined') {
                xhr.setRequestHeader('token2', $('#hdnToken2').val());
            }
            if (typeof (groupID) != "undefined") {
                xhr.setRequestHeader('grouptoken', groupID);
            }
        },
        url: strURL,
        data: strData,
        dataType: "json",
        success: OnSuccess,
        //error: OnFailure
        error: function (xhr, status, error) {
            try {
                if (xhr.status === 403) {
                    alert("Your session is expired. Please reload your page.");
                    location.reload(true);
                    return;
                }

                if (OnFailure != '' && OnFailure != null && OnFailure != undefined && typeof OnFailure === "function") {
                    OnFailure(xhr, status, error);
                }
            } catch (e) { }
        }
    });
}

//Added By Parth On 07/06/2018
function CallAjax(strURL, strData, OnSuccess, OnFailure) {
    if (typeof keepAlive == "undefined" && $('#IsWaitforKeepALive').length > 0 && typeof $('#IsWaitforKeepALive').val() != "undefined" && $('#IsWaitforKeepALive').val().toLowerCase() === "true") {
        setTimeout(function () { CallWSJSON(strURL, strData, OnSuccess, OnFailure) }, 500);
        return;
    }
    //strURL="../WebServices/"+strURL;
    var baseURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/";
    strURL = baseURl + strURL;
    $.ajax({
        type: "POST",
        contentType: "application/json; charset=utf-8",
        beforeSend: function (xhr) {

            if ($('#hdnPartnerId').length > 0 && typeof $('#hdnPartnerId').val() != 'undefined') {
                xhr.setRequestHeader('partner_id', $('#hdnPartnerId').val());
            }
            if (typeof keepAlive != 'undefined') {
                xhr.setRequestHeader('keepAlive', keepAlive);
            }
            if ($('#hdnToken1').length == 1 && typeof $('#hdnToken1').val() != 'undefined') {
                xhr.setRequestHeader('token1', $('#hdnToken1').val());
            }
            if ($('#hdnToken2').length == 1 && typeof $('#hdnToken2').val() != 'undefined') {
                xhr.setRequestHeader('token2', $('#hdnToken2').val());
            }
            if (typeof (groupID) != "undefined") {
                xhr.setRequestHeader('grouptoken', groupID);
            }
        },
        url: strURL,
        data: strData,
        success: OnSuccess,
        //error: OnFailure
        error: function (xhr, status, error) {
            try {
                if (xhr.status === 403 && !StringisNullOrUndefineOrBlank(strURL) && strURL.indexOf("common/checkbusinessundermaintenance") == -1) {
                    //Added by Nirav Savariya handle error log store in form_error_logger on 26/10/2020
                    var _erroLog = JSON.stringify({ error: strURL, status: 403 });
                    var objData = {
                        _objRequest: {
                            errorLog: _erroLog
                        }
                    };
                    CallAjax("common/saveloginmongo", JSON.stringify(objData), function (res) { }, function (res) { }, false, true);
                    alert("Your session is expired. Please reload your page.");
                    location.reload(true);
                    return;
                }

                if (OnFailure != '' && OnFailure != null && OnFailure != undefined && typeof OnFailure === "function") {
                    OnFailure(xhr, status, error);
                }
            } catch (e) { }
        }
    });
}

//Added By Parth On 06/08/2018
//Common function to handle ajax failed response
function HandleAjaxFailed(response) {
    if (response != null) {
        if (response.responseJSON != null && response.responseJSON.Message != null && response.responseJSON.Message != "") {
            ShowHideFailedMessage(response.responseJSON.Message);
        }
        else {
            ShowHideFailedMessage(defaultErrorMessage);
        }
    }
    else {
        ShowHideFailedMessage(defaultErrorMessage);
    }
}

function AsyncCallWS(strURL, strData, OnSuccess, OnFailure) {
    //strURL="../WebServices/"+strURL;
    strData = "{" + strData + "}";
    AsyncCallWSJSON(strURL, strData, OnSuccess, OnFailure);
    //var baseURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/";
    //strURL = baseURl + "WebServices/" + strURL;
    //$.ajax({
    //    type: "POST",
    //    contentType: "application/json; charset=utf-8",
    //    url: strURL,
    //    async: false,
    //    data: "{" + strData + "}",
    //    dataType: "json",
    //    success: OnSuccess,
    //    error: OnFailure
    //});
}
//Added By Divyesh On 14/05/2016
function AsyncCallWSJSON(strURL, strData, OnSuccess, OnFailure) {
    //strURL="../WebServices/"+strURL;
    var baseURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/";
    strURL = baseURl + "WebServices/" + strURL;
    $.ajax({
        type: "POST",
        contentType: "application/json; charset=utf-8",
        beforeSend: function (xhr) {
            if (typeof keepAlive != 'undefined') {
                xhr.setRequestHeader('keepAlive', keepAlive);
            }
            if ($('#hdnToken1').length == 1 && typeof $('#hdnToken1').val() != 'undefined') {
                xhr.setRequestHeader('token1', $('#hdnToken1').val());
            }
            if ($('#hdnToken2').length == 1 && typeof $('#hdnToken2').val() != 'undefined') {
                xhr.setRequestHeader('token2', $('#hdnToken2').val());
            }
            if (typeof (groupID) != "undefined") {
                xhr.setRequestHeader('grouptoken', groupID);
            }
        },
        url: strURL,
        async: false,
        data: strData,
        dataType: "json",
        success: OnSuccess,
        //error: OnFailure
        error: function (xhr, status, error) {
            try {
                if (xhr.status === 403) {
                    alert("Your session is expired. Please reload your page.");
                    location.reload(true);
                    return;
                }

                if (OnFailure != '' && OnFailure != null && OnFailure != undefined && typeof OnFailure === "function") {
                    OnFailure(xhr, status, error);
                }
            } catch (e) { }
        }
    });
}


function AddUserControlAsync(strURL, strData, div) {
    var baseURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/";
    strURL = baseURl + "WebServices/" + strURL;
    $.ajax({
        type: "POST",
        contentType: "application/json; charset=utf-8",
        url: strURL,
        async: false,
        data: strData,
        dataType: "json",
        success: function (r) {
            div.append(r.d);
        },
        error: function (r) {
            alert('error occured.');
        }
    });
}
//function CallWSNew(strURL, strData, OnSuccess,OnFailure) 
//{   
//    $.ajax({
//        type: "POST",
//        contentType: "application/json; charset=utf-8",
//        url: strURL,
//        data: "{" + strData + "}",
//        dataType: "json",
//        success: OnSuccess,
//        error: OnFailure
//    });             
//}

function RedirectToShopListReview(sUrl, isOpen) {
    var data = "tab=7" + ((isOpen == "1") ? "&mode=O" : "");
    if (isOpen == "1") {
        data2 = "&mode=O";
    }
    else {
        data2 = "";
    }
    var Parameter = '"sValue" : "' + data + data2 + '"';

    CallWS('MySampleService.asmx/SetShopDetailSession', Parameter, RedirectPage(sUrl), RedirectPage(sUrl));
}


//Clear Controls
function ClearValidationControls() {
    $('.inputbox-type1').removeClass("errorInput");
    //$('.inputbox-type1').val('');
    $('.requiredErrorText').hide();
    $('.errorInput').hide();

}

function CallParentFunction(divName, URL, title) {
    ShowDynamicPopup(URL, 442, 766, divName, title);
    return false;
}

function HidePrivacyPolicy(obj) {
    if (obj == 3) {
        HideDynamicPopup("divUserAgreement");
    }
    else if (obj == 11) {
        HideDynamicPopup("divCustomerAgreement");
    }
    else {
        HideDynamicPopup("divPrivacyPolicy");
    }
}

function RegisterMenuScroll() {
    $(function () {
        var sticky_navigation_offset_top = $('.inBanner').offset().top;
        var sticky_navigation = function () {
            var scroll_top = $(window).scrollTop(); // our current vertical position from the top
            if (scroll_top > sticky_navigation_offset_top) {
                $('.inBanner').css({ 'position': 'fixed', 'top': '34px', 'z-index': 999 });
                $('#navigation').css({ 'position': 'fixed', 'top': 0, 'z-index': 999 });
            } else {
                $('.inBanner').css({ 'position': 'relative', 'top': 0 });
                $('#navigation').css({ 'position': 'relative' });
            }
        };
        // run our function on load
        sticky_navigation();
        // and run it again every time you scroll
        $(window).scroll(function () {
            sticky_navigation();
        });
    });
}
//AddThis Smart Layers BEGIN -->
//Go to http://www.addthis.com/get/smart-layers to customize -->
function LoadAddToThisSmartLayer() {
    $.getScript("https://s7.addthis.com/js/300/addthis_widget.js#pubid=fredhelou", function (data, textStatus, jqxhr) {
        if (textStatus == "success" && jqxhr.status == 200) {
            addthis.layers({
                'theme': 'transparent',
                'share': {
                    'position': 'left',
                    'numPreferredServices': 5
                },
                'follow': {
                    'services': [
                      { 'service': 'facebook', 'id': 'vagaro' },
                      { 'service': 'twitter', 'id': 'vagaro' },
                      { 'service': 'pinterest', 'id': 'VagaroPins' }
                    ]
                }
            });
        }
    });
}
//AddThis Smart Layers END

function remainingTextCounter(input, output, outputField, maxLength) {
    output = document.getElementById(output);
    input = ('object' === typeof input || 'function' === typeof input) ? input : document.getElementById(input);
    if (input.value.length > maxLength) {
        input.value = input.value.substring(0, maxLength);
        output[outputField] = 0;
        return false;
    } else {
        output[outputField] = maxLength - input.value.length;
    }
}
/*converts JSON date to normal javascript date : 05/13/2016 */
function convertJSONDateToDate(jsonDaTe) {
    if (jsonDaTe == undefined || jsonDaTe == null) {
        return jsonDaTe;
    }
    var re = /-?\d+/;
    var m = re.exec(jsonDaTe);
    return new Date(parseInt(m[0]));
}

//function initDropyMenu() {
//    $('.drop-down-navigation').droppy();

//    $('.navigation-toggle').click(function () {
//        $('.drop-down-navigation').slideToggle("fast");
//    });
//}

//Added By Tejas Bhalani 21-03-2017
//start new search customer from broswer LocalStorage block 
var cache_ulCustomerList = null;
var cache_divCustomers = null;
var cache_txtSearchCustomer = null;


var cache_divCustomersData = null;
var cache_pgNoMatchDiv = null;
var cache_pgDiv = null;
var cache_divtxtCustomers = null;
var cache_ctrlendIndex = null;
var cache_ctrltotalCout = null;
var cache_isFromiPadAndroid = null;
var cache_isLoadCustFromDB = null;
var cache_syncDuration = null;
var cache_liSelectedClassName = null;
var cache_HasCustomerRight = null;
var cache_BusinessId = null;

var cache_custlist = "cusList";
var cache_cusSynInfo = "cusSynInfo";
var cache_pageIndex = 0;
var cache_pageSize = 10;
var cache_noOfRecords = 0;
var cache_glbData = [];
var cache_MS_PER_MINUTE = 60000;
var cache_isDBCallOnly = false;
var cache_lastSearchText = "";
var cache_isFirstTime = false;
var cache_isSyncStarted = false;
var cache_liSelected;
var cache_glbisScrollTop = false;
var cache_OldSelectctedUserId = 0;
var cache_IsValidControls = false;
var IsFirsttime = true;
var cache_PageType = {
    "newappointmentbook": 1, "addeditcustomer": 2, "searchnewappointment": 3, "mergefromcustomer": 4, "mergetocustomer": 5,
    "customermanagement": 6, "giftcertificatesender": 7, "giftcertificateeceipient": 8
};
var glbPageName = "";
function InitializecomponentWrapper(pagename, FixAssignVariable) {
    //if (true) {

    //}
    //Initializecomponent(controls)
    var controls = {};

    if (cache_PageType[pagename] == 1) {// New Appointment Popup
        controls.ulCustomerList = "ulCustomers";
        controls.divCustomers = "divCustomers";
        controls.txtSearchCustomer = "txtSearchCustomer";
        controls.divCustomersData = "divCustomersData";
        controls.pgNoMatchDiv = "pgNoMatchDiv";
        controls.pgDiv = "pgDiv";
        controls.totalCout = 'totalCout';
        controls.endIndex = 'endIndex';
        controls.divtxtCustomers = "divtxtCustomers";
    }
    else if (cache_PageType[pagename] == 2) {//Add edit customer popup

        controls.ulCustomerList = "ulCustomersAddEdit";
        controls.divCustomers = "divCustomersAddEdit";
        controls.txtSearchCustomer = "txtCustomerSearchAddEdit";
        controls.divCustomersData = "divCustomersDataAddEdit";
        controls.pgNoMatchDiv = "pgNoMatchDivAddEdit";
        controls.pgDiv = "pgDivAddEdit";
        controls.totalCout = 'totalCoutAddEdit';
        controls.endIndex = 'endIndexAddEdit';
        controls.divtxtCustomers = "divtxtCustomersAddEdit";
    }
    else if (cache_PageType[pagename] == 3) { //Searach New Appointment

        controls.ulCustomerList = "ulCustomersAppointment";
        controls.divCustomers = "divCustomersAppointment";
        controls.txtSearchCustomer = "txtCustomerSearchAppointment";
        controls.divCustomersData = "divCustomersDataAppointment";
        controls.pgNoMatchDiv = "pgNoMatchDivAppointment";
        controls.pgDiv = "pgDivAppointment";
        controls.totalCout = 'totalCoutAppointment';
        controls.endIndex = 'endIndexAppointment';
        controls.divtxtCustomers = "divtxtCustomersAppointment";
    }
    else if (cache_PageType[pagename] == 4) { // Merge From Customer dropdown

        controls.ulCustomerList = "ulCustomersFrom";
        controls.divCustomers = "divCustomersFrom";
        controls.txtSearchCustomer = "txtCustomerSearchFrom";
        controls.divCustomersData = "divCustomersDataFrom";
        controls.pgNoMatchDiv = "pgNoMatchDivFrom";
        controls.pgDiv = "pgDivFrom";
        controls.totalCout = 'totalCoutFrom';
        controls.endIndex = 'endIndexFrom';
        controls.divtxtCustomers = "divtxtCustomersFrom";
    }
    else if (cache_PageType[pagename] == 5) {// Merge To Customer dropdown
        controls.ulCustomerList = "ulCustomers_To";
        controls.divCustomers = "divCustomers_To";
        controls.txtSearchCustomer = "txtCustomerSearch_To";
        controls.divCustomersData = "divCustomersData_To";
        controls.pgNoMatchDiv = "pgNoMatchDiv_To";
        controls.pgDiv = "pgDiv_To";
        controls.totalCout = 'totalCout_To';
        controls.endIndex = 'endIndex_To';
        controls.divtxtCustomers = "divtxtCustomers_To";
    }
    else if (cache_PageType[pagename] == 6) {// Customer management
        controls.ulCustomerList = "ulCustomers";
        controls.divCustomers = "divCustomers";
        controls.txtSearchCustomer = "txtCustomerSearch";
        controls.divCustomersData = "divCustomersData";
        controls.pgNoMatchDiv = "pgNoMatchDiv";
        controls.pgDiv = "pgDiv";
        controls.totalCout = 'totalCout';
        controls.endIndex = 'endIndex';
        controls.divtxtCustomers = "divtxtCustomers";
    }
    else if (cache_PageType[pagename] == 7) {// Gift Certificate sender customer dropdown
        controls.ulCustomerList = "ulCustomersGift";
        controls.divCustomers = "divCustomersGift";
        controls.txtSearchCustomer = "txtCustomerSearchGift";
        controls.divCustomersData = "divCustomersDataGift";
        controls.pgNoMatchDiv = "pgNoMatchDivGift";
        controls.pgDiv = "pgDivGift";
        controls.totalCout = 'totalCoutGift';
        controls.endIndex = 'endIndexGift';
        controls.divtxtCustomers = "divtxtCustomersGift";
    }
    else if (cache_PageType[pagename] == 8) {// Gift Certificate Receipient customer dropdown
        controls.ulCustomerList = "ulCustomersReceipient";
        controls.divCustomers = "divCustomersReceipient";
        controls.txtSearchCustomer = "txtCustomerSearchReceipient";
        controls.divCustomersData = "divCustomersDataReceipient";
        controls.pgNoMatchDiv = "pgNoMatchDivReceipient";
        controls.pgDiv = "pgDivReceipient";
        controls.totalCout = 'totalCoutReceipient';
        controls.endIndex = 'endIndexReceipient';
        controls.divtxtCustomers = "divtxtCustomersReceipient";
    }


    if (FixAssignVariable != null && Object.getOwnPropertyNames(FixAssignVariable).length > 0) {
        controls.isFromiPadAndroid = FixAssignVariable.isFromiPadAndroid;
        controls.isLoadCustFromDB = FixAssignVariable.isLoadCustFromDB;
        controls.syncDuration = FixAssignVariable.syncDuration;
        controls.liSelectedClassName = FixAssignVariable.liSelectedClassName;
        controls.HasCustomerRight = FixAssignVariable.HasCustomerRight;
        controls.BusinessId = FixAssignVariable.BusinessId;
    }
    else {
        controls.isFromiPadAndroid = cache_isFromiPadAndroid;
        controls.isLoadCustFromDB = cache_isLoadCustFromDB;
        controls.syncDuration = cache_syncDuration;
        controls.liSelectedClassName = cache_liSelectedClassName;
        controls.HasCustomerRight = cache_HasCustomerRight;
        controls.BusinessId = cache_BusinessId;
    }
    if (glbPageName != cache_PageType[pagename]) {

        glbPageName = cache_PageType[pagename];
        Initializecomponent(controls)
    }

}

//Initialize component for Caching Customer Dropdown
function Initializecomponent(controls) {
    ///    console.log(1);
    cache_ulCustomerList = GetClientID(controls.ulCustomerList);
    cache_divCustomers = GetClientID(controls.divCustomers);
    cache_txtSearchCustomer = GetClientID(controls.txtSearchCustomer);

    cache_divCustomersData = GetClientID(controls.divCustomersData);
    cache_pgNoMatchDiv = GetClientID(controls.pgNoMatchDiv);
    cache_pgDiv = GetClientID(controls.pgDiv);
    cache_divtxtCustomers = GetClientID(controls.divtxtCustomerscache_pgDiv);

    cache_ctrlendIndex = GetClientID(controls.endIndex);
    cache_ctrltotalCout = GetClientID(controls.totalCout);

    cache_isFromiPadAndroid = controls.isFromiPadAndroid;
    cache_isLoadCustFromDB = controls.isLoadCustFromDB;
    cache_syncDuration = controls.syncDuration;
    cache_liSelectedClassName = controls.liSelectedClassName;
    cache_HasCustomerRight = controls.HasCustomerRight;
    cache_BusinessId = controls.BusinessId;
    //Added By Tejas bhalani 15-05-2017
    //Reoslved Issue Bug No 281
    //cache_txtSearchCustomer.blur();
    //End
    Load_CachingCustomer();
    cache_IsValidControls = IsValidControls(controls);


    //document mousedown event
    $(document).mousedown(function (e) {

        if (cache_IsValidControls == true) {
            //if ((!StringisNullOrUndefineOrBlank(cache_divCustomersData))) {
            var container = cache_divCustomersData;//$("#cache_divCustomersData");
            //var cache_pgNoMatchDiv = cache_pgNoMatchDiv;//$("#cache_pgNoMatchDiv");
            //var cache_pgDiv = cache_pgDiv;//$("#cache_pgDiv");
            //var cache_divtxtCustomers = cache_divtxtCustomers;//$("#cache_divtxtCustomers");

            if ((!container.is(e.target) && container.has(e.target).length === 0) &&
                (!cache_divCustomers.is(e.target) && cache_divCustomers.has(e.target).length === 0) &&
                (!cache_pgDiv.is(e.target) && cache_pgDiv.has(e.target).length === 0) &&
                (!cache_pgNoMatchDiv.is(e.target) && cache_pgNoMatchDiv.has(e.target).length === 0) &&
                (!cache_divtxtCustomers.is(e.target) && cache_divtxtCustomers.has(e.target).length === 0)) {
                if (cache_divCustomers.is(":visible")) {
                    cache_divCustomers.slideUp(250, function () {
                        cache_ulCustomerList.unbind('scroll');
                        cache_liSelected = null;
                        ///https://cache_txtSearchCustomer.blur();

                    });
                }
            }
        }
    });

    //document mouseover event
    $(document).mouseover(function (e) {
        //if ((!StringisNullOrUndefineOrBlank(cache_divCustomersData)) && (!StringisNullOrUndefineOrBlank(cache_ulCustomerList))) {


        if (cache_IsValidControls == true) {
            var container = cache_ulCustomerList;//$("#cache_divCustomersData");
            var li = cache_ulCustomerList.find('> li');
            if ((!container.is(e.target) && container.has(e.target).length !== 0)
                 || (!cache_divCustomers.is(e.target) && cache_divCustomers.has(e.target).length !== 0)) {
                if (li !== undefined) {
                    li.removeClass(cache_liSelectedClassName);
                    cache_txtSearchCustomer.focus();
                    IsFirsttime = true;
                }
            }

        }
    });

    cache_txtSearchCustomer.on("keydown paste", function (event) {
        txtSearchCustomer_Keyup(event);
    });
}
function Load_CachingCustomer() {
    var isPrivateBrowsing = false;
    //need to check that private browsing allow to set/get for locastorage
    if (typeof localStorage === 'object') {
        try {
            localStorage.setItem('localStorage', 1);
            localStorage.removeItem('localStorage');
        } catch (e) {
            cache_isDBCallOnly = true;
            isPrivateBrowsing = true;
            //alert('Your web browser does not support storing settings locally. In Safari, the most common cause of this is using "Private Browsing Mode". Some settings may not save or some features may not work properly for you.');
        }
    }

    if (lastSyncBusID() != parseFloat(cache_BusinessId)) {
        InvalidateLocalStorage();
    }
    else {
        cache_glbData = (typeof localStorage === 'object' && localStorage[cache_custlist] !== undefined && localStorage[cache_custlist].length > 0) ? JSON.parse(localStorage[cache_custlist] || []) : [];
    }

    if (isPrivateBrowsing) {
        cache_pageIndex = 0;
        cache_pageSize = 10;
        cache_isDBCallOnly = true;
        cache_isFirstTime = true;
    }
    else {
        if (cache_isFirstTime == false && (typeof localStorage === 'object') && (LastSyncDate() == null && MaxQuataReached() == false)) {

            cache_pageIndex = 0;
            cache_pageSize = 10;
            cache_isDBCallOnly = true;

            setTimeout(function () {
                if (isIEBrowser() == false || !cache_isFromiPadAndroid)
                    GetFirstTimeAllCustomers();
            }, 1000);
        }
        else {
            if (isIEBrowser() || cache_isFromiPadAndroid)
                cache_isDBCallOnly = true;
            else
                cache_isDBCallOnly = cache_isLoadCustFromDB;

            cache_isFirstTime = true;

        }
    }
}
//cache_txtSearchCustomer focus event
function txtSearchCustomer_focus(e) {

    try {
        IsFirsttime = true;
        if (cache_IsValidControls == true) {
            if (cache_divCustomers.is(":visible") == false) {

                cache_ulCustomerList.scrollTop(0);
                cache_pageIndex = 0;
                cache_pageSize = 10;
                try {
                    cache_ulCustomerList.html("<li>Loading..</li>");
                    cache_divCustomers.slideDown(250, function () {
                        cache_ulCustomerList.bind('scroll', onCustomerListScroll);
                    });

                    cache_glbData = (typeof localStorage === 'object' && localStorage[cache_custlist] !== undefined && localStorage[cache_custlist].length > 0) ? JSON.parse(localStorage[cache_custlist] || []) : [];
                } catch (dr) { }

                LoadMoreCustomers();
                if (IsFromLocalStorage() && NeedToSync() && !cache_isSyncStarted) {
                    cache_isSyncStarted = true;
                    setTimeout(function () {
                        GetCustomersForSync();
                    }, 1000);
                }
            }
            //if (cache_liSelected != null && cache_ulCustomerList.find('> li') !== undefined) {
            //    cache_liSelected = cache_ulCustomerList.find(" li:nth-child(" + ((cache_pageIndex - 1) * cache_pageSize) / 2 + ")").addClass(cache_liSelectedClassName);
            //} 
        }
    }

    catch (a) { console.log(a); }

}

///https://textbox keyup event
function txtSearchCustomer_Keyup(e) {

    if (cache_IsValidControls == true) {

        var strSearchText = cache_txtSearchCustomer.val();

        try {
            keyCode = e.which || e.keyCode;
            //enter key handle
            if ((!StringisNullOrUndefineOrBlank(typeof (keyCode))) && (keyCode == 13)) {
                if (cache_ulCustomerList.find(' > li.' + cache_liSelectedClassName + '').length == 0 && cache_ulCustomerList.find(' > li.' + cache_liSelectedClassName + '').data("custid") == undefined) {
                    ///https://cache_txtSearchCustomer.blur();
                    if (cache_PageType["giftcertificatesender"] == glbPageName || cache_PageType["giftcertificateeceipient"] == glbPageName) {
                        CloseCachingCustomerDropdown();
                    }
                    e.preventDefault();
                    ///https://alert("Please select customer first using key down arrow.");
                    return;
                }
                SelectCustomerOnEnter();
                e.preventDefault();
                return;
            }
            if (StringisNullOrUndefineOrBlank(strSearchText) || e.keyCode == 8) {
                cache_OldSelectctedUserId = 0;
            }
            //tab key,left key and right key and backspace key handle //page up 33 and page down 34// end 35 insert 45  
            if ((!StringisNullOrUndefineOrBlank(typeof (keyCode))) && (keyCode == 9 || keyCode == 37 || keyCode == 39 || keyCode == 33 || keyCode == 34 || keyCode == 35 || keyCode == 45 ||
                (keyCode == 8 && strSearchText.trim() == "" && (cache_lastSearchText == strSearchText)))) {
                e.preventDefault();
                return;
            }
            ///https://up,down,right,left arrow key                        
            if ((!StringisNullOrUndefineOrBlank(typeof (keyCode))) && (keyCode == 38 || keyCode == 40)) {

                var li = cache_ulCustomerList.find('> li');

                if ($("#liNoCust") !== undefined && $("#liNoCust").text() != "") {
                    e.preventDefault();
                    return;
                }
                if (li !== undefined)
                    li.removeClass(cache_liSelectedClassName);
                //down arrow key handle

                if ((!StringisNullOrUndefineOrBlank(typeof (keyCode))) && keyCode == 40) {
                    ///https://below if condition for when click on bottom after click on textbox at that time selection was gone
                    if (IsFirsttime) {
                        IsFirsttime = false;
                        cache_liSelected = null;
                        cache_ulCustomerList.scrollTop(0);
                    }
                    if (cache_liSelected) {
                        cache_liSelected.removeClass(cache_liSelectedClassName);
                        next = cache_liSelected.next();
                        //olc code of Below code form when only 10 records at that time cursor not move on first record
                        //if (next.length > 0) {
                        //    cache_liSelected = next.addClass(cache_liSelectedClassName);
                        //    selected = next.text();
                        //} else {
                        //    cache_liSelected = li.eq(0).addClass(cache_liSelectedClassName);
                        //    selected = li.eq(0).text();
                        //}

                        //Below code form when only 10 records at that time cursor not move on first record
                        if (next.length > 0) {

                            cache_liSelected = next.addClass(cache_liSelectedClassName);
                            selected = next.text();
                        }
                        else {
                            //if (selected != undefined && cache_ulCustomerList.find(" li:nth-child(" + $("#endIndex")[0].innerHTML + ")").eq(0).text() == selected) {
                            //    cache_liSelected = cache_ulCustomerList.find(" li:nth-child(" + $("#endIndex")[0].innerHTML + ")").addClass('drpselected');
                            //    selected = cache_ulCustomerList.find(" li:nth-child(" + $("#endIndex")[0].innerHTML + ")").eq(0).text();
                            //}
                            if (selected != undefined && cache_ulCustomerList.find(" li:nth-child(" + cache_ctrlendIndex[0].innerHTML + ")").eq(0).text() == selected) {
                                cache_liSelected = cache_ulCustomerList.find(" li:nth-child(" + cache_ctrlendIndex[0].innerHTML + ")").addClass('drpselected');
                                selected = cache_ulCustomerList.find(" li:nth-child(" + cache_ctrlendIndex[0].innerHTML + ")").eq(0).text();
                            }
                            else {
                                cache_liSelected = li.eq(0).addClass(cache_liSelectedClassName);
                                selected = li.eq(0).text();
                            }
                        }
                    } else {
                        cache_liSelected = li.eq(0).addClass(cache_liSelectedClassName);
                        selected = li.eq(0).text();
                    }
                    var index = (cache_pageIndex * cache_pageSize);
                    if (selected == cache_ulCustomerList.find(" li:nth-child(" + index + ")").data("fullname")) {

                        LoadMoreCustomers();
                        cache_liSelected = cache_ulCustomerList.find(" li:nth-child(" + index + ")").addClass(cache_liSelectedClassName);
                        selected = cache_ulCustomerList.find(" li:nth-child(" + index + ")").eq(0).text();
                    }

                    //cache_ulCustomerList.scrollTop(cache_liSelected.prev().index() * cache_liSelected.prev().outerHeight());                           
                    cache_ulCustomerList.scrollTop(cache_ulCustomerList.scrollTop() + cache_ulCustomerList.find(" li:nth-child(" + cache_liSelected.index() + ")").outerHeight());
                }
                    //up arrow key handle
                else if ((!StringisNullOrUndefineOrBlank(typeof (keyCode))) && keyCode == 38) {

                    if (cache_liSelected == null || cache_liSelected.index() == 0) {
                        cache_liSelected = null;
                        e.preventDefault();
                        return;
                    }
                    if (cache_liSelected) {
                        cache_liSelected.removeClass(cache_liSelectedClassName);
                        next = cache_liSelected.prev();
                        if (next.length > 0) {
                            cache_liSelected = next.addClass(cache_liSelectedClassName);
                            selected = next.text();
                        } else {
                            cache_liSelected = li.last().addClass(cache_liSelectedClassName);
                            selected = li.last().text();
                        }
                    } else {
                        cache_liSelected = li.last().addClass(cache_liSelectedClassName);
                        selected = li.last().text();
                    }
                    //cache_ulCustomerList.scrollTop(cache_liSelected.prev().index() * cache_liSelected.prev().outerHeight());                    
                    if (cache_liSelected.index() == 0)
                        cache_ulCustomerList.scrollTop(0);
                    else
                        cache_ulCustomerList.scrollTop(cache_ulCustomerList.scrollTop() - cache_ulCustomerList.find(" li:nth-child(" + (cache_liSelected.index() + 1) + ")").outerHeight());

                }
                e.preventDefault();
                return;
            }
        } catch (a) { console.log(a); }
        //End
        cache_lastSearchText = strSearchText;
        cache_pageIndex = 0;
        cache_pageSize = 10;
        cache_ulCustomerList.html("<li>Loading..</li>");
        LoadMoreCustomers();
    }
}

///https://textbox keydown event
function txtSearchCustomer_Keydown(e) {
    try {

        if (cache_IsValidControls == true && cache_isDBCallOnly == false) {
            keyCode = e.which || e.keyCode;
            //if (typeof (keyCode) !== undefined && (keyCode == 9)) {
            if ((!StringisNullOrUndefineOrBlank(typeof (keyCode))) && (keyCode == 9)) {
                //var li = cache_ulCustomerList.find('> li');
                //if (li !== undefined)
                //    li.removeClass(cache_liSelectedClassName);

                //cache_txtSearchCustomer.focus();
                e.preventDefault();
                return;
            }
        }
    }
    catch (a) { }

}

///https://scroll event on custom dropdown control
function onCustomerListScroll() {
    if (cache_IsValidControls == true) {
        if (cache_ulCustomerList.scrollTop() + (cache_ulCustomerList.innerHeight()) >= (cache_ulCustomerList[0].scrollHeight - 50)) {
            LoadMoreCustomers();
        }
    }
}

//function to set sync again 
function SyncAgain() {
    try {
        if (localStorage[cache_cusSynInfo] !== undefined) {
            var cusSynInfo = JSON.parse(localStorage[cache_cusSynInfo]);
            var lastDate = cusSynInfo.lstDt;
            if (lastDate != null) {
                lastDate = new Date(lastDate);
                var myNewDate = new Date(lastDate - (cache_syncDuration + 1) * cache_MS_PER_MINUTE);
                cusSynInfo.lstDt = myNewDate;
                localStorage[cache_cusSynInfo] = JSON.stringify(cusSynInfo);
            }
        }
    } catch (ed) { }
}

//function to get all customers
function GetCustomers() {
    if (IsFromLocalStorage() == false) {
        if ((cache_noOfRecords > cache_pageSize && cache_noOfRecords <= ((cache_pageIndex * cache_pageSize) + 1)) || (cache_noOfRecords > 0 && ((cache_pageIndex * cache_pageSize) + 1) > cache_noOfRecords)) {
            return;
        }
    }

    var _IsForLocalStorage = (LastSyncDate() == null && MaxQuataReached() == false) ? true : (MaxQuataReached() == false);
    var _LastSyncDate = null;
    if (_IsForLocalStorage) {

        var dataList = (typeof localStorage === 'object' && localStorage[cache_custlist] !== undefined && localStorage[cache_custlist].length > 0) ? JSON.parse(localStorage[cache_custlist] || []) : [];
        if (dataList != null && dataList.length > 0) {
            _LastSyncDate = LastSyncDate();
        }
    }

    var dataicache_BusinessId = IsControlUnderfined(cache_BusinessId) ? 0 : cache_BusinessId;
    var datacache_HasCustomerRights = GetCachingCustomerRight();// IsControlUnderfined(cache_HasCustomerRight) ? false : cache_HasCustomerRight;
    var datastrText = (MaxQuataReached() == false) ? "" : cache_txtSearchCustomer.val();
    var datacache_pageIndex = (MaxQuataReached() == false) ? 1 : (cache_pageIndex + 1);
    var datacache_pageSize = (MaxQuataReached() == false) ? 1000000 : cache_pageSize;
    var dataLastSyncDate = _LastSyncDate;
    var dataIsForLocalStorage = _IsForLocalStorage;

    var vgCustomers = new vagaro.ajax();
    vgCustomers.datamodel.Token = 'GetAllCustomers';
    vgCustomers.datamodel.callback = GetCustomers_Success;
    vgCustomers.datamodel.data = [dataicache_BusinessId, datastrText, datacache_HasCustomerRights, datacache_pageIndex, datacache_pageSize, dataLastSyncDate, dataIsForLocalStorage];
    vgCustomers.datamodel.Error = GetCustomers_Fail
    vgCustomers.PostQue();

}
//function for GetCustomers success event
function GetCustomers_Success(obj) {

    if (obj != null) {
        var objSearchList = obj.objUsersList;
        if ((typeof localStorage === 'object')) {
            if (MaxQuataReached() == false) {
                if (LastSyncDate() == null) {
                    InvalidateLocalStorage();
                }
                objSearchList = StoreLocalStorage(obj.objUsersList, obj.lastCalledTime, obj.deletedIDs);
                obj.TotalCount = objSearchList != null ? objSearchList.length : 0;
                cache_glbData = (typeof localStorage === 'object' && localStorage[cache_custlist] !== undefined && localStorage[cache_custlist].length > 0) ? JSON.parse(localStorage[cache_custlist] || []) : [];
            }
        }
        try {
            objSearchList = objSearchList.sort(Sortingalphabetical);
        } catch (ex1) { }

        SearchCustomer(objSearchList, obj.TotalCount);
    }

}

//function for GetCustomers/GetCustomersForSync fail event
function GetCustomers_Fail() {
    cache_isSyncStarted = false;
}
//function to get data for next sync with background call
function GetCustomersForSync() {
    var _IsForLocalStorage = (LastSyncDate() == null && MaxQuataReached() == false) ? true : (MaxQuataReached() == false);
    var _LastSyncDate = null;
    if (_IsForLocalStorage) {
        var dataList = (typeof localStorage === 'object' && localStorage[cache_custlist] !== undefined && localStorage[cache_custlist].length > 0) ? JSON.parse(localStorage[cache_custlist] || []) : [];
        if (dataList != null && dataList.length > 0) {
            _LastSyncDate = LastSyncDate();
        }
    }

    var dataicache_BusinessId = IsControlUnderfined(cache_BusinessId) ? 0 : cache_BusinessId;
    var datacache_HasCustomerRights = GetCachingCustomerRight();//IsControlUnderfined(cache_HasCustomerRight) ? false : cache_HasCustomerRight;
    var datastrText = "";
    var datacache_pageIndex = 1;
    var datacache_pageSize = 10;
    var dataLastSyncDate = _LastSyncDate;
    var dataIsForLocalStorage = _IsForLocalStorage;

    var vgCustomers = new vagaro.ajax();
    vgCustomers.datamodel.Token = 'GetAllCustomers';
    vgCustomers.datamodel.callback = GetCustomersForSync_Success;
    vgCustomers.datamodel.data = [dataicache_BusinessId, datastrText, datacache_HasCustomerRights, datacache_pageIndex, datacache_pageSize, dataLastSyncDate, dataIsForLocalStorage];
    vgCustomers.datamodel.Error = GetCustomers_Fail
    vgCustomers.PostQue();

}
//function for GetCustomersForSync success event
function GetCustomersForSync_Success(obj) {

    if (obj != null) {
        var objSearchList = obj.objUsersList;
        if ((typeof localStorage === 'object')) {
            if (MaxQuataReached() == false) {
                if (LastSyncDate() == null) {
                    InvalidateLocalStorage();
                }
                StoreLocalStorage(obj.objUsersList, obj.lastCalledTime, obj.deletedIDs);
                cache_glbData = (typeof localStorage === 'object' && localStorage[cache_custlist] !== undefined && localStorage[cache_custlist].length > 0) ? JSON.parse(localStorage[cache_custlist] || []) : [];
            }
        }
    }
    cache_isSyncStarted = false;
}

//function to invalidate local storage 
function InvalidateLocalStorage() {
    if ((typeof localStorage === 'object')) {
        localStorage.removeItem(cache_custlist);
        localStorage.removeItem(cache_cusSynInfo);
    }
}

//function to store local storage of customer list and some sync information
function StoreLocalStorage(newList, syncDate, DeletedIDs) {
    var combineList = newList;
    var cusSynInfo = {};
    cusSynInfo.busID = parseFloat(cache_BusinessId);
    cusSynInfo.lstDt = new Date();
    cusSynInfo.maxDt = new Date();
    cusSynInfo.synDt = syncDate;
    try {
        cusSynInfo.IsMaxQuataReached = false;
        localStorage.removeItem(cache_cusSynInfo);
        localStorage[cache_cusSynInfo] = JSON.stringify(cusSynInfo);
        if (LastSyncDate() == null) {
            if (newList != null) {
                localStorage[cache_custlist] = JSON.stringify(newList);
            }
            else {
                localStorage[cache_custlist] = [];
            }
        }
        else {

            var oldList = [];
            if ((localStorage[cache_custlist] !== undefined)) {
                oldList = JSON.parse(localStorage[cache_custlist]);
            }
            if (DeletedIDs != null && DeletedIDs != "" && DeletedIDs.length > 0 && oldList != null && oldList.length > 0) {
                DeletedIDs = "," + DeletedIDs + ",";
                var filterList = $.grep(oldList, function (item) {
                    return DeletedIDs.indexOf("," + item.ID + ",") <= -1
                });
                oldList = filterList;
            }

            if ((oldList != null && oldList.length > 0) && (newList != null && newList.length > 0)) {
                combineList = oldList.concat(newList);
                //combineList = combineList.getUnique();
            }
            else if ((newList != null && newList.length > 0)) {
                combineList = newList;
            }
            else if ((oldList != null && oldList.length > 0)) {
                combineList = oldList;
            }
            localStorage.removeItem(cache_custlist);
            if (combineList != null) {
                localStorage[cache_custlist] = JSON.stringify(combineList);
            }
            else {
                localStorage[cache_custlist] = [];
            }
        }
        if (isIEBrowser() || cache_isFromiPadAndroid)
            cache_isDBCallOnly = true;
        else
            cache_isDBCallOnly = cache_isLoadCustFromDB;
        //cache_isDBCallOnly = false;

    } catch (e) {
        cache_isDBCallOnly = true;
        InvalidateLocalStorage();
        cusSynInfo.IsMaxQuataReached = true;
        localStorage[cache_cusSynInfo] = JSON.stringify(cusSynInfo);
    }
    return combineList;
}

////prototype for getting unique objects from array list
//Array.prototype.getUnique = function () {
//    a = this.reduce(function (memo, e1) {
//        var matches = memo.filter(function (e2) {
//            return e1.ID == e2.ID
//        })
//        if (matches.length == 0)
//            memo.push(e1)
//        return memo;
//    }, []);
//    return a;
//}

//function to get alphabetical sort array objects
function Sortingalphabetical(a, b) {
    try {
        var A = a.FN.toLowerCase();
        var B = b.FN.toLowerCase();
        if (A < B) {
            return -1;
        } else if (A > B) {
            return 1;
        } else {
            return 0;
        }
    } catch (et) {
        return 0;
    }
}

//function to get last sync date from localstorage
function LastSyncDate() {
    var _LastSyncDate = null;
    if ((typeof localStorage === 'object') && localStorage[cache_cusSynInfo] !== undefined) {
        var cusSynInfo = JSON.parse(localStorage[cache_cusSynInfo]);
        if (cusSynInfo != null && cusSynInfo.synDt !== undefined && cusSynInfo.synDt != null) {
            _LastSyncDate = cusSynInfo.synDt;
        }
    }
    return _LastSyncDate;
}

//function to get max data reached or not from localstorage
function MaxQuataReached() {
    var isMaxQ = false;
    if (cache_isDBCallOnly) {
        isMaxQ = cache_isDBCallOnly;
    }
    else {
        if ((typeof localStorage === 'object') && localStorage[cache_cusSynInfo] !== undefined) {
            var cusSynInfo = JSON.parse(localStorage[cache_cusSynInfo]);
            var curDate = new Date();
            var maxDate = new Date(cusSynInfo.maxDt);
            isMaxQ = (curDate.setHours(0, 0, 0, 0) == maxDate.setHours(0, 0, 0, 0)) ? cusSynInfo.IsMaxQuataReached : isMaxQ;
        }
    }
    return isMaxQ;
}

//function to get last sync cache_BusinessId from localstorage
function lastSyncBusID() {
    var _lastSyncBusID = 0;
    if ((typeof localStorage === 'object') && localStorage[cache_cusSynInfo] !== undefined) {
        var cusSynInfo = JSON.parse(localStorage[cache_cusSynInfo]);
        _lastSyncBusID = cusSynInfo.busID;
    }
    return (_lastSyncBusID == 0) ? parseFloat(cache_BusinessId) : _lastSyncBusID;
}

//function to get information that data got from localstorage or not
function IsFromLocalStorage() {
    return ((typeof localStorage === 'object' && localStorage[cache_custlist] != undefined && MaxQuataReached() == false && lastSyncBusID() == parseFloat(cache_BusinessId)));
}

//function to search customer from list and append it into div
function SearchCustomer(lstCust, tCount) {
    if (cache_IsValidControls == true) {
        if (lstCust != null && lstCust.length > 0) {
            var filterList = lstCust;
            var startIndex = 1;
            var endIndex = cache_pageSize;
            var strText = cache_txtSearchCustomer.val();

            if (strText.length > 0) {
                strText = strText.replace(/\(/g, "").replace(/\)/g, "").replace(/-/g, "").trim();
            }

            var isCustomerRights = GetCachingCustomerRight();//IsControlUnderfined(cache_HasCustomerRight) ? false : cache_HasCustomerRight;
            cache_noOfRecords = lstCust.length;

            if (cache_pageIndex == 0 && (parseInt(filterList.length) > parseInt(cache_pageSize))) {
                filterList = filterList.slice(0, 10);
            }

            if (IsFromLocalStorage()) {
                filterList = $.grep(lstCust, function (item) {
                    return (strText == "" || (item.FN.trim().toLowerCase().indexOf(strText.toLowerCase()) > -1
                                            || (isCustomerRights && (!StringisNullOrUndefineOrBlank(strText)) && (!StringisNullOrUndefineOrBlank(item.C)) && item.C.indexOf(strText) > -1)
                                            || (isCustomerRights && (!StringisNullOrUndefineOrBlank(strText)) && (!StringisNullOrUndefineOrBlank(item.D)) && item.D.indexOf(strText) > -1)
                                            || (isCustomerRights && (!StringisNullOrUndefineOrBlank(strText)) && (!StringisNullOrUndefineOrBlank(item.N)) && item.N.indexOf(strText) > -1)));
                });
                cache_noOfRecords = filterList.length;
                startIndex = ((cache_pageIndex * cache_pageSize) + 1);
                endIndex = ((cache_pageIndex + 1) * cache_pageSize);

            } else {

                cache_noOfRecords = tCount;
                startIndex = 1;
                endIndex = filterList.length;
            }

            if ((cache_noOfRecords > cache_pageSize && cache_noOfRecords < ((cache_pageIndex * cache_pageSize) + 1)) || (cache_noOfRecords > 0 && ((cache_pageIndex * cache_pageSize) + 1) > cache_noOfRecords)) {
                return;
            }

            if (endIndex > cache_noOfRecords) {
                endIndex = cache_noOfRecords;
            }


            var items = [];
            var appendNo = "";
            for (var i = startIndex; i <= endIndex; i++) {
                var singleObj = {};
                singleObj = filterList[i - 1];
                appendNo = "";
                if (isCustomerRights) {
                    // appendNo = (singleObj.C != "") ? singleObj.C : "";
                    //appendNo = (singleObj.C != "") ? singleObj.C : ((singleObj.D != "") ? singleObj.D : singleObj.N != "" ? singleObj.N : "");
                    appendNo = (!StringisNullOrUndefineOrBlank(singleObj.C)) ? singleObj.C : ((!StringisNullOrUndefineOrBlank(singleObj.D)) ? singleObj.D : (!StringisNullOrUndefineOrBlank(singleObj.N)) ? singleObj.N : "");

                    if ((!StringisNullOrUndefineOrBlank(strText)) && (!StringisNullOrUndefineOrBlank(singleObj.C)) && singleObj.C.indexOf(strText) > -1) {
                        appendNo = singleObj.C;
                    } else if ((!StringisNullOrUndefineOrBlank(strText)) && (!StringisNullOrUndefineOrBlank(singleObj.D)) && singleObj.D.indexOf(strText) > -1) {
                        appendNo = singleObj.D;
                    } else if ((!StringisNullOrUndefineOrBlank(strText)) && (!StringisNullOrUndefineOrBlank(singleObj.N)) && singleObj.N.indexOf(strText) > -1) {
                        appendNo = singleObj.N;
                    }
                }
                else {
                    singleObj.C = "";
                    singleObj.D = "";
                    singleObj.N = "";
                }
                singleObj.DName = singleObj.FN + ((!StringisNullOrUndefineOrBlank(appendNo)) ? " (" + appendNo + ")" : "");
                items.push(singleObj);
            }

            cache_pageIndex += 1;

            if (items.length > 0) {
                if (cache_pageIndex == 1) {
                    cache_ulCustomerList.scrollTop(0);
                    cache_ulCustomerList.html("");
                }
                $("#tmplCustomer").tmpl(items).appendTo(cache_ulCustomerList);
                //cache_tmplCustomer.tmpl(items).appendTo(cache_ulCustomerList);

                if (IsFromLocalStorage()) {
                    cache_ctrlendIndex.html(endIndex);
                } else {
                    cache_ctrlendIndex.html((cache_pageSize * cache_pageIndex) > cache_noOfRecords ? cache_noOfRecords : (cache_pageSize * cache_pageIndex));
                }

                cache_ctrltotalCout.html(cache_noOfRecords);
                cache_pgDiv.show();
                cache_pgNoMatchDiv.hide();
                //$("#cache_pgDiv").show();
                //$("#cache_pgNoMatchDiv").hide();
                //Added By Tejas Bhalani 08-03-2017
                //when click on paging at that time record go dynamically up
                //if (cache_pageIndex != 1 && cache_ulCustomerList.find(" li." + cache_liSelectedClassName + "").data("fullname") === undefined && (cache_glbisScrollTop !== undefined && cache_glbisScrollTop)) {
                if (cache_pageIndex != 1 && (StringisNullOrUndefineOrBlank(cache_ulCustomerList.find(" li." + cache_liSelectedClassName + "").data("fullname")))
                    && ((!StringisNullOrUndefineOrBlank(cache_glbisScrollTop)) && cache_glbisScrollTop)) {
                    var index = ((cache_pageIndex - 1) * cache_pageSize) / 2;
                    cache_ulCustomerList.scrollTop(0);
                    cache_ulCustomerList.scrollTop(cache_ulCustomerList.find(" li:nth-child(" + index + ")").position().top);
                    cache_glbisScrollTop = false;
                }

            } else {
                CustomersNoRecordFound();
            }
        } else {
            CustomersNoRecordFound();
        }
    }
}

//function to set no customer found 
function CustomersNoRecordFound() {

    if (cache_IsValidControls == true) {
        cache_ulCustomerList.html("<li id='liNoCust'>No Customer Found</li>");
        cache_pgDiv.hide();
        cache_pgNoMatchDiv.show();
    }
}
//delay method for timer
var DelayMethodCall = (function () {

    var timer = 0;
    return function (callback, ms) {
        clearTimeout(timer);
        timer = setTimeout(callback, ms);
    };
})();
//function to load new customers from database or locatorage
function LoadMoreCustomers(isScrollTop) {

    if (isScrollTop !== undefined) {
        cache_glbisScrollTop = isScrollTop;
    }
    //console.log(3)
    var ms = MaxQuataReached() ? 50 : 0;
    DelayMethodCall(function () {
        if (IsFromLocalStorage()) {
            if ((typeof (cache_glbData) !== "undefined" && cache_glbData != null && cache_glbData.length > 0 != null)) {

                try {
                    cache_glbData = cache_glbData.sort(Sortingalphabetical);
                } catch (g) { }

                SearchCustomer(cache_glbData);
            } else {
                GetCustomers();
            }
        } else {
            GetCustomers();
        }
    }, ms);
}

//function to select customer from customer list dropdown
function selectedCustomer(event) {

    if (cache_IsValidControls == true) {
        if ((!StringisNullOrUndefineOrBlank(event))) {
            var li = $(event);
            cache_lastSearchText = li.data("fullname");
            cache_txtSearchCustomer.val(li.data("fullname"));
            cache_divCustomers.slideUp(250, function () {
                cache_ulCustomerList.unbind('scroll');

            });
            //if (cache_OldSelectctedUserId != li.data("custid"))
            //if (!cache_txtSearchCustomer[0].id.includes("AddEdit")) {
            if (glbPageName != cache_PageType["addeditcustomer"]) {
                cache_OldSelectctedUserId = li.data("custid")
                CachingSelectedCustomer(event);
            }
            else {
                cache_OldSelectctedUserId = li.data("custid")
                CachingSelectedCustomerAddEdit(event);
            }

        }
    }
}

//function to get information about need to sync data again or not
function NeedToSync() {

    var isNeedSync = true;
    if (localStorage[cache_cusSynInfo] !== undefined) {
        var cusSynInfo = JSON.parse(localStorage[cache_cusSynInfo]);
        if (cusSynInfo.IsMaxQuataReached) {
            isNeedSync = true;
        }
        else {
            var lastDate = new Date(cusSynInfo.lstDt);
            var curDate = new Date();
            if (curDate < lastDate) {
                curDate.setDate(curDate.getDate() + 1);
            }
            var diff = curDate - lastDate;
            var msec = diff;
            var mm = Math.floor(msec / 1000 / 60);
            isNeedSync = (mm > cache_syncDuration);
        }
    }
    else {
        isNeedSync = true;
    }
    return isNeedSync;
}


//function to get that this is ie browser or not
function isIEBrowser() {
    var isIEVersion = false;
    if (!!navigator.userAgent.match(/Trident.*rv\:11\./))  // If Internet Explorer, return version number
    {
        isIEVersion = true;
    }
    return isIEVersion;
}

//function to get all customers first time when customer login/change business
function GetFirstTimeAllCustomers() {
    //console.log('GetFirstTimeAllCustomers')

    if (cache_isLoadCustFromDB == false) {
        var dataicache_BusinessId = IsControlUnderfined(cache_BusinessId) ? 0 : cache_BusinessId;
        var datacache_HasCustomerRights = GetCachingCustomerRight();//IsControlUnderfined(cache_HasCustomerRight) ? false : cache_HasCustomerRight;;
        var datastrText = "";
        var datacache_pageIndex = 1;
        var datacache_pageSize = 1000000;
        var dataLastSyncDate = null;
        var dataIsForLocalStorage = true;
        var vgCustomers = new vagaro.ajax();
        vgCustomers.datamodel.Token = 'GetAllCustomers';
        vgCustomers.datamodel.callback = GetFirstTimeAllCustomers_Success;
        vgCustomers.datamodel.data = [dataicache_BusinessId, datastrText, datacache_HasCustomerRights, datacache_pageIndex, datacache_pageSize, dataLastSyncDate, dataIsForLocalStorage];
        vgCustomers.datamodel.Error = GetFirstTimeAllCustomers_Fail
        vgCustomers.Post();
    }
}

//getcustomer success event
function GetFirstTimeAllCustomers_Success(obj) {
    //console.log('GetFirstTimeAllCustomers_Success');
    if (obj != null) {
        cache_isFirstTime = true;
        StoreLocalStorage(obj.objUsersList, obj.lastCalledTime, obj.deletedIDs);
    }
}

//get customers fail event
function GetFirstTimeAllCustomers_Fail() {
    //console.log('GetFirstTimeAllCustomers_Fail');
}
//SelectCustomer On Enter key press
function SelectCustomerOnEnter() {

    if (cache_IsValidControls == true) {
        if (cache_ulCustomerList.find(' > li.' + cache_liSelectedClassName + '').length > 0 && cache_ulCustomerList.find(' > li.' + cache_liSelectedClassName + '').data("custid") != null)
            selectedCustomer(cache_ulCustomerList.find(' > li.' + cache_liSelectedClassName + ''));
        cache_txtSearchCustomer.blur();//For focus from textbox
    }
}
//Get control from  id
function GetClientID(asp_net_id) {
    return $("[id$=" + asp_net_id + "]");//.attr("id");
};
//check Is Valid Controls or not
function IsValidControls(cntrl) {
    try {

        if (IsControlUnderfined(cache_divCustomers))
            return false;
        else if (IsControlUnderfined(cache_ulCustomerList))
            return false;
        else if (IsControlUnderfined(cntrl.cache_divCustomersData))
            return false;
        else if (IsControlUnderfined(cntrl.ulCustomerList))
            return false;
        else if (IsControlUnderfined(cntrl.cache_txtSearchCustomer))
            return false;
        else if (IsControlUnderfined(cntrl.cache_ctrltotalCout))
            return false;
        else if (IsControlUnderfined(cntrl.cache_ctrlendIndex))
            return false;
        else if (IsControlUnderfined(cntrl.cache_liSelectedClassName))
            return false;
        else if (IsControlUnderfined(cntrl.cache_pgNoMatchDiv))
            return false;
        else if (IsControlUnderfined(cntrl.cache_pgDiv))
            return false;
        else if (IsControlUnderfined(cntrl.cache_isFromiPadAndroid))
            return false;
        else if (IsControlUnderfined(cntrl.cache_isLoadCustFromDB))
            return false;
        else if (IsControlUnderfined(cntrl.cache_syncDuration))
            return false;
        else if (IsControlUnderfined(cntrl.cache_divtxtCustomers))
            return false;
        else
            return true;
    }
    catch (a) {
        console.log("Error from IsValidControls function:> " + a)
        return false;
    }
}
//check control is defined or not
function StringisNullOrUndefineOrBlank(data) {
    if (typeof (data) == "undefined" || data == undefined || data == "" || data == null) {
        return true;
    }
    return false;

}

///https://function for Is Control Underfined or not
function IsControlUnderfined(data) {
    if (data !== undefined) {
        if (typeof (data) == "undefined" || data == undefined || data == "" || data == null) {
            return true;
        }
        return false;
    }
    else
        return false;
}
function CloseCachingCustomerDropdown() {
    if (cache_divCustomers.is(":visible")) {
        cache_divCustomers.slideUp(250, function () {
            cache_ulCustomerList.unbind('scroll');
            cache_liSelected = null;
            cache_txtSearchCustomer.blur();
        });
    }
}
// end new search customer from broswer LocalStorage block 


function SetErrorDisplayMessage(strResult, strMessage, strPageID) {
    if (strResult == "1") {
        ShowHideDoneMessage(strMessage, strPageID);
    }
    else if (strResult == "0") {
        ShowHideFailedMessage(strMessage);
    } else if (strResult == "2") {
        ShowHideWarningMessage(strMessage);
    }
}
function iOSversion() {
    if (/iP(hone|od|ad)/.test(navigator.platform)) {
        // supports iOS 2.0 and later: <http://bit.ly/TJjs1V>
        var v = (navigator.appVersion).match(/OS (\d+)_(\d+)_?(\d+)?/);
        return [parseInt(v[1], 10), parseInt(v[2], 10), parseInt(v[3] || 0, 10)];
    }
}

ver = iOSversion();


function ShowHideDoneMessage(strMessage, PageID) {
    //$(".custom-form-done").text(strMessage);
    //$(".custom-form-done").slideDown('slow');
    //$(".custom-form-done").delay(5000).slideUp('slow');
    //$(".custom-form-fail").hide();
    $('.banner-success .text-block-28').html(strMessage);
    var ix = Webflow.require('ix');
    var $target = $('.banner-success');
    var trigger;

    var sTimeSec = setDisplayMessageTime(strMessage);

    if (typeof PageID !== 'undefined' && PageID != null && PageID != '') {
        GetOrUpdateBusinessLastModifiedDetails(PageID, false);
    }


    if (typeof ver != "undefined") {
        if (ver[0] <= 8) {
            trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "-webkit-flex", "transition": "transform 200ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        } else {
            trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 200ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        }
    } else {
        trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 200ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
        ix.run(trigger, $target);
    }

}


function ShowHideFailedMessage(strMessage) {
    //$(".custom-form-fail").text(strMessage);   
    //$(".custom-form-fail").slideDown('slow');
    //$(".custom-form-fail").delay(5000).slideUp('slow');
    //$(".custom-form-done").hide();
    $('.banner-fail .text-block-28').html(strMessage);
    var ix = Webflow.require('ix');
    var $target = $('.banner-fail');
    var trigger;
    var sTimeSec = setDisplayMessageTime(strMessage);

    if (typeof ver != "undefined") {
        if (ver[0] <= 9) {
            var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "-webkit-flex", "transition": "transform 200ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        } else {
            var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 200ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        }
    } else {
        var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 200ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 200 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
        ix.run(trigger, $target);
    }
}

function ShowHideWarningMessage(strMessage) {
    //$(".custom-form-fail").text(strMessage);   
    //$(".custom-form-fail").slideDown('slow');
    //$(".custom-form-fail").delay(5000).slideUp('slow');
    //$(".custom-form-done").hide();
    $('.banner-warning .text-block-28').html(strMessage);
    var ix = Webflow.require('ix');
    var $target = $('.banner-warning');
    var trigger;
    var sTimeSec = setDisplayMessageTime(strMessage);

    if (typeof ver != "undefined") {
        if (ver[0] <= 9) {
            var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "-webkit-flex", "transition": "transform 300ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 300 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        } else {
            var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 300ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 300 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        }
    } else {
        var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 300ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": sTimeSec }, { "transition": "transform 300 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
        ix.run(trigger, $target);
    }
}

function ShowHideWarningMessageForPopup(strMessage) {
    //$(".custom-form-fail").text(strMessage);   
    //$(".custom-form-fail").slideDown('slow');
    //$(".custom-form-fail").delay(5000).slideUp('slow');
    //$(".custom-form-done").hide();
    $('.banner-warning-popup .text-block-28').html(strMessage);
    var ix = Webflow.require('ix');
    var $target = $('.banner-warning-popup');
    var trigger;
    if (typeof ver != "undefined") {
        if (ver[0] <= 9) {
            var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "-webkit-flex", "transition": "transform 300ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 300 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        } else {
            var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 300ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 300 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
            ix.run(trigger, $target);
        }
    } else {
        var trigger = { "type": "click", "preserve3d": true, "stepsA": [{ "display": "flex", "transition": "transform 300ms ease 0", "x": "0px", "y": "50px", "z": "0px" }, { "wait": "3s" }, { "transition": "transform 300 ease 0", "x": "0px", "y": "0px", "z": "0px" }, { "display": "none" }], "stepsB": [] };
        ix.run(trigger, $target);
    }
}

function setDisplayMessageTime(strMessage) {
    var sTimesec = "2s"
    if (strMessage != '' && strMessage.length > 0) {
        if (strMessage.length < 50)
            sTimesec = "2s"
        else if (strMessage.length < 100)
            sTimesec = "3s"
        else if (strMessage.length < 200)
            sTimesec = "4s"
        else if (strMessage.length > 200)
            sTimesec = "7s"
    }
    return sTimesec;
}

function setkeepAlive() {
    (function (qualifiedDomainName) {
        var i = document.createElement('iframe');
        i.style.display = 'none';
        i.onload = function () { i.parentNode.removeChild(i); };
        try {
            i.src = qualifiedDomainName + '/keepalive.aspx?id=' + (Math.random() + 1).toString(36).substring(2);
        }
        catch (e) {
            i.src = qualifiedDomainName + '/keepalive.aspx?id=w5a2g';
        }
        document.body.appendChild(i);
    })(location.protocol + '//' + location.hostname + (location.port ? ':' + location.port : ''));
}
/// Get or Insert/Update Business Last Modification Setting page details
function GetOrUpdateBusinessLastModifiedDetails(PageID, Status) {

    var vgLastModified = new vagaro.ajax();
    vgLastModified.datamodel.Token = 'BusinessLastModifiedDetails';
    vgLastModified.datamodel.callback = GetBusinessLastModified_Success;
    vgLastModified.datamodel.data = [PageID, Status];
    vgLastModified.Post();
}
function GetBusinessLastModified_Success(objModifiedDetails) {
    var strDetails = '';
    if (objModifiedDetails != null) {
        if (objModifiedDetails.LastName == null)
            strDetails = "Last Modified: " + objModifiedDetails.FirstName;
        else if (objModifiedDetails.FirstName == null)
            strDetails = "Last Modified: " + objModifiedDetails.LastName;
        else
            strDetails = "Last Modified: " + objModifiedDetails.FirstName + " " + objModifiedDetails.LastName;
        strDetails += " - " + objModifiedDetails.FormatedModifiedDate;
        $("#dvLastModified" + objModifiedDetails.PageID).html(strDetails);
    }
}
//Project:- Vagaro Forms
//Created By:- Ashish M.
//Reason:- To call export API for generate PDF file based on URL
function commonExportToPDF(_requestUrl, _requestHtml, isPrint) {
    if (typeof (_requestHtml) == 'undefined' || _requestHtml == '' || _requestHtml == null) {
        _requestHtml = "";
    }
    if (typeof (isPrint) == "undefined") {
        isPrint = false;
    }
    frm.displayLoading();
    //var _filedate = moment().format("YYYYMMDDHHmmSS");
    //var _exportFileName = _fileTitle.replace(/\s/g, '') + "_" + _filedate + ".pdf";
    var _baseURL = location.protocol + '//' + location.hostname + (location.port ? ':' + location.port : '');
    CallAjax("common/ExportPDF", JSON.stringify({ PaperType: "A4", Url: _requestUrl, Html: _requestHtml, OutPutFileNamePrefix: "Form", IsPrint:isPrint }), function (res)
    {
        if (res != "" && res != null) {
            if (typeof (isPrint) != 'undefined' && isPrint == true) {
                printPdf(res);
            }
            else {

                if (typeof _formSummary.FormType != 'undefined') {
                    window.location.href = _baseURL + "/common/DownloadFileFromURL?" + "_url=" + res + "&_formType=" + _formSummary.FormType;
                }
                else {
                    if (typeof $("#hdnFormType").val() != 'undefined') {
                        window.location.href = _baseURL + "/common/DownloadFileFromURL?" + "_url=" + res + "&_formType=" + $("#hdnFormType").val();
                    }
                    else {
                        window.location.href = _baseURL + "/common/DownloadFileFromURL?" + "_url=" + res + "&_formType=" + _formSummary.FormType;
                    }
                }
                
            }
        }        
        frm.hideLoading();
    }, function (res) {        
        frm.hideLoading();

        }, false, true);    
    //window.location.href = _baseURL + "/common/ExportPDF?" + "_url=" + _requestUrl + "&_exportFileName=" + _exportFileName;
}

function printPdf(response) {

    var binary_string = window.atob(response)
    var len = response.length;
    var bytes = new Uint8Array(len);
    for (var i = 0; i < len; i++) {
        bytes[i] = binary_string.charCodeAt(i);
    }

    const pdfBlob = new Blob([bytes.buffer], { type: "application/pdf" });
    const url = URL.createObjectURL(pdfBlob);    
    printJS(url);
}

//Project:- Vagaro drive Forms File Upload 
//Created By:- Nishant Patel
//Reason:- Get Base64 of image and pdf url for download all add by Nishant Patel : 03-10-2019 : Upload Forms Files
function _toConvertBase64(url, callback) {
    var xhr = new XMLHttpRequest();
    xhr.onload = function () {
        var reader = new FileReader();
        reader.onloadend = function () {
            callback(reader.result);
        }
        reader.readAsDataURL(xhr.response);
    };
    xhr.open('GET', url);
    xhr.setRequestHeader('Access-Control-Allow-Origin', '*');
    xhr.responseType = 'blob';
    xhr.send();
}
//Project:- Vagaro drive Forms File Upload 
//Created By:- Nishant Patel
//Reason:- Add to zip for prommise to wait for download all add by Nishant Patel : 16-10-2019 : Upload Forms Files
function _addBase64ToZip(zip, imgLink) {
    var deferred = $.Deferred();

    _toConvertBase64(imgLink, function (dataBase64) {

        var strImage = "";
        if (typeof dataBase64 != "undefined" && dataBase64 != "" && dataBase64 != null && !dataBase64.includes("application/xml")) {
            strImage = dataBase64.split(';base64,').pop();
            zip.file(imgLink.substring(imgLink.lastIndexOf('/') + 1), strImage, { base64: true });           
        }
        deferred.resolve(zip);
    });
    return deferred;
}

function FormatPhoneByCountry(phonenumber, countryID, isUkNewFormat = false) {
    try {
        if (phonenumber != null && typeof (phonenumber) != "undefined" && phonenumber.length != 0 && phonenumber.length > 8) {
            var numbers = phonenumber.replace(/\D/g, ''),
                FormatPhone = { 0: '(', 3: ') ', 6: '-' };//US

            if (typeof (countryID) != "undefined" && countryID != null && countryID * 1 > 0) {
                if (countryID == 2 && numbers.length == 10) {
                    numbers = "0" + numbers;
                }
                else if (countryID == 4 && numbers.length == 9) {
                    numbers = "0" + numbers;
                }
            }
            if (typeof (countryID) != "undefined" && countryID != null && countryID * 1 > 0) {
                if (countryID == 2) { //UK
                    if (isUkNewFormat == true) {
                        if (numbers.substring(0, 2) == "01") {
                            FormatPhone = { 5: ' ' };
                        }
                        else if (numbers.substring(0, 2) == "02") {
                            FormatPhone = { 3: ' ', 7: ' ' };
                        }
                        else if (numbers.substring(0, 2) == "07") {
                            FormatPhone = { 5: ' ', 8: ' ' };
                        }
                        else {
                            FormatPhone = { 3: ' ', 7: ' ' };
                        }
                    }
                    else {
                        FormatPhone = { 3: ' ', 7: ' ' };
                    }
                }
                else if (countryID == 3) { // Canada
                    FormatPhone = { 3: '-', 6: '-' };
                }
                else if (countryID == 4) { // Australia
                    FormatPhone = { 0: '(', 2: ') ', 6: ' ' };
                }
            }
            phonenumber = '';
            for (var i = 0; i < numbers.length; i++) {
                phonenumber += (FormatPhone[i] || '') + numbers[i];
            }
        }
        return phonenumber;
    } catch (e) {
        return phonenumber;
    }
}

function is_numeric(str) {
    return /^\d+$/.test(str);
}

function Arrcontains (a, obj) {
    for (var i = 0; i < a.length; i++) {
        if (a[i] === obj) {
            return true;
        }
    }
    return false;
};
! function (e, t, n) {
    "use strict";
    ! function o(e, t, n) {
        function a(s, l) {
            if (!t[s]) {
                if (!e[s]) {
                    var i = "function" == typeof require && require;
                    if (!l && i) return i(s, !0);
                    if (r) return r(s, !0);
                    var u = new Error("Cannot find module '" + s + "'");
                    throw u.code = "MODULE_NOT_FOUND", u
                }
                var c = t[s] = {
                    exports: {}
                };
                e[s][0].call(c.exports, function (t) {
                    var n = e[s][1][t];
                    return a(n ? n : t)
                }, c, c.exports, o, e, t, n)
            }
            return t[s].exports
        }
        for (var r = "function" == typeof require && require, s = 0; s < n.length; s++) a(n[s]);
        return a
    }({
        1: [function (o, a, r) {
            var s = function (e) {
                return e && e.__esModule ? e : {
                    "default": e
                }
            };
            Object.defineProperty(r, "__esModule", {
                value: !0
            });
            var l, i, u, c, d = o("./modules/handle-dom"),
                f = o("./modules/utils"),
                p = o("./modules/handle-swal-dom"),
                m = o("./modules/handle-click"),
                v = o("./modules/handle-key"),
                y = s(v),
                h = o("./modules/default-params"),
                b = s(h),
                g = o("./modules/set-params"),
                w = s(g);
            r["default"] = u = c = function () {
                function o(e) {
                    var t = a;
                    return t[e] === n ? b["default"][e] : t[e]
                }
                var a = arguments[0];
                if (d.addClass(t.body, "stop-scrolling"), p.resetInput(), a === n) return f.logStr("SweetAlert expects at least 1 attribute!"), !1;
                var r = f.extend({}, b["default"]);
                switch (typeof a) {
                    case "string":
                        r.title = a, r.text = arguments[1] || "", r.type = arguments[2] || "";
                        break;
                    case "object":
                        if (a.title === n) return f.logStr('Missing "title" argument!'), !1;
                        r.title = a.title;
                        for (var s in b["default"]) r[s] = o(s);
                        r.confirmButtonText = r.showCancelButton ? "Confirm" : b["default"].confirmButtonText, r.confirmButtonText = o("confirmButtonText"), r.doneFunction = arguments[1] || null;
                        break;
                    default:
                        return f.logStr('Unexpected type of argument! Expected "string" or "object", got ' + typeof a), !1
                }
                w["default"](r), p.fixVerticalPosition(), p.openModal(arguments[1]);
                for (var u = p.getModal(), v = u.querySelectorAll("button"), h = ["onclick", "onmouseover", "onmouseout", "onmousedown", "onmouseup", "onfocus"], g = function (e) {
                        return m.handleButton(e, r, u)
                }, C = 0; C < v.length; C++)
                    for (var S = 0; S < h.length; S++) {
                        var x = h[S];
                        v[C][x] = g
                    }
                p.getOverlay().onclick = g, l = e.onkeydown;
                var k = function (e) {
                    return y["default"](e, r, u)
                };
                e.onkeydown = k, e.onfocus = function () {
                    setTimeout(function () {
                        i !== n && (i.focus(), i = n)
                    }, 0)
                }, c.enableButtons()
            }, u.setDefaults = c.setDefaults = function (e) {
                if (!e) throw new Error("userParams is required");
                if ("object" != typeof e) throw new Error("userParams has to be a object");
                f.extend(b["default"], e)
            }, u.close = c.close = function () {
                $(".gencutom-title").html("Alert");
                var o = p.getModal();
                d.fadeOut(p.getOverlay(), 5), d.fadeOut(o, 5), d.removeClass(o, "showSweetAlert"), d.addClass(o, "hideSweetAlert"), d.removeClass(o, "visible");
                var a = o.querySelector(".sa-icon.sa-success");
                d.removeClass(a, "animate"), d.removeClass(a.querySelector(".sa-tip"), "animateSuccessTip"), d.removeClass(a.querySelector(".sa-long"), "animateSuccessLong");
                var r = o.querySelector(".sa-icon.sa-error");
                d.removeClass(r, "animateErrorIcon"), d.removeClass(r.querySelector(".sa-x-mark"), "animateXMark");
                var s = o.querySelector(".sa-icon.sa-warning");
                return d.removeClass(s, "pulseWarning"), d.removeClass(s.querySelector(".sa-body"), "pulseWarningIns"), d.removeClass(s.querySelector(".sa-dot"), "pulseWarningIns"), setTimeout(function () {
                    var e = o.getAttribute("data-custom-class");
                    d.removeClass(o, e)
                }, 300), d.removeClass(t.body, "stop-scrolling"), e.onkeydown = l, e.previousActiveElement && e.previousActiveElement.focus(), i = n, clearTimeout(o.timeout), !0
            }, u.showInputError = c.showInputError = function (e) {
                var t = p.getModal(),
                    n = t.querySelector(".sa-input-error");
                d.addClass(n, "show");
                var o = t.querySelector(".sa-error-container");
                d.addClass(o, "show"), o.querySelector("p").innerHTML = e, setTimeout(function () {
                    u.enableButtons()
                }, 1), t.querySelector("input").focus()
            }, u.resetInputError = c.resetInputError = function (e) {
                if (e && 13 === e.keyCode) return !1;
                var t = p.getModal(),
                    n = t.querySelector(".sa-input-error");
                d.removeClass(n, "show");
                var o = t.querySelector(".sa-error-container");
                d.removeClass(o, "show")
            }, u.disableButtons = c.disableButtons = function () {
                var e = p.getModal(),
                    t = e.querySelector("button.confirm"),
                    n = e.querySelector("button.cancel");
                t.disabled = !0, n.disabled = !0
            }, u.enableButtons = c.enableButtons = function () {
                var e = p.getModal(),
                    t = e.querySelector("button.confirm"),
                    n = e.querySelector("button.cancel");
                t.disabled = !1, n.disabled = !1
            }, "undefined" != typeof e ? e.sweetAlert = e.swal = u : f.logStr("SweetAlert is a frontend module!"), a.exports = r["default"]
        }, {
            "./modules/default-params": 2,
            "./modules/handle-click": 3,
            "./modules/handle-dom": 4,
            "./modules/handle-key": 5,
            "./modules/handle-swal-dom": 6,
            "./modules/set-params": 8,
            "./modules/utils": 9
        }],
        2: [function (e, t, n) {
            Object.defineProperty(n, "__esModule", {
                value: !0
            });
            var o = {
                title: "",
                text: "",
                type: null,
                allowOutsideClick: !1,
                showConfirmButton: !0,
                showCancelButton: !1,
                closeOnConfirm: !0,
                closeOnCancel: !0,
                confirmButtonText: "OK",
                confirmButtonColor: "#eb6663",
                cancelButtonText: "Cancel",
                imageUrl: null,
                imageSize: null,
                timer: null,
                customClass: "",
                html: !1,
                animation: !0,
                allowEscapeKey: !0,
                inputType: "text",
                inputPlaceholder: "",
                inputValue: "",
                showLoaderOnConfirm: !1
            };
            n["default"] = o, t.exports = n["default"]
        }, {}],
        3: [function (t, n, o) {
            Object.defineProperty(o, "__esModule", {
                value: !0
            });
            var a = t("./utils"),
                r = (t("./handle-swal-dom"), t("./handle-dom")),
                s = function (t, n, o) {
                    function s(e) {
                        m && n.confirmButtonColor && (p.style.backgroundColor = e)
                    }
                    var u, c, d, f = t || e.event,
                        p = f.target || f.srcElement,
                        m = -1 !== p.className.indexOf("confirm"),
                        v = -1 !== p.className.indexOf("sweet-overlay"),
                        y = r.hasClass(o, "visible"),
                        h = n.doneFunction && "true" === o.getAttribute("data-has-done-function");
                    switch (m && n.confirmButtonColor && (u = n.confirmButtonColor, c = a.colorLuminance(u, -.04), d = a.colorLuminance(u, -.14)), f.type) {
                        case "mouseover":
                            s(c);
                            break;
                        case "mouseout":
                            s(u);
                            break;
                        case "mousedown":
                            s(d);
                            break;
                        case "mouseup":
                            s(c);
                            break;
                        case "focus":
                            var b = o.querySelector("button.confirm"),
                                g = o.querySelector("button.cancel");
                            m ? g.style.boxShadow = "none" : b.style.boxShadow = "none";
                            break;
                        case "click":
                            var w = o === p,
                                C = r.isDescendant(o, p);
                            if (!w && !C && y && !n.allowOutsideClick) break;
                            m && h && y ? l(o, n) : h && y || v ? i(o, n) : r.isDescendant(o, p) && "BUTTON" === p.tagName && sweetAlert.close()
                    }
                },
                l = function (e, t) {
                    var n = !0;
                    r.hasClass(e, "show-input") && (n = e.querySelector("input").value, n || (n = "")), t.doneFunction(n), t.closeOnConfirm && sweetAlert.close(), t.showLoaderOnConfirm && sweetAlert.disableButtons()
                },
                i = function (e, t) {
                    var n = String(t.doneFunction).replace(/\s/g, ""),
                        o = "function(" === n.substring(0, 9) && ")" !== n.substring(9, 10);
                    o && t.doneFunction(!1), t.closeOnCancel && sweetAlert.close()
                };
            o["default"] = {
                handleButton: s,
                handleConfirm: l,
                handleCancel: i
            }, n.exports = o["default"]
        }, {
            "./handle-dom": 4,
            "./handle-swal-dom": 6,
            "./utils": 9
        }],
        4: [function (n, o, a) {
            Object.defineProperty(a, "__esModule", {
                value: !0
            });
            var r = function (e, t) {
                return new RegExp(" " + t + " ").test(" " + e.className + " ")
            },
                s = function (e, t) {
                    r(e, t) || (e.className += " " + t)
                },
                l = function (e, t) {
                    var n = " " + e.className.replace(/[\t\r\n]/g, " ") + " ";
                    if (r(e, t)) {
                        for (; n.indexOf(" " + t + " ") >= 0;) n = n.replace(" " + t + " ", " ");
                        e.className = n.replace(/^\s+|\s+$/g, "")
                    }
                },
                i = function (e) {
                    var n = t.createElement("div");
                    return n.appendChild(t.createTextNode(e)), n.innerHTML
                },
                u = function (e) {
                    e.style.opacity = "", e.style.display = "block"
                },
                c = function (e) {
                    if (e && !e.length) return u(e);
                    for (var t = 0; t < e.length; ++t) u(e[t])
                },
                d = function (e) {
                    e.style.opacity = "", e.style.display = "none"
                },
                f = function (e) {
                    if (e && !e.length) return d(e);
                    for (var t = 0; t < e.length; ++t) d(e[t])
                },
                p = function (e, t) {
                    for (var n = t.parentNode; null !== n;) {
                        if (n === e) return !0;
                        n = n.parentNode
                    }
                    return !1
                },
                m = function (e) {
                    e.style.left = "-9999px", e.style.display = "block";
                    var t, n = e.clientHeight;
                    return t = "undefined" != typeof getComputedStyle ? parseInt(getComputedStyle(e).getPropertyValue("padding-top"), 10) : parseInt(e.currentStyle.padding), e.style.left = "", e.style.display = "none", "-" + parseInt((n + t) / 2) + "px"
                },
                v = function (e, t) {
                    if (+e.style.opacity < 1) {
                        t = t || 16, e.style.opacity = 0, e.style.display = "block";
                        var n = +new Date,
                            o = function (e) {
                                function t() {
                                    return e.apply(this, arguments)
                                }
                                return t.toString = function () {
                                    return e.toString()
                                }, t
                            }(function () {
                                e.style.opacity = +e.style.opacity + (new Date - n) / 100, n = +new Date, +e.style.opacity < 1 && setTimeout(o, t)
                            });
                        o()
                    }
                    e.style.display = "block"
                },
                y = function (e, t) {
                    t = t || 16, e.style.opacity = 1;
                    var n = +new Date,
                        o = function (e) {
                            function t() {
                                return e.apply(this, arguments)
                            }
                            return t.toString = function () {
                                return e.toString()
                            }, t
                        }(function () {
                            e.style.opacity = +e.style.opacity - (new Date - n) / 100, n = +new Date, +e.style.opacity > 0 ? setTimeout(o, t) : e.style.display = "none"
                        });
                    o()
                },
                h = function (n) {
                    if ("function" == typeof MouseEvent) {
                        var o = new MouseEvent("click", {
                            view: e,
                            bubbles: !1,
                            cancelable: !0
                        });
                        n.dispatchEvent(o)
                    } else if (t.createEvent) {
                        var a = t.createEvent("MouseEvents");
                        a.initEvent("click", !1, !1), n.dispatchEvent(a)
                    } else t.createEventObject ? n.fireEvent("onclick") : "function" == typeof n.onclick && n.onclick()
                },
                b = function (t) {
                    "function" == typeof t.stopPropagation ? (t.stopPropagation(), t.preventDefault()) : e.event && e.event.hasOwnProperty("cancelBubble") && (e.event.cancelBubble = !0)
                };
            a.hasClass = r, a.addClass = s, a.removeClass = l, a.escapeHtml = i, a._show = u, a.show = c, a._hide = d, a.hide = f, a.isDescendant = p, a.getTopMargin = m, a.fadeIn = v, a.fadeOut = y, a.fireClick = h, a.stopEventPropagation = b
        }, {}],
        5: [function (t, o, a) {
            Object.defineProperty(a, "__esModule", {
                value: !0
            });
            var r = t("./handle-dom"),
                s = t("./handle-swal-dom"),
                l = function (t, o, a) {
                    var l = t || e.event,
                        i = l.keyCode || l.which,
                        u = a.querySelector("button.confirm"),
                        c = a.querySelector("button.cancel"),
                        d = a.querySelectorAll("button[tabindex]");
                    if (-1 !== [9, 13, 32, 27].indexOf(i)) {
                        for (var f = l.target || l.srcElement, p = -1, m = 0; m < d.length; m++)
                            if (f === d[m]) {
                                p = m;
                                break
                            }
                        9 === i ? (f = -1 === p ? u : p === d.length - 1 ? d[0] : d[p + 1], r.stopEventPropagation(l), f.focus(), o.confirmButtonColor && s.setFocusStyle(f, o.confirmButtonColor)) : 13 === i ? ("INPUT" === f.tagName && (f = u, u.focus()), f = -1 === p ? u : n) : 27 === i && o.allowEscapeKey === !0 ? (f = c, r.fireClick(f, l)) : f = n
                    }
                };
            a["default"] = l, o.exports = a["default"]
        }, {
            "./handle-dom": 4,
            "./handle-swal-dom": 6
        }],
        6: [function (n, o, a) {
            var r = function (e) {
                return e && e.__esModule ? e : {
                    "default": e
                }
            };
            Object.defineProperty(a, "__esModule", {
                value: !0
            });
            var s = n("./utils"),
                l = n("./handle-dom"),
                i = n("./default-params"),
                u = r(i),
                c = n("./injected-html"),
                d = r(c),
                f = ".sweet-alert",
                p = ".sweet-overlay",
                m = function () {
                    var e = t.createElement("div");
                    for (e.innerHTML = d["default"]; e.firstChild;) t.body.appendChild(e.firstChild)
                },
                v = function (e) {
                    function t() {
                        return e.apply(this, arguments)
                    }
                    return t.toString = function () {
                        return e.toString()
                    }, t
                }(function () {
                    var e = t.querySelector(f);
                    return e || (m(), e = v()), e
                }),
                y = function () {
                    var e = v();
                    return e ? e.querySelector("input") : void 0
                },
                h = function () {
                    return t.querySelector(p)
                },
                b = function (e, t) {
                    var n = s.hexToRgb(t);
                    e.style.boxShadow = "0 0 2px rgba(" + n + ", 0.8), inset 0 0 0 1px rgba(0, 0, 0, 0.05)"
                },
                g = function (n) {
                    var o = v();
                    l.fadeIn(h(), 10), l.show(o), l.addClass(o, "showSweetAlert"), l.removeClass(o, "hideSweetAlert"), e.previousActiveElement = t.activeElement;
                    var a = o.querySelector("button.confirm");
                    a.focus(), setTimeout(function () {
                        l.addClass(o, "visible")
                    }, 500);
                    var r = o.getAttribute("data-timer");
                    if ("null" !== r && "" !== r) {
                        var s = n;
                        o.timeout = setTimeout(function () {
                            var e = (s || null) && "true" === o.getAttribute("data-has-done-function");
                            e ? s(null) : sweetAlert.close()
                        }, r)
                    }
                },
                w = function () {
                    var e = v(),
                        t = y();
                    l.removeClass(e, "show-input"), t.value = u["default"].inputValue, t.setAttribute("type", u["default"].inputType), t.setAttribute("placeholder", u["default"].inputPlaceholder), C()
                },
                C = function (e) {
                    if (e && 13 === e.keyCode) return !1;
                    var t = v(),
                        n = t.querySelector(".sa-input-error");
                    l.removeClass(n, "show");
                    var o = t.querySelector(".sa-error-container");
                    l.removeClass(o, "show")
                },
                S = function () {
                    var e = v();
                    e.style.marginTop = l.getTopMargin(v())
                };
            a.sweetAlertInitialize = m, a.getModal = v, a.getOverlay = h, a.getInput = y, a.setFocusStyle = b, a.openModal = g, a.resetInput = w, a.resetInputError = C, a.fixVerticalPosition = S
        }, {
            "./default-params": 2,
            "./handle-dom": 4,
            "./injected-html": 7,
            "./utils": 9
        }],
        7: [function (e, t, n) {
         
            Object.defineProperty(n, "__esModule", {
                value: !0
            });
            var o = '<div class="sweet-overlay" tabIndex="-1"></div>' +
                '<div class="sweet-alert">' +
                    '<div class="gencustom-head">' +
                        '<div class="gencutom-title">Alert</div>' +
                        '<button class="gencustom-close"></button>' +
                    '</div>' +
                    '<div class="gencustom-content">' +
                        '<div class="sa-icon sa-error">\n      <span class="sa-x-mark">\n        <span class="sa-line sa-left"></span>\n        <span class="sa-line sa-right"></span>\n      </span>\n    </div><div class="sa-icon sa-warning">\n      <span class="sa-body"></span>\n      <span class="sa-dot"></span>\n    </div><div class="sa-icon sa-info"></div><div class="sa-icon sa-success">\n      <span class="sa-line sa-tip"></span>\n      <span class="sa-line sa-long"></span>\n\n      <div class="sa-placeholder"></div>\n      <div class="sa-fix"></div>\n    </div><div class="sa-icon sa-custom"></div><h2>Title</h2>\n    <p>Text</p>\n    <fieldset>\n      <input type="text" tabIndex="3" />\n      <div class="sa-input-error"></div>\n    </fieldset><div class="sa-error-container">\n      <div class="icon">!</div>\n      <p>Not valid!</p>\n    </div>' +
                    '</div>' +
                    '<div class="sa-button-container">\n      <button class="cancel" tabIndex="2">Cancel</button>\n      <div class="sa-confirm-button-container">\n        <button class="confirm btn btn-primary" tabIndex="1">OK</button><div class="la-ball-fall">\n          <div></div>\n          <div></div>\n          <div></div>\n        </div>\n      </div>\n    </div>' +
                '</div>';
            n["default"] = o, t.exports = n["default"]
        }, {}],
        8: [function (e, t, o) {
            Object.defineProperty(o, "__esModule", {
                value: !0
            });
            var a = e("./utils"),
                r = e("./handle-swal-dom"),
                s = e("./handle-dom"),
                l = ["error", "warning", "info", "success", "input", "prompt"],
                i = function (e) {
                    var t = r.getModal(),
                        o = t.querySelector("h2"),
                        i = t.querySelector("p"),
                        u = t.querySelector("button.cancel"),
                        c = t.querySelector("button.confirm");
                    if (o.innerHTML = e.html ? e.title : s.escapeHtml(e.title).split("\n").join("<br>"), i.innerHTML = e.html ? e.text : s.escapeHtml(e.text || "").split("\n").join("<br>"), e.text && s.show(i), e.customClass) s.addClass(t, e.customClass), t.setAttribute("data-custom-class", e.customClass);
                    else {
                        var d = t.getAttribute("data-custom-class");
                        s.removeClass(t, d), t.setAttribute("data-custom-class", "")
                    }
                    if (s.hide(t.querySelectorAll(".sa-icon")), e.type && !a.isIE8()) {
                        var f = function () {
                            for (var o = !1, a = 0; a < l.length; a++)
                                if (e.type === l[a]) {
                                    o = !0;
                                    break
                                }
                            if (!o) return logStr("Unknown alert type: " + e.type), {
                                v: !1
                            };
                            var i = ["success", "error", "warning", "info"],
                                u = n; -1 !== i.indexOf(e.type) && (u = t.querySelector(".sa-icon.sa-" + e.type), s.show(u));
                            var c = r.getInput();
                            switch (e.type) {
                                case "success":
                                    s.addClass(u, "animate"), s.addClass(u.querySelector(".sa-tip"), "animateSuccessTip"), s.addClass(u.querySelector(".sa-long"), "animateSuccessLong");
                                    break;
                                case "error":
                                    s.addClass(u, "animateErrorIcon"), s.addClass(u.querySelector(".sa-x-mark"), "animateXMark");
                                    break;
                                case "warning":
                                    s.addClass(u, "pulseWarning"), s.addClass(u.querySelector(".sa-body"), "pulseWarningIns"), s.addClass(u.querySelector(".sa-dot"), "pulseWarningIns");
                                    break;
                                case "input":
                                case "prompt":
                                    c.setAttribute("type", e.inputType), c.value = e.inputValue, c.setAttribute("placeholder", e.inputPlaceholder), s.addClass(t, "show-input"), setTimeout(function () {
                                        c.focus(), c.addEventListener("keyup", swal.resetInputError)
                                    }, 400)
                            }
                        }();
                        if ("object" == typeof f) return f.v
                    }
                    if (e.imageUrl) {
                        var p = t.querySelector(".sa-icon.sa-custom");
                        p.style.backgroundImage = "url(" + e.imageUrl + ")", s.show(p);
                        var m = 80,
                            v = 80;
                        if (e.imageSize) {
                            var y = e.imageSize.toString().split("x"),
                                h = y[0],
                                b = y[1];
                            h && b ? (m = h, v = b) : logStr("Parameter imageSize expects value with format WIDTHxHEIGHT, got " + e.imageSize)
                        }
                        p.setAttribute("style", p.getAttribute("style") + "width:" + m + "px; height:" + v + "px")
                    }
                    t.setAttribute("data-has-cancel-button", e.showCancelButton), e.showCancelButton ? u.style.display = "inline-block" : s.hide(u), t.setAttribute("data-has-confirm-button", e.showConfirmButton), e.showConfirmButton ? c.style.display = "inline-block" : s.hide(c), e.cancelButtonText && (u.innerHTML = s.escapeHtml(e.cancelButtonText)), e.confirmButtonText && (c.innerHTML = s.escapeHtml(e.confirmButtonText)), e.confirmButtonColor && (c.style.backgroundColor = e.confirmButtonColor, c.style.borderLeftColor = e.confirmLoadingButtonColor, c.style.borderRightColor = e.confirmLoadingButtonColor, r.setFocusStyle(c, e.confirmButtonColor)), t.setAttribute("data-allow-outside-click", e.allowOutsideClick);
                    var g = e.doneFunction ? !0 : !1;
                    t.setAttribute("data-has-done-function", g), e.animation ? "string" == typeof e.animation ? t.setAttribute("data-animation", e.animation) : t.setAttribute("data-animation", "pop") : t.setAttribute("data-animation", "none"), t.setAttribute("data-timer", e.timer)
                };
            o["default"] = i, t.exports = o["default"]
        }, {
            "./handle-dom": 4,
            "./handle-swal-dom": 6,
            "./utils": 9
        }],
        9: [function (t, n, o) {
            Object.defineProperty(o, "__esModule", {
                value: !0
            });
            var a = function (e, t) {
                for (var n in t) t.hasOwnProperty(n) && (e[n] = t[n]);
                return e
            },
                r = function (e) {
                    var t = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(e);
                    return t ? parseInt(t[1], 16) + ", " + parseInt(t[2], 16) + ", " + parseInt(t[3], 16) : null
                },
                s = function () {
                    return e.attachEvent && !e.addEventListener
                },
                l = function (t) {
                    e.console && e.console.log("SweetAlert: " + t)
                },
                i = function (e, t) {
                    e = String(e).replace(/[^0-9a-f]/gi, ""), e.length < 6 && (e = e[0] + e[0] + e[1] + e[1] + e[2] + e[2]), t = t || 0;
                    var n, o, a = "#";
                    for (o = 0; 3 > o; o++) n = parseInt(e.substr(2 * o, 2), 16), n = Math.round(Math.min(Math.max(0, n + n * t), 255)).toString(16), a += ("00" + n).substr(n.length);
                    return a
                };
            o.extend = a, o.hexToRgb = r, o.isIE8 = s, o.logStr = l, o.colorLuminance = i
        }, {}]
    }, {}, [1]), "function" == typeof define1 && define1.amd ? define1(function () {
        return sweetAlert
    }) : "undefined" != typeof module && module.exports && (module.exports = sweetAlert)
}(window, document);
$(document).ready(function () {
    if ($("#sweetalertClose").length) {
        $("#sweetalertClose").on('click', function () {            
            $("#sweetConfirmbutton").trigger("click");
        });
    }
});
;
; (function ($) {

    'use strict';
    //////////////////////////////////////// Iframe Initialization & Methods - Start ///////////////////////////////////////////
    $.fn.VagaroForms = function (options, callback) {

        if ($.isFunction(options)) {
            callback = options;
            options = null;
        }

        var o = $.extend({}, $.fn.VagaroForms.defaults, options);

        var $frame = this;

        $frame.post = o.post;

        $frame.destroy = function () {
            window.removeEventListener('message', listner, false);
            if ($frame != null) {
                $frame.each(function () {
                    $.data(this, "");
                    $(this).attr('style', '').removeData().hide().html('');
                });
                $frame = null;
            }
        }

        $frame.formsender = {            
            LoginFromForms: function (m) {
                _postMessage('{"eventType": "LoginFromForms"}');
            },
            addClassInVagaroBodyFromForms: function (data) { // Ankit Patel
                _postMessage('{"eventType": "addClassInVagaroBodyFromForms" , "data": ' + JSON.stringify(data) + '}');
            },
            SignUpFromForms: function (m) {
                _postMessage('{"eventType": "SignUpFromForms"}');
            },
            SendBusinessData: function (m) {
                _postMessage('{"eventType": "SendBusinessData" , "data": ' + JSON.stringify(m) + '}');
            }
        };

        window.addEventListener('message', listner, false);

        function listner(e) {
            if (e.origin == "https://portal.forms.com" || e.origin.indexOf("localhost") != -1 || e.origin.indexOf("10.10") != -1 || e.origin.indexOf("vagaro") != -1 || e.origin.indexOf("bookitall") != -1 || e.origin.indexOf("localdev.com") != -1) {
                var m = JSON.parse(e.data || e.originalEvent.data);
                switch (m.eventType) {
                    case 'ECHO':
                        o.loaded = true;
                        break;
                    case 'SendLoginData':  // Ankit Patel                        
                        if (typeof (m.data.LoginUserID) != "undefined" && m.data.LoginUserID > 0) {
                            $("#hdnLoggedInUserID").val(m.data.LoginUserID);
                            //if ($("#hdnRespBy").val() == "") {
                            _loadCCIframe($("#hdnLoggedInUserID").val()); // Added by Ashish M. - Project - Add a Payment Field to Forms - 10/07/2020
                            //}
                            //$("#hdnRespBy").val(m.data.LoginUserID);
                        }
                        if (typeof (m.data.UserName) != "undefined" && m.data.UserName != null) {
                            $("#hdnLoggedInUserName").val(m.data.UserName);
                            //$("#hdnRespByName").val(m.data.UserName);
                        }                        
                        $('#loginPopup').modal('hide');
                        $('#loginRequired').modal('hide');

                        try {
                            if (inIframe()) { // Added by Ashish M. to fix Login popup issue
                                _form.setIframeHeight($('#divFormContentArea')[0].scrollHeight + 50);
                            }
                        }
                        catch (e) {
                            console.log("Some error occured, Please try again!.");
                        }

                        break;
                    case 'ShowLoginPopup':  // Ankit Patel                        
                        // if user is not logged in then display login screen
                        if ($("#hdnLUserID").val() != "" && $("#hdnLUserID").val() != 0) {
                            $("#hdnLoggedInUserID").val($("#hdnLUserID").val());
                            $('#loginPopup').modal('hide');
                            $('#loginRequired').modal('hide');
                        }
                        else {
                            _formResp.setLoginPopupHeight(); // Added by Ashish M. to fix Login popup issue
                            var popup = $("#loginRequired");
                            popup.on('show.bs.modal', _formResp.centerModal(popup)).modal("show");
                            $("html").addClass('hidescroll-form').css('overflow', 'hidden'); //Added by Nirav Savariya for fix ticket https://vagaro.zendesk.com/agent/tickets/1239819 on 28/09/2020
                        }
                        break;                  
                }
            }
        }

        return $frame.each(function () {
            if (!$.data(this, "plugin")) {
                init();
            }
            console.log('frame.each');
        });

        function init() {
            createPopup(o.modal);
        }

        function createPopup(modal) {
            var $iframe = $('<iframe class="b-iframe" ' + o.iframeAttr + ' id="iFrame_' + $frame.attr('id') + '" style="display:none;"></iframe>');
            if (modal == true) {
                var $popup = $("<div id='frame_apgProgress_" + $frame[0].id + "' style='display:none;'></div>" +
                    "<div style='position: relative; ' id='divinnertop_up'>" +
                    "<div id='ccfram_backgroundElement' style='position: fixed; left: 0px; top: 0px; width: 100%; height: 100%;' class='ModalPopupBG'></div>" +
                    "<div style='color: white; font-family: \"Lucida Grande\",\"Arial\"; font-size: 11px; position: absolute; text-align: center;width: 100%; z-index: 2001; top: 6px; position:relative;'></div>" +
                    "<div style='width: auto; height: auto; margin: 0 -7px;z-index:9999; position:relative' class='contentContainer'>" +
                    "</div>" +
                    "</div>");

                $popup.find('.contentContainer').append($iframe);
                $popup.appendTo($frame);//.fadeTo(o.speed, o.opacity);
            }
            else {
                $iframe.appendTo($frame);//.fadeTo(o.speed, o.opacity);
            }



            $frame.data('iframe_id', $iframe.attr('id'));
            $iframe.height(o.height).width(o.width);
            $iframe.attr('src', o.loadUrl); // setting iframe src after open due IE9 bug

            //initialize forms class
            console.log($iframe.attr('id'));
            //Fire opening
            triggerCall(o.receivers.onOpening);
            //Fire when open
            $iframe.load(function (e) {                
                if (o.isfullwidth == true) {
                    $(this).addClass("framefullwidth");
                }
             
                window.setTimeout(ShowFrame(modal), 1000);

            });
        }

        function ShowFrame(modal) {            
            o.loaded = true;
            triggerCall(o.receivers.onOpened);
            $frame.find('iframe').css("display", "block");
            if (modal == true) {
                ShowPopup(o.height, o.width, $frame.attr('id'));
            } else {

                $('#' + vuiForms.contentContainer).show();

            }
            if (vuiForms.loader != null) vuiForms.loader(false);
        }

        function ShowPopup(frameHeight, frameWidth, contentContainer) {
            var divTopLeftarray, divTop, divLeft, viewPortHeight;
            var divtop_up = document.getElementById(contentContainer);
            divTopLeftarray = getTopLeftPosition(frameHeight, frameWidth).split('|');
            divTop = divTopLeftarray[0];
            divLeft = divTopLeftarray[1];
            viewPortHeight = divTopLeftarray[2];
            divtop_up.style.left = divLeft - 20 + 'px';
            var scrollTop;
            if (document.documentElement.scrollTop != document.body.scrollTop) {
                scrollTop = document.documentElement.scrollTop + document.body.scrollTop
            } else {
                scrollTop = document.body.scrollTop;
            }

            if (scrollTop > 0)
                divTop = parseInt(divTop) + scrollTop;

            divTop = divTop - 20;
            divtop_up.style.top = divTop + 'px';

            divtop_up.style.position = 'absolute';
            divtop_up.width = 'auto';
            divtop_up.height = 'auto';
            divtop_up.style.zIndex = 100001;

            divtop_up.style.display = "";
            //Call_ClearControls(contentContainer);
        }

        function getTopLeftPosition(frameHeight, frameWidth) {
            var viewportheightarray, viewportheight, viewportwidth, divTop, divLeft;
            viewportheightarray = getViewPortHeightWidth().split('|');
            viewportheight = viewportheightarray[0];
            viewportwidth = viewportheightarray[1];
            divTop = (viewportheight - frameHeight) / 2; //555 is iFrame Static Height and other top-bottom so, 600 is minus from viewportheight
            if (divTop < 0)
                divTop = 1;
            divLeft = (viewportwidth - frameWidth) / 2; //820 is iFrame Static width and other top-bottom so, 832 is minus from viewportwidth
            return divTop + '|' + divLeft + '|' + viewportheight;
        }

        function getViewPortHeightWidth() {
            //****************************************************************************************************************
            // Viewportwidth and height
            var viewportwidth;
            var viewportheight;

            // the more standards compliant browsers (mozilla/netscape/opera/IE7) use window.innerWidth and window.innerHeight
            if (typeof window.innerWidth != 'undefined') {
                viewportwidth = window.innerWidth,
                    viewportheight = window.innerHeight
            }
            // IE6 in standards compliant mode (i.e. with a valid doctype as the first line in the document)
            else if (typeof document.documentElement != 'undefined'
                && typeof document.documentElement.clientWidth !=
                'undefined' && document.documentElement.clientWidth != 0) {
                viewportwidth = document.documentElement.clientWidth,
                    viewportheight = document.documentElement.clientHeight
            }
            // older versions of IE
            else {
                viewportwidth = document.getElementsByTagName('body')[0].clientWidth,
                    viewportheight = document.getElementsByTagName('body')[0].clientHeight
            }
            return viewportheight + '|' + viewportwidth;
        }

        function _postMessage(message) {
            try {
                if (document.getElementById($frame.data('iframe_id')) != undefined || document.getElementById($frame.data('iframe_id')) != null) {
                    var source = getSource();
                    if (typeof source != 'undefined' && source != null && source != '' && source != "" && source.indexOf('vagaro.com') != -1) {
                        document.getElementById($frame.data('iframe_id')).contentWindow.postMessage(message, '*');
                    }
                    else {
                        document.getElementById($frame.data('iframe_id')).contentWindow.postMessage(message, getSource());
                    }                   
                }
            }
            catch (e) {
                console.log(e);
            }
        }

        var _target = null;
        function getSource() {            
            if (_target == null) {
                var targetRegex = /^(https*:\/\/[^\/]*).*$/g;
                var match = targetRegex.exec($('#' + $frame.data('iframe_id')).attr('src'));
                if (match) {
                    _target = match[1];
                }
            }
            return _target;
        }

        function triggerCall(func, arg) {
            $.isFunction(func) && func.call(this, arg);
        }
    }
    //////////////////////////////////////// Iframe Initialization & Methods - End ///////////////////////////////////////////

    //////////////////////////////////////// Defaults - Start ///////////////////////////////////////////
    $.fn.VagaroForms.defaults = {
        height: 375
        , width: 480
        , loaded: false
        , appendTo: 'body'
        , iframeAttr: 'scrolling="yes" frameborder="0"'
        , loadUrl: ''
        , modal: true
        , modalClose: true
        , opacity: 1
        , position: ['auto', 'auto'] // x, y,
        , positionStyle: 'absolute'// absolute or fixed
        , scrollBar: true
        , speed: 250 // open & close speed
        , transition: 'fadeIn' //transitions: fadeIn, slideDown, slideIn, slideBack
        , transitionClose: false
        , zIndex: 1000001 // popup gets z-index 9999, modal overlay 9998
        , showLog: true
        , afterCallBackHandle: 0 // 0 -- handle error in forms, 1 -- do not handle error forms
        , iswebview: false
        , ignorePro: false
        , isfullwidth: false,
        receivers: {
            onClose: function (m) { if (typeof (onFormCloseCallback) == 'function') onFormCloseCallback(m); },
            onError: function (m) { if (typeof (onErrorCallback) == 'function') onErrorCallback(m); },
            onReloadIframeParentPage: function (m) { if (typeof (onReloadIframeParentPageCallback) == 'function') onReloadIframeParentPageCallback(m); },
            onHideLoading: function (m) { if (typeof (onHideLoadingCallback) == 'function') onHideLoadingCallback(m); },
            onDisplayLoading: function (m) { if (typeof (onDisplayLoadingCallback) == 'function') onDisplayLoadingCallback(m); },            
            onFormsDown: function (m) { if (typeof (onFormsDownCallback) == 'function') onFormsDownCallback(m); }            
        }
    };
    //////////////////////////////////////// Defaults - End ///////////////////////////////////////////

})(jQuery);

//////////////////////////////////////// Direct Calling Methods - Start ///////////////////////////////////////////
(function () {
    window.vuiForms = {
        frameUrl: null,
        frame: null,
        contentContainer: null,
        modal: false,
        height: 375,
        width: 480,
        loader: function (flag) {
            if (flag) {
                if ($("#apgProgress").length > 0) {
                    $("#apgProgress").show();
                }
                else if ($("#apgLoading").length > 0) {
                    $("#apgLoading").show();
                }
            }
            else {
                if ($("#apgProgress").length > 0) {
                    $("#apgProgress").hide();
                }
                else if ($("#apgLoading").length > 0) {
                    $("#apgLoading").hide();
                }
            }
        },
        buttonBackColor: typeof (hdnButtonBackColor) != undefined ? $("#hdnButtonBackColor").val() : "",
        buttonFontColor: typeof (ButtonFontColor) != undefined ? $("#hdnButtonFontColor").val() : "",
        buttonHoverColor: typeof (ButtonHoverColor) != undefined ? $("#hdnButtonHoveColor").val() : "",
        displayLoading: function (progressor) {
            this.loader(true);
        },
        hideLoading: function (progressor) {
            this.loader(false);
        },
        setHeight: function (height, width) {
            var _iframeid = "iFrame_" + this.contentContainer;
            $('#' + _iframeid).height(height);
            $('#' + _iframeid).width(width);
        },
        getSize: function (height, width) {
            forms.getSize();
        },
        getFormsPage: function (contentContainer, url, height, width, iswebview, isOnline) {

            this.modal = false;
            this.height = height;
            this.width = width;
            this.iswebview = iswebview;
            this.isOnline = isOnline;
            this.contentContainer = contentContainer;
            var result = { data: { url: url }, custom_code: 1000 };
            this._callFormsPageSuccess(result);
        },
        _callFormsPageSuccess: function (result) {
            if (result != null && result.custom_code == 1000) {
                if (vuiForms.modal == false) {
                    //$('#' + vuiForms.contentContainer).show();
                }
                if (result.data.url == undefined || result.data.url == null || result.data.url == "undefined") {
                    //if (typeof (onGetSwipeCallback) == 'function') onGetSwipeCallback(result);
                } else {
                    vuiForms.frame = $('#' + vuiForms.contentContainer).VagaroForms({ loadUrl: result.data.url, modal: vuiForms.modal, height: vuiForms.height, width: vuiForms.width, afterCallBackHandle: vuiForms.afterCallBackHandle, iswebview: vuiForms.iswebview, isfullwidth: vuiForms.isfullwidth, isOnline: vuiForms.isOnline });
                }
            }
            else {
                //onMessage
                if (vuiForms.loader != null) vuiForms.loader(false);
                onFormsDownCallback(result);
            }
        },
        getFilledFormsPage: function (contentContainer, url, height, width, iswebview) {
            this.modal = false;
            this.height = height;
            this.width = width;
            this.iswebview = iswebview;
            this.contentContainer = contentContainer;
            this.iframeAttr = 'scrolling="yes" frameborder="0"';
            var result = { data: { url: url }, custom_code: 1000 };
            this._callFilledFormsSuccess(result);
        },
        _callFilledFormsSuccess: function (result) {
            if (result != null && result.custom_code == 1000) {
                if (vuiForms.modal == false) {
                    //$('#' + vuiForms.contentContainer).show();
                }
                if (result.data.url == undefined || result.data.url == null || result.data.url == "undefined") {
                    //if (typeof (onGetSwipeCallback) == 'function') onGetSwipeCallback(result);
                } else {
                    vuiForms.frame = $('#' + vuiForms.contentContainer).VagaroForms({ iframeAttr: vuiForms.iframeAttr, loadUrl: result.data.url, modal: vuiForms.modal, height: vuiForms.height, width: vuiForms.width, afterCallBackHandle: vuiForms.afterCallBackHandle, iswebview: vuiForms.iswebview, isfullwidth: vuiForms.isfullwidth });
                }
                //if (vuiForms.loader != null) vuiForms.loader(false);
            }
            else {
                //onMessage
                if (vuiForms.loader != null) vuiForms.loader(false);
                //onFormsDownCallback(result);
            }
        },
        _callDirectUrl: function (frameURL, modal, height, width, afterCallBackHandleinner) {

            vuiForms.frame = $('#' + vuiForms.contentContainer).VagaroForms({ loadUrl: frameURL, modal: modal, height: height, width: width, afterCallBackHandle: afterCallBackHandleinner });
        },
        setIframeUrl: function (frameURL, modal, height, width, afterCallBackHandleinner) {
            //if (vuiForms.loader != null) vuiForms.loader(true);
            if (vuiForms.frame != null) {
                vuiForms.frame.find('iframe').attr('src', frameURL);
                //if (vuiForms.loader != null) vuiForms.loader(false);
            }
            else {
                vuiForms.frame = $('#' + vuiForms.contentContainer).VagaroForms({ loadUrl: frameURL, modal: modal, height: height, width: width, afterCallBackHandle: afterCallBackHandleinner });
            }
        }       
    };
})();
//////////////////////////////////////// Direct Calling Methods - End ///////////////////////////////////////////

//////////////////////////////////////// Callback Methods - Start ///////////////////////////////////////////
onFormsDownCallback = function (res) {
    var ErrorMsg = "";
    //if (typeof (currElement) != "undefined") {
    if (typeof (res) != "undefined" && typeof (res.data) !== "undefined" && res.data != null && typeof (res.data.Message) !== "undefined" && res.data.Message !== "") {
        var errorcode = "";
        //if (res.data.subResponseCode != null && res.data.subResponseCode != undefined && res.data.subResponseCode != "") {
        //    errorcode = "<br/>Error Code:" + res.data.paymentGateway+"-" + res.data.subResponseCode;
        //}
        ErrorMsg = res.data.Message + errorcode;
    }
    else if (typeof (res) != "undefined" && typeof (res.Message) !== "undefined" && res.Message != null && res.Message !== "") {
        ErrorMsg = res.Message;
    }
    else {
        ErrorMsg = "Some error occured, Please try again!.";
    }
    swal({ title: "", text: ErrorMsg, html: true, showCancelButton: false, customClass: 'sweet-alert-model', animation: "slide-from-bottom" },
        function (isConfirm) {
            window.location.href = window.location.href;
            return false;
        });
}



onReloadIframeParentPageCallback = function (m) {
    window.location.reload(true);
}
onDisplayLoadingCallback = function (m) {
    vuiForms.displayLoading();
}
onHideLoadingCallback = function (m) {
    vuiForms.hideLoading();
}

//--------Read html by url-------end------/
var formsAjax = function (token, data, callback, error, isAjaxQue, async) {
    var scrollAjax = new vagaro.ajax();
    scrollAjax.datamodel.Token = token;
    scrollAjax.datamodel.data = data;
    scrollAjax.datamodel.callback = callback;
    scrollAjax.datamodel.Error = error;
    if (async == false) {
        scrollAjax.datamodel.async = false;
    }
    if (isAjaxQue == true)
        scrollAjax.PostQue();
    else
        scrollAjax.Post();
}


//////////////////////////////////////// Callback Methods - End ///////////////////////////////////////////

//////////////////////////////////////// Common Methods - Start ///////////////////////////////////////////
$(window).on('resize', function () {
    setTimeout(function () {
        setFormPageHeight();
    }, 500);
    //if (vuiForms.frame != null) {
    //    vuiForms.frame.forms.getSize();
    //}
});

$(window).bind("orientationchange", function (e) {
    setTimeout(function () {
        setFormPageHeight()
    }, 1000);
});


$(".settingMainWarp").on("touchend", function (e) {
    vuiForms.frame.forms.getHeight();
    //$(vuiForms.frame).css("height", $(vuiForms.frame).find("iframe").css("height"));    
    setTimeout(function () {
        setFormPageHeight()
    }, 1000);
});
$(".settingMainWarp").on("touchstart", function (e) {
    vuiForms.frame.forms.getHeight();
    //$(vuiForms.frame).css("height", $(vuiForms.frame).find("iframe").css("height"));    
    setTimeout(function () {
        setFormPageHeight()
    }, 1000);
});

function setFormPageHeight() {

    if (typeof iframe_type != 'undefined') {
        if (iframe_type == 1)//ManageForm.aspx
        {
            if ($('.navigation-bg').is(':visible') == true) {
                vuiForms.setHeight($(window).height() - $(".navigation-bg").height(), '100%');
            }
            else {
                vuiForms.setHeight($(window).height(), '100%');
            }
            vuiForms.setHeight($(window).height() - $(".navigation-bg").height(), '100%');
        }
        else if (iframe_type == 2 || iframe_type == 4) // 2 :FormResponse.aspx  4:ManageFormTemplate.aspx
        {
            vuiForms.setHeight($(window).height() - $(".headerFix").height(), '100%');
        }
    }
}
//////////////////////////////////////// Common Methods - End ///////////////////////////////////////////
;
var userAgent = (navigator.userAgent || navigator.vendor || window.opera).toLowerCase();
var iosandroidprocustomerapp = userAgent.match(/iPad com.vagaro.iospro/i) || userAgent.match(/iPad com.vagaro.ioscustomer/i) || userAgent.match(/androidpro/i) || userAgent.match(/androidcustomer/i) || false;
var androidapp = userAgent.match(/androidpro/i) || userAgent.match(/androidcustomer/i) || false;
var iosapp = userAgent.match(/iPad com.vagaro.iospro/i) || userAgent.match(/iPad com.vagaro.ioscustomer/i) || false;
var isSafariBrowser = userAgent.match(/safari/i) || userAgent.match(/mac/i) || false;
var isClick = false;
var isWebView = false;
var iosandroidpro = false;
var isCheckinApp = false;
var isCustomerApp = false;
var deviceIsMobile = false; //At the beginning we set this flag as false. If we can detect the device is a mobile device in the next line, then we set it as true.
var isWindowsPhoneTemp = /windows phone/i.test(navigator.userAgent.toLowerCase());
var countryMapping = { 1: "USA", 2: "UK", 3: "Canada", 4: "Australia" };
var countryMapForAPI = { 1: "US", 2: "GB", 3: "CA", 4: "AU" };
var regex = /^((0[13578]|1[02])[\-.]31[\-.](19|20)[0-9]{2})$|^((01|0[3-9]|1[0-2])[\-.](29|30)[\-.](19|20)[0-9]{2})$|^((0[1-9]|1[0-2])[\-.](0[1-9]|1[0-9]|2[0-8])[\-.](19|20)[0-9]{2})$|^((02)[\-.]29[\-.](((19|20)(04|08|[2468][048]|[13579][26]))|2000))$/;
var isMobile = false;
var isAndroidBrandedApp = false;
var isiOsBrandedApp = false;
if (typeof _form === 'undefined') {
    _form = {}; //used for commom properties and functions
};
_form.ipLocation = null;

if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)) {
    deviceIsMobile = true;
}
if (navigator.userAgent.match(/iospro/i) != null || navigator.userAgent.match(/androidpro/i) != null) {
    iosandroidpro = true;
    $("html").addClass("prodevice");
} else {
    iosandroidpro = false;
}

if (navigator.userAgent.match(/com.vagaro.androidcheckin/i) != null || navigator.userAgent.match(/com.vagaro.ioscheckin/i) != null) {
    isCheckinApp = true;
}

if (navigator.userAgent.match(/com.vagaro.customerios/i) != null || navigator.userAgent.match(/com.vagaro.customerandroid/i) != null || navigator.userAgent.match(/com.vagaro.customerandroid amazon/i) != null) {
    isCustomerApp = true;
}

if (navigator.userAgent.match(/com.vagaro.customerandroid-brandedapp/i) != null) {
    isAndroidBrandedApp = true;
}
if (navigator.userAgent.match(/com.vagaro.customerios-brandedapp/i) != null) {
    isiOsBrandedApp = true;
}
if (!String.isNullOrUndefineOrBlank) {
    String.isNullOrUndefineOrBlank = function (data) {
        if (typeof (data) == "undefined" || data == undefined || data == "" || data == null) {
            return true;
        }
        return false;
    }
}
//////////////////////////////////////// Iframe Listener Methods - Start ///////////////////////////////////////////
window.addEventListener('message',
    function (e) {
        var m = JSON.parse(e.data || e.originalEvent.data);
        onMessage(m);
    }, false);

function onMessage(m) {
    switch (m.eventType) {
        case 'checkWebView':
            isWebView = (m.iswebview == "true" ? true : false);
            if (isWebView) {
                $("#btnSubmit").css("display", "none");
            }
            break;
        case 'getSize':
            frm.getSize();
            break;
        case 'submitForm':
            _form.submitForm(m.resp);
            break;
        case 'NextSign':
            _form.NextSign();
            break;
        case 'submitAllForm': // Ankit Patel
            _form.submitAllForm(m.formsRes);
            break;
        case 'hideHeaderandFooter':
            _form.hideHeaderandFooter();
            break;
        case 'addClassInFormsBody':  // Ankit Patel add class in body
            _form.addClassInFormsBody(m.data);
            break;
        case 'addClassInFormsHtml':  // Ankit Patel add class in body
            _form.addClassInFormsHtml(m.data);
            break;
        case 'showHeaderandFooter':
            _form.showHeaderandFooter(m.message);
            break;
        case 'sendLoginUseDetails':
            _form.sendLoginUseDetails(m.data);
            break;
        case 'addStyle':
            _form.addStyle(m.style);
            break;
        case 'getHeight':
            frm.setHeight();
            break;
        case 'getContentHeight':
            frm.setContentHeight();
            break;
        case 'HideSignatureData':
            _formResp.HideEmployeeSignature();
            break;
        case 'getCheckinContentHeight':
            frm.setCheckinContentHeight();
            break;
        case 'setScreen':
            _form.setCenterPopup(m);
            break;
        case 'responseServiceAndClass':
            _form.responseServiceAndClassData(m.data);
            break;
        case 'responseMembership':
            _form.responseMembershipData(m.data);
            break;
        case 'responseBusinessTypes':  //By :-karangiri goswami
            _form.responseBusinessTypes(m.data);
            break;
        case 'GetFormRespIframeDataSuccess':
            if (typeof (m.message) != "undefined" && m.message != null) {
                _form.getFormRespIframeDataSuccess(m.message);
            }
            break;
        case 'sendAccessRights':
            //vagaro project set an access rights for customer popup
            if (typeof (m.accessrights) != "undefined" && m.accessrights != null) {
                _formResp.setAccessRights(m.accessrights);
            }
            break;
        case 'sendStateDetail':
            //vagaro project set an access rights for customer popup
            if (m != null) {
                _googleLocation.getStateName(m);
            }
            break;
        case 'sendCityByZipCode':
            //vagaro project set an access rights for customer popup
            if (m != null) {
                _googleLocation.sendCityByZipCode(m);
            }
            break;
        case 'getFormOrSoapResponseDetailById':
            //Get soap response detail and fill for edit case
            _formResp.fillDetailForEditResp(m.message);
            break;
        case 'getFormValidationContentHeight':
            frm.setFormValidationContentHeight();
            break;
        case 'getFormValidationScrollTop':
            frm.setFormValidationScrollTop();
            break;
        case 'IsOnline':
            $("#hdnCallFrom").val(m.IsOnline);
            break;
        case 'heicSucessResponseFromVagaro':
            successHEICtoJPG(JSON.stringify(m));
            break;
        case 'sendCCDetailsToForms':
            _sendCCDetailsToFormsOnlineBooking(m);
            break;
        case 'getFormPreviewHide': // Called from forms.js for Rent and Fees Preview Form
            _form.getFormPreviewHide();
            break;
        case 'setPreviewFlag': // Called from forms.js for Rent and Fees Preview Form
            _form.setPreviewFlag();
            break;
        case 'GetRentContractHeight':  // Ankit Patel add class in body
            _form.GetRentContractHeight();
            break;
        case 'callMarkerEditorSave':
            _formResp._saveMarkerEditorFromVagaro(m.responseData);
            break;
        case 'callEmployeeSignValidate':
            _formResp.setUseridInParticularQuestiondv(m.responseData);
            break;
        //case 'setsignaturedatetime':
        //    _form.setsignaturedatetime(m);
        //    break;
    }
}
//////////////////////////////////////// Iframe Listener Methods - End ///////////////////////////////////////////

//////////////////////////////////////// Iframe Post Methods - Start ///////////////////////////////////////////
(function ($, w, d) {
    frm = {
        _getDocHeight: function () {
            //return $("#divMerchantFrame")[0].scrollHeight;
            return $(window).height();
        },
        callSubmitButton: function () {
            this._postMessage('{"eventType":"callSubmitButton"}');
        },
        setHeight: function () {
            this._postMessage('{"eventType":"setHeight", "height":' + (this._getDocHeight()) + ', "id": "forms"}');
        },
        iframesetHeight: function (height) {
            this._postMessage('{"eventType":"setContentHeight", "height":' + height + '}');
        },
        setParentDivHeight: function () {
            this._postMessage('{"eventType": "setParentDivHeight"}');
        },
        setToScrollPosition: function (position) {
            this._postMessage('{"eventType": "setToScrollPosition", "position":' + position + '}');
        },
        setContentHeight: function () {
            var bodyHeight = $('body').height() + 50;
            if (isAndroidBrandedApp || isiOsBrandedApp || isCustomerApp) {
                bodyHeight = $("#divFormContainer").height();
            }
            this._postMessage('{"eventType":"setContentHeight", "height":' + (bodyHeight) + '}'); // modified By Krishnan on 1-10-2019 Form Scrolling Issue Resolved
        },
        setCheckinContentHeight: function () {
            this._postMessage('{"eventType":"setCheckinContentHeight", "height":' + $('body').height() + '}');
        },
        scrollToTop: function (offset) {
            this._postMessage('{"eventType":"scrollTop", "offset":' + parseInt(offset, 10) + '}');
        },
        scrollTobottom: function () {
            this._postMessage('{"eventType":"scrollToBottom"}');
        },
        callSubmitButton: function () {
            this._postMessage('{"eventType":"callSubmitButton"}');
        },
        reloadIframeParentPage: function () {
            this._postMessage('{"eventType": "reloadIframeParentPage"}');
        },
        displayLoading: function () {
            this._postMessage('{"eventType": "displayLoading"}');
        },
        resetReponseFrame: function () {
            if (iosandroidpro) {
                // Vagaro Pro case
                this._postMessage('{"eventType": "formDeleted"}');
            }
            else {
                // Website case
                this._postMessage('{"eventType": "resetReponseFrame"}');
            }
        },
        hideLoading: function () {            
            this._postMessage('{"eventType": "hideLoading"}');
        },
        SavebuttonName: function () {
            this._postMessage('{"eventType": "SavebuttonName","Name" : "' + _formResp.btnSave + '","PendingSign" : "' + _formResp.SignPendding + '"}');
        },
        sendMessage: function (m) {
            this._postMessage('{"eventType": "sendMessage", "message" : ' + JSON.stringify(m) + '}');
        },
        error: function () {
            this._postMessage('{"eventType": "error"}');
        },
        getSize: function () {
            this._postMessage('{"eventType": "getSize","height" :' + $('body').outerHeight(true) + ',"width" :' + $('body').outerWidth(true) + '}');
        },
        loadTutorial: function () {
            this._postMessage('{"eventType": "loadTutorial"}');
        },
        GetFormRespIframeData: function (m) {
            this._postMessage('{"eventType": "GetFormRespIframeData", "message" : ' + JSON.stringify(m) + '}');
        },
        iframe_Loaded: function (m) {
            this._postMessage('{"eventType": "iframe_Loaded", "message" : "iframe_Loaded"}');
        },
        parent_screen: function (m) {
            this._postMessage('{"eventType": "parent_screen", "message" : "parent_screen"}');
        },
        getServicesandClass: function (m) {
            if (typeof (m) == "undefined") {
                m = 0;
            }
            this._postMessage('{"eventType": "getServicesandClass", "businessID" : ' + JSON.stringify(m) + '}');
        },
        getMemberships: function (m) {
            this._postMessage('{"eventType": "getMemberships", "businessID" : ' + JSON.stringify(m) + '}');
        },
        submitFormResponse: function (m, n, isCCCaptureInForms, _zenSwipeCardDetails) {
            if (iosandroidpro) {
                if (inIframe()) {

                    this._postMessage('{"eventType": "submitFormResponse", "message" : ' + JSON.stringify(m) + ',"isSingleSave" : ' + JSON.stringify(n) + '}');
                }
                else {
                    window.JSInterface.CallWSMethod('{"eventType": "formSubmitted"}');
                }
            }
            else {

                if (typeof isCCCaptureInForms == "undefined" || isCCCaptureInForms == "") {
                    isCCCaptureInForms = null;
                }
                this._postMessage('{"eventType": "submitFormResponse", "message" : ' + JSON.stringify(m) + ',"isSingleSave" : ' + JSON.stringify(n) + ',"isCCCaptureInForms" : ' + JSON.stringify(isCCCaptureInForms) + ', "zenSwipeCardDetailsFormForms" : ' + JSON.stringify(_zenSwipeCardDetails) + '}');
            }
        },
        getLoginUserDetails: function (m) {
            this._postMessage('{"eventType": "getLoginUserDetails"}');
        },
        getBusinessTypelist: function (m) {
            this._postMessage('{"eventType" :"getBusinessTypelist","businessId" : "' + JSON.stringify(m) + '"}')
        },
        GetStateDetailByName: function (m) {
            this._postMessage('{"eventType": "GetStateDetailByName", "message" : ' + m + '}');
        },
        GetCityByZipCode: function (m) {
            this._postMessage('{"eventType": "GetCityByZipCode", "message" : ' + m + '}');
        },
        DateRangePickerScrollSetUp: function (m) {
            if ($("body").width() < 462)
                this._postMessage('{"eventType": "DateRangePickerSetUp","message" : ' + m + '}');
        },
        DatePickerScrollSetUp: function (m) {
            this._postMessage('{"eventType": "DateRangePickerSetUp","message" : ' + m + '}');
        },
        setFormValidationContentHeight: function () {
            this._postMessage('{"eventType":"setContentHeight", "height":' + ($('#divFormContentArea').height() + 50) + '}');
        },
        setToFormScrollPosition: function (position) {
            this._postMessage('{"eventType": "setToFormScrollPosition", "position":' + position + '}');
        },
        getCCDetailsFromVagaro: function (UserId) {
            this._postMessage('{"eventType": "getCCDetailsFromVagaro", "UserID":' + UserId + '}');
        },
        _target: null,
        getTarget: function () {
            // Added hdnIFrameTarget to send Post message to Main URL (In case of internal url redirection (e.g. Forms page to FormsSummary page))
            if ($("#hdnIFrameTarget").val() != null && $("#hdnIFrameTarget").val() != undefined && $("#hdnIFrameTarget").val() != "") {
                this._target = $("#hdnIFrameTarget").val()
            }
            if (this._target == null) {
                var targetRegex = /^(https*:\/\/[^\/]*).*$/g;
                var match = targetRegex.exec(document.referrer);
                if (match) {
                    this._target = match[1];
                }
            }
            return this._target;
        },
        _postMessage: function (msg) {
            try {

                if (!(window.JSInterface == undefined) && msg.indexOf("submitFormResponse") < 0) // Added IndexOf condition by Ashish M. for Stop call back send to IOS Customer APP
                    window.JSInterface.CallWSMethod(msg);
                if (!(window.parent == undefined) && !(window.document == undefined) && !(window.parent.postMessage == undefined)) {
                    var source = this.getTarget();
                    if (typeof source != 'undefined' && source != null && source != '' && source != "" && source.indexOf('vagaro.com') != -1) {
                        window.parent.postMessage(msg, '*');
                    }
                    else {
                        window.parent.postMessage(msg, this.getTarget());
                    }
                }
            }
            catch (e) {
                console.log(e);
            }
        },
        showMessage: function (message, type) {
            this._postMessage('{"eventType": "showMessage","message": "' + message + '","type": "' + type + '"}');
        },
        getAccessRights: function () {
            // send post message to vagaro project  to get an access rights for customer popup
            this._postMessage('{"eventType": "getAccessRights"}');
        },
        get_hostname: function (url) {
            //var m = url.match(/^http:\/\/[^/]+/);
            return url.toString().replace(/^(.*\/\/[^\/?#]*).*$/, "$1");
            //var m = url.match(/^http:\/\/[^/]+/);
            //return m ? m[0] : null;
        },
        editFormOrSaopResponse: function () {
            try {
                var currenturl = location.protocol + '//' + location.hostname + (location.port ? ':' + location.port : '');
                var respPageUrl = $("#hdnFormUrl").val();
                if (this.get_hostname(currenturl).toLowerCase() != this.get_hostname(respPageUrl).toLowerCase());
                {
                    if ($("#hdnBusinessID").val() != null && $("#hdnBusinessID").val() != "") {
                        $("#hdnFormUrl").val(respPageUrl.replace(this.get_hostname(respPageUrl), this.get_hostname(currenturl)) + "?reqBusinessId=" + $("#hdnBusinessID").val());
                    }
                    else {
                        $("#hdnFormUrl").val(respPageUrl.replace(this.get_hostname(respPageUrl), this.get_hostname(currenturl)));
                    }
                }
            } catch (e) { }

            var data = {
                respId: $("#hdnFormresponseId").val(),
                respPageUrl: $("#hdnFormUrl").val(),
                formId: $("#hdnFormID").val(), //Added by Nirav S for (PRJ-00100-R)-Send non-required form to Customer - Website on 02/02/2021
                formTemplateID: $("#hdnFormTemplateID").val()
            }
            this._postMessage('{"eventType": "editFormOrSaopResponse", "message": ' + JSON.stringify(data) + '}');
        },
        ResetCheckInAppTimer: function () {
            this._postMessage('{"eventType": "ResetCheckInAppTimer"}');
        },
        SendFormSaveSuccess: function (message) {
            this._postMessage('{"eventType": "SendFormSaveSuccess", "message": ' + message + '}');
        },
        SendCallbackforHideHeader: function () { // Added by Ashish M. : Task #68677 : To Hide Header call back for redirect on sucess screen after form submitted
            window.JSInterface.CallWSMethod('{"eventType": "hideHeader"}');
        },
        SendCallbackforNextSignResponse: function () { 
            window.JSInterface.CallWSMethod('{"eventType": "NextSignResponse"}');
        },
        SendCallbackforformSubmitted: function () { // Added by Ashish M. : Task #68677 : To form Submitted call back on success screen
            window.JSInterface.CallWSMethod('{"eventType": "formSubmitted"}');
        },
        callVagaroDrive: function () {
            this._postMessage('{"eventType": "loadVagaroDrive"}');
        },
        callReactiveVagaroDrivePopup: function () {
            this._postMessage('{"eventType": "loadReactiveVagaroDrivePopup"}');
        },
        callVagaroDriveRequired: function () {
            this._postMessage('{"eventType": "loadVagaroDriveRequired"}');   // Added by Nishant Patel : BUG 96169: Redirect to vagaro drive page when only upload control in ofline 
        },
        callToVagaroForHEICCallBack: function (m) {
            this._postMessage(m);
        },
        callManageMerchantAccount: function () { // Added by Ashish M. - Project - Add a Payment Field to Forms - 31/07/2020
            this._postMessage('{"eventType": "callOpenManageMerchantAccountDialog"}');
        },
        SendCallbackOfFilledContractForm: function () {
            this._postMessage('{"eventType": "filledContractForm"}');
        },
        SendCallbackOfGetRentContractHeight: function (m) {
            this._postMessage('{"eventType": "getrentcontractheightcallback", "message" : ' + m + '}');
        },
        callMarkerPhotoEditor: function (postOnEditorData) {
            this._postMessage('{"eventType": "loadMarkerPhotoEditor", "postData": ' + JSON.stringify(postOnEditorData) + '}');
        },
        callEmployeeSignPopup: function (postOnSignData) {
            this._postMessage('{"eventType": "callEmployeeSignPopup", "postData": ' + JSON.stringify(postOnSignData) + '}');
        }
    };
})(jQuery, window, document);
//////////////////////////////////////// Iframe Post Methods - End ///////////////////////////////////////////

//////////////////////////////////////// Calling Methods - Start ///////////////////////////////////////////
//Responsible for form related methods
(function ($, w, d) {
    
    // To open Tutorial Video From Vagaro
    _form.openTutorialVideo = function () {
        frm.loadTutorial();
    }

    _form.setIframeHeight = function (height) {
        frm.iframesetHeight(height);
    }

    _form.setParentDivHeight = function () {
        frm.setParentDivHeight();
    }
    _form.setScrollPosition = function (position) {

        frm.setToScrollPosition(position);
    }
    _form.setFormScrollPosition = function (position) {
        frm.setToFormScrollPosition(position);
    }
    // Created By:- Sanjay Parmar
    // To get Form response data from FormId
    _form.loadFormRespIframe = function (formId) {
        frm.GetFormRespIframeData(formId);
    }
    // CallBack from form response Iframe data and Set into hidden variables to use in Form response page
    _form.getFormRespIframeDataSuccess = function (iFrameData) {
        if (typeof (iFrameData.LoggedInUserID) != "undefined" && iFrameData.LoggedInUserID > 0) {
            $("#hdnLoggedInUserID").val(iFrameData.LoggedInUserID);
        }
        if (typeof (iFrameData.LoggedInUserName) != "undefined" && iFrameData.LoggedInUserName != null) {
            $("#hdnLoggedInUserName").val(iFrameData.LoggedInUserName);
        }
        if (typeof (iFrameData.UserEmail) != "undefined" && iFrameData.UserEmail != null) {
            $("#hdnUserEmail").val(iFrameData.UserEmail);
        }
        if (typeof (iFrameData.RespBy) != "undefined" && iFrameData.RespBy > 0) {
            $("#hdnRespBy").val(iFrameData.RespBy);
            _loadCCIframe($("#hdnRespBy").val()); // Added by Ashish M. - Project - Add a Payment Field to Forms - 10/07/2020
        }
        if (typeof (iFrameData.RespByName) != "undefined" && iFrameData.RespByName != null) {
            $("#hdnRespByName").val(iFrameData.RespByName);
        }
        if (typeof (iFrameData.BusinessID) != "undefined" && iFrameData.BusinessID > 0) {
            $("#hdnBusinessID").val(iFrameData.BusinessID);
        }
        if (typeof (iFrameData.BusinessName) != "undefined" && iFrameData.BusinessName != null) {
            $("#busName").html(iFrameData.BusinessName);
        }
        if (typeof (iFrameData.BusinessContainer) != "undefined" && iFrameData.BusinessContainer != null) {
            $("#hdnBusinessContainer").val(iFrameData.BusinessContainer);
        }
        if (typeof (iFrameData.BusinessCdnUrl) != "undefined" && iFrameData.BusinessCdnUrl != null) {
            $("#hdnBusinessCdnUrl").val(iFrameData.BusinessCdnUrl);
        }

        if (typeof (iFrameData.FormType) != "undefined" && iFrameData.FormType != null) {
            $("#hdnFormType").val(iFrameData.FormType);
        }
        var strCity = "", strState = "";
        if (typeof (iFrameData.BusinessCity) != "undefined" && iFrameData.BusinessCity != null) {
            strCity = iFrameData.BusinessCity;
        }
        if (typeof (iFrameData.BusinessState) != "undefined" && iFrameData.BusinessState != null) {
            strState = iFrameData.BusinessState;
        }

        if (strCity != "" || strState != "") {
            $("#busAddress").html(_form.combineCityState(strCity, strState));
        }

        if (typeof (iFrameData.BusinessImage) != "undefined" && iFrameData.BusinessImage != null) {
            $("#busImage").css("background-image", "url('" + iFrameData.BusinessImage + "')");
        }

        if (typeof (iFrameData.BusinessGroup) != "undefined" && iFrameData.BusinessGroup != null) {
            $("#hdnBusinessGroupID").val(iFrameData.BusinessGroup);
        }
        if (typeof (iFrameData.Device) != "undefined" && iFrameData.Device != "") {
            $("#hdnDevice").val(iFrameData.Device); // Added by Ashish M. : Task #68677
        }
        if (typeof (iFrameData.ApptServiceIds) != "undefined" && iFrameData.ApptServiceIds != "") {
            $("#hdnApptServiceIds").val(iFrameData.ApptServiceIds); // Added by Nirav Savariya. : Save Serviceid in form_response collection on 31/07/2020.
        }
        if (typeof (iFrameData.IsOnlineForm) != "undefined" && iFrameData.IsOnlineForm != "") {
            $("#hdnIsOnlineForm").val(iFrameData.IsOnlineForm); // Added by Nirav Savariya. : Save Serviceid in form_response collection on 31/07/2020.
            if ($("#hdnIsOnlineForm").val().toLowerCase() == "true") {
                $(".ImageEditorIcone").hide();
            }
        }
    }
    // To Combine City and State with Comma
    _form.combineCityState = function (strCity, strState) {
        if (typeof strState == "undefined" || strState == null) {
            strState = "";
        }

        if (typeof strCity != "undefined" && strCity != null && strCity != "") {
            return (strCity + ", " + strState.toUpperCase());
        }
        else {
            return strState.toUpperCase();
        }
    }

    // Called when Custom Submit Form button from Vagaro is clicked to save form response
    _form.submitForm = function () {
        _formResp.callSaveResp(null,
            //function (res) {
            //    if (res == 'BUM') {
            //        var maintenanceURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/common/schedulemaintenance/";
            //        window.location.replace(maintenanceURl);
            //        //_formResp.showMessage("We are currently undergoing maintenance. This won't take long.", "error");
            //    }
            //    else {
            //        _formResp.showLoadingPanel(false);
            //        frm.submitFormResponse(res, true);
            //    }
            //}
            _formResp.saveFormRespSuccess
            ,
            //function (res)
            //{
            //    _formResp.showLoadingPanel(false);
            //    frm.submitFormResponse("",true);
            //}
            _formResp.saveFilesRespFailed
            ,
            "listenersubmitform");
    }

    _form.NextSign = function () {
        _formResp.NextButton();
    }

    // Ankit Patel
    // save all forms response
    _form.submitAllForm = function (formsRes) {
        _formResp.callSaveResp(formsRes,
            //function (res) {
            //    if (res == 'BUM') {
            //        var maintenanceURl = location.protocol + "//" + location.hostname + (location.port && ":" + location.port) + "/common/schedulemaintenance/";
            //        window.location.replace(maintenanceURl);
            //        //_formResp.showMessage("We are currently undergoing maintenance. This won't take long.", "error");
            //    }
            //    else {
            //        _formResp.showLoadingPanel(false);
            //        frm.submitFormResponse(res, false);
            //    }
            //}
            _formResp.saveFormRespSuccess
            ,
            //function (res) {
            //    _formResp.showLoadingPanel(false);
            //    frm.submitFormResponse("",false);
            //}
            _formResp.saveFilesRespFailed
            ,
            "listenersubmitallform");
    }
    // Created By:- karangiri goswami
    // Get Services and Classes from vagaro
    _form.responseServiceAndClassData = function (data) {
        _formTemp.responseServiceAndClassData(data);
    }

    // Created By:- Parth Savadiya
    // Get Memberships from vagaro
    _form.responseMembershipData = function (data) {
        _formTemp.BindMembershipData(data);
    }

    // Created By:- karangiri goswami
    // Get Business Types from vagaro
    _form.responseBusinessTypes = function (data) { //By :-karangiri goswami
        _formTemp.responseBusinessTypes(data);
    }

    // Hide Vagaro Business Details at Header and Save button at footer
    _form.hideHeaderandFooter = function () {
        $("body").addClass("header-footer-hide hideHeaderandFooter");
    }

    // Ankit Patel Add Class in Body
    _form.addClassInFormsBody = function (data) {
        $("body").addClass(data);
    }
    _form.addClassInFormsHtml = function (data) {
        $("html").addClass(data);
    }
    _form.GetRentContractHeight = function () {
        var rentformheight = $('#divFormContentArea')[0].scrollHeight;
        frm.SendCallbackOfGetRentContractHeight(rentformheight);
    }
    // Show Vagaro Business Details at Header and Save button at footer
    _form.showHeaderandFooter = function (flagShowHeader) {
        if (typeof (flagShowHeader) == "undefined" || flagShowHeader == null || flagShowHeader == true) {
            //Display submit button and business detail
            $("body").removeClass("hideHeaderandFooter header-footer-hide");
        }
        else {
            //Hide submit button and business detail
            $("body").addClass("hideHeaderandFooter header-footer-hide");
        }
    }

    //Display business detail header
    _form.showHeader = function (flagShow) {
        if (typeof (flagShow) == "undefined" || flagShow == null || flagShow == true) {
            //Display business detail
            $("body").removeClass("header-footer-hide");
        }
        else {
            //Hide business detail
            $("body").addClass("header-footer-hide");
        }
    }

    // Get Loggedin User Details from Vagaro 
    _form.sendLoginUseDetails = function (data) {
        $("#hdnLoginUserID").val(data.LoginUserID);
        $("#hdnLoggedInUserID").val(data.LoginUserID);
        $("#hdnLoginUserName").val(data.UserName);
        $("#hdnLoggedInUserName").val(data.UserName);
        $("#hdnBusinessID").val(data.BusinessID);
        $("#hdnCallFrom").val(data.CallFrom);  // Added By Krishnan on 1-10-2019 Form Scrolling Issue Resolved
        if (data.LoginUserID > 0 && $("#loginRequired") != null && $("#loginRequired").length > 0) {
            $("#loginRequired").modal("hide");
        }
        try {

            if (typeof data.isLoadCCIframe != 'undefined' && data.isLoadCCIframe == 'true') {
                _loadCCIframe(data.LoginUserID);
            }
        }
        catch (ex) {
            console.log("error");
        }

        if (typeof data.ResBy != 'undefined') {
            $("#hdnRespBy").val(data.ResBy);
        }
        else {
            $("#hdnRespBy").val(data.LoginUserID);
        }
        if (typeof data.ResByName != 'undefined') {
            $("#hdnRespByName").val(data.ResByName);
        } //New Added services Id before single form submit
        if (typeof data.ServiceId != 'undefined' && String.isNullOrUndefineOrBlank(data.AppointmentId)) { //Added Condition for check if code not Apppointment id not passed then it will work same as old code - Form Always Required
            $("#hdnServiceId").val(data.ServiceId);
        }
        if (typeof data.ApptServiceIds != "undefined") {
            $("#hdnApptServiceIds").val(data.ApptServiceIds); // Added by Nirav Savariya. : Save Appointmentid in form_response collection on 31/07/2020.
        }
        if (typeof data.IsOnlineForm != "undefined") {
            $("#hdnIsOnlineForm").val(data.IsOnlineForm); // Added by Nirav Savariya. : Save Serviceid in form_response collection on 31/07/2020.
            if ($("#hdnIsOnlineForm").val().toLowerCase() == "true") {
                $(".ImageEditorIcone").hide();
            }
        }
    }

    //Show Popup on Center (Not in use currently)
    _form.setCenterPopup = function (screenObject) {
        if ($(".merchantPopupoverlay:visible").length > 0) {
            _form.centerModal(".merchantPopupoverlay:visible", screenObject);
        }
        else {
            _form.centerModal(".bootbox.modal", screenObject);
        }
    }
    //Set Center modal
    _form.centerModal = function (obj, screenObject) {

        //if ($(obj).find("input").is(":focus").length > 0)
        var screenheight;
        var screenoffset;
        var headeroffset;
        var divgotit = false;
        if (screenObject != null) {
            screenheight = screenObject.objScreen;
            screenoffset = screenObject.topoffset;
            headeroffset = screenObject.headeroffset;
            divgotit = screenObject.divgotit;
        }

        if (screenheight != null && parseInt(screenheight) <= 500) {
            $("body").addClass("small-heightmobile");
        } else {
            $("body").removeClass("small-heightmobile");
        }

        var $dialog;
        if ($(obj).hasClass("merchantPopupoverlay")) {
            $dialog = $(obj)
        }
        else {
            $dialog = $(obj).find(".modal-dialog");
        }

        var height = screen.availHeight
        if (screenheight != null && screenheight != undefined) {
            height = parseInt(screenheight);
        }

        var footerHeight = 0;
        if (iosandroidpro && $(".zs-btnsubmit").css("display") == "none") {
            footerHeight = 60;
        }

        if (typeof (window_top) === "undefined" || typeof (window_top) !== "number") window_top = 0;
        var offset = window_top + (height - $dialog.height()) / 2;
        if (divgotit == "true") {       // For website      
            $dialog.css("margin-top", parseInt(offset) - parseInt(headeroffset) + parseInt(screenoffset) - parseInt(parseInt(50)));
        }
        else {
            if (footerHeight > 0) {      // For webversion          
                $dialog.css("margin-top", parseInt(offset) - parseInt(headeroffset) + parseInt(screenoffset) - parseInt(50));
            }
            else {                // For Mobile
                $dialog.css("margin-top", parseInt(offset) - parseInt(headeroffset) + parseInt(screenoffset) + parseInt(50));
            }
        }


        if ($(obj).attr("id") == "divAddressPopup") {
            $dialog.css("max-height", parseInt(screenheight - 20));
        }
    }

    //add custom style to header
    _form.addStyle = function (pstyle) {
        var head = document.head || document.getElementsByTagName('head')[0];
        style = document.createElement('style');

        style.type = 'text/css';
        if (style.styleSheet) {
            style.styleSheet.cssText = pstyle;
        } else {
            style.appendChild(document.createTextNode(pstyle));
        }

        head.appendChild(style);
    }

    // Called when Iframe is loaded
    _form.frameLoaded = function () {
        frm.iframe_Loaded();
    }

    _form.centerModalPopup = function (obj) {
        if (obj == undefined) {
            obj = this;
        }
        $(obj).css('display', 'block');
        var $dialog = $(obj).not(".in").find(".modal-dialog");
        if ($dialog.length == 0)
            $dialog = $(obj).find(".modal-dialog");

        var selector = window;
        if ($(obj).closest(".modal-dialog").length > 0)
            selector = $(obj).closest(".modal-dialog");
        var height = Math.min($(selector).height(), screen.availHeight);
        if (typeof (window_top) === "undefined" || typeof (window_top) !== "number") window_top = 0;
        var offset = window_top + (height - $dialog.height()) / 2;
        $dialog.css("margin-top", offset);
    }

    //Project:- Vagaro Forms
    //Created By:- Ankit Patel
    //Reason:- Open individual form response detail popup
    _form.getDetails = function () {
        var popup = $('#formResponseDetailPopup');
        popup.on('shown.bs.modal', _form.centerModalPopup(popup)).modal("show");
    }

    // Ankit Patel
    // Callback from Mobile for Delete and Details Form Response
    _form.getDetailsAndDeleteFormResponseForMobile = function (data) {

        if (data != undefined && data != null) {
            $("#hdnFormresponseId").val(data.FormRespId);
            $("#hdnBusinessID").val(data.BusinessID);
            $("#hdnLoginUserID").val(data.LoggedInUserID);
            $("#hdnLoginUserName").val(data.LoggedInUserName);
            if (data.Type == 'delete') {
                _formResp.DeleteFormResponseConfirm();
            }
            else if (data.Type == 'detail') {
                _form.getDetails();
            }
        }
    }

    //Called when Preview button cliecked from Rent and Fees Page for proview of the form
    _form.getFormPreview = function () {
        $(".divformcontentwrapper").scrollTop(0);
        if (deviceIsMobile) {
            $("#divFormValidator a[data-href ='#mobilePreview']").trigger('click');
        } else {
            $("#divFormValidator a[data-href ='#desktoPreview']").trigger('click');
        }
    }
    _form.setPreviewFlag = function () {
        $("#tabheight").hide();
        $(".vg-default-tab-link").hide();
        if (typeof model !== 'undefined') {
            model.IsPreview = true;
        }
    }
    //_form.setsignaturedatetime = function (date) {
    //    $('.lblUserDate').text(date);
    //}
})(jQuery, window, document);
//////////////////////////////////////// Calling Methods - End ///////////////////////////////////////////;
(function(e){Array.prototype.map||(Array.prototype.map=function(e,r){var a,o,i;if(null==this)throw new TypeError(" this is null or not defined");var n=Object(this),t=n.length>>>0;if("function"!=typeof e)throw new TypeError(e+" is not a function");for(r&&(a=r),o=Array(t),i=0;t>i;){var l,c;i in n&&(l=n[i],c=e.call(a,l,i,n),o[i]=c),i++}return o});var r=e.detect=function(){var e=function(){},r={browser_parsers:[{regex:"^(Opera)/(\\d+)\\.(\\d+) \\(Nintendo Wii",family_replacement:"Wii",manufacturer:"Nintendo"},{regex:"(SeaMonkey|Camino)/(\\d+)\\.(\\d+)\\.?([ab]?\\d+[a-z]*)",family_replacement:"Camino",other:!0},{regex:"(Pale[Mm]oon)/(\\d+)\\.(\\d+)\\.?(\\d+)?",family_replacement:"Pale Moon (Firefox Variant)",other:!0},{regex:"(Fennec)/(\\d+)\\.(\\d+)\\.?([ab]?\\d+[a-z]*)",family_replacement:"Firefox Mobile"},{regex:"(Fennec)/(\\d+)\\.(\\d+)(pre)",family_replacment:"Firefox Mobile"},{regex:"(Fennec)/(\\d+)\\.(\\d+)",family_replacement:"Firefox Mobile"},{regex:"Mobile.*(Firefox)/(\\d+)\\.(\\d+)",family_replacement:"Firefox Mobile"},{regex:"(Namoroka|Shiretoko|Minefield)/(\\d+)\\.(\\d+)\\.(\\d+(?:pre)?)",family_replacement:"Firefox ($1)"},{regex:"(Firefox)/(\\d+)\\.(\\d+)(a\\d+[a-z]*)",family_replacement:"Firefox Alpha"},{regex:"(Firefox)/(\\d+)\\.(\\d+)(b\\d+[a-z]*)",family_replacement:"Firefox Beta"},{regex:"(Firefox)-(?:\\d+\\.\\d+)?/(\\d+)\\.(\\d+)(a\\d+[a-z]*)",family_replacement:"Firefox Alpha"},{regex:"(Firefox)-(?:\\d+\\.\\d+)?/(\\d+)\\.(\\d+)(b\\d+[a-z]*)",family_replacement:"Firefox Beta"},{regex:"(Namoroka|Shiretoko|Minefield)/(\\d+)\\.(\\d+)([ab]\\d+[a-z]*)?",family_replacement:"Firefox ($1)"},{regex:"(Firefox).*Tablet browser (\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"MicroB",tablet:!0},{regex:"(MozillaDeveloperPreview)/(\\d+)\\.(\\d+)([ab]\\d+[a-z]*)?"},{regex:"(Flock)/(\\d+)\\.(\\d+)(b\\d+?)",family_replacement:"Flock",other:!0},{regex:"(RockMelt)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Rockmelt",other:!0},{regex:"(Navigator)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Netscape"},{regex:"(Navigator)/(\\d+)\\.(\\d+)([ab]\\d+)",family_replacement:"Netscape"},{regex:"(Netscape6)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Netscape"},{regex:"(MyIBrow)/(\\d+)\\.(\\d+)",family_replacement:"My Internet Browser",other:!0},{regex:"(Opera Tablet).*Version/(\\d+)\\.(\\d+)(?:\\.(\\d+))?",family_replacement:"Opera Tablet",tablet:!0},{regex:"(Opera)/.+Opera Mobi.+Version/(\\d+)\\.(\\d+)",family_replacement:"Opera Mobile"},{regex:"Opera Mobi",family_replacement:"Opera Mobile"},{regex:"(Opera Mini)/(\\d+)\\.(\\d+)",family_replacement:"Opera Mini"},{regex:"(Opera Mini)/att/(\\d+)\\.(\\d+)",family_replacement:"Opera Mini"},{regex:"(Opera)/9.80.*Version/(\\d+)\\.(\\d+)(?:\\.(\\d+))?",family_replacement:"Opera"},{regex:"(webOSBrowser)/(\\d+)\\.(\\d+)",family_replacement:"webOS"},{regex:"(webOS)/(\\d+)\\.(\\d+)",family_replacement:"webOS"},{regex:"(wOSBrowser).+TouchPad/(\\d+)\\.(\\d+)",family_replacement:"webOS TouchPad"},{regex:"(luakit)",family_replacement:"LuaKit",other:!0},{regex:"(Lightning)/(\\d+)\\.(\\d+)([ab]?\\d+[a-z]*)",family_replacement:"Lightning",other:!0},{regex:"(Firefox)/(\\d+)\\.(\\d+)\\.(\\d+(?:pre)?) \\(Swiftfox\\)",family_replacement:"Swiftfox",other:!0},{regex:"(Firefox)/(\\d+)\\.(\\d+)([ab]\\d+[a-z]*)? \\(Swiftfox\\)",family_replacement:"Swiftfox",other:!0},{regex:"rekonq",family_replacement:"Rekonq",other:!0},{regex:"(conkeror|Conkeror)/(\\d+)\\.(\\d+)\\.?(\\d+)?",family_replacement:"Conkeror",other:!0},{regex:"(konqueror)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Konqueror",other:!0},{regex:"(WeTab)-Browser",family_replacement:"WeTab",other:!0},{regex:"(Comodo_Dragon)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Comodo Dragon",other:!0},{regex:"(YottaaMonitor)",family_replacement:"Yottaa Monitor",other:!0},{regex:"(Kindle)/(\\d+)\\.(\\d+)",family_replacement:"Kindle"},{regex:"(Symphony) (\\d+).(\\d+)",family_replacement:"Symphony",other:!0},{regex:"Minimo",family_replacement:"Minimo",other:!0},{regex:"(CrMo)/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Chrome Mobile"},{regex:"(CriOS)/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Chrome Mobile iOS"},{regex:"(Chrome)/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+) Mobile",family_replacement:"Chrome Mobile"},{regex:"(chromeframe)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Chrome Frame"},{regex:"(UC Browser)(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"UC Browser",other:!0},{regex:"(SLP Browser)/(\\d+)\\.(\\d+)",family_replacement:"Tizen Browser",other:!0},{regex:"(Epiphany)/(\\d+)\\.(\\d+).(\\d+)",family_replacement:"Epiphany",other:!0},{regex:"(SE 2\\.X) MetaSr (\\d+)\\.(\\d+)",family_replacement:"Sogou Explorer",other:!0},{regex:"(Pingdom.com_bot_version_)(\\d+)\\.(\\d+)",family_replacement:"PingdomBot",other:!0},{regex:"(facebookexternalhit)/(\\d+)\\.(\\d+)",family_replacement:"FacebookBot"},{regex:"(Twitterbot)/(\\d+)\\.(\\d+)",family_replacement:"TwitterBot"},{regex:"(AdobeAIR|Chromium|FireWeb|Jasmine|ANTGalio|Midori|Fresco|Lobo|PaleMoon|Maxthon|Lynx|OmniWeb|Dillo|Camino|Demeter|Fluid|Fennec|Shiira|Sunrise|Chrome|Flock|Netscape|Lunascape|WebPilot|NetFront|Netfront|Konqueror|SeaMonkey|Kazehakase|Vienna|Iceape|Iceweasel|IceWeasel|Iron|K-Meleon|Sleipnir|Galeon|GranParadiso|Opera Mini|iCab|NetNewsWire|ThunderBrowse|Iron|Iris|UP\\.Browser|Bunjaloo|Google Earth|Raven for Mac)/(\\d+)\\.(\\d+)\\.(\\d+)"},{regex:"(Bolt|Jasmine|IceCat|Skyfire|Midori|Maxthon|Lynx|Arora|IBrowse|Dillo|Camino|Shiira|Fennec|Phoenix|Chrome|Flock|Netscape|Lunascape|Epiphany|WebPilot|Opera Mini|Opera|NetFront|Netfront|Konqueror|Googlebot|SeaMonkey|Kazehakase|Vienna|Iceape|Iceweasel|IceWeasel|Iron|K-Meleon|Sleipnir|Galeon|GranParadiso|iCab|NetNewsWire|Iron|Space Bison|Stainless|Orca|Dolfin|BOLT|Minimo|Tizen Browser|Polaris)/(\\d+)\\.(\\d+)"},{regex:"(iRider|Crazy Browser|SkipStone|iCab|Lunascape|Sleipnir|Maemo Browser) (\\d+)\\.(\\d+)\\.(\\d+)"},{regex:"(iCab|Lunascape|Opera|Android|Jasmine|Polaris|BREW) (\\d+)\\.(\\d+)\\.?(\\d+)?"},{regex:"(Android) Donut",v2_replacement:"2",v1_replacement:"1"},{regex:"(Android) Eclair",v2_replacement:"1",v1_replacement:"2"},{regex:"(Android) Froyo",v2_replacement:"2",v1_replacement:"2"},{regex:"(Android) Gingerbread",v2_replacement:"3",v1_replacement:"2"},{regex:"(Android) Honeycomb",v1_replacement:"3"},{regex:"(IEMobile)[ /](\\d+)\\.(\\d+)",family_replacement:"IE Mobile"},{regex:"(MSIE) (\\d+)\\.(\\d+).*XBLWP7",family_replacement:"IE Large Screen"},{regex:"(Firefox)/(\\d+)\\.(\\d+)\\.(\\d+)"},{regex:"(Firefox)/(\\d+)\\.(\\d+)(pre|[ab]\\d+[a-z]*)?"},{regex:"(Obigo)InternetBrowser",other:!0},{regex:"(Obigo)\\-Browser",other:!0},{regex:"(Obigo|OBIGO)[^\\d]*(\\d+)(?:.(\\d+))?",other:!0},{regex:"(MAXTHON|Maxthon) (\\d+)\\.(\\d+)",family_replacement:"Maxthon",other:!0},{regex:"(Maxthon|MyIE2|Uzbl|Shiira)",v1_replacement:"0",other:!0},{regex:"(PLAYSTATION) (\\d+)",family_replacement:"PlayStation",manufacturer:"Sony"},{regex:"(PlayStation Portable)[^\\d]+(\\d+).(\\d+)",manufacturer:"Sony"},{regex:"(BrowseX) \\((\\d+)\\.(\\d+)\\.(\\d+)",other:!0},{regex:"(POLARIS)/(\\d+)\\.(\\d+)",family_replacement:"Polaris",other:!0},{regex:"(Embider)/(\\d+)\\.(\\d+)",family_replacement:"Polaris",other:!0},{regex:"(BonEcho)/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Bon Echo",other:!0},{regex:"(iPod).+Version/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Mobile Safari",manufacturer:"Apple"},{regex:"(iPod).*Version/(\\d+)\\.(\\d+)",family_replacement:"Mobile Safari",manufacturer:"Apple"},{regex:"(iPod)",family_replacement:"Mobile Safari",manufacturer:"Apple"},{regex:"(iPhone).*Version/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Mobile Safari",manufacturer:"Apple"},{regex:"(iPhone).*Version/(\\d+)\\.(\\d+)",family_replacement:"Mobile Safari",manufacturer:"Apple"},{regex:"(iPhone)",family_replacement:"Mobile Safari",manufacturer:"Apple"},{regex:"(iPad).*Version/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Mobile Safari",tablet:!0,manufacturer:"Apple"},{regex:"(iPad).*Version/(\\d+)\\.(\\d+)",family_replacement:"Mobile Safari",tablet:!0,manufacturer:"Apple"},{regex:"(iPad)",family_replacement:"Mobile Safari",tablet:!0,manufacturer:"Apple"},{regex:"(AvantGo) (\\d+).(\\d+)",other:!0},{regex:"(Avant)",v1_replacement:"1",other:!0},{regex:"^(Nokia)",family_replacement:"Nokia Services (WAP) Browser",manufacturer:"Nokia"},{regex:"(NokiaBrowser)/(\\d+)\\.(\\d+).(\\d+)\\.(\\d+)",manufacturer:"Nokia"},{regex:"(NokiaBrowser)/(\\d+)\\.(\\d+).(\\d+)",manufacturer:"Nokia"},{regex:"(NokiaBrowser)/(\\d+)\\.(\\d+)",manufacturer:"Nokia"},{regex:"(BrowserNG)/(\\d+)\\.(\\d+).(\\d+)",family_replacement:"NokiaBrowser",manufacturer:"Nokia"},{regex:"(Series60)/5\\.0",v2_replacement:"0",v1_replacement:"7",family_replacement:"NokiaBrowser",manufacturer:"Nokia"},{regex:"(Series60)/(\\d+)\\.(\\d+)",family_replacement:"Nokia OSS Browser",manufacturer:"Nokia"},{regex:"(S40OviBrowser)/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Nokia Series 40 Ovi Browser",manufacturer:"Nokia"},{regex:"(Nokia)[EN]?(\\d+)",manufacturer:"Nokia"},{regex:"(PlayBook).+RIM Tablet OS (\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Blackberry WebKit",tablet:!0,manufacturer:"Nokia"},{regex:"(Black[bB]erry).+Version/(\\d+)\\.(\\d+)\\.(\\d+)",family_replacement:"Blackberry WebKit",manufacturer:"RIM"},{regex:"(Black[bB]erry)\\s?(\\d+)",family_replacement:"Blackberry",manufacturer:"RIM"},{regex:"(OmniWeb)/v(\\d+)\\.(\\d+)",other:!0},{regex:"(Blazer)/(\\d+)\\.(\\d+)",family_replacement:"Palm Blazer",manufacturer:"Palm"},{regex:"(Pre)/(\\d+)\\.(\\d+)",family_replacement:"Palm Pre",manufacturer:"Palm"},{regex:"(Links) \\((\\d+)\\.(\\d+)",other:!0},{regex:"(QtWeb) Internet Browser/(\\d+)\\.(\\d+)",other:!0},{regex:"(Silk)/(\\d+)\\.(\\d+)(?:\\.([0-9\\-]+))?",other:!0,tablet:!0},{regex:"(AppleWebKit)/(\\d+)\\.?(\\d+)?\\+ .* Version/\\d+\\.\\d+.\\d+ Safari/",family_replacement:"WebKit Nightly"},{regex:"(Version)/(\\d+)\\.(\\d+)(?:\\.(\\d+))?.*Safari/",family_replacement:"Safari"},{regex:"(Safari)/\\d+"},{regex:"(OLPC)/Update(\\d+)\\.(\\d+)",other:!0},{regex:"(OLPC)/Update()\\.(\\d+)",v1_replacement:"0",other:!0},{regex:"(SEMC\\-Browser)/(\\d+)\\.(\\d+)",other:!0},{regex:"(Teleca)",family_replacement:"Teleca Browser",other:!0},{regex:"Trident(.*)rv.(\\d+)\\.(\\d+)",family_replacement:"IE"},{regex:"(MSIE) (\\d+)\\.(\\d+)",family_replacement:"IE"}],os_parsers:[{regex:"(Android) (\\d+)\\.(\\d+)(?:[.\\-]([a-z0-9]+))?"},{regex:"(Android)\\-(\\d+)\\.(\\d+)(?:[.\\-]([a-z0-9]+))?"},{regex:"(Android) Donut",os_v2_replacement:"2",os_v1_replacement:"1"},{regex:"(Android) Eclair",os_v2_replacement:"1",os_v1_replacement:"2"},{regex:"(Android) Froyo",os_v2_replacement:"2",os_v1_replacement:"2"},{regex:"(Android) Gingerbread",os_v2_replacement:"3",os_v1_replacement:"2"},{regex:"(Android) Honeycomb",os_v1_replacement:"3"},{regex:"(Silk-Accelerated=[a-z]{4,5})",os_replacement:"Android"},{regex:"(Windows Phone 6\\.5)"},{regex:"(Windows (?:NT 5\\.2|NT 5\\.1))",os_replacement:"Windows XP"},{regex:"(XBLWP7)",os_replacement:"Windows Phone OS"},{regex:"(Windows NT 6\\.1)",os_replacement:"Windows 7"},{regex:"(Windows NT 6\\.0)",os_replacement:"Windows Vista"},{regex:"(Windows 98|Windows XP|Windows ME|Windows 95|Windows CE|Windows 7|Windows NT 4\\.0|Windows Vista|Windows 2000)"},{regex:"(Windows NT 6\\.2)",os_replacement:"Windows 8"},{regex:"(Windows Phone 8)",os_replacement:"Windows Phone 8"},{regex:"(Windows NT 5\\.0)",os_replacement:"Windows 2000"},{regex:"(Windows Phone OS) (\\d+)\\.(\\d+)"},{regex:"(Windows ?Mobile)",os_replacement:"Windows Mobile"},{regex:"(WinNT4.0)",os_replacement:"Windows NT 4.0"},{regex:"(Win98)",os_replacement:"Windows 98"},{regex:"(Tizen)/(\\d+)\\.(\\d+)",other:!0},{regex:"(Mac OS X) (\\d+)[_.](\\d+)(?:[_.](\\d+))?",manufacturer:"Apple"},{regex:"(?:PPC|Intel) (Mac OS X)",manufacturer:"Apple"},{regex:"(CPU OS|iPhone OS) (\\d+)_(\\d+)(?:_(\\d+))?",os_replacement:"iOS",manufacturer:"Apple"},{regex:"(iPhone|iPad|iPod); Opera",os_replacement:"iOS",manufacturer:"Apple"},{regex:"(iPad); Opera",tablet:!0,manufacturer:"Apple"},{regex:"(iPhone|iPad|iPod).*Mac OS X.*Version/(\\d+)\\.(\\d+)",os_replacement:"iOS",manufacturer:"Apple"},{regex:"(CrOS) [a-z0-9_]+ (\\d+)\\.(\\d+)(?:\\.(\\d+))?",os_replacement:"Chrome OS"},{regex:"(Debian)-(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.(\\d+))?",other:!0},{regex:"(Linux Mint)(?:/(\\d+))?",other:!0},{regex:"(Mandriva)(?: Linux)?/(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.(\\d+))?",other:!0},{regex:"(Symbian[Oo][Ss])/(\\d+)\\.(\\d+)",os_replacement:"Symbian OS"},{regex:"(Symbian/3).+NokiaBrowser/7\\.3",os_replacement:"Symbian^3 Anna"},{regex:"(Symbian/3).+NokiaBrowser/7\\.4",os_replacement:"Symbian^3 Belle"},{regex:"(Symbian/3)",os_replacement:"Symbian^3"},{regex:"(Series 60|SymbOS|S60)",os_replacement:"Symbian OS"},{regex:"(MeeGo)",other:!0},{regex:"Symbian [Oo][Ss]",os_replacement:"Symbian OS"},{regex:"(Black[Bb]erry)[0-9a-z]+/(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.(\\d+))?",os_replacement:"BlackBerry OS",manufacturer:"RIM"},{regex:"(Black[Bb]erry).+Version/(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.(\\d+))?",os_replacement:"BlackBerry OS",manufacturer:"RIM"},{regex:"(RIM Tablet OS) (\\d+)\\.(\\d+)\\.(\\d+)",os_replacement:"BlackBerry Tablet OS",tablet:!0,manufacturer:"RIM"},{regex:"(Play[Bb]ook)",os_replacement:"BlackBerry Tablet OS",tablet:!0,manufacturer:"RIM"},{regex:"(Black[Bb]erry)",os_replacement:"Blackberry OS",manufacturer:"RIM"},{regex:"(webOS|hpwOS)/(\\d+)\\.(\\d+)(?:\\.(\\d+))?",os_replacement:"webOS"},{regex:"(SUSE|Fedora|Red Hat|PCLinuxOS)/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)",other:!0},{regex:"(SUSE|Fedora|Red Hat|Puppy|PCLinuxOS|CentOS)/(\\d+)\\.(\\d+)\\.(\\d+)",other:!0},{regex:"(Ubuntu|Kindle|Bada|Lubuntu|BackTrack|Red Hat|Slackware)/(\\d+)\\.(\\d+)"},{regex:"(Windows|OpenBSD|FreeBSD|NetBSD|Ubuntu|Kubuntu|Android|Arch Linux|CentOS|WeTab|Slackware)"},{regex:"(Linux|BSD)",other:!0}],mobile_os_families:["Windows Phone 6.5","Windows CE","Symbian OS"],device_parsers:[{regex:"HTC ([A-Z][a-z0-9]+) Build",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"HTC ([A-Z][a-z0-9 ]+) \\d+\\.\\d+\\.\\d+\\.\\d+",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"HTC_Touch_([A-Za-z0-9]+)",device_replacement:"HTC Touch ($1)",manufacturer:"HTC"},{regex:"USCCHTC(\\d+)",device_replacement:"HTC $1 (US Cellular)",manufacturer:"HTC"},{regex:"Sprint APA(9292)",device_replacement:"HTC $1 (Sprint)",manufacturer:"HTC"},{regex:"HTC ([A-Za-z0-9]+ [A-Z])",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"HTC-([A-Za-z0-9]+)",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"HTC_([A-Za-z0-9]+)",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"HTC ([A-Za-z0-9]+)",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"(ADR[A-Za-z0-9]+)",device_replacement:"HTC $1",manufacturer:"HTC"},{regex:"(HTC)",manufacturer:"HTC"},{regex:"SonyEricsson([A-Za-z0-9]+)/",device_replacement:"Ericsson $1",other:!0,manufacturer:"Sony"},{regex:"Android[\\- ][\\d]+\\.[\\d]+\\; [A-Za-z]{2}\\-[A-Za-z]{2}\\; WOWMobile (.+) Build"},{regex:"Android[\\- ][\\d]+\\.[\\d]+\\.[\\d]+; [A-Za-z]{2}\\-[A-Za-z]{2}\\; (.+) Build"},{regex:"Android[\\- ][\\d]+\\.[\\d]+\\-update1\\; [A-Za-z]{2}\\-[A-Za-z]{2}\\; (.+) Build"},{regex:"Android[\\- ][\\d]+\\.[\\d]+\\; [A-Za-z]{2}\\-[A-Za-z]{2}\\; (.+) Build"},{regex:"Android[\\- ][\\d]+\\.[\\d]+\\.[\\d]+; (.+) Build"},{regex:"NokiaN([0-9]+)",device_replacement:"Nokia N$1",manufacturer:"Nokia"},{regex:"Nokia([A-Za-z0-9\\v-]+)",device_replacement:"Nokia $1",manufacturer:"Nokia"},{regex:"NOKIA ([A-Za-z0-9\\-]+)",device_replacement:"Nokia $1",manufacturer:"Nokia"},{regex:"Nokia ([A-Za-z0-9\\-]+)",device_replacement:"Nokia $1",manufacturer:"Nokia"},{regex:"Lumia ([A-Za-z0-9\\-]+)",device_replacement:"Lumia $1",manufacturer:"Nokia"},{regex:"Symbian",device_replacement:"Nokia",manufacturer:"Nokia"},{regex:"(PlayBook).+RIM Tablet OS",device_replacement:"Blackberry Playbook",tablet:!0,manufacturer:"RIM"},{regex:"(Black[Bb]erry [0-9]+);",manufacturer:"RIM"},{regex:"Black[Bb]erry([0-9]+)",device_replacement:"BlackBerry $1",manufacturer:"RIM"},{regex:"(Pre)/(\\d+)\\.(\\d+)",device_replacement:"Palm Pre",manufacturer:"Palm"},{regex:"(Pixi)/(\\d+)\\.(\\d+)",device_replacement:"Palm Pixi",manufacturer:"Palm"},{regex:"(Touchpad)/(\\d+)\\.(\\d+)",device_replacement:"HP Touchpad",manufacturer:"HP"},{regex:"HPiPAQ([A-Za-z0-9]+)/(\\d+).(\\d+)",device_replacement:"HP iPAQ $1",manufacturer:"HP"},{regex:"Palm([A-Za-z0-9]+)",device_replacement:"Palm $1",manufacturer:"Palm"},{regex:"Treo([A-Za-z0-9]+)",device_replacement:"Palm Treo $1",manufacturer:"Palm"},{regex:"webOS.*(P160UNA)/(\\d+).(\\d+)",device_replacement:"HP Veer",manufacturer:"HP"},{regex:"(Kindle Fire)",manufacturer:"Amazon"},{regex:"(Kindle)",manufacturer:"Amazon"},{regex:"(Silk)/(\\d+)\\.(\\d+)(?:\\.([0-9\\-]+))?",device_replacement:"Kindle Fire",tablet:!0,manufacturer:"Amazon"},{regex:"(iPad) Simulator;",manufacturer:"Apple"},{regex:"(iPad);",manufacturer:"Apple"},{regex:"(iPod);",manufacturer:"Apple"},{regex:"(iPhone) Simulator;",manufacturer:"Apple"},{regex:"(iPhone);",manufacturer:"Apple"},{regex:"Nexus\\ ([A-Za-z0-9\\-]+)",device_replacement:"Nexus $1"},{regex:"acer_([A-Za-z0-9]+)_",device_replacement:"Acer $1",manufacturer:"Acer"},{regex:"acer_([A-Za-z0-9]+)_",device_replacement:"Acer $1",manufacturer:"Acer"},{regex:"Amoi\\-([A-Za-z0-9]+)",device_replacement:"Amoi $1",other:!0,manufacturer:"Amoi"},{regex:"AMOI\\-([A-Za-z0-9]+)",device_replacement:"Amoi $1",other:!0,manufacturer:"Amoi"},{regex:"Asus\\-([A-Za-z0-9]+)",device_replacement:"Asus $1",manufacturer:"Asus"},{regex:"ASUS\\-([A-Za-z0-9]+)",device_replacement:"Asus $1",manufacturer:"Asus"},{regex:"BIRD\\-([A-Za-z0-9]+)",device_replacement:"Bird $1",other:!0},{regex:"BIRD\\.([A-Za-z0-9]+)",device_replacement:"Bird $1",other:!0},{regex:"BIRD ([A-Za-z0-9]+)",device_replacement:"Bird $1",other:!0},{regex:"Dell ([A-Za-z0-9]+)",device_replacement:"Dell $1",manufacturer:"Dell"},{regex:"DoCoMo/2\\.0 ([A-Za-z0-9]+)",device_replacement:"DoCoMo $1",other:!0},{regex:"([A-Za-z0-9]+)\\_W\\;FOMA",device_replacement:"DoCoMo $1",other:!0},{regex:"([A-Za-z0-9]+)\\;FOMA",device_replacement:"DoCoMo $1",other:!0},{regex:"vodafone([A-Za-z0-9]+)",device_replacement:"Huawei Vodafone $1",other:!0},{regex:"i\\-mate ([A-Za-z0-9]+)",device_replacement:"i-mate $1",other:!0},{regex:"Kyocera\\-([A-Za-z0-9]+)",device_replacement:"Kyocera $1",other:!0},{regex:"KWC\\-([A-Za-z0-9]+)",device_replacement:"Kyocera $1",other:!0},{regex:"Lenovo\\-([A-Za-z0-9]+)",device_replacement:"Lenovo $1",manufacturer:"Lenovo"},{regex:"Lenovo\\_([A-Za-z0-9]+)",device_replacement:"Lenovo $1",manufacturer:"Levovo"},{regex:"LG/([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LG-LG([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LGE-LG([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LGE VX([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LG ([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LGE LG\\-AX([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LG\\-([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LGE\\-([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"LG([A-Za-z0-9]+)",device_replacement:"LG $1",manufacturer:"LG"},{regex:"(KIN)\\.One (\\d+)\\.(\\d+)",device_replacement:"Microsoft $1"},{regex:"(KIN)\\.Two (\\d+)\\.(\\d+)",device_replacement:"Microsoft $1"},{regex:"(Motorola)\\-([A-Za-z0-9]+)",manufacturer:"Motorola"},{regex:"MOTO\\-([A-Za-z0-9]+)",device_replacement:"Motorola $1",manufacturer:"Motorola"},{regex:"MOT\\-([A-Za-z0-9]+)",device_replacement:"Motorola $1",manufacturer:"Motorola"},{regex:"Philips([A-Za-z0-9]+)",device_replacement:"Philips $1",manufacturer:"Philips"},{regex:"Philips ([A-Za-z0-9]+)",device_replacement:"Philips $1",manufacturer:"Philips"},{regex:"SAMSUNG-([A-Za-z0-9\\-]+)",device_replacement:"Samsung $1",manufacturer:"Samsung"},{regex:"SAMSUNG\\; ([A-Za-z0-9\\-]+)",device_replacement:"Samsung $1",manufacturer:"Samsung"},{regex:"Softbank/1\\.0/([A-Za-z0-9]+)",device_replacement:"Softbank $1",other:!0},{regex:"Softbank/2\\.0/([A-Za-z0-9]+)",device_replacement:"Softbank $1",other:!0},{regex:"(hiptop|avantgo|plucker|xiino|blazer|elaine|up.browser|up.link|mmp|smartphone|midp|wap|vodafone|o2|pocket|mobile|pda)",device_replacement:"Generic Smartphone"},{regex:"^(1207|3gso|4thp|501i|502i|503i|504i|505i|506i|6310|6590|770s|802s|a wa|acer|acs\\-|airn|alav|asus|attw|au\\-m|aur |aus |abac|acoo|aiko|alco|alca|amoi|anex|anny|anyw|aptu|arch|argo|bell|bird|bw\\-n|bw\\-u|beck|benq|bilb|blac|c55/|cdm\\-|chtm|capi|comp|cond|craw|dall|dbte|dc\\-s|dica|ds\\-d|ds12|dait|devi|dmob|doco|dopo|el49|erk0|esl8|ez40|ez60|ez70|ezos|ezze|elai|emul|eric|ezwa|fake|fly\\-|fly\\_|g\\-mo|g1 u|g560|gf\\-5|grun|gene|go.w|good|grad|hcit|hd\\-m|hd\\-p|hd\\-t|hei\\-|hp i|hpip|hs\\-c|htc |htc\\-|htca|htcg)",device_replacement:"Generic Feature Phone"},{regex:"^(htcp|htcs|htct|htc\\_|haie|hita|huaw|hutc|i\\-20|i\\-go|i\\-ma|i230|iac|iac\\-|iac/|ig01|im1k|inno|iris|jata|java|kddi|kgt|kgt/|kpt |kwc\\-|klon|lexi|lg g|lg\\-a|lg\\-b|lg\\-c|lg\\-d|lg\\-f|lg\\-g|lg\\-k|lg\\-l|lg\\-m|lg\\-o|lg\\-p|lg\\-s|lg\\-t|lg\\-u|lg\\-w|lg/k|lg/l|lg/u|lg50|lg54|lge\\-|lge/|lynx|leno|m1\\-w|m3ga|m50/|maui|mc01|mc21|mcca|medi|meri|mio8|mioa|mo01|mo02|mode|modo|mot |mot\\-|mt50|mtp1|mtv |mate|maxo|merc|mits|mobi|motv|mozz|n100|n101|n102|n202|n203|n300|n302|n500|n502|n505|n700|n701|n710|nec\\-|nem\\-|newg|neon)",device_replacement:"Generic Feature Phone"},{regex:"^(netf|noki|nzph|o2 x|o2\\-x|opwv|owg1|opti|oran|ot\\-s|p800|pand|pg\\-1|pg\\-2|pg\\-3|pg\\-6|pg\\-8|pg\\-c|pg13|phil|pn\\-2|pt\\-g|palm|pana|pire|pock|pose|psio|qa\\-a|qc\\-2|qc\\-3|qc\\-5|qc\\-7|qc07|qc12|qc21|qc32|qc60|qci\\-|qwap|qtek|r380|r600|raks|rim9|rove|s55/|sage|sams|sc01|sch\\-|scp\\-|sdk/|se47|sec\\-|sec0|sec1|semc|sgh\\-|shar|sie\\-|sk\\-0|sl45|slid|smb3|smt5|sp01|sph\\-|spv |spv\\-|sy01|samm|sany|sava|scoo|send|siem|smar|smit|soft|sony|t\\-mo|t218|t250|t600|t610|t618|tcl\\-|tdg\\-|telm|tim\\-|ts70|tsm\\-|tsm3|tsm5|tx\\-9|tagt)",device_replacement:"Generic Feature Phone"},{regex:"^(talk|teli|topl|tosh|up.b|upg1|utst|v400|v750|veri|vk\\-v|vk40|vk50|vk52|vk53|vm40|vx98|virg|vite|voda|vulc|w3c |w3c\\-|wapj|wapp|wapu|wapm|wig |wapi|wapr|wapv|wapy|wapa|waps|wapt|winc|winw|wonu|x700|xda2|xdag|yas\\-|your|zte\\-|zeto|aste|audi|avan|blaz|brew|brvw|bumb|ccwa|cell|cldc|cmd\\-|dang|eml2|fetc|hipt|http|ibro|idea|ikom|ipaq|jbro|jemu|jigs|keji|kyoc|kyok|libw|m\\-cr|midp|mmef|moto|mwbp|mywa|newt|nok6|o2im|pant|pdxg|play|pluc|port|prox|rozo|sama|seri|smal|symb|treo|upsi|vx52|vx53|vx60|vx61|vx70|vx80|vx81|vx83|vx85|wap\\-|webc|whit|wmlb|xda\\-|xda\\_)",device_replacement:"Generic Feature Phone"},{regex:"(bot|borg|google(^tv)|yahoo|slurp|msnbot|msrbot|openbot|archiver|netresearch|lycos|scooter|altavista|teoma|gigabot|baiduspider|blitzbot|oegp|charlotte|furlbot|http%20client|polybot|htdig|ichiro|mogimogi|larbin|pompos|scrubby|searchsight|seekbot|semanticdiscovery|silk|snappy|speedy|spider|voila|vortex|voyager|zao|zeal|fast\\-webcrawler|converacrawler|dataparksearch|findlinks)",device_replacement:"Spider"}],mobile_browser_families:["Firefox Mobile","Opera Mobile","Opera Mini","Mobile Safari","webOS","IE Mobile","Playstation Portable","Nokia","Blackberry","Palm","Silk","Android","Maemo","Obigo","Netfront","AvantGo","Teleca","SEMC-Browser","Bolt","Iris","UP.Browser","Symphony","Minimo","Bunjaloo","Jasmine","Dolfin","Polaris","BREW","Chrome Mobile","Chrome Mobile iOS","UC Browser","Tizen Browser"]};e.parsers=["device_parsers","browser_parsers","os_parsers","mobile_os_families","mobile_browser_families"],e.types=["browser","os","device"],e.regexes=r||function(){var r={};return e.parsers.map(function(e){r[e]=[]}),r}(),e.families=function(){var r={};return e.types.map(function(e){r[e]=[]}),r}();var a=Array.prototype,o=(Object.prototype,Function.prototype,a.forEach);a.indexOf;var i=function(e,r){for(var a={},o=0;r.length>o&&!(a=r[o](e));o++);return a},n=function(e,r){t(e,function(e){t(r,function(r){delete e[r]})})},t=forEach=function(e,r,a){if(null!=e)if(o&&e.forEach===o)e.forEach(r,a);else if(e.length===+e.length)for(var i=0,n=e.length;n>i;i++)r.call(a,e[i],i,e);else for(var t in e)_.has(e,t)&&r.call(a,e[t],t,e)},l=function(e){return!(!e||e===undefined||null==e)},c=function(e){var r="";return e=e||{},l(e)&&l(e.major)&&(r+=e.major,l(e.minor)&&(r+="."+e.minor,l(e.patch)&&(r+="."+e.patch))),r},d=function(e){e=e||{};var r=c(e);return r&&(r=" "+r),e&&l(e.family)?e.family+r:""};return e.parse=function(r){var a=function(r){return e.regexes[r+"_parsers"].map(function(e){function a(r){var a=r.match(o);if(!a)return null;var t={};return t.family=(i?i.replace("$1",a[1]):a[1])||"other",t.major=parseInt(n?n:a[2])||null,t.minor=a[3]?parseInt(a[3]):null,t.patch=a[4]?parseInt(a[4]):null,t.tablet=e.tablet,t.man=e.manufacturer||null,t}var o=RegExp(e.regex),i=e[("browser"===r?"family":r)+"_replacement"],n=e.major_version_replacement;return a})},o=function(){},t=a("browser"),m=a("os"),p=a("device"),s=new o;s.source=r,s.browser=i(r,t),l(s.browser)?(s.browser.name=d(s.browser),s.browser.version=c(s.browser)):s.browser={},s.os=i(r,m),l(s.os)?(s.os.name=d(s.os),s.os.version=c(s.os)):s.os={},s.device=i(r,p),l(s.device)?(s.device.name=d(s.device),s.device.version=c(s.device)):s.device={tablet:!1,family:"Other"};var g={};return e.regexes.mobile_browser_families.map(function(e){g[e]=!0}),e.regexes.mobile_os_families.map(function(e){g[e]=!0}),s.device.type="Spider"===s.browser.family?"Spider":s.browser.tablet||s.os.tablet||s.device.tablet?"Tablet":g.hasOwnProperty(s.browser.family)?"Mobile":"Desktop",s.device.manufacturer=s.browser.man||s.os.man||s.device.man||null,n([s.browser,s.os,s.device],["tablet","man"]),s},e}();"undefined"!=typeof exports?("undefined"!=typeof module&&module.exports&&(exports=module.exports=r),exports.detect=r):e.detect=r,"function"==typeof define&&define.amd&&define(function(){return r})})(window);;
var userAgent = (navigator.userAgent || navigator.vendor || window.opera).toLowerCase();
var isWindowsPhone = /windows phone/i.test(navigator.userAgent.toLowerCase());
var iPadAndroid = userAgent.match(/ipad/i) || userAgent.match(/iphone/i) || userAgent.match(/itouch/i) || userAgent.match(/android/i) || false;
var iMacSafari = (userAgent.match(/safari/i) && userAgent.match(/mac/i)) || false;
var isWebKit = (userAgent.match(/webkit/i)) || false;
var isEdge = (userAgent.match(/edge/i)) || false;
var isWindowsPhoneTemp = /windows phone/i.test(navigator.userAgent.toLowerCase());
var iOS = /iPad|iPhone|iPod|iTouch/.test(navigator.userAgent) && !window.MSStream;
var isiOSPRO = (userAgent.match(/com.vagaro.iospro/i));
var IsAndroid = ((userAgent.match(/Android/i) || userAgent.toLowerCase().match(/kf/i)) ? true : false);
var deviceIsMobile = false;
var InFullScreenDateRangeLoad = false;
if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)) {
    deviceIsMobile = true;
}

if (navigator.userAgent != null && navigator.userAgent.indexOf("com.vagaro.iospro") > -1) {
    if (navigator.userAgent.indexOf("WKWebview") > -1) {
        window.EasyJS = {
            __callbacks: {},
            invokeCallback: function (cbID, removeAfterExecute) {
                var args = Array.prototype.slice.call(arguments);
                args.shift();
                args.shift();
                for (var i = 0, l = args.length; i < l; i++) {
                    args[i] = decodeURIComponent(args[i]);
                }
                var cb = EasyJS.__callbacks[cbID];
                if (removeAfterExecute) {
                    EasyJS.__callbacks[cbID] = undefined;
                }
                return cb.apply(null, args);
            },
            call: function (obj, functionName, args) {
                var formattedArgs = [];
                for (var i = 0, l = args.length; i < l; i++) {
                    if (typeof args[i] == "function") {
                        formattedArgs.push("f");
                        var cbID = "__cb" + (+new Date);
                        EasyJS.__callbacks[cbID] = args[i];
                        formattedArgs.push(cbID);
                    } else {
                        formattedArgs.push("s");
                        formattedArgs.push(encodeURIComponent(args[i]));
                    }
                }
                var argStr = (formattedArgs.length > 0 ? ":" + encodeURIComponent(formattedArgs.join(":")) : "");
                window.webkit.messageHandlers.Listener.postMessage(obj + ":" + encodeURIComponent(functionName) + argStr);
                var ret = EasyJS.retValue;
                EasyJS.retValue = undefined;
                if (ret) {
                    return decodeURIComponent(ret);
                }
            },
            inject: function (obj, methods) {
                window[obj] = {};
                var jsObj = window[obj];
                for (var i = 0, l = methods.length; i < l; i++) {
                    (function () {
                        var method = methods[i];
                        var jsMethod = method.replace(new RegExp(":", "g"), "");
                        jsObj[jsMethod] = function () {
                            return EasyJS.call(obj, method, Array.prototype.slice.call(arguments));
                        };
                    })();
                }
            }
        };
    }
    else {
        window.EasyJS = {
            __callbacks: {},
            invokeCallback: function (cbID, removeAfterExecute) {
                var args = Array.prototype.slice.call(arguments);
                args.shift();
                args.shift();
                for (var i = 0, l = args.length; i < l; i++) {
                    args[i] = decodeURIComponent(args[i]);
                }
                var cb = EasyJS.__callbacks[cbID];
                if (removeAfterExecute) {
                    EasyJS.__callbacks[cbID] = undefined;
                }
                return cb.apply(null, args);
            },
            call: function (obj, functionName, args) {
                var formattedArgs = [];
                for (var i = 0, l = args.length; i < l; i++) {
                    if (typeof args[i] == "function") {
                        formattedArgs.push("f");
                        var cbID = "__cb" + (+new Date);
                        EasyJS.__callbacks[cbID] = args[i];
                        formattedArgs.push(cbID);
                    } else {
                        formattedArgs.push("s");
                        formattedArgs.push(encodeURIComponent(args[i]));
                    }
                }
                var argStr = (formattedArgs.length > 0 ? ":" + encodeURIComponent(formattedArgs.join(":")) : "");
                var iframe = document.createElement("IFRAME");
                iframe.setAttribute("src", "easy-js:" + obj + ":" + encodeURIComponent(functionName) + argStr);
                document.documentElement.appendChild(iframe);
                iframe.parentNode.removeChild(iframe);
                iframe = null;
            },
            inject: function (obj, methods) {
                window[obj] = {};
                var jsObj = window[obj];
                for (var i = 0, l = methods.length; i < l; i++) {
                    (function () {
                        var method = methods[i];
                        var jsMethod = method.replace(new RegExp(":", "g"), "");
                        jsObj[jsMethod] = function () {
                            return EasyJS.call(obj, method, Array.prototype.slice.call(arguments));
                        };
                    })();
                }
            }
        }
    }
    // EasyJS.call("JSInterface", "setObjReqView", Array.prototype.slice.call(arguments));
    EasyJS.inject("JSInterface", ["setObjReqView:", "objReqView", "CallWSMethod:", ".cxx_destruct"]);
}

var iPhoneDevice = navigator.userAgent.match(/ipad|iphone/i);
; (function ($) {

    'use strict';

    $(document).ready(function () {
        if (!iPadAndroid) {
            $("body").addClass("desktopmachine");
        }
        if (iPadAndroid) {
            $("body").addClass("ipadandroid");
        }
        if (!iPadAndroid && iMacSafari) {
            $("body").addClass("macdesktop");
        }
        if (iPadAndroid || iMacSafari) {
            $("body").addClass("macipadandroid");
        }
        if (IsAndroid) {
            $("body").addClass("androiddevice");
        }
        /* Tooltip open function */
        if (!$("body").hasClass("ipadandroid")) {
            $(".tooltip-overlay").hover(function () {
                $(this).siblings('.form-tooltip').show();
            });
            $(".tooltip-overlay").mouseleave(function () {
                $(this).siblings('.form-tooltip').hide();
            });
        } else {
            $(".tooltip-overlay").on("click", function () {
                if ($(this).hasClass("active")) {
                    $(this).siblings('.form-tooltip').hide();
                    $(this).removeClass("active");
                } else {
                    $(".form-tooltip").hide();
                    $(".tooltip-overlay").removeClass("active");
                    $(this).addClass("active");
                    $(this).siblings('.form-tooltip').show();
                }
            });
        }
        $(document).on("touchstart click mousedown", function () {

        });
        /* Tooltip open function END */
    });
})(jQuery);

////////////////////////////////////// Date Picker Functions :: Start ////////////////////////////////////
// Created By:- Sanjay Parmar
_formsCommon = {
    dateFormat: "MMM D, YYYY",
    timeFormat: "h:mm A",
    mobileDateTimeFormat: "MMM DD YYYY hh:mm A"
};

// Created By:- Sanjay Parmar
//Return null if value is undefined
_formsCommon.parseObject = function (value) {
    if (typeof (value) == "undefined") {
        return null;
    }
    return value;
}

// Created By:- Sanjay Parmar
//Return current date if value is undefined or null
_formsCommon.parseDate = function (value) {
    if (typeof (value) == "undefined" || value == null) {
        return new Date();
    }
    return new Date(value);
}

// Created By:- Sanjay Parmar
//Return date in minutes steps
_formsCommon.formatDateInStep = function (value, steps) {
    var newDate = new Date(value);
    var min = newDate.format('nn');
    var mindiff = parseInt(parseInt(min) % steps);
    if (mindiff > 0) {
        min = (min - mindiff) + steps;
        newDate.setMinutes(min);
    }
    return newDate;
}

// Created By:- Sanjay Parmar
//Return false if value is undefined or null
_formsCommon.parseBool = function (value) {
    if (typeof (value) == "undefined" || value == null) {
        return false;
    }
    return value;
}

// Created By:- Sanjay Parmar
//Apply date picker based on options provided in arguments
_formsCommon.applyDatePicker = function (objDateTimePickerOptions, flagMobileDevice, flagDateRangePicker) {
    //Container div of textbox on which date picker will bind
    var divId = objDateTimePickerOptions.divId;
    //Textbox on which date picker will bind
    var textId = objDateTimePickerOptions.textId;
    //Preset value for date picker
    var preset = _formsCommon.parseObject(objDateTimePickerOptions.preset);
    //Minimum date for picker
    var startDate = _formsCommon.parseDate(objDateTimePickerOptions.MinDate);
    //Maximium date for picker
    var endDate = objDateTimePickerOptions.MaxDate;
    //Date for intial selection
    var defaultDate = _formsCommon.parseDate(objDateTimePickerOptions.defaultDateTime);
    //Function for calling on show date picker
    var callBackOnShow = _formsCommon.parseObject(objDateTimePickerOptions.callBackOnShow);
    //Function for calling on date change
    var callBackOnChange = _formsCommon.parseObject(objDateTimePickerOptions.callBackOnChange);
    //Function for calling on closing date picker
    var callBackOnHide = _formsCommon.parseObject(objDateTimePickerOptions.callBackOnHide);
    //Array of valid dates (It will disable all other dates)
    var arrValidDates = _formsCommon.parseObject(objDateTimePickerOptions.arrValidDates);
    //Date format for date picker (Textbox value will be filled based on this format)
    var dateFormat = _formsCommon.parseObject(objDateTimePickerOptions.dateFormat);
    //Parent id for date picker contorl
    var parentID = _formsCommon.parseObject(objDateTimePickerOptions.parentID);
    if (parentID == null || parentID == '') {
        parentID = "body";
    }

    if (dateFormat == null || dateFormat == '') {
        dateFormat = _formsCommon.dateFormat;
    }
    if (_formsCommon.parseObject(endDate) == null) {
        //If enddate not provided then set date of next six month in enddate
        endDate = new Date(startDate);
        endDate.setMonth(endDate.getMonth() + 120);
    }

    if (arrValidDates != null && arrValidDates.length > 0) {
        startDate = new Date(moment(arrValidDates[0])._d);
        endDate = new Date(moment(arrValidDates[arrValidDates.length - 1])._d);
    }

    if (defaultDate < startDate || defaultDate > endDate) {
        defaultDate = new Date(startDate);
    }

    if (_formsCommon.parseBool(objDateTimePickerOptions.allowPastDate) == true) {
        startDate = new Date(0, 1, 1); //Set min date for the case when need to allow past date 
    }

    if (preset == null || preset == '') {
        //Set default value of date picker
        preset = 'date';
    }

    if (flagMobileDevice == true) {
        if (arrValidDates != null && arrValidDates.length > 0) {
            $("#" + textId).data("dtmindate", arrValidDates[0]);
        }
        else {
            $("#" + textId).data("dtmindate", "");
        }

        var dateTimePickerOptions = {
            container: $(parentID),
            preset: preset,
            dateFormat: dateFormat,
            startDate: _formsCommon.formatDateInStep(startDate, 5),
            endDate: _formsCommon.formatDateInStep(endDate, 5),
            defaultDate: _formsCommon.formatDateInStep(defaultDate, 5),
            arrValidDates: arrValidDates,
            callBackOnChange: callBackOnChange
        };

        //Bind date picker for mobile devices
        _formsCommon.bindMobileDatePicker(textId, dateTimePickerOptions);
    }
    else if (flagDateRangePicker) {
        //Options for date range picker
        var dateTimePickerOptions = {
            parentID: parentID,
            startDate: defaultDate,
            endDate: endDate,
            callBackOnChange: callBackOnChange
        }

        if (callBackOnShow != null) {
            dateTimePickerOptions.callBackOnShow = function (textId) {
                //Call function on showing date picker
                callBackOnShow(textId);
            };
        }

        if (callBackOnHide != null) {
            dateTimePickerOptions.callBackOnHide = function (textId) {
                //Call function on hide date picker
                callBackOnHide(textId);
            };
        }

        //Bind date range picker
        _formsCommon.bindDateRangePicker(textId, dateTimePickerOptions);
    }
    else {
        if (typeof $("#" + textId).data("xdsoft_datetimepicker") === 'undefined' || $("#" + textId).data("xdsoft_datetimepicker") == null) {
            //Flag for time picker
            var pickTime = _formsCommon.parseBool(objDateTimePickerOptions.pickTime);

            //Content window for date picker
            var contentWindow = _formsCommon.parseObject(objDateTimePickerOptions.contentWindow);
            if (contentWindow == null || contentWindow == "") {
                contentWindow = window;
            }

            //Date picker options
            var dateTimePickerOptions = {
                scrollMonth: false,
                datepicker: (preset != "time"),//If need only time picker, then remove date picker
                minDate: _formsCommon.formatDateInStep(startDate, 30),
                maxDate: _formsCommon.formatDateInStep(endDate, 30),
                defaultDate: _formsCommon.formatDateInStep(defaultDate, 30),
                format: dateFormat,
                timepickerScrollbar: pickTime,
                timepicker: pickTime,
                validateOnBlur: false,
                id: textId + "_picker",
                closeOnTimeSelect: (preset == "time"),
                todayButton: false,
                showOkCloseButtons: (preset == "datetime"),
                yearStart: 1900,//new Date().getFullYear(),
                yearEnd: (new Date().getFullYear() + 10),
                allowDates: arrValidDates,
                parentID: parentID,
                contentWindow: contentWindow
            };

            //Array of week days which need to disable
            if (_formsCommon.parseObject(objDateTimePickerOptions.disabledWeekDays) != null) {
                dateTimePickerOptions.disabledWeekDays = objDateTimePickerOptions.disabledWeekDays;
            }

            if (pickTime == true) {
                if (preset != "time") {
                    //Set min date time for date picker
                    dateTimePickerOptions.minDateTime = new Date(startDate);
                }

                //Time format for date picker
                var timeFormat = _formsCommon.parseObject(objDateTimePickerOptions.timeFormat);
                if (timeFormat == null || timeFormat == '') {
                    timeFormat = _formsCommon.timeFormat;
                }

                //Set time format
                dateTimePickerOptions.formatTime = timeFormat;

                //Time slot in minutes
                dateTimePickerOptions.step = 30;
            }

            if (callBackOnShow != null) {
                dateTimePickerOptions.onShow = function (e) {
                    //Call function on showing date picker
                    callBackOnShow(textId);
                };
            }

            if (callBackOnChange != null) {
                if (preset.toLowerCase() == "time") {
                    dateTimePickerOptions.onSelectTime = function (ev) {
                        //Call function on time selection
                        callBackOnChange();
                    };
                }
                else {
                    dateTimePickerOptions.onSelectDate = function (ev) {
                        //Call function on date selection
                        callBackOnChange(new Date(ev));
                    };
                }
            }

            if (callBackOnHide != null) {
                dateTimePickerOptions.onClose = function (e) {
                    //Call function on closing date picker
                    callBackOnHide(textId);
                };
            }

            //Bind date picker for desktop devices
            _formsCommon.bindDesktopDatePicker(textId, dateTimePickerOptions);
        }
    }
}

// Created By:- Sanjay Parmar
//Bind date picker for desktop devices
_formsCommon.bindDesktopDatePicker = function (textId, dateTimePickerOptions) {
    //Functions being called for date picker
    $.datetimepicker.setDateFormatter({
        parseDate: function (date, format) {
            var d = moment(date, format);
            return d.isValid() ? d.toDate() : false;
        },

        formatDate: function (date, format) {
            return moment(date).format(format);
        }
    });

    //Bind date picker
    var picker = $("#" + textId).datetimepicker(dateTimePickerOptions);
}

// Created By:- Sanjay Parmar
//Bind date picker for mobile devices
_formsCommon.bindMobileDatePicker = function (textId, dateTimePickerOptions) {
    //Options for date picker
    var options = {
        container: dateTimePickerOptions.container,
        preset: dateTimePickerOptions.preset,
        dateFormat: dateTimePickerOptions.dateFormat,
        minDate: new Date(dateTimePickerOptions.startDate),
        maxDate: new Date(dateTimePickerOptions.endDate),
        selectedDate: new Date(dateTimePickerOptions.defaultDate)
    };
    if (_formsCommon.parseObject(dateTimePickerOptions.numberOfMonths) != null && dateTimePickerOptions.numberOfMonths > 0) {
        //Number months to generate on click of next button
        options.numberOfMonths = dateTimePickerOptions.numberOfMonths;
    }

    if (_formsCommon.parseObject(dateTimePickerOptions.arrValidDates) != null && dateTimePickerOptions.arrValidDates.length > 0) {
        //Array of valid dates (It will disable all other dates)
        options.arrValidDates = arrValidDates;
    }

    if (_formsCommon.parseObject(dateTimePickerOptions.disabledWeekDays) != null) {
        //Array of week days for disable
        options.disabledWeekDays = dateTimePickerOptions.disabledWeekDays;
    }

    if (_formsCommon.parseObject(dateTimePickerOptions.callBackOnChange) != null) {
        //Function which need to call on date change
        options.ondatechange = dateTimePickerOptions.callBackOnChange;
    }

    if (_formsCommon.parseObject(dateTimePickerOptions.callBackOnHide) != null) {
        //Function which need to call on closing date picker
        options.onclose = dateTimePickerOptions.callBackOnHide;
    }

    //Destroy old date picker if bind previously
    $("#" + textId).mobileFullDatePicker("destroy");

    //Bind date picker
    $("#" + textId).mobileFullDatePicker(options);
}

// Created By:- Sanjay Parmar
//Bind date range picker based on provided options
_formsCommon.bindDateRangePicker = function (textId, dateTimePickerOptions) {
    $('#' + textId).daterangepicker().data('daterangepicker');
    var endDate = new Date(dateTimePickerOptions.startDate);
    endDate.setMonth(endDate.getMonth() + 3);
    var picker = $('#' + textId).daterangepicker({
        parentEl: dateTimePickerOptions.parentID,
        startDate: dateTimePickerOptions.startDate,
        endDate: endDate,
        minDate: dateTimePickerOptions.startDate.format("MMM-D-YYYY"),
        showDropdowns: true,
        showWeekNumbers: true,
        timePicker: false,
        timePickerIncrement: 1,
        timePicker12Hour: true,
        ranges: {
            'Today': [moment().startOf('day'), moment().endOf('day')],
            'Yesterday': [moment().subtract(1, 'days').startOf('day'), moment().subtract(1, 'days').endOf('day')],
            'Last 7 Days': [moment().subtract(6, 'days').startOf('day'), moment().endOf('day')],
            'Last 30 Days': [moment().subtract(29, 'days').startOf('day'), moment().endOf('day')],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment()],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        },
        opens: 'right',
        buttonClasses: ['btn btn-default'],
        applyClass: 'btn-sm btn-primary',
        cancelClass: 'btn-sm',
        format: 'MMM D, YYYY',
        separator: ' to ',
        locale: {
            applyLabel: 'Submit',
            cancelLabel: 'Cancel',
            fromLabel: 'From',
            toLabel: 'To',
            customRangeLabel: 'Custom',
            daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
            monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
            firstDay: 0
        }
    }, dateTimePickerOptions.callBackOnChange).data('daterangepicker');

    picker.container.addClass('no-use-bootstrap-css');
    //inner business logic to manage a scroll in public side
    $('#' + textId).on('show.daterangepicker', function (ev, picker) {
        $("html, body").addClass("mob-overflowhidden");
        if ($(".daterangepicker.dropdown-menu").is(":visible")) {
            InFullScreenDateRangeLoad = true;
            frm.DateRangePickerScrollSetUp(JSON.stringify({ isDatePickerVisible: true, position: 0 }));
        }

        if (dateTimePickerOptions.callBackOnShow != null) {
            //Call function on showing date picker
            dateTimePickerOptions.callBackOnShow(textId);
            if (deviceIsMobile == true) {
                _form.setParentDivHeight();
            }
        }
    });
    $('#' + textId).on('hide.daterangepicker', function (ev, picker) {
        $("html, body").removeClass("mob-overflowhidden");
        if (InFullScreenDateRangeLoad == true) {
            frm.DateRangePickerScrollSetUp(JSON.stringify({ isDatePickerVisible: false, position: $(this).offset().top }));
            InFullScreenDateRangeLoad = false;
        }

        if (dateTimePickerOptions.callBackOnHide != null) {
            //Call function on hide date picker
            dateTimePickerOptions.callBackOnHide(textId);
            if (deviceIsMobile == true && typeof $("#divFormContainer")[0] != "undefined" && $("#divFormContainer")[0] != "") {
                _form.setIframeHeight($("#divFormContainer")[0].scrollHeight + 50);
                _form.setScrollPosition($("#" + textId).offset().top);
            }
        }
    });
}

// Created By:- Sanjay Parmar
//Get selected date picker value based on provided options
_formsCommon.getSelectedValue = function (textId, preset, format) {
    var input = $("#" + textId);
    if (input.length > 0) {
        if (preset.toLowerCase() == "daterange") {
            var strDateRange = input.val();
            strDateRange = strDateRange.replace(" to ", "$");
            var arrDates = strDateRange.split("$");
            var startDate = new Date(moment(arrDates[0], format)._d);
            var endDate = new Date(moment(arrDates[1], format)._d);

            arrDates = [];
            arrDates.push(startDate);
            arrDates.push(endDate);
            return arrDates;
        }
        else {
            return new Date(moment(input.val(), format)._d);
        }
    }
}

// Created By:- Parth Savadiya
// Replace static content with dynamic content
_formsCommon.onAgreementClick = function () {
    $("#agreementBusinessName").html("Agreement to do business with " + $("#hdnBusinessName").val());
    var agreementContent = $("#agreementContent").html();
    agreementContent = agreementContent.replace(/##BusinessEmail##/g, $("#hdnBusinessEmailID").val());
    agreementContent = agreementContent.replace(/##BusinessName##/g, $("#hdnBusinessName").val());
    $("#agreementContent").html(agreementContent);
}

// Created By:- Parth Savadiya
// To expand textarea as input come
_formsCommon.onTextAreaInput = function (that) {
    textarea = window.document.querySelector("#" + that.id);
    if (textarea.scrollTop != 0) {
        textarea.style.height = textarea.scrollHeight + "px";
    }
    //var scroll_height = $(that).get(0).scrollHeight;
    //$(that).css('height', scroll_height + 'px');
}

// Created By:- Rakesh raval
// Created On:- 03/03/2023
// Manage customer and Employee sign Tab...
_formsCommon.manageSignTab = function (id) {
    if (id != null && id != "" && id.indexOf('_') > -1) {
        var selectedCntrlID = id.split('_')[0];
        var selectedCntrl = id.split('_')[1];
        if (selectedCntrlID == "acustomer" && !$('#acustomer_' + selectedCntrl).hasClass('w--current')) {
            //Customer Tab...
            $('#acustomer_' + selectedCntrl).addClass('w--current');
            $('#CustomerSecondBody_' + selectedCntrl).addClass('w--tab-active');
            $('#aemployee_' + selectedCntrl).removeClass('w--current');
            $('#EmployeeSecondBody_' + selectedCntrl).removeClass('w--tab-active');
            $('.allowCommentDiv_' + selectedCntrl).hide();
            $('#signatureText_' + selectedCntrl).text("Customer Signature");
        } else if (selectedCntrlID == "aemployee" && !$('#aemployee_' + selectedCntrl).hasClass('w--current')) {
            //Employee Tab...
            $('#aemployee_' + selectedCntrl).addClass('w--current');
            $('#EmployeeSecondBody_' + selectedCntrl).addClass('w--tab-active');
            $('#acustomer_' + selectedCntrl).removeClass('w--current');
            $('#CustomerSecondBody_' + selectedCntrl).removeClass('w--tab-active');
            $('.allowCommentDiv_' + selectedCntrl).show();
            $('#signatureText_' + selectedCntrl).text("Employee Signature");
            $("#chkRequireLogin").prop("checked", true);
            //bind employee List...
            if (typeof $('#employeeforSign_' + selectedCntrl).data('select2') == 'undefined') {
                _formsCommon.BindEmployeeList(accessLevelAndEmployeeList, selectedCntrl);
            }
        }
    }
}

// Created By:- Rakesh raval
// Created On:- 07/03/2023
// bind employee List...
_formsCommon.BindEmployeeList = function (obj, selectedCntrlID) {
    if (typeof (obj) != "undefined" && obj != null && typeof (obj.employeeLists) != "undefined" && obj.employeeLists != null && obj.employeeLists.length > 0 && typeof (obj.roleLists) != "undefined" && obj.roleLists != null && obj.roleLists.length > 0) {
        cboemployee = "employeeforSign_" + selectedCntrlID;

        _formsCommon.InitializeServiceClassSelect2(cboemployee);
        _formsCommon.BindServicesClassSelect2(obj, cboemployee);
    }
}
//Check whether year is leap year
_formsCommon.isLeapYear = function (year) {
    return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
}

//Bind years in drop down
_formsCommon.fillYearDropDown = function (ddlYear) {
    var currYear = new Date().getFullYear();
    var startYear = currYear - 100;
    if (typeof isPayDeskdevice != "undefined" && isPayDeskdevice != null && isPayDeskdevice) {
        var ulYear = ddlYear.next();
        ulYear.empty();
        ulYear.append($('<li value="">Year</li>'));
        for (i = startYear; i <= currYear; i++) {
            var opt = $('<li class="select-custom-option" onclick="openBirthDateDropdownPayDesk(this,\'' + ddlYear.attr("id") + '\');" value="' + i + '">' + i + '</li>');
            ulYear.append(opt);
        }
    } else {
        ddlYear.empty();
        ddlYear.append($('<option value="">Year</option>'));
        for (i = startYear; i <= currYear; i++) {
            var opt = $('<option value="' + i + '">' + i + '</option>');
            ddlYear.append(opt);
        }
    }

}

//Validate date on month and year selection
_formsCommon.validateDate = function (queId, flagMobPreview) {
    var parentDiv = $("#divPreviewContent #divQuestion_" + queId);
    var strIdPostFix = "";
    if (typeof (flagMobPreview) != "undefined" && flagMobPreview == true) {
        parentDiv = $("#divMobilePreviewContent #divQuestion_" + queId);
        strIdPostFix = "_mob";
    }

    var year = parseInt($("#ddlYear_" + queId + strIdPostFix, parentDiv).val());
    var month = parseInt($("#ddlMonth_" + queId + strIdPostFix, parentDiv).val());
    var date = parseInt($("#ddlDate_" + queId + strIdPostFix, parentDiv).val());
    var maxDate = 31;

    if (month > 0) {
        switch (month) {
            case 2:
                if (isNaN(year) || _formsCommon.isLeapYear(year)) {
                    maxDate = 29;
                }
                else {
                    maxDate = 28;
                }
                break;
            case 4:
            case 6:
            case 9:
            case 11:
                maxDate = 30;
                break;
        }
    }

    var ddlDate = $("#ddlDate_" + queId + strIdPostFix, parentDiv);
    ddlDate.empty();
    ddlDate.append($('<option value="">Day</option>'));
    for (i = 1; i <= maxDate; i++) {
        var opt = $('<option value="' + i + '" ' + (i == date ? "selected" : "") + '>' + i + '</option>');
        ddlDate.append(opt);
    }
}
////////////////////////////////////// Date Picker Functions :: End ////////////////////////////////////

////////////////////////////////////// Employee Select2 bind:: Start ///////////////////////////////////
//Created By : - Raval Rakesh
//Created on : - 07/03/2023
var SelectionType = { Select: 1, Deselect: 2, Opening: 3 };
var cboEmployee = $("#employeeforSign_1");
_formsCommon.InitializeServiceClassSelect2 = function (employeeSignId) {
    $("#" + employeeSignId).pumselect2({
        closeOnSelect: false,
        placeholder: "Select",
        minimumInputLength: 0,
        selectAll: 1,
        isCountOnlyChild: 1,
        templateResult: function (obj) {
            if (!obj.id) {
                return obj.text;
            }
            var $obj = "";
            if ($(obj.element).attr("class") == "parent_p") {
                $obj = $('<span class="multicheck-checkbox ' + ($(obj.element).data("is-parent-selected") == false ? 'multicheck-deselect-checkbox' : '') + '"></span><label class="labelpadd parent" data-is-parent=true data-parent="' + $(obj.element).data("parent") + '">' + obj.text + '</label>');
            } else {
                $obj = $('<span class="multicheck-checkbox" style="margin-left:30px !important;"></span><label style="margin-left:30px !important;" class="labelpadd" data-is-parent=false data-parent="' + $(obj.element).data("parent") + '">' + obj.text + '</label>');
            }
            return $obj;
        }
    }).on('select2:open', function (e) {
        $("span.select2-container.select2-container--default.select2-container--open").addClass("emp-signature");
        $("span.select2-container.select2-container--default.select2-container--open").addClass("empSignature_" + employeeSignId.split('_')[1]);
        $("span.select2-search--dropdown input.select2-search__field").attr("placeholder", "Search");
        //$("body").addClass("slim-body-scroll");
    }).on('select2:closing', function (e) {
        //$("body").removeClass("slim-body-scroll");
    }).on('select2:select', function (e) {
        _formsCommon.SelectDeSelectOptions(e, SelectionType.Select, employeeSignId);
    }).on('select2:unselect', function (e) {
        _formsCommon.SelectDeSelectOptions(e, SelectionType.Deselect, employeeSignId);
    }).on('change', function (e) {
        $('#hdnFormUpdate').val(true);
    });


}

_formsCommon.SelectDeSelectOptions = function (e, type, employeeSignId) {
    var seletedItems = [];
    var parentID = $(e.params.data.element).data("parent");
    var allParentElements = $("#" + employeeSignId).find("option[data-parent=" + parentID + "]");
    var parentLabel = $('label[data-is-parent=true][data-parent=' + parentID + ']').first().parent();
    var parentSelectedElements = $("#" + employeeSignId).find("option:selected[data-parent=" + parentID + "][data-is-parent=false]");
    var childElements = jQuery.grep(allParentElements, function (n) {
        return ($(n).data("is-parent") == false);
    });
    seletedItems = $("#" + employeeSignId).val() == null ? [] : $("#" + employeeSignId).val();
    parentLabel.find("span.multicheck-checkbox").removeClass("multicheck-deselect-checkbox");
    allParentElements.first().data("is-parent-selected", false);
    if (type == SelectionType.Select) {
        if ($(e.params.data.element).attr("class") == "parent_p") {
            allParentElements.first().data("is-parent-selected", true);
            if (!($.inArray($(e.params.data.element).val(), seletedItems) !== -1)) {
                seletedItems.push($(e.params.data.element).val());
            }

            $('label[data-parent=' + parentID + ']').parent().attr("aria-selected", "true");
            $(childElements).each(function (i, item) {
                seletedItems.push($(item).val());
            });
        } else {
            if (!($.inArray(parentID, seletedItems) !== -1)) {
                seletedItems.push(parentID);
            }

            parentLabel.attr("aria-selected", "true");
            if (childElements != null && parentSelectedElements != null && (childElements.length == parentSelectedElements.length)) {
                allParentElements.first().data("is-parent-selected", true);
                $('label[data-parent=' + parentID + ']').parent().attr("aria-selected", "true");
            }
            else {
                if (parentSelectedElements.length > 0) {
                    parentLabel.find("span.multicheck-checkbox").addClass("multicheck-deselect-checkbox");
                }
                else {
                    parentLabel.attr("aria-selected", "false");
                    $('label[data-parent=' + parentID + ']').parent().attr("aria-selected", "false");
                    seletedItems = jQuery.grep(seletedItems, function (n) {
                        return n != parentID;
                    });
                }
            }
        }
    }
    else if (type == SelectionType.Deselect) {
        if ($(e.params.data.element).attr("class") == "parent_p") {
            $('label[data-parent=' + parentID + ']').parent().attr("aria-selected", "false");
            $(allParentElements).each(function (i, item) {
                var removeItem = $(item).val();
                seletedItems = jQuery.grep(seletedItems, function (n) {
                    return n != removeItem;
                });
            });
            seletedItems = jQuery.grep(seletedItems, function (n) {
                return n != parentID;
            });
        }
        else {

            if (childElements != null && parentSelectedElements != null && (childElements.length != parentSelectedElements.length)) {
                if (parentSelectedElements.length > 0) {
                    parentLabel.find("span.multicheck-checkbox").addClass("multicheck-deselect-checkbox");
                }
                else {
                    parentLabel.attr("aria-selected", "false");
                    $('label[data-parent=' + parentID + ']').parent().attr("aria-selected", "false");
                    seletedItems = jQuery.grep(seletedItems, function (n) {
                        return n != parentID;
                    });
                }
            }
        }
    }

    if (seletedItems.length > 0) {
        $("#" + employeeSignId).next("span").removeClass("errorInput");
        $("#divEmployeeErrorMessage_" + employeeSignId.split('_')[1]).hide();
        $("#divemployeeforSign_" + employeeSignId.split('_')[1] + ".emp-size .select2-container--default .select2-selection--multiple").removeClass('errorInput');
        $("#" + employeeSignId).val(seletedItems).trigger("change");
    }
    else {
        parentLabel.attr("aria-selected", "false");
        $("#" + employeeSignId).val('').trigger("change");
    }
    //Added By Rakesh Raval
    var ddlEmployee = "employeeforSign_" + employeeSignId.split('_')[1];
    if (typeof $('#' + ddlEmployee + " option:selected[data-is-parent=true]") != "undefined" && $('#' + ddlEmployee + " option:selected[data-is-parent=true]") != null && $('#' + ddlEmployee + " option:selected[data-is-parent=true]").length == 1) {
        $('#' + ddlEmployee + " option:selected[data-is-parent=true]").each(function (i, item) {
            let totalSelectedChilds = $('#' + ddlEmployee).find("option:selected[data-is-parent=false][data-parent=" + $(item).data("parent") + "]").length;
            let totalChilds = $('#' + ddlEmployee).find("option[data-is-parent=false][data-parent=" + $(item).data("parent") + "]").length;
            if (totalSelectedChilds == totalChilds) {
                $("#divemployeeforSign_" + employeeSignId.split('_')[1] + " .select2-selection__rendered").find('span').text($(item).text());
            }
        });
    }
}
_formsCommon.BindFormTypeDD = function (ctrlName) {
    var isFirstTime = true;
    var select2Control = $("#" + ctrlName);
    if (typeof select2Control.data('select2') != "undefined") {
        select2Control.pumselect2('destroy');
    }
    select2Control.pumselect2({
        closeOnSelect: false,
        placeholder: "Select Types",
        minimumInputLength: 0,
        selectAll: 1,
        isCountOnlyChild: 1,
        minimumResultsForSearch: Infinity,
        templateResult: function (obj) {
            if (!obj.id) {
                return obj.text;
            }
            var $obj = $('<span class="multicheck-checkbox ' + ($(obj.element).data("is-parent-selected") == false ? 'multicheck-deselect-checkbox' : '') + '"></span><label class="labelpadd parent" data-is-parent=true data-parent="' + $(obj.element).data("parent") + '">' + obj.text + '</label>');
            return $obj;
        }
    }).on('select2:open', function (e) {
        $("span.select2-container.select2-container--default.select2-container--open").addClass("emp-signature soap-drop-width");

        $("span.select2-search--dropdown input.select2-search__field").attr("placeholder", "Search");
    }).on('select2:closing', function (e) {
    }).on('select2:select', function (e) {
    }).on('select2:unselect', function (e) {
    }).on('change', function (e) {
        if (isFirstTime == false) {
            _formTemp.statusChange();
        }
        isFirstTime = false;
    });
    $(".select2-search input").prop("readonly", true);
    select2Control.empty();
    var FormTy