(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?factory(exports):typeof define==='function'&&define.amd?define(['exports'],factory):(factory((global.azblob={})));}(this,(function(exports){'use strict';function getHeaderKey(headerName){return headerName.toLowerCase();}
var HttpHeaders=(function(){function HttpHeaders(rawHeaders){this._headersMap={};if(rawHeaders){for(var headerName in rawHeaders){this.set(headerName,rawHeaders[headerName]);}}}
HttpHeaders.prototype.set=function(headerName,headerValue){this._headersMap[getHeaderKey(headerName)]={name:headerName,value:headerValue.toString()};};HttpHeaders.prototype.get=function(headerName){var header=this._headersMap[getHeaderKey(headerName)];return!header?undefined:header.value;};HttpHeaders.prototype.contains=function(headerName){return!!this._headersMap[getHeaderKey(headerName)];};HttpHeaders.prototype.remove=function(headerName){var result=this.contains(headerName);delete this._headersMap[getHeaderKey(headerName)];return result;};HttpHeaders.prototype.rawHeaders=function(){var result={};for(var headerKey in this._headersMap){var header=this._headersMap[headerKey];result[header.name.toLowerCase()]=header.value;}
return result;};HttpHeaders.prototype.headersArray=function(){var headers=[];for(var headerKey in this._headersMap){headers.push(this._headersMap[headerKey]);}
return headers;};HttpHeaders.prototype.headerNames=function(){var headerNames=[];var headers=this.headersArray();for(var i=0;i<headers.length;++i){headerNames.push(headers[i].name);}
return headerNames;};HttpHeaders.prototype.headerValues=function(){var headerValues=[];var headers=this.headersArray();for(var i=0;i<headers.length;++i){headerValues.push(headers[i].value);}
return headerValues;};HttpHeaders.prototype.toJson=function(){return this.rawHeaders();};HttpHeaders.prototype.toString=function(){return JSON.stringify(this.toJson());};HttpHeaders.prototype.clone=function(){return new HttpHeaders(this.rawHeaders());};return HttpHeaders;}());function encodeByteArray(value){var str="";for(var i=0;i<value.length;i++){str+=String.fromCharCode(value[i]);}
return btoa(str);}
function decodeString(value){var byteString=atob(value);var arr=new Uint8Array(byteString.length);for(var i=0;i<byteString.length;i++){arr[i]=byteString.charCodeAt(i);}
return arr;}
function createCommonjsModule(fn,module){return module={exports:{}},fn(module,module.exports),module.exports;}
var rngBrowser=createCommonjsModule(function(module){var getRandomValues=(typeof(crypto)!='undefined'&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto))||(typeof(msCrypto)!='undefined'&&typeof window.msCrypto.getRandomValues=='function'&&msCrypto.getRandomValues.bind(msCrypto));if(getRandomValues){var rnds8=new Uint8Array(16);module.exports=function whatwgRNG(){getRandomValues(rnds8);return rnds8;};}else{var rnds=new Array(16);module.exports=function mathRNG(){for(var i=0,r;i<16;i++){if((i&0x03)===0)r=Math.random()*0x100000000;rnds[i]=r>>>((i&0x03)<<3)&0xff;}
return rnds;};}});var byteToHex=[];for(var i=0;i<256;++i){byteToHex[i]=(i+0x100).toString(16).substr(1);}
function bytesToUuid(buf,offset){var i=offset||0;var bth=byteToHex;return([bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],'-',bth[buf[i++]],bth[buf[i++]],'-',bth[buf[i++]],bth[buf[i++]],'-',bth[buf[i++]],bth[buf[i++]],'-',bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]]]).join('');}
var bytesToUuid_1=bytesToUuid;function v4(options,buf,offset){var i=buf&&offset||0;if(typeof(options)=='string'){buf=options==='binary'?new Array(16):null;options=null;}
options=options||{};var rnds=options.random||(options.rng||rngBrowser)();rnds[6]=(rnds[6]&0x0f)|0x40;rnds[8]=(rnds[8]&0x3f)|0x80;if(buf){for(var ii=0;ii<16;++ii){buf[i+ii]=rnds[ii];}}
return buf||bytesToUuid_1(rnds);}
var v4_1=v4;var Constants={msRestVersion:"0.1.0",HTTP:"http:",HTTPS:"https:",HTTP_PROXY:"HTTP_PROXY",HTTPS_PROXY:"HTTPS_PROXY",HttpConstants:{HttpVerbs:{PUT:"PUT",GET:"GET",DELETE:"DELETE",POST:"POST",MERGE:"MERGE",HEAD:"HEAD",PATCH:"PATCH"},StatusCodes:{TooManyRequests:429}},HeaderConstants:{AUTHORIZATION:"authorization",AUTHORIZATION_SCHEME:"Bearer",RETRY_AFTER:"Retry-After",USER_AGENT:"User-Agent"}};var isNode=typeof navigator==="undefined"&&typeof process!=="undefined";function stripResponse(response){var strippedResponse={};strippedResponse.body=response.bodyAsText;strippedResponse.headers=response.headers;strippedResponse.status=response.status;return strippedResponse;}
function stripRequest(request){var strippedRequest=request.clone();if(strippedRequest.headers){strippedRequest.headers.remove("authorization");}
return strippedRequest;}
function isValidUuid(uuid){var validUuidRegex=new RegExp("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$","ig");return validUuidRegex.test(uuid);}
function generateUuid(){return v4_1();}
function delay$1(t,value){return new Promise(function(resolve){return setTimeout(function(){return resolve(value);},t);});}
function prepareXMLRootList(obj,elementName){var _a;if(!Array.isArray(obj)){obj=[obj];}
return _a={},_a[elementName]=obj,_a;}
var validateISODuration=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function isDuration(value){return validateISODuration.test(value);}
function replaceAll(value,searchValue,replaceValue){return!value||!searchValue?value:value.split(searchValue).join(replaceValue||"");}
var Serializer=(function(){function Serializer(modelMappers,isXML){if(modelMappers===void 0){modelMappers={};}
this.modelMappers=modelMappers;this.isXML=isXML;}
Serializer.prototype.validateConstraints=function(mapper,value,objectName){var failValidation=function(constraintName,constraintValue){throw new Error("\""+objectName+"\" with value \""+value+"\" should satisfy the constraint \""+constraintName+"\": "+constraintValue+".");};if(mapper.constraints&&(value!=undefined)){var _a=mapper.constraints,ExclusiveMaximum=_a.ExclusiveMaximum,ExclusiveMinimum=_a.ExclusiveMinimum,InclusiveMaximum=_a.InclusiveMaximum,InclusiveMinimum=_a.InclusiveMinimum,MaxItems=_a.MaxItems,MaxLength=_a.MaxLength,MinItems=_a.MinItems,MinLength=_a.MinLength,MultipleOf=_a.MultipleOf,Pattern=_a.Pattern,UniqueItems=_a.UniqueItems;if(ExclusiveMaximum!=undefined&&value>=ExclusiveMaximum){failValidation("ExclusiveMaximum",ExclusiveMaximum);}
if(ExclusiveMinimum!=undefined&&value<=ExclusiveMinimum){failValidation("ExclusiveMinimum",ExclusiveMinimum);}
if(InclusiveMaximum!=undefined&&value>InclusiveMaximum){failValidation("InclusiveMaximum",InclusiveMaximum);}
if(InclusiveMinimum!=undefined&&value<InclusiveMinimum){failValidation("InclusiveMinimum",InclusiveMinimum);}
if(MaxItems!=undefined&&value.length>MaxItems){failValidation("MaxItems",MaxItems);}
if(MaxLength!=undefined&&value.length>MaxLength){failValidation("MaxLength",MaxLength);}
if(MinItems!=undefined&&value.length<MinItems){failValidation("MinItems",MinItems);}
if(MinLength!=undefined&&value.length<MinLength){failValidation("MinLength",MinLength);}
if(MultipleOf!=undefined&&value%MultipleOf!==0){failValidation("MultipleOf",MultipleOf);}
if(Pattern&&value.match(Pattern)===null){failValidation("Pattern",Pattern);}
if(UniqueItems&&value.some(function(item,i,ar){return ar.indexOf(item)!==i;})){failValidation("UniqueItems",UniqueItems);}}};Serializer.prototype.serialize=function(mapper,object,objectName){var payload={};var mapperType=mapper.type.name;if(!objectName){objectName=mapper.serializedName;}
if(mapperType.match(/^Sequence$/ig)!==null){payload=[];}
if(object==undefined&&(mapper.defaultValue!=undefined||mapper.isConstant)){object=mapper.defaultValue;}
var required=mapper.required,nullable=mapper.nullable;if(required&&nullable&&object===undefined){throw new Error(objectName+" cannot be undefined.");}
if(required&&!nullable&&object==undefined){throw new Error(objectName+" cannot be null or undefined.");}
if(!required&&nullable===false&&object===null){throw new Error(objectName+" cannot be null.");}
if(object==undefined){payload=object;}
else{this.validateConstraints(mapper,object,objectName);if(mapperType.match(/^any$/ig)!==null){payload=object;}
else if(mapperType.match(/^(Number|String|Boolean|Object|Stream|Uuid)$/ig)!==null){payload=serializeBasicTypes(mapperType,objectName,object);}
else if(mapperType.match(/^Enum$/ig)!==null){var enumMapper=mapper;payload=serializeEnumType(objectName,enumMapper.type.allowedValues,object);}
else if(mapperType.match(/^(Date|DateTime|TimeSpan|DateTimeRfc1123|UnixTime)$/ig)!==null){payload=serializeDateTypes(mapperType,object,objectName);}
else if(mapperType.match(/^ByteArray$/ig)!==null){payload=serializeByteArrayType(objectName,object);}
else if(mapperType.match(/^Base64Url$/ig)!==null){payload=serializeBase64UrlType(objectName,object);}
else if(mapperType.match(/^Sequence$/ig)!==null){payload=serializeSequenceType(this,mapper,object,objectName);}
else if(mapperType.match(/^Dictionary$/ig)!==null){payload=serializeDictionaryType(this,mapper,object,objectName);}
else if(mapperType.match(/^Composite$/ig)!==null){payload=serializeCompositeType(this,mapper,object,objectName);}}
return payload;};Serializer.prototype.deserialize=function(mapper,responseBody,objectName){if(responseBody==undefined){if(this.isXML&&mapper.type.name==="Sequence"&&!mapper.xmlIsWrapped){responseBody=[];}
return responseBody;}
var payload;var mapperType=mapper.type.name;if(!objectName){objectName=mapper.serializedName;}
if(mapperType.match(/^Composite$/ig)!==null){payload=deserializeCompositeType(this,mapper,responseBody,objectName);}
else{if(this.isXML){if(responseBody["$"]!=undefined&&responseBody["_"]!=undefined){responseBody=responseBody["_"];}}
if(mapperType.match(/^Number$/ig)!==null){payload=parseFloat(responseBody);if(isNaN(payload)){payload=responseBody;}}
else if(mapperType.match(/^Boolean$/ig)!==null){if(responseBody==="true"){payload=true;}
else if(responseBody==="false"){payload=false;}
else{payload=responseBody;}}
else if(mapperType.match(/^(String|Enum|Object|Stream|Uuid|TimeSpan|any)$/ig)!==null){payload=responseBody;}
else if(mapperType.match(/^(Date|DateTime|DateTimeRfc1123)$/ig)!==null){payload=new Date(responseBody);}
else if(mapperType.match(/^UnixTime$/ig)!==null){payload=unixTimeToDate(responseBody);}
else if(mapperType.match(/^ByteArray$/ig)!==null){payload=decodeString(responseBody);}
else if(mapperType.match(/^Base64Url$/ig)!==null){payload=base64UrlToByteArray(responseBody);}
else if(mapperType.match(/^Sequence$/ig)!==null){payload=deserializeSequenceType(this,mapper,responseBody,objectName);}
else if(mapperType.match(/^Dictionary$/ig)!==null){payload=deserializeDictionaryType(this,mapper,responseBody,objectName);}}
if(mapper.isConstant){payload=mapper.defaultValue;}
return payload;};return Serializer;}());function trimEnd(str,ch){var len=str.length;while((len-1)>=0&&str[len-1]===ch){--len;}
return str.substr(0,len);}
function bufferToBase64Url(buffer){if(!buffer){return undefined;}
if(!(buffer instanceof Uint8Array)){throw new Error("Please provide an input of type Uint8Array for converting to Base64Url.");}
var str=encodeByteArray(buffer);return trimEnd(str,"=").replace(/\+/g,"-").replace(/\//g,"_");}
function base64UrlToByteArray(str){if(!str){return undefined;}
if(str&&typeof str.valueOf()!=="string"){throw new Error("Please provide an input of type string for converting to Uint8Array");}
str=str.replace(/\-/g,"+").replace(/\_/g,"/");return decodeString(str);}
function splitSerializeName(prop){var classes=[];var partialclass="";if(prop){var subwords=prop.split(".");for(var _i=0,subwords_1=subwords;_i<subwords_1.length;_i++){var item=subwords_1[_i];if(item.charAt(item.length-1)==="\\"){partialclass+=item.substr(0,item.length-1)+".";}
else{partialclass+=item;classes.push(partialclass);partialclass="";}}}
return classes;}
function dateToUnixTime(d){if(!d){return undefined;}
if(typeof d.valueOf()==="string"){d=new Date(d);}
return Math.floor(d.getTime()/1000);}
function unixTimeToDate(n){if(!n){return undefined;}
return new Date(n*1000);}
function serializeBasicTypes(typeName,objectName,value){if(value!==null&&value!==undefined){if(typeName.match(/^Number$/ig)!==null){if(typeof value!=="number"){throw new Error(objectName+" with value "+value+" must be of type number.");}}
else if(typeName.match(/^String$/ig)!==null){if(typeof value.valueOf()!=="string"){throw new Error(objectName+" with value \""+value+"\" must be of type string.");}}
else if(typeName.match(/^Uuid$/ig)!==null){if(!(typeof value.valueOf()==="string"&&isValidUuid(value))){throw new Error(objectName+" with value \""+value+"\" must be of type string and a valid uuid.");}}
else if(typeName.match(/^Boolean$/ig)!==null){if(typeof value!=="boolean"){throw new Error(objectName+" with value "+value+" must be of type boolean.");}}
else if(typeName.match(/^Stream$/ig)!==null){var objectType=typeof value;if(objectType!=="string"&&objectType!=="function"&&!(value instanceof ArrayBuffer)&&!ArrayBuffer.isView(value)&&!((typeof Blob==="function"||typeof Blob==="object")&&value instanceof Blob)){throw new Error(objectName+" must be a string, Blob, ArrayBuffer, ArrayBufferView, or a function returning NodeJS.ReadableStream.");}}}
return value;}
function serializeEnumType(objectName,allowedValues,value){if(!allowedValues){throw new Error("Please provide a set of allowedValues to validate "+objectName+" as an Enum Type.");}
var isPresent=allowedValues.some(function(item){if(typeof item.valueOf()==="string"){return item.toLowerCase()===value.toLowerCase();}
return item===value;});if(!isPresent){throw new Error(value+" is not a valid value for "+objectName+". The valid values are: "+JSON.stringify(allowedValues)+".");}
return value;}
function serializeByteArrayType(objectName,value){if(value!=undefined){if(!(value instanceof Uint8Array)){throw new Error(objectName+" must be of type Uint8Array.");}
value=encodeByteArray(value);}
return value;}
function serializeBase64UrlType(objectName,value){if(value!=undefined){if(!(value instanceof Uint8Array)){throw new Error(objectName+" must be of type Uint8Array.");}
value=bufferToBase64Url(value);}
return value;}
function serializeDateTypes(typeName,value,objectName){if(value!=undefined){if(typeName.match(/^Date$/ig)!==null){if(!(value instanceof Date||(typeof value.valueOf()==="string"&&!isNaN(Date.parse(value))))){throw new Error(objectName+" must be an instanceof Date or a string in ISO8601 format.");}
value=(value instanceof Date)?value.toISOString().substring(0,10):new Date(value).toISOString().substring(0,10);}
else if(typeName.match(/^DateTime$/ig)!==null){if(!(value instanceof Date||(typeof value.valueOf()==="string"&&!isNaN(Date.parse(value))))){throw new Error(objectName+" must be an instanceof Date or a string in ISO8601 format.");}
value=(value instanceof Date)?value.toISOString():new Date(value).toISOString();}
else if(typeName.match(/^DateTimeRfc1123$/ig)!==null){if(!(value instanceof Date||(typeof value.valueOf()==="string"&&!isNaN(Date.parse(value))))){throw new Error(objectName+" must be an instanceof Date or a string in RFC-1123 format.");}
value=(value instanceof Date)?value.toUTCString():new Date(value).toUTCString();}
else if(typeName.match(/^UnixTime$/ig)!==null){if(!(value instanceof Date||(typeof value.valueOf()==="string"&&!isNaN(Date.parse(value))))){throw new Error(objectName+" must be an instanceof Date or a string in RFC-1123/ISO8601 format "+"for it to be serialized in UnixTime/Epoch format.");}
value=dateToUnixTime(value);}
else if(typeName.match(/^TimeSpan$/ig)!==null){if(!isDuration(value)){throw new Error(objectName+" must be a string in ISO 8601 format. Instead was \""+value+"\".");}
value=value;}}
return value;}
function serializeSequenceType(serializer,mapper,object,objectName){if(!Array.isArray(object)){throw new Error(objectName+" must be of type Array.");}
var elementType=mapper.type.element;if(!elementType||typeof elementType!=="object"){throw new Error("element\" metadata for an Array must be defined in the "+("mapper and it must of type \"object\" in "+objectName+"."));}
var tempArray=[];for(var i=0;i<object.length;i++){tempArray[i]=serializer.serialize(elementType,object[i],objectName);}
return tempArray;}
function serializeDictionaryType(serializer,mapper,object,objectName){if(typeof object!=="object"){throw new Error(objectName+" must be of type object.");}
var valueType=mapper.type.value;if(!valueType||typeof valueType!=="object"){throw new Error("\"value\" metadata for a Dictionary must be defined in the "+("mapper and it must of type \"object\" in "+objectName+"."));}
var tempDictionary={};for(var _i=0,_a=Object.keys(object);_i<_a.length;_i++){var key=_a[_i];tempDictionary[key]=serializer.serialize(valueType,object[key],objectName+"."+key);}
return tempDictionary;}
function resolveModelProperties(serializer,mapper,objectName){var modelProps=mapper.type.modelProperties;if(!modelProps){var className=mapper.type.className;if(!className){throw new Error("Class name for model \""+objectName+"\" is not provided in the mapper \""+JSON.stringify(mapper,undefined,2)+"\".");}
var modelMapper=serializer.modelMappers[className];if(!modelMapper){throw new Error("mapper() cannot be null or undefined for model \""+className+"\".");}
modelProps=modelMapper.type.modelProperties;if(!modelProps){throw new Error("modelProperties cannot be null or undefined in the "+("mapper \""+JSON.stringify(modelMapper)+"\" of type \""+className+"\" for object \""+objectName+"\"."));}}
return modelProps;}
function serializeCompositeType(serializer,mapper,object,objectName){var _a;if(getPolymorphicDiscriminatorRecursively(serializer,mapper)){mapper=getPolymorphicMapper(serializer,mapper,object,"clientName");}
if(object!=undefined){var payload={};var modelProps=resolveModelProperties(serializer,mapper,objectName);for(var _i=0,_b=Object.keys(modelProps);_i<_b.length;_i++){var key=_b[_i];var propertyMapper=modelProps[key];if(propertyMapper.readOnly){continue;}
var propName=void 0;var parentObject=payload;if(serializer.isXML){if(propertyMapper.xmlIsWrapped){propName=propertyMapper.xmlName;}
else{propName=propertyMapper.xmlElementName||propertyMapper.xmlName;}}
else{var paths=splitSerializeName(propertyMapper.serializedName);propName=paths.pop();for(var _c=0,paths_1=paths;_c<paths_1.length;_c++){var pathName=paths_1[_c];var childObject=parentObject[pathName];if((childObject==undefined)&&(object[key]!=undefined)){parentObject[pathName]={};}
parentObject=parentObject[pathName];}}
if(parentObject!=undefined){var propertyObjectName=propertyMapper.serializedName!==""?objectName+"."+propertyMapper.serializedName:objectName;var toSerialize=object[key];var polymorphicDiscriminator=getPolymorphicDiscriminatorRecursively(serializer,mapper);if(polymorphicDiscriminator&&polymorphicDiscriminator.clientName===key&&toSerialize==undefined){toSerialize=mapper.serializedName;}
var serializedValue=serializer.serialize(propertyMapper,toSerialize,propertyObjectName);if(serializedValue!==undefined&&propName!=undefined){if(propertyMapper.xmlIsAttribute){parentObject.$=parentObject.$||{};parentObject.$[propName]=serializedValue;}
else if(propertyMapper.xmlIsWrapped){parentObject[propName]=(_a={},_a[propertyMapper.xmlElementName]=serializedValue,_a);}
else{parentObject[propName]=serializedValue;}}}}
var additionalPropertiesMapper=mapper.type.additionalProperties;if(additionalPropertiesMapper){var propNames=Object.keys(modelProps);var _loop_1=function(clientPropName){var isAdditionalProperty=propNames.every(function(pn){return pn!==clientPropName;});if(isAdditionalProperty){payload[clientPropName]=serializer.serialize(additionalPropertiesMapper,object[clientPropName],objectName+'["'+clientPropName+'"]');}};for(var clientPropName in object){_loop_1(clientPropName);}}
return payload;}
return object;}
function isSpecialXmlProperty(propertyName){return["$","_"].includes(propertyName);}
function deserializeCompositeType(serializer,mapper,responseBody,objectName){if(getPolymorphicDiscriminatorRecursively(serializer,mapper)){mapper=getPolymorphicMapper(serializer,mapper,responseBody,"serializedName");}
var modelProps=resolveModelProperties(serializer,mapper,objectName);var instance={};var handledPropertyNames=[];for(var _i=0,_a=Object.keys(modelProps);_i<_a.length;_i++){var key=_a[_i];var propertyMapper=modelProps[key];var paths=splitSerializeName(modelProps[key].serializedName);handledPropertyNames.push(paths[0]);var serializedName=propertyMapper.serializedName,xmlName=propertyMapper.xmlName,xmlElementName=propertyMapper.xmlElementName;var propertyObjectName=objectName;if(serializedName!==""&&serializedName!==undefined){propertyObjectName=objectName+"."+serializedName;}
var headerCollectionPrefix=propertyMapper.headerCollectionPrefix;if(headerCollectionPrefix){var dictionary={};for(var _b=0,_c=Object.keys(responseBody);_b<_c.length;_b++){var headerKey=_c[_b];if(headerKey.startsWith(headerCollectionPrefix)){dictionary[headerKey.substring(headerCollectionPrefix.length)]=serializer.deserialize(propertyMapper.type.value,responseBody[headerKey],propertyObjectName);}
handledPropertyNames.push(headerKey);}
instance[key]=dictionary;}
else if(serializer.isXML){if(propertyMapper.xmlIsAttribute&&responseBody.$){instance[key]=serializer.deserialize(propertyMapper,responseBody.$[xmlName],propertyObjectName);}
else{var propertyName=xmlElementName||xmlName||serializedName;var unwrappedProperty=responseBody[propertyName];if(propertyMapper.xmlIsWrapped){unwrappedProperty=responseBody[xmlName];unwrappedProperty=unwrappedProperty&&unwrappedProperty[xmlElementName];var isEmptyWrappedList=unwrappedProperty===undefined;if(isEmptyWrappedList){unwrappedProperty=[];}}
instance[key]=serializer.deserialize(propertyMapper,unwrappedProperty,propertyObjectName);}}
else{var propertyInstance=void 0;var res=responseBody;for(var _d=0,paths_2=paths;_d<paths_2.length;_d++){var item=paths_2[_d];if(!res)
break;res=res[item];}
propertyInstance=res;var polymorphicDiscriminator=mapper.type.polymorphicDiscriminator;if(polymorphicDiscriminator&&propertyMapper.serializedName===polymorphicDiscriminator.serializedName&&propertyInstance==undefined){propertyInstance=mapper.serializedName;}
var serializedValue=void 0;if(Array.isArray(responseBody[key])&&modelProps[key].serializedName===""){propertyInstance=responseBody[key];instance=serializer.deserialize(propertyMapper,propertyInstance,propertyObjectName);}
else if(propertyInstance!==undefined){serializedValue=serializer.deserialize(propertyMapper,propertyInstance,propertyObjectName);instance[key]=serializedValue;}}}
var additionalPropertiesMapper=mapper.type.additionalProperties;if(additionalPropertiesMapper){var isAdditionalProperty=function(responsePropName){for(var clientPropName in modelProps){var paths=splitSerializeName(modelProps[clientPropName].serializedName);if(paths[0]===responsePropName){return false;}}
return true;};for(var responsePropName in responseBody){if(isAdditionalProperty(responsePropName)){instance[responsePropName]=serializer.deserialize(additionalPropertiesMapper,responseBody[responsePropName],objectName+'["'+responsePropName+'"]');}}}
else{for(var _e=0,_f=Object.keys(responseBody);_e<_f.length;_e++){var key=_f[_e];if(instance[key]===undefined&&!handledPropertyNames.includes(key)&&!isSpecialXmlProperty(key)){instance[key]=responseBody[key];}}}
return instance;}
function deserializeDictionaryType(serializer,mapper,responseBody,objectName){var value=mapper.type.value;if(!value||typeof value!=="object"){throw new Error("\"value\" metadata for a Dictionary must be defined in the "+("mapper and it must of type \"object\" in "+objectName));}
if(responseBody){var tempDictionary={};for(var _i=0,_a=Object.keys(responseBody);_i<_a.length;_i++){var key=_a[_i];tempDictionary[key]=serializer.deserialize(value,responseBody[key],objectName);}
return tempDictionary;}
return responseBody;}
function deserializeSequenceType(serializer,mapper,responseBody,objectName){var element=mapper.type.element;if(!element||typeof element!=="object"){throw new Error("element\" metadata for an Array must be defined in the "+("mapper and it must of type \"object\" in "+objectName));}
if(responseBody){if(!Array.isArray(responseBody)){responseBody=[responseBody];}
var tempArray=[];for(var i=0;i<responseBody.length;i++){tempArray[i]=serializer.deserialize(element,responseBody[i],objectName+"["+i+"]");}
return tempArray;}
return responseBody;}
function getPolymorphicMapper(serializer,mapper,object,polymorphicPropertyName){var polymorphicDiscriminator=getPolymorphicDiscriminatorRecursively(serializer,mapper);if(polymorphicDiscriminator){var discriminatorName=polymorphicDiscriminator[polymorphicPropertyName];if(discriminatorName!=undefined){var discriminatorValue=object[discriminatorName];if(discriminatorValue!=undefined){var typeName=mapper.type.uberParent||mapper.type.className;var indexDiscriminator=discriminatorValue===typeName?discriminatorValue:typeName+"."+discriminatorValue;var polymorphicMapper=serializer.modelMappers.discriminators[indexDiscriminator];if(polymorphicMapper){mapper=polymorphicMapper;}}}}
return mapper;}
function getPolymorphicDiscriminatorRecursively(serializer,mapper){return mapper.type.polymorphicDiscriminator||getPolymorphicDiscriminatorSafely(serializer,mapper.type.uberParent)||getPolymorphicDiscriminatorSafely(serializer,mapper.type.className);}
function getPolymorphicDiscriminatorSafely(serializer,typeName){return(typeName&&serializer.modelMappers[typeName]&&serializer.modelMappers[typeName].type.polymorphicDiscriminator);}
function strEnum(o){var result={};for(var _i=0,o_1=o;_i<o_1.length;_i++){var key=o_1[_i];result[key]=key;}
return result;}
var MapperType=strEnum(["Base64Url","Boolean","ByteArray","Composite","Date","DateTime","DateTimeRfc1123","Dictionary","Enum","Number","Object","Sequence","String","Stream","TimeSpan","UnixTime"]);var WebResource=(function(){function WebResource(url,method,body,query,headers,streamResponseBody,withCredentials,abortSignal,timeout,onUploadProgress,onDownloadProgress){this.streamResponseBody=streamResponseBody;this.url=url||"";this.method=method||"GET";this.headers=(headers instanceof HttpHeaders?headers:new HttpHeaders(headers));this.body=body;this.query=query;this.formData=undefined;this.withCredentials=withCredentials||false;this.abortSignal=abortSignal;this.timeout=timeout||0;this.onUploadProgress=onUploadProgress;this.onDownloadProgress=onDownloadProgress;}
WebResource.prototype.validateRequestProperties=function(){if(!this.method){throw new Error("WebResource.method is required.");}
if(!this.url){throw new Error("WebResource.url is required.");}};WebResource.prototype.prepare=function(options){if(!options){throw new Error("options object is required");}
if(options.method==undefined||typeof options.method.valueOf()!=="string"){throw new Error("options.method must be a string.");}
if(options.url&&options.pathTemplate){throw new Error("options.url and options.pathTemplate are mutually exclusive. Please provide exactly one of them.");}
if((options.pathTemplate==undefined||typeof options.pathTemplate.valueOf()!=="string")&&(options.url==undefined||typeof options.url.valueOf()!=="string")){throw new Error("Please provide exactly one of options.pathTemplate or options.url.");}
if(options.url){if(typeof options.url!=="string"){throw new Error("options.url must be of type \"string\".");}
this.url=options.url;}
if(options.method){var validMethods=["GET","PUT","HEAD","DELETE","OPTIONS","POST","PATCH","TRACE"];if(validMethods.indexOf(options.method.toUpperCase())===-1){throw new Error("The provided method \""+options.method+"\" is invalid. Supported HTTP methods are: "+JSON.stringify(validMethods));}}
this.method=options.method.toUpperCase();if(options.pathTemplate){var pathTemplate_1=options.pathTemplate,pathParameters_1=options.pathParameters;if(typeof pathTemplate_1!=="string"){throw new Error("options.pathTemplate must be of type \"string\".");}
if(!options.baseUrl){options.baseUrl="https://management.azure.com";}
var baseUrl=options.baseUrl;var url_1=baseUrl+(baseUrl.endsWith("/")?"":"/")+(pathTemplate_1.startsWith("/")?pathTemplate_1.slice(1):pathTemplate_1);var segments=url_1.match(/({\w*\s*\w*})/ig);if(segments&&segments.length){if(!pathParameters_1){throw new Error("pathTemplate: "+pathTemplate_1+" has been provided. Hence, options.pathParameters must also be provided.");}
segments.forEach(function(item){var pathParamName=item.slice(1,-1);var pathParam=pathParameters_1[pathParamName];if(pathParam===null||pathParam===undefined||!(typeof pathParam==="string"||typeof pathParam==="object")){throw new Error("pathTemplate: "+pathTemplate_1+" contains the path parameter "+pathParamName+(" however, it is not present in "+pathParameters_1+" - "+JSON.stringify(pathParameters_1,undefined,2)+".")+("The value of the path parameter can either be a \"string\" of the form { "+pathParamName+": \"some sample value\" } or ")+("it can be an \"object\" of the form { \""+pathParamName+"\": { value: \"some sample value\", skipUrlEncoding: true } }."));}
if(typeof pathParam.valueOf()==="string"){url_1=url_1.replace(item,encodeURIComponent(pathParam));}
if(typeof pathParam.valueOf()==="object"){if(!pathParam.value){throw new Error("options.pathParameters["+pathParamName+"] is of type \"object\" but it does not contain a \"value\" property.");}
if(pathParam.skipUrlEncoding){url_1=url_1.replace(item,pathParam.value);}
else{url_1=url_1.replace(item,encodeURIComponent(pathParam.value));}}});}
this.url=url_1;}
if(options.queryParameters){var queryParameters=options.queryParameters;if(typeof queryParameters!=="object"){throw new Error("options.queryParameters must be of type object. It should be a JSON object "+"of \"query-parameter-name\" as the key and the \"query-parameter-value\" as the value. "+"The \"query-parameter-value\" may be fo type \"string\" or an \"object\" of the form { value: \"query-parameter-value\", skipUrlEncoding: true }.");}
if(this.url&&this.url.indexOf("?")===-1){this.url+="?";}
var queryParams=[];this.query={};for(var queryParamName in queryParameters){var queryParam=queryParameters[queryParamName];if(queryParam){if(typeof queryParam==="string"){queryParams.push(queryParamName+"="+encodeURIComponent(queryParam));this.query[queryParamName]=encodeURIComponent(queryParam);}
else if(typeof queryParam==="object"){if(!queryParam.value){throw new Error("options.queryParameters["+queryParamName+"] is of type \"object\" but it does not contain a \"value\" property.");}
if(queryParam.skipUrlEncoding){queryParams.push(queryParamName+"="+queryParam.value);this.query[queryParamName]=queryParam.value;}
else{queryParams.push(queryParamName+"="+encodeURIComponent(queryParam.value));this.query[queryParamName]=encodeURIComponent(queryParam.value);}}}}
this.url+=queryParams.join("&");}
if(options.headers){var headers=options.headers;for(var _i=0,_a=Object.keys(options.headers);_i<_a.length;_i++){var headerName=_a[_i];this.headers.set(headerName,headers[headerName]);}}
if(!this.headers.get("accept-language")){this.headers.set("accept-language","en-US");}
if(!this.headers.get("x-ms-client-request-id")&&!options.disableClientRequestId){this.headers.set("x-ms-client-request-id",generateUuid());}
if(!this.headers.get("Content-Type")){this.headers.set("Content-Type","application/json; charset=utf-8");}
this.body=options.body;if(options.body!=undefined){if(options.bodyIsStream){if(!this.headers.get("Transfer-Encoding")){this.headers.set("Transfer-Encoding","chunked");}
if(this.headers.get("Content-Type")!=="application/octet-stream"){this.headers.set("Content-Type","application/octet-stream");}}
else{if(options.serializationMapper){this.body=new Serializer(options.mappers).serialize(options.serializationMapper,options.body,"requestBody");}
if(!options.disableJsonStringifyOnBody){this.body=JSON.stringify(options.body);}}}
this.abortSignal=options.abortSignal;this.onDownloadProgress=options.onDownloadProgress;this.onUploadProgress=options.onUploadProgress;return this;};WebResource.prototype.clone=function(){var result=new WebResource(this.url,this.method,this.body,this.query,this.headers&&this.headers.clone(),this.streamResponseBody,this.withCredentials,this.abortSignal,this.timeout,this.onUploadProgress,this.onDownloadProgress);if(this.formData){result.formData=this.formData;}
if(this.operationSpec){result.operationSpec=this.operationSpec;}
if(this.shouldDeserialize){result.shouldDeserialize=this.shouldDeserialize;}
if(this.operationResponseGetter){result.operationResponseGetter=this.operationResponseGetter;}
return result;};return WebResource;}());var extendStatics=function(d,b){extendStatics=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return extendStatics(d,b);};function __extends(d,b){extendStatics(d,b);function __(){this.constructor=d;}
d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __());}
var __assign=function(){__assign=Object.assign||function __assign(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p];}
return t;};return __assign.apply(this,arguments);};function __awaiter(thisArg,_arguments,P,generator){return new(P||(P=Promise))(function(resolve,reject){function fulfilled(value){try{step(generator.next(value));}catch(e){reject(e);}}
function rejected(value){try{step(generator["throw"](value));}catch(e){reject(e);}}
function step(result){result.done?resolve(result.value):new P(function(resolve){resolve(result.value);}).then(fulfilled,rejected);}
step((generator=generator.apply(thisArg,_arguments||[])).next());});}
function __generator(thisArg,body){var _={label:0,sent:function(){if(t[0]&1)throw t[1];return t[1];},trys:[],ops:[]},f,y,t,g;return g={next:verb(0),"throw":verb(1),"return":verb(2)},typeof Symbol==="function"&&(g[Symbol.iterator]=function(){return this;}),g;function verb(n){return function(v){return step([n,v]);};}
function step(op){if(f)throw new TypeError("Generator is already executing.");while(_)try{if(f=1,y&&(t=op[0]&2?y["return"]:op[0]?y["throw"]||((t=y["return"])&&t.call(y),0):y.next)&&!(t=t.call(y,op[1])).done)return t;if(y=0,t)op=[op[0]&2,t.value];switch(op[0]){case 0:case 1:t=op;break;case 4:_.label++;return{value:op[1],done:false};case 5:_.label++;y=op[1];op=[0];continue;case 7:op=_.ops.pop();_.trys.pop();continue;default:if(!(t=_.trys,t=t.length>0&&t[t.length-1])&&(op[0]===6||op[0]===2)){_=0;continue;}
if(op[0]===3&&(!t||(op[1]>t[0]&&op[1]<t[3]))){_.label=op[1];break;}
if(op[0]===6&&_.label<t[1]){_.label=t[1];t=op;break;}
if(t&&_.label<t[2]){_.label=t[2];_.ops.push(op);break;}
if(t[2])_.ops.pop();_.trys.pop();continue;}
op=body.call(thisArg,_);}catch(e){op=[6,e];y=0;}finally{f=t=0;}
if(op[0]&5)throw op[1];return{value:op[0]?op[1]:void 0,done:true};}}
var RestError=(function(_super){__extends(RestError,_super);function RestError(message,code,statusCode,request,response,body){var _this=_super.call(this,message)||this;_this.code=code;_this.statusCode=statusCode;_this.request=request;_this.response=response;_this.body=body;Object.setPrototypeOf(_this,RestError.prototype);return _this;}
RestError.REQUEST_SEND_ERROR="REQUEST_SEND_ERROR";RestError.REQUEST_ABORTED_ERROR="REQUEST_ABORTED_ERROR";RestError.PARSE_ERROR="PARSE_ERROR";return RestError;}(Error));var XhrHttpClient=(function(){function XhrHttpClient(){}
XhrHttpClient.prototype.sendRequest=function(request){var xhr=new XMLHttpRequest();var abortSignal=request.abortSignal;if(abortSignal){var listener_1=function(){xhr.abort();};abortSignal.addEventListener("abort",listener_1);xhr.addEventListener("readystatechange",function(){if(xhr.readyState===XMLHttpRequest.DONE){abortSignal.removeEventListener("abort",listener_1);}});}
addProgressListener(xhr.upload,request.onUploadProgress);addProgressListener(xhr,request.onDownloadProgress);if(request.formData){var formData=request.formData;var requestForm_1=new FormData();var appendFormValue=function(key,value){if(value&&value.hasOwnProperty("value")&&value.hasOwnProperty("options")){requestForm_1.append(key,value.value,value.options);}
else{requestForm_1.append(key,value);}};for(var _i=0,_a=Object.keys(formData);_i<_a.length;_i++){var formKey=_a[_i];var formValue=formData[formKey];if(Array.isArray(formValue)){for(var j=0;j<formValue.length;j++){appendFormValue(formKey,formValue[j]);}}
else{appendFormValue(formKey,formValue);}}
request.body=requestForm_1;request.formData=undefined;var contentType=request.headers.get("Content-Type");if(contentType&&contentType.indexOf("multipart/form-data")!==-1){request.headers.remove("Content-Type");}}
xhr.open(request.method,request.url);xhr.timeout=request.timeout;xhr.withCredentials=request.withCredentials;for(var _b=0,_c=request.headers.headersArray();_b<_c.length;_b++){var header=_c[_b];xhr.setRequestHeader(header.name,header.value);}
xhr.responseType=request.streamResponseBody?"blob":"text";xhr.send(request.body===undefined?null:request.body);if(request.streamResponseBody){return new Promise(function(resolve,reject){xhr.addEventListener("readystatechange",function(){if(xhr.readyState===XMLHttpRequest.HEADERS_RECEIVED){var blobBody=new Promise(function(resolve,reject){xhr.addEventListener("load",function(){resolve(xhr.response);});rejectOnTerminalEvent(request,xhr,reject);});resolve({request:request,status:xhr.status,headers:parseHeaders(xhr),blobBody:blobBody});}});rejectOnTerminalEvent(request,xhr,reject);});}
else{return new Promise(function(resolve,reject){xhr.addEventListener("load",function(){return resolve({request:request,status:xhr.status,headers:parseHeaders(xhr),bodyAsText:xhr.responseText});});rejectOnTerminalEvent(request,xhr,reject);});}};return XhrHttpClient;}());function addProgressListener(xhr,listener){if(listener){xhr.addEventListener("progress",function(rawEvent){return listener({loadedBytes:rawEvent.loaded});});}}
function parseHeaders(xhr){var responseHeaders=new HttpHeaders();var headerLines=xhr.getAllResponseHeaders().trim().split(/[\r\n]+/);for(var _i=0,headerLines_1=headerLines;_i<headerLines_1.length;_i++){var line=headerLines_1[_i];var index=line.indexOf(":");var headerName=line.slice(0,index);var headerValue=line.slice(index+2);responseHeaders.set(headerName,headerValue);}
return responseHeaders;}
function rejectOnTerminalEvent(request,xhr,reject){xhr.addEventListener("error",function(){return reject(new RestError("Failed to send request to "+request.url,RestError.REQUEST_SEND_ERROR,undefined,request));});xhr.addEventListener("abort",function(){return reject(new RestError("The request was aborted",RestError.REQUEST_ABORTED_ERROR,undefined,request));});xhr.addEventListener("timeout",function(){return reject(new RestError("timeout of "+xhr.timeout+"ms exceeded",RestError.REQUEST_SEND_ERROR,undefined,request));});}
(function(HttpPipelineLogLevel){HttpPipelineLogLevel[HttpPipelineLogLevel["OFF"]=0]="OFF";HttpPipelineLogLevel[HttpPipelineLogLevel["ERROR"]=1]="ERROR";HttpPipelineLogLevel[HttpPipelineLogLevel["WARNING"]=2]="WARNING";HttpPipelineLogLevel[HttpPipelineLogLevel["INFO"]=3]="INFO";})(exports.HttpPipelineLogLevel||(exports.HttpPipelineLogLevel={}));function getPathStringFromParameter(parameter){return getPathStringFromParameterPath(parameter.parameterPath,parameter.mapper);}
function getPathStringFromParameterPath(parameterPath,mapper){var result;if(typeof parameterPath==="string"){result=parameterPath;}
else if(Array.isArray(parameterPath)){result=parameterPath.join(".");}
else{result=mapper.serializedName;}
return result;}
function isStreamOperation(operationSpec){var result=false;for(var statusCode in operationSpec.responses){var operationResponse=operationSpec.responses[statusCode];if(operationResponse.bodyMapper&&operationResponse.bodyMapper.type.name===MapperType.Stream){result=true;break;}}
return result;}
var parser=new DOMParser();function parseXML(str){try{var dom=parser.parseFromString(str,"application/xml");throwIfError(dom);var obj=domToObject(dom.childNodes[0]);return Promise.resolve(obj);}
catch(err){return Promise.reject(err);}}
var errorNS="";try{errorNS=parser.parseFromString("INVALID","text/xml").getElementsByTagName("parsererror")[0].namespaceURI;}
catch(ignored){}
function throwIfError(dom){if(errorNS){var parserErrors=dom.getElementsByTagNameNS(errorNS,"parsererror");if(parserErrors.length){throw new Error(parserErrors.item(0).innerHTML);}}}
function isElement(node){return!!node.attributes;}
function asElementWithAttributes(node){return isElement(node)&&node.hasAttributes()?node:undefined;}
function domToObject(node){var result={};var childNodeCount=node.childNodes.length;var firstChildNode=node.childNodes[0];var onlyChildTextValue=(firstChildNode&&childNodeCount===1&&firstChildNode.nodeType===Node.TEXT_NODE&&firstChildNode.nodeValue)||undefined;var elementWithAttributes=asElementWithAttributes(node);if(elementWithAttributes){result["$"]={};for(var i=0;i<elementWithAttributes.attributes.length;i++){var attr=elementWithAttributes.attributes[i];result["$"][attr.nodeName]=attr.nodeValue;}
if(onlyChildTextValue){result["_"]=onlyChildTextValue;}}
else if(childNodeCount===0){result="";}
else if(onlyChildTextValue){result=onlyChildTextValue;}
if(!onlyChildTextValue){for(var i=0;i<childNodeCount;i++){var child=node.childNodes[i];if(child.nodeType!==Node.TEXT_NODE){var childObject=domToObject(child);if(!result[child.nodeName]){result[child.nodeName]=childObject;}
else if(Array.isArray(result[child.nodeName])){result[child.nodeName].push(childObject);}
else{result[child.nodeName]=[result[child.nodeName],childObject];}}}}
return result;}
var doc=document.implementation.createDocument(null,null,null);var serializer=new XMLSerializer();function stringifyXML(obj,opts){var rootName=opts&&opts.rootName||"root";var dom=buildNode(obj,rootName)[0];return'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+serializer.serializeToString(dom);}
function buildAttributes(attrs){var result=[];for(var _i=0,_a=Object.keys(attrs);_i<_a.length;_i++){var key=_a[_i];var attr=doc.createAttribute(key);attr.value=attrs[key].toString();result.push(attr);}
return result;}
function buildNode(obj,elementName){if(typeof obj==="string"||typeof obj==="number"||typeof obj==="boolean"){var elem=doc.createElement(elementName);elem.textContent=obj.toString();return[elem];}
else if(Array.isArray(obj)){var result=[];for(var _i=0,obj_1=obj;_i<obj_1.length;_i++){var arrayElem=obj_1[_i];for(var _a=0,_b=buildNode(arrayElem,elementName);_a<_b.length;_a++){var child=_b[_a];result.push(child);}}
return result;}
else if(typeof obj==="object"){var elem=doc.createElement(elementName);for(var _c=0,_d=Object.keys(obj);_c<_d.length;_c++){var key=_d[_c];if(key==="$"){for(var _e=0,_f=buildAttributes(obj[key]);_e<_f.length;_e++){var attr=_f[_e];elem.attributes.setNamedItem(attr);}}
else{for(var _g=0,_h=buildNode(obj[key],key);_g<_h.length;_g++){var child=_h[_g];elem.appendChild(child);}}}
return[elem];}
else{throw new Error("Illegal value passed to buildObject: "+obj);}}
var BaseRequestPolicy=(function(){function BaseRequestPolicy(_nextPolicy,_options){this._nextPolicy=_nextPolicy;this._options=_options;}
BaseRequestPolicy.prototype.shouldLog=function(logLevel){return this._options.shouldLog(logLevel);};BaseRequestPolicy.prototype.log=function(logLevel,message){this._options.log(logLevel,message);};return BaseRequestPolicy;}());var RequestPolicyOptions=(function(){function RequestPolicyOptions(_logger){this._logger=_logger;}
RequestPolicyOptions.prototype.shouldLog=function(logLevel){return!!this._logger&&logLevel!==exports.HttpPipelineLogLevel.OFF&&logLevel<=this._logger.minimumLogLevel;};RequestPolicyOptions.prototype.log=function(logLevel,message){if(this._logger&&this.shouldLog(logLevel)){this._logger.log(logLevel,message);}};return RequestPolicyOptions;}());function deserializationPolicy(deserializationContentTypes){return{create:function(nextPolicy,options){return new DeserializationPolicy(nextPolicy,deserializationContentTypes,options);}};}
var defaultJsonContentTypes=["application/json","text/json"];var defaultXmlContentTypes=["application/xml","application/atom+xml"];var DeserializationPolicy=(function(_super){__extends(DeserializationPolicy,_super);function DeserializationPolicy(nextPolicy,deserializationContentTypes,options){var _this=_super.call(this,nextPolicy,options)||this;_this.jsonContentTypes=deserializationContentTypes&&deserializationContentTypes.json||defaultJsonContentTypes;_this.xmlContentTypes=deserializationContentTypes&&deserializationContentTypes.xml||defaultXmlContentTypes;return _this;}
DeserializationPolicy.prototype.sendRequest=function(request){return __awaiter(this,void 0,void 0,function(){var _this=this;return __generator(this,function(_a){return[2,this._nextPolicy.sendRequest(request).then(function(response){return deserializeResponseBody(_this.jsonContentTypes,_this.xmlContentTypes,response);})];});});};return DeserializationPolicy;}(BaseRequestPolicy));function getOperationResponse(parsedResponse){var result;var request=parsedResponse.request;var operationSpec=request.operationSpec;if(operationSpec){var operationResponseGetter=request.operationResponseGetter;if(!operationResponseGetter){result=operationSpec.responses[parsedResponse.status];}
else{result=operationResponseGetter(operationSpec,parsedResponse);}}
return result;}
function shouldDeserializeResponse(parsedResponse){var shouldDeserialize=parsedResponse.request.shouldDeserialize;var result;if(shouldDeserialize===undefined){result=true;}
else if(typeof shouldDeserialize==="boolean"){result=shouldDeserialize;}
else{result=shouldDeserialize(parsedResponse);}
return result;}
function deserializeResponseBody(jsonContentTypes,xmlContentTypes,response){return parse(jsonContentTypes,xmlContentTypes,response).then(function(parsedResponse){var shouldDeserialize=shouldDeserializeResponse(parsedResponse);if(shouldDeserialize){var operationSpec=parsedResponse.request.operationSpec;if(operationSpec&&operationSpec.responses){var statusCode=parsedResponse.status;var expectedStatusCodes=Object.keys(operationSpec.responses);var hasNoExpectedStatusCodes=(expectedStatusCodes.length===0||(expectedStatusCodes.length===1&&expectedStatusCodes[0]==="default"));var responseSpec=getOperationResponse(parsedResponse);var isExpectedStatusCode=hasNoExpectedStatusCodes?(200<=statusCode&&statusCode<300):!!responseSpec;if(!isExpectedStatusCode){var defaultResponseSpec=operationSpec.responses.default;if(defaultResponseSpec){var initialErrorMessage=isStreamOperation(operationSpec)?"Unexpected status code: "+statusCode:parsedResponse.bodyAsText;var error=new RestError(initialErrorMessage);error.statusCode=statusCode;error.request=stripRequest(parsedResponse.request);error.response=stripResponse(parsedResponse);var parsedErrorResponse=parsedResponse.parsedBody;try{if(parsedErrorResponse){var defaultResponseBodyMapper=defaultResponseSpec.bodyMapper;if(defaultResponseBodyMapper&&defaultResponseBodyMapper.serializedName==="CloudError"){if(parsedErrorResponse.error){parsedErrorResponse=parsedErrorResponse.error;}
if(parsedErrorResponse.code){error.code=parsedErrorResponse.code;}
if(parsedErrorResponse.message){error.message=parsedErrorResponse.message;}}
else{var internalError=parsedErrorResponse;if(parsedErrorResponse.error){internalError=parsedErrorResponse.error;}
error.code=internalError.code;if(internalError.message){error.message=internalError.message;}}
if(defaultResponseBodyMapper){var valueToDeserialize=parsedErrorResponse;if(operationSpec.isXML&&defaultResponseBodyMapper.type.name===MapperType.Sequence){valueToDeserialize=typeof parsedErrorResponse==="object"?parsedErrorResponse[defaultResponseBodyMapper.xmlElementName]:[];}
error.body=operationSpec.serializer.deserialize(defaultResponseBodyMapper,valueToDeserialize,"error.body");}}}
catch(defaultError){error.message="Error \""+defaultError.message+"\" occurred in deserializing the responseBody - \""+parsedResponse.bodyAsText+"\" for the default response.";}
return Promise.reject(error);}}
else if(responseSpec){if(responseSpec.bodyMapper){var valueToDeserialize=parsedResponse.parsedBody;if(operationSpec.isXML&&responseSpec.bodyMapper.type.name===MapperType.Sequence){valueToDeserialize=typeof valueToDeserialize==="object"?valueToDeserialize[responseSpec.bodyMapper.xmlElementName]:[];}
try{parsedResponse.parsedBody=operationSpec.serializer.deserialize(responseSpec.bodyMapper,valueToDeserialize,"operationRes.parsedBody");}
catch(error){var restError=new RestError("Error "+error+" occurred in deserializing the responseBody - "+parsedResponse.bodyAsText);restError.request=stripRequest(parsedResponse.request);restError.response=stripResponse(parsedResponse);return Promise.reject(restError);}}
else if(operationSpec.httpMethod==="HEAD"){parsedResponse.parsedBody=response.status>=200&&response.status<300;}
if(responseSpec.headersMapper){parsedResponse.parsedHeaders=operationSpec.serializer.deserialize(responseSpec.headersMapper,parsedResponse.headers.rawHeaders(),"operationRes.parsedHeaders");}}}}
return Promise.resolve(parsedResponse);});}
function parse(jsonContentTypes,xmlContentTypes,operationResponse){var errorHandler=function(err){var msg="Error \""+err+"\" occurred while parsing the response body - "+operationResponse.bodyAsText+".";var errCode=err.code||RestError.PARSE_ERROR;var e=new RestError(msg,errCode,operationResponse.status,operationResponse.request,operationResponse,operationResponse.bodyAsText);return Promise.reject(e);};if(!operationResponse.request.streamResponseBody&&operationResponse.bodyAsText){var text_1=operationResponse.bodyAsText;var contentType=operationResponse.headers.get("Content-Type")||"";var contentComponents=!contentType?[]:contentType.split(";").map(function(component){return component.toLowerCase();});if(contentComponents.length===0||contentComponents.some(function(component){return jsonContentTypes.indexOf(component)!==-1;})){return new Promise(function(resolve){operationResponse.parsedBody=JSON.parse(text_1);resolve(operationResponse);}).catch(errorHandler);}
else if(contentComponents.some(function(component){return xmlContentTypes.indexOf(component)!==-1;})){return parseXML(text_1).then(function(body){operationResponse.parsedBody=body;return operationResponse;}).catch(errorHandler);}}
return Promise.resolve(operationResponse);}
function exponentialRetryPolicy(retryCount,retryInterval,minRetryInterval,maxRetryInterval){return{create:function(nextPolicy,options){return new ExponentialRetryPolicy(nextPolicy,options,retryCount,retryInterval,minRetryInterval,maxRetryInterval);}};}
var DEFAULT_CLIENT_RETRY_INTERVAL=1000*30;var DEFAULT_CLIENT_RETRY_COUNT=3;var DEFAULT_CLIENT_MAX_RETRY_INTERVAL=1000*90;var DEFAULT_CLIENT_MIN_RETRY_INTERVAL=1000*3;var ExponentialRetryPolicy=(function(_super){__extends(ExponentialRetryPolicy,_super);function ExponentialRetryPolicy(nextPolicy,options,retryCount,retryInterval,minRetryInterval,maxRetryInterval){var _this=_super.call(this,nextPolicy,options)||this;function isNumber(n){return typeof n==="number";}
_this.retryCount=isNumber(retryCount)?retryCount:DEFAULT_CLIENT_RETRY_COUNT;_this.retryInterval=isNumber(retryInterval)?retryInterval:DEFAULT_CLIENT_RETRY_INTERVAL;_this.minRetryInterval=isNumber(minRetryInterval)?minRetryInterval:DEFAULT_CLIENT_MIN_RETRY_INTERVAL;_this.maxRetryInterval=isNumber(maxRetryInterval)?maxRetryInterval:DEFAULT_CLIENT_MAX_RETRY_INTERVAL;return _this;}
ExponentialRetryPolicy.prototype.sendRequest=function(request){var _this=this;return this._nextPolicy.sendRequest(request.clone()).then(function(response){return retry(_this,request,response);}).catch(function(error){return retry(_this,request,error.response,undefined,error);});};return ExponentialRetryPolicy;}(BaseRequestPolicy));function shouldRetry(policy,statusCode,retryData){if(statusCode==undefined||(statusCode<500&&statusCode!==408)||statusCode===501||statusCode===505){return false;}
var currentCount;if(!retryData){throw new Error("retryData for the ExponentialRetryPolicyFilter cannot be null.");}
else{currentCount=(retryData&&retryData.retryCount);}
return(currentCount<policy.retryCount);}
function updateRetryData(policy,retryData,err){if(!retryData){retryData={retryCount:0,retryInterval:0};}
if(err){if(retryData.error){err.innerError=retryData.error;}
retryData.error=err;}
retryData.retryCount++;var incrementDelta=Math.pow(2,retryData.retryCount)-1;var boundedRandDelta=policy.retryInterval*0.8+Math.floor(Math.random()*(policy.retryInterval*1.2-policy.retryInterval*0.8));incrementDelta*=boundedRandDelta;retryData.retryInterval=Math.min(policy.minRetryInterval+incrementDelta,policy.maxRetryInterval);return retryData;}
function retry(policy,request,response,retryData,requestError){retryData=updateRetryData(policy,retryData,requestError);var isAborted=request.abortSignal&&request.abortSignal.aborted;if(!isAborted&&shouldRetry(policy,response&&response.status,retryData)){return delay$1(retryData.retryInterval).then(function(){return policy._nextPolicy.sendRequest(request.clone());}).then(function(res){return retry(policy,request,res,retryData,undefined);}).catch(function(err){return retry(policy,request,response,retryData,err);});}
else if(isAborted||requestError||!response){var err=retryData.error||new RestError("Failed to send the request.",RestError.REQUEST_SEND_ERROR,response&&response.status,response&&response.request,response);return Promise.reject(err);}
else{return Promise.resolve(response);}}
function generateClientRequestIdPolicy(requestIdHeaderName){if(requestIdHeaderName===void 0){requestIdHeaderName="x-ms-client-request-id";}
return{create:function(nextPolicy,options){return new GenerateClientRequestIdPolicy(nextPolicy,options,requestIdHeaderName);}};}
var GenerateClientRequestIdPolicy=(function(_super){__extends(GenerateClientRequestIdPolicy,_super);function GenerateClientRequestIdPolicy(nextPolicy,options,_requestIdHeaderName){var _this=_super.call(this,nextPolicy,options)||this;_this._requestIdHeaderName=_requestIdHeaderName;return _this;}
GenerateClientRequestIdPolicy.prototype.sendRequest=function(request){if(!request.headers.contains(this._requestIdHeaderName)){request.headers.set(this._requestIdHeaderName,generateUuid());}
return this._nextPolicy.sendRequest(request);};return GenerateClientRequestIdPolicy;}(BaseRequestPolicy));function getDefaultUserAgentKey(){return"x-ms-command-name";}
function getPlatformSpecificData(){var navigator=window.navigator;var osInfo={key:"OS",value:(navigator.oscpu||navigator.platform).replace(" ","")};return[osInfo];}
function getRuntimeInfo(){var msRestRuntime={key:"ms-rest-js",value:Constants.msRestVersion};return[msRestRuntime];}
function getUserAgentString(telemetryInfo,keySeparator,valueSeparator){if(keySeparator===void 0){keySeparator=" ";}
if(valueSeparator===void 0){valueSeparator="/";}
return telemetryInfo.map(function(info){var value=info.value?""+valueSeparator+info.value:"";return""+info.key+value;}).join(keySeparator);}
function getDefaultUserAgentValue(){var runtimeInfo=getRuntimeInfo();var platformSpecificData=getPlatformSpecificData();var userAgent=getUserAgentString(runtimeInfo.concat(platformSpecificData));return userAgent;}
function userAgentPolicy(userAgentData){var key=(!userAgentData||userAgentData.key==undefined)?getDefaultUserAgentKey():userAgentData.key;var value=(!userAgentData||userAgentData.value==undefined)?getDefaultUserAgentValue():userAgentData.value;return{create:function(nextPolicy,options){return new UserAgentPolicy(nextPolicy,options,key,value);}};}
var UserAgentPolicy=(function(_super){__extends(UserAgentPolicy,_super);function UserAgentPolicy(_nextPolicy,_options,headerKey,headerValue){var _this=_super.call(this,_nextPolicy,_options)||this;_this._nextPolicy=_nextPolicy;_this._options=_options;_this.headerKey=headerKey;_this.headerValue=headerValue;return _this;}
UserAgentPolicy.prototype.sendRequest=function(request){this.addUserAgentHeader(request);return this._nextPolicy.sendRequest(request);};UserAgentPolicy.prototype.addUserAgentHeader=function(request){if(!request.headers){request.headers=new HttpHeaders();}
if(!request.headers.get(this.headerKey)&&this.headerValue){request.headers.set(this.headerKey,this.headerValue);}};return UserAgentPolicy;}(BaseRequestPolicy));var URLQuery=(function(){function URLQuery(){this._rawQuery={};}
URLQuery.prototype.any=function(){return Object.keys(this._rawQuery).length>0;};URLQuery.prototype.set=function(parameterName,parameterValue){if(parameterName){if(parameterValue!=undefined){var newValue=Array.isArray(parameterValue)?parameterValue:parameterValue.toString();this._rawQuery[parameterName]=newValue;}
else{delete this._rawQuery[parameterName];}}};URLQuery.prototype.get=function(parameterName){return parameterName?this._rawQuery[parameterName]:undefined;};URLQuery.prototype.toString=function(){var result="";for(var parameterName in this._rawQuery){if(result){result+="&";}
var parameterValue=this._rawQuery[parameterName];if(Array.isArray(parameterValue)){var parameterStrings=[];for(var _i=0,parameterValue_1=parameterValue;_i<parameterValue_1.length;_i++){var parameterValueElement=parameterValue_1[_i];parameterStrings.push(parameterName+"="+parameterValueElement);}
result+=parameterStrings.join("&");}
else{result+=parameterName+"="+parameterValue;}}
return result;};URLQuery.parse=function(text){var result=new URLQuery();if(text){if(text.startsWith("?")){text=text.substring(1);}
var currentState="ParameterName";var parameterName="";var parameterValue="";for(var i=0;i<text.length;++i){var currentCharacter=text[i];switch(currentState){case"ParameterName":switch(currentCharacter){case"=":currentState="ParameterValue";break;case"&":parameterName="";parameterValue="";break;default:parameterName+=currentCharacter;break;}
break;case"ParameterValue":switch(currentCharacter){case"=":parameterName="";parameterValue="";currentState="Invalid";break;case"&":result.set(parameterName,parameterValue);parameterName="";parameterValue="";currentState="ParameterName";break;default:parameterValue+=currentCharacter;break;}
break;case"Invalid":if(currentCharacter==="&"){currentState="ParameterName";}
break;default:throw new Error("Unrecognized URLQuery parse state: "+currentState);}}
if(currentState==="ParameterValue"){result.set(parameterName,parameterValue);}}
return result;};return URLQuery;}());var URLBuilder=(function(){function URLBuilder(){}
URLBuilder.prototype.setScheme=function(scheme){if(!scheme){this._scheme=undefined;}
else{this.set(scheme,"SCHEME");}};URLBuilder.prototype.getScheme=function(){return this._scheme;};URLBuilder.prototype.setHost=function(host){if(!host){this._host=undefined;}
else{this.set(host,"SCHEME_OR_HOST");}};URLBuilder.prototype.getHost=function(){return this._host;};URLBuilder.prototype.setPort=function(port){if(port==undefined||port===""){this._port=undefined;}
else{this.set(port.toString(),"PORT");}};URLBuilder.prototype.getPort=function(){return this._port;};URLBuilder.prototype.setPath=function(path){if(!path){this._path=undefined;}
else{if(path.indexOf("://")!==-1){this.set(path,"SCHEME");}
else{this.set(path,"PATH");}}};URLBuilder.prototype.appendPath=function(path){if(path){var currentPath=this.getPath();if(currentPath){if(!currentPath.endsWith("/")){currentPath+="/";}
if(path.startsWith("/")){path=path.substring(1);}
path=currentPath+path;}
this.set(path,"PATH");}};URLBuilder.prototype.getPath=function(){return this._path;};URLBuilder.prototype.setQuery=function(query){if(!query){this._query=undefined;}
else{this._query=URLQuery.parse(query);}};URLBuilder.prototype.setQueryParameter=function(queryParameterName,queryParameterValue){if(queryParameterName){if(!this._query){this._query=new URLQuery();}
this._query.set(queryParameterName,queryParameterValue);}};URLBuilder.prototype.getQueryParameterValue=function(queryParameterName){return this._query?this._query.get(queryParameterName):undefined;};URLBuilder.prototype.getQuery=function(){return this._query?this._query.toString():undefined;};URLBuilder.prototype.set=function(text,startState){var tokenizer=new URLTokenizer(text,startState);while(tokenizer.next()){var token=tokenizer.current();if(token){switch(token.type){case"SCHEME":this._scheme=token.text||undefined;break;case"HOST":this._host=token.text||undefined;break;case"PORT":this._port=token.text||undefined;break;case"PATH":var tokenPath=token.text||undefined;if(!this._path||this._path==="/"||tokenPath!=="/"){this._path=tokenPath;}
break;case"QUERY":this._query=URLQuery.parse(token.text);break;default:throw new Error("Unrecognized URLTokenType: "+token.type);}}}};URLBuilder.prototype.toString=function(){var result="";if(this._scheme){result+=this._scheme+"://";}
if(this._host){result+=this._host;}
if(this._port){result+=":"+this._port;}
if(this._path){if(!this._path.startsWith("/")){result+="/";}
result+=this._path;}
if(this._query&&this._query.any()){result+="?"+this._query.toString();}
return result;};URLBuilder.prototype.replaceAll=function(searchValue,replaceValue){if(searchValue){this.setScheme(replaceAll(this.getScheme(),searchValue,replaceValue));this.setHost(replaceAll(this.getHost(),searchValue,replaceValue));this.setPort(replaceAll(this.getPort(),searchValue,replaceValue));this.setPath(replaceAll(this.getPath(),searchValue,replaceValue));this.setQuery(replaceAll(this.getQuery(),searchValue,replaceValue));}};URLBuilder.parse=function(text){var result=new URLBuilder();result.set(text,"SCHEME_OR_HOST");return result;};return URLBuilder;}());var URLToken=(function(){function URLToken(text,type){this.text=text;this.type=type;}
URLToken.scheme=function(text){return new URLToken(text,"SCHEME");};URLToken.host=function(text){return new URLToken(text,"HOST");};URLToken.port=function(text){return new URLToken(text,"PORT");};URLToken.path=function(text){return new URLToken(text,"PATH");};URLToken.query=function(text){return new URLToken(text,"QUERY");};return URLToken;}());function isAlphaNumericCharacter(character){var characterCode=character.charCodeAt(0);return(48<=characterCode&&characterCode<=57)||(65<=characterCode&&characterCode<=90)||(97<=characterCode&&characterCode<=122);}
var URLTokenizer=(function(){function URLTokenizer(_text,state){this._text=_text;this._textLength=_text?_text.length:0;this._currentState=state!=undefined?state:"SCHEME_OR_HOST";this._currentIndex=0;}
URLTokenizer.prototype.current=function(){return this._currentToken;};URLTokenizer.prototype.next=function(){if(!hasCurrentCharacter(this)){this._currentToken=undefined;}
else{switch(this._currentState){case"SCHEME":nextScheme(this);break;case"SCHEME_OR_HOST":nextSchemeOrHost(this);break;case"HOST":nextHost(this);break;case"PORT":nextPort(this);break;case"PATH":nextPath(this);break;case"QUERY":nextQuery(this);break;default:throw new Error("Unrecognized URLTokenizerState: "+this._currentState);}}
return!!this._currentToken;};return URLTokenizer;}());function readRemaining(tokenizer){var result="";if(tokenizer._currentIndex<tokenizer._textLength){result=tokenizer._text.substring(tokenizer._currentIndex);tokenizer._currentIndex=tokenizer._textLength;}
return result;}
function hasCurrentCharacter(tokenizer){return tokenizer._currentIndex<tokenizer._textLength;}
function getCurrentCharacter(tokenizer){return tokenizer._text[tokenizer._currentIndex];}
function nextCharacter(tokenizer,step){if(hasCurrentCharacter(tokenizer)){if(!step){step=1;}
tokenizer._currentIndex+=step;}}
function peekCharacters(tokenizer,charactersToPeek){var endIndex=tokenizer._currentIndex+charactersToPeek;if(tokenizer._textLength<endIndex){endIndex=tokenizer._textLength;}
return tokenizer._text.substring(tokenizer._currentIndex,endIndex);}
function readWhile(tokenizer,condition){var result="";while(hasCurrentCharacter(tokenizer)){var currentCharacter=getCurrentCharacter(tokenizer);if(!condition(currentCharacter)){break;}
else{result+=currentCharacter;nextCharacter(tokenizer);}}
return result;}
function readWhileLetterOrDigit(tokenizer){return readWhile(tokenizer,function(character){return isAlphaNumericCharacter(character);});}
function readUntilCharacter(tokenizer){var terminatingCharacters=[];for(var _i=1;_i<arguments.length;_i++){terminatingCharacters[_i-1]=arguments[_i];}
return readWhile(tokenizer,function(character){return terminatingCharacters.indexOf(character)===-1;});}
function nextScheme(tokenizer){var scheme=readWhileLetterOrDigit(tokenizer);tokenizer._currentToken=URLToken.scheme(scheme);if(!hasCurrentCharacter(tokenizer)){tokenizer._currentState="DONE";}
else{tokenizer._currentState="HOST";}}
function nextSchemeOrHost(tokenizer){var schemeOrHost=readUntilCharacter(tokenizer,":","/","?");if(!hasCurrentCharacter(tokenizer)){tokenizer._currentToken=URLToken.host(schemeOrHost);tokenizer._currentState="DONE";}
else if(getCurrentCharacter(tokenizer)===":"){if(peekCharacters(tokenizer,3)==="://"){tokenizer._currentToken=URLToken.scheme(schemeOrHost);tokenizer._currentState="HOST";}
else{tokenizer._currentToken=URLToken.host(schemeOrHost);tokenizer._currentState="PORT";}}
else{tokenizer._currentToken=URLToken.host(schemeOrHost);if(getCurrentCharacter(tokenizer)==="/"){tokenizer._currentState="PATH";}
else{tokenizer._currentState="QUERY";}}}
function nextHost(tokenizer){if(peekCharacters(tokenizer,3)==="://"){nextCharacter(tokenizer,3);}
var host=readUntilCharacter(tokenizer,":","/","?");tokenizer._currentToken=URLToken.host(host);if(!hasCurrentCharacter(tokenizer)){tokenizer._currentState="DONE";}
else if(getCurrentCharacter(tokenizer)===":"){tokenizer._currentState="PORT";}
else if(getCurrentCharacter(tokenizer)==="/"){tokenizer._currentState="PATH";}
else{tokenizer._currentState="QUERY";}}
function nextPort(tokenizer){if(getCurrentCharacter(tokenizer)===":"){nextCharacter(tokenizer);}
var port=readUntilCharacter(tokenizer,"/","?");tokenizer._currentToken=URLToken.port(port);if(!hasCurrentCharacter(tokenizer)){tokenizer._currentState="DONE";}
else if(getCurrentCharacter(tokenizer)==="/"){tokenizer._currentState="PATH";}
else{tokenizer._currentState="QUERY";}}
function nextPath(tokenizer){var path=readUntilCharacter(tokenizer,"?");tokenizer._currentToken=URLToken.path(path);if(!hasCurrentCharacter(tokenizer)){tokenizer._currentState="DONE";}
else{tokenizer._currentState="QUERY";}}
function nextQuery(tokenizer){if(getCurrentCharacter(tokenizer)==="?"){nextCharacter(tokenizer);}
var query=readRemaining(tokenizer);tokenizer._currentToken=URLToken.query(query);tokenizer._currentState="DONE";}
function redirectPolicy(maximumRetries){if(maximumRetries===void 0){maximumRetries=20;}
return{create:function(nextPolicy,options){return new RedirectPolicy(nextPolicy,options,maximumRetries);}};}
var RedirectPolicy=(function(_super){__extends(RedirectPolicy,_super);function RedirectPolicy(nextPolicy,options,maxRetries){if(maxRetries===void 0){maxRetries=20;}
var _this=_super.call(this,nextPolicy,options)||this;_this.maxRetries=maxRetries;return _this;}
RedirectPolicy.prototype.sendRequest=function(request){var _this=this;return this._nextPolicy.sendRequest(request).then(function(response){return handleRedirect(_this,response,0);});};return RedirectPolicy;}(BaseRequestPolicy));function handleRedirect(policy,response,currentRetries){var request=response.request,status=response.status;var locationHeader=response.headers.get("location");if(locationHeader&&(status===300||status===307||(status===303&&request.method==="POST"))&&(!policy.maxRetries||currentRetries<policy.maxRetries)){var builder=URLBuilder.parse(request.url);builder.setPath(locationHeader);request.url=builder.toString();if(status===303){request.method="GET";}
return policy._nextPolicy.sendRequest(request).then(function(res){return handleRedirect(policy,res,currentRetries+1);});}
return Promise.resolve(response);}
function rpRegistrationPolicy(retryTimeout){if(retryTimeout===void 0){retryTimeout=30;}
return{create:function(nextPolicy,options){return new RPRegistrationPolicy(nextPolicy,options,retryTimeout);}};}
var RPRegistrationPolicy=(function(_super){__extends(RPRegistrationPolicy,_super);function RPRegistrationPolicy(nextPolicy,options,_retryTimeout){if(_retryTimeout===void 0){_retryTimeout=30;}
var _this=_super.call(this,nextPolicy,options)||this;_this._retryTimeout=_retryTimeout;return _this;}
RPRegistrationPolicy.prototype.sendRequest=function(request){var _this=this;return this._nextPolicy.sendRequest(request.clone()).then(function(response){return registerIfNeeded(_this,request,response);});};return RPRegistrationPolicy;}(BaseRequestPolicy));function registerIfNeeded(policy,request,response){if(response.status===409){var rpName=checkRPNotRegisteredError(response.bodyAsText);if(rpName){var urlPrefix=extractSubscriptionUrl(request.url);return registerRP(policy,urlPrefix,rpName,request).catch(function(){return false;}).then(function(registrationStatus){if(registrationStatus){request.headers.set("x-ms-client-request-id",generateUuid());return policy._nextPolicy.sendRequest(request.clone());}
return response;});}}
return Promise.resolve(response);}
function getRequestEssentials(originalRequest,reuseUrlToo){if(reuseUrlToo===void 0){reuseUrlToo=false;}
var reqOptions={headers:{}};if(reuseUrlToo){reqOptions.url=originalRequest.url;}
for(var h in originalRequest.headers){reqOptions.headers.set(h,originalRequest.headers.get(h));}
reqOptions.headers["x-ms-client-request-id"]=generateUuid();reqOptions.headers["Content-Type"]="application/json; charset=utf-8";return reqOptions;}
function checkRPNotRegisteredError(body){var result,responseBody;if(body){try{responseBody=JSON.parse(body);}
catch(err){}
if(responseBody&&responseBody.error&&responseBody.error.message&&responseBody.error.code&&responseBody.error.code==="MissingSubscriptionRegistration"){var matchRes=responseBody.error.message.match(/.*'(.*)'/i);if(matchRes){result=matchRes.pop();}}}
return result;}
function extractSubscriptionUrl(url){var result;var matchRes=url.match(/.*\/subscriptions\/[a-f0-9-]+\//ig);if(matchRes&&matchRes[0]){result=matchRes[0];}
else{throw new Error("Unable to extract subscriptionId from the given url - "+url+".");}
return result;}
function registerRP(policy,urlPrefix,provider,originalRequest){var postUrl=urlPrefix+"providers/"+provider+"/register?api-version=2016-02-01";var getUrl=urlPrefix+"providers/"+provider+"?api-version=2016-02-01";var reqOptions=getRequestEssentials(originalRequest);reqOptions.method="POST";reqOptions.url=postUrl;return policy._nextPolicy.sendRequest(reqOptions).then(function(response){if(response.status!==200){throw new Error("Autoregistration of "+provider+" failed. Please try registering manually.");}
return getRegistrationStatus(policy,getUrl,originalRequest);});}
function getRegistrationStatus(policy,url,originalRequest){var reqOptions=getRequestEssentials(originalRequest);reqOptions.url=url;reqOptions.method="GET";return policy._nextPolicy.sendRequest(reqOptions).then(function(res){var obj=res.parsedBody;if(res.parsedBody&&obj.registrationState&&obj.registrationState==="Registered"){return true;}
else{return delay$1(policy._retryTimeout*1000).then(function(){return getRegistrationStatus(policy,url,originalRequest);});}});}
function signingPolicy(authenticationProvider){return{create:function(nextPolicy,options){return new SigningPolicy(nextPolicy,options,authenticationProvider);}};}
var SigningPolicy=(function(_super){__extends(SigningPolicy,_super);function SigningPolicy(nextPolicy,options,authenticationProvider){var _this=_super.call(this,nextPolicy,options)||this;_this.authenticationProvider=authenticationProvider;return _this;}
SigningPolicy.prototype.signRequest=function(request){return this.authenticationProvider.signRequest(request);};SigningPolicy.prototype.sendRequest=function(request){var _this=this;return this.signRequest(request).then(function(nextRequest){return _this._nextPolicy.sendRequest(nextRequest);});};return SigningPolicy;}(BaseRequestPolicy));function systemErrorRetryPolicy(retryCount,retryInterval,minRetryInterval,maxRetryInterval){return{create:function(nextPolicy,options){return new SystemErrorRetryPolicy(nextPolicy,options,retryCount,retryInterval,minRetryInterval,maxRetryInterval);}};}
var SystemErrorRetryPolicy=(function(_super){__extends(SystemErrorRetryPolicy,_super);function SystemErrorRetryPolicy(nextPolicy,options,retryCount,retryInterval,minRetryInterval,maxRetryInterval){var _this=_super.call(this,nextPolicy,options)||this;_this.DEFAULT_CLIENT_RETRY_INTERVAL=1000*30;_this.DEFAULT_CLIENT_RETRY_COUNT=3;_this.DEFAULT_CLIENT_MAX_RETRY_INTERVAL=1000*90;_this.DEFAULT_CLIENT_MIN_RETRY_INTERVAL=1000*3;_this.retryCount=typeof retryCount==="number"?retryCount:_this.DEFAULT_CLIENT_RETRY_COUNT;_this.retryInterval=typeof retryInterval==="number"?retryInterval:_this.DEFAULT_CLIENT_RETRY_INTERVAL;_this.minRetryInterval=typeof minRetryInterval==="number"?minRetryInterval:_this.DEFAULT_CLIENT_MIN_RETRY_INTERVAL;_this.maxRetryInterval=typeof maxRetryInterval==="number"?maxRetryInterval:_this.DEFAULT_CLIENT_MAX_RETRY_INTERVAL;return _this;}
SystemErrorRetryPolicy.prototype.sendRequest=function(request){var _this=this;return this._nextPolicy.sendRequest(request.clone()).then(function(response){return retry$1(_this,request,response);});};return SystemErrorRetryPolicy;}(BaseRequestPolicy));function shouldRetry$1(policy,retryData){var currentCount;if(!retryData){throw new Error("retryData for the SystemErrorRetryPolicyFilter cannot be null.");}
else{currentCount=(retryData&&retryData.retryCount);}
return(currentCount<policy.retryCount);}
function updateRetryData$1(policy,retryData,err){if(!retryData){retryData={retryCount:0,retryInterval:0};}
if(err){if(retryData.error){err.innerError=retryData.error;}
retryData.error=err;}
retryData.retryCount++;var incrementDelta=Math.pow(2,retryData.retryCount)-1;var boundedRandDelta=policy.retryInterval*0.8+Math.floor(Math.random()*(policy.retryInterval*1.2-policy.retryInterval*0.8));incrementDelta*=boundedRandDelta;retryData.retryInterval=Math.min(policy.minRetryInterval+incrementDelta,policy.maxRetryInterval);return retryData;}
function retry$1(policy,request,operationResponse,retryData,err){retryData=updateRetryData$1(policy,retryData,err);if(err&&err.code&&shouldRetry$1(policy,retryData)&&(err.code==="ETIMEDOUT"||err.code==="ESOCKETTIMEDOUT"||err.code==="ECONNREFUSED"||err.code==="ECONNRESET"||err.code==="ENOENT")){return delay$1(retryData.retryInterval).then(function(){return policy._nextPolicy.sendRequest(request.clone());}).then(function(res){return retry$1(policy,request,res,retryData,err);}).catch(function(err){return retry$1(policy,request,operationResponse,retryData,err);});}
else{if(err!=undefined){err=retryData.error;return Promise.reject(err);}
return Promise.resolve(operationResponse);}}
var QueryCollectionFormat;(function(QueryCollectionFormat){QueryCollectionFormat["Csv"]=",";QueryCollectionFormat["Ssv"]=" ";QueryCollectionFormat["Tsv"]="\t";QueryCollectionFormat["Pipes"]="|";QueryCollectionFormat["Multi"]="Multi";})(QueryCollectionFormat||(QueryCollectionFormat={}));var StatusCodes=Constants.HttpConstants.StatusCodes;function throttlingRetryPolicy(){return{create:function(nextPolicy,options){return new ThrottlingRetryPolicy(nextPolicy,options);}};}
var ThrottlingRetryPolicy=(function(_super){__extends(ThrottlingRetryPolicy,_super);function ThrottlingRetryPolicy(nextPolicy,options,_handleResponse){var _this=_super.call(this,nextPolicy,options)||this;_this._handleResponse=_handleResponse||_this._defaultResponseHandler;return _this;}
ThrottlingRetryPolicy.prototype.sendRequest=function(httpRequest){return __awaiter(this,void 0,void 0,function(){var _this=this;return __generator(this,function(_a){return[2,this._nextPolicy.sendRequest(httpRequest.clone()).then(function(response){if(response.status!==StatusCodes.TooManyRequests){return response;}
else{return _this._handleResponse(httpRequest,response);}})];});});};ThrottlingRetryPolicy.prototype._defaultResponseHandler=function(httpRequest,httpResponse){return __awaiter(this,void 0,void 0,function(){var retryAfterHeader,delayInMs;var _this=this;return __generator(this,function(_a){retryAfterHeader=httpResponse.headers.get(Constants.HeaderConstants.RETRY_AFTER);if(retryAfterHeader){delayInMs=ThrottlingRetryPolicy.parseRetryAfterHeader(retryAfterHeader);if(delayInMs){return[2,delay(delayInMs).then(function(_){return _this._nextPolicy.sendRequest(httpRequest);})];}}
return[2,httpResponse];});});};ThrottlingRetryPolicy.parseRetryAfterHeader=function(headerValue){var retryAfterInSeconds=Number(headerValue);if(Number.isNaN(retryAfterInSeconds)){return ThrottlingRetryPolicy.parseDateRetryAfterHeader(headerValue);}
else{return retryAfterInSeconds*1000;}};ThrottlingRetryPolicy.parseDateRetryAfterHeader=function(headerValue){try{var now=Date.now();var date=Date.parse(headerValue);var diff=date-now;return Number.isNaN(diff)?undefined:diff;}
catch(error){return undefined;}};return ThrottlingRetryPolicy;}(BaseRequestPolicy));var ServiceClient=(function(){function ServiceClient(credentials,options){if(!options){options={};}
if(credentials&&!credentials.signRequest){throw new Error("credentials argument needs to implement signRequest method");}
this._withCredentials=options.withCredentials||false;this._httpClient=options.httpClient||new XhrHttpClient();this._requestPolicyOptions=new RequestPolicyOptions(options.httpPipelineLogger);this._requestPolicyFactories=options.requestPolicyFactories||createDefaultRequestPolicyFactories(credentials,options);}
ServiceClient.prototype.sendRequest=function(options){if(options===null||options===undefined||typeof options!=="object"){throw new Error("options cannot be null or undefined and it must be of type object.");}
var httpRequest;try{if(options instanceof WebResource){options.validateRequestProperties();httpRequest=options;}
else{httpRequest=new WebResource();httpRequest=httpRequest.prepare(options);}}
catch(error){return Promise.reject(error);}
var httpPipeline=this._httpClient;if(this._requestPolicyFactories&&this._requestPolicyFactories.length>0){for(var i=this._requestPolicyFactories.length-1;i>=0;--i){httpPipeline=this._requestPolicyFactories[i].create(httpPipeline,this._requestPolicyOptions);}}
return httpPipeline.sendRequest(httpRequest);};ServiceClient.prototype.sendOperationRequest=function(operationArguments,operationSpec,callback){if(typeof operationArguments.options==="function"){callback=operationArguments.options;operationArguments.options=undefined;}
var httpRequest=new WebResource();var result;try{var baseUri=operationSpec.baseUrl||this.baseUri;if(!baseUri){throw new Error("If operationSpec.baseUrl is not specified, then the ServiceClient must have a baseUri string property that contains the base URL to use.");}
httpRequest.method=operationSpec.httpMethod;httpRequest.operationSpec=operationSpec;var requestUrl=URLBuilder.parse(baseUri);if(operationSpec.path){requestUrl.appendPath(operationSpec.path);}
if(operationSpec.urlParameters&&operationSpec.urlParameters.length>0){for(var _i=0,_a=operationSpec.urlParameters;_i<_a.length;_i++){var urlParameter=_a[_i];var urlParameterValue=getOperationArgumentValueFromParameter(this,operationArguments,urlParameter,operationSpec.serializer);urlParameterValue=operationSpec.serializer.serialize(urlParameter.mapper,urlParameterValue,getPathStringFromParameter(urlParameter));if(!urlParameter.skipEncoding){urlParameterValue=encodeURIComponent(urlParameterValue);}
requestUrl.replaceAll("{"+(urlParameter.mapper.serializedName||getPathStringFromParameter(urlParameter))+"}",urlParameterValue);}}
if(operationSpec.queryParameters&&operationSpec.queryParameters.length>0){for(var _b=0,_c=operationSpec.queryParameters;_b<_c.length;_b++){var queryParameter=_c[_b];var queryParameterValue=getOperationArgumentValueFromParameter(this,operationArguments,queryParameter,operationSpec.serializer);if(queryParameterValue!=undefined){queryParameterValue=operationSpec.serializer.serialize(queryParameter.mapper,queryParameterValue,getPathStringFromParameter(queryParameter));if(queryParameter.collectionFormat!=undefined){if(queryParameter.collectionFormat===QueryCollectionFormat.Multi){if(queryParameterValue.length===0){queryParameterValue="";}
else{for(var index in queryParameterValue){var item=queryParameterValue[index];queryParameterValue[index]=item==undefined?"":item.toString();}}}
else{queryParameterValue=queryParameterValue.join(queryParameter.collectionFormat);}}
if(!queryParameter.skipEncoding){if(Array.isArray(queryParameterValue)){for(var index in queryParameterValue){queryParameterValue[index]=encodeURIComponent(queryParameterValue[index]);}}
else{queryParameterValue=encodeURIComponent(queryParameterValue);}}
requestUrl.setQueryParameter(queryParameter.mapper.serializedName||getPathStringFromParameter(queryParameter),queryParameterValue);}}}
httpRequest.url=requestUrl.toString();var contentType=operationSpec.contentType||this.requestContentType;if(contentType){httpRequest.headers.set("Content-Type",contentType);}
if(operationSpec.headerParameters){for(var _d=0,_e=operationSpec.headerParameters;_d<_e.length;_d++){var headerParameter=_e[_d];var headerValue=getOperationArgumentValueFromParameter(this,operationArguments,headerParameter,operationSpec.serializer);if(headerValue!=undefined){headerValue=operationSpec.serializer.serialize(headerParameter.mapper,headerValue,getPathStringFromParameter(headerParameter));var headerCollectionPrefix=headerParameter.mapper.headerCollectionPrefix;if(headerCollectionPrefix){for(var _f=0,_g=Object.keys(headerValue);_f<_g.length;_f++){var key=_g[_f];httpRequest.headers.set(headerCollectionPrefix+key,headerValue[key]);}}
else{httpRequest.headers.set(headerParameter.mapper.serializedName||getPathStringFromParameter(headerParameter),headerValue);}}}}
var options=operationArguments.options;if(options){if(options.customHeaders){for(var customHeaderName in options.customHeaders){httpRequest.headers.set(customHeaderName,options.customHeaders[customHeaderName]);}}
if(options.abortSignal){httpRequest.abortSignal=options.abortSignal;}
if(options.timeout){httpRequest.timeout=options.timeout;}
if(options.onUploadProgress){httpRequest.onUploadProgress=options.onUploadProgress;}
if(options.onDownloadProgress){httpRequest.onDownloadProgress=options.onDownloadProgress;}}
httpRequest.withCredentials=this._withCredentials;serializeRequestBody(this,httpRequest,operationArguments,operationSpec);if(httpRequest.streamResponseBody==undefined){httpRequest.streamResponseBody=isStreamOperation(operationSpec);}
result=this.sendRequest(httpRequest).then(function(res){return flattenResponse(res,operationSpec.responses[res.status]);});}
catch(error){result=Promise.reject(error);}
var cb=callback;if(cb){result.then(function(res){return cb(null,res._response.parsedBody,res._response.request,res._response);}).catch(function(err){return cb(err);});}
return result;};return ServiceClient;}());function serializeRequestBody(serviceClient,httpRequest,operationArguments,operationSpec){if(operationSpec.requestBody&&operationSpec.requestBody.mapper){httpRequest.body=getOperationArgumentValueFromParameter(serviceClient,operationArguments,operationSpec.requestBody,operationSpec.serializer);var bodyMapper=operationSpec.requestBody.mapper;var required=bodyMapper.required,xmlName=bodyMapper.xmlName,xmlElementName=bodyMapper.xmlElementName,serializedName=bodyMapper.serializedName;var typeName=bodyMapper.type.name;try{if(httpRequest.body!=undefined||required){var requestBodyParameterPathString=getPathStringFromParameter(operationSpec.requestBody);httpRequest.body=operationSpec.serializer.serialize(bodyMapper,httpRequest.body,requestBodyParameterPathString);var isStream=typeName===MapperType.Stream;if(operationSpec.isXML){if(typeName===MapperType.Sequence){httpRequest.body=stringifyXML(prepareXMLRootList(httpRequest.body,xmlElementName||xmlName||serializedName),{rootName:xmlName||serializedName});}
else if(!isStream){httpRequest.body=stringifyXML(httpRequest.body,{rootName:xmlName||serializedName});}}
else if(!isStream){httpRequest.body=JSON.stringify(httpRequest.body);}}}
catch(error){throw new Error("Error \""+error.message+"\" occurred in serializing the payload - "+JSON.stringify(serializedName,undefined,"  ")+".");}}
else if(operationSpec.formDataParameters&&operationSpec.formDataParameters.length>0){httpRequest.formData={};for(var _i=0,_a=operationSpec.formDataParameters;_i<_a.length;_i++){var formDataParameter=_a[_i];var formDataParameterValue=getOperationArgumentValueFromParameter(serviceClient,operationArguments,formDataParameter,operationSpec.serializer);if(formDataParameterValue!=undefined){var formDataParameterPropertyName=formDataParameter.mapper.serializedName||getPathStringFromParameter(formDataParameter);httpRequest.formData[formDataParameterPropertyName]=operationSpec.serializer.serialize(formDataParameter.mapper,formDataParameterValue,getPathStringFromParameter(formDataParameter));}}}}
function isRequestPolicyFactory(instance){return typeof instance.create==="function";}
function createDefaultRequestPolicyFactories(credentials,options){var factories=[];if(options.generateClientRequestIdHeader){factories.push(generateClientRequestIdPolicy(options.clientRequestIdHeaderName));}
if(credentials){if(isRequestPolicyFactory(credentials)){factories.push(credentials);}
else{factories.push(signingPolicy(credentials));}}
factories.push(userAgentPolicy({value:options.userAgent}));factories.push(redirectPolicy());factories.push(rpRegistrationPolicy(options.rpRegistrationRetryTimeout));if(!options.noRetryPolicy){factories.push(exponentialRetryPolicy());factories.push(systemErrorRetryPolicy());factories.push(throttlingRetryPolicy());}
factories.push(deserializationPolicy(options.deserializationContentTypes));return factories;}
function getOperationArgumentValueFromParameter(serviceClient,operationArguments,parameter,serializer){return getOperationArgumentValueFromParameterPath(serviceClient,operationArguments,parameter.parameterPath,parameter.mapper,serializer);}
function getOperationArgumentValueFromParameterPath(serviceClient,operationArguments,parameterPath,parameterMapper,serializer){var value;if(typeof parameterPath==="string"){parameterPath=[parameterPath];}
if(Array.isArray(parameterPath)){if(parameterPath.length>0){if(parameterMapper.isConstant){value=parameterMapper.defaultValue;}
else{var propertySearchResult=getPropertyFromParameterPath(operationArguments,parameterPath);if(!propertySearchResult.propertyFound){propertySearchResult=getPropertyFromParameterPath(serviceClient,parameterPath);}
var useDefaultValue=false;if(!propertySearchResult.propertyFound){useDefaultValue=parameterMapper.required||(parameterPath[0]==="options"&&parameterPath.length===2);}
value=useDefaultValue?parameterMapper.defaultValue:propertySearchResult.propertyValue;}
var parameterPathString=getPathStringFromParameterPath(parameterPath,parameterMapper);serializer.serialize(parameterMapper,value,parameterPathString);}}
else{for(var propertyName in parameterPath){var propertyMapper=parameterMapper.type.modelProperties[propertyName];var propertyPath=parameterPath[propertyName];var propertyValue=getOperationArgumentValueFromParameterPath(serviceClient,operationArguments,propertyPath,propertyMapper,serializer);var propertyPathString=getPathStringFromParameterPath(propertyPath,propertyMapper);serializer.serialize(propertyMapper,propertyValue,propertyPathString);if(propertyValue!==undefined){if(!value){value={};}
value[propertyName]=propertyValue;}}}
return value;}
function getPropertyFromParameterPath(parent,parameterPath){var result={propertyFound:false};var i=0;for(;i<parameterPath.length;++i){var parameterPathPart=parameterPath[i];if(parent!=undefined&&parameterPathPart in parent){parent=parent[parameterPathPart];}
else{break;}}
if(i===parameterPath.length){result.propertyValue=parent;result.propertyFound=true;}
return result;}
function flattenResponse(_response,responseSpec){var parsedHeaders=_response.parsedHeaders;var bodyMapper=responseSpec&&responseSpec.bodyMapper;var addOperationResponse=function(obj){return Object.defineProperty(obj,"_response",{value:_response});};if(bodyMapper){var typeName=bodyMapper.type.name;if(typeName==="Stream"){return addOperationResponse(__assign({},parsedHeaders,{blobBody:_response.blobBody,readableStreamBody:_response.readableStreamBody}));}
var modelProperties_1=typeName==="Composite"&&bodyMapper.type.modelProperties||{};var isPageableResponse=Object.keys(modelProperties_1).some(function(k){return modelProperties_1[k].serializedName==="";});if(typeName==="Sequence"||isPageableResponse){var arrayResponse=(_response.parsedBody||[]).slice();for(var _i=0,_a=Object.keys(modelProperties_1);_i<_a.length;_i++){var key=_a[_i];if(modelProperties_1[key].serializedName){arrayResponse[key]=_response.parsedBody[key];}}
if(parsedHeaders){for(var _b=0,_c=Object.keys(parsedHeaders);_b<_c.length;_b++){var key=_c[_b];arrayResponse[key]=parsedHeaders[key];}}
addOperationResponse(arrayResponse);return arrayResponse;}
if(typeName==="Composite"||typeName==="Dictionary"){return addOperationResponse(__assign({},parsedHeaders,_response.parsedBody));}}
if(bodyMapper||_response.request.method==="HEAD"){return addOperationResponse(__assign({},parsedHeaders,{body:_response.parsedBody}));}
return addOperationResponse(__assign({},parsedHeaders,_response.parsedBody));}
var LogPolicy=(function(_super){__extends(LogPolicy,_super);function LogPolicy(nextPolicy,options,logger){if(logger===void 0){logger=console.log;}
var _this=_super.call(this,nextPolicy,options)||this;_this.logger=logger;return _this;}
LogPolicy.prototype.sendRequest=function(request){var _this=this;return this._nextPolicy.sendRequest(request).then(function(response){return logResponse(_this,response);});};return LogPolicy;}(BaseRequestPolicy));function logResponse(policy,response){policy.logger(">> Request: "+JSON.stringify(response.request,undefined,2));policy.logger(">> Response status code: "+response.status);var responseBody=response.bodyAsText;policy.logger(">> Body: "+responseBody);return Promise.resolve(response);}
var ApiKeyCredentials=(function(){function ApiKeyCredentials(options){if(!options||(options&&!options.inHeader&&!options.inQuery)){throw new Error("options cannot be null or undefined. Either \"inHeader\" or \"inQuery\" property of the options object needs to be provided.");}
this.inHeader=options.inHeader;this.inQuery=options.inQuery;}
ApiKeyCredentials.prototype.signRequest=function(webResource){if(!webResource){return Promise.reject(new Error("webResource cannot be null or undefined and must be of type \"object\"."));}
if(this.inHeader){if(!webResource.headers){webResource.headers=new HttpHeaders();}
for(var headerName in this.inHeader){webResource.headers.set(headerName,this.inHeader[headerName]);}}
if(this.inQuery){if(!webResource.url){return Promise.reject(new Error("url cannot be null in the request object."));}
if(webResource.url.indexOf("?")<0){webResource.url+="?";}
for(var key in this.inQuery){if(!webResource.url.endsWith("?")){webResource.url+="&";}
webResource.url+=key+"="+this.inQuery[key];}}
return Promise.resolve(webResource);};return ApiKeyCredentials;}());var TopicCredentials=(function(_super){__extends(TopicCredentials,_super);function TopicCredentials(topicKey){var _this=this;if(!topicKey||(topicKey&&typeof topicKey!=="string")){throw new Error("topicKey cannot be null or undefined and must be of type string.");}
var options={inHeader:{"aeg-sas-key":topicKey}};_this=_super.call(this,options)||this;return _this;}
return TopicCredentials;}(ApiKeyCredentials));var index=Object.freeze({});var Aborter=(function(){function Aborter(parent,timeout,key,value){if(timeout===void 0){timeout=0;}
var _this=this;this._aborted=false;this.children=[];this.abortEventListeners=[];this.parent=parent;this.key=key;this.value=value;if(timeout>0){this.timer=setTimeout(function(){_this.abort.call(_this);},timeout);if(this.timer&&isNode){this.timer.unref();}}}
Object.defineProperty(Aborter.prototype,"aborted",{get:function(){return this._aborted;},enumerable:true,configurable:true});Object.defineProperty(Aborter,"none",{get:function(){return new Aborter(undefined,0);},enumerable:true,configurable:true});Aborter.timeout=function(timeout){return new Aborter(undefined,timeout);};Aborter.prototype.withTimeout=function(timeout){var childCancelContext=new Aborter(this,timeout);this.children.push(childCancelContext);return childCancelContext;};Aborter.prototype.withValue=function(key,value){var childCancelContext=new Aborter(this,0,key,value);this.children.push(childCancelContext);return childCancelContext;};Aborter.prototype.getValue=function(key){for(var parent_1=this;parent_1;parent_1=parent_1.parent){if(parent_1.key===key){return parent_1.value;}}
return undefined;};Aborter.prototype.abort=function(){var _this=this;if(this.aborted){return;}
this.cancelTimer();if(this.onabort){this.onabort.call(this);}
this.abortEventListeners.forEach(function(listener){listener.call(_this);});this.children.forEach(function(child){return child.cancelByParent();});this._aborted=true;};Aborter.prototype.addEventListener=function(_type,listener){this.abortEventListeners.push(listener);};Aborter.prototype.removeEventListener=function(_type,listener){var index=this.abortEventListeners.indexOf(listener);if(index>-1){this.abortEventListeners.splice(index,1);}};Aborter.prototype.cancelByParent=function(){this.abort();};Aborter.prototype.cancelTimer=function(){if(this.timer){clearTimeout(this.timer);}};return Aborter;}());var BlobDownloadResponse=1;var StorageError={serializedName:"StorageError",type:{name:"Composite",className:"StorageError",modelProperties:{message:{xmlName:"Message",serializedName:"Message",type:{name:"String"}}}}};var AccessPolicy={serializedName:"AccessPolicy",type:{name:"Composite",className:"AccessPolicy",modelProperties:{start:{xmlName:"Start",required:true,serializedName:"Start",type:{name:"String"}},expiry:{xmlName:"Expiry",required:true,serializedName:"Expiry",type:{name:"String"}},permission:{xmlName:"Permission",required:true,serializedName:"Permission",type:{name:"String"}}}}};var BlobProperties={xmlName:"Properties",serializedName:"BlobProperties",type:{name:"Composite",className:"BlobProperties",modelProperties:{creationTime:{xmlName:"Creation-Time",serializedName:"Creation-Time",type:{name:"DateTimeRfc1123"}},lastModified:{xmlName:"Last-Modified",required:true,serializedName:"Last-Modified",type:{name:"DateTimeRfc1123"}},etag:{xmlName:"Etag",required:true,serializedName:"Etag",type:{name:"String"}},contentLength:{xmlName:"Content-Length",serializedName:"Content-Length",type:{name:"Number"}},contentType:{xmlName:"Content-Type",serializedName:"Content-Type",type:{name:"String"}},contentEncoding:{xmlName:"Content-Encoding",serializedName:"Content-Encoding",type:{name:"String"}},contentLanguage:{xmlName:"Content-Language",serializedName:"Content-Language",type:{name:"String"}},contentMD5:{xmlName:"Content-MD5",serializedName:"Content-MD5",type:{name:"ByteArray"}},contentDisposition:{xmlName:"Content-Disposition",serializedName:"Content-Disposition",type:{name:"String"}},cacheControl:{xmlName:"Cache-Control",serializedName:"Cache-Control",type:{name:"String"}},blobSequenceNumber:{xmlName:"x-ms-blob-sequence-number",serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},blobType:{xmlName:"BlobType",serializedName:"BlobType",type:{name:"Enum",allowedValues:["BlockBlob","PageBlob","AppendBlob"]}},leaseStatus:{xmlName:"LeaseStatus",serializedName:"LeaseStatus",type:{name:"Enum",allowedValues:["locked","unlocked"]}},leaseState:{xmlName:"LeaseState",serializedName:"LeaseState",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseDuration:{xmlName:"LeaseDuration",serializedName:"LeaseDuration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},copyId:{xmlName:"CopyId",serializedName:"CopyId",type:{name:"String"}},copyStatus:{xmlName:"CopyStatus",serializedName:"CopyStatus",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},copySource:{xmlName:"CopySource",serializedName:"CopySource",type:{name:"String"}},copyProgress:{xmlName:"CopyProgress",serializedName:"CopyProgress",type:{name:"String"}},copyCompletionTime:{xmlName:"CopyCompletionTime",serializedName:"CopyCompletionTime",type:{name:"DateTimeRfc1123"}},copyStatusDescription:{xmlName:"CopyStatusDescription",serializedName:"CopyStatusDescription",type:{name:"String"}},serverEncrypted:{xmlName:"ServerEncrypted",serializedName:"ServerEncrypted",type:{name:"Boolean"}},incrementalCopy:{xmlName:"IncrementalCopy",serializedName:"IncrementalCopy",type:{name:"Boolean"}},destinationSnapshot:{xmlName:"DestinationSnapshot",serializedName:"DestinationSnapshot",type:{name:"String"}},deletedTime:{xmlName:"DeletedTime",serializedName:"DeletedTime",type:{name:"DateTimeRfc1123"}},remainingRetentionDays:{xmlName:"RemainingRetentionDays",serializedName:"RemainingRetentionDays",type:{name:"Number"}},accessTier:{xmlName:"AccessTier",serializedName:"AccessTier",type:{name:"String"}},accessTierInferred:{xmlName:"AccessTierInferred",serializedName:"AccessTierInferred",type:{name:"Boolean"}},archiveStatus:{xmlName:"ArchiveStatus",serializedName:"ArchiveStatus",type:{name:"String"}},accessTierChangeTime:{xmlName:"AccessTierChangeTime",serializedName:"AccessTierChangeTime",type:{name:"DateTimeRfc1123"}}}}};var BlobItem={xmlName:"Blob",serializedName:"BlobItem",type:{name:"Composite",className:"BlobItem",modelProperties:{name:{xmlName:"Name",required:true,serializedName:"Name",type:{name:"String"}},deleted:{xmlName:"Deleted",required:true,serializedName:"Deleted",type:{name:"Boolean"}},snapshot:{xmlName:"Snapshot",required:true,serializedName:"Snapshot",type:{name:"String"}},properties:{xmlName:"Properties",required:true,serializedName:"Properties",type:{name:"Composite",className:"BlobProperties"}},metadata:{xmlName:"Metadata",serializedName:"Metadata",type:{name:"Dictionary",value:{type:{name:"String"}}}}}}};var BlobFlatListSegment={xmlName:"Blobs",serializedName:"BlobFlatListSegment",type:{name:"Composite",className:"BlobFlatListSegment",modelProperties:{blobItems:{xmlName:"BlobItems",xmlElementName:"Blob",required:true,serializedName:"BlobItems",type:{name:"Sequence",element:{type:{name:"Composite",className:"BlobItem"}}}}}}};var ListBlobsFlatSegmentResponse={xmlName:"EnumerationResults",serializedName:"ListBlobsFlatSegmentResponse",type:{name:"Composite",className:"ListBlobsFlatSegmentResponse",modelProperties:{serviceEndpoint:{xmlIsAttribute:true,xmlName:"ServiceEndpoint",required:true,serializedName:"ServiceEndpoint",type:{name:"String"}},containerName:{xmlIsAttribute:true,xmlName:"ContainerName",required:true,serializedName:"ContainerName",type:{name:"String"}},prefix:{xmlName:"Prefix",required:true,serializedName:"Prefix",type:{name:"String"}},marker:{xmlName:"Marker",required:true,serializedName:"Marker",type:{name:"String"}},maxResults:{xmlName:"MaxResults",required:true,serializedName:"MaxResults",type:{name:"Number"}},delimiter:{xmlName:"Delimiter",required:true,serializedName:"Delimiter",type:{name:"String"}},segment:{xmlName:"Blobs",required:true,serializedName:"Segment",type:{name:"Composite",className:"BlobFlatListSegment"}},nextMarker:{xmlName:"NextMarker",required:true,serializedName:"NextMarker",type:{name:"String"}}}}};var BlobPrefix={serializedName:"BlobPrefix",type:{name:"Composite",className:"BlobPrefix",modelProperties:{name:{xmlName:"Name",required:true,serializedName:"Name",type:{name:"String"}}}}};var BlobHierarchyListSegment={xmlName:"Blobs",serializedName:"BlobHierarchyListSegment",type:{name:"Composite",className:"BlobHierarchyListSegment",modelProperties:{blobPrefixes:{xmlName:"BlobPrefixes",xmlElementName:"BlobPrefix",serializedName:"BlobPrefixes",type:{name:"Sequence",element:{type:{name:"Composite",className:"BlobPrefix"}}}},blobItems:{xmlName:"BlobItems",xmlElementName:"Blob",required:true,serializedName:"BlobItems",type:{name:"Sequence",element:{type:{name:"Composite",className:"BlobItem"}}}}}}};var ListBlobsHierarchySegmentResponse={xmlName:"EnumerationResults",serializedName:"ListBlobsHierarchySegmentResponse",type:{name:"Composite",className:"ListBlobsHierarchySegmentResponse",modelProperties:{serviceEndpoint:{xmlIsAttribute:true,xmlName:"ServiceEndpoint",required:true,serializedName:"ServiceEndpoint",type:{name:"String"}},containerName:{xmlIsAttribute:true,xmlName:"ContainerName",required:true,serializedName:"ContainerName",type:{name:"String"}},prefix:{xmlName:"Prefix",required:true,serializedName:"Prefix",type:{name:"String"}},marker:{xmlName:"Marker",required:true,serializedName:"Marker",type:{name:"String"}},maxResults:{xmlName:"MaxResults",required:true,serializedName:"MaxResults",type:{name:"Number"}},delimiter:{xmlName:"Delimiter",required:true,serializedName:"Delimiter",type:{name:"String"}},segment:{xmlName:"Blobs",required:true,serializedName:"Segment",type:{name:"Composite",className:"BlobHierarchyListSegment"}},nextMarker:{xmlName:"NextMarker",required:true,serializedName:"NextMarker",type:{name:"String"}}}}};var Block={serializedName:"Block",type:{name:"Composite",className:"Block",modelProperties:{name:{xmlName:"Name",required:true,serializedName:"Name",type:{name:"String"}},size:{xmlName:"Size",required:true,serializedName:"Size",type:{name:"Number"}}}}};var BlockList={serializedName:"BlockList",type:{name:"Composite",className:"BlockList",modelProperties:{committedBlocks:{xmlIsWrapped:true,xmlName:"CommittedBlocks",xmlElementName:"Block",serializedName:"CommittedBlocks",type:{name:"Sequence",element:{type:{name:"Composite",className:"Block"}}}},uncommittedBlocks:{xmlIsWrapped:true,xmlName:"UncommittedBlocks",xmlElementName:"Block",serializedName:"UncommittedBlocks",type:{name:"Sequence",element:{type:{name:"Composite",className:"Block"}}}}}}};var BlockLookupList={xmlName:"BlockList",serializedName:"BlockLookupList",type:{name:"Composite",className:"BlockLookupList",modelProperties:{committed:{xmlName:"Committed",xmlElementName:"Committed",serializedName:"Committed",type:{name:"Sequence",element:{type:{name:"String"}}}},uncommitted:{xmlName:"Uncommitted",xmlElementName:"Uncommitted",serializedName:"Uncommitted",type:{name:"Sequence",element:{type:{name:"String"}}}},latest:{xmlName:"Latest",xmlElementName:"Latest",serializedName:"Latest",type:{name:"Sequence",element:{type:{name:"String"}}}}}}};var ContainerProperties={serializedName:"ContainerProperties",type:{name:"Composite",className:"ContainerProperties",modelProperties:{lastModified:{xmlName:"Last-Modified",required:true,serializedName:"Last-Modified",type:{name:"DateTimeRfc1123"}},etag:{xmlName:"Etag",required:true,serializedName:"Etag",type:{name:"String"}},leaseStatus:{xmlName:"LeaseStatus",serializedName:"LeaseStatus",type:{name:"Enum",allowedValues:["locked","unlocked"]}},leaseState:{xmlName:"LeaseState",serializedName:"LeaseState",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseDuration:{xmlName:"LeaseDuration",serializedName:"LeaseDuration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},publicAccess:{xmlName:"PublicAccess",serializedName:"PublicAccess",type:{name:"String"}},hasImmutabilityPolicy:{xmlName:"HasImmutabilityPolicy",serializedName:"HasImmutabilityPolicy",type:{name:"Boolean"}},hasLegalHold:{xmlName:"HasLegalHold",serializedName:"HasLegalHold",type:{name:"Boolean"}}}}};var ContainerItem={xmlName:"Container",serializedName:"ContainerItem",type:{name:"Composite",className:"ContainerItem",modelProperties:{name:{xmlName:"Name",required:true,serializedName:"Name",type:{name:"String"}},properties:{xmlName:"Properties",required:true,serializedName:"Properties",type:{name:"Composite",className:"ContainerProperties"}},metadata:{xmlName:"Metadata",serializedName:"Metadata",type:{name:"Dictionary",value:{type:{name:"String"}}}}}}};var ListContainersSegmentResponse={xmlName:"EnumerationResults",serializedName:"ListContainersSegmentResponse",type:{name:"Composite",className:"ListContainersSegmentResponse",modelProperties:{serviceEndpoint:{xmlIsAttribute:true,xmlName:"ServiceEndpoint",required:true,serializedName:"ServiceEndpoint",type:{name:"String"}},prefix:{xmlName:"Prefix",required:true,serializedName:"Prefix",type:{name:"String"}},marker:{xmlName:"Marker",serializedName:"Marker",type:{name:"String"}},maxResults:{xmlName:"MaxResults",required:true,serializedName:"MaxResults",type:{name:"Number"}},containerItems:{xmlIsWrapped:true,xmlName:"Containers",xmlElementName:"Container",required:true,serializedName:"ContainerItems",type:{name:"Sequence",element:{type:{name:"Composite",className:"ContainerItem"}}}},nextMarker:{xmlName:"NextMarker",required:true,serializedName:"NextMarker",type:{name:"String"}}}}};var CorsRule={serializedName:"CorsRule",type:{name:"Composite",className:"CorsRule",modelProperties:{allowedOrigins:{xmlName:"AllowedOrigins",required:true,serializedName:"AllowedOrigins",type:{name:"String"}},allowedMethods:{xmlName:"AllowedMethods",required:true,serializedName:"AllowedMethods",type:{name:"String"}},allowedHeaders:{xmlName:"AllowedHeaders",required:true,serializedName:"AllowedHeaders",type:{name:"String"}},exposedHeaders:{xmlName:"ExposedHeaders",required:true,serializedName:"ExposedHeaders",type:{name:"String"}},maxAgeInSeconds:{xmlName:"MaxAgeInSeconds",required:true,serializedName:"MaxAgeInSeconds",constraints:{InclusiveMinimum:0},type:{name:"Number"}}}}};var GeoReplication={serializedName:"GeoReplication",type:{name:"Composite",className:"GeoReplication",modelProperties:{status:{xmlName:"Status",required:true,serializedName:"Status",type:{name:"String"}},lastSyncTime:{xmlName:"LastSyncTime",required:true,serializedName:"LastSyncTime",type:{name:"DateTimeRfc1123"}}}}};var RetentionPolicy={serializedName:"RetentionPolicy",type:{name:"Composite",className:"RetentionPolicy",modelProperties:{enabled:{xmlName:"Enabled",required:true,serializedName:"Enabled",type:{name:"Boolean"}},days:{xmlName:"Days",serializedName:"Days",constraints:{InclusiveMinimum:1},type:{name:"Number"}}}}};var Logging={serializedName:"Logging",type:{name:"Composite",className:"Logging",modelProperties:{version:{xmlName:"Version",required:true,serializedName:"Version",type:{name:"String"}},deleteProperty:{xmlName:"Delete",required:true,serializedName:"Delete",type:{name:"Boolean"}},read:{xmlName:"Read",required:true,serializedName:"Read",type:{name:"Boolean"}},write:{xmlName:"Write",required:true,serializedName:"Write",type:{name:"Boolean"}},retentionPolicy:{xmlName:"RetentionPolicy",required:true,serializedName:"RetentionPolicy",type:{name:"Composite",className:"RetentionPolicy"}}}}};var Metrics={serializedName:"Metrics",type:{name:"Composite",className:"Metrics",modelProperties:{version:{xmlName:"Version",serializedName:"Version",type:{name:"String"}},enabled:{xmlName:"Enabled",required:true,serializedName:"Enabled",type:{name:"Boolean"}},includeAPIs:{xmlName:"IncludeAPIs",serializedName:"IncludeAPIs",type:{name:"Boolean"}},retentionPolicy:{xmlName:"RetentionPolicy",serializedName:"RetentionPolicy",type:{name:"Composite",className:"RetentionPolicy"}}}}};var PageRange={serializedName:"PageRange",type:{name:"Composite",className:"PageRange",modelProperties:{start:{xmlName:"Start",required:true,serializedName:"Start",type:{name:"Number"}},end:{xmlName:"End",required:true,serializedName:"End",type:{name:"Number"}}}}};var ClearRange={serializedName:"ClearRange",type:{name:"Composite",className:"ClearRange",modelProperties:{start:{xmlName:"Start",required:true,serializedName:"Start",type:{name:"Number"}},end:{xmlName:"End",required:true,serializedName:"End",type:{name:"Number"}}}}};var PageList={serializedName:"PageList",type:{name:"Composite",className:"PageList",modelProperties:{pageRange:{xmlName:"PageRange",xmlElementName:"PageRange",serializedName:"PageRange",type:{name:"Sequence",element:{type:{name:"Composite",className:"PageRange"}}}},clearRange:{xmlName:"ClearRange",xmlElementName:"ClearRange",serializedName:"ClearRange",type:{name:"Sequence",element:{type:{name:"Composite",className:"ClearRange"}}}}}}};var SignedIdentifier={serializedName:"SignedIdentifier",type:{name:"Composite",className:"SignedIdentifier",modelProperties:{id:{xmlName:"Id",required:true,serializedName:"Id",type:{name:"String"}},accessPolicy:{xmlName:"AccessPolicy",required:true,serializedName:"AccessPolicy",type:{name:"Composite",className:"AccessPolicy"}}}}};var StaticWebsite={serializedName:"StaticWebsite",type:{name:"Composite",className:"StaticWebsite",modelProperties:{enabled:{xmlName:"Enabled",required:true,serializedName:"Enabled",type:{name:"Boolean"}},indexDocument:{xmlName:"IndexDocument",serializedName:"IndexDocument",type:{name:"String"}},errorDocument404Path:{xmlName:"ErrorDocument404Path",serializedName:"ErrorDocument404Path",type:{name:"String"}}}}};var StorageServiceProperties={serializedName:"StorageServiceProperties",type:{name:"Composite",className:"StorageServiceProperties",modelProperties:{logging:{xmlName:"Logging",serializedName:"Logging",type:{name:"Composite",className:"Logging"}},hourMetrics:{xmlName:"HourMetrics",serializedName:"HourMetrics",type:{name:"Composite",className:"Metrics"}},minuteMetrics:{xmlName:"MinuteMetrics",serializedName:"MinuteMetrics",type:{name:"Composite",className:"Metrics"}},cors:{xmlIsWrapped:true,xmlName:"Cors",xmlElementName:"CorsRule",serializedName:"Cors",type:{name:"Sequence",element:{type:{name:"Composite",className:"CorsRule"}}}},defaultServiceVersion:{xmlName:"DefaultServiceVersion",serializedName:"DefaultServiceVersion",type:{name:"String"}},deleteRetentionPolicy:{xmlName:"DeleteRetentionPolicy",serializedName:"DeleteRetentionPolicy",type:{name:"Composite",className:"RetentionPolicy"}},staticWebsite:{xmlName:"StaticWebsite",serializedName:"StaticWebsite",type:{name:"Composite",className:"StaticWebsite"}}}}};var StorageServiceStats={serializedName:"StorageServiceStats",type:{name:"Composite",className:"StorageServiceStats",modelProperties:{geoReplication:{xmlName:"GeoReplication",serializedName:"GeoReplication",type:{name:"Composite",className:"GeoReplication"}}}}};var ServiceSetPropertiesHeaders={serializedName:"service-setproperties-headers",type:{name:"Composite",className:"ServiceSetPropertiesHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ServiceGetPropertiesHeaders={serializedName:"service-getproperties-headers",type:{name:"Composite",className:"ServiceGetPropertiesHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ServiceGetStatisticsHeaders={serializedName:"service-getstatistics-headers",type:{name:"Composite",className:"ServiceGetStatisticsHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ServiceListContainersSegmentHeaders={serializedName:"service-listcontainerssegment-headers",type:{name:"Composite",className:"ServiceListContainersSegmentHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ServiceGetAccountInfoHeaders={serializedName:"service-getaccountinfo-headers",type:{name:"Composite",className:"ServiceGetAccountInfoHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},skuName:{serializedName:"x-ms-sku-name",type:{name:"Enum",allowedValues:["Standard_LRS","Standard_GRS","Standard_RAGRS","Standard_ZRS","Premium_LRS"]}},accountKind:{serializedName:"x-ms-account-kind",type:{name:"Enum",allowedValues:["Storage","BlobStorage","StorageV2"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerCreateHeaders={serializedName:"container-create-headers",type:{name:"Composite",className:"ContainerCreateHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerGetPropertiesHeaders={serializedName:"container-getproperties-headers",type:{name:"Composite",className:"ContainerGetPropertiesHeaders",modelProperties:{metadata:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseDuration:{serializedName:"x-ms-lease-duration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},leaseState:{serializedName:"x-ms-lease-state",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseStatus:{serializedName:"x-ms-lease-status",type:{name:"Enum",allowedValues:["locked","unlocked"]}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobPublicAccess:{serializedName:"x-ms-blob-public-access",type:{name:"String"}},hasImmutabilityPolicy:{serializedName:"x-ms-has-immutability-policy",type:{name:"Boolean"}},hasLegalHold:{serializedName:"x-ms-has-legal-hold",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerDeleteHeaders={serializedName:"container-delete-headers",type:{name:"Composite",className:"ContainerDeleteHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerSetMetadataHeaders={serializedName:"container-setmetadata-headers",type:{name:"Composite",className:"ContainerSetMetadataHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerGetAccessPolicyHeaders={serializedName:"container-getaccesspolicy-headers",type:{name:"Composite",className:"ContainerGetAccessPolicyHeaders",modelProperties:{blobPublicAccess:{serializedName:"x-ms-blob-public-access",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerSetAccessPolicyHeaders={serializedName:"container-setaccesspolicy-headers",type:{name:"Composite",className:"ContainerSetAccessPolicyHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerAcquireLeaseHeaders={serializedName:"container-acquirelease-headers",type:{name:"Composite",className:"ContainerAcquireLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerReleaseLeaseHeaders={serializedName:"container-releaselease-headers",type:{name:"Composite",className:"ContainerReleaseLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerRenewLeaseHeaders={serializedName:"container-renewlease-headers",type:{name:"Composite",className:"ContainerRenewLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerBreakLeaseHeaders={serializedName:"container-breaklease-headers",type:{name:"Composite",className:"ContainerBreakLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseTime:{serializedName:"x-ms-lease-time",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerChangeLeaseHeaders={serializedName:"container-changelease-headers",type:{name:"Composite",className:"ContainerChangeLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerListBlobFlatSegmentHeaders={serializedName:"container-listblobflatsegment-headers",type:{name:"Composite",className:"ContainerListBlobFlatSegmentHeaders",modelProperties:{contentType:{serializedName:"content-type",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerListBlobHierarchySegmentHeaders={serializedName:"container-listblobhierarchysegment-headers",type:{name:"Composite",className:"ContainerListBlobHierarchySegmentHeaders",modelProperties:{contentType:{serializedName:"content-type",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var ContainerGetAccountInfoHeaders={serializedName:"container-getaccountinfo-headers",type:{name:"Composite",className:"ContainerGetAccountInfoHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},skuName:{serializedName:"x-ms-sku-name",type:{name:"Enum",allowedValues:["Standard_LRS","Standard_GRS","Standard_RAGRS","Standard_ZRS","Premium_LRS"]}},accountKind:{serializedName:"x-ms-account-kind",type:{name:"Enum",allowedValues:["Storage","BlobStorage","StorageV2"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobDownloadHeaders={serializedName:"blob-download-headers",type:{name:"Composite",className:"BlobDownloadHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},metadata:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"},contentLength:{serializedName:"content-length",type:{name:"Number"}},contentType:{serializedName:"content-type",type:{name:"String"}},contentRange:{serializedName:"content-range",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},contentEncoding:{serializedName:"content-encoding",type:{name:"String"}},cacheControl:{serializedName:"cache-control",type:{name:"String"}},contentDisposition:{serializedName:"content-disposition",type:{name:"String"}},contentLanguage:{serializedName:"content-language",type:{name:"String"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},blobType:{serializedName:"x-ms-blob-type",type:{name:"Enum",allowedValues:["BlockBlob","PageBlob","AppendBlob"]}},copyCompletionTime:{serializedName:"x-ms-copy-completion-time",type:{name:"DateTimeRfc1123"}},copyStatusDescription:{serializedName:"x-ms-copy-status-description",type:{name:"String"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyProgress:{serializedName:"x-ms-copy-progress",type:{name:"String"}},copySource:{serializedName:"x-ms-copy-source",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},leaseDuration:{serializedName:"x-ms-lease-duration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},leaseState:{serializedName:"x-ms-lease-state",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseStatus:{serializedName:"x-ms-lease-status",type:{name:"Enum",allowedValues:["locked","unlocked"]}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},acceptRanges:{serializedName:"accept-ranges",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},isServerEncrypted:{serializedName:"x-ms-server-encrypted",type:{name:"Boolean"}},blobContentMD5:{serializedName:"x-ms-blob-content-md5",type:{name:"ByteArray"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobGetPropertiesHeaders={serializedName:"blob-getproperties-headers",type:{name:"Composite",className:"BlobGetPropertiesHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},creationTime:{serializedName:"x-ms-creation-time",type:{name:"DateTimeRfc1123"}},metadata:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"},blobType:{serializedName:"x-ms-blob-type",type:{name:"Enum",allowedValues:["BlockBlob","PageBlob","AppendBlob"]}},copyCompletionTime:{serializedName:"x-ms-copy-completion-time",type:{name:"DateTimeRfc1123"}},copyStatusDescription:{serializedName:"x-ms-copy-status-description",type:{name:"String"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyProgress:{serializedName:"x-ms-copy-progress",type:{name:"String"}},copySource:{serializedName:"x-ms-copy-source",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},isIncrementalCopy:{serializedName:"x-ms-incremental-copy",type:{name:"Boolean"}},destinationSnapshot:{serializedName:"x-ms-copy-destination-snapshot",type:{name:"String"}},leaseDuration:{serializedName:"x-ms-lease-duration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},leaseState:{serializedName:"x-ms-lease-state",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseStatus:{serializedName:"x-ms-lease-status",type:{name:"Enum",allowedValues:["locked","unlocked"]}},contentLength:{serializedName:"content-length",type:{name:"Number"}},contentType:{serializedName:"content-type",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},contentEncoding:{serializedName:"content-encoding",type:{name:"String"}},contentDisposition:{serializedName:"content-disposition",type:{name:"String"}},contentLanguage:{serializedName:"content-language",type:{name:"String"}},cacheControl:{serializedName:"cache-control",type:{name:"String"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},acceptRanges:{serializedName:"accept-ranges",type:{name:"String"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},isServerEncrypted:{serializedName:"x-ms-server-encrypted",type:{name:"Boolean"}},accessTier:{serializedName:"x-ms-access-tier",type:{name:"String"}},accessTierInferred:{serializedName:"x-ms-access-tier-inferred",type:{name:"Boolean"}},archiveStatus:{serializedName:"x-ms-archive-status",type:{name:"String"}},accessTierChangeTime:{serializedName:"x-ms-access-tier-change-time",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobDeleteHeaders={serializedName:"blob-delete-headers",type:{name:"Composite",className:"BlobDeleteHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobCreateHeaders={serializedName:"pageblob-create-headers",type:{name:"Composite",className:"PageBlobCreateHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var AppendBlobCreateHeaders={serializedName:"appendblob-create-headers",type:{name:"Composite",className:"AppendBlobCreateHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlockBlobUploadHeaders={serializedName:"blockblob-upload-headers",type:{name:"Composite",className:"BlockBlobUploadHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobUndeleteHeaders={serializedName:"blob-undelete-headers",type:{name:"Composite",className:"BlobUndeleteHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobSetHTTPHeadersHeaders={serializedName:"blob-sethttpheaders-headers",type:{name:"Composite",className:"BlobSetHTTPHeadersHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobSetMetadataHeaders={serializedName:"blob-setmetadata-headers",type:{name:"Composite",className:"BlobSetMetadataHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobAcquireLeaseHeaders={serializedName:"blob-acquirelease-headers",type:{name:"Composite",className:"BlobAcquireLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobReleaseLeaseHeaders={serializedName:"blob-releaselease-headers",type:{name:"Composite",className:"BlobReleaseLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobRenewLeaseHeaders={serializedName:"blob-renewlease-headers",type:{name:"Composite",className:"BlobRenewLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobChangeLeaseHeaders={serializedName:"blob-changelease-headers",type:{name:"Composite",className:"BlobChangeLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobBreakLeaseHeaders={serializedName:"blob-breaklease-headers",type:{name:"Composite",className:"BlobBreakLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseTime:{serializedName:"x-ms-lease-time",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobCreateSnapshotHeaders={serializedName:"blob-createsnapshot-headers",type:{name:"Composite",className:"BlobCreateSnapshotHeaders",modelProperties:{snapshot:{serializedName:"x-ms-snapshot",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobStartCopyFromURLHeaders={serializedName:"blob-startcopyfromurl-headers",type:{name:"Composite",className:"BlobStartCopyFromURLHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobAbortCopyFromURLHeaders={serializedName:"blob-abortcopyfromurl-headers",type:{name:"Composite",className:"BlobAbortCopyFromURLHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobSetTierHeaders={serializedName:"blob-settier-headers",type:{name:"Composite",className:"BlobSetTierHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlobGetAccountInfoHeaders={serializedName:"blob-getaccountinfo-headers",type:{name:"Composite",className:"BlobGetAccountInfoHeaders",modelProperties:{requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},skuName:{serializedName:"x-ms-sku-name",type:{name:"Enum",allowedValues:["Standard_LRS","Standard_GRS","Standard_RAGRS","Standard_ZRS","Premium_LRS"]}},accountKind:{serializedName:"x-ms-account-kind",type:{name:"Enum",allowedValues:["Storage","BlobStorage","StorageV2"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlockBlobStageBlockHeaders={serializedName:"blockblob-stageblock-headers",type:{name:"Composite",className:"BlockBlobStageBlockHeaders",modelProperties:{contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlockBlobStageBlockFromURLHeaders={serializedName:"blockblob-stageblockfromurl-headers",type:{name:"Composite",className:"BlockBlobStageBlockFromURLHeaders",modelProperties:{contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlockBlobCommitBlockListHeaders={serializedName:"blockblob-commitblocklist-headers",type:{name:"Composite",className:"BlockBlobCommitBlockListHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var BlockBlobGetBlockListHeaders={serializedName:"blockblob-getblocklist-headers",type:{name:"Composite",className:"BlockBlobGetBlockListHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},contentType:{serializedName:"content-type",type:{name:"String"}},blobContentLength:{serializedName:"x-ms-blob-content-length",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobUploadPagesHeaders={serializedName:"pageblob-uploadpages-headers",type:{name:"Composite",className:"PageBlobUploadPagesHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobClearPagesHeaders={serializedName:"pageblob-clearpages-headers",type:{name:"Composite",className:"PageBlobClearPagesHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobGetPageRangesHeaders={serializedName:"pageblob-getpageranges-headers",type:{name:"Composite",className:"PageBlobGetPageRangesHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},blobContentLength:{serializedName:"x-ms-blob-content-length",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobGetPageRangesDiffHeaders={serializedName:"pageblob-getpagerangesdiff-headers",type:{name:"Composite",className:"PageBlobGetPageRangesDiffHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},blobContentLength:{serializedName:"x-ms-blob-content-length",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobResizeHeaders={serializedName:"pageblob-resize-headers",type:{name:"Composite",className:"PageBlobResizeHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobUpdateSequenceNumberHeaders={serializedName:"pageblob-updatesequencenumber-headers",type:{name:"Composite",className:"PageBlobUpdateSequenceNumberHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var PageBlobCopyIncrementalHeaders={serializedName:"pageblob-copyincremental-headers",type:{name:"Composite",className:"PageBlobCopyIncrementalHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var AppendBlobAppendBlockHeaders={serializedName:"appendblob-appendblock-headers",type:{name:"Composite",className:"AppendBlobAppendBlockHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobAppendOffset:{serializedName:"x-ms-blob-append-offset",type:{name:"String"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}};var Mappers=Object.freeze({StorageServiceProperties:StorageServiceProperties,Logging:Logging,RetentionPolicy:RetentionPolicy,Metrics:Metrics,CorsRule:CorsRule,StaticWebsite:StaticWebsite,ServiceSetPropertiesHeaders:ServiceSetPropertiesHeaders,StorageError:StorageError,ServiceGetPropertiesHeaders:ServiceGetPropertiesHeaders,StorageServiceStats:StorageServiceStats,GeoReplication:GeoReplication,ServiceGetStatisticsHeaders:ServiceGetStatisticsHeaders,ListContainersSegmentResponse:ListContainersSegmentResponse,ContainerItem:ContainerItem,ContainerProperties:ContainerProperties,ServiceListContainersSegmentHeaders:ServiceListContainersSegmentHeaders,ServiceGetAccountInfoHeaders:ServiceGetAccountInfoHeaders});var access={parameterPath:["options","access"],mapper:{serializedName:"x-ms-blob-public-access",type:{name:"String"}}};var action0={parameterPath:"action",mapper:{required:true,isConstant:true,serializedName:"x-ms-lease-action",defaultValue:'acquire',type:{name:"String"}}};var action1={parameterPath:"action",mapper:{required:true,isConstant:true,serializedName:"x-ms-lease-action",defaultValue:'release',type:{name:"String"}}};var action2={parameterPath:"action",mapper:{required:true,isConstant:true,serializedName:"x-ms-lease-action",defaultValue:'renew',type:{name:"String"}}};var action3={parameterPath:"action",mapper:{required:true,isConstant:true,serializedName:"x-ms-lease-action",defaultValue:'break',type:{name:"String"}}};var action4={parameterPath:"action",mapper:{required:true,isConstant:true,serializedName:"x-ms-lease-action",defaultValue:'change',type:{name:"String"}}};var appendPosition={parameterPath:["options","appendPositionAccessConditions","appendPosition"],mapper:{serializedName:"x-ms-blob-condition-appendpos",type:{name:"Number"}}};var blobCacheControl={parameterPath:["options","blobHTTPHeaders","blobCacheControl"],mapper:{serializedName:"x-ms-blob-cache-control",type:{name:"String"}}};var blobContentDisposition={parameterPath:["options","blobHTTPHeaders","blobContentDisposition"],mapper:{serializedName:"x-ms-blob-content-disposition",type:{name:"String"}}};var blobContentEncoding={parameterPath:["options","blobHTTPHeaders","blobContentEncoding"],mapper:{serializedName:"x-ms-blob-content-encoding",type:{name:"String"}}};var blobContentLanguage={parameterPath:["options","blobHTTPHeaders","blobContentLanguage"],mapper:{serializedName:"x-ms-blob-content-language",type:{name:"String"}}};var blobContentLength={parameterPath:"blobContentLength",mapper:{required:true,serializedName:"x-ms-blob-content-length",type:{name:"Number"}}};var blobContentMD5={parameterPath:["options","blobHTTPHeaders","blobContentMD5"],mapper:{serializedName:"x-ms-blob-content-md5",type:{name:"ByteArray"}}};var blobContentType={parameterPath:["options","blobHTTPHeaders","blobContentType"],mapper:{serializedName:"x-ms-blob-content-type",type:{name:"String"}}};var blobSequenceNumber={parameterPath:["options","blobSequenceNumber"],mapper:{serializedName:"x-ms-blob-sequence-number",defaultValue:0,type:{name:"Number"}}};var blobType0={parameterPath:"blobType",mapper:{required:true,isConstant:true,serializedName:"x-ms-blob-type",defaultValue:'PageBlob',type:{name:"String"}}};var blobType1={parameterPath:"blobType",mapper:{required:true,isConstant:true,serializedName:"x-ms-blob-type",defaultValue:'AppendBlob',type:{name:"String"}}};var blobType2={parameterPath:"blobType",mapper:{required:true,isConstant:true,serializedName:"x-ms-blob-type",defaultValue:'BlockBlob',type:{name:"String"}}};var blockId={parameterPath:"blockId",mapper:{required:true,serializedName:"blockid",type:{name:"String"}}};var breakPeriod={parameterPath:["options","breakPeriod"],mapper:{serializedName:"x-ms-lease-break-period",type:{name:"Number"}}};var comp0={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'properties',type:{name:"String"}}};var comp1={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'stats',type:{name:"String"}}};var comp10={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'page',type:{name:"String"}}};var comp11={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'pagelist',type:{name:"String"}}};var comp12={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'incrementalcopy',type:{name:"String"}}};var comp13={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'appendblock',type:{name:"String"}}};var comp14={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'block',type:{name:"String"}}};var comp15={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'blocklist',type:{name:"String"}}};var comp2={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'list',type:{name:"String"}}};var comp3={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'metadata',type:{name:"String"}}};var comp4={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'acl',type:{name:"String"}}};var comp5={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'lease',type:{name:"String"}}};var comp6={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'undelete',type:{name:"String"}}};var comp7={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'snapshot',type:{name:"String"}}};var comp8={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'copy',type:{name:"String"}}};var comp9={parameterPath:"comp",mapper:{required:true,isConstant:true,serializedName:"comp",defaultValue:'tier',type:{name:"String"}}};var contentLength={parameterPath:"contentLength",mapper:{required:true,serializedName:"Content-Length",type:{name:"Number"}}};var copyActionAbortConstant={parameterPath:"copyActionAbortConstant",mapper:{required:true,isConstant:true,serializedName:"x-ms-copy-action",defaultValue:'abort',type:{name:"String"}}};var copyId={parameterPath:"copyId",mapper:{required:true,serializedName:"copyid",type:{name:"String"}}};var copySource={parameterPath:"copySource",mapper:{required:true,serializedName:"x-ms-copy-source",type:{name:"String"}}};var deleteSnapshots={parameterPath:["options","deleteSnapshots"],mapper:{serializedName:"x-ms-delete-snapshots",type:{name:"Enum",allowedValues:["include","only"]}}};var delimiter={parameterPath:"delimiter",mapper:{required:true,serializedName:"delimiter",type:{name:"String"}}};var duration={parameterPath:["options","duration"],mapper:{serializedName:"x-ms-lease-duration",type:{name:"Number"}}};var ifMatch={parameterPath:["options","modifiedAccessConditions","ifMatch"],mapper:{serializedName:"If-Match",type:{name:"String"}}};var ifModifiedSince={parameterPath:["options","modifiedAccessConditions","ifModifiedSince"],mapper:{serializedName:"If-Modified-Since",type:{name:"DateTimeRfc1123"}}};var ifNoneMatch={parameterPath:["options","modifiedAccessConditions","ifNoneMatch"],mapper:{serializedName:"If-None-Match",type:{name:"String"}}};var ifSequenceNumberEqualTo={parameterPath:["options","sequenceNumberAccessConditions","ifSequenceNumberEqualTo"],mapper:{serializedName:"x-ms-if-sequence-number-eq",type:{name:"Number"}}};var ifSequenceNumberLessThan={parameterPath:["options","sequenceNumberAccessConditions","ifSequenceNumberLessThan"],mapper:{serializedName:"x-ms-if-sequence-number-lt",type:{name:"Number"}}};var ifSequenceNumberLessThanOrEqualTo={parameterPath:["options","sequenceNumberAccessConditions","ifSequenceNumberLessThanOrEqualTo"],mapper:{serializedName:"x-ms-if-sequence-number-le",type:{name:"Number"}}};var ifUnmodifiedSince={parameterPath:["options","modifiedAccessConditions","ifUnmodifiedSince"],mapper:{serializedName:"If-Unmodified-Since",type:{name:"DateTimeRfc1123"}}};var include0={parameterPath:["options","include"],mapper:{serializedName:"include",type:{name:"Enum",allowedValues:["metadata"]}}};var include1={parameterPath:["options","include"],mapper:{serializedName:"include",type:{name:"Sequence",element:{type:{name:"Enum",allowedValues:["snapshots","metadata","uncommittedblobs","copy","deleted"]}}}},collectionFormat:QueryCollectionFormat.Csv};var leaseId0={parameterPath:["options","leaseAccessConditions","leaseId"],mapper:{serializedName:"x-ms-lease-id",type:{name:"String"}}};var leaseId1={parameterPath:"leaseId",mapper:{required:true,serializedName:"x-ms-lease-id",type:{name:"String"}}};var listType={parameterPath:"listType",mapper:{required:true,serializedName:"blocklisttype",defaultValue:'committed',type:{name:"Enum",allowedValues:["committed","uncommitted","all"]}}};var marker={parameterPath:["options","marker"],mapper:{serializedName:"marker",type:{name:"String"}}};var maxresults={parameterPath:["options","maxresults"],mapper:{serializedName:"maxresults",constraints:{InclusiveMinimum:1},type:{name:"Number"}}};var maxSize={parameterPath:["options","appendPositionAccessConditions","maxSize"],mapper:{serializedName:"x-ms-blob-condition-maxsize",type:{name:"Number"}}};var metadata={parameterPath:["options","metadata"],mapper:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"}};var pageWrite0={parameterPath:"pageWrite",mapper:{required:true,isConstant:true,serializedName:"x-ms-page-write",defaultValue:'update',type:{name:"String"}}};var pageWrite1={parameterPath:"pageWrite",mapper:{required:true,isConstant:true,serializedName:"x-ms-page-write",defaultValue:'clear',type:{name:"String"}}};var prefix={parameterPath:["options","prefix"],mapper:{serializedName:"prefix",type:{name:"String"}}};var prevsnapshot={parameterPath:["options","prevsnapshot"],mapper:{serializedName:"prevsnapshot",type:{name:"String"}}};var proposedLeaseId0={parameterPath:["options","proposedLeaseId"],mapper:{serializedName:"x-ms-proposed-lease-id",type:{name:"String"}}};var proposedLeaseId1={parameterPath:"proposedLeaseId",mapper:{required:true,serializedName:"x-ms-proposed-lease-id",type:{name:"String"}}};var range={parameterPath:["options","range"],mapper:{serializedName:"x-ms-range",type:{name:"String"}}};var rangeGetContentMD5={parameterPath:["options","rangeGetContentMD5"],mapper:{serializedName:"x-ms-range-get-content-md5",type:{name:"Boolean"}}};var requestId={parameterPath:["options","requestId"],mapper:{serializedName:"x-ms-client-request-id",type:{name:"String"}}};var restype0={parameterPath:"restype",mapper:{required:true,isConstant:true,serializedName:"restype",defaultValue:'service',type:{name:"String"}}};var restype1={parameterPath:"restype",mapper:{required:true,isConstant:true,serializedName:"restype",defaultValue:'account',type:{name:"String"}}};var restype2={parameterPath:"restype",mapper:{required:true,isConstant:true,serializedName:"restype",defaultValue:'container',type:{name:"String"}}};var sequenceNumberAction={parameterPath:"sequenceNumberAction",mapper:{required:true,serializedName:"x-ms-sequence-number-action",type:{name:"Enum",allowedValues:["max","update","increment"]}}};var snapshot={parameterPath:["options","snapshot"],mapper:{serializedName:"snapshot",type:{name:"String"}}};var sourceContentMD5={parameterPath:["options","sourceContentMD5"],mapper:{serializedName:"x-ms-source-content-md5",type:{name:"ByteArray"}}};var sourceIfMatch={parameterPath:["options","sourceModifiedAccessConditions","sourceIfMatch"],mapper:{serializedName:"x-ms-source-if-match",type:{name:"String"}}};var sourceIfModifiedSince={parameterPath:["options","sourceModifiedAccessConditions","sourceIfModifiedSince"],mapper:{serializedName:"x-ms-source-if-modified-since",type:{name:"DateTimeRfc1123"}}};var sourceIfNoneMatch={parameterPath:["options","sourceModifiedAccessConditions","sourceIfNoneMatch"],mapper:{serializedName:"x-ms-source-if-none-match",type:{name:"String"}}};var sourceIfUnmodifiedSince={parameterPath:["options","sourceModifiedAccessConditions","sourceIfUnmodifiedSince"],mapper:{serializedName:"x-ms-source-if-unmodified-since",type:{name:"DateTimeRfc1123"}}};var sourceRange={parameterPath:["options","sourceRange"],mapper:{serializedName:"x-ms-source-range",type:{name:"String"}}};var sourceUrl={parameterPath:"sourceUrl",mapper:{required:true,serializedName:"x-ms-copy-source",type:{name:"String"}}};var tier={parameterPath:"tier",mapper:{required:true,serializedName:"x-ms-access-tier",type:{name:"String"}}};var timeout={parameterPath:["options","timeout"],mapper:{serializedName:"timeout",constraints:{InclusiveMinimum:0},type:{name:"Number"}}};var transactionalContentMD5={parameterPath:["options","transactionalContentMD5"],mapper:{serializedName:"Content-MD5",type:{name:"ByteArray"}}};var url={parameterPath:"url",mapper:{required:true,serializedName:"url",defaultValue:'',type:{name:"String"}},skipEncoding:true};var version={parameterPath:"version",mapper:{required:true,isConstant:true,serializedName:"x-ms-version",defaultValue:'2018-03-28',type:{name:"String"}}};var Service=(function(){function Service(client){this.client=client;}
Service.prototype.setProperties=function(storageServiceProperties,options,callback){return this.client.sendOperationRequest({storageServiceProperties:storageServiceProperties,options:options},setPropertiesOperationSpec,callback);};Service.prototype.getProperties=function(options,callback){return this.client.sendOperationRequest({options:options},getPropertiesOperationSpec,callback);};Service.prototype.getStatistics=function(options,callback){return this.client.sendOperationRequest({options:options},getStatisticsOperationSpec,callback);};Service.prototype.listContainersSegment=function(options,callback){return this.client.sendOperationRequest({options:options},listContainersSegmentOperationSpec,callback);};Service.prototype.getAccountInfo=function(options,callback){return this.client.sendOperationRequest({options:options},getAccountInfoOperationSpec,callback);};return Service;}());var serializer$1=new Serializer(Mappers,true);var setPropertiesOperationSpec={httpMethod:"PUT",urlParameters:[url],queryParameters:[timeout,restype0,comp0],headerParameters:[version,requestId],requestBody:{parameterPath:"storageServiceProperties",mapper:__assign({},StorageServiceProperties,{required:true})},contentType:"application/xml; charset=utf-8",responses:{202:{headersMapper:ServiceSetPropertiesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$1};var getPropertiesOperationSpec={httpMethod:"GET",urlParameters:[url],queryParameters:[timeout,restype0,comp0],headerParameters:[version,requestId],responses:{200:{bodyMapper:StorageServiceProperties,headersMapper:ServiceGetPropertiesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$1};var getStatisticsOperationSpec={httpMethod:"GET",urlParameters:[url],queryParameters:[timeout,restype0,comp1],headerParameters:[version,requestId],responses:{200:{bodyMapper:StorageServiceStats,headersMapper:ServiceGetStatisticsHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$1};var listContainersSegmentOperationSpec={httpMethod:"GET",urlParameters:[url],queryParameters:[prefix,marker,maxresults,include0,timeout,comp2],headerParameters:[version,requestId],responses:{200:{bodyMapper:ListContainersSegmentResponse,headersMapper:ServiceListContainersSegmentHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$1};var getAccountInfoOperationSpec={httpMethod:"GET",urlParameters:[url],queryParameters:[restype1,comp0],headerParameters:[version],responses:{200:{headersMapper:ServiceGetAccountInfoHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$1};var Mappers$1=Object.freeze({ContainerCreateHeaders:ContainerCreateHeaders,StorageError:StorageError,ContainerGetPropertiesHeaders:ContainerGetPropertiesHeaders,ContainerDeleteHeaders:ContainerDeleteHeaders,ContainerSetMetadataHeaders:ContainerSetMetadataHeaders,SignedIdentifier:SignedIdentifier,AccessPolicy:AccessPolicy,ContainerGetAccessPolicyHeaders:ContainerGetAccessPolicyHeaders,ContainerSetAccessPolicyHeaders:ContainerSetAccessPolicyHeaders,ContainerAcquireLeaseHeaders:ContainerAcquireLeaseHeaders,ContainerReleaseLeaseHeaders:ContainerReleaseLeaseHeaders,ContainerRenewLeaseHeaders:ContainerRenewLeaseHeaders,ContainerBreakLeaseHeaders:ContainerBreakLeaseHeaders,ContainerChangeLeaseHeaders:ContainerChangeLeaseHeaders,ListBlobsFlatSegmentResponse:ListBlobsFlatSegmentResponse,BlobFlatListSegment:BlobFlatListSegment,BlobItem:BlobItem,BlobProperties:BlobProperties,ContainerListBlobFlatSegmentHeaders:ContainerListBlobFlatSegmentHeaders,ListBlobsHierarchySegmentResponse:ListBlobsHierarchySegmentResponse,BlobHierarchyListSegment:BlobHierarchyListSegment,BlobPrefix:BlobPrefix,ContainerListBlobHierarchySegmentHeaders:ContainerListBlobHierarchySegmentHeaders,ContainerGetAccountInfoHeaders:ContainerGetAccountInfoHeaders});var Container=(function(){function Container(client){this.client=client;}
Container.prototype.create=function(options,callback){return this.client.sendOperationRequest({options:options},createOperationSpec,callback);};Container.prototype.getProperties=function(options,callback){return this.client.sendOperationRequest({options:options},getPropertiesOperationSpec$1,callback);};Container.prototype.deleteMethod=function(options,callback){return this.client.sendOperationRequest({options:options},deleteMethodOperationSpec,callback);};Container.prototype.setMetadata=function(options,callback){return this.client.sendOperationRequest({options:options},setMetadataOperationSpec,callback);};Container.prototype.getAccessPolicy=function(options,callback){return this.client.sendOperationRequest({options:options},getAccessPolicyOperationSpec,callback);};Container.prototype.setAccessPolicy=function(options,callback){return this.client.sendOperationRequest({options:options},setAccessPolicyOperationSpec,callback);};Container.prototype.acquireLease=function(options,callback){return this.client.sendOperationRequest({options:options},acquireLeaseOperationSpec,callback);};Container.prototype.releaseLease=function(leaseId,options,callback){return this.client.sendOperationRequest({leaseId:leaseId,options:options},releaseLeaseOperationSpec,callback);};Container.prototype.renewLease=function(leaseId,options,callback){return this.client.sendOperationRequest({leaseId:leaseId,options:options},renewLeaseOperationSpec,callback);};Container.prototype.breakLease=function(options,callback){return this.client.sendOperationRequest({options:options},breakLeaseOperationSpec,callback);};Container.prototype.changeLease=function(leaseId,proposedLeaseId,options,callback){return this.client.sendOperationRequest({leaseId:leaseId,proposedLeaseId:proposedLeaseId,options:options},changeLeaseOperationSpec,callback);};Container.prototype.listBlobFlatSegment=function(options,callback){return this.client.sendOperationRequest({options:options},listBlobFlatSegmentOperationSpec,callback);};Container.prototype.listBlobHierarchySegment=function(delimiter$$1,options,callback){return this.client.sendOperationRequest({delimiter:delimiter$$1,options:options},listBlobHierarchySegmentOperationSpec,callback);};Container.prototype.getAccountInfo=function(options,callback){return this.client.sendOperationRequest({options:options},getAccountInfoOperationSpec$1,callback);};return Container;}());var serializer$2=new Serializer(Mappers$1,true);var createOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,restype2],headerParameters:[metadata,access,version,requestId],responses:{201:{headersMapper:ContainerCreateHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var getPropertiesOperationSpec$1={httpMethod:"GET",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,restype2],headerParameters:[version,requestId,leaseId0],responses:{200:{headersMapper:ContainerGetPropertiesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var deleteMethodOperationSpec={httpMethod:"DELETE",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,restype2],headerParameters:[version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince],responses:{202:{headersMapper:ContainerDeleteHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var setMetadataOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,restype2,comp3],headerParameters:[metadata,version,requestId,leaseId0,ifModifiedSince],responses:{200:{headersMapper:ContainerSetMetadataHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var getAccessPolicyOperationSpec={httpMethod:"GET",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,restype2,comp4],headerParameters:[version,requestId,leaseId0],responses:{200:{bodyMapper:{xmlElementName:"SignedIdentifier",serializedName:"parsedResponse",type:{name:"Sequence",element:{type:{name:"Composite",className:"SignedIdentifier"}}}},headersMapper:ContainerGetAccessPolicyHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var setAccessPolicyOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,restype2,comp4],headerParameters:[access,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince],requestBody:{parameterPath:["options","containerAcl"],mapper:{xmlName:"SignedIdentifiers",xmlElementName:"SignedIdentifier",serializedName:"containerAcl",type:{name:"Sequence",element:{type:{name:"Composite",className:"SignedIdentifier"}}}}},contentType:"application/xml; charset=utf-8",responses:{200:{headersMapper:ContainerSetAccessPolicyHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var acquireLeaseOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,comp5,restype2],headerParameters:[duration,proposedLeaseId0,version,requestId,action0,ifModifiedSince,ifUnmodifiedSince],responses:{201:{headersMapper:ContainerAcquireLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var releaseLeaseOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,comp5,restype2],headerParameters:[leaseId1,version,requestId,action1,ifModifiedSince,ifUnmodifiedSince],responses:{200:{headersMapper:ContainerReleaseLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var renewLeaseOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,comp5,restype2],headerParameters:[leaseId1,version,requestId,action2,ifModifiedSince,ifUnmodifiedSince],responses:{200:{headersMapper:ContainerRenewLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var breakLeaseOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,comp5,restype2],headerParameters:[breakPeriod,version,requestId,action3,ifModifiedSince,ifUnmodifiedSince],responses:{202:{headersMapper:ContainerBreakLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var changeLeaseOperationSpec={httpMethod:"PUT",path:"{containerName}",urlParameters:[url],queryParameters:[timeout,comp5,restype2],headerParameters:[leaseId1,proposedLeaseId1,version,requestId,action4,ifModifiedSince,ifUnmodifiedSince],responses:{200:{headersMapper:ContainerChangeLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var listBlobFlatSegmentOperationSpec={httpMethod:"GET",path:"{containerName}",urlParameters:[url],queryParameters:[prefix,marker,maxresults,include1,timeout,restype2,comp2],headerParameters:[version,requestId],responses:{200:{bodyMapper:ListBlobsFlatSegmentResponse,headersMapper:ContainerListBlobFlatSegmentHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var listBlobHierarchySegmentOperationSpec={httpMethod:"GET",path:"{containerName}",urlParameters:[url],queryParameters:[prefix,delimiter,marker,maxresults,include1,timeout,restype2,comp2],headerParameters:[version,requestId],responses:{200:{bodyMapper:ListBlobsHierarchySegmentResponse,headersMapper:ContainerListBlobHierarchySegmentHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var getAccountInfoOperationSpec$1={httpMethod:"GET",path:"{containerName}",urlParameters:[url],queryParameters:[restype1,comp0],headerParameters:[version],responses:{200:{headersMapper:ContainerGetAccountInfoHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$2};var Mappers$2=Object.freeze({BlobDownloadHeaders:BlobDownloadHeaders,StorageError:StorageError,BlobGetPropertiesHeaders:BlobGetPropertiesHeaders,BlobDeleteHeaders:BlobDeleteHeaders,BlobUndeleteHeaders:BlobUndeleteHeaders,BlobSetHTTPHeadersHeaders:BlobSetHTTPHeadersHeaders,BlobSetMetadataHeaders:BlobSetMetadataHeaders,BlobAcquireLeaseHeaders:BlobAcquireLeaseHeaders,BlobReleaseLeaseHeaders:BlobReleaseLeaseHeaders,BlobRenewLeaseHeaders:BlobRenewLeaseHeaders,BlobChangeLeaseHeaders:BlobChangeLeaseHeaders,BlobBreakLeaseHeaders:BlobBreakLeaseHeaders,BlobCreateSnapshotHeaders:BlobCreateSnapshotHeaders,BlobStartCopyFromURLHeaders:BlobStartCopyFromURLHeaders,BlobAbortCopyFromURLHeaders:BlobAbortCopyFromURLHeaders,BlobSetTierHeaders:BlobSetTierHeaders,BlobGetAccountInfoHeaders:BlobGetAccountInfoHeaders});var Blob$1=(function(){function Blob(client){this.client=client;}
Blob.prototype.download=function(options,callback){return this.client.sendOperationRequest({options:options},downloadOperationSpec,callback);};Blob.prototype.getProperties=function(options,callback){return this.client.sendOperationRequest({options:options},getPropertiesOperationSpec$2,callback);};Blob.prototype.deleteMethod=function(options,callback){return this.client.sendOperationRequest({options:options},deleteMethodOperationSpec$1,callback);};Blob.prototype.undelete=function(options,callback){return this.client.sendOperationRequest({options:options},undeleteOperationSpec,callback);};Blob.prototype.setHTTPHeaders=function(options,callback){return this.client.sendOperationRequest({options:options},setHTTPHeadersOperationSpec,callback);};Blob.prototype.setMetadata=function(options,callback){return this.client.sendOperationRequest({options:options},setMetadataOperationSpec$1,callback);};Blob.prototype.acquireLease=function(options,callback){return this.client.sendOperationRequest({options:options},acquireLeaseOperationSpec$1,callback);};Blob.prototype.releaseLease=function(leaseId,options,callback){return this.client.sendOperationRequest({leaseId:leaseId,options:options},releaseLeaseOperationSpec$1,callback);};Blob.prototype.renewLease=function(leaseId,options,callback){return this.client.sendOperationRequest({leaseId:leaseId,options:options},renewLeaseOperationSpec$1,callback);};Blob.prototype.changeLease=function(leaseId,proposedLeaseId,options,callback){return this.client.sendOperationRequest({leaseId:leaseId,proposedLeaseId:proposedLeaseId,options:options},changeLeaseOperationSpec$1,callback);};Blob.prototype.breakLease=function(options,callback){return this.client.sendOperationRequest({options:options},breakLeaseOperationSpec$1,callback);};Blob.prototype.createSnapshot=function(options,callback){return this.client.sendOperationRequest({options:options},createSnapshotOperationSpec,callback);};Blob.prototype.startCopyFromURL=function(copySource$$1,options,callback){return this.client.sendOperationRequest({copySource:copySource$$1,options:options},startCopyFromURLOperationSpec,callback);};Blob.prototype.abortCopyFromURL=function(copyId$$1,options,callback){return this.client.sendOperationRequest({copyId:copyId$$1,options:options},abortCopyFromURLOperationSpec,callback);};Blob.prototype.setTier=function(tier$$1,options,callback){return this.client.sendOperationRequest({tier:tier$$1,options:options},setTierOperationSpec,callback);};Blob.prototype.getAccountInfo=function(options,callback){return this.client.sendOperationRequest({options:options},getAccountInfoOperationSpec$2,callback);};return Blob;}());var serializer$3=new Serializer(Mappers$2,true);var downloadOperationSpec={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[snapshot,timeout],headerParameters:[range,rangeGetContentMD5,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{bodyMapper:{serializedName:"parsedResponse",type:{name:"Stream"}},headersMapper:BlobDownloadHeaders},206:{bodyMapper:{serializedName:"parsedResponse",type:{name:"Stream"}},headersMapper:BlobDownloadHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var getPropertiesOperationSpec$2={httpMethod:"HEAD",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[snapshot,timeout],headerParameters:[version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:BlobGetPropertiesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var deleteMethodOperationSpec$1={httpMethod:"DELETE",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[snapshot,timeout],headerParameters:[deleteSnapshots,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{202:{headersMapper:BlobDeleteHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var undeleteOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp6],headerParameters:[version,requestId],responses:{200:{headersMapper:BlobUndeleteHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var setHTTPHeadersOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp0],headerParameters:[version,requestId,blobCacheControl,blobContentType,blobContentMD5,blobContentEncoding,blobContentLanguage,blobContentDisposition,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:BlobSetHTTPHeadersHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var setMetadataOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp3],headerParameters:[metadata,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:BlobSetMetadataHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var acquireLeaseOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp5],headerParameters:[duration,proposedLeaseId0,version,requestId,action0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{201:{headersMapper:BlobAcquireLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var releaseLeaseOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp5],headerParameters:[leaseId1,version,requestId,action1,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:BlobReleaseLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var renewLeaseOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp5],headerParameters:[leaseId1,version,requestId,action2,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:BlobRenewLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var changeLeaseOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp5],headerParameters:[leaseId1,proposedLeaseId1,version,requestId,action4,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:BlobChangeLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var breakLeaseOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp5],headerParameters:[breakPeriod,version,requestId,action3,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{202:{headersMapper:BlobBreakLeaseHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var createSnapshotOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp7],headerParameters:[metadata,version,requestId,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch,leaseId0],responses:{201:{headersMapper:BlobCreateSnapshotHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var startCopyFromURLOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout],headerParameters:[metadata,copySource,version,requestId,sourceIfModifiedSince,sourceIfUnmodifiedSince,sourceIfMatch,sourceIfNoneMatch,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch,leaseId0],responses:{202:{headersMapper:BlobStartCopyFromURLHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var abortCopyFromURLOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[copyId,timeout,comp8],headerParameters:[version,requestId,copyActionAbortConstant,leaseId0],responses:{204:{headersMapper:BlobAbortCopyFromURLHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var setTierOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp9],headerParameters:[tier,version,requestId,leaseId0],responses:{200:{headersMapper:BlobSetTierHeaders},202:{headersMapper:BlobSetTierHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var getAccountInfoOperationSpec$2={httpMethod:"GET",path:"{containerName}/{blobName}",urlParameters:[url],queryParameters:[restype1,comp0],headerParameters:[version],responses:{200:{headersMapper:BlobGetAccountInfoHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$3};var Mappers$3=Object.freeze({PageBlobCreateHeaders:PageBlobCreateHeaders,StorageError:StorageError,PageBlobUploadPagesHeaders:PageBlobUploadPagesHeaders,PageBlobClearPagesHeaders:PageBlobClearPagesHeaders,PageList:PageList,PageRange:PageRange,ClearRange:ClearRange,PageBlobGetPageRangesHeaders:PageBlobGetPageRangesHeaders,PageBlobGetPageRangesDiffHeaders:PageBlobGetPageRangesDiffHeaders,PageBlobResizeHeaders:PageBlobResizeHeaders,PageBlobUpdateSequenceNumberHeaders:PageBlobUpdateSequenceNumberHeaders,PageBlobCopyIncrementalHeaders:PageBlobCopyIncrementalHeaders});var PageBlob=(function(){function PageBlob(client){this.client=client;}
PageBlob.prototype.create=function(contentLength$$1,blobContentLength$$1,options,callback){return this.client.sendOperationRequest({contentLength:contentLength$$1,blobContentLength:blobContentLength$$1,options:options},createOperationSpec$1,callback);};PageBlob.prototype.uploadPages=function(body,contentLength$$1,options,callback){return this.client.sendOperationRequest({body:body,contentLength:contentLength$$1,options:options},uploadPagesOperationSpec,callback);};PageBlob.prototype.clearPages=function(contentLength$$1,options,callback){return this.client.sendOperationRequest({contentLength:contentLength$$1,options:options},clearPagesOperationSpec,callback);};PageBlob.prototype.getPageRanges=function(options,callback){return this.client.sendOperationRequest({options:options},getPageRangesOperationSpec,callback);};PageBlob.prototype.getPageRangesDiff=function(options,callback){return this.client.sendOperationRequest({options:options},getPageRangesDiffOperationSpec,callback);};PageBlob.prototype.resize=function(blobContentLength$$1,options,callback){return this.client.sendOperationRequest({blobContentLength:blobContentLength$$1,options:options},resizeOperationSpec,callback);};PageBlob.prototype.updateSequenceNumber=function(sequenceNumberAction$$1,options,callback){return this.client.sendOperationRequest({sequenceNumberAction:sequenceNumberAction$$1,options:options},updateSequenceNumberOperationSpec,callback);};PageBlob.prototype.copyIncremental=function(copySource$$1,options,callback){return this.client.sendOperationRequest({copySource:copySource$$1,options:options},copyIncrementalOperationSpec,callback);};return PageBlob;}());var serializer$4=new Serializer(Mappers$3,true);var createOperationSpec$1={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout],headerParameters:[contentLength,metadata,blobContentLength,blobSequenceNumber,version,requestId,blobType0,blobContentType,blobContentEncoding,blobContentLanguage,blobContentMD5,blobCacheControl,blobContentDisposition,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{201:{headersMapper:PageBlobCreateHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var uploadPagesOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp10],headerParameters:[contentLength,transactionalContentMD5,range,version,requestId,pageWrite0,leaseId0,ifSequenceNumberLessThanOrEqualTo,ifSequenceNumberLessThan,ifSequenceNumberEqualTo,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],requestBody:{parameterPath:"body",mapper:{required:true,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:PageBlobUploadPagesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var clearPagesOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp10],headerParameters:[contentLength,range,version,requestId,pageWrite1,leaseId0,ifSequenceNumberLessThanOrEqualTo,ifSequenceNumberLessThan,ifSequenceNumberEqualTo,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{201:{headersMapper:PageBlobClearPagesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var getPageRangesOperationSpec={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[snapshot,timeout,comp11],headerParameters:[range,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{bodyMapper:PageList,headersMapper:PageBlobGetPageRangesHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var getPageRangesDiffOperationSpec={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[snapshot,timeout,prevsnapshot,comp11],headerParameters:[range,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{bodyMapper:PageList,headersMapper:PageBlobGetPageRangesDiffHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var resizeOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp0],headerParameters:[blobContentLength,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:PageBlobResizeHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var updateSequenceNumberOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp0],headerParameters:[sequenceNumberAction,blobSequenceNumber,version,requestId,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{200:{headersMapper:PageBlobUpdateSequenceNumberHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var copyIncrementalOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp12],headerParameters:[copySource,version,requestId,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{202:{headersMapper:PageBlobCopyIncrementalHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$4};var Mappers$4=Object.freeze({AppendBlobCreateHeaders:AppendBlobCreateHeaders,StorageError:StorageError,AppendBlobAppendBlockHeaders:AppendBlobAppendBlockHeaders});var AppendBlob=(function(){function AppendBlob(client){this.client=client;}
AppendBlob.prototype.create=function(contentLength$$1,options,callback){return this.client.sendOperationRequest({contentLength:contentLength$$1,options:options},createOperationSpec$2,callback);};AppendBlob.prototype.appendBlock=function(body,contentLength$$1,options,callback){return this.client.sendOperationRequest({body:body,contentLength:contentLength$$1,options:options},appendBlockOperationSpec,callback);};return AppendBlob;}());var serializer$5=new Serializer(Mappers$4,true);var createOperationSpec$2={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout],headerParameters:[contentLength,metadata,version,requestId,blobType1,blobContentType,blobContentEncoding,blobContentLanguage,blobContentMD5,blobCacheControl,blobContentDisposition,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],responses:{201:{headersMapper:AppendBlobCreateHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$5};var appendBlockOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp13],headerParameters:[contentLength,transactionalContentMD5,version,requestId,leaseId0,maxSize,appendPosition,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],requestBody:{parameterPath:"body",mapper:{required:true,serializedName:"body",type:{name:"Stream"}}},contentType:"application/xml; charset=utf-8",responses:{201:{headersMapper:AppendBlobAppendBlockHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$5};var Mappers$5=Object.freeze({BlockBlobUploadHeaders:BlockBlobUploadHeaders,StorageError:StorageError,BlockBlobStageBlockHeaders:BlockBlobStageBlockHeaders,BlockBlobStageBlockFromURLHeaders:BlockBlobStageBlockFromURLHeaders,BlockLookupList:BlockLookupList,BlockBlobCommitBlockListHeaders:BlockBlobCommitBlockListHeaders,BlockList:BlockList,Block:Block,BlockBlobGetBlockListHeaders:BlockBlobGetBlockListHeaders});var BlockBlob=(function(){function BlockBlob(client){this.client=client;}
BlockBlob.prototype.upload=function(body,contentLength$$1,options,callback){return this.client.sendOperationRequest({body:body,contentLength:contentLength$$1,options:options},uploadOperationSpec,callback);};BlockBlob.prototype.stageBlock=function(blockId$$1,contentLength$$1,body,options,callback){return this.client.sendOperationRequest({blockId:blockId$$1,contentLength:contentLength$$1,body:body,options:options},stageBlockOperationSpec,callback);};BlockBlob.prototype.stageBlockFromURL=function(blockId$$1,contentLength$$1,sourceUrl$$1,options,callback){return this.client.sendOperationRequest({blockId:blockId$$1,contentLength:contentLength$$1,sourceUrl:sourceUrl$$1,options:options},stageBlockFromURLOperationSpec,callback);};BlockBlob.prototype.commitBlockList=function(blocks,options,callback){return this.client.sendOperationRequest({blocks:blocks,options:options},commitBlockListOperationSpec,callback);};BlockBlob.prototype.getBlockList=function(listType$$1,options,callback){return this.client.sendOperationRequest({listType:listType$$1,options:options},getBlockListOperationSpec,callback);};return BlockBlob;}());var serializer$6=new Serializer(Mappers$5,true);var uploadOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout],headerParameters:[contentLength,metadata,version,requestId,blobType2,blobContentType,blobContentEncoding,blobContentLanguage,blobContentMD5,blobCacheControl,blobContentDisposition,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],requestBody:{parameterPath:"body",mapper:{required:true,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:BlockBlobUploadHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$6};var stageBlockOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[blockId,timeout,comp14],headerParameters:[contentLength,transactionalContentMD5,version,requestId,leaseId0],requestBody:{parameterPath:"body",mapper:{required:true,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:BlockBlobStageBlockHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$6};var stageBlockFromURLOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[blockId,timeout,comp14],headerParameters:[contentLength,sourceUrl,sourceRange,sourceContentMD5,version,requestId,leaseId0],responses:{201:{headersMapper:BlockBlobStageBlockFromURLHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$6};var commitBlockListOperationSpec={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[timeout,comp15],headerParameters:[metadata,version,requestId,blobCacheControl,blobContentType,blobContentEncoding,blobContentLanguage,blobContentMD5,blobContentDisposition,leaseId0,ifModifiedSince,ifUnmodifiedSince,ifMatch,ifNoneMatch],requestBody:{parameterPath:"blocks",mapper:__assign({},BlockLookupList,{required:true})},contentType:"application/xml; charset=utf-8",responses:{201:{headersMapper:BlockBlobCommitBlockListHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$6};var getBlockListOperationSpec={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[url],queryParameters:[snapshot,listType,timeout,comp15],headerParameters:[version,requestId,leaseId0],responses:{200:{bodyMapper:BlockList,headersMapper:BlockBlobGetBlockListHeaders},default:{bodyMapper:StorageError}},isXML:true,serializer:serializer$6};function rangeToString(iRange){if(iRange.offset<0){throw new RangeError("IRange.offset cannot be smaller than 0.");}
if(iRange.count&&iRange.count<=0){throw new RangeError("IRange.count must be larger than 0. Leave it undefined if you want a range from offset to the end.");}
return iRange.count?"bytes="+iRange.offset+"-"+(iRange.offset+iRange.count-1):"bytes="+iRange.offset+"-";}
var BLOCK_BLOB_MAX_UPLOAD_BLOB_BYTES=256*1024*1024;var BLOCK_BLOB_MAX_STAGE_BLOCK_BYTES=100*1024*1024;var BLOCK_BLOB_MAX_BLOCKS=50000;var DEFAULT_BLOB_DOWNLOAD_BLOCK_BYTES=4*1024*1024;var DEFAULT_MAX_DOWNLOAD_RETRY_REQUESTS=5;var URLConstants={Parameters:{FORCE_BROWSER_NO_CACHE:"_",SIGNATURE:"sig",SNAPSHOT:"snapshot",TIMEOUT:"timeout"}};var HTTPURLConnection={HTTP_CONFLICT:409,HTTP_NOT_FOUND:404,HTTP_PRECON_FAILED:412,HTTP_RANGE_NOT_SATISFIABLE:416};var HeaderConstants$2={AUTHORIZATION:"authorization",AUTHORIZATION_SCHEME:"Bearer",CONTENT_ENCODING:"content-encoding",CONTENT_LANGUAGE:"content-language",CONTENT_LENGTH:"content-length",CONTENT_MD5:"content-md5",CONTENT_TYPE:"content-type",COOKIE:"Cookie",DATE:"date",IF_MATCH:"if-match",IF_MODIFIED_SINCE:"if-modified-since",IF_NONE_MATCH:"if-none-match",IF_UNMODIFIED_SINCE:"if-unmodified-since",PREFIX_FOR_STORAGE:"x-ms-",RANGE:"Range",USER_AGENT:"User-Agent",X_MS_CLIENT_REQUEST_ID:"x-ms-client-request-id",X_MS_DATE:"x-ms-date"};var ETagNone="";function escapeURLPath(url){var urlParsed=URLBuilder.parse(url);var path=urlParsed.getPath();path=path||"/";path=escape(path);urlParsed.setPath(path);return urlParsed.toString();}
function escape(text){return encodeURIComponent(text).replace(/%2F/g,"/").replace(/'/g,"%27").replace(/\+/g,"%20").replace(/%25/g,"%");}
function appendToURLPath(url,name){var urlParsed=URLBuilder.parse(url);var path=urlParsed.getPath();path=path?path.endsWith("/")?""+path+name:path+"/"+name:name;urlParsed.setPath(path);return urlParsed.toString();}
function setURLParameter(url,name,value){var urlParsed=URLBuilder.parse(url);urlParsed.setQueryParameter(name,value);return urlParsed.toString();}
function getURLParameter(url,name){var urlParsed=URLBuilder.parse(url);return urlParsed.getQueryParameterValue(name);}
function setURLHost(url,host){var urlParsed=URLBuilder.parse(url);urlParsed.setHost(host);return urlParsed.toString();}
function truncatedISO8061Date(date,withMilliseconds){if(withMilliseconds===void 0){withMilliseconds=true;}
var dateString=date.toISOString();return withMilliseconds?dateString.substring(0,dateString.length-1)+"0000"+"Z":dateString.substring(0,dateString.length-5)+"Z";}
function base64encode(content){return!isNode?btoa(content):Buffer.from(content).toString("base64");}
function generateBlockID(blockIDPrefix,blockIndex){var maxSourceStringLength=48;var maxBlockIndexLength=6;var maxAllowedBlockIDPrefixLength=maxSourceStringLength-maxBlockIndexLength;if(blockIDPrefix.length>maxAllowedBlockIDPrefixLength){blockIDPrefix=blockIDPrefix.slice(0,maxAllowedBlockIDPrefixLength);}
var res=blockIDPrefix+padStart(blockIndex.toString(),maxSourceStringLength-blockIDPrefix.length,"0");return base64encode(res);}
function padStart(currentString,targetLength,padString){if(padString===void 0){padString=" ";}
if(String.prototype.padStart){return currentString.padStart(targetLength,padString);}
padString=padString||" ";if(currentString.length>targetLength){return currentString;}
else{targetLength=targetLength-currentString.length;if(targetLength>padString.length){padString+=padString.repeat(targetLength/padString.length);}
return padString.slice(0,targetLength)+currentString;}}
var BrowserPolicy=(function(_super){__extends(BrowserPolicy,_super);function BrowserPolicy(nextPolicy,options){return _super.call(this,nextPolicy,options)||this;}
BrowserPolicy.prototype.sendRequest=function(request){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){if(request.method.toUpperCase()==="GET"||request.method.toUpperCase()==="HEAD"){request.url=setURLParameter(request.url,URLConstants.Parameters.FORCE_BROWSER_NO_CACHE,new Date().getTime().toString());}
request.headers.remove(HeaderConstants$2.COOKIE);request.headers.remove(HeaderConstants$2.CONTENT_LENGTH);return[2,this._nextPolicy.sendRequest(request)];});});};return BrowserPolicy;}(BaseRequestPolicy));var BrowserPolicyFactory=(function(){function BrowserPolicyFactory(){}
BrowserPolicyFactory.prototype.create=function(nextPolicy,options){return new BrowserPolicy(nextPolicy,options);};return BrowserPolicyFactory;}());var packageName="azure-storage-blob";var packageVersion="1.0.0";var StorageClientContext=(function(_super){__extends(StorageClientContext,_super);function StorageClientContext(url,options){var _this=this;if(url===null||url===undefined){throw new Error('\'url\' cannot be null.');}
if(!options){options={};}
if(!options.userAgent){var defaultUserAgent=getDefaultUserAgentValue();options.userAgent=packageName+"/"+packageVersion+" "+defaultUserAgent;}
_this=_super.call(this,undefined,options)||this;_this.version='2018-03-28';_this.baseUri="{url}";_this.requestContentType="application/json; charset=utf-8";_this.url=url;return _this;}
return StorageClientContext;}(ServiceClient));var DEFAULT_REQUEST_LOG_OPTIONS={logWarningIfTryOverThreshold:3000};var LoggingPolicy=(function(_super){__extends(LoggingPolicy,_super);function LoggingPolicy(nextPolicy,options,loggingOptions){if(loggingOptions===void 0){loggingOptions=DEFAULT_REQUEST_LOG_OPTIONS;}
var _this=_super.call(this,nextPolicy,options)||this;_this.tryCount=0;_this.operationStartTime=new Date();_this.requestStartTime=new Date();_this.loggingOptions=loggingOptions;return _this;}
LoggingPolicy.prototype.sendRequest=function(request){return __awaiter(this,void 0,void 0,function(){var safeURL,response,requestEndTime,requestCompletionTime,operationDuration,currentLevel,logMessage,errorString,messageInfo,err_1;return __generator(this,function(_a){switch(_a.label){case 0:this.tryCount++;this.requestStartTime=new Date();if(this.tryCount===1){this.operationStartTime=this.requestStartTime;}
safeURL=request.url;if(getURLParameter(safeURL,URLConstants.Parameters.SIGNATURE)){safeURL=setURLParameter(safeURL,URLConstants.Parameters.SIGNATURE,"*****");}
this.log(exports.HttpPipelineLogLevel.INFO,"'"+safeURL+"'==> OUTGOING REQUEST (Try number="+this.tryCount+").");_a.label=1;case 1:_a.trys.push([1,3,,4]);return[4,this._nextPolicy.sendRequest(request)];case 2:response=_a.sent();requestEndTime=new Date();requestCompletionTime=requestEndTime.getTime()-this.requestStartTime.getTime();operationDuration=requestEndTime.getTime()-this.operationStartTime.getTime();currentLevel=exports.HttpPipelineLogLevel.INFO;logMessage="";if(this.shouldLog(exports.HttpPipelineLogLevel.INFO)){logMessage="Successfully Received Response. ";}
if(requestCompletionTime>=this.loggingOptions.logWarningIfTryOverThreshold){if(this.shouldLog(exports.HttpPipelineLogLevel.WARNING)){currentLevel=exports.HttpPipelineLogLevel.WARNING;logMessage="SLOW OPERATION. Duration > "+this.loggingOptions.logWarningIfTryOverThreshold+" ms. ";}}
if((response.status>=400&&response.status<=499&&(response.status!==HTTPURLConnection.HTTP_NOT_FOUND&&response.status!==HTTPURLConnection.HTTP_CONFLICT&&response.status!==HTTPURLConnection.HTTP_PRECON_FAILED&&response.status!==HTTPURLConnection.HTTP_RANGE_NOT_SATISFIABLE))||(response.status>=500&&response.status<=509)){errorString="REQUEST ERROR: HTTP request failed with status code: "+response.status+". ";logMessage=errorString;currentLevel=exports.HttpPipelineLogLevel.ERROR;}
messageInfo="Request try:"+this.tryCount+", status:"+response.status+" request duration:"+requestCompletionTime+" ms, operation duration:"+operationDuration+" ms\n";this.log(currentLevel,logMessage+messageInfo);return[2,response];case 3:err_1=_a.sent();this.log(exports.HttpPipelineLogLevel.ERROR,"Unexpected failure attempting to make request. Error message: "+err_1.message);throw err_1;case 4:return[2];}});});};return LoggingPolicy;}(BaseRequestPolicy));var LoggingPolicyFactory=(function(){function LoggingPolicyFactory(loggingOptions){this.loggingOptions=loggingOptions;}
LoggingPolicyFactory.prototype.create=function(nextPolicy,options){return new LoggingPolicy(nextPolicy,options,this.loggingOptions);};return LoggingPolicyFactory;}());var Pipeline=(function(){function Pipeline(factories,options){if(options===void 0){options={};}
this.factories=factories;this.options=options;}
Pipeline.prototype.toServiceClientOptions=function(){return{httpClient:this.options.HTTPClient,httpPipelineLogger:this.options.logger,requestPolicyFactories:this.factories};};return Pipeline;}());var RetryPolicyType;(function(RetryPolicyType){RetryPolicyType[RetryPolicyType["EXPONENTIAL"]=0]="EXPONENTIAL";RetryPolicyType[RetryPolicyType["FIXED"]=1]="FIXED";})(RetryPolicyType||(RetryPolicyType={}));var DEFAULT_RETRY_OPTIONS={maxRetryDelayInMs:120*1000,maxTries:4,retryDelayInMs:4*1000,retryPolicyType:RetryPolicyType.EXPONENTIAL,secondaryHost:"",tryTimeoutInMs:undefined};var RetryPolicy=(function(_super){__extends(RetryPolicy,_super);function RetryPolicy(nextPolicy,options,retryOptions){if(retryOptions===void 0){retryOptions=DEFAULT_RETRY_OPTIONS;}
var _this=_super.call(this,nextPolicy,options)||this;_this.retryOptions={retryPolicyType:retryOptions.retryPolicyType?retryOptions.retryPolicyType:DEFAULT_RETRY_OPTIONS.retryPolicyType,maxTries:retryOptions.maxTries&&retryOptions.maxTries>=1?Math.floor(retryOptions.maxTries):DEFAULT_RETRY_OPTIONS.maxTries,tryTimeoutInMs:retryOptions.tryTimeoutInMs&&retryOptions.tryTimeoutInMs>=0?retryOptions.tryTimeoutInMs:DEFAULT_RETRY_OPTIONS.tryTimeoutInMs,retryDelayInMs:retryOptions.retryDelayInMs&&retryOptions.retryDelayInMs>=0?Math.min(retryOptions.retryDelayInMs,retryOptions.maxRetryDelayInMs?retryOptions.maxRetryDelayInMs:DEFAULT_RETRY_OPTIONS.maxRetryDelayInMs):DEFAULT_RETRY_OPTIONS.retryDelayInMs,maxRetryDelayInMs:retryOptions.maxRetryDelayInMs&&retryOptions.maxRetryDelayInMs>=0?retryOptions.maxRetryDelayInMs:DEFAULT_RETRY_OPTIONS.maxRetryDelayInMs,secondaryHost:retryOptions.secondaryHost?retryOptions.secondaryHost:DEFAULT_RETRY_OPTIONS.secondaryHost};return _this;}
RetryPolicy.prototype.sendRequest=function(request){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.attemptSendRequest(request,false,1)];});});};RetryPolicy.prototype.attemptSendRequest=function(request,secondaryHas404,attempt){return __awaiter(this,void 0,void 0,function(){var newRequest,isPrimaryRetry,response,err_1;return __generator(this,function(_a){switch(_a.label){case 0:newRequest=request.clone();isPrimaryRetry=secondaryHas404||!this.retryOptions.secondaryHost||!(request.method==="GET"||request.method==="HEAD"||request.method==="OPTIONS")||attempt%2===1;if(!isPrimaryRetry){newRequest.url=setURLHost(newRequest.url,this.retryOptions.secondaryHost);}
if(this.retryOptions.tryTimeoutInMs){newRequest.url=setURLParameter(newRequest.url,URLConstants.Parameters.TIMEOUT,Math.floor(this.retryOptions.tryTimeoutInMs/1000).toString());}
_a.label=1;case 1:_a.trys.push([1,3,,4]);this.logf(exports.HttpPipelineLogLevel.INFO,"RetryPolicy: =====> Try="+attempt+" "+(isPrimaryRetry?"Primary":"Secondary"));return[4,this._nextPolicy.sendRequest(newRequest)];case 2:response=_a.sent();if(!this.shouldRetry(isPrimaryRetry,attempt,response)){return[2,response];}
secondaryHas404=secondaryHas404||(!isPrimaryRetry&&response.status===404);return[3,4];case 3:err_1=_a.sent();this.logf(exports.HttpPipelineLogLevel.ERROR,"RetryPolicy: Caught error, message: "+err_1.message+", code: "+err_1.code);if(!this.shouldRetry(isPrimaryRetry,attempt,response,err_1)){throw err_1;}
return[3,4];case 4:return[4,this.delay(isPrimaryRetry,attempt)];case 5:_a.sent();return[4,this.attemptSendRequest(request,secondaryHas404,++attempt)];case 6:return[2,_a.sent()];}});});};RetryPolicy.prototype.shouldRetry=function(isPrimaryRetry,attempt,response,err){if(attempt>=this.retryOptions.maxTries){this.logf(exports.HttpPipelineLogLevel.INFO,"RetryPolicy: Attempt(s) "+attempt+" >= maxTries "+this.retryOptions.maxTries+", no further try.");return false;}
var retriableErrors=["ETIMEDOUT","ESOCKETTIMEDOUT","ECONNREFUSED","ECONNRESET","ENOENT","ENOTFOUND","TIMEOUT","REQUEST_SEND_ERROR"];if(err){for(var _i=0,retriableErrors_1=retriableErrors;_i<retriableErrors_1.length;_i++){var retriableError=retriableErrors_1[_i];if(err.name.toUpperCase().includes(retriableError)||err.message.toUpperCase().includes(retriableError)||(err.code&&err.code.toUpperCase().includes(retriableError))){this.logf(exports.HttpPipelineLogLevel.INFO,"RetryPolicy: Network error "+retriableError+" found, will retry.");return true;}}}
if(response||err){var statusCode=response?response.status:err?err.statusCode:0;if(!isPrimaryRetry&&statusCode===404){this.logf(exports.HttpPipelineLogLevel.INFO,"RetryPolicy: Secondary access with 404, will retry.");return true;}
if(statusCode===503||statusCode===500){this.logf(exports.HttpPipelineLogLevel.INFO,"RetryPolicy: Will retry for status code "+statusCode+".");return true;}}
return false;};RetryPolicy.prototype.logf=function(_level,_message){};RetryPolicy.prototype.delay=function(isPrimaryRetry,attempt){return __awaiter(this,void 0,void 0,function(){var delayTimeInMs;return __generator(this,function(_a){delayTimeInMs=0;if(isPrimaryRetry){switch(this.retryOptions.retryPolicyType){case RetryPolicyType.EXPONENTIAL:delayTimeInMs=Math.min((Math.pow(2,attempt-1)-1)*this.retryOptions.retryDelayInMs,this.retryOptions.maxRetryDelayInMs);break;case RetryPolicyType.FIXED:delayTimeInMs=this.retryOptions.retryDelayInMs;break;}}
else{delayTimeInMs=Math.random()*1000;}
this.logf(exports.HttpPipelineLogLevel.INFO,"RetryPolicy: Delay for "+delayTimeInMs+"ms");return[2,delay$1(delayTimeInMs)];});});};return RetryPolicy;}(BaseRequestPolicy));var RetryPolicyFactory=(function(){function RetryPolicyFactory(retryOptions){this.retryOptions=retryOptions;}
RetryPolicyFactory.prototype.create=function(nextPolicy,options){return new RetryPolicy(nextPolicy,options,this.retryOptions);};return RetryPolicyFactory;}());var TelemetryPolicy=(function(_super){__extends(TelemetryPolicy,_super);function TelemetryPolicy(nextPolicy,options,telemetry){var _this=_super.call(this,nextPolicy,options)||this;_this.telemetry=telemetry;return _this;}
TelemetryPolicy.prototype.sendRequest=function(request){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this._nextPolicy.sendRequest(request)];});});};return TelemetryPolicy;}(BaseRequestPolicy));var TelemetryPolicyFactory=(function(){function TelemetryPolicyFactory(telemetry){var userAgentInfo=[];this.telemetryString=userAgentInfo.join(" ");}
TelemetryPolicyFactory.prototype.create=function(nextPolicy,options){return new TelemetryPolicy(nextPolicy,options,this.telemetryString);};return TelemetryPolicyFactory;}());var UniqueRequestIDPolicy=(function(_super){__extends(UniqueRequestIDPolicy,_super);function UniqueRequestIDPolicy(nextPolicy,options){return _super.call(this,nextPolicy,options)||this;}
UniqueRequestIDPolicy.prototype.sendRequest=function(request){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){if(!request.headers.contains(HeaderConstants$2.X_MS_CLIENT_REQUEST_ID)){request.headers.set(HeaderConstants$2.X_MS_CLIENT_REQUEST_ID,generateUuid());}
return[2,this._nextPolicy.sendRequest(request)];});});};return UniqueRequestIDPolicy;}(BaseRequestPolicy));var UniqueRequestIDPolicyFactory=(function(){function UniqueRequestIDPolicyFactory(){}
UniqueRequestIDPolicyFactory.prototype.create=function(nextPolicy,options){return new UniqueRequestIDPolicy(nextPolicy,options);};return UniqueRequestIDPolicyFactory;}());var StorageURL=(function(){function StorageURL(url,pipeline){this.url=escapeURLPath(url);this.pipeline=pipeline;this.storageClientContext=new StorageClientContext(this.url,pipeline.toServiceClientOptions());var storageClientContext=this.storageClientContext;storageClientContext.requestContentType=undefined;}
StorageURL.newPipeline=function(credential,pipelineOptions){if(pipelineOptions===void 0){pipelineOptions={};}
var factories=[new TelemetryPolicyFactory(pipelineOptions.telemetry),new UniqueRequestIDPolicyFactory(),new BrowserPolicyFactory(),deserializationPolicy(),new RetryPolicyFactory(pipelineOptions.retryOptions),new LoggingPolicyFactory(),credential];return new Pipeline(factories,{HTTPClient:pipelineOptions.httpClient,logger:pipelineOptions.logger});};return StorageURL;}());var BlobURL=(function(_super){__extends(BlobURL,_super);function BlobURL(url,pipeline){var _this=_super.call(this,url,pipeline)||this;_this.blobContext=new Blob$1(_this.storageClientContext);return _this;}
BlobURL.fromContainerURL=function(containerURL,blobName){return new BlobURL(appendToURLPath(containerURL.url,encodeURIComponent(blobName)),containerURL.pipeline);};BlobURL.prototype.withPipeline=function(pipeline){return new BlobURL(this.url,pipeline);};BlobURL.prototype.withSnapshot=function(snapshot){return new BlobURL(setURLParameter(this.url,URLConstants.Parameters.SNAPSHOT,snapshot.length===0?undefined:snapshot),this.pipeline);};BlobURL.prototype.download=function(aborter,offset,count,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){var res;var _this=this;return __generator(this,function(_a){switch(_a.label){case 0:options.blobAccessConditions=options.blobAccessConditions||{};options.blobAccessConditions.modifiedAccessConditions=options.blobAccessConditions.modifiedAccessConditions||{};return[4,this.blobContext.download({abortSignal:aborter,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions,onDownloadProgress:isNode?undefined:options.progress,range:offset===0&&!count?undefined:rangeToString({offset:offset,count:count}),rangeGetContentMD5:options.rangeGetContentMD5,snapshot:options.snapshot})];case 1:res=_a.sent();if(!isNode){return[2,res];}
if(options.maxRetryRequests===undefined||options.maxRetryRequests<0){options.maxRetryRequests=DEFAULT_MAX_DOWNLOAD_RETRY_REQUESTS;}
if(res.contentLength===undefined){throw new RangeError("File download response doesn't contain valid content length header");}
if(!res.eTag){throw new RangeError("File download response doesn't contain valid etag header");}
return[2,new BlobDownloadResponse(aborter,res,function(start){return __awaiter(_this,void 0,void 0,function(){var updatedOptions;return __generator(this,function(_a){switch(_a.label){case 0:updatedOptions={leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:{ifMatch:options.blobAccessConditions.modifiedAccessConditions.ifMatch||res.eTag,ifModifiedSince:options.blobAccessConditions.modifiedAccessConditions.ifModifiedSince,ifNoneMatch:options.blobAccessConditions.modifiedAccessConditions.ifNoneMatch,ifUnmodifiedSince:options.blobAccessConditions.modifiedAccessConditions.ifUnmodifiedSince},range:rangeToString({count:offset+res.contentLength-start,offset:start}),snapshot:options.snapshot};return[4,this.blobContext.download(__assign({abortSignal:aborter},updatedOptions))];case 1:return[2,(_a.sent()).readableStreamBody];}});});},offset,res.contentLength,{maxRetryRequests:options.maxRetryRequests,progress:options.progress})];}});});};BlobURL.prototype.getProperties=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.blobAccessConditions=options.blobAccessConditions||{};return[2,this.blobContext.getProperties({abortSignal:aborter,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions})];});});};BlobURL.prototype.delete=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.blobAccessConditions=options.blobAccessConditions||{};return[2,this.blobContext.deleteMethod({abortSignal:aborter,deleteSnapshots:options.deleteSnapshots,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions})];});});};BlobURL.prototype.undelete=function(aborter){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.undelete({abortSignal:aborter})];});});};BlobURL.prototype.setHTTPHeaders=function(aborter,blobHTTPHeaders,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.blobAccessConditions=options.blobAccessConditions||{};return[2,this.blobContext.setHTTPHeaders({abortSignal:aborter,blobHTTPHeaders:blobHTTPHeaders,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions})];});});};BlobURL.prototype.setMetadata=function(aborter,metadata,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.blobAccessConditions=options.blobAccessConditions||{};return[2,this.blobContext.setMetadata({abortSignal:aborter,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,metadata:metadata,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions})];});});};BlobURL.prototype.acquireLease=function(aborter,proposedLeaseId,duration,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.acquireLease({abortSignal:aborter,duration:duration,modifiedAccessConditions:options.modifiedAccessConditions,proposedLeaseId:proposedLeaseId})];});});};BlobURL.prototype.releaseLease=function(aborter,leaseId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.releaseLease(leaseId,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};BlobURL.prototype.renewLease=function(aborter,leaseId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.renewLease(leaseId,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};BlobURL.prototype.changeLease=function(aborter,leaseId,proposedLeaseId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.changeLease(leaseId,proposedLeaseId,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};BlobURL.prototype.breakLease=function(aborter,breakPeriod,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.breakLease({abortSignal:aborter,breakPeriod:breakPeriod,modifiedAccessConditions:options.modifiedAccessConditions})];});});};BlobURL.prototype.createSnapshot=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.blobAccessConditions=options.blobAccessConditions||{};return[2,this.blobContext.createSnapshot({abortSignal:aborter,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,metadata:options.metadata,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions})];});});};BlobURL.prototype.startCopyFromURL=function(aborter,copySource,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.blobAccessConditions=options.blobAccessConditions||{};options.sourceModifiedAccessConditions=options.sourceModifiedAccessConditions||{};return[2,this.blobContext.startCopyFromURL(copySource,{abortSignal:aborter,leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions,metadata:options.metadata,modifiedAccessConditions:options.blobAccessConditions.modifiedAccessConditions,sourceModifiedAccessConditions:{sourceIfMatch:options.sourceModifiedAccessConditions.ifMatch,sourceIfModifiedSince:options.sourceModifiedAccessConditions.ifModifiedSince,sourceIfNoneMatch:options.sourceModifiedAccessConditions.ifNoneMatch,sourceIfUnmodifiedSince:options.sourceModifiedAccessConditions.ifUnmodifiedSince}})];});});};BlobURL.prototype.abortCopyFromURL=function(aborter,copyId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blobContext.abortCopyFromURL(copyId,{abortSignal:aborter,leaseAccessConditions:options.leaseAccessConditions})];});});};BlobURL.prototype.setTier=function(aborter,tier,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){switch(_a.label){case 0:return[4,this.blobContext.setTier(tier,{abortSignal:aborter,leaseAccessConditions:options.leaseAccessConditions})];case 1:return[2,_a.sent()];}});});};return BlobURL;}(StorageURL));var AppendBlobURL=(function(_super){__extends(AppendBlobURL,_super);function AppendBlobURL(url,pipeline){var _this=_super.call(this,url,pipeline)||this;_this.appendBlobContext=new AppendBlob(_this.storageClientContext);return _this;}
AppendBlobURL.fromContainerURL=function(containerURL,blobName){return new AppendBlobURL(appendToURLPath(containerURL.url,encodeURIComponent(blobName)),containerURL.pipeline);};AppendBlobURL.fromBlobURL=function(blobURL){return new AppendBlobURL(blobURL.url,blobURL.pipeline);};AppendBlobURL.prototype.withPipeline=function(pipeline){return new AppendBlobURL(this.url,pipeline);};AppendBlobURL.prototype.withSnapshot=function(snapshot){return new AppendBlobURL(setURLParameter(this.url,URLConstants.Parameters.SNAPSHOT,snapshot.length===0?undefined:snapshot),this.pipeline);};AppendBlobURL.prototype.create=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.appendBlobContext.create(0,{abortSignal:aborter,blobHTTPHeaders:options.blobHTTPHeaders,leaseAccessConditions:options.accessConditions.leaseAccessConditions,metadata:options.metadata,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions})];});});};AppendBlobURL.prototype.appendBlock=function(aborter,body,contentLength,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.appendBlobContext.appendBlock(body,contentLength,{abortSignal:aborter,appendPositionAccessConditions:options.accessConditions.appendPositionAccessConditions,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions,onUploadProgress:options.progress,transactionalContentMD5:options.transactionalContentMD5})];});});};return AppendBlobURL;}(BlobURL));var BlockBlobURL=(function(_super){__extends(BlockBlobURL,_super);function BlockBlobURL(url,pipeline){var _this=_super.call(this,url,pipeline)||this;_this.blockBlobContext=new BlockBlob(_this.storageClientContext);return _this;}
BlockBlobURL.fromContainerURL=function(containerURL,blobName){return new BlockBlobURL(appendToURLPath(containerURL.url,encodeURIComponent(blobName)),containerURL.pipeline);};BlockBlobURL.fromBlobURL=function(blobURL){return new BlockBlobURL(blobURL.url,blobURL.pipeline);};BlockBlobURL.prototype.withPipeline=function(pipeline){return new BlockBlobURL(this.url,pipeline);};BlockBlobURL.prototype.withSnapshot=function(snapshot){return new BlockBlobURL(setURLParameter(this.url,URLConstants.Parameters.SNAPSHOT,snapshot.length===0?undefined:snapshot),this.pipeline);};BlockBlobURL.prototype.upload=function(aborter,body,contentLength,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.blockBlobContext.upload(body,contentLength,{abortSignal:aborter,blobHTTPHeaders:options.blobHTTPHeaders,leaseAccessConditions:options.accessConditions.leaseAccessConditions,metadata:options.metadata,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions,onUploadProgress:options.progress})];});});};BlockBlobURL.prototype.stageBlock=function(aborter,blockId,body,contentLength,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blockBlobContext.stageBlock(blockId,contentLength,body,{abortSignal:aborter,leaseAccessConditions:options.leaseAccessConditions,onUploadProgress:options.progress,transactionalContentMD5:options.transactionalContentMD5})];});});};BlockBlobURL.prototype.stageBlockFromURL=function(aborter,blockId,sourceURL,offset,count,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.blockBlobContext.stageBlockFromURL(blockId,0,sourceURL,{abortSignal:aborter,leaseAccessConditions:options.leaseAccessConditions,sourceContentMD5:options.sourceContentMD5,sourceRange:offset===0&&!count?undefined:rangeToString({offset:offset,count:count})})];});});};BlockBlobURL.prototype.commitBlockList=function(aborter,blocks,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.blockBlobContext.commitBlockList({latest:blocks},{abortSignal:aborter,blobHTTPHeaders:options.blobHTTPHeaders,leaseAccessConditions:options.accessConditions.leaseAccessConditions,metadata:options.metadata,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions})];});});};BlockBlobURL.prototype.getBlockList=function(aborter,listType,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){var res;return __generator(this,function(_a){switch(_a.label){case 0:return[4,this.blockBlobContext.getBlockList(listType,{abortSignal:aborter,leaseAccessConditions:options.leaseAccessConditions})];case 1:res=_a.sent();if(!res.committedBlocks){res.committedBlocks=[];}
if(!res.uncommittedBlocks){res.uncommittedBlocks=[];}
return[2,res];}});});};return BlockBlobURL;}(BlobURL));var ContainerURL=(function(_super){__extends(ContainerURL,_super);function ContainerURL(url,pipeline){var _this=_super.call(this,url,pipeline)||this;_this.containerContext=new Container(_this.storageClientContext);return _this;}
ContainerURL.fromServiceURL=function(serviceURL,containerName){return new ContainerURL(appendToURLPath(serviceURL.url,encodeURIComponent(containerName)),serviceURL.pipeline);};ContainerURL.prototype.withPipeline=function(pipeline){return new ContainerURL(this.url,pipeline);};ContainerURL.prototype.create=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.create(__assign({},options,{abortSignal:aborter}))];});});};ContainerURL.prototype.getProperties=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){if(!options.leaseAccessConditions){options.leaseAccessConditions={};}
return[2,this.containerContext.getProperties(__assign({abortSignal:aborter},options.leaseAccessConditions))];});});};ContainerURL.prototype.delete=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){if(!options.containerAccessConditions){options.containerAccessConditions={};}
if(!options.containerAccessConditions.modifiedAccessConditions){options.containerAccessConditions.modifiedAccessConditions={};}
if(!options.containerAccessConditions.leaseAccessConditions){options.containerAccessConditions.leaseAccessConditions={};}
if((options.containerAccessConditions.modifiedAccessConditions.ifMatch&&options.containerAccessConditions.modifiedAccessConditions.ifMatch!==ETagNone)||(options.containerAccessConditions.modifiedAccessConditions.ifNoneMatch&&options.containerAccessConditions.modifiedAccessConditions.ifNoneMatch!==ETagNone)){throw new RangeError("the IfMatch and IfNoneMatch access conditions must have their default\
        values because they are ignored by the service");}
return[2,this.containerContext.deleteMethod({abortSignal:aborter,leaseAccessConditions:options.containerAccessConditions.leaseAccessConditions,modifiedAccessConditions:options.containerAccessConditions.modifiedAccessConditions})];});});};ContainerURL.prototype.setMetadata=function(aborter,metadata,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){if(!options.containerAccessConditions){options.containerAccessConditions={};}
if(!options.containerAccessConditions.modifiedAccessConditions){options.containerAccessConditions.modifiedAccessConditions={};}
if(!options.containerAccessConditions.leaseAccessConditions){options.containerAccessConditions.leaseAccessConditions={};}
if(options.containerAccessConditions.modifiedAccessConditions.ifUnmodifiedSince||(options.containerAccessConditions.modifiedAccessConditions.ifMatch&&options.containerAccessConditions.modifiedAccessConditions.ifMatch!==ETagNone)||(options.containerAccessConditions.modifiedAccessConditions.ifNoneMatch&&options.containerAccessConditions.modifiedAccessConditions.ifNoneMatch!==ETagNone)){throw new RangeError("the IfUnmodifiedSince, IfMatch, and IfNoneMatch must have their default values\
        because they are ignored by the blob service");}
return[2,this.containerContext.setMetadata({abortSignal:aborter,leaseAccessConditions:options.containerAccessConditions.leaseAccessConditions,metadata:metadata,modifiedAccessConditions:options.containerAccessConditions.modifiedAccessConditions})];});});};ContainerURL.prototype.getAccessPolicy=function(aborter,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){var response,res,_i,response_1,identifier;return __generator(this,function(_a){switch(_a.label){case 0:if(!options.leaseAccessConditions){options.leaseAccessConditions={};}
return[4,this.containerContext.getAccessPolicy({abortSignal:aborter,leaseAccessConditions:options.leaseAccessConditions})];case 1:response=_a.sent();res={_response:response._response,blobPublicAccess:response.blobPublicAccess,date:response.date,eTag:response.eTag,errorCode:response.errorCode,lastModified:response.lastModified,requestId:response.requestId,signedIdentifiers:[],version:response.version};for(_i=0,response_1=response;_i<response_1.length;_i++){identifier=response_1[_i];res.signedIdentifiers.push({accessPolicy:{expiry:new Date(identifier.accessPolicy.expiry),permission:identifier.accessPolicy.permission,start:new Date(identifier.accessPolicy.start)},id:identifier.id});}
return[2,res];}});});};ContainerURL.prototype.setAccessPolicy=function(aborter,access,containerAcl,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){var acl,_i,_a,identifier;return __generator(this,function(_b){options.containerAccessConditions=options.containerAccessConditions||{};acl=[];for(_i=0,_a=containerAcl||[];_i<_a.length;_i++){identifier=_a[_i];acl.push({accessPolicy:{expiry:truncatedISO8061Date(identifier.accessPolicy.expiry),permission:identifier.accessPolicy.permission,start:truncatedISO8061Date(identifier.accessPolicy.start)},id:identifier.id});}
return[2,this.containerContext.setAccessPolicy({abortSignal:aborter,access:access,containerAcl:acl,leaseAccessConditions:options.containerAccessConditions.leaseAccessConditions,modifiedAccessConditions:options.containerAccessConditions.modifiedAccessConditions})];});});};ContainerURL.prototype.acquireLease=function(aborter,proposedLeaseId,duration,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.acquireLease({abortSignal:aborter,duration:duration,modifiedAccessConditions:options.modifiedAccessConditions,proposedLeaseId:proposedLeaseId})];});});};ContainerURL.prototype.releaseLease=function(aborter,leaseId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.releaseLease(leaseId,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};ContainerURL.prototype.renewLease=function(aborter,leaseId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.renewLease(leaseId,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};ContainerURL.prototype.breakLease=function(aborter,period,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.breakLease({abortSignal:aborter,breakPeriod:period,modifiedAccessConditions:options.modifiedAccessConditions})];});});};ContainerURL.prototype.changeLease=function(aborter,leaseId,proposedLeaseId,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.changeLease(leaseId,proposedLeaseId,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};ContainerURL.prototype.listBlobFlatSegment=function(aborter,marker,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.listBlobFlatSegment(__assign({abortSignal:aborter,marker:marker},options))];});});};ContainerURL.prototype.listBlobHierarchySegment=function(aborter,delimiter,marker,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.containerContext.listBlobHierarchySegment(delimiter,__assign({abortSignal:aborter,marker:marker},options))];});});};return ContainerURL;}(StorageURL));var CredentialPolicy=(function(_super){__extends(CredentialPolicy,_super);function CredentialPolicy(){return _super!==null&&_super.apply(this,arguments)||this;}
CredentialPolicy.prototype.sendRequest=function(request){return this._nextPolicy.sendRequest(this.signRequest(request));};CredentialPolicy.prototype.signRequest=function(request){return request;};return CredentialPolicy;}(BaseRequestPolicy));var AnonymousCredentialPolicy=(function(_super){__extends(AnonymousCredentialPolicy,_super);function AnonymousCredentialPolicy(nextPolicy,options){return _super.call(this,nextPolicy,options)||this;}
return AnonymousCredentialPolicy;}(CredentialPolicy));var Credential=(function(){function Credential(){}
Credential.prototype.create=function(_nextPolicy,_options){throw new Error("Method should be implemented in children classes.");};return Credential;}());var AnonymousCredential=(function(_super){__extends(AnonymousCredential,_super);function AnonymousCredential(){return _super!==null&&_super.apply(this,arguments)||this;}
AnonymousCredential.prototype.create=function(nextPolicy,options){return new AnonymousCredentialPolicy(nextPolicy,options);};return AnonymousCredential;}(Credential));var TokenCredentialPolicy=(function(_super){__extends(TokenCredentialPolicy,_super);function TokenCredentialPolicy(nextPolicy,options,tokenCredential){var _this=_super.call(this,nextPolicy,options)||this;_this.tokenCredential=tokenCredential;_this.authorizationScheme=HeaderConstants$2.AUTHORIZATION_SCHEME;return _this;}
TokenCredentialPolicy.prototype.signRequest=function(request){if(!request.headers){request.headers=new HttpHeaders();}
request.headers.set(HeaderConstants$2.AUTHORIZATION,this.authorizationScheme+" "+this.tokenCredential.token);return request;};return TokenCredentialPolicy;}(CredentialPolicy));var TokenCredential=(function(_super){__extends(TokenCredential,_super);function TokenCredential(token){var _this=_super.call(this)||this;_this.token=token;return _this;}
TokenCredential.prototype.create=function(nextPolicy,options){return new TokenCredentialPolicy(nextPolicy,options,this);};return TokenCredential;}(Credential));var R=typeof Reflect==='object'?Reflect:null;var ReflectApply=R&&typeof R.apply==='function'?R.apply:function ReflectApply(target,receiver,args){return Function.prototype.apply.call(target,receiver,args);};var ReflectOwnKeys;if(R&&typeof R.ownKeys==='function'){ReflectOwnKeys=R.ownKeys;}else if(Object.getOwnPropertySymbols){ReflectOwnKeys=function ReflectOwnKeys(target){return Object.getOwnPropertyNames(target).concat(Object.getOwnPropertySymbols(target));};}else{ReflectOwnKeys=function ReflectOwnKeys(target){return Object.getOwnPropertyNames(target);};}
function ProcessEmitWarning(warning){if(console&&console.warn)console.warn(warning);}
var NumberIsNaN=Number.isNaN||function NumberIsNaN(value){return value!==value;};function EventEmitter(){EventEmitter.init.call(this);}
var events=EventEmitter;EventEmitter.EventEmitter=EventEmitter;EventEmitter.prototype._events=undefined;EventEmitter.prototype._eventsCount=0;EventEmitter.prototype._maxListeners=undefined;var defaultMaxListeners=10;Object.defineProperty(EventEmitter,'defaultMaxListeners',{enumerable:true,get:function(){return defaultMaxListeners;},set:function(arg){if(typeof arg!=='number'||arg<0||NumberIsNaN(arg)){throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received '+arg+'.');}
defaultMaxListeners=arg;}});EventEmitter.init=function(){if(this._events===undefined||this._events===Object.getPrototypeOf(this)._events){this._events=Object.create(null);this._eventsCount=0;}
this._maxListeners=this._maxListeners||undefined;};EventEmitter.prototype.setMaxListeners=function setMaxListeners(n){if(typeof n!=='number'||n<0||NumberIsNaN(n)){throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received '+n+'.');}
this._maxListeners=n;return this;};function $getMaxListeners(that){if(that._maxListeners===undefined)
return EventEmitter.defaultMaxListeners;return that._maxListeners;}
EventEmitter.prototype.getMaxListeners=function getMaxListeners(){return $getMaxListeners(this);};EventEmitter.prototype.emit=function emit(type){var args=[];for(var i=1;i<arguments.length;i++)args.push(arguments[i]);var doError=(type==='error');var events=this._events;if(events!==undefined)
doError=(doError&&events.error===undefined);else if(!doError)
return false;if(doError){var er;if(args.length>0)
er=args[0];if(er instanceof Error){throw er;}
var err=new Error('Unhandled error.'+(er?' ('+er.message+')':''));err.context=er;throw err;}
var handler=events[type];if(handler===undefined)
return false;if(typeof handler==='function'){ReflectApply(handler,this,args);}else{var len=handler.length;var listeners=arrayClone(handler,len);for(var i=0;i<len;++i)
ReflectApply(listeners[i],this,args);}
return true;};function _addListener(target,type,listener,prepend){var m;var events;var existing;if(typeof listener!=='function'){throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof listener);}
events=target._events;if(events===undefined){events=target._events=Object.create(null);target._eventsCount=0;}else{if(events.newListener!==undefined){target.emit('newListener',type,listener.listener?listener.listener:listener);events=target._events;}
existing=events[type];}
if(existing===undefined){existing=events[type]=listener;++target._eventsCount;}else{if(typeof existing==='function'){existing=events[type]=prepend?[listener,existing]:[existing,listener];}else if(prepend){existing.unshift(listener);}else{existing.push(listener);}
m=$getMaxListeners(target);if(m>0&&existing.length>m&&!existing.warned){existing.warned=true;var w=new Error('Possible EventEmitter memory leak detected. '+existing.length+' '+String(type)+' listeners '+'added. Use emitter.setMaxListeners() to '+'increase limit');w.name='MaxListenersExceededWarning';w.emitter=target;w.type=type;w.count=existing.length;ProcessEmitWarning(w);}}
return target;}
EventEmitter.prototype.addListener=function addListener(type,listener){return _addListener(this,type,listener,false);};EventEmitter.prototype.on=EventEmitter.prototype.addListener;EventEmitter.prototype.prependListener=function prependListener(type,listener){return _addListener(this,type,listener,true);};function onceWrapper(){var args=[];for(var i=0;i<arguments.length;i++)args.push(arguments[i]);if(!this.fired){this.target.removeListener(this.type,this.wrapFn);this.fired=true;ReflectApply(this.listener,this.target,args);}}
function _onceWrap(target,type,listener){var state={fired:false,wrapFn:undefined,target:target,type:type,listener:listener};var wrapped=onceWrapper.bind(state);wrapped.listener=listener;state.wrapFn=wrapped;return wrapped;}
EventEmitter.prototype.once=function once(type,listener){if(typeof listener!=='function'){throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof listener);}
this.on(type,_onceWrap(this,type,listener));return this;};EventEmitter.prototype.prependOnceListener=function prependOnceListener(type,listener){if(typeof listener!=='function'){throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof listener);}
this.prependListener(type,_onceWrap(this,type,listener));return this;};EventEmitter.prototype.removeListener=function removeListener(type,listener){var list,events,position,i,originalListener;if(typeof listener!=='function'){throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof listener);}
events=this._events;if(events===undefined)
return this;list=events[type];if(list===undefined)
return this;if(list===listener||list.listener===listener){if(--this._eventsCount===0)
this._events=Object.create(null);else{delete events[type];if(events.removeListener)
this.emit('removeListener',type,list.listener||listener);}}else if(typeof list!=='function'){position=-1;for(i=list.length-1;i>=0;i--){if(list[i]===listener||list[i].listener===listener){originalListener=list[i].listener;position=i;break;}}
if(position<0)
return this;if(position===0)
list.shift();else{spliceOne(list,position);}
if(list.length===1)
events[type]=list[0];if(events.removeListener!==undefined)
this.emit('removeListener',type,originalListener||listener);}
return this;};EventEmitter.prototype.off=EventEmitter.prototype.removeListener;EventEmitter.prototype.removeAllListeners=function removeAllListeners(type){var listeners,events,i;events=this._events;if(events===undefined)
return this;if(events.removeListener===undefined){if(arguments.length===0){this._events=Object.create(null);this._eventsCount=0;}else if(events[type]!==undefined){if(--this._eventsCount===0)
this._events=Object.create(null);else
delete events[type];}
return this;}
if(arguments.length===0){var keys=Object.keys(events);var key;for(i=0;i<keys.length;++i){key=keys[i];if(key==='removeListener')continue;this.removeAllListeners(key);}
this.removeAllListeners('removeListener');this._events=Object.create(null);this._eventsCount=0;return this;}
listeners=events[type];if(typeof listeners==='function'){this.removeListener(type,listeners);}else if(listeners!==undefined){for(i=listeners.length-1;i>=0;i--){this.removeListener(type,listeners[i]);}}
return this;};function _listeners(target,type,unwrap){var events=target._events;if(events===undefined)
return[];var evlistener=events[type];if(evlistener===undefined)
return[];if(typeof evlistener==='function')
return unwrap?[evlistener.listener||evlistener]:[evlistener];return unwrap?unwrapListeners(evlistener):arrayClone(evlistener,evlistener.length);}
EventEmitter.prototype.listeners=function listeners(type){return _listeners(this,type,true);};EventEmitter.prototype.rawListeners=function rawListeners(type){return _listeners(this,type,false);};EventEmitter.listenerCount=function(emitter,type){if(typeof emitter.listenerCount==='function'){return emitter.listenerCount(type);}else{return listenerCount.call(emitter,type);}};EventEmitter.prototype.listenerCount=listenerCount;function listenerCount(type){var events=this._events;if(events!==undefined){var evlistener=events[type];if(typeof evlistener==='function'){return 1;}else if(evlistener!==undefined){return evlistener.length;}}
return 0;}
EventEmitter.prototype.eventNames=function eventNames(){return this._eventsCount>0?ReflectOwnKeys(this._events):[];};function arrayClone(arr,n){var copy=new Array(n);for(var i=0;i<n;++i)
copy[i]=arr[i];return copy;}
function spliceOne(list,index){for(;index+1<list.length;index++)
list[index]=list[index+1];list.pop();}
function unwrapListeners(arr){var ret=new Array(arr.length);for(var i=0;i<ret.length;++i){ret[i]=arr[i].listener||arr[i];}
return ret;}
var events_1=events.EventEmitter;var BatchStates;(function(BatchStates){BatchStates[BatchStates["Good"]=0]="Good";BatchStates[BatchStates["Error"]=1]="Error";})(BatchStates||(BatchStates={}));var Batch=(function(){function Batch(concurrency){if(concurrency===void 0){concurrency=5;}
this.actives=0;this.completed=0;this.offset=0;this.operations=[];this.state=BatchStates.Good;if(concurrency<1){throw new RangeError("concurrency must be larger than 0");}
this.concurrency=concurrency;this.emitter=new events_1();}
Batch.prototype.addOperation=function(operation){var _this=this;this.operations.push(function(){return __awaiter(_this,void 0,void 0,function(){var error_1;return __generator(this,function(_a){switch(_a.label){case 0:_a.trys.push([0,2,,3]);this.actives++;return[4,operation()];case 1:_a.sent();this.actives--;this.completed++;this.parallelExecute();return[3,3];case 2:error_1=_a.sent();this.emitter.emit("error",error_1);return[3,3];case 3:return[2];}});});});};Batch.prototype.do=function(){return __awaiter(this,void 0,void 0,function(){var _this=this;return __generator(this,function(_a){this.parallelExecute();return[2,new Promise(function(resolve,reject){_this.emitter.on("finish",resolve);_this.emitter.on("error",function(error){_this.state=BatchStates.Error;reject(error);});})];});});};Batch.prototype.nextOperation=function(){if(this.offset<this.operations.length){return this.operations[this.offset++];}
return null;};Batch.prototype.parallelExecute=function(){if(this.state===BatchStates.Error){return;}
if(this.completed>=this.operations.length){this.emitter.emit("finish");return;}
while(this.actives<this.concurrency){var operation=this.nextOperation();if(operation){operation();}
else{return;}}};return Batch;}());function uploadBrowserDataToBlockBlob(aborter,browserData,blockBlobURL,options){return __awaiter(this,void 0,void 0,function(){var browserBlob;return __generator(this,function(_a){browserBlob=new Blob([browserData]);return[2,UploadSeekableBlobToBlockBlob(aborter,function(offset,size){return browserBlob.slice(offset,offset+size);},browserBlob.size,blockBlobURL,options)];});});}
function UploadSeekableBlobToBlockBlob(aborter,blobFactory,size,blockBlobURL,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){var numBlocks,blockList,blockIDPrefix,transferProgress,batch,_loop_1,i;var _this=this;return __generator(this,function(_a){switch(_a.label){case 0:if(!options.blockSize){options.blockSize=0;}
if(options.blockSize<0||options.blockSize>BLOCK_BLOB_MAX_STAGE_BLOCK_BYTES){throw new RangeError("blockSize option must be >= 0 and <= "+BLOCK_BLOB_MAX_STAGE_BLOCK_BYTES);}
if(options.maxSingleShotSize!==0&&!options.maxSingleShotSize){options.maxSingleShotSize=BLOCK_BLOB_MAX_UPLOAD_BLOB_BYTES;}
if(options.maxSingleShotSize<0||options.maxSingleShotSize>BLOCK_BLOB_MAX_UPLOAD_BLOB_BYTES){throw new RangeError("maxSingleShotSize option must be >= 0 and <= "+BLOCK_BLOB_MAX_UPLOAD_BLOB_BYTES);}
if(options.blockSize===0){if(size>BLOCK_BLOB_MAX_STAGE_BLOCK_BYTES*BLOCK_BLOB_MAX_BLOCKS){throw new RangeError(size+" is too larger to upload to a block blob.");}
if(size>options.maxSingleShotSize){options.blockSize=Math.ceil(size/BLOCK_BLOB_MAX_BLOCKS);if(options.blockSize<DEFAULT_BLOB_DOWNLOAD_BLOCK_BYTES){options.blockSize=DEFAULT_BLOB_DOWNLOAD_BLOCK_BYTES;}}}
if(!options.blobHTTPHeaders){options.blobHTTPHeaders={};}
if(!options.blobAccessConditions){options.blobAccessConditions={};}
if(size<=options.maxSingleShotSize){return[2,blockBlobURL.upload(aborter,blobFactory(0,size),size,options)];}
numBlocks=Math.floor((size-1)/options.blockSize)+1;if(numBlocks>BLOCK_BLOB_MAX_BLOCKS){throw new RangeError("The buffer's size is too big or the BlockSize is too small;"+("the number of blocks must be <= "+BLOCK_BLOB_MAX_BLOCKS));}
blockList=[];blockIDPrefix=generateUuid();transferProgress=0;batch=new Batch(options.parallelism);_loop_1=function(i){batch.addOperation(function(){return __awaiter(_this,void 0,void 0,function(){var blockID,start,end,contentLength;return __generator(this,function(_a){switch(_a.label){case 0:blockID=generateBlockID(blockIDPrefix,i);start=options.blockSize*i;end=i===numBlocks-1?size:start+options.blockSize;contentLength=end-start;blockList.push(blockID);return[4,blockBlobURL.stageBlock(aborter,blockID,blobFactory(start,contentLength),contentLength,{leaseAccessConditions:options.blobAccessConditions.leaseAccessConditions})];case 1:_a.sent();transferProgress+=contentLength;if(options.progress){options.progress({loadedBytes:transferProgress});}
return[2];}});});});};for(i=0;i<numBlocks;i++){_loop_1(i);}
return[4,batch.do()];case 1:_a.sent();return[2,blockBlobURL.commitBlockList(aborter,blockList,options)];}});});}
var PageBlobURL=(function(_super){__extends(PageBlobURL,_super);function PageBlobURL(url,pipeline){var _this=_super.call(this,url,pipeline)||this;_this.pageBlobContext=new PageBlob(_this.storageClientContext);return _this;}
PageBlobURL.fromContainerURL=function(containerURL,blobName){return new PageBlobURL(appendToURLPath(containerURL.url,encodeURIComponent(blobName)),containerURL.pipeline);};PageBlobURL.fromBlobURL=function(blobURL){return new PageBlobURL(blobURL.url,blobURL.pipeline);};PageBlobURL.prototype.withPipeline=function(pipeline){return new PageBlobURL(this.url,pipeline);};PageBlobURL.prototype.withSnapshot=function(snapshot){return new PageBlobURL(setURLParameter(this.url,URLConstants.Parameters.SNAPSHOT,snapshot.length===0?undefined:snapshot),this.pipeline);};PageBlobURL.prototype.create=function(aborter,size,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.create(0,size,{abortSignal:aborter,blobHTTPHeaders:options.blobHTTPHeaders,blobSequenceNumber:options.blobSequenceNumber,leaseAccessConditions:options.accessConditions.leaseAccessConditions,metadata:options.metadata,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions})];});});};PageBlobURL.prototype.uploadPages=function(aborter,body,offset,count,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.uploadPages(body,count,{abortSignal:aborter,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions,onUploadProgress:options.progress,range:rangeToString({offset:offset,count:count}),sequenceNumberAccessConditions:options.accessConditions.sequenceNumberAccessConditions,transactionalContentMD5:options.transactionalContentMD5})];});});};PageBlobURL.prototype.clearPages=function(aborter,offset,count,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.clearPages(0,{abortSignal:aborter,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions,range:rangeToString({offset:offset,count:count}),sequenceNumberAccessConditions:options.accessConditions.sequenceNumberAccessConditions})];});});};PageBlobURL.prototype.getPageRanges=function(aborter,offset,count,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.getPageRanges({abortSignal:aborter,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions,range:rangeToString({offset:offset,count:count})})];});});};PageBlobURL.prototype.getPageRangesDiff=function(aborter,offset,count,prevSnapshot,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.getPageRangesDiff({abortSignal:aborter,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions,prevsnapshot:prevSnapshot,range:rangeToString({offset:offset,count:count})})];});});};PageBlobURL.prototype.resize=function(aborter,size,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.resize(size,{abortSignal:aborter,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions})];});});};PageBlobURL.prototype.updateSequenceNumber=function(aborter,sequenceNumberAction,sequenceNumber,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){options.accessConditions=options.accessConditions||{};return[2,this.pageBlobContext.updateSequenceNumber(sequenceNumberAction,{abortSignal:aborter,blobSequenceNumber:sequenceNumber,leaseAccessConditions:options.accessConditions.leaseAccessConditions,modifiedAccessConditions:options.accessConditions.modifiedAccessConditions})];});});};PageBlobURL.prototype.startCopyIncremental=function(aborter,copySource,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.pageBlobContext.copyIncremental(copySource,{abortSignal:aborter,modifiedAccessConditions:options.modifiedAccessConditions})];});});};return PageBlobURL;}(BlobURL));var ServiceURL=(function(_super){__extends(ServiceURL,_super);function ServiceURL(url,pipeline){var _this=_super.call(this,url,pipeline)||this;_this.serviceContext=new Service(_this.storageClientContext);return _this;}
ServiceURL.prototype.withPipeline=function(pipeline){return new ServiceURL(this.url,pipeline);};ServiceURL.prototype.getProperties=function(aborter){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.serviceContext.getProperties({abortSignal:aborter})];});});};ServiceURL.prototype.setProperties=function(aborter,properties){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.serviceContext.setProperties(properties,{abortSignal:aborter})];});});};ServiceURL.prototype.getStatistics=function(aborter){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.serviceContext.getStatistics({abortSignal:aborter})];});});};ServiceURL.prototype.getAccountInfo=function(aborter){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.serviceContext.getAccountInfo({abortSignal:aborter})];});});};ServiceURL.prototype.listContainersSegment=function(aborter,marker,options){if(options===void 0){options={};}
return __awaiter(this,void 0,void 0,function(){return __generator(this,function(_a){return[2,this.serviceContext.listContainersSegment(__assign({abortSignal:aborter,marker:marker},options))];});});};return ServiceURL;}(StorageURL));exports.Models=index;exports.RestError=RestError;exports.Aborter=Aborter;exports.AppendBlobURL=AppendBlobURL;exports.BlobURL=BlobURL;exports.BlockBlobURL=BlockBlobURL;exports.BrowserPolicyFactory=BrowserPolicyFactory;exports.ContainerURL=ContainerURL;exports.AnonymousCredential=AnonymousCredential;exports.Credential=Credential;exports.TokenCredential=TokenCredential;exports.uploadBrowserDataToBlockBlob=uploadBrowserDataToBlockBlob;exports.PageBlobURL=PageBlobURL;exports.HttpHeaders=HttpHeaders;exports.WebResource=WebResource;exports.BaseRequestPolicy=BaseRequestPolicy;exports.RequestPolicyOptions=RequestPolicyOptions;exports.Pipeline=Pipeline;exports.AnonymousCredentialPolicy=AnonymousCredentialPolicy;exports.CredentialPolicy=CredentialPolicy;exports.RetryPolicyFactory=RetryPolicyFactory;exports.LoggingPolicyFactory=LoggingPolicyFactory;exports.TelemetryPolicyFactory=TelemetryPolicyFactory;exports.TokenCredentialPolicy=TokenCredentialPolicy;exports.UniqueRequestIDPolicyFactory=UniqueRequestIDPolicyFactory;exports.ServiceURL=ServiceURL;exports.deserializationPolicy=deserializationPolicy;exports.StorageURL=StorageURL;Object.defineProperty(exports,'__esModule',{value:true});})));